<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
$genderList = $this->customlib->getGender();
?>  
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title titlefix"> <?php echo $this->lang->line('diagnosis_billing'); ?></h3>
                         <div class="box-tools pull-right">
                           <button type="button" class="btn btn-primary btn-sm assigntest" id="load1" data-loading-text="<i class='fa fa-circle-o-notch fa-spin'></i>
                           <?php echo $this->lang->line('please_wait'); ?>"><i class="fa fa-plus"></i> <?php echo $this->lang->line('add_patient'); ?></button>
                            
                           
                        </div>
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <div class="download_label"><?php echo $this->lang->line('diagnosis_reports'); ?></div>
                <div class="table-responsive">        
                    <table class="table table-striped table-bordered table-hover ajaxlist" id="diagnosis" cellspacing="0" width="100%"
                           data-export-title="<?php echo $this->lang->line('diagnosis_reports'); ?>">
                            <thead class="white-space-nowrap">
                            <tr>
                                <th><?php echo $this->lang->line('bill_no'); ?></th>
                                <th><?php echo $this->lang->line('case_id'); ?></th>
                                <th><?php echo $this->lang->line('reporting_date'); ?></th> 
                                <th><?php echo $this->lang->line('patient_name'); ?></th>
                                <th><?php echo $this->lang->line('reference_doctor'); ?></th>
                                <th><?php echo $this->lang->line('note'); ?></th>
                                <?php 
                                if (!empty($fields)) {
                                        foreach ($fields as $fields_key => $fields_value) {
                                            ?>
                                            <th><?php echo $fields_value->name; ?></th>
                                             <?php
                                        } 
                                    }
                                ?> 
                                <th class="" ><?php echo $this->lang->line('amount') . ' (' . $currency_symbol . ')'; ?></th>
                                <th class="" ><?php echo $this->lang->line('paid_amount'). ' (' . $currency_symbol . ')'; ?></th>
                                <th class="text-right" ><?php echo $this->lang->line('balance_amount'). ' (' . $currency_symbol . ')'; ?></th>
                            </tr>
                            </thead>
                            <tbody>
                               
                            </tbody>
                         </table>
                       </div>  
                    </div>
                </div>                                                    
            </div>
        </div>  
    </section>
</div>



<div class="modal fade" id="assigntestModal" aria-hidden="true" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog pup100" role="document">
        <div class="modal-content modal-media-content">
            <form id="bill" accept-charset="utf-8" method="post">
            <div class="modal-header modal-media-header">
                 <button type="button" class="close pupclose" data-dismiss="modal">&times;</button>
                <div class="row">
                    <div class="col-lg-5 col-md-5 col-sm-5 col-xs-9">
                        <div class="p-2 select2-full-width">
                            <select name="patientid" class="form-control patient_list_ajax" id="addpatient_id" required>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-3 col-xs-1">
                        <div class="p-2">        
                        <?php if ($this->rbac->hasPrivilege('patient', 'can_add')) {?>
                            <a data-toggle="modal" id="add" onclick="holdModal('myModalpa')" class="modalbtnpatient"><i class="fa fa-plus"></i>  <span><?php echo $this->lang->line('new_patient'); ?></span></a>
                        <?php }?>
                       </div>
                    </div>   
                    <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
                        <div class="p-2">
                            <div class="input-group">
                                <input type="text" class="form-control border-0" id="prescription_no" placeholder="<?php echo $this->lang->line('prescription_no'); ?>" name="prescription_no">
                                <div class="input-group-btn">
                                    <button class="btn btn-default btn-group-custom" type="button" id="search_prescription"><i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>    
             
                </div><!--./d-flex-->
            </div><!--./modal-header-->
                <div class="pup-scroll-area">
                    <div class="tabinsetbottom pt5">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-lg-2 col-md-3 col-sm-4">
                                    <label><?php echo $this->lang->line('bill_no'); ?><input readonly name="bill_no" id="billno" type="text" class="transparentbg-border"/>
                                    <span class="text-danger"><?php echo form_error('bill_no'); ?></span></label>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-4">
                                    <label><?php echo $this->lang->line('case_id'); ?>
                                        <input readonly name="case_reference_id" id="case_reference_id" type="text" class="transparentbg-border"/>
                                        <span class="text-danger"><?php echo form_error('case_reference_id'); ?></span>
                                    </label>
                                </div>
                                <div class="col-lg-7 col-md-5 col-sm-4 text-right text-md-left">
                                     <label><?php echo $this->lang->line('date'); ?>
                         <input name="date" type="text"  id="txtDate10"  class="transparentbg-border"/>
                                     </label>
                                </div>
                            </div>
                        </div>
                    </div>            
                    <div class="modal-body pb0">
                        
                    </div><!--./row-->
                </div>
                <div class="modal-footer sticky-footer">
                    <div class="pull-right">
                        
                        <p id="demo"></p>

                     <button type="button" onclick="addTotal()" class="btn btn-info" autocomplete="off"><i class="fa fa-calculator"></i> <?php echo $this->lang->line('calculate'); ?></button>&nbsp;

                        <!--<button type="submit" name="save" data-loading-text="<?php /*echo $this->lang->line('processing'); */?>" style="display: none" id="billsave" class="btn btn-info pull-right"><i class="fa fa-check-circle"></i> <?php /*echo $this->lang->line('save'); */?></button>-->
                        <button type="submit" name="save_print" style="display: none; margin-right:2px;" data-loading-text="<?php echo $this->lang->line('processing'); ?>" class="btn btn-info pull-right printsavebtn"><i class="fa fa-print"></i> <?php echo $this->lang->line('save_print'); ?>
                        </button>
                    </div>

                </div>
            </form>

        </div><!--./modal-body-->

    </div>
</div>

<div class="modal fade" id="viewDetailReportModal"  role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog pup100" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-toggle="tooltip" title="<?php echo $this->lang->line('close'); ?>" data-dismiss="modal">&times;</button>
                <div class="modalicon"> 
                    <div id='action_detail_report_modal'>

                   </div>
                </div>
                <h4 class="modal-title"><?php echo $this->lang->line('bill_details'); ?></h4> 
            </div>
            <div class="modal-body pt0 pb0">
                <div id="reportbilldata"></div>
            </div>
        </div>
    </div>    
</div>

<div class="modal fade" id="collectionModal"  role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content modal-media-content">
        <form action="" method="POST" id="form-sample-collected">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-toggle="tooltip" title="<?php echo $this->lang->line('close'); ?>" data-dismiss="modal">&times;</button>
                <div class="modalicon"> 
                    <div id='collection_modal_header'>

                   </div>
                </div>
                <h4 class="modal-title"><?php echo $this->lang->line('sample_collection'); ?></h4> 
            </div>
        <div class="modal-body">
          <input type="hidden" name="radiology_report_id" value="0">  
          <input type="hidden" name="radiology_bill_id" value="0">  
          <div class="form-group">
                <label><?php echo $this->lang->line('sample_collected_person_name'); ?></label><small class="req"> *</small>
                <select class="form-control" name="collected_by" id="collected_by">
                     <option value=""><?php echo $this->lang->line('select') ?></option>
                            <?php foreach ($radiologist as $dkey => $dvalue) {
                                                            ?>
                            <option value="<?php echo $dvalue["id"]; ?>" <?php
                                    if ((isset($radiologist_select)) && ($radiologist_select == $dvalue["id"])) {
                                        echo "selected";
                                     }
                                ?>><?php echo $dvalue["name"] . " " . $dvalue["surname"]." (".$dvalue["employee_id"].")" ?>
                            </option>   
                        <?php } ?>
                </select>
          
            </div>
              <div class="form-group">
                <label><?php echo $this->lang->line('collected_date'); ?></label><small class="req"> *</small>
                <input type="text" class="form-control" name="collected_date" id="collected_date">
              </div>
               <div class="form-group">
                <label><?php echo $this->lang->line('radiology_center'); ?></label><small class="req"> *</small>
                <input type="text" class="form-control" name="radiology_center" id="radiology_center">
              </div>
              </div>
            <div class="modal-footer">
              <button type="submit"  data-loading-text="<?php echo $this->lang->line('processing'); ?>" class="btn btn-info pull-right" ><i class="fa fa-check-circle"></i> <?php echo $this->lang->line('save'); ?></button>
      </div>
      </form>
        </div>
    </div>    
</div>
    
<div class="modal fade" id="addReportModal"  role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
              <form action="" method="POST" id="form-report_param">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-toggle="tooltip" title="<?php echo $this->lang->line('close'); ?>" data-dismiss="modal">&times;</button>
                <div class="modalicon"> 
                    <div id='collection_modal_header'>

                   </div>
                </div>
                <h4 class="modal-title"><?php echo $this->lang->line('add_edit_report'); ?></h4> 
            </div>
            <div class="scroll-area">
                <div class="modal-body">
         
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit"  data-loading-text="<?php echo $this->lang->line('processing'); ?>" class="btn btn-info pull-right" ><i class="fa fa-check-circle"></i> <?php echo $this->lang->line('save'); ?></button>
      </div>
      </form>
        </div>
    </div>    
</div>

<div class="modal fade" id="addPaymentModal" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog pup100" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-toggle="tooltip" title="<?php echo $this->lang->line('close'); ?>" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('payments'); ?></h4>
            </div>
            <div class="scroll-area">
                <div class="modal-body pb0 min-h-3">

                </div>
            </div>
        </div>
    </div>
</div>



<?php include('scripts/staticScript.php');?>
<?php include('scripts/scripts.php');?>