<script id="testradio-template" type="text/template">
    <?php
    foreach ($radiology as $dkey => $testlist_value) {
        ?>
        <option value='<?php echo $testlist_value["id"]; ?>'>
            <?php echo $testlist_value["test_name"]." (".$testlist_value["short_name"].") - ".$testlist_value["standard_charge"]; ?>
        </option>
        <?php
    }
    ?>

</script>

<script id="testpatho-template" type="text/template">
    <?php
    foreach ($pathology as $dkey => $testlist_value) {
        ?>
        <option value='<?php echo $testlist_value["id"]; ?>'>
            <?php echo $testlist_value["test_name"]." (".$testlist_value["short_name"].") - ".$testlist_value["standard_charge"]; ?>
        </option>
        <?php
    }
    ?>
</script>

<script type="text/javascript">

    $(function () {
        //Initialize Select2 Elements
        $('.select2').select2();
    });
    var  total_rows = 5;
    var date_format_new = '<?php echo $result = strtr($this->customlib->getHospitalDateFormat(), ['d' => 'dd', 'm' => 'mm', 'Y' => 'yyyy']) ?>';
    var datetime_format = '<?php echo $result = strtr($this->customlib->getHospitalDateFormat(true, true), ['d' => 'DD', 'm' => 'MM', 'Y' => 'YYYY', 'H' => 'hh', 'i' => 'mm']) ?>';

    $(document).ready(function(){

        $('input[name="collected_date"]').datepicker({
            format: date_format_new,
            autoclose: true,
            todayHighlight: true
        });
    });

    function holdModal(modalId) {
        $('#' + modalId).modal({
            backdrop: 'static',
            keyboard: false,
            show: true
        });
    }

    $(document).on('click','.assigntest',function(){
        var createModal=$('#assigntestModal');
        var $this = $(this);
        $this.button('loading');
        $.ajax({
            url: '<?php echo base_url(); ?>admin/diagnosis/assigntest',
            type: "POST",
            dataType: 'json',
            beforeSend: function() {
                $this.button('loading');
                createModal.addClass('modal_loading');
            },
            success: function(res) {
                $('#assigntestModal #billno').val(res.bill_no);
                $('#assigntestModal .modal-body').html(res.page);

                $('#assigntestModal .filestyle').dropify();
                $(".radio_test_name").select2();
                updateDate();
                $('#assigntestModal').modal('show');
                createModal.removeClass('modal_loading');
            },
            error: function(xhr) { // if error occured
                alert("<?php echo $this->lang->line('error_occurred_please_try_again'); ?>");
                $this.button('reset');
                createModal.removeClass('modal_loading');
            },
            complete: function() {
                $this.button('reset');
                createModal.removeClass('modal_loading');
            }
        });
    });

    $(document).on('click','.edit_radiology',function(){
        var createModal=$('#assigntestModal');
        var $this = $(this);
        var recordId=$this.data('recordId');
        $this.button('loading');
        $.ajax({
            url: base_url+'admin/bill/editradiology',
            type: "POST",
            data: {'id':recordId},
            dataType: 'json',
            beforeSend: function() {
                $this.button('loading');
                createModal.addClass('modal_loading');
            },
            success: function(res) {
                total_rows =res.total_rows;
                $('#assigntestModal #billno').val(res.bill_no);
                $('#case_reference_id').val(res.case_reference_id);
                // $("#addpatient_id").select2("val", res.patient_id);
                var option = new Option(res.patient_name, res.patient_id, true, true);
                $("#bill .patient_list_ajax").append(option).trigger('change');

                $('#assigntestModal .modal-body').html(res.page);
                $('#assigntestModal .filestyle').dropify();
                $('#txtDate10').data("DateTimePicker").date(new Date(res.radiology_date));
                updateDate();
                $('#viewDetailReportModal').modal('hide');
                $('#assigntestModal').modal('show');
                // $('.select2').select2();
                createModal.removeClass('modal_loading');
            },
            error: function(xhr) { // if error occured
                alert("<?php echo $this->lang->line('error_occurred_please_try_again') ?>");
                $this.button('reset');
                createModal.removeClass('modal_loading');
            },
            complete: function() {
                $this.button('reset');
                createModal.removeClass('modal_loading');
            }
        });
    });


    $(document).on('click','.delete_radiology',function(){

        if (confirm('<?php echo $this->lang->line("delete_confirm") ?>')) {
            var $this = $(this);
            var recordId=$this.data('recordId');
            $this.button('loading');
            $.ajax({
                url: base_url+'admin/radio/deleteRadiologyBill',
                type: "POST",
                data: {'id':recordId},
                dataType: 'json',
                beforeSend: function() {
                    $this.button('loading');

                },
                success: function(res) {
                    if (res.status == "fail") {

                        errorMsg(res.message);
                    } else {
                        successMsg(res.message);
                        $('#viewDetailReportModal').modal('hide');
                        //table.ajax.reload();
                    }

                    $this.button('reset');
                },
                error: function(xhr) { // if error occured
                    alert("<?php echo $this->lang->line('error_occurred_please_try_again'); ?>");
                    $this.button('reset');
                    createModal.removeClass('modal_loading');
                },
                complete: function() {
                    $this.button('reset');

                }
            });
        }
    });

</script>