<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
$genderList = $this->customlib->getGender();
?>
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title titlefix"> <?php echo $this->lang->line('ipd_discharged_patient'); ?></h3>

                        <div class="box-tools pull-right">

                        </div>    
                    </div><!-- /.box-header -->

                    <div class="box-body pb0">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <form id="form1" action="" method="post" class="">
                                        <div class="box-body row">
							                <?php echo $this->customlib->getCSRF(); ?>
                                            <div class="col-sm-6 col-md-3" >
                                                <div class="form-group">
                                                    <label><?php echo $this->lang->line('search_type'); ?></label><small class="req"> *</small>
                                                    <select class="form-control" name="search_type"  id="search_type_select" onchange="showdate(this.value)">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
										                <?php
										                foreach ($searchlist as $key => $search) { ?>
                                                            <option value="<?php echo $key ?>" <?php
											                if ((isset($search_type)) && ($search_type == $key)) {
												                echo "selected";
											                }
											                ?>><?php echo $search ?></option>
										                <?php }?>
                                                    </select>
                                                    <span class="text-danger" id="error_search_type"><?php echo form_error('search_type'); ?></span>
                                                </div>
                                            </div>


                                            <div class="col-sm-6 col-md-3" id="fromdate" style="display: none">
                                                <div class="form-group">
                                                    <label><?php echo $this->lang->line('date_from'); ?></label><small class="req"> *</small>
                                                    <input id="date_from" name="date_from" placeholder="" type="text" class="form-control date" value="<?php echo set_value('date_from', date($this->customlib->getHospitalDateFormat())); ?>"  />
                                                    <span class="text-danger"><?php echo form_error('date_from'); ?></span>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-3" id="todate" style="display: none">
                                                <div class="form-group">
                                                    <label><?php echo $this->lang->line('date_to'); ?></label><small class="req"> *</small>
                                                    <input id="date_to" name="date_to" placeholder="" type="text" class="form-control date" value="<?php echo set_value('date_to', date($this->customlib->getHospitalDateFormat())); ?>"  />
                                                    <span class="text-danger"><?php echo form_error('date_to'); ?></span>
                                                </div>
                                            </div>


                                            <div class="form-group">
                                                <div class="col-sm-12">
                                                    <button type="submit" name="search" value="search_filter" class="btn btn-primary btn-sm pull-right"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                        <div class="box-body">
                            <div class="download_label"> <?php echo $this->lang->line('ipd_discharged_patient'); ?></div>

                            <table class="table table-striped table-bordered table-hover ajaxlist" cellspacing="0" width="100%" data-export-title="<?php echo $this->lang->line('ipd_discharged_patient'); ?>">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('name') ?></th>
                                        <th><?php echo $this->lang->line('patient_id'); ?></th>
                                        <th><?php echo $this->lang->line('case_id'); ?></th>
                                        <th><?php echo $this->lang->line('gender'); ?></th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <th><?php echo $this->lang->line('consultant') ?></th>
                                        <th><?php echo $this->lang->line('admission_date'); ?></th>
                                        <th><?php echo $this->lang->line('discharged_date'); ?></th>
                                        <th class="text-right" ><?php echo $this->lang->line('tax') . " (" . $currency_symbol . ")" ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('net_amount') . " (" . $currency_symbol . ")" ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('total') . " (" . $currency_symbol . ")" ?></th>
                                      
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    
                </div>  
            </div>
        </div> 
    </section>
</div>

<script type="text/javascript">


    function showdate(value) {

        if (value == 'period') {
            $('#fromdate').show();
            $('#todate').show();
        } else {
            $('#fromdate').hide();
            $('#todate').hide();
        }
    }
</script>
<script type="text/javascript">
    $(function () {
        //Initialize Select2 Elements
        $('.select2').select2()
    });
    $(function () {
        $('#easySelectable').easySelectable();
    })
</script>


<script type="text/javascript">
            (function ($) {
                //selectable html elements
                $.fn.easySelectable = function (options) {
                    var el = $(this);
                    var options = $.extend({
                        'item': 'li',
                        'state': true,
                        onSelecting: function (el) {

                        },
                        onSelected: function (el) {

                        },
                        onUnSelected: function (el) {

                        }
                    }, options);
                    el.on('dragstart', function (event) {
                        event.preventDefault();
                    });
                    el.off('mouseover');
                    el.addClass('easySelectable');
                    if (options.state) {
                        el.find(options.item).addClass('es-selectable');
                        el.on('mousedown', options.item, function (e) {
                            $(this).trigger('start_select');
                            var offset = $(this).offset();
                            var hasClass = $(this).hasClass('es-selected');
                            var prev_el = false;
                            el.on('mouseover', options.item, function (e) {
                                if (prev_el == $(this).index())
                                    return true;
                                prev_el = $(this).index();
                                var hasClass2 = $(this).hasClass('es-selected');
                                if (!hasClass2) {
                                    $(this).addClass('es-selected').trigger('selected');
                                    el.trigger('selected');
                                    options.onSelecting($(this));
                                    options.onSelected($(this));
                                } else {
                                    $(this).removeClass('es-selected').trigger('unselected');
                                    el.trigger('unselected');
                                    options.onSelecting($(this))
                                    options.onUnSelected($(this));
                                }
                            });
                            if (!hasClass) {
                                $(this).addClass('es-selected').trigger('selected');
                                el.trigger('selected');
                                options.onSelecting($(this));
                                options.onSelected($(this));
                            } else {
                                $(this).removeClass('es-selected').trigger('unselected');
                                el.trigger('unselected');
                                options.onSelecting($(this));
                                options.onUnSelected($(this));
                            }
                            var relativeX = (e.pageX - offset.left);
                            var relativeY = (e.pageY - offset.top);
                        });
                        $(document).on('mouseup', function () {
                            el.off('mouseover');
                        });
                    } else {
                        el.off('mousedown');
                    }
                };
            })(jQuery);

</script>
<script type="text/javascript">
( function ( $ ) {
    'use strict';
   /* $(document).ready(function () {
    initDatatable('ajaxlist', 'admin/patient/getdischargeddatatable/',{},[],100,
    [{"bSortable": false,"sWidth": "60px", "aTargets": [ -1,-2,-3 ] ,'sClass': 'dt-body-left'}]
    );
    });*/
} ( jQuery ) )
</script>

<script>
    ( function ( $ ) {
        'use strict';
        $(document).ready(function () {
            emptyDatatable('ajaxlist', 'data');
            $('#form1').on('submit', (function (e) {
                    e.preventDefault();
                    var search= 'search_filter';
                    var formData = new FormData(this);
                    formData.append('search', 'search_filter');
                    $.ajax({
                        url: '<?php echo base_url(); ?>admin/patient/checkValidationSearch',
                        type: "POST",
                        data: formData,
                        dataType: 'json',
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function (data) {
                            if (data.status == "fail") {
                                $.each(data.error, function(key, value) {
                                    $('#error_' + key).html(value);
                                });
                            } else {
                                $("#error_search_type").html('');

                               /* initDatatable('ajaxlist','admin/diagnosis/getpathologybillDatatable',data.param,[],100,
                                    [
                                        { "bSortable": false, "sWidth": "105px", "aTargets": [ -1 ] ,'sClass': 'dt-body-right'},
                                        {  "sWidth": "105px", "aTargets": [ -2,-3 ] ,'sClass': 'dt-body-right'},
                                        { "aTargets": [ 1 ] ,'sClass': 'dt-body-center'}
                                    ]
                                );*/

                                initDatatable('ajaxlist', 'admin/patient/getdischargeddatatable/',data.param,[],100,
                                    [{"bSortable": false,"sWidth": "60px", "aTargets": [ -1,-2,-3 ] ,'sClass': 'dt-body-left'}]
                                );

                            }
                        }
                    });
                }
            ));
        });

    } ( jQuery ) );

</script>