<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
?>
<input type="hidden" name="radiology_bill_id" value="<?php echo $result->radiology_bill_id ?>">
<input type="hidden" name="radiology_center" value="<?php echo $result->radiology_center ?>">
<input type="hidden" name="collected_date"
       value="<?php echo $this->customlib->YYYYMMDDTodateFormat($result->collection_date); ?>">
<input type="hidden" name="collected_by"
       value="<?php echo composeStaffNameByString($result->collection_specialist_staff_name, $result->collection_specialist_staff_surname, $result->collection_specialist_staff_employee_id); ?>">
<input type="hidden" name="collected_id" value="<?php echo $result->collection_specialist; ?>">
<div class="row">
    <div class="col-md-12">
        <div class="table-responsive">
            <table class="table table-hover table-sm">
                <tr>
                    <td><label><?php echo $this->lang->line('test_name'); ?></label></td>
                    <td><?php echo $result->short_name; ?></td>
                    <td><label><?php echo $this->lang->line('expected_date'); ?></label></td>
                    <td><?php echo $this->customlib->YYYYMMDDTodateFormat($result->reporting_date); ?></td>
                </tr>
                <tr>
                    <td><label><?php echo $this->lang->line('approve_date'); ?></label></td>
                    <td><?php if ($result->parameter_update != '') {
                            echo $this->customlib->YYYYMMDDTodateFormat($result->parameter_update);
                        } ?></td>
                    <td><label><?php echo $this->lang->line('date_of_collection'); ?></label></td>
                    <td><?php echo $this->customlib->YYYYMMDDTodateFormat($result->collection_date); ?></td>
                </tr>
                <tr>
                    <td><label><?php echo $this->lang->line('collection_by'); ?></label></td>
                    <td> <?php echo composeStaffNameByString($result->collection_specialist_staff_name, $result->collection_specialist_staff_surname, $result->collection_specialist_staff_employee_id); ?></td>
                    <td><label><?php echo $this->lang->line('radiology_center'); ?></label></td>
                    <td><?php echo $result->radiology_center ?></td>
                </tr>
            </table>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="approved_by"><?php echo $this->lang->line('approved_by'); ?></label><small class="req">
                        *</small>
                    <select class="form-control select2" name="approved_by" id="approved_by">
                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                        <?php
                        foreach ($staff as $staff_key => $staff_value) { ?>
                            <option value="<?php echo $staff_value['id'] ?>" <?php echo set_select('approved_by', $staff_value['id'], (set_value('approved_by', $result->approved_by) == $staff_value['id']) ? TRUE : FALSE); ?>><?php echo composeStaffNameByString($staff_value['name'], $staff_value['surname'], $staff_value['employee_id']); ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="approved_by"><?php echo $this->lang->line('approve_date'); ?><small class="req">
                            *</small></label>
                    <input class="form-control date" value="<?php if ($result->parameter_update != '') {
                        echo $this->customlib->YYYYMMDDTodateFormat($result->parameter_update);
                    } else {
                        echo $this->customlib->YYYYMMDDTodateFormat(date('Y-m-d'));
                    } ?>" name="approve_date" type="text" id="approve_date">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="approved_by"><?php echo $this->lang->line('upload_report'); ?></label>
                    <input class="filestyle form-control" type='file' name='attachment_report' id="attachment_report"
                           size='20'/>
                    <?php
                    if ($result->radiology_report != "") {
                        ?>
                        <a href="<?php echo site_url('admin/radio/downloadReport/' . $result->id) ?>"><i
                                    class="fa fa-download"></i> <?php echo $result->report_name; ?></a>
                        <?php
                    }
                    ?>

                </div>
            </div>
        </div>
        <!-- //============= -->
        <div class="table-responsive">
            <input type="hidden" name="radiology_report_id" value="<?php echo $result->id; ?>">
            <table id="tableID" class="table table-hover table-sm">

                <thead>
                <tr class="line">
                    <td style="width: 5%"><strong>#</strong></td>
                    <td class="text-left" style="width: 40%">
                        <strong><?php echo $this->lang->line('test_parameter_name'); ?><small class="req"> *</small>
                        </strong></td>
                    <td class="text-lrft" style="width: 20%">
                        <strong><?php echo $this->lang->line('report_value'); ?></strong></td>
                    <td class="text-right" style="width: 20%">
                        <strong><?php echo $this->lang->line('reference_range'); ?> </strong></td>
                    <td class="text-right" style="width: 20%">
                        <strong><?php echo $this->lang->line('action'); ?> </strong></td>
                </tr>
                </thead>
                <tbody>
                <?php
                $row_counter = 1;
                foreach ($result->radiology_parameter as $parameter_key => $parameter_value) {
                    //var_dump($parameter_value);
                    //exit();
                    ?>
                    <input type="hidden" name="radiology_parameterdetails[]"
                           value="<?php echo $parameter_value->id; ?>">
                    <input type="hidden" name="radiology_reference_range_<?php echo $parameter_value->id; ?>"
                           value="<?php echo $parameter_value->reference_range; ?>">
                    <tr>
                        <td><?php echo $row_counter; ?></td>
                        <td>
                            <strong><?php echo $parameter_value->parameter_name ?></strong><br/>
                            <div class="bill_item_footer text-muted">
                                <label><?php if ($parameter_value->description != '') {
                                        echo $this->lang->line('description') . ': ';
                                    } ?></label> <?php echo $parameter_value->description; ?></div>
                        </td>
                        <td>
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="hidden" class="form-control left-border-none"
                                           name="prev_id_<?php echo $parameter_value->id; ?>"
                                           value="<?php echo $parameter_value->radiology_report_parameterdetail_id; ?>">
                                    <?php //old value /*echo $parameter_value->radiology_report_value; */?>
                                    <input type="text" class="form-control left-border-none"
                                           name="radiology_parameter_<?php echo $parameter_value->id; ?>"
                                           value="<?php if (! empty($parameter_value->radiology_report_value))
                                           {echo $parameter_value->radiology_report_value; }
                                           else{ echo $parameter_value->reference_range;} ?>">
                                    <span class="input-group-addon transparent" id="start-date"
                                          name="radiology_parameterdetails_<?php echo $parameter_value->id; ?>"> <?php echo $parameter_value->unit_name; ?></span>
                                </div>
                            </div>
                        </td>
                        <td class="text-right">
                            <strong>
                                <?php echo $parameter_value->reference_range . " " . $parameter_value->unit_name; ?>
                            </strong>
                        </td>
                        <td>
                            <button type="button" class="closebtn delete_row"><i class="fa fa-remove"></i></button>
                        </td>
                    </tr>
                    <?php
                    $row_counter++;
                }
                ?>
                </tbody>
            </table>
        </div>
    </div>
</div>