<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
?>
    <div class="content-wrapper">
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <!-- general form elements -->
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title titlefix">PC List</h3>
                            <div class="box-tools pull-right">
                            </div>
                        </div>

                        <div class="box-body pb0">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="row">
                                        <form id="form1" action="" method="post" class="">
                                            <div class="box-body row">
                                                <?php echo $this->customlib->getCSRF(); ?>
                                                <div class="col-sm-6 col-md-3" >
                                                    <div class="form-group">
                                                        <label><?php echo $this->lang->line('search_type'); ?></label><small class="req"> *</small>
                                                        <select class="form-control" name="search_type"  id="search_type_select" onchange="showdate(this.value)">
                                                            <option value=""><?php echo $this->lang->line('select') ?></option>
                                                            <?php
                                                            foreach ($searchlist as $key => $search) { ?>
                                                                <option value="<?php echo $key ?>" <?php
                                                                if ((isset($search_type)) && ($search_type == $key)) {
                                                                    echo "selected";
                                                                }
                                                                ?>><?php echo $search ?></option>
                                                            <?php }?>
                                                        </select>
                                                        <span class="text-danger" id="error_search_type"><?php echo form_error('search_type'); ?></span>
                                                    </div>
                                                </div>


                                                <div class="col-sm-6 col-md-3" id="fromdate" style="display: none">
                                                    <div class="form-group">
                                                        <label><?php echo $this->lang->line('date_from'); ?></label><small class="req"> *</small>
                                                        <input id="date_from" name="date_from" placeholder="" type="text" class="form-control date" value="<?php echo set_value('date_from', date($this->customlib->getHospitalDateFormat())); ?>"  />
                                                        <span class="text-danger"><?php echo form_error('date_from'); ?></span>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-3" id="todate" style="display: none">
                                                    <div class="form-group">
                                                        <label><?php echo $this->lang->line('date_to'); ?></label><small class="req"> *</small>
                                                        <input id="date_to" name="date_to" placeholder="" type="text" class="form-control date" value="<?php echo set_value('date_to', date($this->customlib->getHospitalDateFormat())); ?>"  />
                                                        <span class="text-danger"><?php echo form_error('date_to'); ?></span>
                                                    </div>
                                                </div>


                                                <div class="form-group">
                                                    <div class="col-sm-12">
                                                        <button type="submit" name="search" value="1" class="btn btn-primary btn-sm pull-right"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="box-body">
                            <div class="table-responsive mailbox-messages">
                                <table class="table table-hover table-striped table-bordered example ajaxlist">
                                    <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('type'); ?></th>
                                        <th><?php echo $this->lang->line('patient_name'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('bill_no'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('amount'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('payee'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('date'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    if (empty($list)) {
                                        ?>
                                        <?php
                                    } else {

                                        foreach ($list as $key => $value) {
                                            ?>
                                            <tr>
                                                <td class="mailbox-name">
                                                    <a href="#" data-toggle="popover"
                                                       class="detail_popover"><?php echo $value->type ?></a>

                                                </td>
                                                <td>
                                                    <?php echo composePatientName($value->patient_name, $value->patient_id); ?>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo $value->bill_no; ?>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo number_format($value->amount, 2); ?>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo $value->name; ?>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo date('Y-m-d h:i a', strtotime($value->created_at)); ?>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                    </tbody>
                                </table><!-- /.table -->
                            </div><!-- /.mail-box-messages -->
                        </div><!-- /.box-body -->
                    </div>
                </div><!--/.col (left) -->
                <!-- right column -->
            </div>
        </section><!-- /.content -->
    </div><!-- /.content-wrapper -->


<script type="text/javascript">

    function showdate(value) {

        if (value == 'period') {
            $('#fromdate').show();
            $('#todate').show();
        } else {
            $('#fromdate').hide();
            $('#todate').hide();
        }
    }
</script>
