<style type="text/css">
    @media print
    {
        .no-print, .no-print *
        {
            display: none !important;
        }
    }
</style>
<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
?>
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo $this->lang->line('details_transaction_report') ?></h3>
                        <div class="box-tools pull-right">
                        </div>
                    </div>
                    <div class="box-body pb0">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <form id="form1" action="" method="post" class="">
                                        <div class="box-body row">
                                            <?php echo $this->customlib->getCSRF(); ?>
                                            <div class="col-sm-6 col-md-3" >
                                                <div class="form-group">
                                                    <label><?php echo $this->lang->line('date_from'); ?></label><small class="req"> *</small>
                                                    <input id="date_from" name="date_from" placeholder="" type="text" class="form-control start_date" value="<?php echo set_value('date_from', date($this->customlib->getHospitalDateFormat())); ?>"  />
                                                    <span class="text-danger" id="error_date_from"><?php echo form_error('collect_staff'); ?></span>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-3" >
                                                <div class="form-group">
                                                    <label><?php echo $this->lang->line('date_to'); ?></label><small class="req"> *</small>
                                                    <input id="date_to" name="date_to" placeholder="" type="text" class="form-control end_date" value="<?php echo set_value('date_to', date($this->customlib->getHospitalDateFormat())); ?>"  />
                                                    <span class="text-danger" id="error_date_to"><?php echo form_error('collect_staff'); ?></span>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-sm-12">
                                                     <button type="submit" name="search" value="search_filter" class="btn btn-primary btn-sm pull-right"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tabsborderbg"></div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover allajaxlist" cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('transaction_id'); ?></th>
                                    <th><?php echo $this->lang->line('date'); ?></th>
                                    <th><?php echo $this->lang->line('payment_mode'); ?></th>
                                    <th><?php echo $this->lang->line('collected_by'); ?></th>
                                    <th class="text text-right"><?php echo $this->lang->line('amount'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>   <!-- /.row -->
    </section><!-- /.content -->
</div>

<script>

    var date_format_new = '<?php echo $result = strtr($this->customlib->getHospitalDateFormat(), ['d' => 'dd', 'm' => 'mm', 'Y' => 'yyyy']) ?>';
    $(document).ready(function(){

        $(".start_date").datepicker({
            format: date_format_new,
            setDate: new Date(),
            autoclose: true,
            todayHighlight: true
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            $('.end_date').datepicker('setStartDate', minDate);
        });

        $(".end_date").datepicker({
            format: date_format_new,
            setDate: new Date(),
            autoclose: true,
            todayHighlight: true
        }).on('changeDate', function (selected) {
            var maxDate = new Date(selected.date.valueOf());
            $('.start_date').datepicker('setEndDate', maxDate);
        });

    });


    ( function ( $ ) {
        'use strict';
        $(document).ready(function () {
            emptyDatatable('allajaxlist', 'data');
            $('#form1').on('submit', (function (e) {
                    e.preventDefault();
                    var search= 'search_filter';
                    var formData = new FormData(this);
                    formData.append('search', 'search_filter');
                    $.ajax({
                        url: '<?php echo base_url(); ?>admin/income/checkvalidationDetails',
                        type: "POST",
                        data: formData,
                        dataType: 'json',
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function (data) {
                            if (data.status == "fail") {
                                $.each(data.error, function(key, value) {
                                    $('#error_' + key).html(value);
                                });
                            } else
                            {
                                initDatatable('allajaxlist','admin/income/detailstransaction/',data.param,[],100,
                                    [
                                        { "sWidth": "90px", "aTargets": [ 0 ] ,'sClass': 'dt-body-left'},
                                        { "sWidth": "150px", "aTargets": [ 1] ,'sClass': 'dt-body-left'},
                                        { "sWidth": "150px", "aTargets": [ -1] ,'sClass': 'dt-body-right'}
                                    ]);
                            }
                        }
                    });
                }
            ));
        });

    } ( jQuery ) );

</script>