#
# TABLE STRUCTURE FOR: acc_coa
#

DROP TABLE IF EXISTS `acc_coa`;

CREATE TABLE `acc_coa` (
  `HeadCode` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `HeadName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `PHeadName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `HeadLevel` int(11) NOT NULL,
  `IsActive` tinyint(1) NOT NULL,
  `IsTransaction` tinyint(1) NOT NULL,
  `IsGL` tinyint(1) NOT NULL,
  `HeadType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `IsBudget` tinyint(1) NOT NULL,
  `IsDepreciation` tinyint(1) NOT NULL,
  `DepreciationRate` decimal(18,2) NOT NULL,
  `CreateBy` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `CreateDate` datetime NOT NULL,
  `UpdateBy` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `UpdateDate` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021403', 'AC', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:33:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202', 'Account Payable', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10203', 'Account Receivable', 'Current Asset', 2, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2013-09-18 15:29:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020201', 'Advance', 'Advance, Deposit And Pre-payments', 3, 1, 0, 1, 'A', 0, 0, '0.00', 'Zoherul', '2015-05-31 13:29:12', 'admin', '2015-12-31 16:46:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020103', 'Advance House Rent', 'Advance', 4, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-10-02 16:55:38', 'admin', '2016-10-02 16:57:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10202', 'Advance, Deposit And Pre-payments', 'Current Asset', 2, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-12-31 16:46:24');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020602', 'Advertisement and Publicity', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:51:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010410', 'Air Cooler', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-05-23 12:13:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020603', 'AIT Against Advertisement', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:09', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020200001', 'any-CDC5X7X2KR3ILJVQTIVG', 'Account Payable', 3, 1, 1, 0, 'L', 0, 0, '0.00', '1', '2022-02-23 23:30:57', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1', 'Assets', 'COA', 0, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010204', 'Attendance Machine', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:49:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40216', 'Audit Fee', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2017-07-18 12:54:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021002', 'Bank Charge', 'Financial Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:21:03', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30203', 'Bank Interest', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'Obaidul', '2015-01-03 14:49:54', 'admin', '2016-09-25 11:04:19');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010104', 'Book Shelf', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:46:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010407', 'Books and Journal', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:45:37', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020604', 'Business Development Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020606', 'Campaign Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:57', 'admin', '2016-09-19 14:52:48');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020502', 'Campus Rent', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:46:53', 'admin', '2017-04-27 17:02:39');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40212', 'Car Running Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:28:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10201', 'Cash & Cash Equivalent', 'Current Asset', 2, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-06-12 11:47:24', 'admin', '2015-10-15 15:57:55');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020102', 'Cash At Bank', 'Cash & Cash Equivalent', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-03-18 06:08:18', 'admin', '2015-10-15 15:32:42');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020101', 'Cash In Hand', 'Cash & Cash Equivalent', 3, 1, 1, 0, 'A', 0, 0, '0.00', '1', '2019-01-26 07:38:48', 'admin', '2016-05-23 12:05:43');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010207', 'CCTV', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:24', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020102', 'CEO Current A/C', 'Advance', 4, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-09-25 11:54:54', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010101', 'Class Room Chair', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:45:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021407', 'Close Circuit Cemera', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:35', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020601', 'Commision on Admission', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:51:21', 'admin', '2016-09-19 14:42:54');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010206', 'Computer', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:09', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021410', 'Computer (R)', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-03-24 12:38:52', 'Zoherul', '2016-03-24 12:41:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010102', 'Computer Table', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:45:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('301020401', 'Continuing Registration fee - UoL (Income)', 'Registration Fee (UOL) Income', 4, 1, 1, 0, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:40:40', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020904', 'Contratuall Staff Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:34', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020709', 'Cultural Expense', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'nasmud', '2017-04-29 12:45:10', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102', 'Current Asset', 'Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2018-07-07 11:23:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502', 'Current Liabilities', 'Liabilities', 1, 1, 0, 0, 'L', 0, 0, '0.00', 'anwarul', '2014-08-30 13:18:20', 'admin', '2015-10-15 19:49:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020301', 'Customer Receivable', 'Account Receivable', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-01-24 12:10:05', 'admin', '2018-07-07 12:31:42');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020202', 'Deposit', 'Advance, Deposit And Pre-payments', 3, 1, 0, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:40:42', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020605', 'Design & Printing Expense', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:55:00', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020404', 'Dish Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40215', 'Dividend', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2016-09-25 14:07:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020403', 'Drinking Water Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:10', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010211', 'DSLR Camera', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:53:17', 'admin', '2016-01-02 16:23:25');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020908', 'Earned Leave', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:38', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020607', 'Education Fair Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:53:42', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010602', 'Electric Equipment', 'Electrical Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:44:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010203', 'Electric Kettle', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:49:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10106', 'Electrical Equipment', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:43:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020407', 'Electricity Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:59:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50204', 'Employee Ledger', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', '1', '2019-04-08 10:36:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('404', 'Employee Salary', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-23 05:46:14', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40201', 'Entertainment', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:21:26', 'anwarul', '2013-07-17 14:21:47');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('2', 'Equity', 'COA', 0, 1, 0, 0, 'L', 0, 0, '0.00', '', '2019-08-10 11:01:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4', 'Expence', 'COA', 0, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-06-18 11:40:41', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020903', 'Faculty,Staff Salary & Allowances', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021404', 'Fax Machine', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:34:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020905', 'Festival & Incentive Bonus', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:48', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010103', 'File Cabinet', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:46:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40210', 'Financial Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-08-20 12:24:31', 'admin', '2015-10-15 19:20:36');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010403', 'Fire Extingushier', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:39:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('405', 'Fixed Assets Cost', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-29 05:32:01', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021408', 'Furniture', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:47', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10101', 'Furniture & Fixturers', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'anwarul', '2013-08-20 16:18:15', 'anwarul', '2013-08-21 13:35:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020406', 'Gas Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:59:20', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20201', 'General Reserve', 'Reserve & Surplus', 2, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-25 14:07:12', 'admin', '2016-10-02 17:48:49');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10105', 'Generator', 'Non Current Assets', 2, 1, 1, 1, 'A', 0, 0, '0.00', 'Zoherul', '2016-02-27 16:02:35', 'admin', '2016-05-23 12:05:18');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021414', 'Generator Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-06-16 10:21:05', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40213', 'Generator Running Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:29:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10103', 'Groceries and Cutleries', 'Non Current Assets', 2, 1, 1, 1, 'A', 0, 0, '0.00', '2', '2018-07-12 10:02:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010408', 'Gym Equipment', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:46:03', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020907', 'Honorarium', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:26', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40205', 'House Rent', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-08-24 10:26:56', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3', 'Income', 'COA', 0, 1, 0, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:32:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30204', 'Income from Photocopy & Printing', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'Zoherul', '2015-07-14 10:29:54', 'admin', '2016-09-25 11:04:28');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020302', 'Income Tax Payable', 'Liabilities for Expenses', 3, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2016-09-19 11:18:17', 'admin', '2016-09-28 13:18:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10107', 'Inventory', 'Non Current Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '2', '2018-07-07 15:21:58', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010210', 'LCD TV', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:52:27', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30103', 'Lease Sale', 'Store Income', 1, 1, 1, 1, 'I', 0, 0, '0.00', '2', '2018-07-08 07:51:52', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5', 'Liabilities', 'COA', 0, 1, 0, 0, 'L', 0, 0, '0.00', 'admin', '2013-07-04 12:32:07', 'admin', '2015-10-15 19:46:54');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50203', 'Liabilities for Expenses', 'Current Liabilities', 2, 1, 0, 0, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020707', 'Library Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2017-01-10 15:34:54', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021409', 'Lift', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:36:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020302', 'Loan Receivable', 'Account Receivable', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-01-26 07:37:20', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50101', 'Long Term Borrowing', 'Non Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2013-07-04 12:32:26', 'admin', '2015-10-15 19:47:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020608', 'Marketing & Promotion Exp.', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:53:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020901', 'Medical Allowance', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:11:33', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010411', 'Metal Ditector', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'Zoherul', '2016-08-22 10:55:22', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021413', 'Micro Oven', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-05-12 14:53:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30202', 'Miscellaneous (Income)', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'anwarul', '2014-02-06 15:26:31', 'admin', '2016-09-25 11:04:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020909', 'Miscellaneous Benifit', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:53', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020701', 'Miscellaneous Exp', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-09-25 12:54:39', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40207', 'Miscellaneous Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2014-04-26 16:49:56', 'admin', '2016-09-25 12:54:19');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010401', 'Mobile Phone', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-29 10:43:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010212', 'Network Accessories', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-02 16:23:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020408', 'News Paper Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-01-02 15:55:57', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('101', 'Non Current Assets', 'Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-10-15 15:29:11');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('501', 'Non Current Liabilities', 'Liabilities', 1, 1, 0, 0, 'L', 0, 0, '0.00', 'anwarul', '2014-08-30 13:18:20', 'admin', '2015-10-15 19:49:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010404', 'Office Decoration', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:40:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10102', 'Office Equipment', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'anwarul', '2013-12-06 18:08:00', 'admin', '2015-10-15 15:48:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021401', 'Office Repair & Maintenance', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:33:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30201', 'Office Stationary (Income)', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'anwarul', '2013-07-17 15:21:06', 'admin', '2016-09-25 11:04:50');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('302', 'Other Income', 'Income', 1, 1, 0, 0, 'I', 0, 0, '0.00', '2', '2018-07-07 13:40:57', 'admin', '2016-09-25 11:04:09');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40211', 'Others (Non Academic Expenses)', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'Obaidul', '2014-12-03 16:05:42', 'admin', '2015-10-15 19:22:09');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30205', 'Others (Non-Academic Income)', 'Other Income', 2, 1, 0, 1, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:23:49', 'admin', '2015-10-15 17:57:52');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10104', 'Others Assets', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2016-01-29 10:43:16', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020910', 'Outstanding Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 11:56:50', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021405', 'Oven', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:34:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021412', 'PABX-Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 14:40:18', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020902', 'Part-time Staff Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:06', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010202', 'Photocopy & Fax Machine', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:47:27', 'admin', '2016-05-23 12:14:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021411', 'Photocopy Machine Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 12:40:02', 'admin', '2017-04-27 17:03:17');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020503', 'Practical Fee', 'Others (Non-Academic Income)', 3, 1, 1, 1, 'I', 0, 0, '0.00', 'admin', '2017-07-22 18:00:37', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020203', 'Prepayment', 'Advance, Deposit And Pre-payments', 3, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:40:51', 'admin', '2015-12-31 16:49:58');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010201', 'Printer', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:47:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40202', 'Printing and Stationary', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:21:45', 'admin', '2016-09-19 14:39:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('402', 'Product Purchase', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-20 07:46:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('304', 'Product Sale', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-06-16 12:15:40', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020502', 'Professional Training Course(Oracal-1)', 'Others (Non-Academic Income)', 3, 1, 1, 0, 'I', 0, 0, '0.00', 'nasim', '2017-06-22 13:28:05', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30207', 'Professional Training Course(Oracal)', 'Other Income', 2, 1, 0, 1, 'I', 0, 0, '0.00', 'nasim', '2017-06-22 13:24:16', 'nasim', '2017-06-22 13:25:56');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010208', 'Projector', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40206', 'Promonational Expence', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-07-11 13:48:57', 'anwarul', '2013-07-17 14:23:03');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40214', 'Repair and Maintenance', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:32:46', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('202', 'Reserve & Surplus', 'Equity', 1, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2016-09-25 14:06:34', 'admin', '2016-10-02 17:48:57');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20102', 'Retained Earnings', 'Share Holders Equity', 2, 1, 1, 1, 'L', 0, 0, '0.00', 'admin', '2016-05-23 11:20:40', 'admin', '2016-09-25 14:05:06');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020708', 'River Cruse', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2017-04-24 15:35:25', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020105', 'Salary', 'Advance', 4, 1, 0, 0, 'A', 0, 0, '0.00', 'admin', '2018-07-05 11:46:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40209', 'Salary & Allowances', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-12-12 11:22:58', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010406', 'Security Equipment', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:41:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('305', 'Service Income', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-22 13:36:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20101', 'Share Capital', 'Share Holders Equity', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'anwarul', '2013-12-08 19:37:32', 'admin', '2015-10-15 19:45:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('201', 'Share Holders Equity', 'Equity', 1, 1, 0, 0, 'L', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-10-15 19:43:51');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50201', 'Short Term Borrowing', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40208', 'Software Development Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-11-21 14:13:01', 'admin', '2015-10-15 19:02:51');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020906', 'Special Allowances', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:13', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50102', 'Sponsors Loan', 'Non Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:48:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020706', 'Sports Expense', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'nasmud', '2016-11-09 13:16:53', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('301', 'Store Income', 'Income', 1, 1, 0, 0, 'I', 0, 0, '0.00', '2', '2018-07-07 13:40:37', 'admin', '2015-09-17 17:00:02');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020501', 'Students Info. Correction Fee', 'Others (Non-Academic Income)', 3, 1, 1, 0, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:24:45', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010601', 'Sub Station', 'Electrical Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:44:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50205', 'Supplier Ledger', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', '1', '2019-10-06 06:18:49', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020704', 'TB Care Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-10-08 13:03:04', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30206', 'TB Care Income', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'admin', '2016-10-08 13:00:56', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020501', 'TDS on House Rent', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:44:07', 'admin', '2016-09-19 14:40:16');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030201', 'TDS Payable House Rent', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-19 11:19:42', 'admin', '2016-09-28 13:19:37');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030203', 'TDS Payable on Advertisement Bill', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-28 13:20:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030202', 'TDS Payable on Salary', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-28 13:20:17', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020402', 'Telephone Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:57:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010209', 'Telephone Set & PABX', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:57', 'admin', '2016-10-02 17:10:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30301', 'test in 1', 'Test Income', 2, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:25:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('303', 'Test Income', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:24:33', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40203', 'Travelling & Conveyance', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:22:06', 'admin', '2015-10-15 18:45:13');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021406', 'TV', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010205', 'UPS', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:50:38', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40204', 'Utility Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-07-11 16:20:24', 'admin', '2016-01-02 15:55:22');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020503', 'VAT on House Rent Exp', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:49:22', 'admin', '2016-09-25 14:00:52');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020301', 'VAT Payable', 'Liabilities for Expenses', 3, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:51:11', 'admin', '2016-09-28 13:23:53');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010409', 'Vehicle A/C', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'Zoherul', '2016-05-12 12:13:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010405', 'Voltage Stablizer', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:40:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102030101', 'Walking Customer-P3NY6D1AKZQPHB7', 'Customer Receivable', 4, 1, 1, 0, 'A', 0, 0, '0.00', '1', '2019-05-20 06:55:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020405', 'WASA Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010402', 'Water Purifier', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-29 11:14:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020705', 'Website Development Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-10-15 12:42:47', '', '2019-08-10 11:01:12');


#
# TABLE STRUCTURE FOR: acc_transaction
#

DROP TABLE IF EXISTS `acc_transaction`;

CREATE TABLE `acc_transaction` (
  `ID` int(11) NOT NULL,
  `VNo` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Vtype` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `VDate` date DEFAULT NULL,
  `COAID` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `Narration` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `Debit` decimal(18,2) DEFAULT NULL,
  `Credit` decimal(18,2) DEFAULT NULL,
  `IsPosted` char(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CreateBy` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CreateDate` datetime DEFAULT NULL,
  `UpdateBy` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `UpdateDate` datetime DEFAULT NULL,
  `IsAppove` char(10) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (1, '20220223233214', 'Purchase', '2022-02-23', '10107', 'Inventory Debit For Purchase No20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (2, '20220223233214', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233214', '0.00', '80.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (3, '20220223233214', 'Purchase', '2022-02-23', '402', 'Company Credit For Purchase No20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (4, '20220223233214', 'Purchase', '2022-02-23', '1020101', 'Cash in Hand For Purchase No20220223233214', '0.00', '80.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (5, '20220223233214', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (6, '20220223233301', 'Purchase', '2022-02-23', '10107', 'Inventory Debit For Purchase No20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (7, '20220223233301', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233301', '0.00', '132.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (8, '20220223233301', 'Purchase', '2022-02-23', '402', 'Company Credit For Purchase No20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (9, '20220223233301', 'Purchase', '2022-02-23', '1020101', 'Cash in Hand For Purchase No20220223233301', '0.00', '132.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (10, '20220223233301', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (11, '9259592329', 'INVOICE', '2022-02-23', '10107', 'Inventory credit For Invoice No9259592329', '0.00', '8.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (12, '9259592329', 'INVOICE', '2022-02-23', '102030101', 'Customer debit For Invoice No9259592329', '6.00', '0.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (13, '9259592329', 'INVOICE', '2022-02-23', '304', 'Customer debit For Invoice No9259592329', '0.00', '6.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (14, '1877899635', 'INVOICE', '2022-02-23', '10107', 'Inventory credit For Invoice No1877899635', '0.00', '4.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (15, '1877899635', 'INVOICE', '2022-02-23', '102030101', 'Customer debit For Invoice No1877899635', '3.00', '0.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (16, '1877899635', 'INVOICE', '2022-02-23', '304', 'Customer debit For Invoice No1877899635', '0.00', '3.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');


#
# TABLE STRUCTURE FOR: accesslog
#

DROP TABLE IF EXISTS `accesslog`;

CREATE TABLE `accesslog` (
  `sl_no` bigint(20) NOT NULL,
  `action_page` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action_done` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `user_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_date` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: account_2
#

DROP TABLE IF EXISTS `account_2`;

CREATE TABLE `account_2` (
  `account_id` int(11) NOT NULL,
  `account_name` varchar(40) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `parent_id` int(1) NOT NULL,
  `status` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `account_id` varchar(20) NOT NULL,
  `account_table_name` varchar(255) NOT NULL,
  `account_name` varchar(255) NOT NULL,
  `status` int(5) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) DEFAULT NULL,
  `tax_percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  CONSTRAINT `ambulance_call_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_2` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_4` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (5, 'Low', '2021-09-24 13:28:40');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `time` time DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int(11) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `is_queue` int(11) DEFAULT NULL,
  `live_consult` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  KEY `case_reference_id` (`case_reference_id`),
  CONSTRAINT `appointment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_2` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `note` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `appointment_id` (`appointment_id`),
  CONSTRAINT `appointment_payment_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_payment_ibfk_3` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`shift_id`),
  CONSTRAINT `appointment_queue_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_3` FOREIGN KEY (`shift_id`) REFERENCES `doctor_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset_purchase
#

DROP TABLE IF EXISTS `asset_purchase`;

CREATE TABLE `asset_purchase` (
  `id` int(11) NOT NULL,
  `p_date` date NOT NULL,
  `supplier_id` varchar(30) NOT NULL,
  `grand_total` float NOT NULL,
  `payment_type` tinyint(4) DEFAULT NULL,
  `bank_id` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: attendance
#

DROP TABLE IF EXISTS `attendance`;

CREATE TABLE `attendance` (
  `att_id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `sign_in` varchar(30) NOT NULL,
  `sign_out` varchar(30) NOT NULL,
  `staytime` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bank_add
#

DROP TABLE IF EXISTS `bank_add`;

CREATE TABLE `bank_add` (
  `id` int(11) NOT NULL,
  `bank_id` varchar(50) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `ac_name` varchar(250) DEFAULT NULL,
  `ac_number` varchar(250) DEFAULT NULL,
  `branch` varchar(250) DEFAULT NULL,
  `signature_pic` varchar(250) DEFAULT NULL,
  `status` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bank_summary
#

DROP TABLE IF EXISTS `bank_summary`;

CREATE TABLE `bank_summary` (
  `id` int(11) NOT NULL,
  `bank_id` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `deposite_id` varchar(250) DEFAULT NULL,
  `date` varchar(250) DEFAULT NULL,
  `ac_type` varchar(50) DEFAULT NULL,
  `dr` decimal(12,2) DEFAULT 0.00,
  `cr` decimal(10,2) DEFAULT 0.00,
  `ammount` decimal(12,2) DEFAULT 0.00,
  `status` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `bed_ibfk_1` FOREIGN KEY (`bed_type_id`) REFERENCES `bed_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (1, '401A', 1, 3, 'no', '2022-02-18 05:49:52');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (2, '402A', 1, 3, 'no', '2022-02-18 05:50:06');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (3, '403A', 1, 3, 'no', '2022-02-18 05:50:36');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (4, '303', 2, 2, 'no', '2022-02-18 05:50:59');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (6, '208', 2, 1, 'yes', '2022-02-28 03:59:56');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (7, '401B', 1, 3, 'no', '2022-02-28 04:00:48');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (8, '401C', 1, 3, 'no', '2022-02-28 04:01:04');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (9, '401D', 1, 3, 'no', '2022-02-28 04:01:15');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (10, '401E', 1, 3, 'no', '2022-02-28 04:01:32');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (11, '402B', 1, 3, 'no', '2022-02-28 04:02:04');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (12, '402C', 1, 3, 'no', '2022-02-28 04:02:16');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (13, '402D', 1, 3, 'no', '2022-02-28 04:02:27');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (14, '402E', 1, 3, 'no', '2022-02-28 04:02:40');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (15, '403B', 1, 3, 'no', '2022-02-28 04:03:05');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (16, '403C', 1, 3, 'no', '2022-02-28 04:03:16');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (17, '403D', 1, 3, 'no', '2022-02-28 04:03:28');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (18, '403E', 1, 3, 'no', '2022-02-28 04:03:39');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (19, '303A', 2, 2, 'no', '2022-02-28 04:08:28');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (21, '303.', 2, 2, 'no', '2022-02-28 04:09:21');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `color` varchar(50) NOT NULL DEFAULT '#f4f4f4',
  `description` varchar(200) NOT NULL,
  `floor` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (1, 'Cabin', '#f4f4f4', '', 1, 0, '2022-02-28 03:54:13');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (2, 'Cabin VIP', '#a3acf5', '', 2, 0, '2022-02-28 03:55:01');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (3, 'Ward', '#9cf29d', '', 3, 0, '2022-02-28 03:55:37');


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (1, 'Ward', '2022-02-18 05:49:17');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (2, 'Cabin', '2022-02-18 05:49:28');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext DEFAULT NULL,
  `document` varchar(200) NOT NULL,
  `address` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `birth_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `birth_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  CONSTRAINT `blood_donor_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int(11) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `blood_donor_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `volume` varchar(100) DEFAULT NULL,
  `unit` int(11) DEFAULT NULL,
  `available` int(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_donor_cycle_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_2` FOREIGN KEY (`blood_donor_id`) REFERENCES `blood_donor` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `blood_donor_cycle_id` int(11) DEFAULT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `hospital_doctor` int(11) DEFAULT NULL,
  `reference` varchar(200) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `remark` mediumtext DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_issue_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_2` FOREIGN KEY (`blood_donor_cycle_id`) REFERENCES `blood_donor_cycle` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_4` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-10-22 05:21:32');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-10-22 05:21:38');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 0, '2021-10-22 05:21:40');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

INSERT INTO `case_references` (`id`, `created_at`) VALUES (1, '2022-01-11 06:32:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2, '2022-02-18 05:55:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (3, '2022-02-18 06:56:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (4, '2022-02-26 09:30:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (5, '2022-02-26 09:54:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (6, '2022-02-27 14:21:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (7, '2022-02-27 15:20:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (8, '2022-02-27 15:32:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (9, '2022-02-28 18:04:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (10, '2022-03-01 03:10:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (11, '2022-03-01 07:19:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (12, '2022-03-01 12:30:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (13, '2022-03-01 12:49:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (14, '2022-03-01 13:06:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (15, '2022-03-01 13:10:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (16, '2022-03-01 13:11:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (17, '2022-03-01 13:24:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (18, '2022-03-01 13:42:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (19, '2022-03-01 13:53:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (20, '2022-03-01 17:43:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (21, '2022-03-01 17:55:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (22, '2022-03-01 18:12:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (23, '2022-03-01 18:16:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (24, '2022-03-02 02:56:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (25, '2022-03-02 12:07:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (26, '2022-03-02 12:26:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (27, '2022-03-02 12:28:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (28, '2022-03-02 12:34:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (29, '2022-03-02 12:37:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (30, '2022-03-02 12:37:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (31, '2022-03-03 05:53:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (32, '2022-03-03 06:29:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (33, '2022-03-03 06:31:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (34, '2022-03-03 06:33:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (35, '2022-03-03 10:30:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (36, '2022-03-03 17:14:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (37, '2022-03-04 10:20:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (38, '2022-03-05 03:31:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (39, '2022-03-05 11:34:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (40, '2022-03-05 11:59:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (41, '2022-03-05 12:10:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (42, '2022-03-05 12:23:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (43, '2022-03-05 12:24:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (44, '2022-03-05 12:25:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (45, '2022-03-05 12:38:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (46, '2022-03-05 12:54:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (47, '2022-03-05 12:55:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (48, '2022-03-05 12:57:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (49, '2022-03-06 02:38:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (50, '2022-03-06 03:05:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (51, '2022-03-06 09:15:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (52, '2022-03-06 09:27:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (53, '2022-03-06 09:32:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (54, '2022-03-06 09:38:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (55, '2022-03-06 09:40:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (56, '2022-03-06 13:42:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (57, '2022-03-06 18:24:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (58, '2022-03-06 19:04:37');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text DEFAULT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) NOT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `updated_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (12, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '1_(5).png', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2022-01-17 03:53:59');


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_id` int(11) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `short_code` varchar(30) DEFAULT NULL,
  `is_default` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  CONSTRAINT `charge_categories_ibfk_1` FOREIGN KEY (`charge_type_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (2, 4, 'BIO-CHEMISTRY', '0\r\n', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (3, 4, 'CANCER MARKER', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (4, 4, 'CULTURE', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (5, 4, 'ELECTROLYTES', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (6, 4, 'HAEMATOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (7, 4, 'HEPATOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (8, 4, 'HISTOPATHOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (9, 4, 'HORMONE	', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (10, 4, 'IMMUNOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (11, 4, 'MICROBIOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (12, 4, 'PBF', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (13, 4, 'SEROLOGY/IMMUNOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (14, 4, 'STOOL EXAM', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (15, 4, 'URINE EXAM', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (16, 4, 'VIRAL MARKER', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (18, 2, 'Dr. Fees', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (19, 5, 'ULTRASOUND', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (20, 5, 'X-RAY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (21, 7, 'Ambulance Charge', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (22, 4, 'ENT SURGERY	', '0\r\n', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (23, 4, 'GENERAL SURGERY	', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (24, 4, 'Gynae', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (25, 4, 'MAJOR SURGERY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (26, 4, 'MINOR SURGERY', '0', NULL, '', '2022-01-12 18:06:56');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (27, 1, 'Selim Doctor online fees', 'Virtual Consultancy', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (28, 3, 'Admission', 'IPD', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (29, 3, 'Advance', 'Take advance from patient for IPD ', NULL, '', '2022-03-05 11:57:04');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (30, 1, 'Dr.Fees', 'Visiting fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (31, 2, 'Free Doctor Visit', 'No charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (32, 3, 'Bed', 'Ward and Cabin', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (33, 3, 'Doctor Round', 'Visit', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (34, 3, 'OT Charge', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (35, 11, 'Surgeon Fees', 'Surgeon', NULL, '', '2022-03-01 02:51:32');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (36, 11, 'Anesthesia', 'Anesthesia', NULL, '', '2022-03-01 02:54:29');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (37, 11, 'Assist fees', 'Assist ', NULL, '', '2022-03-01 02:59:27');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (38, 3, 'Service Charge', 'Service', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (39, 3, 'Dressings Charges', 'Dressings', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (40, 3, 'OT Charge2', 'OT ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (41, 3, 'OT Charge3', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (42, 11, 'Operations', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (43, 11, 'Operation2.5k', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (44, 11, 'Operation3k', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (45, 12, 'Sewing Cutting', 'Sewing', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (46, 2, 'Emergency', 'eg', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (49, 2, 'Cannula Change', 'CC', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (50, 2, 'injection push', 'ip', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (51, 2, 'Nebulization Fees', 'NF', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (52, 2, 'Oxygen Fees', 'OF', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (53, 3, 'Cabin Charge', 'CC', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (54, 4, 'Urine Report', 'Full Urine test', NULL, '', NULL);


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (1, 'Appointment', 'yes', 'yes', '2021-09-24 14:10:32');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (2, 'OPD', 'yes', 'yes', '2021-09-24 14:10:02');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (3, 'IPD', 'yes', 'yes', '2021-09-24 14:10:47');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', 'yes', '2021-10-22 21:40:03');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (5, 'Radiology', 'yes', 'yes', '2021-10-22 22:10:21');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (6, 'Blood Bank', 'yes', 'yes', '2021-10-22 22:10:33');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (7, 'Ambulance', 'yes', 'yes', '2021-10-22 22:10:44');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (8, 'Procedures', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (9, 'Investigations', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (10, 'Supplier', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (11, 'Operations', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (12, 'Others', 'yes', 'yes', '2018-08-17 13:40:07');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int(11) DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_master_id` (`charge_type_master_id`),
  CONSTRAINT `charge_type_module_ibfk_1` FOREIGN KEY (`charge_type_master_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (2, 1, 'appointment', '2021-10-23 03:52:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (4, 2, 'opd', '2021-10-23 03:52:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (5, 3, 'ipd', '2021-10-23 03:52:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (6, 4, 'pathology', '2021-10-23 03:52:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (7, 5, 'radiology', '2021-10-23 03:52:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (8, 6, 'blood_bank', '2021-10-23 03:52:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (9, 7, 'ambulance', '2021-10-23 03:52:59');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (10, 8, 'opd', '2021-10-23 03:53:03');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (11, 8, 'ipd', '2021-10-23 03:53:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (13, 9, 'pathology', '2021-10-23 03:53:09');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (14, 9, 'radiology', '2021-10-23 03:53:11');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (15, 10, 'opd', '2021-10-23 03:53:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (16, 10, 'ipd', '2021-10-23 03:53:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (17, 11, 'opd', '2021-10-23 03:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (18, 11, 'ipd', '2021-10-23 03:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (19, 12, 'appointment', '2021-10-23 03:53:20');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (20, 12, 'opd', '2021-10-23 03:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (21, 12, 'ipd', '2021-10-23 03:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (24, 12, 'pathology', '2021-10-23 03:53:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (25, 12, 'radiology', '2021-10-23 03:53:27');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (26, 12, 'blood_bank', '2021-10-23 03:53:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (27, 12, 'ambulance', '2021-10-23 03:53:31');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, '0', 0, '2022-01-11 05:12:07');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (2, 'Tk.', 0, '2022-02-18 06:20:13');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_category_id` int(11) DEFAULT NULL,
  `tax_category_id` int(11) DEFAULT NULL,
  `charge_unit_id` int(10) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  CONSTRAINT `charges_ibfk_1` FOREIGN KEY (`charge_category_id`) REFERENCES `charge_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_2` FOREIGN KEY (`tax_category_id`) REFERENCES `tax_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_3` FOREIGN KEY (`charge_unit_id`) REFERENCES `charge_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=769 DEFAULT CHARSET=utf8;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (15, 2, 1, 1, '2 hrs after 75g Glucose', '150.00', NULL, '', '', '2022-01-11 07:08:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (16, 2, 1, 1, '2 hrs after breakfast', '150.00', NULL, '', '', '2022-01-11 07:12:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (17, 5, 1, 1, 'S. Electrolytes', '1000.00', NULL, '', '', '2022-01-11 07:36:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (18, 13, 1, 1, 'ASO Titre', '500.00', NULL, '', '', '2022-01-11 07:36:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (19, 10, 1, 1, 'Anti TB IgG', '1000.00', NULL, '', '', '2022-01-11 07:39:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (20, 10, 1, 1, 'Anti TB IgM', '1000.00', NULL, '', '', '2022-01-11 07:40:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (21, 10, 1, 1, 'Anti-TB IgA', '1000.00', NULL, '', '', '2022-01-11 07:42:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (22, 16, 1, 1, 'Anti DS DNA', '1000.00', NULL, '', '', '2022-01-11 07:42:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (23, 10, 1, 1, 'Antibody HSV IgG', '1000.00', NULL, '', '', '2022-01-11 07:43:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (24, 10, 1, 1, 'Antibody HSV IgM', '1000.00', NULL, '', '', '2022-01-11 07:44:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (25, 10, 1, 1, 'C3', '1000.00', NULL, '', '', '2022-01-11 07:45:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (26, 16, 1, 1, 'Anti HAV IgM', '800.00', NULL, '', '', '2022-01-11 07:47:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (27, 10, 1, 1, 'CA-125', '1500.00', NULL, '', '', '2022-01-11 07:47:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (28, 10, 1, 1, 'CFT for Filaria', '1000.00', NULL, '', '', '2022-01-11 07:49:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (29, 13, 1, 1, 'Anti Dengue IgG', '1200.00', NULL, '', '', '2022-01-11 07:50:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (30, 10, 1, 1, 'CFT for Kala-Azar', '1000.00', NULL, '', '', '2022-01-11 07:52:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (31, 16, 1, 1, 'Anti HBc/IgM', '800.00', NULL, '', '', '2022-01-11 07:53:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (32, 13, 1, 1, 'Anti Dengue IgM', '1200.00', NULL, '', '', '2022-01-11 07:53:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (33, 10, 1, 1, 'Dengue IgM IgG', '500.00', NULL, '', '', '2022-01-11 07:53:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (34, 2, 1, 1, '2 hrs after dinner', '200.00', NULL, '', '', '2022-01-11 07:54:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (35, 10, 1, 1, 'ICT for Malaria', '1000.00', NULL, '', '', '2022-01-11 07:55:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (36, 16, 1, 1, 'Anti HBe (HBe Ab)', '800.00', NULL, '', '', '2022-01-11 07:55:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (37, 2, 1, 1, '2 hrs after lunch', '200.00', NULL, '', '', '2022-01-11 07:56:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (38, 13, 1, 1, 'Anti H-Pylory', '700.00', NULL, '', '', '2022-01-11 07:56:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (39, 10, 1, 1, 'MT (Mantoux Test)', '300.00', NULL, '', '', '2022-01-11 08:01:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (40, 13, 1, 1, 'Anti- HIV (1+2)', '1000.00', NULL, '', '', '2022-01-11 08:04:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (41, 10, 1, 1, 'Rubela for IgM', '2000.00', NULL, '', '', '2022-01-11 08:04:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (42, 16, 1, 1, 'Anti HBs Ab', '800.00', NULL, '', '', '2022-01-11 08:04:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (43, 2, 1, 1, '2 hrs before dinner', '200.00', NULL, '', '', '2022-01-11 08:05:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (44, 13, 1, 1, 'B.T.C.T', '500.00', NULL, '', '', '2022-01-11 08:05:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (45, 10, 1, 1, 'S. IgE', '1200.00', NULL, '', '', '2022-01-11 08:05:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (46, 13, 1, 1, 'Blood group', '150.00', NULL, '', '', '2022-01-11 08:06:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (47, 2, 1, 1, '2 hrs before lunch', '200.00', NULL, '', '', '2022-01-11 08:06:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (48, 16, 1, 1, 'Anti HCV', '600.00', NULL, '', '', '2022-01-11 08:07:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (49, 10, 1, 1, 'TB for ICT', '1000.00', NULL, '', '', '2022-01-11 08:07:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (50, 2, 1, 1, '24 Hours UTV, UTP, CCR', '1000.00', NULL, '', '', '2022-01-11 08:07:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (51, 13, 1, 1, 'C4', '1000.00', NULL, '', '', '2022-01-11 08:07:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (52, 2, 1, 1, 'ACR (Albumin Creatinine Ratio)', '800.00', NULL, '', '', '2022-01-11 08:08:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (53, 15, 1, 1, 'Bile pigment', '100.00', NULL, '', '', '2022-01-11 08:09:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (54, 13, 1, 1, 'CRP', '500.00', NULL, '', '', '2022-01-11 08:09:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (55, 16, 1, 1, 'Anti HEV IgG', '1000.00', NULL, '', '', '2022-01-11 08:10:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (56, 2, 1, 1, 'ACTH', '1000.00', NULL, '', '', '2022-01-11 08:10:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (57, 13, 1, 1, 'Cross Matching', '500.00', NULL, '', '', '2022-01-11 08:10:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (58, 15, 1, 1, 'Bile salt', '100.00', NULL, '', '', '2022-01-11 08:10:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (59, 2, 1, 1, 'AFP', '1000.00', NULL, '', '', '2022-01-11 08:11:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (60, 13, 1, 1, 'Cross Matching (Divice)', '1200.00', NULL, '', '', '2022-01-11 08:11:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (61, 15, 1, 1, 'Pregnancy test', '200.00', NULL, '', '', '2022-01-11 08:11:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (62, 2, 1, 1, 'APTT', '800.00', NULL, '', '', '2022-01-11 08:12:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (63, 16, 1, 1, 'Anti HEV IgM', '1000.00', NULL, '', '', '2022-01-11 08:13:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (64, 13, 1, 1, 'Cross Matching with (Screeing ,VDRL, HBsAg , HIV, HCV)', '2200.00', NULL, '', '', '2022-01-11 08:13:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (65, 15, 1, 1, 'URINE FOR SP. GRAVITY', '100.00', NULL, '', '', '2022-01-11 08:13:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (66, 13, 1, 1, 'Febrile Antigen', '1200.00', NULL, '', '', '2022-01-11 08:14:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (67, 16, 1, 1, 'Beta hCG', '1000.00', NULL, '', '', '2022-01-11 08:14:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (68, 13, 1, 1, 'HBcAg', '1000.00', NULL, '', '', '2022-01-11 08:15:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (69, 15, 1, 1, 'Urine  Albumin', '200.00', NULL, '', '', '2022-01-11 08:15:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (70, 15, 1, 1, 'Urine  R/E', '200.00', NULL, '', '', '2022-01-11 08:16:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (71, 16, 1, 1, 'HBV-DNA (PCR)', '9500.00', NULL, '', '', '2022-01-11 08:16:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (72, 13, 1, 1, 'HBsAg (Screening)', '500.00', NULL, '', '', '2022-01-11 08:16:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (73, 2, 1, 1, 'Ag Ratio', '1000.00', NULL, '', '', '2022-01-11 08:16:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (74, 15, 1, 1, 'Urine Electrolytes', '1000.00', NULL, '', '', '2022-01-11 08:17:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (75, 16, 1, 1, 'HCV-RNA (PCR)', '13500.00', NULL, '', '', '2022-01-11 08:17:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (76, 13, 1, 1, 'HCG/PT', '200.00', NULL, '', '', '2022-01-11 08:17:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (77, 2, 1, 1, 'Anti CCP Antibody', '2000.00', NULL, '', '', '2022-01-11 08:17:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (78, 13, 1, 1, 'HIV', '500.00', NULL, '', '', '2022-01-11 08:17:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (79, 15, 1, 1, 'Urine Ketone Body', '200.00', NULL, '', '', '2022-01-11 08:18:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (80, 2, 1, 1, 'Anti CCP IgG', '1400.00', NULL, '', '', '2022-01-11 08:19:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (81, 13, 1, 1, 'NS-1 Antigen', '500.00', NULL, '', '', '2022-01-11 08:19:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (82, 15, 1, 1, 'Urine Sugar', '100.00', NULL, '', '', '2022-01-11 08:19:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (83, 2, 1, 1, 'BUN', '300.00', NULL, '', '', '2022-01-11 08:20:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (84, 13, 1, 1, 'RA test', '500.00', NULL, '', '', '2022-01-11 08:20:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (85, 15, 1, 1, 'Urine for Benzodiazepines', '1000.00', NULL, '', '', '2022-01-11 08:20:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (86, 2, 1, 1, 'Blood Urea', '500.00', NULL, '', '', '2022-01-11 08:20:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (87, 13, 1, 1, 'RF', '400.00', NULL, '', '', '2022-01-11 08:21:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (88, 15, 1, 1, 'Urine for Cannabinodies', '1000.00', NULL, '', '', '2022-01-11 08:21:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (89, 2, 1, 1, 'CCR', '800.00', NULL, '', '', '2022-01-11 08:21:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (90, 13, 1, 1, 'Rose-Waaler test', '600.00', NULL, '', '', '2022-01-11 08:21:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (91, 15, 1, 1, 'Urine for haemoglobin', '200.00', NULL, '', '', '2022-01-11 08:22:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (92, 14, 1, 1, 'Stool  Reducing Substance', '500.00', NULL, '', '', '2022-01-11 08:22:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (93, 2, 1, 1, 'CK-MB', '700.00', NULL, '', '', '2022-01-11 08:22:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (94, 13, 1, 1, 'Semen Analysis', '700.00', NULL, '', '', '2022-01-11 08:22:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (95, 13, 1, 1, 'TPHA', '500.00', NULL, '', '', '2022-01-11 08:23:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (96, 2, 1, 1, 'CPK', '1200.00', NULL, '', '', '2022-01-11 08:24:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (97, 15, 1, 1, 'Urine for opoids', '1000.00', NULL, '', '', '2022-01-11 08:24:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (98, 13, 1, 1, 'Torch Anti Body', '1200.00', NULL, '', '', '2022-01-11 08:24:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (99, 14, 1, 1, 'Stool OBT', '500.00', NULL, '', '', '2022-01-11 08:24:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (100, 2, 1, 1, 'CSF For Albumin', '300.00', NULL, '', '', '2022-01-11 08:24:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (101, 13, 1, 1, 'VDRL', '500.00', NULL, '', '', '2022-01-11 08:25:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (102, 14, 1, 1, 'Stool R/E', '500.00', NULL, '', '', '2022-01-11 08:25:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (103, 2, 1, 1, 'CSF For HDL', '500.00', NULL, '', '', '2022-01-11 08:25:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (104, 12, 1, 1, 'PBF (Peripheral blood film)', '200.00', NULL, '', '', '2022-01-11 08:25:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (105, 2, 1, 1, 'CSF For Protein', '300.00', NULL, '', '', '2022-01-11 08:26:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (106, 13, 1, 1, 'VDRL (Q+Q)', '400.00', NULL, '', '', '2022-01-11 08:26:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (107, 13, 1, 1, 'Widal test', '500.00', NULL, '', '', '2022-01-11 08:27:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (108, 3, 1, 1, 'CA-15.3', '1000.00', NULL, '', '', '2022-01-11 08:28:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (109, 2, 1, 1, 'CSF For Sugar', '120.00', NULL, '', '', '2022-01-11 08:29:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (110, 4, 1, 1, 'Blood C/S', '2500.00', NULL, '', '', '2022-01-11 08:29:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (111, 3, 1, 1, 'CA-19.9', '1500.00', NULL, '', '', '2022-01-11 08:29:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (112, 2, 1, 1, 'FBS', '150.00', NULL, '', '', '2022-01-11 08:30:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (113, 11, 1, 1, 'Clot Culture (salmonella inf.)', '350.00', NULL, '', '', '2022-01-11 08:30:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (114, 4, 1, 1, 'CSF R/E /S', '600.00', NULL, '', '', '2022-01-11 08:31:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (115, 2, 1, 1, 'Fasting Lipid Profile', '1000.00', NULL, '', '', '2022-01-11 08:31:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (116, 3, 1, 1, 'CEA', '1200.00', NULL, '', '', '2022-01-11 08:31:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (117, 2, 1, 1, 'Ferritine', '900.00', NULL, '', '', '2022-01-11 08:31:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (118, 11, 1, 1, 'Endocervical swab for gram stain', '200.00', NULL, '', '', '2022-01-11 08:31:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (119, 4, 1, 1, 'Conjunctival swab C/S', '300.00', NULL, '', '', '2022-01-11 08:32:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (120, 2, 1, 1, 'GTT', '360.00', NULL, '', '', '2022-01-11 08:32:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (121, 2, 1, 1, 'Gamma GT', '500.00', NULL, '', '', '2022-01-11 16:35:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (122, 2, 1, 1, 'Globulin', '1000.00', NULL, '', '', '2022-01-11 17:44:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (123, 2, 1, 1, 'H. Pylori', '800.00', NULL, '', '', '2022-01-11 17:45:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (124, 11, 1, 1, 'FNAC', '1500.00', NULL, '', '', '2022-01-11 17:46:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (125, 2, 1, 1, 'HDL', '500.00', NULL, '', '', '2022-01-11 17:47:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (126, 11, 1, 1, 'FNAC Collection', '500.00', NULL, '', '', '2022-01-11 17:48:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (127, 2, 1, 1, 'HbA1C', '1000.00', NULL, '', '', '2022-01-11 17:49:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (128, 11, 1, 1, 'Gastric Level aspirate (3 Sample)', '400.00', NULL, '', '', '2022-01-11 17:50:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (129, 3, 1, 1, 'Cytology', '500.00', NULL, '', '', '2022-01-11 17:50:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (130, 2, 1, 1, 'Iron', '600.00', NULL, '', '', '2022-01-11 17:50:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (131, 11, 1, 1, 'Gramstain', '200.00', NULL, '', '', '2022-01-11 17:50:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (132, 11, 1, 1, 'HVS for Gram Stain', '200.00', NULL, '', '', '2022-01-11 17:51:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (133, 11, 1, 1, 'HVS for R/E', '200.00', NULL, '', '', '2022-01-11 17:52:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (134, 11, 1, 1, 'MT (Mantoux Test)', '500.00', NULL, '', '', '2022-01-11 17:53:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (135, 3, 1, 1, 'PSA', '700.00', NULL, '', '', '2022-01-11 17:56:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (136, 11, 1, 1, 'Malignant Cell', '800.00', NULL, '', '', '2022-01-11 17:57:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (137, 11, 1, 1, 'Prostatic smear R/E', '200.00', NULL, '', '', '2022-01-11 17:57:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (138, 2, 1, 1, 'L.F.T (Liver Function Test with)', '1500.00', NULL, '', '', '2022-01-11 17:57:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (139, 3, 1, 1, 'PSA ( Elisa)', '1200.00', NULL, '', '', '2022-01-11 17:58:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (140, 11, 1, 1, 'Prostatic smear gram stain', '200.00', NULL, '', '', '2022-01-11 17:58:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (141, 3, 1, 1, 'Pap smear', '900.00', NULL, '', '', '2022-01-11 17:59:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (142, 11, 1, 1, 'Skin Scraping   R/E', '200.00', NULL, '', '', '2022-01-11 17:59:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (143, 11, 1, 1, 'Skin Scraping for Fungus', '800.00', NULL, '', '', '2022-01-11 17:59:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (144, 11, 1, 1, 'Sputum AFB', '200.00', NULL, '', '', '2022-01-11 18:00:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (145, 7, 1, 1, 'Anti HBs', '800.00', NULL, '', '', '2022-01-11 18:00:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (146, 11, 1, 1, 'Sputum AFB 2 samples', '400.00', NULL, '', '', '2022-01-11 18:01:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (147, 11, 1, 1, 'Sputum AFB 3 samples', '600.00', NULL, '', '', '2022-01-11 18:01:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (148, 7, 1, 1, 'Anti HcV', '600.00', NULL, '', '', '2022-01-11 18:02:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (149, 11, 1, 1, 'Sputum Gene Xpert', '4000.00', NULL, '', '', '2022-01-11 18:02:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (150, 11, 1, 1, 'Sputum for gramstain', '300.00', NULL, '', '', '2022-01-11 18:03:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (151, 11, 1, 1, 'T/A for ABF Staining', '200.00', NULL, '', '', '2022-01-11 18:03:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (152, 7, 1, 1, 'HBe - ab', '1100.00', NULL, '', '', '2022-01-11 18:04:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (153, 11, 1, 1, 'Urethra smear R/E', '200.00', NULL, '', '', '2022-01-11 18:04:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (154, 11, 1, 1, 'Urothral for Gram  Stain', '200.00', NULL, '', '', '2022-01-11 18:04:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (155, 7, 1, 1, 'HBe Ag', '1100.00', NULL, '', '', '2022-01-11 18:05:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (156, 2, 1, 1, '\"SGPT,SGOT,S.Bilirubin,HBsAg) LDL\"', '500.00', NULL, '', '', '2022-01-11 18:07:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (157, 7, 1, 1, 'HBsAg (Confirmatory)', '500.00', NULL, '', '', '2022-01-11 18:07:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (158, 7, 1, 1, 'HBsAg (ELISA)', '1200.00', NULL, '', '', '2022-01-11 18:08:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (159, 4, 1, 1, 'Ear swab C/S', '800.00', NULL, '', '', '2022-01-11 18:08:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (160, 2, 1, 1, 'LDL Cholesterol', '300.00', NULL, '', '', '2022-01-11 18:10:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (161, 4, 1, 1, 'Endocervical swab C/S', '800.00', NULL, '', '', '2022-01-11 18:11:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (162, 2, 1, 1, 'Lipid Profile', '1000.00', NULL, '', '', '2022-01-11 18:11:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (163, 2, 1, 1, 'OGTT', '600.00', NULL, '', '', '2022-01-11 18:12:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (164, 6, 1, 1, 'BT', '250.00', NULL, '', '', '2022-01-11 18:12:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (165, 8, 1, 1, 'Histopathology', '1100.00', NULL, '', '', '2022-01-11 18:13:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (166, 6, 1, 1, 'BT.CT', '500.00', NULL, '', '', '2022-01-11 18:13:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (167, 4, 1, 1, 'Eye swab C/S', '800.00', NULL, '', '', '2022-01-11 18:13:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (168, 2, 1, 1, 'Pleural Fluid', '400.00', NULL, '', '', '2022-01-11 18:14:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (169, 6, 1, 1, 'CBC', '600.00', NULL, '', '', '2022-01-11 18:14:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (170, 2, 1, 1, 'Prothrombin time', '1200.00', NULL, '', '', '2022-01-11 18:15:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (171, 4, 1, 1, 'Finger Print for C/S', '600.00', NULL, '', '', '2022-01-11 18:15:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (172, 6, 1, 1, 'CEC', '300.00', NULL, '', '', '2022-01-11 18:15:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (173, 4, 1, 1, 'HVS C/S', '800.00', NULL, '', '', '2022-01-11 18:16:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (174, 2, 1, 1, 'RBS', '150.00', NULL, '', '', '2022-01-11 18:16:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (175, 6, 1, 1, 'CT', '250.00', NULL, '', '', '2022-01-11 18:16:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (176, 4, 1, 1, 'Nasal swab C/S', '800.00', NULL, '', '', '2022-01-11 18:17:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (177, 2, 1, 1, 'RBS (Random Blood Sugar)', '200.00', NULL, '', '', '2022-01-11 18:17:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (178, 9, 1, 1, 'ANA', '1200.00', NULL, '', '', '2022-01-11 18:18:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (179, 6, 1, 1, 'Coombs test', '400.00', NULL, '', '', '2022-01-11 18:18:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (180, 4, 1, 1, 'PAPS C/S', '800.00', NULL, '', '', '2022-01-11 18:19:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (181, 2, 1, 1, 'S. Albumin', '500.00', NULL, '', '', '2022-01-11 18:19:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (182, 6, 1, 1, 'DC', '150.00', NULL, '', '', '2022-01-11 18:20:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (183, 4, 1, 1, 'Prostatic smear C/S', '600.00', NULL, '', '', '2022-01-11 18:20:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (184, 2, 1, 1, 'S. Alkaline Phosphatase', '500.00', NULL, '', '', '2022-01-11 18:20:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (185, 4, 1, 1, 'Pus C/S', '800.00', NULL, '', '', '2022-01-11 18:21:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (186, 2, 1, 1, 'S. Amonia', '900.00', NULL, '', '', '2022-01-11 18:21:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (187, 6, 1, 1, 'ESR', '200.00', NULL, '', '', '2022-01-11 18:21:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (188, 2, 1, 1, 'S. Amylase', '800.00', NULL, '', '', '2022-01-11 18:22:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (189, 4, 1, 1, 'Skin Scraping for C/S', '600.00', NULL, '', '', '2022-01-11 18:22:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (190, 9, 1, 1, 'Anti Cardiolipin IgG', '1500.00', NULL, '', '', '2022-01-11 18:22:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (191, 6, 1, 1, 'ESR tube', '45.00', NULL, '', '', '2022-01-11 18:23:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (192, 2, 1, 1, 'S. Bilirubin (Direct.InDirect)', '1200.00', NULL, '', '', '2022-01-11 18:23:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (193, 4, 1, 1, 'Sputum C/S', '600.00', NULL, '', '', '2022-01-11 18:24:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (194, 9, 1, 1, 'Anti Cardiolipin IgM', '1500.00', NULL, '', '', '2022-01-11 18:24:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (195, 2, 1, 1, 'S. Bilirubin Direct', '600.00', NULL, '', '', '2022-01-11 18:24:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (196, 4, 1, 1, 'Stool C/S', '800.00', NULL, '', '', '2022-01-11 18:24:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (197, 6, 1, 1, 'Electrophroses', '1400.00', NULL, '', '', '2022-01-11 18:25:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (198, 9, 1, 1, 'Anti DNA', '1000.00', NULL, '', '', '2022-01-11 18:25:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (199, 2, 1, 1, 'S. Bilirubin Indirect', '600.00', NULL, '', '', '2022-01-11 18:25:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (200, 4, 1, 1, 'Swab C/S with Gram Stain', '300.00', NULL, '', '', '2022-01-11 18:25:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (201, 6, 1, 1, 'Hb', '200.00', NULL, '', '', '2022-01-11 18:26:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (202, 2, 1, 1, 'S. Billirubin', '500.00', NULL, '', '', '2022-01-11 18:26:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (203, 2, 1, 1, 'S. Calcium', '600.00', NULL, '', '', '2022-01-11 18:27:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (204, 4, 1, 1, 'T/A For C/S', '600.00', NULL, '', '', '2022-01-11 18:27:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (205, 9, 1, 1, 'Anti MPO(P-ANCA)', '1500.00', NULL, '', '', '2022-01-11 18:27:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (206, 2, 1, 1, 'S. Cholesterol', '500.00', NULL, '', '', '2022-01-11 18:28:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (207, 9, 1, 1, 'Anti PR-3 (C-ANCA)', '1500.00', NULL, '', '', '2022-01-11 18:28:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (208, 6, 1, 1, 'ICT for Kala-Azar', '600.00', NULL, '', '', '2022-01-11 18:28:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (209, 2, 1, 1, 'S. Creatinine', '500.00', NULL, '', '', '2022-01-11 18:29:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (210, 4, 1, 1, 'Throat Swab C/S', '800.00', NULL, '', '', '2022-01-11 18:29:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (211, 9, 1, 1, 'Anti Phospholipid Screen', '1200.00', NULL, '', '', '2022-01-11 18:29:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (212, 6, 1, 1, 'Kala Jor', '500.00', NULL, '', '', '2022-01-11 18:29:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (213, 2, 1, 1, 'S. Lipase', '1200.00', NULL, '', '', '2022-01-11 18:29:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (214, 4, 1, 1, 'Umbilical swab C/S', '800.00', NULL, '', '', '2022-01-11 18:29:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (215, 9, 1, 1, 'Anti thyroid Anti body', '1000.00', NULL, '', '', '2022-01-11 18:30:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (216, 2, 1, 1, 'S. Lipid Profile', '1000.00', NULL, '', '', '2022-01-11 18:30:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (217, 6, 1, 1, 'MP (ICT)', '500.00', NULL, '', '', '2022-01-11 18:30:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (218, 4, 1, 1, 'Urethra smear C/S', '800.00', NULL, '', '', '2022-01-11 18:31:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (219, 2, 1, 1, 'S. Magnessium', '600.00', NULL, '', '', '2022-01-11 18:31:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (220, 9, 1, 1, 'B-hcG', '1500.00', NULL, '', '', '2022-01-11 18:31:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (221, 6, 1, 1, 'MP (Slide)', '500.00', NULL, '', '', '2022-01-11 18:31:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (222, 4, 1, 1, 'Urine C/S', '1500.00', NULL, '', '', '2022-01-11 18:32:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (223, 2, 1, 1, 'S. Phosphate', '400.00', NULL, '', '', '2022-01-11 18:32:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (224, 9, 1, 1, 'Cortisol', '1000.00', NULL, '', '', '2022-01-11 18:32:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (225, 6, 1, 1, 'PBF', '500.00', NULL, '', '', '2022-01-11 18:33:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (226, 4, 1, 1, 'Wound swab C/S', '600.00', NULL, '', '', '2022-01-11 18:33:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (227, 2, 1, 1, 'S. Total Acid Phosphate', '500.00', NULL, '', '', '2022-01-11 18:33:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (228, 9, 1, 1, 'D-Dimer', '1200.00', NULL, '', '', '2022-01-11 18:33:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (229, 6, 1, 1, 'PCV/HCT', '500.00', NULL, '', '', '2022-01-11 18:34:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (230, 2, 1, 1, 'S. Total Protein', '300.00', NULL, '', '', '2022-01-11 18:34:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (231, 9, 1, 1, 'Estrodiol', '1000.00', NULL, '', '', '2022-01-11 18:34:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (232, 6, 1, 1, 'Platelet count', '500.00', NULL, '', '', '2022-01-11 18:35:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (233, 2, 1, 1, 'S. Triglycerides', '500.00', NULL, '', '', '2022-01-11 18:35:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (234, 9, 1, 1, 'Free T3', '700.00', NULL, '', '', '2022-01-11 18:36:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (235, 6, 1, 1, 'RBC Parameters', '100.00', NULL, '', '', '2022-01-11 18:36:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (236, 2, 1, 1, 'S. Urea', '500.00', NULL, '', '', '2022-01-11 18:36:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (237, 9, 1, 1, 'Free T4', '700.00', NULL, '', '', '2022-01-11 18:37:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (238, 2, 1, 1, 'S. Uric Acid', '500.00', NULL, '', '', '2022-01-11 18:37:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (239, 6, 1, 1, 'Reticulocyte count', '150.00', NULL, '', '', '2022-01-11 18:37:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (240, 9, 1, 1, 'Growth Hormone', '1800.00', NULL, '', '', '2022-01-11 18:38:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (241, 2, 1, 1, 'S. Urine', '100.00', NULL, '', '', '2022-01-11 18:38:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (242, 6, 1, 1, 'Rh- Antibody', '1200.00', NULL, '', '', '2022-01-11 18:39:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (243, 9, 1, 1, 'HDV Ab', '1000.00', NULL, '', '', '2022-01-11 18:39:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (244, 2, 1, 1, 'S.Vitamin-D3 Level', '2500.00', NULL, '', '', '2022-01-11 18:39:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (245, 2, 1, 1, 'SGOT (AST)', '500.00', NULL, '', '', '2022-01-11 18:40:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (246, 9, 1, 1, 'Iron Profile', '3000.00', NULL, '', '', '2022-01-11 18:40:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (247, 2, 1, 1, 'SGPT (ALT)', '500.00', NULL, '', '', '2022-01-11 18:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (248, 6, 1, 1, 'Sputum Eosinophil', '200.00', NULL, '', '', '2022-01-11 18:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (249, 9, 1, 1, 'Myoglobin', '2000.00', NULL, '', '', '2022-01-11 18:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (250, 2, 1, 1, 'TCO2', '250.00', NULL, '', '', '2022-01-11 18:42:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (251, 9, 1, 1, 'Oestrogen', '800.00', NULL, '', '', '2022-01-11 18:42:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (252, 6, 1, 1, 'Syringe', '5.00', NULL, '', '', '2022-01-11 18:42:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (253, 2, 1, 1, 'TIBC', '900.00', NULL, '', '', '2022-01-11 18:42:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (255, 6, 1, 1, 'TC', '150.00', NULL, '', '', '2022-01-11 18:43:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (256, 2, 1, 1, 'TROPONIN-I', '600.00', NULL, '', '', '2022-01-11 18:43:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (257, 2, 1, 1, 'Total Cholesterol', '400.00', NULL, '', '', '2022-01-11 18:44:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (258, 6, 1, 1, 'TC. DC', '300.00', NULL, '', '', '2022-01-11 18:44:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (259, 2, 1, 1, 'Total Protein', '500.00', NULL, '', '', '2022-01-11 18:45:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (260, 2, 1, 1, 'UTV (Urine Total Volume)', '100.00', NULL, '', '', '2022-01-11 18:45:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (261, 6, 1, 1, 'Urine M/E', '600.00', NULL, '', '', '2022-01-11 18:46:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (262, 9, 1, 1, 'Para Thyroid Hormone (PTH)', '1000.00', NULL, '', '', '2022-01-11 18:46:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (264, 9, 1, 1, 'Progesterone', '1200.00', NULL, '', '', '2022-01-11 18:47:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (265, 2, 1, 1, 'Vitamin-D', '2500.00', NULL, '', '', '2022-01-11 18:48:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (266, 9, 1, 1, 'S. Basal Cortisol', '1000.00', NULL, '', '', '2022-01-11 18:48:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (267, 9, 1, 1, 'S. FSH', '1200.00', NULL, '', '', '2022-01-11 18:49:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (268, 9, 1, 1, 'S. Ferritine', '1200.00', NULL, '', '', '2022-01-11 18:50:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (269, 9, 1, 1, 'S. LH', '1200.00', NULL, '', '', '2022-01-11 18:51:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (270, 9, 1, 1, 'S. Oestrogen', '1500.00', NULL, '', '', '2022-01-11 18:52:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (271, 9, 1, 1, 'S. Prolactin', '1500.00', NULL, '', '', '2022-01-11 18:53:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (272, 9, 1, 1, 'S. Testosteron', '1200.00', NULL, '', '', '2022-01-11 18:54:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (273, 9, 1, 1, 'T3', '700.00', NULL, '', '', '2022-01-11 18:55:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (274, 9, 1, 1, 'T3, T4, TSH', '2200.00', NULL, '', '', '2022-01-11 18:56:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (275, 9, 1, 1, 'T4', '700.00', NULL, '', '', '2022-01-11 18:57:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (276, 9, 1, 1, 'TH', '800.00', NULL, '', '', '2022-01-11 18:57:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (278, 9, 1, 1, 'TSH', '800.00', NULL, '', '', '2022-01-11 19:00:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (279, 9, 1, 1, 'Testosterone', '1100.00', NULL, '', '', '2022-01-11 19:01:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (280, 9, 1, 1, 'Thyroglobulin', '1500.00', NULL, '', '', '2022-01-11 19:02:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (281, 9, 1, 1, 'Trepnonema Pallidum [TP]', '1000.00', NULL, '', '', '2022-01-11 19:02:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (282, 19, 1, 1, 'TestCharge', '1.00', NULL, '', '', '2022-01-12 09:57:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (283, 19, 1, 1, 'USG of Lower abdomen Early Pregnency', '500.00', NULL, '', '', '2022-01-12 10:27:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (284, 20, 1, 1, 'X-Ray CXR L/V', '600.00', NULL, '', '', '2022-01-12 10:33:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (285, 20, 1, 1, 'X-Ray CXR Lt L/V', '600.00', NULL, '', '', '2022-01-12 10:35:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (286, 20, 1, 1, 'X-Ray Lt wrist joint B/V', '600.00', NULL, '', '', '2022-01-12 10:35:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (288, 20, 1, 1, 'X-Ray CXR O/V (Ribs) ', '600.00', NULL, '', '', '2022-01-12 10:36:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (289, 20, 1, 1, 'X-Ray CXR P/A', '600.00', NULL, '', '', '2022-01-12 10:38:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (290, 19, 1, 1, 'USG of Chest', '500.00', NULL, '', '', '2022-01-12 10:39:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (291, 20, 1, 1, 'X-Ray CXR Rt L/V', '600.00', NULL, '', '', '2022-01-12 10:39:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (292, 20, 1, 1, 'X-Ray Lumber Spine Lateral View ', '300.00', NULL, '', '', '2022-01-12 10:39:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (293, 20, 1, 1, 'X-Ray Cervical Spine A/P view ', '600.00', NULL, '', '', '2022-01-12 10:40:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (294, 20, 1, 1, 'X-Ray Lumber SpineB/V (Digital) ', '350.00', NULL, '', '', '2022-01-12 10:41:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (295, 19, 1, 1, 'USG of HBS', '400.00', NULL, '', '', '2022-01-12 10:41:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (296, 20, 1, 1, 'X-Ray Cervical Spine B/V', '900.00', NULL, '', '', '2022-01-12 10:41:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (297, 19, 1, 1, 'USG of Head', '900.00', NULL, '', '', '2022-01-12 10:45:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (298, 20, 1, 1, 'X-Ray Cervical Spine B/V Digital ', '600.00', NULL, '', '', '2022-01-12 10:45:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (299, 20, 1, 1, 'X-Ray Mandible B/V', '800.00', NULL, '', '', '2022-01-12 10:46:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (300, 19, 1, 1, 'USG of Inguinl Region', '1300.00', NULL, '', '', '2022-01-12 10:46:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (301, 20, 1, 1, 'X-Ray Cervical Spine Lateral view', '300.00', NULL, '', '', '2022-01-12 10:47:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (302, 19, 1, 1, 'USG of KUB Female', '600.00', NULL, '', '', '2022-01-12 10:47:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (303, 20, 1, 1, 'X-Ray Mandible L/V', '400.00', NULL, '', '', '2022-01-12 10:48:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (304, 20, 1, 1, 'X-Ray Cervical spine flexion and extension', '500.00', NULL, '', '', '2022-01-12 10:48:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (305, 19, 1, 1, 'USG of KUB Male', '600.00', NULL, '', '', '2022-01-12 10:48:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (306, 20, 1, 1, 'X-Ray Mandible Lateral View ', '300.00', NULL, '', '', '2022-01-12 10:49:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (307, 19, 1, 1, 'USG of Kub with lower abdomen Female', '900.00', NULL, '', '', '2022-01-12 10:49:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (308, 20, 1, 1, 'X-Ray Chest A/P Lateral View', '700.00', NULL, '', '', '2022-01-12 10:49:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (309, 19, 1, 1, 'USG of Kub with lower abdomen Male', '900.00', NULL, '', '', '2022-01-12 10:50:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (310, 20, 1, 1, 'X-Ray Chest A/P Supine ', '400.00', NULL, '', '', '2022-01-12 10:50:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (311, 20, 1, 1, 'X-Ray Mandible P/A view', '400.00', NULL, '', '', '2022-01-12 10:50:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (312, 19, 1, 1, 'USG of Lower abdomen Female', '600.00', NULL, '', '', '2022-01-12 10:51:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (313, 20, 1, 1, 'X-Ray Chest A/P for Ribs ', '400.00', NULL, '', '', '2022-01-12 10:51:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (314, 19, 1, 1, 'USG of Lower abdomen Female (2D)', '500.00', NULL, '', '', '2022-01-12 10:51:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (315, 20, 1, 1, 'X-Ray Mastoid townes view ', '600.00', NULL, '', '', '2022-01-12 10:52:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (316, 20, 1, 1, 'X-Ray Chest A/P view', '600.00', NULL, '', '', '2022-01-12 10:52:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (317, 19, 1, 1, 'USG of Lower abdomen Male', '600.00', NULL, '', '', '2022-01-12 10:52:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (318, 20, 1, 1, 'X-Ray Chest Lt Posterior obique (LPO)', '400.00', NULL, '', '', '2022-01-12 10:53:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (319, 19, 1, 1, 'USG of Molar Pregnancy', '2500.00', NULL, '', '', '2022-01-12 10:53:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (320, 19, 1, 1, 'USG of P/P', '500.00', NULL, '', '', '2022-01-12 10:55:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (321, 20, 1, 1, 'X-Ray Chest P/A Lateral Decubitus View ', '700.00', NULL, '', '', '2022-01-12 10:55:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (322, 20, 1, 1, 'X-Ray Mastoyed townes', '400.00', NULL, '', '', '2022-01-12 10:55:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (323, 20, 1, 1, 'X-Ray Chest P/A View', '600.00', NULL, '', '', '2022-01-12 10:56:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (324, 19, 1, 1, 'USG of Pregnancy Profile (4D)', '800.00', NULL, '', '', '2022-01-12 10:56:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (325, 20, 1, 1, 'X-Ray D/S A/P ', '400.00', NULL, '', '', '2022-01-12 10:57:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (326, 20, 1, 1, 'X-Ray D/S B/V ', '800.00', NULL, '', '', '2022-01-12 10:58:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (327, 20, 1, 1, 'X-Ray Maxilla Lateral oblique view ', '300.00', NULL, '', '', '2022-01-12 10:58:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (328, 19, 1, 1, 'USG of Pregnancy Profile With Anomaly Scan', '3000.00', NULL, '', '', '2022-01-12 10:58:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (329, 20, 1, 1, 'X-Ray D/S L/V', '400.00', NULL, '', '', '2022-01-12 11:00:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (330, 19, 1, 1, 'USG of Pregnency Profile', '600.00', NULL, '', '', '2022-01-12 11:00:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (331, 20, 1, 1, 'X-Ray Nasal bone lateral view', '600.00', NULL, '', '', '2022-01-12 11:00:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (332, 20, 1, 1, 'X-Ray Dental one film ', '120.00', NULL, '', '', '2022-01-12 11:01:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (333, 19, 1, 1, 'USG of Reproductive organ Female', '900.00', NULL, '', '', '2022-01-12 11:01:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (334, 20, 1, 1, 'X-Ray Nasopharynx Lateral view ', '600.00', NULL, '', '', '2022-01-12 11:01:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (335, 20, 1, 1, 'X-Ray Dental three film ', '360.00', NULL, '', '', '2022-01-12 11:03:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (336, 20, 1, 1, 'X-Ray Neck A/P', '400.00', NULL, '', '', '2022-01-12 11:03:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (337, 20, 1, 1, 'X-Ray Dental two film ', '240.00', NULL, '', '', '2022-01-12 11:03:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (338, 20, 1, 1, 'X-Ray Dorsal Spine B/V', '800.00', NULL, '', '', '2022-01-12 11:04:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (339, 20, 1, 1, 'X-Ray Dorsal Spine A/P view', '300.00', NULL, '', '', '2022-01-12 11:05:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (340, 20, 1, 1, 'X-Ray Sternum Lateral view', '300.00', NULL, '', '', '2022-01-12 11:06:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (341, 20, 1, 1, 'X-Ray Dorsal Spine Lateral view ', '300.00', NULL, '', '', '2022-01-12 11:06:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (342, 20, 1, 1, 'X-Ray Sternum oblique view', '400.00', NULL, '', '', '2022-01-12 11:07:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (343, 20, 1, 1, 'X-Ray Dorso Lumber Spine', '600.00', NULL, '', '', '2022-01-12 11:07:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (344, 19, 1, 1, 'USG of Scrotum', '900.00', NULL, '', '', '2022-01-12 11:07:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (345, 20, 1, 1, 'X-Ray Neck A/P', '300.00', NULL, '', '', '2022-01-12 11:07:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (346, 20, 1, 1, 'X-Ray Styloid Proces B/V', '400.00', NULL, '', '', '2022-01-12 11:08:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (347, 20, 1, 1, 'X-Ray Dorso-Lumber A/P view ', '300.00', NULL, '', '', '2022-01-12 11:08:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (348, 19, 1, 1, 'USG of Testis', '900.00', NULL, '', '', '2022-01-12 11:08:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (349, 20, 1, 1, 'X-Ray Throat Lateral View', '400.00', NULL, '', '', '2022-01-12 11:08:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (350, 20, 1, 1, 'X-Ray Neck B/V', '800.00', NULL, '', '', '2022-01-12 11:09:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (351, 19, 1, 1, 'USG of Thyroid', '1300.00', NULL, '', '', '2022-01-12 11:09:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (352, 20, 1, 1, 'X-Ray Dorso-Lumber B/V', '500.00', NULL, '', '', '2022-01-12 11:09:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (353, 20, 1, 1, 'X-Ray Throat P/A View', '400.00', NULL, '', '', '2022-01-12 11:09:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (354, 19, 1, 1, 'USG of Transvaginal sonography', '900.00', NULL, '', '', '2022-01-12 11:10:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (355, 20, 1, 1, 'X-Ray Neck L/V', '400.00', NULL, '', '', '2022-01-12 11:10:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (356, 20, 1, 1, 'X-Ray Throsis Spine B/V', '500.00', NULL, '', '', '2022-01-12 11:10:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (357, 20, 1, 1, 'X-Ray Dorso-Lumber Lateral view ', '300.00', NULL, '', '', '2022-01-12 11:10:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (358, 19, 1, 1, 'USG of Transvaginal sonography', '900.00', NULL, '', '', '2022-01-12 11:10:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (359, 20, 1, 1, 'X-ray L/S Spine B/V', '650.00', NULL, '', '', '2022-01-12 11:11:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (360, 19, 1, 1, 'USG of Upper abdomen Female', '600.00', NULL, '', '', '2022-01-12 11:11:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (361, 20, 1, 1, 'X-Ray Elbow with fore arm B/V ', '700.00', NULL, '', '', '2022-01-12 11:11:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (362, 20, 1, 1, 'X-Ray Neck Soft tissue L/V ', '400.00', NULL, '', '', '2022-01-12 11:11:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (363, 20, 1, 1, 'X-ray T.m Joint B/V', '600.00', NULL, '', '', '2022-01-12 11:12:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (364, 19, 1, 1, 'USG of Upper abdomen Male', '600.00', NULL, '', '', '2022-01-12 11:12:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (365, 20, 1, 1, 'X-Ray Face B/V', '400.00', NULL, '', '', '2022-01-12 11:12:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (366, 20, 1, 1, 'X-Ray OPG', '600.00', NULL, '', '', '2022-01-12 11:13:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (367, 19, 1, 1, 'USG of W/A with pregnancy', '700.00', NULL, '', '', '2022-01-12 11:13:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (368, 20, 1, 1, 'X-Ray Face Lateral View ', '400.00', NULL, '', '', '2022-01-12 11:13:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (369, 19, 1, 1, 'USG of Whole abdomen Female', '700.00', NULL, '', '', '2022-01-12 11:14:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (370, 20, 1, 1, 'X-Ray Face P/A View', '300.00', NULL, '', '', '2022-01-12 11:14:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (371, 19, 1, 1, 'USG of Whole abdomen Male', '700.00', NULL, '', '', '2022-01-12 11:15:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (372, 20, 1, 1, 'X-Ray Fore Arm B/V ', '600.00', NULL, '', '', '2022-01-12 11:15:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (373, 19, 1, 1, 'USG of Breast', '1300.00', NULL, '', '', '2022-01-12 11:16:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (374, 20, 1, 1, 'X-Ray Rt Knee A/P Standing View', '400.00', NULL, '', '', '2022-01-12 11:16:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (375, 20, 1, 1, 'X-Ray Hip joint B/V ', '800.00', NULL, '', '', '2022-01-12 11:16:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (376, 20, 1, 1, 'X-Ray Rt Knee joint B/V', '600.00', NULL, '', '', '2022-01-12 11:16:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (377, 20, 1, 1, 'X-Ray IVU', '1500.00', NULL, '', '', '2022-01-12 11:17:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (378, 20, 1, 1, 'X-Ray Rt Knee jt B/V', '600.00', NULL, '', '', '2022-01-12 11:17:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (379, 20, 1, 1, 'X-Ray IVU Let film one ', '300.00', NULL, '', '', '2022-01-12 11:17:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (380, 20, 1, 1, 'X-Ray Rt Leg B/V', '700.00', NULL, '', '', '2022-01-12 11:18:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (381, 20, 1, 1, 'X-Ray IVU Let film two ', '500.00', NULL, '', '', '2022-01-12 11:18:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (382, 19, 1, 1, 'USG of inguino - scrotal', '1300.00', NULL, '', '', '2022-01-12 11:18:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (383, 20, 1, 1, 'X-Ray Rt Leg B/V', '400.00', NULL, '', '', '2022-01-12 11:19:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (384, 20, 1, 1, 'X-Ray IVU/IVP', '1200.00', NULL, '', '', '2022-01-12 11:19:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (385, 19, 1, 1, 'utla', '600.00', NULL, '', '', '2022-01-12 11:19:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (386, 20, 1, 1, 'X-Ray Rt Leg finger B/V', '400.00', NULL, '', '', '2022-01-12 11:20:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (387, 20, 1, 1, 'X-Ray KUB', '600.00', NULL, '', '', '2022-01-12 11:20:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (388, 20, 1, 1, 'X-Ray KUB A/P view ', '500.00', NULL, '', '', '2022-01-12 11:21:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (389, 20, 1, 1, 'X-Ray Abdomen AP', '500.00', NULL, '', '', '2022-01-12 11:21:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (390, 20, 1, 1, 'X-Ray Rt Mastoid Townes View', '700.00', NULL, '', '', '2022-01-12 11:22:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (391, 20, 1, 1, 'X-Ray KUB B/V', '800.00', NULL, '', '', '2022-01-12 11:22:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (392, 20, 1, 1, 'X-Ray Abdomen EP', '550.00', NULL, '', '', '2022-01-12 11:22:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (393, 20, 1, 1, 'X-Ray Rt Middle finger B/V', '400.00', NULL, '', '', '2022-01-12 11:22:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (394, 20, 1, 1, 'X-Ray KUB L/V', '500.00', NULL, '', '', '2022-01-12 11:23:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (395, 20, 1, 1, 'X-Ray Rt Neck of Femur A/P View', '700.00', NULL, '', '', '2022-01-12 11:23:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (396, 20, 1, 1, 'X-Ray Atlas bone A/P View', '400.00', NULL, '', '', '2022-01-12 11:23:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (397, 20, 1, 1, 'X-Ray KUB errect ', '500.00', NULL, '', '', '2022-01-12 11:24:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (398, 20, 1, 1, 'X-Ray PNS B/V', '800.00', NULL, '', '', '2022-01-12 11:24:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (399, 20, 1, 1, 'X-Ray Rt Neck of Femur B/V', '700.00', NULL, '', '', '2022-01-12 11:24:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (400, 20, 1, 1, 'X-Ray KUB x-ray ', '500.00', NULL, '', '', '2022-01-12 11:25:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (401, 20, 1, 1, 'X-Ray Rt Patella P/A', '500.00', NULL, '', '', '2022-01-12 11:25:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (402, 20, 1, 1, 'X-Ray Atlas bone B/V', '400.00', NULL, '', '', '2022-01-12 11:25:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (403, 20, 1, 1, 'X-Ray Rt Patella Skyline View', '400.00', NULL, '', '', '2022-01-12 11:26:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (404, 20, 1, 1, 'X-Ray L/S A/P', '700.00', NULL, '', '', '2022-01-12 11:26:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (405, 20, 1, 1, 'X-Ray Rt Patella Skyline view', '450.00', NULL, '', '', '2022-01-12 11:26:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (406, 20, 1, 1, 'X-Ray BA ENAMA D/C', '2200.00', NULL, '', '', '2022-01-12 11:26:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (407, 20, 1, 1, 'X-Ray PNS OM View Digital ', '450.00', NULL, '', '', '2022-01-12 11:27:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (408, 20, 1, 1, 'X-Ray Rt Ring finger B/V', '400.00', NULL, '', '', '2022-01-12 11:27:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (409, 20, 1, 1, 'X-Ray BA Follow Through', '1500.00', NULL, '', '', '2022-01-12 11:28:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (410, 20, 1, 1, 'X-Ray Rt Scaphoid View', '400.00', NULL, '', '', '2022-01-12 11:28:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (411, 20, 1, 1, 'X-Ray PNS OM view', '600.00', NULL, '', '', '2022-01-12 11:28:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (412, 20, 1, 1, 'X-Ray Rt Scapula A/P View', '400.00', NULL, '', '', '2022-01-12 11:28:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (413, 20, 1, 1, 'X-Ray PNS OM view', '500.00', NULL, '', '', '2022-01-12 11:29:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (414, 20, 1, 1, 'X-Ray Pelvimetry A/P (Errect) ', '400.00', NULL, '', '', '2022-01-12 11:30:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (415, 20, 1, 1, 'X-Ray BA MEAL S/D', '1000.00', NULL, '', '', '2022-01-12 11:31:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (416, 20, 1, 1, 'X-Ray Rt Scapula B/V', '700.00', NULL, '', '', '2022-01-12 11:31:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (417, 20, 1, 1, 'X-Ray BA-Enema of Large GUT X-Ray', '1500.00', NULL, '', '', '2022-01-12 11:32:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (418, 20, 1, 1, 'X-Ray Rt Shoulder jt Swimmers View', '400.00', NULL, '', '', '2022-01-12 11:32:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (419, 20, 1, 1, 'X-Ray Rt Sole B/V View', '500.00', NULL, '', '', '2022-01-12 11:32:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (420, 20, 1, 1, 'X-Ray Pelvis A/P view', '600.00', NULL, '', '', '2022-01-12 11:32:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (421, 20, 1, 1, 'X-Ray Ba-Enema let film one', '400.00', NULL, '', '', '2022-01-12 11:32:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (422, 20, 1, 1, 'X-Ray Rt Sub-Mandibular gland Lateral oblique view', '500.00', NULL, '', '', '2022-01-12 11:33:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (423, 20, 1, 1, 'X-Ray Ba-follow through let film two', '700.00', NULL, '', '', '2022-01-12 11:34:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (424, 20, 1, 1, 'X-Ray Pelvis B/V ', '800.00', NULL, '', '', '2022-01-12 11:34:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (425, 20, 1, 1, 'X-Ray Bone Age L-1', '300.00', NULL, '', '', '2022-01-12 11:34:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (426, 20, 1, 1, 'X-Ray Rt T/F', '300.00', NULL, '', '', '2022-01-12 11:34:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (427, 20, 1, 1, 'X-Ray Pelvis L/V', '400.00', NULL, '', '', '2022-01-12 11:35:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (428, 20, 1, 1, 'X-Ray Both Knee Joint A/P View', '400.00', NULL, '', '', '2022-01-12 11:35:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (429, 20, 1, 1, 'X-Ray Plain Abdomen in E/P', '600.00', NULL, '', '', '2022-01-12 11:36:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (430, 20, 1, 1, 'X-Ray Both Knee Joint B/V', '600.00', NULL, '', '', '2022-01-12 11:36:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (431, 20, 1, 1, 'X-Ray Plain Abdomen in E/P Child ', '300.00', NULL, '', '', '2022-01-12 11:37:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (432, 20, 1, 1, 'X-Ray Both Knee jt A/P view', '400.00', NULL, '', '', '2022-01-12 11:37:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (433, 20, 1, 1, 'X-Ray Rt TM jt open mouth', '400.00', NULL, '', '', '2022-01-12 11:38:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (434, 20, 1, 1, 'X-Ray RGU + MCU', '1500.00', NULL, '', '', '2022-01-12 11:38:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (435, 20, 1, 1, 'X-Ray Both Mastoid Townes View', '500.00', NULL, '', '', '2022-01-12 11:38:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (436, 20, 1, 1, 'X-Ray Rt Zygomatic bone B/V', '400.00', NULL, '', '', '2022-01-12 11:39:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (437, 20, 1, 1, 'X-Ray Rt ankle and foot B/V', '400.00', NULL, '', '', '2022-01-12 11:39:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (438, 20, 1, 1, 'X-Ray RT Foot B/V', '600.00', NULL, '', '', '2022-01-12 11:39:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (439, 20, 1, 1, 'X-Ray Rt arm B/V', '600.00', NULL, '', '', '2022-01-12 11:40:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (440, 20, 1, 1, 'X-Ray Retrograde Cysto-Urethrogram (RCU)', '1500.00', NULL, '', '', '2022-01-12 11:40:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (441, 20, 1, 1, 'X-Ray Both clavicle A/P View', '300.00', NULL, '', '', '2022-01-12 11:40:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (442, 20, 1, 1, 'X-Ray Rt calcaneum Axial view', '400.00', NULL, '', '', '2022-01-12 11:41:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (443, 20, 1, 1, 'X-Ray Retrograde Cysto-Urethrogram with MCU ', '1500.00', NULL, '', '', '2022-01-12 11:41:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (444, 20, 1, 1, 'X-Ray Both hib joint', '600.00', NULL, '', '', '2022-01-12 11:41:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (445, 20, 1, 1, 'X-Ray Rt calcaneum B/V', '400.00', NULL, '', '', '2022-01-12 11:41:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (446, 20, 1, 1, 'X-Ray Retrograde Urethrogram (RGU)', '1000.00', NULL, '', '', '2022-01-12 11:42:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (447, 20, 1, 1, 'X-Ray Both hip A/P View', '300.00', NULL, '', '', '2022-01-12 11:42:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (448, 20, 1, 1, 'X-Ray Rt clavicle A/P view', '400.00', NULL, '', '', '2022-01-12 11:42:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (449, 20, 1, 1, 'X-Ray Rt foot B/V', '400.00', NULL, '', '', '2022-01-12 11:43:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (450, 20, 1, 1, 'X-Ray Both knee joint B/V', '900.00', NULL, '', '', '2022-01-12 11:43:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (451, 20, 1, 1, 'X-Ray Rt Mastoid Stenverse View ', '400.00', NULL, '', '', '2022-01-12 11:43:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (452, 20, 1, 1, 'X-Ray Rt fore arm B/V', '400.00', NULL, '', '', '2022-01-12 11:44:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (453, 20, 1, 1, 'X-Ray Rt Shoulder jt A/P View', '600.00', NULL, '', '', '2022-01-12 11:44:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (454, 20, 1, 1, 'X-Ray Both mastoid townes view', '500.00', NULL, '', '', '2022-01-12 11:45:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (455, 20, 1, 1, 'X-Ray Rt great toe B/V', '400.00', NULL, '', '', '2022-01-12 11:45:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (456, 20, 1, 1, 'X-Ray Rt hand B/V', '600.00', NULL, '', '', '2022-01-12 11:45:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (457, 20, 1, 1, 'X-Ray Both orbit P/A View', '300.00', NULL, '', '', '2022-01-12 11:45:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (458, 20, 1, 1, 'X-Ray Rt Ankle joint B/V ', '600.00', NULL, '', '', '2022-01-12 11:46:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (459, 20, 1, 1, 'X-Ray Rt index B/V', '400.00', NULL, '', '', '2022-01-12 11:46:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (460, 20, 1, 1, 'X-Ray C/S A/P', '400.00', NULL, '', '', '2022-01-12 11:46:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (461, 20, 1, 1, 'X-Ray Rt knee jt Tunnel view', '400.00', NULL, '', '', '2022-01-12 11:47:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (462, 20, 1, 1, 'X-Ray C/S B/V', '800.00', NULL, '', '', '2022-01-12 11:47:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (463, 20, 1, 1, 'X-Ray Rt orbit B/V', '400.00', NULL, '', '', '2022-01-12 11:47:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (464, 20, 1, 1, 'X-Ray Rt Ankle jt B/V', '600.00', NULL, '', '', '2022-01-12 11:47:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (465, 20, 1, 1, 'X-Ray C/S L/V', '600.00', NULL, '', '', '2022-01-12 11:48:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (466, 20, 1, 1, 'X-Ray Rt orbit oblique View', '500.00', NULL, '', '', '2022-01-12 11:48:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (467, 20, 1, 1, 'X-Ray Rt Ankle jt B/V', '450.00', NULL, '', '', '2022-01-12 11:49:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (468, 20, 1, 1, 'X-Ray Rt shoulder jt B/V', '600.00', NULL, '', '', '2022-01-12 11:49:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (469, 20, 1, 1, 'X-Ray Rt Elbow joint B/V', '600.00', NULL, '', '', '2022-01-12 11:50:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (470, 20, 1, 1, 'X-Ray Rt shoulder jt internal rotation', '500.00', NULL, '', '', '2022-01-12 11:51:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (471, 20, 1, 1, 'X-Ray Rt shoulder jt A/P view', '600.00', NULL, '', '', '2022-01-12 11:52:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (472, 20, 1, 1, 'X-Ray Rt Femar B/V', '400.00', NULL, '', '', '2022-01-12 11:52:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (473, 20, 1, 1, 'X-Ray Rt thumb B/V', '300.00', NULL, '', '', '2022-01-12 11:53:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (474, 20, 1, 1, 'X-Ray Rt Femur Including Hip A/P View ', '400.00', NULL, '', '', '2022-01-12 11:53:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (475, 20, 1, 1, 'X-Ray Rt wrist joint B/V', '600.00', NULL, '', '', '2022-01-12 11:53:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (476, 20, 1, 1, 'X-Ray Rt. Thigh B/V', '700.00', NULL, '', '', '2022-01-12 11:54:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (477, 20, 1, 1, 'X-Ray Rt Fore Arm B/V', '400.00', NULL, '', '', '2022-01-12 11:54:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (478, 20, 1, 1, 'X-Ray Rt.Wrist B/V', '300.00', NULL, '', '', '2022-01-12 11:55:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (479, 20, 1, 1, 'X-Ray Rt Hand B/V', '600.00', NULL, '', '', '2022-01-12 11:55:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (480, 20, 1, 1, 'X-Ray SI Joint/view', '800.00', NULL, '', '', '2022-01-12 11:55:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (481, 20, 1, 1, 'X-Ray Rt Hand finger B/V ', '400.00', NULL, '', '', '2022-01-12 11:56:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (482, 20, 1, 1, 'X-Ray Sacro-coccygeal A/P view', '300.00', NULL, '', '', '2022-01-12 11:56:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (483, 20, 1, 1, 'X-Ray Rt Heel B/V', '400.00', NULL, '', '', '2022-01-12 11:57:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (484, 20, 1, 1, 'X-Ray Sacro-coccygeal B/V', '500.00', NULL, '', '', '2022-01-12 11:57:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (485, 20, 1, 1, 'X-Ray Sacro-coccygeal Lateral', '300.00', NULL, '', '', '2022-01-12 11:58:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (486, 20, 1, 1, 'X-Ray Rt Hip A/P view ', '400.00', NULL, '', '', '2022-01-12 11:58:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (487, 20, 1, 1, 'X-Ray Rt Hip B/V', '700.00', NULL, '', '', '2022-01-12 11:59:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (488, 20, 1, 1, 'X-Ray Rt Hip joint B/V  ', '600.00', NULL, '', '', '2022-01-12 11:59:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (489, 20, 1, 1, 'X-Ray Sialogram of Lt Parotid gland', '1000.00', NULL, '', '', '2022-01-12 12:00:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (490, 20, 1, 1, 'X-Ray Sialogram of Lt Sub-Mandibular gland', '1000.00', NULL, '', '', '2022-01-12 12:01:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (491, 20, 1, 1, 'X-Ray Sialogram of Rt Sub-Mandibular gland', '1000.00', NULL, '', '', '2022-01-12 12:02:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (492, 20, 1, 1, 'X-Ray Sialogram of Rt parotid gland', '1000.00', NULL, '', '', '2022-01-12 12:06:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (493, 20, 1, 1, 'X-Ray Skull A/P', '400.00', NULL, '', '', '2022-01-12 12:06:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (494, 20, 1, 1, 'X-Ray Skull B/V', '760.00', NULL, '', '', '2022-01-12 12:07:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (495, 20, 1, 1, 'X-Ray Skull B/V', '800.00', NULL, '', '', '2022-01-12 12:08:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (496, 20, 1, 1, 'X-Ray Skull Lateral view', '400.00', NULL, '', '', '2022-01-12 12:09:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (497, 20, 1, 1, 'X-Ray Skull P/A view', '400.00', NULL, '', '', '2022-01-12 12:10:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (498, 20, 1, 1, 'X-Ray Skull SM view', '300.00', NULL, '', '', '2022-01-12 12:10:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (499, 20, 1, 1, 'X-Ray Spine A/P View (child)', '300.00', NULL, '', '', '2022-01-12 12:11:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (500, 20, 1, 1, 'X-Ray Spine B/V (child)', '500.00', NULL, '', '', '2022-01-12 12:12:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (501, 20, 1, 1, 'X-Ray Spine Lateral View (child)', '500.00', NULL, '', '', '2022-01-12 12:12:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (502, 20, 1, 1, 'X-Ray Sterno-clavicular jt P/A View', '400.00', NULL, '', '', '2022-01-12 12:15:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (503, 20, 1, 1, 'X-Ray Sternum A/P', '300.00', NULL, '', '', '2022-01-12 12:17:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (504, 20, 1, 1, 'X-Ray Sternum A/P view', '400.00', NULL, '', '', '2022-01-12 12:18:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (505, 20, 1, 1, 'X-Ray L/S B/V', '900.00', NULL, '', '', '2022-01-12 14:31:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (506, 20, 1, 1, 'X-Ray L/S L/V', '400.00', NULL, '', '', '2022-01-12 14:34:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (507, 20, 1, 1, 'X-Ray L/S Spine A/P View', '300.00', NULL, '', '', '2022-01-12 14:35:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (508, 20, 1, 1, 'X-Ray L/S Spine B/Oblique view', '500.00', NULL, '', '', '2022-01-12 14:37:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (509, 20, 1, 1, 'X-Ray L/S Spine B/V', '600.00', NULL, '', '', '2022-01-12 14:37:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (510, 20, 1, 1, 'X-Ray L/S Spine Flexion', '500.00', NULL, '', '', '2022-01-12 14:40:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (511, 20, 1, 1, 'X-Ray L/S Spine Lateral view', '600.00', NULL, '', '', '2022-01-12 14:40:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (512, 20, 1, 1, 'X-Ray L/S spine flexion and extension', '500.00', NULL, '', '', '2022-01-12 14:41:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (513, 20, 1, 1, 'X-Ray Lt Ankle B/V', '600.00', NULL, '', '', '2022-01-12 14:42:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (514, 20, 1, 1, 'X-Ray Lt Ankle joint B/V', '600.00', NULL, '', '', '2022-01-12 14:43:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (515, 20, 1, 1, 'X-Ray Lt Elbow joint B/V', '600.00', NULL, '', '', '2022-01-12 14:44:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (516, 20, 1, 1, 'X-Ray Lt Femar B/V', '400.00', NULL, '', '', '2022-01-12 14:45:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (517, 20, 1, 1, 'X-Ray Lt Femur Including Hip A/V View', '800.00', NULL, '', '', '2022-01-12 14:46:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (518, 20, 1, 1, 'X-Ray Lt Foot B/V', '600.00', NULL, '', '', '2022-01-12 14:46:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (519, 20, 1, 1, 'X-Ray Lt Fore Arm B/V', '400.00', NULL, '', '', '2022-01-12 14:47:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (520, 20, 1, 1, 'X-Ray Lt Hand B/V', '600.00', NULL, '', '', '2022-01-12 14:48:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (521, 20, 1, 1, 'X-Ray Lt Hand finger B/V', '400.00', NULL, '', '', '2022-01-12 14:49:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (522, 20, 1, 1, 'X-Ray Lt Heel B/V', '400.00', NULL, '', '', '2022-01-12 14:50:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (523, 20, 1, 1, 'X-Ray Lt Hip joint B/V', '600.00', NULL, '', '', '2022-01-12 14:51:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (524, 20, 1, 1, 'X-Ray Lt Knee B/V', '600.00', NULL, '', '', '2022-01-12 14:52:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (525, 20, 1, 1, 'X-Ray Lt Knee joint B/V', '600.00', NULL, '', '', '2022-01-12 14:53:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (526, 20, 1, 1, 'X-Ray Lt Leg B/V', '600.00', NULL, '', '', '2022-01-12 14:54:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (527, 20, 1, 1, 'X-Ray Lt Leg B/V', '700.00', NULL, '', '', '2022-01-12 14:55:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (528, 20, 1, 1, 'X-Ray Lt Leg finger B/V', '400.00', NULL, '', '', '2022-01-12 14:56:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (529, 20, 1, 1, 'X-Ray Lt Little finger B/V', '400.00', NULL, '', '', '2022-01-12 14:57:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (530, 20, 1, 1, 'X-Ray Lt Mastoid Stenverse View', '500.00', NULL, '', '', '2022-01-12 14:58:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (531, 20, 1, 1, 'X-Ray Lt Mastoid Townes View', '700.00', NULL, '', '', '2022-01-12 14:59:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (532, 20, 1, 1, 'X-Ray Lt Neck of Femur A/P View', '400.00', NULL, '', '', '2022-01-12 15:00:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (533, 20, 1, 1, 'X-Ray Lt Neck of Femur B/V', '700.00', NULL, '', '', '2022-01-12 15:01:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (534, 20, 1, 1, 'X-Ray Lt Patella P/A', '400.00', NULL, '', '', '2022-01-12 15:02:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (535, 20, 1, 1, 'X-Ray Lt Patella Skyline view', '400.00', NULL, '', '', '2022-01-12 15:03:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (536, 20, 1, 1, 'X-Ray Lt Ring finger B/V', '400.00', NULL, '', '', '2022-01-12 15:04:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (537, 20, 1, 1, 'X-Ray Lt Shouder jt Swimmers View', '400.00', NULL, '', '', '2022-01-12 15:05:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (538, 20, 1, 1, 'X-Ray Lt Shoulder jt B/V', '600.00', NULL, '', '', '2022-01-12 15:07:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (539, 20, 1, 1, 'X-Ray Lt Thigh B/V', '600.00', NULL, '', '', '2022-01-12 15:07:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (540, 20, 1, 1, 'X-Ray Lt Wrist jt B/V', '600.00', NULL, '', '', '2022-01-12 15:08:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (541, 20, 1, 1, 'X-Ray Lt ankle and foot B/V', '400.00', NULL, '', '', '2022-01-12 15:09:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (543, 20, 1, 1, 'X-Ray Lt arm B/V', '400.00', NULL, '', '', '2022-01-12 15:12:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (544, 20, 1, 1, 'X-Ray Lt calcaneum Axial view', '400.00', NULL, '', '', '2022-01-12 15:12:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (545, 20, 1, 1, 'X-Ray Lt calcaneum B/V', '400.00', NULL, '', '', '2022-01-12 15:13:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (546, 20, 1, 1, 'X-Ray Lt cavicle B/V', '500.00', NULL, '', '', '2022-01-12 15:15:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (547, 20, 1, 1, 'X-Ray Lt clavicle A/P view', '300.00', NULL, '', '', '2022-01-12 15:15:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (548, 20, 1, 1, 'X-Ray Lt elbow jt B/V', '600.00', NULL, '', '', '2022-01-12 15:16:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (552, 20, 1, 1, 'X-Ray Lt knee jt tunnel view', '400.00', NULL, '', '', '2022-01-12 15:28:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (553, 20, 1, 1, 'X-Ray Lt orbit  oblique View', '400.00', NULL, '', '', '2022-01-12 15:30:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (554, 20, 1, 1, 'X-Ray Lt orbit B/V', '500.00', NULL, '', '', '2022-01-12 15:31:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (555, 21, 1, 1, 'Ambulance Charge', '5000.00', NULL, '', '', '2022-01-12 18:02:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (556, 23, 1, 1, 'Appendicectomy', '6000.00', NULL, '', '', '2022-01-12 18:10:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (557, 24, 1, 1, 'Secondary Stitch with Catamine', '3000.00', NULL, '', '', '2022-01-12 18:11:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (558, 23, 1, 1, 'Bartholine Abcess (GA)', '5000.00', NULL, '', '', '2022-01-12 18:11:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (559, 23, 1, 1, 'Piles', '6000.00', NULL, '', '', '2022-01-12 18:12:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (560, 23, 1, 1, 'Bartholine CYST (GA)', '5000.00', NULL, '', '', '2022-01-12 18:12:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (561, 25, 1, 1, 'Gland Biopsy', '4000.00', NULL, '', '', '2022-01-12 18:12:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (562, 24, 1, 1, 'Vaginal Delevery', '1000.00', NULL, '', '', '2022-01-12 18:13:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (563, 25, 1, 1, 'Hydrocyl', '2500.00', NULL, '', '', '2022-01-12 18:13:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (564, 23, 1, 1, 'Pterygium', '5000.00', NULL, '', '', '2022-01-12 18:14:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (565, 23, 1, 1, 'Biopsy Surgery', '7000.00', NULL, '', '', '2022-01-12 18:14:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (566, 24, 1, 1, 'Vaginal Delevery (with Episiotomy)', '1500.00', NULL, '', '', '2022-01-12 18:14:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (567, 25, 1, 1, 'Hysterectomy', '4000.00', NULL, '', '', '2022-01-12 18:14:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (568, 23, 1, 1, 'Breast Abses (L)/A', '4000.00', NULL, '', '', '2022-01-12 18:15:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (569, 24, 1, 1, 'Retained Placenta', '1000.00', NULL, '', '', '2022-01-12 18:15:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (570, 24, 1, 1, 'Vaginal Histrictomy', '12000.00', NULL, '', '', '2022-01-12 18:15:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (571, 25, 1, 1, 'Incissional Hernia', '3000.00', NULL, '', '', '2022-01-12 18:16:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (572, 23, 1, 1, 'Breast Lump/Tumour', '8000.00', NULL, '', '', '2022-01-12 18:16:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (573, 25, 1, 1, 'Abdominal Histectomy (Single Surgeon)', '8000.00', NULL, '', '', '2022-01-12 18:16:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (574, 25, 1, 1, 'Kidney urinary stone', '4000.00', NULL, '', '', '2022-01-12 18:17:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (575, 24, 1, 1, 'Secondary Stitch with Catamine', '3000.00', NULL, '', '', '2022-01-12 18:17:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (576, 23, 1, 1, 'Herniotomy', '7500.00', NULL, '', '', '2022-01-12 18:17:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (577, 25, 1, 1, 'Appendicectomy', '2700.00', NULL, '', '', '2022-01-12 18:18:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (578, 25, 1, 1, 'L U C S', '3200.00', NULL, '', '', '2022-01-12 18:18:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (579, 23, 1, 1, 'Hydrocill', '2700.00', NULL, '', '', '2022-01-12 18:18:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (580, 25, 1, 1, 'Laminectomy', '4000.00', NULL, '', '', '2022-01-12 18:19:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (581, 24, 1, 1, 'Vaginal Delevery', '1000.00', NULL, '', '', '2022-01-12 18:19:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (582, 25, 1, 1, 'Biopsy', '2500.00', NULL, '', '', '2022-01-12 18:19:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (583, 23, 1, 1, 'Piles', '6000.00', NULL, '', '', '2022-01-12 18:19:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (584, 25, 1, 1, 'Laparotomy Single Cons.', '8000.00', NULL, '', '', '2022-01-12 18:19:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (585, 25, 1, 1, 'Catheterization', '700.00', NULL, '', '', '2022-01-12 18:20:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (586, 24, 1, 1, 'Vaginal Delevery (with Episiotomy)', '1500.00', NULL, '', '', '2022-01-12 18:20:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (587, 25, 1, 1, 'Laparscopy', '4000.00', NULL, '', '', '2022-01-12 18:20:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (588, 23, 1, 1, 'Pterygium', '5000.00', NULL, '', '', '2022-01-12 18:20:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (589, 25, 1, 1, 'Chest Aspiration (Local)', '1000.00', NULL, '', '', '2022-01-12 18:21:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (590, 25, 1, 1, 'Lapchole', '12000.00', NULL, '', '', '2022-01-12 18:21:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (591, 25, 1, 1, 'Lapcoly', '4000.00', NULL, '', '', '2022-01-12 18:22:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (592, 25, 1, 1, 'Chest Aspiration(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-12 18:23:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (593, 24, 1, 1, 'Vaginal Histrictomy', '12000.00', NULL, '', '', '2022-01-12 18:23:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (594, 25, 1, 1, 'Lapratomy', '4000.00', NULL, '', '', '2022-01-12 18:23:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (595, 25, 1, 1, 'Lipoma', '2500.00', NULL, '', '', '2022-01-12 18:24:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (596, 25, 1, 1, 'Circumcession(Anaesthesia)', '1000.00', NULL, '', '', '2022-01-12 18:24:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (597, 25, 1, 1, 'Abdominal Histectomy (Single Surgeon)', '8000.00', NULL, '', '', '2022-01-12 18:25:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (598, 22, 1, 1, 'Adenoidectomy', '6000.00', NULL, '', '', '2022-01-12 18:25:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (599, 25, 1, 1, 'M. R (local)', '700.00', NULL, '', '', '2022-01-12 18:25:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (600, 25, 1, 1, 'Circumcession(Local)', '700.00', NULL, '', '', '2022-01-12 18:25:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (601, 25, 1, 1, 'Mastaidioactomy', '4000.00', NULL, '', '', '2022-01-12 18:26:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (602, 25, 1, 1, 'Appendicectomy', '2700.00', NULL, '', '', '2022-01-12 18:26:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (603, 25, 1, 1, 'Cistostopy', '2000.00', NULL, '', '', '2022-01-12 18:26:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (604, 22, 1, 1, 'Amalgum Filling', '350.00', NULL, '', '', '2022-01-12 18:26:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (605, 25, 1, 1, 'Mastectomy', '4000.00', NULL, '', '', '2022-01-12 18:27:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (606, 25, 1, 1, 'Dilatation(Anaesthesia)', '2000.00', NULL, '', '', '2022-01-12 18:27:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (607, 22, 1, 1, 'Branchial Cyst - 1', '11000.00', NULL, '', '', '2022-01-12 18:27:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (608, 25, 1, 1, 'Nephroelithotomy', '4000.00', NULL, '', '', '2022-01-12 18:28:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (609, 25, 1, 1, 'Biopsy', '2500.00', NULL, '', '', '2022-01-12 18:28:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (610, 22, 1, 1, 'Ear Wash', '500.00', NULL, '', '', '2022-01-12 18:28:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (611, 25, 1, 1, 'Dilatation(Local)', '700.00', NULL, '', '', '2022-01-12 18:28:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (612, 25, 1, 1, 'OT Charge Including Assist', '1500.00', NULL, '', '', '2022-01-12 18:28:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (613, 22, 1, 1, 'Nose Surgery', '5500.00', NULL, '', '', '2022-01-12 18:29:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (614, 25, 1, 1, 'Ovarian Cyst', '4000.00', NULL, '', '', '2022-01-12 18:29:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (615, 25, 1, 1, 'Excision of the Encephalocele', '12000.00', NULL, '', '', '2022-01-12 18:29:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (616, 25, 1, 1, 'Catheterization', '700.00', NULL, '', '', '2022-01-12 18:29:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (617, 25, 1, 1, 'Poly Pectomy', '4000.00', NULL, '', '', '2022-01-12 18:30:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (618, 22, 1, 1, 'Nose Wash', '500.00', NULL, '', '', '2022-01-12 18:30:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (619, 25, 1, 1, 'Fistula(Perianal)', '2500.00', NULL, '', '', '2022-01-12 18:30:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (620, 25, 1, 1, 'SMR/SMD', '1700.00', NULL, '', '', '2022-01-12 18:31:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (621, 25, 1, 1, 'Chest Aspiration (Local)', '1000.00', NULL, '', '', '2022-01-12 18:31:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (622, 22, 1, 1, 'Nose Wash (LA)', '2000.00', NULL, '', '', '2022-01-12 18:31:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (623, 25, 1, 1, 'Gallbladder', '4000.00', NULL, '', '', '2022-01-12 18:32:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (624, 25, 1, 1, 'Skin grfting', '4000.00', NULL, '', '', '2022-01-12 18:32:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (625, 22, 1, 1, 'Septoplasty + BAWO', '7000.00', NULL, '', '', '2022-01-12 18:32:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (626, 25, 1, 1, 'Gland Biopsy', '4000.00', NULL, '', '', '2022-01-12 18:33:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (627, 25, 1, 1, 'Stich (local)', '700.00', NULL, '', '', '2022-01-12 18:33:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (628, 22, 1, 1, 'Septoplasty+SMD', '7000.00', NULL, '', '', '2022-01-12 18:33:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (629, 25, 1, 1, 'Chest Aspiration(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-12 18:33:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (630, 25, 1, 1, 'Stich(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-12 18:34:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (631, 22, 1, 1, 'Tonsilities', '6000.00', NULL, '', '', '2022-01-12 18:34:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (632, 25, 1, 1, 'Hydrocyl', '2500.00', NULL, '', '', '2022-01-12 18:35:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (633, 25, 1, 1, 'TURP', '4000.00', NULL, '', '', '2022-01-12 18:35:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (634, 25, 1, 1, 'Circumcession(Anaesthesia)', '1000.00', NULL, '', '', '2022-01-12 18:35:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (635, 25, 1, 1, 'Tendor Repair', '7000.00', NULL, '', '', '2022-01-12 18:36:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (636, 25, 1, 1, 'Circumcession(Local)', '700.00', NULL, '', '', '2022-01-12 18:37:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (637, 25, 1, 1, 'Cistostopy', '2000.00', NULL, '', '', '2022-01-12 18:39:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (638, 25, 1, 1, 'Dilatation(Anaesthesia)', '2000.00', NULL, '', '', '2022-01-12 18:41:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (639, 25, 1, 1, 'Dilatation(Local)', '700.00', NULL, '', '', '2022-01-12 18:43:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (640, 25, 1, 1, 'Excision of the Encephalocele', '12000.00', NULL, '', '', '2022-01-12 18:44:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (641, 25, 1, 1, 'Fistula(Perianal)', '2500.00', NULL, '', '', '2022-01-12 18:46:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (642, 25, 1, 1, 'Gallbladder', '4000.00', NULL, '', '', '2022-01-12 18:47:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (643, 26, 1, 1, 'Abcess Drain (LA)', '1000.00', NULL, '', '', '2022-01-12 19:52:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (644, 26, 1, 1, 'Abcess Drain with GA', '5000.00', NULL, '', '', '2022-01-12 19:53:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (645, 26, 1, 1, 'Circumcision (Adult)', '2000.00', NULL, '', '', '2022-01-12 19:55:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (646, 26, 1, 1, 'Circumcision (GA)', '4000.00', NULL, '', '', '2022-01-12 19:56:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (647, 26, 1, 1, 'Circumcision (LA)', '1500.00', NULL, '', '', '2022-01-12 19:57:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (648, 26, 1, 1, 'Consultant Fee', '1000.00', NULL, '', '', '2022-01-12 19:58:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (649, 26, 1, 1, 'Drain Abses', '500.00', NULL, '', '', '2022-01-12 19:59:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (650, 26, 1, 1, 'ECT', '2500.00', NULL, '', '', '2022-01-12 20:00:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (651, 26, 1, 1, 'Excision Biopsy (SA)', '3500.00', NULL, '', '', '2022-01-12 20:03:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (652, 26, 1, 1, 'Excision Tissue', '1500.00', NULL, '', '', '2022-01-12 20:04:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (653, 26, 1, 1, 'Fibroadinoma', '10000.00', NULL, '', '', '2022-01-12 20:05:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (654, 26, 1, 1, 'Fissurcetomy', '6000.00', NULL, '', '', '2022-01-12 20:06:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (655, 26, 1, 1, 'Foreign Body Removal', '500.00', NULL, '', '', '2022-01-12 20:07:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (656, 26, 1, 1, 'Foreign Body Removal (Catamine)', '2000.00', NULL, '', '', '2022-01-12 20:08:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (657, 26, 1, 1, 'Foreign Body Removal (La)', '800.00', NULL, '', '', '2022-01-12 20:10:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (658, 26, 1, 1, 'Ligation', '1000.00', NULL, '', '', '2022-01-12 20:11:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (659, 26, 1, 1, 'OT Team Charge', '9000.00', NULL, '', '', '2022-01-12 20:12:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (660, 26, 1, 1, 'Perinaeal Tear (1st Degree)', '1500.00', NULL, '', '', '2022-01-12 20:13:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (661, 26, 1, 1, 'Report repeat (USG)', '200.00', NULL, '', '', '2022-01-12 20:14:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (662, 27, 1, 1, 'Online Doctor Fees', '600.00', NULL, '', '', '2022-01-17 17:05:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (663, 28, 1, 2, 'Admission Fees', '500.00', NULL, '', '', '2022-02-18 06:21:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (664, 29, 1, 2, 'Advance', '2000.00', NULL, '', '', '2022-02-18 06:31:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (665, 30, 1, 2, 'Dr.Kamal FCPS-USA', '600.00', NULL, '', '', '2022-02-18 06:53:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (666, 18, 1, 2, 'Dr.Kamal FCPS-USA', '6000.00', NULL, '', '', '2022-02-18 06:56:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (667, 2, 1, 2, 'CBC/CP/Blood RE', '500.00', NULL, '', '', '2022-02-25 17:37:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (668, 2, 1, 2, 'TOTAL PLATELET COUNT', '500.00', NULL, '', '', '2022-02-25 17:45:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (669, 2, 1, 2, 'PCV (HCT)', '500.00', NULL, '', '', '2022-02-25 17:46:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (670, 2, 1, 2, 'BT. & C.T', '500.00', NULL, '', '', '2022-02-25 17:52:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (671, 2, 1, 2, 'P.B.F', '500.00', NULL, '', '', '2022-02-25 17:52:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (672, 2, 1, 2, 'MP(Malarial Parasites)', '500.00', NULL, '', '', '2022-02-25 17:54:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (673, 2, 1, 2, 'FBS/RBS/PPBS(75 glucose).', '200.00', NULL, '', '', '2022-02-25 17:55:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (674, 2, 1, 2, 'S. Bilirubin', '500.00', NULL, '', '', '2022-02-25 18:00:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (675, 2, 1, 2, 'ASO Test ', '500.00', NULL, '', '', '2022-02-25 18:02:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (676, 2, 1, 2, 'CRP(C-Reactive Protein)', '500.00', NULL, '', '', '2022-02-25 18:14:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (677, 2, 1, 2, '2 Hrs after BF/75 glucose', '200.00', NULL, '', '', '2022-02-25 18:16:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (678, 2, 1, 2, 'Alkaline Phosphates (ALP)', '500.00', NULL, '', '', '2022-02-25 18:16:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (679, 2, 1, 2, 'S. Total Cholesterol', '500.00', NULL, '', '', '2022-02-25 18:17:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (680, 2, 1, 2, 'LDL', '500.00', NULL, '', '', '2022-02-25 18:18:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (681, 2, 1, 2, 'Uric Acid', '500.00', NULL, '', '', '2022-02-25 18:19:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (682, 2, 1, 2, 'Blood Urea/BUN', '500.00', NULL, '', '', '2022-02-25 18:19:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (683, 2, 1, 2, 'Blood Grouping & RH F actor ', '150.00', NULL, '', '', '2022-02-25 18:20:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (684, 2, 1, 2, 'RA/RF Test', '500.00', NULL, '', '', '2022-02-25 18:21:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (685, 2, 1, 2, 'S. Calcium (Ca++)', '600.00', NULL, '', '', '2022-02-25 18:21:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (686, 2, 1, 2, 'S. Electroytes ', '1000.00', NULL, '', '', '2022-02-25 18:22:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (687, 2, 1, 2, 'ASO (Quantitative) Test', '500.00', NULL, '', '', '2022-02-25 18:23:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (688, 2, 1, 2, 'MP (ICT Method)', '500.00', NULL, '', '', '2022-02-25 18:23:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (689, 2, 1, 2, 'Urine Albumin/ Urine Sugar', '200.00', NULL, '', '', '2022-02-25 18:24:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (690, 2, 1, 2, 'Albumin/Globulin (A/G) Ratio', '1000.00', NULL, '', '', '2022-02-25 18:25:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (691, 2, 1, 2, 'CRP (Quantitative) Test', '800.00', NULL, '', '', '2022-02-25 18:25:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (692, 2, 1, 2, 'Tuberculin Test / Mantoux test (MT)', '500.00', NULL, '', '', '2022-02-25 18:26:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (693, 2, 1, 2, 'CKMB', '700.00', NULL, '', '', '2022-02-25 18:27:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (694, 2, 1, 2, 'RA/RF (Quantitative) Test', '800.00', NULL, '', '', '2022-02-25 18:27:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (695, 2, 1, 2, 'PSA (ICT Method)', '700.00', NULL, '', '', '2022-02-25 18:27:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (696, 2, 1, 2, 'PSA Level (ELISA Method)', '1200.00', NULL, '', '', '2022-02-25 18:28:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (697, 2, 1, 2, 'HBeAG (Elisa/Confirmatory)', '1100.00', NULL, '', '', '2022-02-25 18:28:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (698, 2, 1, 2, 'HBeAG (ICT Method)', '600.00', NULL, '', '', '2022-02-25 18:30:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (699, 2, 1, 2, 'Triple Antigen (Ag) / Febrile Antigen', '1200.00', NULL, '', '', '2022-02-25 18:30:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (700, 2, 1, 2, 'HCV (Screening)', '500.00', NULL, '', '', '2022-02-25 18:31:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (701, 2, 1, 2, 'Serum Lipase', '1200.00', NULL, '', '', '2022-02-25 18:31:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (702, 2, 1, 2, 'Alfa Feto Protein (ELISA Method)', '1200.00', NULL, '', '', '2022-02-25 18:32:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (703, 2, 1, 2, 'HIV (Screening)', '500.00', NULL, '', '', '2022-02-25 18:32:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (704, 2, 1, 2, '25 (OH)vitamin D', '2000.00', NULL, '', '', '2022-02-25 18:33:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (705, 2, 1, 2, 'TPHA (ICT Method)', '500.00', NULL, '', '', '2022-02-25 18:33:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (706, 2, 1, 2, 'CEA (ELISA Method)', '1200.00', NULL, '', '', '2022-02-25 18:34:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (707, 2, 1, 2, 'Urine for R/E', '200.00', NULL, '', '', '2022-02-25 18:34:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (708, 2, 1, 2, 'Anti HBc Total (ELASA Method)', '800.00', NULL, '', '', '2022-02-25 18:35:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (709, 2, 1, 2, 'Troponin-l (ELISA Method) ', '800.00', NULL, '', '', '2022-02-25 18:36:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (710, 2, 1, 2, 'Stool for R/E', '500.00', NULL, '', '', '2022-02-25 18:36:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (711, 2, 1, 2, 'Prothrombin Time(PR) INR', '1200.00', NULL, '', '', '2022-02-25 18:37:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (712, 2, 1, 2, 'Anti HAV (ELISA Method)', '800.00', NULL, '', '', '2022-02-25 18:37:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (713, 2, 1, 2, 'Stool Redu. Substance', '500.00', NULL, '', '', '2022-02-25 18:37:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (714, 2, 1, 2, 'Total Circulating Eosinophil Count (TCEC)', '500.00', NULL, '', '', '2022-02-25 18:38:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (715, 2, 1, 2, 'Total Bilirubin: Direct Bilirubin: Indirect Bilirubin ', '1200.00', NULL, '', '', '2022-02-25 18:39:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (716, 2, 1, 2, 'F, T3', '700.00', NULL, '', '', '2022-02-25 18:40:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (717, 2, 1, 2, 'F,T4', '700.00', NULL, '', '', '2022-02-25 18:41:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (718, 2, 1, 2, 'F, T3, F. T4', '1400.00', NULL, '', '', '2022-02-25 18:43:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (719, 2, 1, 2, 'Total lgE', '1200.00', NULL, '', '', '2022-02-25 18:44:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (720, 2, 1, 2, 'Anti-H. Pylori', '700.00', NULL, '', '', '2022-02-25 18:45:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (721, 2, 1, 2, 'S.TESTOSTERONE', '1200.00', NULL, '', '', '2022-02-25 18:47:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (722, 2, 1, 2, 'S. PROLACTIN (PRL)', '1200.00', NULL, '', '', '2022-02-25 18:48:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (723, 2, 1, 2, 'Serum hCG', '1100.00', NULL, '', '', '2022-02-25 18:49:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (724, 2, 1, 2, 'Β HCG', '1600.00', NULL, '', '', '2022-02-25 18:50:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (725, 2, 1, 2, 'Skin Scrapping for Fungus', '800.00', NULL, '', '', '2022-02-25 18:51:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (726, 2, 1, 2, 'HbA1c (Glycated Haemoglobin)', '800.00', NULL, '', '', '2022-02-25 18:52:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (727, 2, 1, 2, 'Rh Antibody Titer', '1200.00', NULL, '', '', '2022-02-25 18:53:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (728, 2, 1, 2, 'FSH', '800.00', NULL, '', '', '2022-02-25 18:54:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (729, 2, 1, 2, 'LH', '800.00', NULL, '', '', '2022-02-25 18:56:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (730, 2, 1, 2, 'Serum Ferritin ', '1200.00', NULL, '', '', '2022-02-25 18:57:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (731, 19, 1, 2, 'ECG', '500.00', NULL, '', '', '2022-02-25 18:59:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (732, 19, 1, 2, 'CPK', '1200.00', NULL, '', '', '2022-02-25 19:02:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (733, 2, 1, 2, 'Anti HBC IgM/ IgG', '800.00', NULL, '', '', '2022-02-25 19:04:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (734, 19, 1, 2, 'ETT', '2600.00', NULL, '', '', '2022-02-25 19:05:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (735, 19, 1, 2, 'Echocardiography (2D)', '1500.00', NULL, '', '', '2022-02-25 19:06:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (736, 19, 1, 2, 'Echocardiography (Colour Dopler)', '2500.00', NULL, '', '', '2022-02-25 19:07:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (737, 19, 1, 2, 'USG of W/A', '700.00', NULL, '', '', '2022-02-25 19:08:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (739, 19, 1, 2, 'USG of L/A', '600.00', NULL, '', '', '2022-02-25 19:10:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (740, 20, 1, 2, 'X-Ray L/S Spine B/V', '900.00', NULL, '', '', '2022-02-25 19:14:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (741, 20, 1, 2, 'X-Ray CXR', '500.00', NULL, '', '', '2022-02-25 19:15:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (742, 20, 1, 2, 'X-Ray KUB', '500.00', NULL, '', '', '2022-02-25 19:16:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (743, 20, 1, 2, 'X-Ray PNS', '500.00', NULL, '', '', '2022-02-25 19:18:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (744, 31, 1, 2, 'Free Doctor Visit', '0.01', NULL, '', '', '2022-02-26 09:52:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (746, 32, 1, 2, 'General Bed', '500.00', NULL, '', '', '2022-02-28 03:45:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (747, 32, 1, 2, 'Cabin single', '1200.00', NULL, '', '', '2022-02-28 03:50:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (748, 32, 1, 2, 'Cabin Double', '1500.00', NULL, '', '', '2022-02-28 03:51:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (749, 33, 1, 2, 'Doctor Round', '300.00', NULL, '', '', '2022-02-28 04:14:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (750, 34, 1, 2, 'OT charge(2000)', '2000.00', NULL, '', '', '2022-02-28 04:25:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (751, 34, 1, 2, 'OT Charge(2500)', '2500.00', NULL, '', '', '2022-02-28 04:32:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (752, 34, 1, 2, 'OT Charge(3000)', '3000.00', NULL, '', '', '2022-02-28 04:35:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (753, 42, 1, 2, 'Operation(2000)', '2000.00', NULL, '', '', '2022-02-28 04:40:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (754, 42, 1, 2, 'Operation(2500)', '2500.00', NULL, '', '', '2022-02-28 04:41:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (755, 42, 1, 2, 'Operation(3000)', '3000.00', NULL, '', '', '2022-02-28 04:42:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (756, 45, 1, 2, 'Sewing', '300.00', NULL, '', '', '2022-02-28 04:48:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (758, 46, 1, 2, 'Emergency(100)', '100.00', NULL, '', '', '2022-02-28 16:16:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (761, 46, 1, 2, 'Emergency(200)', '200.00', NULL, '', '', '2022-03-01 02:16:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (762, 46, 1, 2, 'Emergency(300)', '300.00', NULL, '', '', '2022-03-01 02:27:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (763, 49, 1, 2, 'Cannula Change(100)', '100.00', NULL, '', '', '2022-03-01 02:35:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (764, 35, 1, 2, 'Surgeon fees(4000)', '4000.00', NULL, '', '', '2022-03-01 02:52:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (765, 18, 1, 2, 'Dr. Selim Hossen', '100.00', NULL, '', '', '2022-03-01 12:25:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (766, 18, 1, 2, 'Dr.Shohanur Rahman', '100.00', NULL, '', '', '2022-03-01 12:33:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (767, 15, 1, 2, 'Unine Exam', '900.00', NULL, '', '', '2022-03-04 15:22:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (768, 45, 1, 2, 'TPA', '150.00', NULL, '', '', '2022-03-06 18:18:28');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(1) DEFAULT 0,
  `is_read` int(1) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_patient_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_patient_id` (`create_patient_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cheque_manger
#

DROP TABLE IF EXISTS `cheque_manger`;

CREATE TABLE `cheque_manger` (
  `cheque_id` varchar(100) NOT NULL,
  `transection_id` varchar(100) NOT NULL,
  `customer_id` varchar(100) NOT NULL,
  `bank_id` varchar(100) NOT NULL,
  `cheque_no` varchar(100) NOT NULL,
  `date` varchar(50) NOT NULL,
  `transection_type` varchar(100) NOT NULL,
  `cheque_status` varchar(30) NOT NULL,
  `amount` float NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: company_information
#

DROP TABLE IF EXISTS `company_information`;

CREATE TABLE `company_information` (
  `company_id` varchar(50) NOT NULL,
  `company_name` varchar(250) NOT NULL,
  `email` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `mobile` varchar(30) NOT NULL,
  `website` varchar(50) NOT NULL,
  `status` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `company_information` (`company_id`, `company_name`, `email`, `address`, `mobile`, `website`, `status`) VALUES ('NOILG8EGCRXXBWUEUQBM', 'bdtask Shop', 'bdtask@gmail.com', 'B-25, Mannan Plaza, 4th Floor, Khilkhet\r\nDhaka-1229, Bangladesh ', '1922296392', 'http://www.bdtask.com', 1);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`),
  CONSTRAINT `complaint_ibfk_1` FOREIGN KEY (`complaint_type_id`) REFERENCES `complaint_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `timezone` text DEFAULT NULL,
  `return_response` text DEFAULT NULL,
  `api_type` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `created_id` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_3` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_4` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_5` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `consult_charges_ibfk_1` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`),
  CONSTRAINT `consultant_register_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consultant_register_ibfk_2` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (2, 7, '2022-03-02 16:28:00', '2022-03-02', 'Re Check', 28, '2022-03-02 10:28:26');


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` varchar(250) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: currency_tbl
#

DROP TABLE IF EXISTS `currency_tbl`;

CREATE TABLE `currency_tbl` (
  `id` int(11) NOT NULL,
  `currency_name` varchar(50) NOT NULL,
  `icon` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `currency_tbl` (`id`, `currency_name`, `icon`) VALUES (1, 'Taka', 'à§³');
INSERT INTO `currency_tbl` (`id`, `currency_name`, `icon`) VALUES (2, 'Azerbaijan Manat', 'â‚¼');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1, 44, 1, '106', '2022-03-03 17:52:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2, 45, 1, '107', '2022-03-04 12:38:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3, 46, 1, '106', '2022-03-04 12:42:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4, 47, 1, '106', '2022-03-04 13:11:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (5, 48, 1, '106', '2022-03-04 13:12:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (6, 49, 1, '106', '2022-03-04 13:32:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (7, 50, 1, '', '2022-03-04 13:32:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (8, 51, 1, '106', '2022-03-04 15:38:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (9, 40, 2, '107', '2022-03-04 15:53:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (10, 52, 1, '106', '2022-03-05 03:26:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (11, 41, 2, '107', '2022-03-05 07:27:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (12, 41, 3, 'USG', '2022-03-05 07:27:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (13, 53, 1, '', '2022-03-05 13:04:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (14, 54, 1, '', '2022-03-05 13:10:21');


#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `visible_on_print` int(11) DEFAULT NULL,
  `visible_on_report` int(11) DEFAULT NULL,
  `visible_on_table` int(11) DEFAULT NULL,
  `visible_on_patient_panel` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (1, 'Room', 'pathology', 'select', 12, 0, '106,107', 1, 0, 1, 0, NULL, 0, '2022-03-03 17:51:16');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (2, 'Room', 'radiology', 'select', 12, 0, '106,107', 1, 0, 1, 0, NULL, 0, '2022-03-03 17:54:04');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (3, 'Test Group', 'radiology', 'select', 12, 1, 'USG,X-Ray', 0, 0, 1, 0, NULL, 0, '2022-03-05 07:25:54');


#
# TABLE STRUCTURE FOR: customer_information
#

DROP TABLE IF EXISTS `customer_information`;

CREATE TABLE `customer_information` (
  `id` int(11) NOT NULL,
  `customer_id` varchar(30) NOT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_address` varchar(255) NOT NULL,
  `customer_mobile` varchar(100) NOT NULL,
  `customer_email` varchar(100) NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `customer_information` (`id`, `customer_id`, `customer_name`, `customer_address`, `customer_mobile`, `customer_email`, `status`) VALUES (1, 'P3NY6D1AKZQPHB7', 'Walking Customer', '', '465645', '', 1);


#
# TABLE STRUCTURE FOR: customer_ledger
#

DROP TABLE IF EXISTS `customer_ledger`;

CREATE TABLE `customer_ledger` (
  `transaction_id` varchar(100) NOT NULL,
  `customer_id` varchar(100) NOT NULL,
  `invoice_no` varchar(100) DEFAULT NULL,
  `receipt_no` varchar(50) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT 0.00,
  `description` varchar(255) NOT NULL,
  `payment_type` varchar(255) NOT NULL,
  `cheque_no` varchar(255) NOT NULL,
  `date` varchar(50) NOT NULL,
  `status` int(2) NOT NULL,
  `id` int(11) NOT NULL,
  `d_c` varchar(1) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('TLT8FQ3FV1QJKWV', 'P3NY6D1AKZQPHB7', '9259592329', NULL, '0.00', 'Cash Paid By Customer', '', '', '2022-02-23', 1, 1, 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('TLT8FQ3FV1QJKWV', 'P3NY6D1AKZQPHB7', NULL, 'SEC4WOUJ4A', '6.00', 'Medicine Received By Customer', '1', '', '2022-02-23', 1, 2, 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('A32NOO3TOJ2ZXQM', 'P3NY6D1AKZQPHB7', '1877899635', NULL, '0.00', 'Cash Paid By Customer', '', '', '2022-02-23', 1, 3, 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('A32NOO3TOJ2ZXQM', 'P3NY6D1AKZQPHB7', NULL, 'GBGUX5XLAU', '3.00', 'Medicine Received By Customer', '1', '', '2022-02-23', 1, 4, 'd');


#
# TABLE STRUCTURE FOR: daily_banking_add
#

DROP TABLE IF EXISTS `daily_banking_add`;

CREATE TABLE `daily_banking_add` (
  `banking_id` varchar(255) NOT NULL,
  `date` varchar(50) NOT NULL,
  `bank_id` varchar(100) NOT NULL,
  `deposit_type` varchar(255) NOT NULL,
  `transaction_type` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `amount` float NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: daily_closing
#

DROP TABLE IF EXISTS `daily_closing`;

CREATE TABLE `daily_closing` (
  `closing_id` varchar(255) NOT NULL,
  `last_day_closing` float NOT NULL,
  `cash_in` float NOT NULL,
  `cash_out` float NOT NULL,
  `date` varchar(50) NOT NULL,
  `amount` float NOT NULL,
  `adjustment` float NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `attachment` varchar(200) NOT NULL,
  `attachment_name` text DEFAULT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `death_report` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `death_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `death_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (1, 'pathology', 'yes', '2022-01-11 07:10:12');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (2, 'Reception', 'yes', '2022-01-17 04:14:12');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (3, 'Account', 'yes', '2022-01-17 04:27:14');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (4, 'Admin_Hospital', 'yes', '2022-01-17 04:27:48');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (5, 'Radiology ', 'yes', '2022-01-17 04:28:29');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (6, 'Ultrasound', 'yes', '2022-01-17 04:29:49');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (7, 'Report', 'yes', '2022-01-17 04:30:37');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (8, 'Pharmacy', 'yes', '2022-01-17 04:33:15');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (9, 'Doctor', 'yes', '2022-01-17 04:33:57');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (10, 'IT', 'yes', '2022-01-17 04:35:08');


#
# TABLE STRUCTURE FOR: designation
#

DROP TABLE IF EXISTS `designation`;

CREATE TABLE `designation` (
  `id` int(11) NOT NULL,
  `designation` varchar(150) NOT NULL,
  `details` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: discharge_card
#

DROP TABLE IF EXISTS `discharge_card`;

CREATE TABLE `discharge_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_details_id` int(11) DEFAULT NULL,
  `discharge_by` int(11) DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_status` int(10) NOT NULL,
  `death_date` datetime DEFAULT NULL,
  `refer_date` datetime DEFAULT NULL,
  `refer_to_hospital` varchar(255) DEFAULT NULL,
  `reason_for_referral` varchar(255) DEFAULT NULL,
  `operation` varchar(225) NOT NULL,
  `diagnosis` varchar(255) NOT NULL,
  `investigations` text DEFAULT NULL,
  `treatment_home` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `discharge_by` (`discharge_by`),
  CONSTRAINT `discharge_card_ibfk_1` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_2` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_4` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_5` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_6` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (1, 24, NULL, 7, 1, '2022-03-02 16:29:00', 3, NULL, NULL, NULL, '', 'no', 'yes', 'yes', 'ok', 'Discharged as normal', '2022-03-02 10:31:56');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (2, 4, NULL, 2, 1, '2022-03-02 17:07:00', 3, NULL, NULL, NULL, '', '', '', '', '', '', '2022-03-02 11:07:25');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (3, 43, NULL, 16, 1, '2022-03-06 19:04:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'good', '2022-03-06 13:05:12');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (4, 9, NULL, 4, 1, '2022-03-07 00:23:00', 3, NULL, NULL, NULL, '', '', '', '', '', '', '2022-03-06 18:23:47');


#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `image` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_absent_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_global_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_global_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (2, 46, 1, '2022-03-01 12:56:18');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (3, 46, 2, '2022-03-02 17:01:30');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (4, 24, 1, '2022-03-02 17:01:53');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (5, 24, 2, '2022-03-02 17:01:57');


#
# TABLE STRUCTURE FOR: doctor_shift
#

DROP TABLE IF EXISTS `doctor_shift`;

CREATE TABLE `doctor_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (1, 'Monday', 46, 1, '00:04:00', '01:04:00', '2022-03-02 17:05:14');


#
# TABLE STRUCTURE FOR: dose_duration
#

DROP TABLE IF EXISTS `dose_duration`;

CREATE TABLE `dose_duration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: dose_interval
#

DROP TABLE IF EXISTS `dose_interval`;

CREATE TABLE `dose_interval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (1, 'sendmail', '', '', '', '', '', 'true', 'yes', '2021-09-24 12:44:21');


#
# TABLE STRUCTURE FOR: employee_history
#

DROP TABLE IF EXISTS `employee_history`;

CREATE TABLE `employee_history` (
  `id` int(11) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `rate_type` int(11) NOT NULL,
  `hrate` float NOT NULL,
  `email` varchar(50) NOT NULL,
  `blood_group` varchar(10) NOT NULL,
  `address_line_1` text NOT NULL,
  `address_line_2` text NOT NULL,
  `image` text DEFAULT NULL,
  `country` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `zip` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: employee_salary_payment
#

DROP TABLE IF EXISTS `employee_salary_payment`;

CREATE TABLE `employee_salary_payment` (
  `emp_sal_pay_id` int(11) NOT NULL,
  `generate_id` int(11) NOT NULL,
  `employee_id` varchar(50) CHARACTER SET latin1 NOT NULL,
  `total_salary` decimal(18,2) NOT NULL DEFAULT 0.00,
  `total_working_minutes` varchar(50) CHARACTER SET latin1 NOT NULL,
  `working_period` varchar(50) CHARACTER SET latin1 NOT NULL,
  `payment_due` varchar(50) CHARACTER SET latin1 NOT NULL,
  `payment_date` varchar(50) CHARACTER SET latin1 NOT NULL,
  `paid_by` varchar(50) CHARACTER SET latin1 NOT NULL,
  `salary_month` varchar(70) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: employee_salary_setup
#

DROP TABLE IF EXISTS `employee_salary_setup`;

CREATE TABLE `employee_salary_setup` (
  `e_s_s_id` int(11) unsigned NOT NULL,
  `employee_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `sal_type` varchar(30) NOT NULL,
  `salary_type_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `create_date` date DEFAULT NULL,
  `update_date` datetime(6) DEFAULT NULL,
  `update_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `gross_salary` float NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense
#

DROP TABLE IF EXISTS `expense`;

CREATE TABLE `expense` (
  `id` int(11) NOT NULL,
  `date` date NOT NULL,
  `type` varchar(100) NOT NULL,
  `voucher_no` varchar(50) NOT NULL,
  `amount` float NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Administrative', 'Test', 'yes', 'no', '2022-02-26 04:57:35');


#
# TABLE STRUCTURE FOR: expense_item
#

DROP TABLE IF EXISTS `expense_item`;

CREATE TABLE `expense_item` (
  `id` int(11) NOT NULL,
  `expense_item_name` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES (1, 'Gass Bill');
INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES (2, 'Pc');
INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES (3, 'Nasta');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `expenses_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (1, 1, 'Electricity Bill', '121', '2022-02-26', '5000.00', NULL, '', 'yes', 'no', 1, '2022-02-26 05:03:15');


#
# TABLE STRUCTURE FOR: finding
#

DROP TABLE IF EXISTS `finding`;

CREATE TABLE `finding` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `finding_category_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `finding_category_id` (`finding_category_id`),
  CONSTRAINT `finding_ibfk_1` FOREIGN KEY (`finding_category_id`) REFERENCES `finding_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: finding_category
#

DROP TABLE IF EXISTS `finding_category`;

CREATE TABLE `finding_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fixed_assets
#

DROP TABLE IF EXISTS `fixed_assets`;

CREATE TABLE `fixed_assets` (
  `id` int(11) NOT NULL,
  `item_code` varchar(50) NOT NULL,
  `item_name` varchar(100) NOT NULL,
  `price` float NOT NULL,
  `insert_date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (1, '2nd floor', '', '2022-02-18 05:45:17');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (2, '3rd Floor', '', '2022-02-28 03:53:03');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (3, '4 th Floor', '', '2022-02-28 03:53:33');


#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext DEFAULT NULL,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 03:14:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Appointment', 0, 0, '1', 1, 'http://34.126.191.23/99/form/appointment', 'appointment', 2, 0, NULL, 'no', '2022-02-11 16:40:49');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', 1, 0, NULL, 'no', '2022-01-17 03:20:36');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 10:54:41');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (5, 1, 'Admin Login', 0, 0, '1', 1, 'http://34.126.191.23/99/site/login', 'admin-login', 4, 0, NULL, 'no', '2022-02-11 16:40:14');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (6, 1, 'Medicine login', 0, 0, '1', 1, 'http://34.126.191.23/100/', 'medicine-login', 3, 0, NULL, 'no', '2022-02-11 16:40:36');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (7, 1, 'Local Admin Login', 0, 0, '1', 1, 'http://10.0.99.99', 'local-admin-login', 5, 0, NULL, 'no', '2022-01-17 18:56:40');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` mediumtext DEFAULT NULL,
  `ext_url_link` mediumtext DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 03:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 03:54:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home page first new', 'page/home-page-first-new', 'page', 'home-page-first-new', '', '', '', '', '<p>Home page first</p>', '0000-00-00', 1, 1, 'no', '2021-09-28 15:49:10');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 03:00:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<title></title>\r\n<p>404 page found</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 11:35:15');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 06:27:54');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (5, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">First name: <input name=\"fname\" type=\"text\" /><br />\r\nLast name: <input name=\"lname\" type=\"text\" /><br />\r\n<input type=\"submit\" value=\"Submit\" />&nbsp;</form>', '0000-00-00', 0, 1, 'no', '2021-09-24 11:35:25');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` mediumtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) NOT NULL DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_online_appointment` int(11) DEFAULT NULL,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext DEFAULT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_online_appointment`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'darkgray', NULL, 1, 1, NULL, './uploads/hospital_content/logo/front_logo-61e4f70b06a6b4.63157873.png', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', 'Copyright@ hilfulsoft- China', './uploads/hospital_content/logo/front_fav_icon-61e4f70b06bb65.03308344.png', '2022-01-17 04:56:43');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` text DEFAULT NULL,
  `follow_up_date` date DEFAULT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (1, 'morning', '00:00:00', '08:00:00', '2022-03-02 16:58:42');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (2, 'evening', '12:30:00', '13:00:00', '2022-03-02 17:01:00');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_deleted` varchar(10) DEFAULT 'no',
  `documents` varchar(255) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `inc_head_id` (`inc_head_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`inc_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `income_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: invoice
#

DROP TABLE IF EXISTS `invoice`;

CREATE TABLE `invoice` (
  `id` int(11) NOT NULL,
  `invoice_id` varchar(30) DEFAULT NULL,
  `customer_id` varchar(100) NOT NULL,
  `date` date DEFAULT NULL,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `invoice` varchar(255) NOT NULL,
  `total_discount` decimal(10,2) DEFAULT 0.00 COMMENT 'total invoice discount',
  `invoice_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_tax` decimal(10,2) DEFAULT 0.00,
  `prevous_due` decimal(10,2) NOT NULL DEFAULT 0.00,
  `sales_by` varchar(30) DEFAULT NULL,
  `invoice_details` varchar(200) DEFAULT NULL,
  `status` int(2) NOT NULL,
  `payment_type` int(11) NOT NULL DEFAULT 1,
  `bank_id` varchar(30) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES (1, '9259592329', 'P3NY6D1AKZQPHB7', '2022-02-23', '6.00', '1000', '0.00', '0.00', '0.00', '0.00', '1', '', 1, 1, NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES (2, '1877899635', 'P3NY6D1AKZQPHB7', '2022-02-23', '3.00', '1001', '0.00', '0.00', '0.00', '0.00', '1', '', 1, 1, NULL);


#
# TABLE STRUCTURE FOR: invoice_details
#

DROP TABLE IF EXISTS `invoice_details`;

CREATE TABLE `invoice_details` (
  `id` int(11) NOT NULL,
  `invoice_details_id` varchar(30) NOT NULL,
  `invoice_id` varchar(100) NOT NULL,
  `product_id` varchar(100) NOT NULL,
  `batch_id` varchar(30) NOT NULL,
  `cartoon` float DEFAULT NULL,
  `quantity` float NOT NULL,
  `rate` decimal(12,2) NOT NULL DEFAULT 0.00,
  `manufacturer_rate` decimal(10,2) DEFAULT 0.00,
  `total_price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `discount` decimal(12,0) DEFAULT 0,
  `tax` decimal(10,2) DEFAULT 0.00,
  `paid_amount` decimal(12,0) DEFAULT 0,
  `due_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` int(2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `invoice_details` (`id`, `invoice_details_id`, `invoice_id`, `product_id`, `batch_id`, `cartoon`, `quantity`, `rate`, `manufacturer_rate`, `total_price`, `discount`, `tax`, `paid_amount`, `due_amount`, `status`) VALUES (1, '158396893255633', '9259592329', '58967225', '11', NULL, '2', '3.00', '4.00', '6.00', '0', NULL, '0', '6.00', 1);
INSERT INTO `invoice_details` (`id`, `invoice_details_id`, `invoice_id`, `product_id`, `batch_id`, `cartoon`, `quantity`, `rate`, `manufacturer_rate`, `total_price`, `discount`, `tax`, `paid_amount`, `due_amount`, `status`) VALUES (2, '628395523414933', '1877899635', '58967225', '11', NULL, '1', '3.00', '4.00', '3.00', '0', NULL, '0', '3.00', 1);


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `bed` varchar(100) NOT NULL,
  `bed_group_id` int(10) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` varchar(200) NOT NULL,
  `known_allergies` varchar(200) DEFAULT NULL,
  `patient_old` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `cons_doctor` (`cons_doctor`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `ipd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_4` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_5` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (2, 12, 4, '', '', '', '', '', '', '1', 1, 'Pregnancy\'s', 'No', '', NULL, '', NULL, 'Shakil', 33, NULL, '2000', '', '2022-02-26 15:29:00', 'yes', 'no', 1, '2022-03-02 11:07:25');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (4, 11, 9, '', '', '', '', '', '', '6', 1, '', 'No', '', NULL, '', NULL, '', 17, NULL, '10000', '', '2022-03-01 00:03:00', 'yes', 'no', 35, '2022-03-06 18:23:47');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (5, 40, 11, '', '', '', '', '', '', '19', 2, 'Matha Beatha', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-01 13:18:00', 'no', 'no', 35, '2022-03-01 07:19:10');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (6, 47, 19, '', '', '', '', '', '', '21', 2, 'Matha Beatha', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-01 19:51:00', 'no', 'no', 35, '2022-03-01 13:53:18');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (7, 43, 24, '', '', '', '', '', '', '3', 3, 'surgery', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-01 08:55:00', 'yes', 'no', 35, '2022-03-02 10:31:56');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (8, 57, 28, '', '', '', '', '', '', '8', 3, 'Pain', 'No', '', NULL, '', NULL, '', 46, NULL, '2000', '', '2022-03-02 18:33:00', 'no', 'no', 35, '2022-03-02 12:34:07');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (9, 43, 29, '', '', '', '', '', '', '1', 3, 'Fever', 'No', '', NULL, '', NULL, '', 28, NULL, '2000', '', '2022-03-02 18:36:00', 'no', 'no', 35, '2022-03-02 12:37:32');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (10, 69, 36, '', '', '', '', '', '', '3', 3, '', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-03 23:14:00', 'no', 'no', 1, '2022-03-03 17:14:28');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (11, 71, 37, '', '', '', '', '', '', '7', 3, 'Pete Beatha', 'No', '', NULL, '', NULL, '', 46, NULL, '2000', '', '2022-03-04 16:19:00', 'no', 'no', 35, '2022-03-04 10:20:02');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (12, 81, 39, '', '', '', '', '', '', '12', 3, 'Pain', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-05 17:32:00', 'no', 'no', 35, '2022-03-05 11:34:01');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (13, 82, 40, '', '', '', '', '', '', '13', 3, 'Matha Beatha', 'No', '', NULL, '', NULL, '', 46, NULL, '2000', '', '2022-03-05 17:58:00', 'no', 'no', 35, '2022-03-05 11:59:31');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (14, 83, 41, '', '', '', '', '', '', '10', 3, '', 'No', '', NULL, '', NULL, '', 25, NULL, '2000', '', '2022-03-05 18:09:00', 'no', 'no', 48, '2022-03-05 12:10:07');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (15, 84, 42, '', '', '', '', '', '', '16', 3, 'pain', 'Yes', '', NULL, '', NULL, '', 46, NULL, '1', '', '2022-03-05 18:23:00', 'no', 'no', 35, '2022-03-05 12:23:44');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (16, 31, 43, '', '', '', '', '', '', '15', 3, '', 'No', '', NULL, '', NULL, '', 22, NULL, '2000', '', '2022-03-05 18:21:00', 'yes', 'no', 48, '2022-03-06 13:05:12');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (17, 72, 44, '', '', '', '', '', '', '11', 3, '', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-05 18:25:00', 'no', 'no', 48, '2022-03-05 12:25:30');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (18, 13, 45, '', '', '', '', '', '', '9', 3, 'Medecine', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-05 18:37:00', 'no', 'no', 35, '2022-03-05 12:38:19');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (19, 14, 49, '', '', '', '', '', '', '18', 3, 'pate bata', 'No', '', NULL, '', NULL, '', 16, NULL, '2000', '', '2022-03-06 08:37:00', 'no', 'no', 51, '2022-03-06 02:38:46');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (20, 85, 51, '', '', '', '', '', '', '14', 3, 'Medecine', 'No', '', NULL, '', NULL, '', 20, NULL, '2000', '', '2022-03-06 15:14:00', 'no', 'no', 35, '2022-03-06 09:15:32');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (21, 1, 52, '', '', '', '', '', '', '17', 3, 'Medecine', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-06 15:26:00', 'no', 'no', 35, '2022-03-06 09:27:51');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (22, 86, 56, '', '', '', '', '', '', '15', 3, '', 'No', '', NULL, '', NULL, '', 46, NULL, '2000', '', '2022-03-06 19:42:00', 'no', 'no', 51, '2022-03-06 13:42:37');


#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `consult_doctor` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `consult_doctor` (`consult_doctor`),
  CONSTRAINT `ipd_doctors_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_doctors_ibfk_2` FOREIGN KEY (`consult_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `header_note` text DEFAULT NULL,
  `footer_note` text DEFAULT NULL,
  `finding_description` text DEFAULT NULL,
  `is_finding_print` varchar(100) DEFAULT NULL,
  `date` date NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `prescribe_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `visit_details_id` (`visit_details_id`),
  CONSTRAINT `ipd_prescription_basic_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_2` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (1, 11, NULL, '', '', ' ', 'yes', '2022-03-04', 1, 46, '2022-03-04 10:54:34');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(10) DEFAULT NULL,
  `dosage` int(11) DEFAULT NULL,
  `dose_interval_id` int(11) DEFAULT NULL,
  `dose_duration_id` int(11) DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `basic_id` (`basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  CONSTRAINT `ipd_prescription_details_ibfk_1` FOREIGN KEY (`basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (1, 1, 3, 1, 0, 0, '', '2022-03-04 10:54:34');


#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_prescription_basic_id` int(100) DEFAULT NULL,
  `pathology_id` int(11) DEFAULT NULL,
  `radiology_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `radiology_id` (`radiology_id`),
  CONSTRAINT `ipd_prescription_test_ibfk_1` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_2` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_3` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (1, 1, 16, NULL, '2022-03-04 10:54:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (2, 1, 31, NULL, '2022-03-04 10:54:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (3, 1, NULL, 279, '2022-03-04 10:54:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (4, 1, NULL, 259, '2022-03-04 10:54:34');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (1, 1, 'x-ray film', 'pcs', NULL, '', 0, NULL, '2022-02-26 05:36:28');


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'Radiology', 'yes', '', '2022-02-26 05:29:51');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (2, 'Pathology', 'yes', '', '2022-02-26 05:30:08');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` int(11) DEFAULT NULL,
  `issue_to` int(11) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text DEFAULT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (1, 1, 1, '+', 2, 100, '5000.00', '2022-02-26', NULL, 'Challan not found', 'yes', '2022-02-26 05:38:57');


#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (1, 'Pathology', '101', '', '2022-02-26 05:32:14');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (2, 'Radiology', '', '', '2022-02-26 05:32:30');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (1, 'Satu estationary', '', '', '', '', '', '', '', '2022-02-26 05:30:43');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (2, 'Others Stotionary', '', '', '', '', '', '', '', '2022-02-26 05:31:45');


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (1, 'ULTRASOUND', '2022-01-11 19:02:53');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (2, 'X-RAY', '2022-01-11 19:03:55');


#
# TABLE STRUCTURE FOR: language
#

DROP TABLE IF EXISTS `language`;

CREATE TABLE `language` (
  `id` int(11) unsigned NOT NULL,
  `phrase` text NOT NULL,
  `english` text DEFAULT NULL,
  `bangla` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (1, 'user_profile', 'User Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (2, 'setting', 'Web Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (3, 'language', 'Language', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (4, 'manage_users', 'Manage Users', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (5, 'add_user', 'Add User', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (6, 'manage_company', 'Manage Company', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (7, 'web_settings', 'Software Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (8, 'manage_accounts', 'Manage Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (9, 'create_accounts', 'Create Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (10, 'manage_bank', 'Manage Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (11, 'add_new_bank', 'Add New Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (12, 'settings', 'Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (13, 'closing_report', 'Closing Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (14, 'closing', 'Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (15, 'cheque_manager', 'Cheque Manager', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (16, 'accounts_summary', 'Accounts Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (17, 'expense', 'Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (18, 'income', 'Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (19, 'accounts', 'Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (20, 'stock_report', 'Stock Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (21, 'stock', 'Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (22, 'pos_invoice', 'POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (23, 'manage_invoice', 'Manage Invoice ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (24, 'new_invoice', 'New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (25, 'invoice', 'Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (26, 'manage_purchase', 'Manage Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (27, 'add_purchase', 'Add Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (28, 'purchase', 'Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (29, 'paid_customer', 'Paid Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (30, 'manage_customer', 'Manage Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (31, 'add_customer', 'Add Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (32, 'customer', 'Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (33, 'manufacturer_payment_actual', 'Manufacturer Payment Actual', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (34, 'manufacturer_sales_summary', 'Manufacturer  Sales Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (35, 'manufacturer_sales_details', 'Manufacturer Sales Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (36, 'manufacturer_ledger', 'Manufacturer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (37, 'manage_manufacturer', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (38, 'add_manufacturer', 'Add Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (39, 'manufacturer', 'Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (40, 'product_statement', 'Medicine Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (41, 'manage_product', 'Manage Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (42, 'add_product', 'Add Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (43, 'product', 'Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (44, 'manage_category', 'Manage Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (45, 'add_category', 'Add Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (46, 'category', 'Medicine Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (47, 'sales_report_product_wise', 'Sales Report (Medicine Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (48, 'purchase_report', 'Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (49, 'sales_report', 'Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (50, 'todays_report', 'Todays Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (51, 'report', 'Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (52, 'dashboard', 'Dashboard', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (53, 'online', 'Online', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (54, 'logout', 'Logout', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (56, 'total_purchase', 'Total Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (57, 'total_amount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (58, 'manufacturer_name', 'Manufacturer  Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (59, 'invoice_no', 'Invoice No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (60, 'purchase_date', 'Purchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (61, 'todays_purchase_report', 'Todays Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (62, 'total_sales', 'Total Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (63, 'customer_name', 'Customer Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (64, 'sales_date', 'Sales Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (65, 'todays_sales_report', 'Todays Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (66, 'home', 'Home', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (67, 'todays_sales_and_purchase_report', 'Todays sales and purchase report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (68, 'total_ammount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (69, 'rate', 'Sale Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (70, 'product_model', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (71, 'product_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (72, 'search', 'Search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (73, 'end_date', 'End Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (74, 'start_date', 'Start Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (75, 'total_purchase_report', 'Total Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (76, 'total_sales_report', 'Total Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (77, 'total_seles', 'Total Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (78, 'all_stock_report', 'All Stock Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (79, 'search_by_product', 'Search By Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (80, 'date', 'Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (81, 'print', 'Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (82, 'stock_date', 'Stock Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (83, 'print_date', 'Print Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (84, 'sales', 'Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (85, 'price', 'Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (86, 'sl', 'SL.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (87, 'add_new_category', 'Add new category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (88, 'category_name', 'Category Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (89, 'save', 'Save', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (90, 'delete', 'Delete', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (91, 'update', 'Update', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (92, 'action', 'Action', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (93, 'manage_your_category', 'Manage your category ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (94, 'category_edit', 'Category Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (95, 'status', 'Status', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (96, 'active', 'Active', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (97, 'inactive', 'Inactive', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (98, 'save_changes', 'Save Changes', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (99, 'save_and_add_another', 'Save And Add Another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (100, 'model', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (101, 'manufacturer_price', 'Manufacturer Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (102, 'sell_price', 'Sell Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (103, 'image', 'Image', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (104, 'select_one', 'Select One', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (105, 'details', 'Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (106, 'new_product', 'New Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (107, 'add_new_product', 'Add new medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (108, 'barcode', 'Barcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (109, 'qr_code', 'Qr-Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (110, 'product_details', 'Medicine Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (111, 'manage_your_product', 'Manage your medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (112, 'product_edit', 'Medicine Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (113, 'edit_your_product', 'Edit your medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (114, 'cancel', 'Cancel', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (115, 'incl_vat', 'Incl. Vat', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (116, 'money', 'Dollar', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (117, 'grand_total', 'Grand Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (118, 'quantity', 'Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (119, 'product_report', 'Medicine Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (120, 'product_sales_and_purchase_report', 'Medicine sales and purchase report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (121, 'previous_stock', 'Previous Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (122, 'out', 'Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (123, 'in', 'In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (124, 'to', 'To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (125, 'previous_balance', 'Previous Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (126, 'customer_address', 'Customer Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (127, 'customer_mobile', 'Customer Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (128, 'customer_email', 'Customer Email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (129, 'add_new_customer', 'Add new customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (130, 'balance', 'Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (131, 'mobile', 'Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (132, 'address', 'Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (133, 'manage_your_customer', 'Manage your customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (134, 'customer_edit', 'Customer Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (135, 'paid_customer_list', 'Paid Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (136, 'ammount', 'Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (137, 'customer_ledger', 'Customer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (138, 'manage_customer_ledger', 'Manage Customer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (139, 'customer_information', 'Customer Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (140, 'debit_ammount', 'Debit Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (141, 'credit_ammount', 'Credit Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (142, 'balance_ammount', 'Balance Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (143, 'receipt_no', 'Receipt NO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (144, 'description', 'Description', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (145, 'debit', 'Debit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (146, 'credit', 'Credit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (147, 'item_information', 'Item Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (148, 'total', 'Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (149, 'please_select_manufacturer', 'Please Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (150, 'submit', 'Submit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (151, 'submit_and_add_another', 'Submit And Add Another One', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (152, 'add_new_item', 'Add New Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (153, 'manage_your_purchase', 'Manage your purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (154, 'purchase_edit', 'Purchase Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (155, 'purchase_ledger', 'Purchase Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (156, 'invoice_information', 'Invoice Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (157, 'paid_ammount', 'Paid Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (158, 'discount', 'Discount / Pcs.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (159, 'save_and_paid', 'Save And Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (160, 'payee_name', 'Payee Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (161, 'manage_your_invoice', 'Manage your invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (162, 'invoice_edit', 'Invoice Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (163, 'new_pos_invoice', 'New POS invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (164, 'add_new_pos_invoice', 'Add new pos invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (165, 'product_id', 'Medicine ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (166, 'paid_amount', 'Paid Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (167, 'authorised_by', 'Authorised By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (168, 'checked_by', 'Checked By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (169, 'received_by', 'Received By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (170, 'prepared_by', 'Prepared By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (171, 'memo_no', 'Memo No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (172, 'website', 'Website', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (173, 'email', 'Email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (174, 'invoice_details', 'Invoice Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (175, 'reset', 'Reset', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (176, 'payment_account', 'Payment Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (177, 'bank_name', 'Bank Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (178, 'cheque_or_pay_order_no', 'Cheque/Pay Order No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (179, 'payment_type', 'Payment Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (180, 'payment_from', 'Payment From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (181, 'payment_date', 'Payment Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (182, 'add_income', 'Add Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (183, 'cash', 'Cash', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (184, 'cheque', 'Cheque', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (185, 'pay_order', 'Pay Order', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (186, 'payment_to', 'Payment To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (187, 'total_expense_ammount', 'Total Expense Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (188, 'transections', 'Transactions', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (189, 'accounts_name', 'Accounts Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (190, 'outflow_report', 'Expense Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (191, 'inflow_report', 'Income Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (192, 'all', 'All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (193, 'account', 'Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (194, 'from', 'From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (195, 'account_summary_report', 'Account Summary Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (196, 'search_by_date', 'Search By Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (197, 'cheque_no', 'Cheque No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (198, 'name', 'Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (199, 'closing_account', 'Closing Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (200, 'close_your_account', 'Close your account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (201, 'last_day_closing', 'Last Day Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (202, 'cash_in', 'Cash In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (203, 'cash_out', 'Cash Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (204, 'cash_in_hand', 'Cash In Hand', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (205, 'add_new_bank', 'Add New Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (206, 'day_closing', 'Day Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (207, 'account_closing_report', 'Account Closing Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (208, 'last_day_ammount', 'Last Day Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (209, 'adjustment', 'Adjustment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (210, 'pay_type', 'Pay Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (211, 'customer_or_manufacturer', 'Customer,Manufacturer Or Others', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (212, 'transection_id', 'Transactions ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (213, 'accounts_summary_report', 'Accounts Summary Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (214, 'bank_list', 'Bank List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (215, 'bank_edit', 'Bank Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (216, 'debit_plus', 'Debit (+)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (217, 'credit_minus', 'Credit (-)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (218, 'account_name', 'Account Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (219, 'account_type', 'Account Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (220, 'account_real_name', 'Account Real Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (221, 'manage_account', 'Manage Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (222, 'company_name', 'Company Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (223, 'edit_your_company_information', 'Edit your company information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (224, 'company_edit', 'Company Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (225, 'admin', 'Admin', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (226, 'user', 'User', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (227, 'password', 'Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (228, 'last_name', 'Last Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (229, 'first_name', 'First Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (230, 'add_new_user_information', 'Add new user information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (231, 'user_type', 'User Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (232, 'user_edit', 'User Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (233, 'rtr', 'RTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (234, 'ltr', 'LTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (235, 'ltr_or_rtr', 'LTR/RTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (236, 'footer_text', 'Footer Text', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (237, 'favicon', 'Favicon', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (238, 'logo', 'Logo', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (239, 'update_setting', 'Update Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (240, 'update_your_web_setting', 'Update your Web setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (241, 'login', 'Login', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (242, 'your_strong_password', 'Your strong password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (243, 'your_unique_email', 'Your unique email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (244, 'please_enter_your_login_information', 'Please enter your login information.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (245, 'update_profile', 'Update Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (246, 'your_profile', 'Your Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (247, 're_type_password', 'Re-Type Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (248, 'new_password', 'New Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (249, 'old_password', 'Old Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (250, 'new_information', 'New Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (251, 'old_information', 'Old Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (252, 'change_your_information', 'Change your information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (253, 'change_your_profile', 'Change your profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (254, 'profile', 'Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (255, 'wrong_username_or_password', 'Wrong User Name Or Password !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (256, 'successfully_updated', 'Successfully Updated.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (257, 'blank_field_does_not_accept', 'Blank Field Does Not Accept !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (258, 'successfully_changed_password', 'Successfully changed password.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (259, 'you_are_not_authorised_person', 'You are not authorised person !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (260, 'password_and_repassword_does_not_match', 'Passwor and re-password does not match !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (261, 'new_password_at_least_six_character', 'New Password At Least 6 Character.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (262, 'you_put_wrong_email_address', 'You put wrong email address !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (263, 'cheque_ammount_asjusted', 'Cheque amount adjusted.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (264, 'successfully_payment_paid', 'Successfully Payment Paid.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (265, 'successfully_added', 'Successfully Added.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (266, 'successfully_updated_2_closing_ammount_not_changeale', 'Successfully Updated -2. Note: Closing Amount Not Changeable.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (267, 'successfully_payment_received', 'Successfully Payment Received.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (268, 'already_inserted', 'Already Inserted !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (269, 'successfully_delete', 'Successfully Delete.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (270, 'successfully_created', 'Successfully Created.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (271, 'logo_not_uploaded', 'Logo not uploaded !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (272, 'favicon_not_uploaded', 'Favicon not uploaded !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (273, 'manufacturer_mobile', 'Manufacturer  Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (274, 'manufacturer_address', 'Manufacturer  Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (275, 'manufacturer_details', 'Manufacturer Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (276, 'add_new_manufacturer', 'Add New Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (277, 'manage_suppiler', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (278, 'manage_your_manufacturer', 'Manage your Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (279, 'manage_manufacturer_ledger', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (280, 'invoice_id', 'Invoice ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (281, 'deposite_id', 'Deposit ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (282, 'manufacturer_actual_ledger', 'Manufacturer Actual Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (283, 'manufacturer_information', 'Manufacturer Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (284, 'event', 'Event', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (285, 'add_new_income', 'Add New Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (286, 'add_expese', 'Add Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (287, 'add_new_expense', 'Add New Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (288, 'total_income_ammount', 'Total Income Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (289, 'create_new_invoice', 'Create New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (290, 'create_pos_invoice', 'Create POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (291, 'total_profit', 'Total Profit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (292, 'monthly_progress_report', 'Monthly Progress Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (293, 'total_invoice', 'Total Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (294, 'account_summary', 'Account Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (295, 'total_manufacturer', 'Total manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (296, 'total_product', 'Total Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (297, 'total_customer', 'Total Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (298, 'manufacturer_edit', 'Manufacturer Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (299, 'add_new_invoice', 'Add New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (300, 'add_new_purchase', 'Add new purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (301, 'currency', 'Currency', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (302, 'currency_position', 'Currency Position', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (303, 'left', 'Left', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (304, 'right', 'Right', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (305, 'add_tax', 'Add Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (306, 'manage_tax', 'Manage Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (307, 'add_new_tax', 'Add new tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (308, 'enter_tax', 'Enter Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (309, 'already_exists', 'Already Exists !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (310, 'successfully_inserted', 'Successfully Inserted.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (311, 'tax', 'Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (312, 'tax_edit', 'Tax Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (313, 'product_not_added', 'Medicine not added !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (314, 'total_tax', 'Total Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (315, 'manage_your_manufacturer_details', 'Manage your Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (316, 'invoice_description', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s                                       standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (317, 'thank_you_for_choosing_us', 'Thank you very much for choosing us.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (318, 'billing_date', 'Billing Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (319, 'billing_to', 'Billing To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (320, 'billing_from', 'Billing From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (321, 'you_cant_delete_this_product', 'Sorry !!  You can\'t delete this medicine.This medicine already used in calculation system!', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (322, 'old_customer', 'Old Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (323, 'new_customer', 'New Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (324, 'new_manufacturer', 'New Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (325, 'old_manufacturer', 'Old Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (326, 'credit_customer', 'Credit Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (327, 'account_already_exists', 'This Account Already Exists !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (328, 'edit_income', 'Edit Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (329, 'you_are_not_access_this_part', 'You are not authorised person !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (330, 'account_edit', 'Account Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (331, 'due', 'Due', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (332, 'expense_edit', 'Expense Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (333, 'please_select_customer', 'Please select customer !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (334, 'profit_report', 'Profit Report (Invoice Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (335, 'total_profit_report', 'Total profit report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (336, 'please_enter_valid_captcha', 'Please enter valid captcha.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (337, 'category_not_selected', 'Category not selected.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (338, 'manufacturer_not_selected', 'Manufacturer not selected.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (339, 'please_select_product', 'Please select medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (340, 'product_model_already_exist', 'Medicine model already exist !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (341, 'invoice_logo', 'Invoice Logo', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (342, 'available_quantity', 'Available Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (343, 'you_can_not_buy_greater_than_available_quantity', 'You can not select grater than availale quantity !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (344, 'customer_details', 'Customer details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (345, 'manage_customer_details', 'Manage customer details.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (346, 'box_size', 'Box size', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (347, 'expire_date', 'Expiry  date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (348, 'product_location', 'Medicine  Shelf', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (349, 'generic_name', 'Generic name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (350, 'payment_method', 'Payment Method', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (351, 'card_no', 'Card no', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (352, 'medicine', 'Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (353, 'medicine_search', 'Medicine Search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (354, 'what_you_search', 'Enter what you search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (355, 'company', 'Company', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (356, 'customer_search', 'Customer search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (357, 'invoice_search', 'Invoice search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (358, 'purchase_search', 'Purchase search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (359, 'daily_closing_report', 'Daily closing report.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (360, 'closing_search_report', 'Closing Search Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (361, 'category_list', 'Category List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (362, 'company_list', 'Company List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (363, 'customers_list', 'Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (364, 'credit_customer_list', 'Credit Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (365, 'previous_balance_adjustment', 'Previous Balance Adjustment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (366, 'invoice_list', 'Invoice List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (367, 'add_pos_invoice', 'Add POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (368, 'add_invoice', 'Add Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (369, 'product_list', 'Medicine List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (370, 'purchases_list', 'Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (371, 'purchase_list', 'Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (372, 'stock_list', 'Stock List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (373, 'all_report', 'All Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (374, 'daily_sales_report', 'Daily sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (375, 'product_wise_sales_report', 'Medicine Wise Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (376, 'bank_update', 'Bank Update', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (377, 'account_list', 'Account List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (378, 'manufacturer_list', 'Manufacturer  List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (379, 'manufacturer_search_item', 'Manufacturer  Search Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (380, 'user_list', 'User List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (381, 'user_search_item', 'User Search Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (382, 'change_password', 'Change Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (383, 'admin_login_area', 'Admin Login Area', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (384, 'accounts_inflow_form', 'Account Inflow Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (385, 'accounts_outflow_form', 'Accounts Outflow Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (386, 'accounts_tax_form', 'Accounts Tax Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (387, 'accounts_manage_tax', 'Accounts Manage Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (388, 'accounts_tax_edit', 'Accounts Tax Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (389, 'accounts_summary_data', 'Accounts Summary Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (390, 'accounts_details_data', 'Accounts Details Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (391, 'datewise_summary_data', 'Datewise Summary Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (392, 'accounts_cheque_manager', 'Account Cheque Manager', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (393, 'accounts_edit_data', 'Accounts Edit Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (394, 'print_barcode', 'Print Barcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (395, 'print_qrcode', 'Print Qrcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (396, 'add_new_account', 'Add New Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (397, 'table_edit', 'Table Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (398, 'secret_key', 'Secret Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (399, 'site_key', 'Site Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (400, 'captcha', 'Captcha', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (401, 'please_add_walking_customer_for_default_customer', 'Please add walking customer for default customer. ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (402, 'barcode_qrcode_scan_here', 'Barcode Or QRcode scan here', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (403, 'manage_your_credit_customer', 'Manage your credit customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (404, 'unit', 'Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (405, 'total_discount', 'Total Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (406, 'meter_m', 'Meter (M)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (407, 'piece_pc', 'Piece (Pc)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (408, 'kilogram_kg', 'Kilogram (Kg)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (409, 'import_product_csv', 'Import Medicine (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (410, 'close', 'Close', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (411, 'csv_file_informaion', 'File Information (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (412, 'download_example_file', 'Download Example File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (413, 'upload_csv_file', 'Upload CSV File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (414, 'manufacturer_id', 'Manufacturer ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (415, 'category_id', 'Category ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (416, 'are_you_sure_to_delete', 'Are you sure,want to delete ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (417, 'stock_report_manufacturer_wise', 'Stock Report (Manufacturer Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (418, 'stock_report_product_wise', 'Stock Report (Medicine Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (419, 'select_manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (420, 'select_product', 'Select Medicine ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (421, 'phone', 'Phone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (422, 'in_quantity', 'In Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (423, 'out_quantity', 'Sold QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (424, 'in_taka', 'In Taka', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (425, 'out_taka', 'Out Taka', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (426, 'data_synchronizer', 'Data Synchronizer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (427, 'synchronize', 'Synchronize', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (428, 'backup_restore', 'Backup And Restore', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (429, 'synchronizer_setting', 'Synchronizer Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (430, 'backup_and_restore', 'Backup And Restore', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (431, 'hostname', 'Host Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (432, 'username', 'User Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (433, 'ftp_port', 'FTP Port', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (434, 'ftp_debug', 'FTP Debug', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (435, 'project_root', 'Project Root', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (436, 'internet_connection', 'Internet connection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (437, 'ok', 'Ok', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (438, 'not_available', 'Not available', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (439, 'outgoing_file', 'Outgoing File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (440, 'available', 'Available', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (441, 'incoming_file', 'Incoming file', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (442, 'data_upload_to_server', 'Data upload to server', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (443, 'download_data_from_server', 'Download data from server', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (444, 'data_import_to_database', 'Data import to database', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (445, 'please_wait', 'Please Wait', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (446, 'ooops_something_went_wrong', 'Ooops something went wrong', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (447, 'file_information', 'File Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (448, 'size', 'Size', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (449, 'backup_date', 'Backup date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (450, 'backup_now', 'Backup Now', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (451, 'are_you_sure', 'Are you sure ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (452, 'download', 'Downlaod', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (453, 'database_backup', 'Database Backup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (454, 'backup_successfully', 'Backup Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (455, 'please_try_again', 'Please Try Again', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (456, 'restore_successfully', 'Restore successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (457, 'download_successfully', 'Download Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (458, 'delete_successfully', 'Delete Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (459, 'ftp_setting', 'FTP Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (460, 'save_successfully', 'Save successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (461, 'upload_successfully', 'Upload successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (462, 'unable_to_upload_file_please_check_configuration', 'unable to upload file please check configuration.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (463, 'please_configure_synchronizer_settings', 'Please Configure Synchronizer Settings ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (464, 'unable_to_download_file_please_check_configuration', 'Unable To Download File,Please Check Configuration.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (465, 'data_import_first', 'Data Import First', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (466, 'data_import_successfully', 'Data Import Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (467, 'unable_to_import_data_please_check_config_or_sql_file', 'Unable to import data please check config or sql file.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (468, 'restore_now', 'Restore Now', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (469, 'out_of_stock', 'Out Of Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (470, 'others', 'Others', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (471, 'shelf', 'Shelf', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (472, 'discount_type', 'Discount Type ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (473, 'discount_percentage', 'Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (474, 'fixed_dis', 'Fixed Dis', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (475, 'full_paid', 'Full Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (476, 'available_qnty', 'Ava.Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (477, 'stock_ctn', 'Stock/Qnt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (478, 'sale_price', 'Sale Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (479, 'manufacturer_rate', 'Manufacturer  Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (480, 'please_upload_image_type', 'Sorry!!! Please Upload jpg,jpeg,png,gif typeimage', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (481, 'ml', 'Milli liter(ml)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (482, 'mg', 'Milli Gram(mg)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (483, 'you_can_not_buy_greater_than_available_qnty', 'You can not sale more than available quantity ! please purchase this Product', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (484, 'due_amount', 'Due Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (485, 'return_invoice', 'Return Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (486, 'sold_qty', 'Sold Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (487, 'ret_quantity', 'Return QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (488, 'deduction', 'Deduction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (489, 'return', 'Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (490, 'note', 'Return Reasone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (491, 'usablilties', 'Return Usability', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (492, 'adjs_with_stck', 'Adjust With Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (493, 'return_to_manufacturer', 'Return To Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (494, 'wastage', 'Wastage', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (495, 'to_deduction', 'Total Deduction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (496, 'nt_return', 'Net Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (497, 'return_id', 'Return Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (498, 'return_details', 'Return Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (499, 'add_return', 'Add Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (500, 'return_list', 'Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (501, 'stock_return_list', 'Stock Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (502, 'wastage_return_list', 'Wastage Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (503, 'check_return', 'Check Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (504, 'quantity_must_be_fillup', 'Return Quantity Must be Fill Up', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (505, 'expeire_date', 'Expiry  date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (506, 'batch_id', 'Batch ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (507, 'manufacturer_return_list', 'Manufacturer  Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (508, 'c_r_slist', 'Customer Return List ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (509, 'manufacturer_return', 'Manufacturer  Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (510, 'wastage_list', 'Wastage List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (511, 'in_qnty', 'In Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (512, 'out_qnty', 'Sold QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (513, 'stock_sale', 'Stock Sell Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (514, 'add_product_csv', 'Import Medicine (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (515, 'purchase_id', 'Purchase ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (516, 'add_payment', 'Add Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (517, 'add_new_payment', 'Add new Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (518, 'transaction', 'Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (519, 'manage_transaction', 'Manage Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (520, 'choose_transaction', 'Choose Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (521, 'receipt', 'Receipt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (522, 'payment', 'Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (523, 'transaction_categry', 'Transaction Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (524, 'transaction_mood', 'Transaction Mood', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (525, 'payment_amount', 'Payment Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (526, 'receipt_amount', 'Receipt Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (527, 'daily_summary', 'Daily Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (528, 'daily_cash_flow', 'Daily  Cashflow', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (529, 'custom_report', 'Custom Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (530, 'root_account', 'Root Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (531, 'office', 'Office', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (532, 'loan', 'Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (533, 'successfully_saved', 'Successfully Saved', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (534, 'bank', 'Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (535, 'bank_transaction', 'Bank Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (536, 'office_loan', 'Office Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (537, 'add_person', 'Add Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (538, 'manage_loan', 'Manage Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (539, 'add_loan', 'Add Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (540, 'ac_name', 'Account Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (541, 'ac_no', 'Account No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (542, 'branch', 'Branch', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (543, 'signature_pic', 'Signature ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (544, 'withdraw_deposite_id', 'Withdraw Deposit ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (545, 'select_report', 'Select Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (546, 'per_qty', 'Purchase Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (547, 'stock_report_batch_wise', 'Stock Report(Batch Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (548, 'box', 'Box', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (549, 'gram', 'Gram', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (550, 'profit_report_manufacturer_wise', 'Profit/Loss Report(Manufacturer)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (551, 'calculate', 'Calculate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (552, 'profit_report_product_wise', 'Profit/Loss  Report Product Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (553, 'view_report', 'View Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (554, 'report_for', 'Report For', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (555, 'total_sale_qty', 'Total Sale QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (556, 'total_purchase_pric', 'Total purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (557, 'total_sale', 'Total Sale', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (558, 'net_profit', 'Net Profit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (559, 'loss', 'Loss', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (560, 'product_type', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (561, 'add_type', 'Add Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (562, 'add_new_type', 'Add New Medicine  Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (563, 'type', 'Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (564, 'type_name', 'Type Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (565, 'manage_type', 'Manage Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (566, 'type_id', 'Type Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (567, 'type_edit', 'Edit Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (568, 'profitloss', 'profit/Loss', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (569, 'manufacturer_wise', 'Manufacturer Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (570, 'product_wise', 'Medicine Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (571, 'medicine_info', 'Medicine Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (572, 'choose_another_invno', 'Choose Another Invoice No !!', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (573, 'return_manufacturers', 'Return Manufacturers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (574, 'return_manufacturer', 'Return Manufacturers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (575, 'please_input_correct_invoice_no', 'Please Input Correct Invoice No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (576, 'stock_purchase_price', 'Stock Purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (577, 'manufacturer_returns', 'Manufacturer  Return ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (578, 'invoice_discount', 'Invoice Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (579, 'qty', 'Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (580, 'discounts', 'Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (581, 'sub_total', 'Sub Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (582, 'paid', 'Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (583, 'change', 'Change', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (584, 'purchase_price', 'Purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (585, 'expiry', 'Expiry', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (586, 'batch', 'Batch', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (587, 'role_permission', 'Role Permission', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (588, 'user_assign_role', 'Assign  User Role', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (589, 'permission', 'Permission', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (590, 'personal_loan', 'Personal Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (591, 'role_name', 'Role Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (592, 'create', 'Create', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (593, 'read', 'Read', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (594, 'add_role', 'Add Role', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (595, 'You do not have permission to access. Please contact with administrator.', 'You do not have permission to access. Please contact with administrator.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (596, 'role_permission_added_successfully', 'Role Permission Added successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (597, 'role_list', 'Role List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (598, 'role_permission_updated_successfully', 'Role Permission Updated Successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (599, 'add_phrase', 'Add Phrase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (600, 'language_home', 'Language Home', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (601, 'phrase_edit', 'Phrase Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (602, 'no_role_selected', 'No Role Selected', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (603, 'category_added_successfully', 'Category added successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (604, 'category_already_exist', 'Category already exist', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (605, 'select_manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (607, 'select_tax', 'Select Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (608, 'must_input_numbers', 'Must input numbers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (609, 'please_check_your_price', 'Please Check Your Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (610, 'your_profit_is', 'Your Profit is', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (611, 'failed', 'Failed', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (612, 'you_have_reached_the_limit_of_adding', 'You have reached the limit of adding', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (613, 'inputs', 'inputs', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (614, 'expiry_date_should_be_greater_than_puchase_date', 'Expiry Date should be greater than Puchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (615, 'expiry_date_should_be_greater_than_puchase_date', 'Expiry Date should be greater than Puchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (616, 'product_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (617, 'total_quantity', 'Total Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (618, 'rates', 'Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (619, 'total_amount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (621, 'receipt_detail', 'Receipt Detail', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (622, 'amount', 'Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (623, 'save_and_add_another_one', 'Save and add another one', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (624, 'checque_number', 'Checque Number', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (625, 'edit_receipt', 'Edit Receipt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (626, 'receipt_list', 'Receipt List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (627, 'search_by_customer_name', 'Search By Customer Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (628, 'actions', 'Actions', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (629, 'no_data_found', 'No Data Found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (630, 'edit', 'Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (631, 'product_not_found', 'Medicine  not found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (632, 'request_failed_please_check_your_code_and_try_again', 'Request Failed, Please check your code and try again', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (633, 'You_can_not_return_more_than_sold_quantity', 'You Can Not Return More than Sold quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (634, 'you_can_not_return_less_than_1', 'You Can Not Return Less than 1', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (635, 'transection_details', 'Transection Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (636, 'transection_details_datewise', 'Transection  Details Datewise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (637, 'transection_id', 'Transactions ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (638, 'select_option', 'Select Option', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (639, 'loan_list', 'Loan List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (640, 'todays_details', 'Todays Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (641, 'transaction_details', 'Transaction Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (642, 'person_id', 'Person ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (643, 'total_transection', 'Total Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (644, 'transaction_id', 'Transaction ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (645, 'transection_report', 'Transection Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (646, 'add_transection', 'Add Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (647, 'manage_transection', 'Manage Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (648, 'select_id', 'Select ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (649, 'choose_transection', 'Choose Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (650, 'update_transection', 'Update Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (651, 'manufacturer_all', 'Manufacturer All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (652, 'select_all', 'Select All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (653, 'all', 'All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (654, 'max_rate', 'Max Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (655, 'min_rate', 'Min Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (656, 'average_rate', 'Average Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (657, 'date_expired_please_choose_another.', 'Date Expired!! Please Choose another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (658, 'your_medicine_is_date_expiry_Please_choose_another', 'Your Medicine is Date Expiry !! Please Choose another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (659, 'meno', 'MEMO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (660, 'out_of_stock_and_date_expired_medicine', 'Out of Stock and Date Expired Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (661, 'edit_profile', 'Edit Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (662, 'deposit_detail', 'Deposit detail', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (663, 'new_deposit', 'New Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (664, 'edit_deposit', 'Edit Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (665, 'select_customer', 'Select Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (666, 'draw', 'Draw', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (667, 'deposit', 'Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (668, 'select_type', 'Select Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (669, 'transaction_type', 'Transaction Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (670, 'cash', 'Cash', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (671, 'select_bank', 'Select Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (672, 'drawing', 'Drawing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (673, 'expenses', 'Expenses', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (674, 'banking', 'Banking', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (675, 'daily_closing', 'Daily Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (676, 'title', 'Title', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (677, 'error_get_data_from_ajax', 'Error get data from ajax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (678, 'toggle_navigation', 'Toggle Navigation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (679, 'this_product_not_found', 'This Medicine  Not Found !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (680, 'search_by_date_from', 'Search By Date: From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (681, 'manufacturer_sales_report', 'Manufacturer Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (682, 'transection', 'Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (683, 'transection_mood', 'Transection Mood', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (684, 'transection_categry', 'Transection Categry', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (685, 'export_csv', 'Export CSV', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (686, 'select manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (687, 'customer_return', 'Customer Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (688, 'return_form', 'Return Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (689, 'data_not_found', 'Data Not Found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (690, 'export_csv', 'Export CSV', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (691, 'manage_person', 'Manage Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (692, 'backup', 'Back Up', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (693, 'total_balance', 'Total Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (694, 'product_id_model_manufacturer_id_can_not_null', 'Medicine Id & Medicine Type & Manufacturer Id Can not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (695, 'product_name_can_not_be_null', 'Medicine  Name can Not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (696, 'product_model_can_not_be_null', 'Medicine  Model Can Not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (697, 'sms', 'SMS', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (698, 'sms_configure', 'Sms Configuration', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (699, 'url', 'Url', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (700, 'sender_id', 'Sender ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (701, 'api_key', 'Api Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (702, 'barcode_or_qrcode', 'Barcode Or QRcode ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (703, 'currency_name', 'Currency Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (704, 'add_currency', 'Add Currency', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (705, 'currency_icon', 'Currency Icon', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (706, 'currency_list', 'Currency List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (707, 'import', 'Import', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (708, 'c_o_a', 'Chart Of Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (709, 'supplier_payment', 'Supplier Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (710, 'customer_receive', 'Customer Receive', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (711, 'debit_voucher', 'Debit Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (712, 'credit_voucher', 'Credit voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (713, 'voucher_approval', 'Voucher Approval', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (714, 'contra_voucher', 'Contra Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (715, 'journal_voucher', 'Journal Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (716, 'voucher_report', 'Voucher Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (717, 'cash_book', 'Cash Book', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (718, 'inventory_ledger', 'Inventory Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (719, 'bank_book', 'Bank Book', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (720, 'general_ledger', 'General Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (721, 'trial_balance', 'Trial Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (722, 'profit_loss_report', 'Profit Loss Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (723, 'cash_flow', 'Cash Flow', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (724, 'coa_print', 'COA Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (725, 'manufacturer_payment', 'Manufacturer Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (726, 'add_more', 'Add More', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (727, 'code', 'Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (728, 'remark', 'Transaction Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (729, 'voucher_no', 'Voucher NO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (730, 'accounts_tree_view', 'Accounts Tree view', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (731, 'find', 'Find', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (732, 'voucher_type', 'Voucher Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (733, 'particulars', 'Particulars', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (734, 'cash_flow_statement', 'Cash Flow Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (735, 'amount_in_dollar', 'Amount In Dollar', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (736, 'opening_cash_and_equivalent', 'Opening Cash and Equivalent', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (737, 'with_details', 'With Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (738, 'transaction_head', 'Transaction Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (739, 'gl_head', 'General Ledger Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (740, 'no_report', 'No Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (741, 'pre_balance', 'Pre Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (742, 'current_balance', 'Current Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (743, 'from_date', 'From Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (744, 'to_date', 'To Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (745, 'profit_loss', 'Profit Loss Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (746, 'add_expense_item', 'Add Expense Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (747, 'manage_expense_item', 'Manage Expense Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (748, 'add_expense', 'Add Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (749, 'manage_expense', 'Manage Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (750, 'expense_statement', 'Expense Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (751, 'expense_type', 'Expense Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (752, 'expense_item_name', 'Expense Item Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (753, 'opening_balance', 'Opening Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (754, 'tax_settings', 'Tax Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (755, 'add_incometax', 'Add Income Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (756, 'manage_income_tax', 'Manage Income tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (757, 'tax_report', 'Tax Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (758, 'invoice_wise_tax_report', 'Invoice Wise Tax Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (759, 'number_of_tax', 'Number of Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (760, 'default_value', 'Default Value', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (761, 'reg_no', 'Registration No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (762, 'tax_name', 'Tax Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (763, 'service_id', 'Service Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (764, 'service', 'Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (765, 'add_service', 'Add Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (766, 'manage_service', 'Manage Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (767, 'service_invoice', 'Service Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (768, 'manage_service_invoice', 'Manage Service Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (769, 'service_name', 'Service Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (770, 'charge', 'Charge', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (771, 'add', 'Add', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (772, 'previous', 'Previous', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (773, 'net_total', 'Net Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (774, 'hanging_over', 'Estimated Time Of Departure', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (775, 'service_discount', 'Service Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (776, 'hrm', 'HRM', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (777, 'add_designation', 'Add Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (778, 'manage_designation', 'Manage Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (779, 'add_employee', 'Add Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (780, 'manage_employee', 'Manage Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (781, 'attendance', 'Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (782, 'add_attendance', 'Add Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (783, 'manage_attendance', 'Manage Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (784, 'attendance_report', 'Attendance Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (785, 'payroll', 'Payroll', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (786, 'add_benefits', 'Add Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (787, 'manage_benefits', 'Manage Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (788, 'add_salary_setup', 'Add Salary Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (789, 'manage_salary_setup', 'Manage Salary Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (790, 'salary_generate', 'Salary Generate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (791, 'manage_salary_generate', 'Manage Salary Generate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (792, 'salary_payment', 'Salary Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (793, 'designation', 'Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (794, 'rate_type', 'Rate Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (795, 'hour_rate_or_salary', 'Hourly Rate/Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (796, 'blood_group', 'Blood Group', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (797, 'address_line_1', 'Address Line 1', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (798, 'address_line_2', 'Address Line 2', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (799, 'picture', 'Picture', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (800, 'country', 'Country', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (801, 'city', 'City', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (802, 'zip', 'Zip code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (803, 'single_checkin', 'Single Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (804, 'bulk_checkin', 'Bulk Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (805, 'checkin', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (806, 'employee_name', 'Employee Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (807, 'check_in', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (808, 'checkout', 'Check Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (809, 'confirm_clock', 'Confirm Clock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (810, 'stay', 'Stay', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (811, 'download_sample_file', 'Download Sample File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (812, 'employee', 'Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (813, 'sign_in', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (814, 'sign_out', 'Check  Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (815, 'staytime', 'Stay Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (816, 'benefits_list', 'Benefit List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (817, 'benefits', 'Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (818, 'benefit_type', 'Benefit Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (819, 'salary_benefits', 'Salary Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (820, 'salary_benefits_type', 'Salary Benefits Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (821, 'hourly', 'Hourly', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (822, 'salary', 'Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (823, 'timezone', 'Time Zone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (824, 'request', 'Request', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (825, 'datewise_report', 'Date Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (826, 'work_hour', 'Work Hours', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (827, 'employee_wise_report', 'Employee Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (828, 'date_in_time_report', 'In Time Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (829, 'successfully_checkout', 'Successfully Checked Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (830, 'setup_tax', 'Setup Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (831, 'start_amount', 'Start Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (832, 'end_amount', 'End Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (833, 'tax_rate', 'Tax Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (834, 'setup', 'Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (835, 'income_tax_updateform', 'Income Tax Update Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (836, 'salary_type', 'Salary Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (837, 'addition', 'Addition', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (838, 'gross_salary', 'Gross Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (839, 'set', 'Set', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (840, 'salary_month', 'Salary Month', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (841, 'generate', 'Generate ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (842, 'total_salary', 'Total Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (843, 'total_working_minutes', 'Total Working Hours', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (844, 'working_period', 'Total Working Days', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (845, 'paid_by', 'Paid By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (846, 'pay_now', 'Pay Now ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (847, 'confirm', 'Confirm', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (848, 'generate_by', 'Generate By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (849, 'gui_pos', 'GUI POS', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (850, 'add_fixed_assets', 'Add Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (851, 'fixed_assets_list', 'Fixed Asset List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (852, 'fixed_assets_purchase', 'Purchase Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (853, 'fixed_assets_purchase_manage', 'Fixed Assets Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (854, 'fixed_assets', 'Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (855, 'item_code', 'Item code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (856, 'item_name', 'Item Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (857, 'opening_assets', 'Assets Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (858, 'edit_fixed_asset', 'Edit Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (859, 'save_change', 'Save Change', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (860, 'in_word', 'In Word', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (861, 'purchase_pad_print', 'Purchase Pad Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (862, 'fixed_assets_purchase_details', 'Fixed Assets Purchase Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (863, 'manage_language', 'Manage Language', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (864, 'person_edit', 'Person Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (865, 'person_ledger', 'Person Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (866, 'medicine_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (867, 'unit_list', 'Unit List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (868, 'add_unit', 'Add Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (869, 'edit_unit', 'Edit Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (870, 'unit_name', 'Unit Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (871, 'unit_not_selected', 'Unit did not Selected', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (872, 'supplier', 'Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (873, 'add_supplier', 'Add Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (874, 'manage_supplier', 'Manage Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (875, 'supplier_ledger', 'Supplier Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (876, 'supplier_sales_details', 'Supplier Sales Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (877, 'purchase_detail', 'Purchase details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (878, 'purchase_information', 'Purchase Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (879, 'account_head', 'Account Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (880, 'transaction_date', 'Transaction Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (881, 'approved', 'Approve', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (882, 'date_wise_report', 'Date Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (883, 'time_wise_report', 'Time Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (884, 'report_date', 'Report Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (885, 's_time', 'Start Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (886, 'e_time', 'End Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (887, 'basic', 'Basic', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (888, 'supplier_name', 'Supplier Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (889, 'supplier_mobile', 'Supplier Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (890, 'supplier_address', 'Supplier Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (891, 'supplier_details', 'Supplier Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (892, 'select_supplier', 'Select Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (893, 'accounts_report', 'Accounts Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (894, 'account_code', 'Account Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (895, 'human_resource_management', 'Human Resource ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (896, 'menu_name', 'Menu Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (897, 'head_of_account', 'Account Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (898, 'successfully_approved', 'Successfully Approved', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (899, 'supplier_edit', 'Supplier Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (900, 'supplier_id', 'Supplier ID', NULL);


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_rtl` varchar(10) NOT NULL DEFAULT 'no',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', 'no', '2021-09-28 09:51:22', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', 'no', '2021-09-28 10:08:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', 'no', '2021-09-28 09:50:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', 'no', '2021-09-16 05:20:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', 'no', '2021-09-28 09:50:48', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Afrikaans', 'af', 'af', 'no', 'no', 'no', '2021-09-28 10:51:19', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Basque', 'eu', 'es', 'no', 'no', 'no', '2021-09-24 06:58:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Bengali', 'bn', 'in', 'no', 'no', 'no', '2021-09-24 06:58:25', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Bosnian', 'bs', 'bs', 'no', 'no', 'no', '2021-09-24 06:58:28', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Welsh', 'cy', 'cy', 'no', 'no', 'no', '2021-09-24 06:58:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Hungarian', 'hu', 'hu', 'no', 'no', 'no', '2021-09-24 06:58:35', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Vietnamese', 'vi', 'vi', 'no', 'no', 'no', '2021-09-24 06:58:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Haitian', 'ht', 'ht', 'no', 'no', 'no', '2021-09-24 06:58:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Galician', 'gl', 'gl', 'no', 'no', 'no', '2021-09-24 06:58:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'nl', 'nl', 'no', 'no', 'no', '2021-09-24 06:58:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Greek', 'el', 'gr', 'no', 'no', 'no', '2021-09-24 06:58:53', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Georgian', 'ka', 'ge', 'no', 'no', 'no', '2021-09-24 06:58:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Gujarati', 'gu', 'in', 'no', 'no', 'no', '2021-09-24 06:58:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Danish', 'da', 'dk', 'no', 'no', 'no', '2021-09-24 06:59:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'Hebrew', 'he', 'il', 'no', 'no', 'no', '2021-09-24 06:59:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Yiddish', 'yi', 'il', 'no', 'no', 'no', '2021-09-24 06:59:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Indonesian', 'id', 'id', 'no', 'no', 'no', '2021-09-24 06:59:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Irish', 'ga', 'ga', 'no', 'no', 'no', '2021-09-24 06:59:14', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Italian', 'it', 'it', 'no', 'no', 'no', '2021-09-24 06:59:17', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Icelandic', 'is', 'is', 'no', 'no', 'no', '2021-09-24 06:59:20', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Spanish', 'es', 'es', 'no', 'no', 'no', '2021-09-24 06:59:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Kannada', 'kn', 'kn', 'no', 'no', 'no', '2021-09-24 06:59:32', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Catalan', 'ca', 'ca', 'no', 'no', 'no', '2021-09-24 06:59:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Chinese', 'zh', 'cn', 'no', 'no', 'no', '2021-09-24 06:59:36', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Korean', 'ko', 'kr', 'no', 'no', 'no', '2021-09-24 06:59:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Xhosa', 'xh', 'ls', 'no', 'no', 'no', '2021-09-24 06:59:42', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'Latin', 'la', 'la', 'no', 'no', 'no', '2021-09-24 06:59:45', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Latvian', 'lv', 'lv', 'no', 'no', 'no', '2021-09-24 06:59:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Lithuanian', 'lt', 'lt', 'no', 'no', 'no', '2021-09-24 06:59:50', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'Malagasy', 'mg', 'mg', 'no', 'no', 'no', '2021-09-24 06:59:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Malay', 'ms', 'ms', 'no', 'no', 'no', '2021-09-24 07:00:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Malayalam', 'ml', 'ml', 'no', 'no', 'no', '2021-09-24 07:00:05', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Maltese', 'mt', 'mt', 'no', 'no', 'no', '2021-09-24 07:00:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Macedonian', 'mk', 'mk', 'no', 'no', 'no', '2021-09-24 07:00:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Maori', 'mi', 'nz', 'no', 'no', 'no', '2021-09-24 07:00:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Marathi', 'mr', 'in', 'no', 'no', 'no', '2021-09-24 07:00:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'Mongolian', 'mn', 'mn', 'no', 'no', 'no', '2021-09-24 07:01:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'German', 'de', 'de', 'no', 'no', 'no', '2021-09-24 07:01:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Nepali', 'ne', 'ne', 'no', 'no', 'no', '2021-09-24 07:01:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Norwegian', 'no', 'no', 'no', 'no', 'no', '2021-09-24 07:01:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Punjabi', 'pa', 'in', 'no', 'no', 'no', '2021-09-24 07:01:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Persian', 'fa', 'ir', 'no', 'no', 'no', '2021-09-24 07:01:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Portuguese', 'pt', 'pt', 'no', 'no', 'no', '2021-09-24 07:01:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Romanian', 'ro', 'ro', 'no', 'no', 'no', '2021-09-24 07:01:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'Russian', 'ru', 'ru', 'no', 'no', 'no', '2021-09-24 07:01:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Cebuano', 'ceb', 'ph', 'no', 'no', 'no', '2021-09-24 07:02:02', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'Sinhala', 'si', 'si', 'no', 'no', 'no', '2021-09-24 07:02:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Slovakian', 'sk', 'sk', 'no', 'no', 'no', '2021-09-24 07:02:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Slovenian', 'sl', 'sl', 'no', 'no', 'no', '2021-09-24 07:02:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Swahili', 'sw', 'ke', 'no', 'no', 'no', '2021-09-24 07:02:12', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'Sundanese', 'su', 'sd', 'no', 'no', 'no', '2021-09-24 07:02:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Thai', 'th', 'th', 'no', 'no', 'no', '2021-09-24 07:02:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'Tagalog', 'tl', 'tl', 'no', 'no', 'no', '2021-09-24 07:02:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Tamil', 'ta', 'in', 'no', 'no', 'no', '2021-09-24 07:02:23', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Telugu', 'te', 'in', 'no', 'no', 'no', '2021-09-24 07:02:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Turkish', 'tr', 'tr', 'no', 'no', 'no', '2021-09-24 07:02:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Uzbek', 'uz', 'uz', 'no', 'no', 'no', '2021-09-24 07:02:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'Urdu', 'ur', 'pk', 'no', 'no', 'no', '2021-09-24 07:02:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Finnish', 'fi', 'fi', 'no', 'no', 'no', '2021-09-24 07:02:37', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'French', 'fr', 'fr', 'no', 'no', 'no', '2021-09-24 07:02:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Hindi', 'hi', 'in', 'no', 'no', 'no', '2021-09-24 07:02:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Czech', 'cs', 'cz', 'no', 'no', 'no', '2021-09-24 07:02:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Swedish', 'sv', 'sv', 'no', 'no', 'no', '2021-09-24 07:02:46', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'Scottish', 'gd', 'gd', 'no', 'no', 'no', '2021-09-24 07:02:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Estonian', 'et', 'et', 'no', 'no', 'no', '2021-09-24 07:02:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Esperanto', 'eo', 'br', 'no', 'no', 'no', '2021-09-24 07:02:55', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Javanese', 'jv', 'id', 'no', 'no', 'no', '2021-09-24 07:02:58', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'Japanese', 'ja', 'jp', 'no', 'no', 'no', '2021-09-24 07:03:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Polish', 'pl', 'pl', 'no', 'no', 'no', '2021-09-28 06:39:06', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Croatia ', 'hr', 'hr', 'no', 'no', 'no', '2021-10-25 07:56:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'Kurdish', 'ku', 'iq', 'no', 'no', 'no', '2021-10-25 07:56:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Lao', 'lo', 'la', 'no', 'no', 'no', '2021-10-25 07:56:47', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `record_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `ip_address` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `agent` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2437 DEFAULT CHARSET=utf8;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-09 13:32:34', '2022-01-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-09 13:32:45', '2022-01-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-09 13:33:06', '2022-01-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-09 13:33:17', '2022-01-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:48:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:48:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:49:16', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:49:16', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:49:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:49:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:50:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:50:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'Record updated On Print Setting id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:50:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'Record updated On Print Setting id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:50:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'Record updated On Print Setting id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:03', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'Record updated On Print Setting id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:03', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'Record updated On Print Setting id 4', 4, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:13', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'Record updated On Print Setting id 4', 4, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:13', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'Record updated On Print Setting id 5', 5, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'Record updated On Print Setting id 5', 5, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'Record updated On Print Setting id 6', 6, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'Record updated On Print Setting id 6', 6, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'Record updated On Print Setting id 7', 7, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'Record updated On Print Setting id 7', 7, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'Record updated On Print Setting id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'Record updated On Print Setting id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:51:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'Record updated On Print Setting id 9', 9, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:52:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'Record updated On Print Setting id 9', 9, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:52:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'Record updated On Print Setting id 10', 10, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:52:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'Record updated On Print Setting id 10', 10, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:52:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'Record updated On Print Setting id 11', 11, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:52:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'Record updated On Print Setting id 11', 11, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:52:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'Record updated On Print Setting id 12', 12, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:53:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'Record updated On Print Setting id 12', 12, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:53:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'Record updated On Print Setting id 13', 13, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:53:39', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'Record updated On Print Setting id 13', 13, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:53:39', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'Record updated On Print Setting id 14', 14, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:53:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'Record updated On Print Setting id 14', 14, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:53:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'Record updated On Print Setting id 15', 15, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:54:08', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'Record updated On Print Setting id 15', 15, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:54:08', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'Record updated On Print Setting id 16', 16, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:54:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'Record updated On Print Setting id 16', 16, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 21:54:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 22:02:11', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-10 22:03:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:04:37', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'Record updated For Staff id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:06:15', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'Record updated For Staff id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:07:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'Record updated Change Password For Staff id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:09:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:10:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'Record updated For Staff id 4', 4, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:49:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:49:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'Record updated For Staff id 5', 5, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:51:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'Record updated Change Password For Staff id 5', 5, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:51:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'Record updated For Staff id 6', 6, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:52:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'Record updated Change Password For Staff id 6', 6, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:53:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted On Pathology Category id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:10:37', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'New Record inserted On Charge Units id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:11:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'Record updated On Charge Units id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:12:07', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'New Record inserted On Tax Category id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:12:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'New Record inserted On Charge Categories id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:13:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'Record updated On Charge Categories id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:15:00', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'New Record inserted On Unit id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:18:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'New Record inserted On Radiology Parameter id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:18:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'New Record inserted On Unit id 2', 2, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:20:39', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'New Record inserted On Pathology Parameter id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:21:01', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On pathology Test id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:21:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'Record deleted On roles Permissions where Role id  2', 2, 1, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 05:34:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'New Record inserted On Pathology Category id 2', 2, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:38:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'New Record inserted On pathology Test id 2', 2, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:50:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'New Record inserted On pathology Test id 3', 3, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:51:49', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'New Record inserted On Pathology Category id 3', 3, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:52:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On Pathology Category id 4', 4, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:53:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On Pathology Category id 5', 5, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:54:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'New Record inserted On Pathology Category id 6', 6, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:54:28', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'New Record inserted On Pathology Category id 7', 7, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:54:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'New Record inserted On Pathology Category id 8', 8, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:55:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'New Record inserted On Pathology Category id 9', 9, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:55:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'New Record inserted On Pathology Category id 10', 10, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:55:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'New Record inserted On Pathology Category id 11', 11, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:56:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'New Record inserted On Pathology Category id 12', 12, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:56:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'New Record inserted On Pathology Category id 13', 13, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:57:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'New Record inserted On Pathology Category id 14', 14, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:57:30', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'New Record inserted On Pathology Category id 15', 15, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:57:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'New Record inserted On Pathology Category id 16', 16, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:57:50', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'Record updated On Pathology Category id 16', 16, 2, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 05:58:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'New Record inserted On Charge Categories id 2', 2, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:06:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On Charge Categories id 3', 3, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:07:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'New Record inserted On Charge Categories id 4', 4, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:07:47', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'New Record inserted On Charge Categories id 5', 5, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:08:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'New Record inserted On Charge Categories id 6', 6, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:08:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'New Record inserted On Charge Categories id 7', 7, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:09:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'New Record inserted On Charge Categories id 8', 8, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:09:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'New Record inserted On Charge Categories id 9', 9, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:09:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'New Record inserted On Charge Categories id 10', 10, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:10:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On Charge Categories id 11', 11, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:13:50', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'New Record inserted On Charge Categories id 12', 12, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:14:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'New Record inserted On Charge Categories id 13', 13, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:15:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'New Record inserted On Charge Categories id 14', 14, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:15:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'New Record inserted On Charge Categories id 15', 15, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:16:14', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'New Record inserted On Charge Categories id 16', 16, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:16:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'Record updated For Staff id 7', 7, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:16:37', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'New Record inserted On Charge Categories id 17', 17, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:16:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'Record deleted On Charge Categories id 17', 17, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:16:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'New Record inserted On Patient id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:17:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'Record updated On Patient id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:17:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'New Record inserted On Transactions id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:18:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'New Record inserted On pathology Test id 4', 4, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:21:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'New Record inserted On pathology Test id 5', 5, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:23:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On pathology Test id 6', 6, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:28:18', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'New Record inserted On Patient id 2', 2, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:28:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'Record updated On Patient id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:28:30', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'New Record inserted On Charge Categories id 18', 18, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:29:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'New Record inserted On pathology Test id 7', 7, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:30:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'New Record inserted On Transactions id 2', 2, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:32:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'New Record inserted On pathology Test id 8', 8, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:32:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'New Record inserted On pathology Test id 9', 9, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:35:23', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'New Record inserted On pathology Test id 10', 10, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:36:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'New Record inserted On Transactions id 3', 3, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 06:43:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'New Record inserted On pathology Test id 11', 11, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:47:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'Record deleted On Charges id 13', 13, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'Record deleted On Charges id 12', 12, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'Record deleted On Charges id 12', 12, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:43', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'Record deleted On Charges id 12', 12, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:48:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'Record deleted On Charges id 10', 10, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'Record deleted On Charges id 9', 9, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'Record deleted On Charges id 8', 8, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:16', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'Record deleted On Charges id 7', 7, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'Record deleted On Charges id 6', 6, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'Record deleted On Charges id 6', 6, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:46', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:46', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:49:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:15', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:26', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'Record deleted On Charges id 4', 4, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:39', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'Record deleted On Charges id 4', 4, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'Record deleted On Charges id 4', 4, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'Record deleted On Charges id 3', 3, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'Record deleted On Charges id 3', 3, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'Record deleted On Charges id 1', 1, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 06:50:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:02:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On pathology Test id 12', 12, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:02:50', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'New Record inserted On Transactions id 4', 4, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:04:14', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:05:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:05:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'Record deleted On Charges id 14', 14, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:08:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'New Record inserted On Staff Designation id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:09:49', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'New Record inserted On Department id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:10:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:10:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:10:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'New Record inserted On pathology Test id 13', 13, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:11:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'Record updated On Pathology Report id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:11:30', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'New Record inserted On pathology Test id 14', 14, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:13:38', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'New Record inserted On pathology Test id 15', 15, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:37:11', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'New Record inserted On pathology Test id 16', 16, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:39:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'New Record inserted On pathology Test id 17', 17, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:41:18', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'New Record inserted On pathology Test id 18', 18, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:42:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'New Record inserted On pathology Test id 19', 19, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:43:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'New Record inserted On pathology Test id 20', 20, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:44:00', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'New Record inserted On pathology Test id 21', 21, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:44:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On pathology Test id 22', 22, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:45:27', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'New Record inserted On pathology Test id 23', 23, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:46:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'New Record inserted On pathology Test id 24', 24, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:48:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'New Record inserted On pathology Test id 25', 25, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:49:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'New Record inserted On pathology Test id 26', 26, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:51:46', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'New Record inserted On pathology Test id 27', 27, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:52:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'New Record inserted On pathology Test id 28', 28, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:53:13', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'New Record inserted On pathology Test id 29', 29, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:54:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'New Record inserted On pathology Test id 30', 30, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:54:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'New Record inserted On pathology Test id 31', 31, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:54:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'New Record inserted On pathology Test id 32', 32, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:55:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'New Record inserted On pathology Test id 33', 33, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:56:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'New Record inserted On pathology Test id 34', 34, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 07:56:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'New Record inserted On pathology Test id 35', 35, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:59:38', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'New Record inserted On pathology Test id 36', 36, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 07:59:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'New Record inserted On pathology Test id 37', 37, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:02:27', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'New Record inserted On pathology Test id 38', 38, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:04:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'New Record inserted On pathology Test id 39', 39, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:05:08', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On pathology Test id 40', 40, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:05:26', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'New Record inserted On pathology Test id 41', 41, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:06:07', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'New Record inserted On pathology Test id 42', 42, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:06:08', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'New Record inserted On pathology Test id 43', 43, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:06:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'New Record inserted On pathology Test id 44', 44, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:07:07', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'New Record inserted On pathology Test id 45', 45, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:07:11', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'New Record inserted On pathology Test id 46', 46, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:07:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'New Record inserted On pathology Test id 47', 47, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:07:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'New Record inserted On pathology Test id 48', 48, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:08:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'New Record inserted On pathology Test id 49', 49, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:08:14', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'New Record inserted On pathology Test id 50', 50, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:09:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'New Record inserted On pathology Test id 51', 51, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:09:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On pathology Test id 52', 52, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:09:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'New Record inserted On pathology Test id 53', 53, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:10:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'New Record inserted On pathology Test id 54', 54, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:10:38', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'New Record inserted On pathology Test id 55', 55, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:10:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'New Record inserted On pathology Test id 56', 56, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:11:02', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'New Record inserted On pathology Test id 57', 57, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:11:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On pathology Test id 58', 58, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:12:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'New Record inserted On pathology Test id 59', 59, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:12:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On pathology Test id 60', 60, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:12:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'New Record inserted On pathology Test id 61', 61, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:14:00', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'New Record inserted On pathology Test id 62', 62, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:14:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'New Record inserted On pathology Test id 63', 63, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:14:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On pathology Test id 64', 64, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:14:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'New Record inserted On pathology Test id 65', 65, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:15:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'New Record inserted On pathology Test id 66', 66, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:15:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'New Record inserted On pathology Test id 67', 67, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:15:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On pathology Test id 68', 68, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:16:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'New Record inserted On pathology Test id 69', 69, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:16:36', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'New Record inserted On pathology Test id 70', 70, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:16:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On pathology Test id 71', 71, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:17:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'New Record inserted On pathology Test id 72', 72, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:17:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'New Record inserted On pathology Test id 73', 73, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:17:38', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'New Record inserted On pathology Test id 74', 74, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:18:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'New Record inserted On pathology Test id 75', 75, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:18:23', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'New Record inserted On pathology Test id 76', 76, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:18:37', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On pathology Test id 77', 77, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:19:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'New Record inserted On pathology Test id 78', 78, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:19:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'New Record inserted On pathology Test id 79', 79, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:19:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'New Record inserted On pathology Test id 80', 80, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:19:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'New Record inserted On pathology Test id 81', 81, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:20:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'New Record inserted On pathology Test id 82', 82, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:20:23', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'New Record inserted On pathology Test id 83', 83, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:21:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On pathology Test id 84', 84, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:21:11', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'New Record inserted On pathology Test id 85', 85, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:21:35', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'New Record inserted On pathology Test id 86', 86, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:22:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'New Record inserted On pathology Test id 87', 87, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:22:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'New Record inserted On pathology Test id 88', 88, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:22:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'New Record inserted On pathology Test id 89', 89, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:23:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'New Record inserted On pathology Test id 90', 90, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:23:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'New Record inserted On pathology Test id 91', 91, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:23:23', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'New Record inserted On pathology Test id 92', 92, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:23:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'New Record inserted On pathology Test id 93', 93, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:24:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'New Record inserted On pathology Test id 94', 94, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:24:26', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'New Record inserted On pathology Test id 95', 95, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:24:36', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'New Record inserted On pathology Test id 96', 96, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:24:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'New Record inserted On pathology Test id 97', 97, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:25:01', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'New Record inserted On pathology Test id 98', 98, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:25:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'New Record inserted On pathology Test id 99', 99, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:26:03', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'New Record inserted On pathology Test id 100', 100, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:26:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'New Record inserted On pathology Test id 101', 101, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:26:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'New Record inserted On pathology Test id 102', 102, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:26:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'New Record inserted On pathology Test id 103', 103, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:26:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'New Record inserted On pathology Test id 104', 104, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:27:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'New Record inserted On Pathology Category id 17', 17, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:28:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'New Record inserted On pathology Test id 105', 105, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:28:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'New Record inserted On pathology Test id 106', 106, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:29:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'New Record inserted On pathology Test id 107', 107, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:29:50', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'New Record inserted On pathology Test id 108', 108, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:30:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'New Record inserted On pathology Test id 109', 109, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:30:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'New Record inserted On pathology Test id 110', 110, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:30:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'New Record inserted On pathology Test id 111', 111, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:31:35', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'New Record inserted On pathology Test id 112', 112, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:31:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'New Record inserted On pathology Test id 113', 113, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 08:32:01', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'New Record inserted On pathology Test id 114', 114, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:32:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'New Record inserted On pathology Test id 115', 115, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 08:32:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:25:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:25:15', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:25:28', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:26:36', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'New Record inserted On pathology Test id 116', 116, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:35:43', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'New Record inserted On Read System Notification id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:35:49', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'New Record inserted On Read System Notification id 2', 2, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:35:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'New Record inserted On Read System Notification id 3', 3, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:35:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'New Record inserted On Read System Notification id 4', 4, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:35:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'New Record inserted On Read System Notification id 5', 5, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:35:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'New Record inserted On Read System Notification id 6', 6, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:35:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'New Record inserted On Read System Notification id 7', 7, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:35:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'New Record inserted On Read System Notification id 8', 8, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:37:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'New Record inserted On Read System Notification id 9', 9, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:37:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'New Record inserted On Read System Notification id 10', 10, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:37:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'New Record inserted On Read System Notification id 11', 11, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:37:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 22:38:16', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'New Record inserted On pathology Test id 117', 117, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:44:35', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'New Record inserted On pathology Test id 118', 118, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:45:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'New Record inserted On pathology Test id 119', 119, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:45:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'New Record inserted On pathology Test id 120', 120, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:47:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'New Record inserted On pathology Test id 121', 121, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:48:13', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'New Record inserted On pathology Test id 122', 122, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:48:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'New Record inserted On pathology Test id 123', 123, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:50:01', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'New Record inserted On pathology Test id 124', 124, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:50:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'New Record inserted On pathology Test id 125', 125, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:51:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'New Record inserted On pathology Test id 126', 126, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:51:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'New Record inserted On pathology Test id 127', 127, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:51:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'New Record inserted On pathology Test id 128', 128, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:52:30', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'New Record inserted On pathology Test id 129', 129, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:53:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'New Record inserted On pathology Test id 130', 130, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:57:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'New Record inserted On pathology Test id 131', 131, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:57:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'New Record inserted On pathology Test id 132', 132, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:57:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'New Record inserted On pathology Test id 133', 133, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:58:26', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'New Record inserted On pathology Test id 134', 134, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:58:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'New Record inserted On pathology Test id 135', 135, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:58:43', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'New Record inserted On pathology Test id 136', 136, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:59:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'New Record inserted On pathology Test id 137', 137, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:59:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'New Record inserted On pathology Test id 138', 138, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 23:59:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'New Record inserted On pathology Test id 139', 139, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:00:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'New Record inserted On pathology Test id 140', 140, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:01:25', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'New Record inserted On pathology Test id 141', 141, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:01:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'New Record inserted On pathology Test id 142', 142, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:02:00', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'New Record inserted On pathology Test id 143', 143, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:02:37', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'New Record inserted On pathology Test id 144', 144, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:03:20', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'New Record inserted On pathology Test id 145', 145, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:03:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'New Record inserted On pathology Test id 146', 146, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:04:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'New Record inserted On pathology Test id 147', 147, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:04:43', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'New Record inserted On pathology Test id 148', 148, 4, 'Insert', '103.102.247.6', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:05:11', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'New Record inserted On pathology Test id 149', 149, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:06:22', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'New Record inserted On pathology Test id 150', 150, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:07:37', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'New Record inserted On pathology Test id 151', 151, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:09:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'New Record inserted On pathology Test id 152', 152, 6, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:09:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'New Record inserted On pathology Test id 153', 153, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:09:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'New Record inserted On pathology Test id 154', 154, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:10:47', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'New Record inserted On pathology Test id 155', 155, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:11:45', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'New Record inserted On pathology Test id 156', 156, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:11:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'New Record inserted On pathology Test id 157', 157, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:12:39', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'New Record inserted On pathology Test id 158', 158, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:12:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'New Record inserted On pathology Test id 159', 159, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:14:10', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'New Record inserted On pathology Test id 160', 160, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:14:21', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'New Record inserted On pathology Test id 161', 161, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:14:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'New Record inserted On pathology Test id 162', 162, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:15:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'New Record inserted On pathology Test id 163', 163, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:15:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'New Record inserted On pathology Test id 164', 164, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:15:51', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'New Record inserted On pathology Test id 165', 165, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:16:15', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'New Record inserted On pathology Test id 166', 166, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:16:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'New Record inserted On pathology Test id 167', 167, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:17:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'New Record inserted On pathology Test id 168', 168, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:17:22', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'New Record inserted On pathology Test id 169', 169, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:17:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'New Record inserted On pathology Test id 170', 170, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:18:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'New Record inserted On pathology Test id 171', 171, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:18:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'New Record inserted On pathology Test id 172', 172, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:18:33', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'New Record inserted On pathology Test id 173', 173, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:19:07', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'New Record inserted On pathology Test id 174', 174, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:19:29', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (341, 'New Record inserted On pathology Test id 175', 175, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:19:55', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (342, 'New Record inserted On pathology Test id 176', 176, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:20:33', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (343, 'New Record inserted On pathology Test id 177', 177, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:20:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (344, 'New Record inserted On pathology Test id 178', 178, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:21:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (345, 'New Record inserted On pathology Test id 179', 179, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:21:56', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'New Record inserted On pathology Test id 180', 180, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:21:59', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (347, 'New Record inserted On pathology Test id 181', 181, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:22:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'New Record inserted On pathology Test id 182', 182, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:22:51', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'New Record inserted On pathology Test id 183', 183, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:23:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'New Record inserted On pathology Test id 184', 184, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:23:21', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'New Record inserted On pathology Test id 185', 185, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:23:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'New Record inserted On pathology Test id 186', 186, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:23:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'New Record inserted On pathology Test id 187', 187, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:24:25', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'New Record inserted On pathology Test id 188', 188, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:24:29', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'New Record inserted On pathology Test id 189', 189, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:24:35', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'New Record inserted On pathology Test id 190', 190, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:25:22', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'New Record inserted On pathology Test id 191', 191, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:25:41', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'New Record inserted On pathology Test id 192', 192, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:25:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'New Record inserted On pathology Test id 193', 193, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:25:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'New Record inserted On pathology Test id 194', 194, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:26:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'New Record inserted On pathology Test id 195', 195, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:26:37', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'New Record inserted On pathology Test id 196', 196, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:27:13', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'New Record inserted On pathology Test id 197', 197, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:27:29', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'New Record inserted On pathology Test id 198', 198, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:27:45', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'New Record inserted On pathology Test id 199', 199, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:27:53', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'New Record inserted On pathology Test id 200', 200, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:28:31', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'New Record inserted On pathology Test id 201', 201, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:28:53', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'New Record inserted On pathology Test id 202', 202, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:29:02', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'New Record inserted On pathology Test id 203', 203, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:29:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'New Record inserted On pathology Test id 204', 204, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:29:26', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'New Record inserted On pathology Test id 205', 205, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:29:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'New Record inserted On pathology Test id 206', 206, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:30:04', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'New Record inserted On pathology Test id 207', 207, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:30:15', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'New Record inserted On pathology Test id 208', 208, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:30:26', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'New Record inserted On pathology Test id 209', 209, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:30:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'New Record inserted On pathology Test id 210', 210, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:30:59', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'New Record inserted On pathology Test id 211', 211, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:31:09', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'New Record inserted On pathology Test id 212', 212, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:31:31', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'New Record inserted On pathology Test id 213', 213, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:31:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'New Record inserted On pathology Test id 214', 214, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:31:59', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'New Record inserted On pathology Test id 215', 215, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:32:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (382, 'New Record inserted On pathology Test id 216', 216, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:32:30', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (383, 'New Record inserted On pathology Test id 217', 217, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:32:35', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (384, 'New Record inserted On pathology Test id 218', 218, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:33:10', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (385, 'New Record inserted On pathology Test id 219', 219, 6, 'Insert', '103.120.160.174', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:33:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (386, 'New Record inserted On pathology Test id 220', 220, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:33:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (387, 'New Record inserted On pathology Test id 221', 221, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:34:07', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (388, 'New Record inserted On pathology Test id 222', 222, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:34:12', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (389, 'New Record inserted On pathology Test id 223', 223, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:34:41', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (390, 'New Record inserted On pathology Test id 224', 224, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:35:14', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (391, 'New Record inserted On pathology Test id 225', 225, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:35:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (392, 'New Record inserted On pathology Test id 226', 226, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:35:56', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (393, 'New Record inserted On pathology Test id 227', 227, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:36:14', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (394, 'New Record inserted On pathology Test id 228', 228, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:36:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (395, 'New Record inserted On pathology Test id 229', 229, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:37:00', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (396, 'New Record inserted On pathology Test id 230', 230, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:37:14', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (397, 'New Record inserted On pathology Test id 231', 231, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:37:43', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (398, 'New Record inserted On pathology Test id 232', 232, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:37:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (399, 'New Record inserted On pathology Test id 233', 233, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:38:29', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (400, 'New Record inserted On pathology Test id 234', 234, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:38:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (401, 'New Record inserted On pathology Test id 235', 235, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:38:56', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (402, 'New Record inserted On pathology Test id 236', 236, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:39:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (403, 'New Record inserted On pathology Test id 237', 237, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:40:02', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (404, 'New Record inserted On pathology Test id 238', 238, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:40:27', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (405, 'New Record inserted On pathology Test id 239', 239, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:40:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (406, 'New Record inserted On pathology Test id 240', 240, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:40:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (407, 'New Record inserted On pathology Test id 241', 241, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:41:39', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (408, 'New Record inserted On pathology Test id 242', 242, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:41:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (409, 'New Record inserted On pathology Test id 243', 243, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:42:00', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (410, 'New Record inserted On pathology Test id 244', 244, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:42:23', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (411, 'New Record inserted On pathology Test id 245', 245, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:42:41', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (412, 'New Record inserted On pathology Test id 246', 246, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:42:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (413, 'New Record inserted On pathology Test id 247', 247, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:43:04', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (414, 'New Record inserted On pathology Test id 248', 248, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:43:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (415, 'New Record inserted On pathology Test id 249', 249, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:43:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (416, 'New Record inserted On pathology Test id 250', 250, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:44:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (417, 'New Record inserted On pathology Test id 251', 251, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:45:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (418, 'New Record inserted On pathology Test id 252', 252, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:45:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (419, 'Record deleted On Charges id 254', 254, 4, 'Delete', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:46:11', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (420, 'New Record inserted On pathology Test id 253', 253, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:46:15', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (421, 'New Record inserted On pathology Test id 254', 254, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:46:34', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (422, 'New Record inserted On pathology Test id 255', 255, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:47:04', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (423, 'New Record inserted On pathology Test id 256', 256, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:47:09', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (424, 'New Record inserted On pathology Test id 257', 257, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:48:05', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (425, 'Record deleted On Charges id 263', 263, 2, 'Delete', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:48:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (426, 'New Record inserted On pathology Test id 258', 258, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:48:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (427, 'New Record inserted On pathology Test id 259', 259, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:48:55', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (428, 'New Record inserted On pathology Test id 260', 260, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:50:20', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (429, 'New Record inserted On pathology Test id 261', 261, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:51:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (430, 'New Record inserted On pathology Test id 262', 262, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:52:13', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (431, 'New Record inserted On pathology Test id 263', 263, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:53:01', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (432, 'New Record inserted On pathology Test id 264', 264, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:53:56', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (433, 'New Record inserted On pathology Test id 265', 265, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:54:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (434, 'New Record inserted On pathology Test id 266', 266, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:55:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (435, 'New Record inserted On pathology Test id 267', 267, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:56:35', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (436, 'New Record inserted On pathology Test id 268', 268, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:57:23', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (437, 'New Record inserted On pathology Test id 269', 269, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:58:14', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (438, 'New Record inserted On pathology Test id 169', 169, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 00:59:31', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (439, 'Record deleted On Charges id 277', 277, 4, 'Delete', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 01:00:10', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (440, 'New Record inserted On pathology Test id 270', 270, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 01:00:48', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (441, 'New Record inserted On pathology Test id 271', 271, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 01:01:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (442, 'New Record inserted On pathology Test id 272', 272, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 01:02:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (443, 'New Record inserted On Lab id 1', 1, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 01:02:53', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (444, 'New Record inserted On pathology Test id 273', 273, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 01:03:15', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (445, 'New Record inserted On Lab id 2', 2, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 01:03:55', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (446, 'Record updated On Lab id 1', 1, 4, 'Update', '163.53.180.248', 'Windows 10', 'Opera 82.0.4227.50', '2022-01-12 12:10:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (447, 'Record updated On Lab id 2', 2, 4, 'Update', '163.53.180.248', 'Windows 10', 'Opera 82.0.4227.50', '2022-01-12 12:10:23', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (448, 'Record updated On Radiology Parameter id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 15:53:35', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (449, 'New Record inserted On Charge Categories id 19', 19, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 15:56:39', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (450, 'New Record inserted On Radio id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 15:58:13', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (451, 'New Record inserted On Charge Categories id 20', 20, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:01:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (452, 'New Record inserted On Radio id 2', 2, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:04:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (453, 'New Record inserted On Radio id 3', 3, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:34:21', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (454, 'New Record inserted On Radio id 4', 4, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:34:35', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (455, 'New Record inserted On Radio id 5', 5, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:35:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (456, 'Record deleted On Charges id 287', 287, 2, 'Delete', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:35:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (457, 'New Record inserted On Radio id 6', 6, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:37:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (458, 'New Record inserted On Radio id 7', 7, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:38:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (459, 'New Record inserted On Radio id 8', 8, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:38:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (460, 'New Record inserted On Radio id 9', 9, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:38:56', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (461, 'New Record inserted On Radio id 10', 10, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:39:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (462, 'New Record inserted On Radio id 11', 11, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:39:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (463, 'New Record inserted On Radio id 12', 12, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:40:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (464, 'New Record inserted On Radio id 13', 13, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:40:55', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (465, 'New Record inserted On Radio id 14', 14, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:41:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (466, 'New Record inserted On Radio id 15', 15, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:42:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (467, 'New Record inserted On Radio id 16', 16, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:42:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (468, 'New Record inserted On Radio id 17', 17, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:46:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (469, 'New Record inserted On Radio id 18', 18, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:46:37', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (470, 'New Record inserted On Radio id 19', 19, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:47:04', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (471, 'New Record inserted On Radio id 20', 20, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:47:21', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (472, 'New Record inserted On Radio id 21', 21, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:47:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (473, 'New Record inserted On Radio id 22', 22, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:48:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (474, 'New Record inserted On Radio id 23', 23, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:48:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (475, 'New Record inserted On Radio id 24', 24, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:48:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (476, 'New Record inserted On Radio id 25', 25, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:48:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (477, 'New Record inserted On Radio id 26', 26, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:49:48', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (478, 'New Record inserted On Radio id 27', 27, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:49:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (479, 'New Record inserted On Radio id 28', 28, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:50:11', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (480, 'New Record inserted On Radio id 29', 29, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:50:30', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (481, 'New Record inserted On Radio id 30', 30, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:50:59', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (482, 'New Record inserted On Radio id 31', 31, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:51:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (483, 'New Record inserted On Radio id 32', 32, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:51:25', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (484, 'New Record inserted On Radio id 33', 33, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:52:01', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (485, 'New Record inserted On Radio id 34', 34, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:52:14', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (486, 'New Record inserted On Radio id 35', 35, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:52:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (487, 'New Record inserted On Radio id 36', 36, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:53:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (488, 'New Record inserted On Radio id 37', 37, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:53:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (489, 'New Record inserted On Radio id 38', 38, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:54:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (490, 'New Record inserted On Radio id 39', 39, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:54:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (491, 'New Record inserted On Radio id 40', 40, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:55:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (492, 'New Record inserted On Radio id 41', 41, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:55:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (493, 'New Record inserted On Radio id 42', 42, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:56:11', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (494, 'New Record inserted On Radio id 43', 43, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:56:34', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (495, 'New Record inserted On Radio id 44', 44, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:57:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (496, 'New Record inserted On Radio id 45', 45, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:58:44', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (497, 'New Record inserted On Radio id 46', 46, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:59:33', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (498, 'New Record inserted On Radio id 47', 47, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 16:59:39', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (499, 'New Record inserted On Radio id 48', 48, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:00:34', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (500, 'New Record inserted On Radio id 49', 49, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:00:37', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (501, 'New Record inserted On Radio id 50', 50, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:00:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (502, 'New Record inserted On Radio id 51', 51, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:01:33', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (503, 'New Record inserted On Radio id 52', 52, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:01:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (504, 'New Record inserted On Radio id 53', 53, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:02:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (505, 'New Record inserted On Radio id 54', 54, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:03:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (506, 'New Record inserted On Radio id 55', 55, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:04:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (507, 'New Record inserted On Radio id 56', 56, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:04:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (508, 'New Record inserted On Radio id 57', 57, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:05:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (509, 'New Record inserted On Radio id 58', 58, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:06:07', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (510, 'New Record inserted On Radio id 59', 59, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:06:27', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (511, 'Record updated On Radio id 59', 59, 4, 'Update', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:06:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (512, 'New Record inserted On Radio id 60', 60, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:07:10', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (513, 'New Record inserted On Radio id 61', 61, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:07:41', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (514, 'New Record inserted On Radio id 62', 62, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:08:04', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (515, 'New Record inserted On Radio id 63', 63, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:08:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (516, 'New Record inserted On Radio id 64', 64, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:08:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (517, 'New Record inserted On Radio id 65', 65, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:08:37', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (518, 'New Record inserted On Radio id 66', 66, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:08:59', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (519, 'New Record inserted On Radio id 67', 67, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:09:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (520, 'New Record inserted On Radio id 68', 68, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:09:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (521, 'New Record inserted On Radio id 69', 69, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:09:44', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (522, 'New Record inserted On Radio id 70', 70, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:09:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (523, 'New Record inserted On Radio id 71', 71, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:10:14', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (524, 'New Record inserted On Radio id 72', 72, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:10:17', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (525, 'New Record inserted On Radio id 73', 73, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:11:02', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (526, 'New Record inserted On Radio id 74', 74, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:11:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (527, 'New Record inserted On Radio id 75', 75, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:11:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (528, 'New Record inserted On Radio id 76', 76, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:11:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (529, 'Record updated On Radio id 73', 73, 6, 'Update', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:11:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (530, 'New Record inserted On Radio id 77', 77, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:11:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (531, 'New Record inserted On Radio id 78', 78, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:12:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (532, 'New Record inserted On Radio id 79', 79, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:12:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (533, 'New Record inserted On Radio id 80', 80, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:12:20', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (534, 'New Record inserted On Radio id 81', 81, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:12:27', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (535, 'New Record inserted On Radio id 82', 82, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:12:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (536, 'New Record inserted On Radio id 83', 83, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:13:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (537, 'New Record inserted On Radio id 84', 84, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:13:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (538, 'New Record inserted On Radio id 85', 85, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:13:55', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (539, 'New Record inserted On Radio id 86', 86, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:14:04', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (540, 'New Record inserted On Radio id 87', 87, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:14:44', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (541, 'New Record inserted On Radio id 88', 88, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:15:01', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (542, 'New Record inserted On Radio id 89', 89, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:15:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (543, 'New Record inserted On Radio id 90', 90, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:15:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (544, 'New Record inserted On Radio id 91', 91, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:16:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (545, 'New Record inserted On Radio id 92', 92, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:16:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (546, 'New Record inserted On Radio id 93', 93, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:17:12', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (547, 'New Record inserted On Radio id 94', 94, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:17:33', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (548, 'New Record inserted On Radio id 95', 95, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:17:52', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (549, 'New Record inserted On Radio id 96', 96, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:18:05', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (550, 'New Record inserted On Radio id 97', 97, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:18:11', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (551, 'New Record inserted On Radio id 98', 98, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:18:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (552, 'New Record inserted On Radio id 99', 99, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:18:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (553, 'New Record inserted On Radio id 100', 100, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:18:59', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (554, 'New Record inserted On Radio id 101', 101, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:19:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (555, 'New Record inserted On Radio id 102', 102, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:19:45', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (556, 'New Record inserted On Radio id 103', 103, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:20:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (557, 'New Record inserted On Radio id 104', 104, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:20:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (558, 'Record updated On Radio id 101', 101, 4, 'Update', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:21:23', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (559, 'New Record inserted On Radio id 105', 105, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:21:43', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (560, 'New Record inserted On Radio id 106', 106, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:21:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (561, 'New Record inserted On Radio id 107', 107, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:22:30', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (562, 'New Record inserted On Radio id 108', 108, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:22:37', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (563, 'New Record inserted On Radio id 109', 109, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:22:51', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (564, 'New Record inserted On Radio id 110', 110, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:23:13', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (565, 'New Record inserted On Radio id 111', 111, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:23:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (566, 'New Record inserted On Radio id 112', 112, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:23:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (567, 'New Record inserted On Radio id 113', 113, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:23:55', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (568, 'New Record inserted On Radio id 114', 114, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:24:02', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (569, 'New Record inserted On Radio id 115', 115, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:24:29', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (570, 'New Record inserted On Radio id 116', 116, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:24:39', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (571, 'New Record inserted On Radio id 117', 117, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:24:39', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (572, 'New Record inserted On Radio id 118', 118, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:25:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (573, 'New Record inserted On Radio id 119', 119, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:25:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (574, 'New Record inserted On Radio id 120', 120, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:26:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (575, 'New Record inserted On Radio id 121', 121, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:26:17', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (576, 'New Record inserted On Radio id 122', 122, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:26:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (577, 'New Record inserted On Radio id 123', 123, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:27:02', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (578, 'New Record inserted On Radio id 124', 124, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:27:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (579, 'New Record inserted On Radio id 125', 125, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:27:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (580, 'New Record inserted On Radio id 126', 126, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:27:47', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (581, 'New Record inserted On Radio id 127', 127, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:28:30', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (582, 'New Record inserted On Radio id 128', 128, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:29:17', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (583, 'New Record inserted On Radio id 129', 129, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:30:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (584, 'New Record inserted On Radio id 130', 130, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:30:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (585, 'Record updated On Radio id 129', 129, 4, 'Update', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:30:20', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (586, 'New Record inserted On Radio id 131', 131, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:30:26', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (587, 'New Record inserted On Radio id 132', 132, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:31:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (588, 'New Record inserted On Radio id 133', 133, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:31:34', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (589, 'New Record inserted On Radio id 134', 134, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:31:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (590, 'Record updated On Radio id 132', 132, 5, 'Update', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:32:09', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (591, 'New Record inserted On Radio id 135', 135, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:32:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (592, 'New Record inserted On Radio id 136', 136, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:32:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (593, 'New Record inserted On Radio id 137', 137, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:33:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (594, 'New Record inserted On Radio id 138', 138, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:33:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (595, 'New Record inserted On Radio id 139', 139, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:33:23', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (596, 'New Record inserted On Radio id 140', 140, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:33:44', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (597, 'New Record inserted On Radio id 141', 141, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:34:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (598, 'New Record inserted On Radio id 142', 142, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:34:30', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (599, 'Record updated On Radio id 140', 140, 4, 'Update', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:34:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (600, 'New Record inserted On Radio id 143', 143, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:35:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (601, 'New Record inserted On Radio id 144', 144, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:35:31', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (602, 'New Record inserted On Radio id 145', 145, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:35:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (603, 'New Record inserted On Radio id 146', 146, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:36:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (604, 'New Record inserted On Radio id 147', 147, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:36:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (605, 'New Record inserted On Radio id 148', 148, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:37:05', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (606, 'New Record inserted On Radio id 149', 149, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:37:53', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (607, 'New Record inserted On Radio id 150', 150, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:38:08', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (608, 'New Record inserted On Radio id 151', 151, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:38:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (609, 'New Record inserted On Radio id 152', 152, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:38:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (610, 'New Record inserted On Radio id 153', 153, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:39:00', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (611, 'New Record inserted On Radio id 154', 154, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:39:35', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (612, 'New Record inserted On Radio id 155', 155, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:40:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (613, 'New Record inserted On Radio id 156', 156, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:40:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (614, 'New Record inserted On Radio id 157', 157, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:41:01', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (615, 'New Record inserted On Radio id 158', 158, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:41:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (616, 'New Record inserted On Radio id 159', 159, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:41:17', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (617, 'New Record inserted On Radio id 160', 160, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:41:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (618, 'New Record inserted On Radio id 161', 161, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:42:04', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (619, 'New Record inserted On Radio id 162', 162, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:42:13', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (620, 'New Record inserted On Radio id 163', 163, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:42:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (621, 'New Record inserted On Radio id 164', 164, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:43:07', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (622, 'New Record inserted On Radio id 165', 165, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:43:14', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (623, 'New Record inserted On Radio id 166', 166, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:43:15', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (624, 'New Record inserted On Radio id 167', 167, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:44:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (625, 'New Record inserted On Radio id 168', 168, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:44:14', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (626, 'New Record inserted On Radio id 169', 169, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:44:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (627, 'New Record inserted On Radio id 170', 170, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:44:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (628, 'New Record inserted On Radio id 171', 171, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:45:20', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (629, 'New Record inserted On Radio id 172', 172, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:45:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (630, 'New Record inserted On Radio id 173', 173, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:45:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (631, 'New Record inserted On Radio id 174', 174, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:45:59', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (632, 'New Record inserted On Radio id 175', 175, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:46:00', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (633, 'New Record inserted On Radio id 176', 176, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:46:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (634, 'New Record inserted On Radio id 177', 177, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:46:44', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (635, 'New Record inserted On Radio id 178', 178, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:46:55', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (636, 'New Record inserted On Radio id 179', 179, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:47:26', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (637, 'New Record inserted On Radio id 180', 180, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:47:51', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (638, 'New Record inserted On Radio id 181', 181, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:48:13', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (639, 'New Record inserted On Radio id 182', 182, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:48:22', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (640, 'Record updated On Radio id 182', 182, 5, 'Update', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:48:32', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (641, 'New Record inserted On Radio id 183', 183, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:48:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (642, 'New Record inserted On Radio id 184', 184, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:48:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (643, 'New Record inserted On Radio id 185', 185, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:49:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (644, 'New Record inserted On Radio id 186', 186, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:51:05', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (645, 'New Record inserted On Radio id 187', 187, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:51:43', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (646, 'New Record inserted On Radio id 188', 188, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:51:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (647, 'Record updated On Radio id 187', 187, 5, 'Update', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:51:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (648, 'New Record inserted On Radio id 189', 189, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:52:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (649, 'New Record inserted On Radio id 190', 190, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:53:00', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (650, 'New Record inserted On Radio id 191', 191, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:53:33', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (651, 'New Record inserted On Radio id 192', 192, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:54:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (652, 'New Record inserted On Radio id 193', 193, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:54:13', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (653, 'New Record inserted On Radio id 194', 194, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:54:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (654, 'New Record inserted On Radio id 195', 195, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:54:59', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (655, 'New Record inserted On Radio id 196', 196, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:55:30', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (656, 'New Record inserted On Radio id 197', 197, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:55:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (657, 'New Record inserted On Radio id 198', 198, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:56:17', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (658, 'New Record inserted On Radio id 199', 199, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:56:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (659, 'New Record inserted On Radio id 200', 200, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:57:11', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (660, 'New Record inserted On Radio id 201', 201, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:57:45', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (661, 'New Record inserted On Radio id 202', 202, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:57:51', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (662, 'New Record inserted On Radio id 203', 203, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:58:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (663, 'New Record inserted On Radio id 204', 204, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:58:41', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (664, 'New Record inserted On Radio id 205', 205, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 17:59:34', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (665, 'New Record inserted On Radio id 206', 206, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:00:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (666, 'New Record inserted On Radio id 207', 207, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:01:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (667, 'New Record inserted On Radio id 208', 208, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:02:07', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (668, 'New Record inserted On Radio id 209', 209, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:05:25', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (669, 'New Record inserted On Radio id 210', 210, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:06:18', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (670, 'New Record inserted On Radio id 211', 211, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:06:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (671, 'New Record inserted On Radio id 212', 212, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:07:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (672, 'Record updated On Radio id 212', 212, 4, 'Update', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:08:01', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (673, 'New Record inserted On Radio id 213', 213, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:08:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (674, 'New Record inserted On Radio id 214', 214, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:09:43', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (675, 'New Record inserted On Radio id 215', 215, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:10:23', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (676, 'New Record inserted On Radio id 216', 216, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:11:05', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (677, 'New Record inserted On Radio id 217', 217, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:11:45', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (678, 'New Record inserted On Radio id 218', 218, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:12:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (679, 'New Record inserted On Radio id 219', 219, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:14:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (680, 'New Record inserted On Radio id 220', 220, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:15:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (681, 'New Record inserted On Radio id 221', 221, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:18:05', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (682, 'New Record inserted On Radio id 222', 222, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 18:18:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (683, 'New Record inserted On Radiology Billing id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 19:12:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (684, 'New Record inserted On Transactions id 5', 5, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 19:12:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (685, 'New Record inserted On Read System Notification id 12', 12, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 19:14:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (686, 'New Record inserted On Read System Notification id 13', 13, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 19:14:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (687, 'New Record inserted On Radiology Parameter id 2', 2, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 19:27:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (688, 'New Record inserted On operation_category id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 19:34:48', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (689, 'New Record inserted On Operation id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 19:35:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (690, 'New Record inserted On Radio id 223', 223, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:32:02', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (691, 'New Record inserted On Radio id 224', 224, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:35:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (692, 'New Record inserted On Radio id 225', 225, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:36:26', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (693, 'New Record inserted On Radio id 226', 226, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:37:30', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (694, 'New Record inserted On Radio id 227', 227, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:39:23', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (695, 'New Record inserted On Radio id 228', 228, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:40:26', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (696, 'New Record inserted On Radio id 229', 229, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:41:15', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (697, 'New Record inserted On Radio id 230', 230, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:42:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (698, 'New Record inserted On Radio id 231', 231, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:42:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (699, 'New Record inserted On Radio id 232', 232, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:43:54', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (700, 'New Record inserted On Radio id 233', 233, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:44:46', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (701, 'New Record inserted On Radio id 234', 234, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:45:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (702, 'New Record inserted On Radio id 235', 235, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:46:26', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (703, 'New Record inserted On Radio id 236', 236, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:47:21', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (704, 'New Record inserted On Radio id 237', 237, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:48:11', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (705, 'New Record inserted On Radio id 238', 238, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:48:58', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (706, 'New Record inserted On Radio id 239', 239, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:49:50', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (707, 'New Record inserted On Radio id 240', 240, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:50:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (708, 'New Record inserted On Radio id 241', 241, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:51:39', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (709, 'New Record inserted On Radio id 242', 242, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:52:30', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (710, 'New Record inserted On Radio id 243', 243, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:53:40', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (711, 'New Record inserted On Radio id 244', 244, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:54:33', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (712, 'New Record inserted On Radio id 245', 245, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:56:24', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (713, 'New Record inserted On Radio id 246', 246, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:57:25', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (714, 'New Record inserted On Radio id 247', 247, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:58:13', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (715, 'Record updated On Radio id 247', 247, 6, 'Update', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:58:25', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (716, 'New Record inserted On Radio id 248', 248, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 20:59:17', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (717, 'New Record inserted On Radio id 249', 249, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:00:21', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (718, 'New Record inserted On Radio id 250', 250, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:01:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (719, 'New Record inserted On Radio id 251', 251, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:01:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (720, 'New Record inserted On Radio id 252', 252, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:02:47', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (721, 'New Record inserted On Radio id 253', 253, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:03:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (722, 'New Record inserted On Radio id 254', 254, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:04:38', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (723, 'New Record inserted On Radio id 255', 255, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:06:37', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (724, 'New Record inserted On Radio id 256', 256, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:07:21', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (725, 'New Record inserted On Radio id 257', 257, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:08:07', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (726, 'New Record inserted On Radio id 258', 258, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:09:22', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (727, 'New Record inserted On Radio id 259', 259, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:10:09', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (728, 'Record deleted On Charges id 542', 542, 6, 'Delete', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:11:57', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (729, 'New Record inserted On Radio id 260', 260, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:12:31', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (730, 'New Record inserted On Radio id 261', 261, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:13:16', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (731, 'New Record inserted On Radio id 262', 262, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:14:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (732, 'New Record inserted On Radio id 263', 263, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:15:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (733, 'New Record inserted On Radio id 264', 264, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:16:02', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (734, 'New Record inserted On Radio id 265', 265, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:16:51', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (735, 'Record deleted On Charges id 549', 549, 6, 'Delete', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:19:51', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (736, 'Record updated For Staff id 9', 9, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:21:56', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (737, 'Record updated On Radiology Report id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:22:19', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (738, 'Record deleted On Charges id 550', 550, 6, 'Delete', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:23:00', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (739, 'Record updated On Radio id 167', 167, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:24:33', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (740, 'Record deleted On Charges id 551', 551, 6, 'Delete', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:28:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (741, 'New Record inserted On Radio id 266', 266, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:29:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (742, 'New Record inserted On Radio id 267', 267, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:30:34', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (743, 'New Record inserted On Radio id 268', 268, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:32:00', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (744, 'Record updated On Radiology Parameter id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:34:01', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (745, 'Record updated On Radiology Parameter id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:50:06', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (746, 'Record updated On Unit id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 21:50:20', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (747, 'New Record inserted On Referral Category id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:04:28', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (748, 'New Record inserted On Referral Commission id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:04:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (749, 'New Record inserted On Referral Commission id 2', 2, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:04:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (750, 'New Record inserted On Referral Commission id 3', 3, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:04:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (751, 'New Record inserted On Referral Commission id 4', 4, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:04:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (752, 'New Record inserted On Referral Commission id 5', 5, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:04:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (753, 'New Record inserted On Referral Commission id 6', 6, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:04:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (754, 'New Record inserted On Referral Commission id 7', 7, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:04:49', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (755, 'New Record inserted On Referral Person id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:06:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (756, 'New Record inserted On Referral Person Commission id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:06:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (757, 'New Record inserted On Referral Person Commission id 2', 2, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:06:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (758, 'New Record inserted On Referral Person Commission id 3', 3, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:06:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (759, 'New Record inserted On Referral Person Commission id 4', 4, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:06:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (760, 'New Record inserted On Referral Person Commission id 5', 5, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:06:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (761, 'New Record inserted On Referral Person Commission id 6', 6, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:06:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (762, 'New Record inserted On Referral Person Commission id 7', 7, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:06:36', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (763, 'New Record inserted On Referral Payment id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:08:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (764, 'Record updated On Referral Payment id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:08:42', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (765, 'New Record inserted On Read System Notification id 14', 14, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 22:15:03', '2022-01-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (766, 'New Record inserted On Charge Categories id 21', 21, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:02:04', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (767, 'New Record inserted On Charge Categories id 22', 22, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:05:43', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (768, 'New Record inserted On Charge Categories id 23', 23, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:05:51', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (769, 'New Record inserted On Charge Categories id 24', 24, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:06:05', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (770, 'New Record inserted On Charge Categories id 25', 25, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:06:18', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (771, 'New Record inserted On Charge Categories id 26', 26, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:06:35', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (772, 'Record updated On Charge Categories id 26', 26, 2, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:06:56', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (773, 'New Record inserted On Pathology Category id 18', 18, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:08:23', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (774, 'New Record inserted On Pathology Category id 19', 19, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:08:34', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (775, 'New Record inserted On Pathology Category id 20', 20, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:08:44', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (776, 'New Record inserted On Pathology Category id 21', 21, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:08:54', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (777, 'New Record inserted On Pathology Category id 22', 22, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:09:07', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (778, 'New Record inserted On pathology Test id 274', 274, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:10:50', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (779, 'New Record inserted On pathology Test id 275', 275, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:12:08', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (780, 'New Record inserted On pathology Test id 276', 276, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:12:26', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (781, 'New Record inserted On pathology Test id 277', 277, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:13:18', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (782, 'New Record inserted On pathology Test id 278', 278, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:13:23', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (783, 'New Record inserted On pathology Test id 279', 279, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:13:28', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (784, 'New Record inserted On pathology Test id 280', 280, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:13:50', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (785, 'New Record inserted On pathology Test id 281', 281, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:14:24', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (786, 'New Record inserted On pathology Test id 282', 282, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:14:42', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (787, 'New Record inserted On pathology Test id 283', 283, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:14:43', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (788, 'New Record inserted On pathology Test id 284', 284, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:15:17', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (789, 'New Record inserted On pathology Test id 285', 285, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:15:44', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (790, 'New Record inserted On pathology Test id 286', 286, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:15:48', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (791, 'New Record inserted On pathology Test id 287', 287, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:16:21', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (792, 'New Record inserted On pathology Test id 288', 288, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:16:21', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (793, 'New Record inserted On pathology Test id 289', 289, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:16:37', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (794, 'New Record inserted On pathology Test id 290', 290, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:16:44', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (795, 'New Record inserted On pathology Test id 291', 291, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:17:29', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (796, 'New Record inserted On pathology Test id 292', 292, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:17:41', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (797, 'New Record inserted On pathology Test id 293', 293, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:17:41', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (798, 'New Record inserted On pathology Test id 294', 294, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:18:16', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (799, 'New Record inserted On pathology Test id 295', 295, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:18:28', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (800, 'New Record inserted On pathology Test id 296', 296, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:18:40', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (801, 'New Record inserted On pathology Test id 297', 297, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:18:42', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (802, 'New Record inserted On pathology Test id 298', 298, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:19:26', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (803, 'New Record inserted On pathology Test id 299', 299, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:19:39', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (804, 'New Record inserted On pathology Test id 300', 300, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:19:55', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (805, 'New Record inserted On pathology Test id 301', 301, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:20:02', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (806, 'New Record inserted On pathology Test id 302', 302, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:20:14', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (807, 'New Record inserted On pathology Test id 303', 303, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:20:35', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (808, 'New Record inserted On pathology Test id 304', 304, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:21:03', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (809, 'New Record inserted On pathology Test id 305', 305, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:21:17', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (810, 'New Record inserted On pathology Test id 306', 306, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:21:18', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (811, 'New Record inserted On pathology Test id 307', 307, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:21:27', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (812, 'New Record inserted On pathology Test id 308', 308, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:21:56', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (813, 'New Record inserted On pathology Test id 309', 309, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:23:06', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (814, 'New Record inserted On pathology Test id 310', 310, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:23:51', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (815, 'New Record inserted On pathology Test id 311', 311, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:23:55', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (816, 'New Record inserted On pathology Test id 312', 312, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:24:02', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (817, 'New Record inserted On pathology Test id 313', 313, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:24:29', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (818, 'New Record inserted On pathology Test id 314', 314, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:24:51', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (819, 'New Record inserted On pathology Test id 315', 315, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:25:00', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (820, 'New Record inserted On pathology Test id 316', 316, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:25:55', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (821, 'New Record inserted On pathology Test id 317', 317, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:25:57', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (822, 'New Record inserted On pathology Test id 318', 318, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:26:08', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (823, 'New Record inserted On pathology Test id 319', 319, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:26:32', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (824, 'New Record inserted On pathology Test id 320', 320, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:26:43', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (825, 'New Record inserted On pathology Test id 321', 321, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:27:12', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (826, 'New Record inserted On pathology Test id 322', 322, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:27:16', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (827, 'New Record inserted On pathology Test id 323', 323, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:27:24', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (828, 'New Record inserted On pathology Test id 324', 324, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:27:30', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (829, 'New Record inserted On pathology Test id 324', 324, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:27:47', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (830, 'New Record inserted On pathology Test id 325', 325, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:28:13', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (831, 'New Record inserted On pathology Test id 326', 326, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:28:15', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (832, 'New Record inserted On pathology Test id 326', 326, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:28:25', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (833, 'New Record inserted On pathology Test id 327', 327, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:28:32', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (834, 'New Record inserted On pathology Test id 328', 328, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:28:54', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (835, 'New Record inserted On pathology Test id 329', 329, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:29:03', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (836, 'New Record inserted On pathology Test id 330', 330, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:29:15', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (837, 'New Record inserted On pathology Test id 331', 331, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:29:26', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (838, 'New Record inserted On pathology Test id 332', 332, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:30:08', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (839, 'New Record inserted On pathology Test id 333', 333, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:30:09', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (840, 'New Record inserted On pathology Test id 334', 334, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:30:15', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (841, 'New Record inserted On pathology Test id 335', 335, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:30:29', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (842, 'New Record inserted On pathology Test id 336', 336, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:30:58', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (843, 'New Record inserted On pathology Test id 337', 337, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:31:10', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (844, 'New Record inserted On pathology Test id 338', 338, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:31:25', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (845, 'New Record inserted On pathology Test id 339', 339, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:32:10', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (846, 'New Record inserted On pathology Test id 340', 340, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:32:30', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (847, 'New Record inserted On pathology Test id 341', 341, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:32:34', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (848, 'New Record inserted On pathology Test id 342', 342, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:32:55', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (849, 'New Record inserted On pathology Test id 343', 343, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:33:04', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (850, 'New Record inserted On pathology Test id 344', 344, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:33:16', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (851, 'New Record inserted On pathology Test id 345', 345, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:33:47', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (852, 'New Record inserted On pathology Test id 346', 346, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:34:13', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (853, 'New Record inserted On pathology Test id 347', 347, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:34:41', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (854, 'New Record inserted On pathology Test id 348', 348, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:34:47', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (855, 'New Record inserted On pathology Test id 349', 349, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:34:48', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (856, 'New Record inserted On pathology Test id 350', 350, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:35:23', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (857, 'New Record inserted On pathology Test id 351', 351, 6, 'Insert', '103.120.160.190', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:35:43', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (858, 'New Record inserted On pathology Test id 352', 352, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:35:57', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (859, 'New Record inserted On pathology Test id 353', 353, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:36:29', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (860, 'New Record inserted On pathology Test id 354', 354, 4, 'Insert', '202.83.127.187', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:36:46', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (861, 'New Record inserted On pathology Test id 355', 355, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:38:35', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (862, 'New Record inserted On pathology Test id 356', 356, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:40:33', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (863, 'New Record inserted On pathology Test id 357', 357, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:41:54', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (864, 'New Record inserted On pathology Test id 358', 358, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:43:50', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (865, 'New Record inserted On pathology Test id 359', 359, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:45:18', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (866, 'New Record inserted On pathology Test id 360', 360, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:46:49', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (867, 'New Record inserted On pathology Test id 361', 361, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 00:48:05', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (868, 'New Record inserted On pathology Test id 362', 362, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 01:53:17', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (869, 'New Record inserted On pathology Test id 363', 363, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 01:54:21', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (870, 'New Record inserted On pathology Test id 364', 364, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 01:55:31', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (871, 'New Record inserted On pathology Test id 365', 365, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 01:56:56', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (872, 'New Record inserted On pathology Test id 366', 366, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 01:57:56', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (873, 'New Record inserted On pathology Test id 367', 367, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 01:59:20', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (874, 'New Record inserted On pathology Test id 368', 368, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:00:12', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (875, 'New Record inserted On pathology Test id 369', 369, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:03:19', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (876, 'New Record inserted On pathology Test id 370', 370, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:04:15', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (877, 'New Record inserted On pathology Test id 371', 371, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:05:11', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (878, 'New Record inserted On pathology Test id 372', 372, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:06:05', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (879, 'New Record inserted On pathology Test id 373', 373, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:06:56', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (880, 'New Record inserted On pathology Test id 374', 374, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:08:03', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (881, 'New Record inserted On pathology Test id 375', 375, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:09:51', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (882, 'New Record inserted On pathology Test id 376', 376, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:10:53', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (883, 'New Record inserted On pathology Test id 377', 377, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:11:50', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (884, 'New Record inserted On pathology Test id 378', 378, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:12:54', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (885, 'New Record inserted On pathology Test id 379', 379, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:14:11', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (886, 'New Record inserted On pathology Test id 380', 380, 5, 'Insert', '103.135.134.38', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 02:15:03', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (887, 'New Record inserted On Read System Notification id 15', 15, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:11:14', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (888, 'New Record inserted On Read System Notification id 16', 16, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:11:17', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (889, 'New Record inserted On Read System Notification id 17', 17, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:13:54', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (890, 'New Record inserted On Medicine Category id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:32:00', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (891, 'New Record inserted On Pharmacy id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:32:49', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (892, 'New Record inserted On Medicine Supplier id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:39:21', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (893, 'New Record inserted On Pharmacy id 2', 2, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:41:52', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (894, 'New Record inserted On Supplier Bill Basic id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:44:39', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (895, 'New Record inserted On Pharmacy Bill Basic id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 09:46:24', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (896, 'Record updated On Pharmacy Bill Basic id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 10:00:26', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (897, 'New Record inserted On Read System Notification id 18', 18, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 10:29:42', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (898, 'New Record inserted On Read System Notification id 19', 19, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 10:29:44', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (899, 'New Record inserted On Read System Notification id 20', 20, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 10:29:46', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (900, 'New Record inserted On Read System Notification id 21', 21, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 10:29:46', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (901, 'New Record inserted On Read System Notification id 22', 22, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 10:38:53', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (902, 'New Record inserted On Read System Notification id 23', 23, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-13 10:38:53', '2022-01-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (903, 'New Record inserted On Read System Notification id 24', 24, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-15 14:37:40', '2022-01-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (904, 'New Record inserted On Read System Notification id 25', 25, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-15 14:37:40', '2022-01-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (905, 'New Record inserted On Read System Notification id 26', 26, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-15 14:47:01', '2022-01-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (906, 'New Record inserted On Read System Notification id 27', 27, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-15 14:47:03', '2022-01-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (907, 'Record updated On Front Cms Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:03:10', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (908, 'Record updated For Menu Item id 2', 2, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:08:57', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (909, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:12:59', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (910, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:13:14', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (911, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:13:23', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (912, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:13:43', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (913, 'Record updated On Front Cms Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:14:27', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (914, 'Record updated On Front Cms Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:15:15', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (915, 'Record updated On Front Cms Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:15:53', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (916, 'Record updated On Front Cms Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:16:45', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (917, 'Record updated On Front Cms Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:17:00', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (918, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:17:22', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (919, 'New Record inserted On Menu Item id 5', 5, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:19:57', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (920, 'New Record inserted On Menu Item id 6', 6, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:21:33', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (921, 'Record updated For Menu Item id 6', 6, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:22:02', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (922, 'Record updated For Menu Item id 5', 5, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:22:09', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (923, 'Record updated On Certificates id 12', 12, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:47:56', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (927, 'Record updated On Certificates id 12', 12, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 09:53:59', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (928, 'New Record inserted On Department id 2', 2, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:14:12', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (929, 'New Record inserted On Department id 3', 3, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:27:14', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (930, 'New Record inserted On Department id 4', 4, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:27:48', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (931, 'New Record inserted On Department id 5', 5, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:28:29', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (932, 'New Record inserted On Department id 6', 6, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:29:49', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (933, 'New Record inserted On Department id 7', 7, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:30:37', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (934, 'New Record inserted On Staff Designation id 2', 2, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:31:00', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (935, 'New Record inserted On Staff Designation id 3', 3, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:31:24', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (936, 'New Record inserted On Staff Designation id 4', 4, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:32:46', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (937, 'New Record inserted On Department id 8', 8, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:33:15', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (938, 'New Record inserted On Staff Designation id 5', 5, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:33:44', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (939, 'New Record inserted On Department id 9', 9, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:33:57', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (940, 'New Record inserted On Staff Designation id 6', 6, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:34:57', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (941, 'New Record inserted On Department id 10', 10, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:35:08', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (942, 'New Record inserted On Roles id 10', 10, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:36:17', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (943, 'New Record inserted On Roles id 11', 11, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:36:36', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (944, 'New Record inserted On Roles id 12', 12, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:36:43', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (945, 'New Record inserted On Roles id 13', 13, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:37:04', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (946, 'New Record inserted On Roles id 14', 14, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:39:01', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (947, 'New Record inserted On Roles id 15', 15, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:39:47', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (948, 'Record updated On Front Cms Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 10:56:43', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (949, 'New Record inserted On Specialist id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 22:56:08', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (950, 'Record updated For Staff id 7', 7, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 22:56:57', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (951, 'Record updated For Staff id 7', 7, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 22:56:57', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (952, 'Record updated For Staff id 7', 7, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 22:57:47', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (953, 'Record updated For Staff id 7', 7, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 22:57:47', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (954, 'New Record inserted On Global Shift id 1', 1, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 23:03:00', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (955, 'New Record inserted On Charge Categories id 27', 27, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-17 23:04:32', '2022-01-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (956, 'New Record inserted On Menu Item id 7', 7, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 00:08:26', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (957, 'Record updated For Menu Item id 7', 7, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 00:56:40', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (958, 'Record updated For Staff id 10', 10, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 01:25:32', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (959, 'Record updated Change Password For Staff id 10', 10, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 01:26:36', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (960, 'Record updated For Staff id 11', 11, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 09:55:00', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (961, 'Record updated Change Password For Staff id 11', 11, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 09:55:32', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (962, 'Record deleted On roles Permissions where Role id  14', 14, 1, 'Delete', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:00:58', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (963, 'New Record inserted On Pathology Category id 23', 23, 11, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:02:22', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (964, 'New Record inserted On Radiology Billing id 2', 2, 11, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:05:45', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (965, 'New Record inserted On Transactions id 8', 8, 11, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:05:45', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (966, 'Record deleted On roles Permissions where Role id  14', 14, 1, 'Delete', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:12:08', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (967, 'Record deleted On roles Permissions where Role id  14', 14, 1, 'Delete', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:15:22', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (968, 'Record deleted On roles Permissions where Role id  14', 14, 1, 'Delete', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:17:57', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (969, 'Record deleted On roles Permissions where Role id  12', 12, 1, 'Delete', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:21:02', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (970, 'Record updated On Print Setting id 1', 1, 10, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:35:59', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (971, 'Record updated On Print Setting id 1', 1, 10, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:35:59', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (972, 'Record updated On Print Setting id 4', 4, 10, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:36:09', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (973, 'Record updated On Print Setting id 4', 4, 10, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:36:09', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (974, 'Record updated On Print Setting id 5', 5, 10, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:36:17', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (975, 'Record updated On Print Setting id 5', 5, 10, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:36:17', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (976, 'Record updated On Print Setting id 8', 8, 10, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:36:26', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (977, 'Record updated On Print Setting id 8', 8, 10, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-18 10:36:26', '2022-01-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (978, 'Record updated On Radiology Parameter id 2', 2, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 07:50:20', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (979, 'Record updated On Radiology Report id 2', 2, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 07:50:48', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (980, 'New Record inserted On Patient id 3', 3, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:09:50', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (981, 'Record updated On Patient id 3', 3, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:09:50', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (982, 'New Record inserted On Radiology Billing id 3', 3, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:10:43', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (983, 'New Record inserted On Transactions id 9', 9, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:10:43', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (984, 'Record updated On Radiology Report id 3', 3, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:11:22', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (985, 'Record updated On Radio id 96', 96, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:14:58', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (986, 'Record updated On Radiology Parameter id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:18:36', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (987, 'New Record inserted On Radiology Parameter id 3', 3, 1, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:21:35', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (988, 'Record updated On Radiology Parameter id 3', 3, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 08:23:03', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (989, 'Record updated On Print Setting id 9', 9, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:00:22', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (990, 'Record updated On Print Setting id 9', 9, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:00:22', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (991, 'Record updated On Print Setting id 10', 10, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:00:32', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (992, 'Record updated On Print Setting id 10', 10, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:00:32', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (993, 'Record updated On Print Setting id 11', 11, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:00:41', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (994, 'Record updated On Print Setting id 11', 11, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:00:41', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (995, 'Record updated On Print Setting id 12', 12, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:00:53', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (996, 'Record updated On Print Setting id 12', 12, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:00:53', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (997, 'Record updated On Print Setting id 13', 13, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:01:04', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (998, 'Record updated On Print Setting id 13', 13, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:01:04', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (999, 'Record updated On Print Setting id 14', 14, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:01:15', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1000, 'Record updated On Print Setting id 14', 14, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:01:15', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1001, 'Record updated On Print Setting id 15', 15, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:01:29', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1002, 'Record updated On Print Setting id 15', 15, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:01:29', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1003, 'Record updated On Print Setting id 16', 16, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:01:39', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1004, 'Record updated On Print Setting id 16', 16, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-19 09:01:39', '2022-01-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1005, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-20 12:29:51', '2022-01-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1006, 'Record updated For Staff id 3', 3, 3, 'Update', '103.58.75.233', 'Windows 7', 'Chrome 97.0.4692.71', '2022-01-20 12:57:29', '2022-01-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1007, 'Record updated For Staff id 3', 3, 3, 'Update', '103.58.75.233', 'Windows 7', 'Chrome 97.0.4692.71', '2022-01-20 12:57:29', '2022-01-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1008, 'Record updated For Staff id 3', 3, 3, 'Update', '103.58.75.233', 'Windows 7', 'Chrome 97.0.4692.71', '2022-01-20 12:57:29', '2022-01-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1009, 'Record updated For Staff id 3', 3, 3, 'Update', '103.58.75.233', 'Windows 7', 'Chrome 97.0.4692.71', '2022-01-20 12:58:49', '2022-01-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1010, 'Record updated For Staff id 3', 3, 3, 'Update', '103.58.75.233', 'Windows 7', 'Chrome 97.0.4692.71', '2022-01-20 12:58:49', '2022-01-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1011, 'Record updated For Staff id 3', 3, 0, 'Update', '23.108.96.79', 'Windows 7', 'Chrome 97.0.4692.71', '2022-01-23 05:10:08', '2022-01-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1012, 'Record updated For Staff id 12', 12, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-24 04:38:23', '2022-01-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1013, 'Record updated Change Password For Staff id 12', 12, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-24 04:39:28', '2022-01-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1014, 'Record deleted On roles Permissions where Role id  2', 2, 1, 'Delete', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-24 04:42:11', '2022-01-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1015, 'Record updated For Staff id 2', 2, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 20:51:22', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1016, 'Record updated For Staff id 2', 2, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 20:51:22', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1017, 'Record updated Change Password For Staff id 2', 2, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 20:51:45', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1018, 'New Record inserted On Unit id 3', 3, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:04:50', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1019, 'New Record inserted On Pathology Parameter id 2', 2, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:05:43', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1020, 'New Record inserted On Unit id 4', 4, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:10:00', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1021, 'New Record inserted On Pathology Parameter id 3', 3, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:10:51', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1022, 'New Record inserted On pathology Test id 241', 241, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:11:46', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1023, 'New Record inserted On Transactions id 10', 10, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:15:19', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1024, 'Record updated On Pathology Report id 4', 4, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:16:00', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1025, 'Record updated Change Password For Staff id 8', 8, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:19:49', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1026, 'Record updated On Pathology Report id 4', 4, 8, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:25:34', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1027, 'New Record inserted On Unit id 5', 5, 8, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:46:52', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1028, 'New Record inserted On Pathology Parameter id 4', 4, 8, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:47:47', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1029, 'Record deleted On Pathology Parameter id 4', 4, 8, 'Delete', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:48:22', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1030, 'New Record inserted On Unit id 6', 6, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:48:48', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1031, 'New Record inserted On Radiology Parameter id 4', 4, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:50:38', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1032, 'Record updated On Radio id 268', 268, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:51:29', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1033, 'Record updated On Radiology Billing id 3', 3, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:52:48', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1034, 'Record updated On Radiology Report id 4', 4, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:53:08', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1035, 'Record updated On Radiology Parameter id 4', 4, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 21:56:41', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1036, 'New Record inserted On Read System Notification id 28', 28, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 22:09:20', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1037, 'Record updated For Menu Item id 5', 5, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 22:40:14', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1038, 'Record updated For Menu Item id 6', 6, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 22:40:36', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1039, 'Record updated For Menu Item id 2', 2, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-11 22:40:49', '2022-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1040, 'New Record inserted On Radiology Parameter id 5', 5, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-12 23:14:47', '2022-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1041, 'Record updated On Radio id 87', 87, 2, 'Update', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-12 23:16:41', '2022-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1042, 'New Record inserted On Radiology Parameter id 6', 6, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-12 23:23:45', '2022-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1043, 'New Record inserted On Unit id 7', 7, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 00:17:28', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1044, 'New Record inserted On Pathology Parameter id 5', 5, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 00:19:37', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1045, 'New Record inserted On pathology Test id 13', 13, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 00:21:15', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1046, 'New Record inserted On Pathology Parameter id 6', 6, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 00:22:46', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1047, 'New Record inserted On Pathology Parameter id 7', 7, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 00:51:56', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1048, 'New Record inserted On pathology Test id 13', 13, 2, 'Insert', '8.38.147.56', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 00:53:47', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1049, 'New Record inserted On Pathology Parameter id 8', 8, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 01:26:49', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1050, 'New Record inserted On Radiology Parameter id 7', 7, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 01:35:19', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1051, 'Record deleted On Pathology Parameter id 8', 8, 2, 'Delete', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 01:39:58', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1052, 'New Record inserted On Radiology Parameter id 8', 8, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 01:40:37', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1053, 'New Record inserted On Pathology Parameter id 9', 9, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 01:45:08', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1054, 'Record updated On Pathology Parameter id 9', 9, 2, 'Update', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 01:54:57', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1055, 'New Record inserted On Unit id 8', 8, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 02:01:36', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1056, 'Record updated On Pathology Parameter id 9', 9, 2, 'Update', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 02:02:31', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1057, 'New Record inserted On Read System Notification id 29', 29, 1, 'Insert', '103.220.206.34', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 17:21:23', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1058, 'New Record inserted On Read System Notification id 30', 30, 1, 'Insert', '103.220.206.34', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 17:21:29', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1059, 'New Record inserted On Unit id 9', 9, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:15:43', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1060, 'New Record inserted On Pathology Parameter id 10', 10, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:16:14', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1061, 'New Record inserted On Unit id 10', 10, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:17:35', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1062, 'New Record inserted On Pathology Parameter id 11', 11, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:18:02', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1063, 'Record deleted On Unit id 9', 9, 2, 'Delete', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:21:04', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1064, 'New Record inserted On Unit id 11', 11, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:21:53', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1065, 'New Record inserted On Radiology Parameter id 9', 9, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:22:10', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1066, 'New Record inserted On Pathology Parameter id 12', 12, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:23:08', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1067, 'New Record inserted On pathology Test id 99', 99, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:23:49', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1068, 'New Record inserted On Pathology Parameter id 13', 13, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:25:30', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1069, 'New Record inserted On Pathology Parameter id 14', 14, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:26:50', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1070, 'Record deleted On Pathology Parameter id 14', 14, 2, 'Delete', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:26:57', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1071, 'New Record inserted On Radiology Parameter id 10', 10, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:27:15', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1072, 'New Record inserted On Radiology Parameter id 11', 11, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:30:13', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1073, 'New Record inserted On Unit id 12', 12, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:33:34', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1074, 'New Record inserted On Pathology Parameter id 15', 15, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:34:27', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1075, 'New Record inserted On pathology Test id 232', 232, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:34:54', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1076, 'New Record inserted On Unit id 13', 13, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:42:16', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1077, 'New Record inserted On Pathology Parameter id 16', 16, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:42:32', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1078, 'New Record inserted On pathology Test id 270', 270, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:42:59', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1079, 'New Record inserted On Pathology Parameter id 17', 17, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:44:02', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1080, 'New Record inserted On pathology Test id 248', 248, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 18:44:22', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1081, 'New Record inserted On Pathology Parameter id 18', 18, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:17:17', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1082, 'New Record inserted On Pathology Parameter id 19', 19, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:21:07', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1083, 'New Record inserted On Pathology Parameter id 20', 20, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:23:13', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1084, 'New Record inserted On pathology Test id 93', 93, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:23:32', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1085, 'New Record inserted On Unit id 14', 14, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:25:05', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1086, 'New Record inserted On Pathology Parameter id 21', 21, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:25:18', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1087, 'New Record inserted On Pathology Parameter id 22', 22, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:27:05', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1088, 'New Record inserted On pathology Test id 250', 250, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:27:34', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1089, 'New Record inserted On Unit id 15', 15, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:29:47', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1090, 'New Record inserted On Pathology Parameter id 23', 23, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:30:00', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1091, 'New Record inserted On Unit id 16', 16, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:30:55', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1092, 'Record updated On Unit id 16', 16, 2, 'Update', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:31:02', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1093, 'New Record inserted On Pathology Parameter id 24', 24, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:31:16', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1094, 'New Record inserted On Unit id 17', 17, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:32:19', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1095, 'New Record inserted On Pathology Parameter id 25', 25, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:32:30', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1096, 'New Record inserted On pathology Test id 247', 247, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:33:06', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1097, 'New Record inserted On Pathology Parameter id 26', 26, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:33:59', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1098, 'Record updated On Pathology Parameter id 26', 26, 2, 'Update', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:34:23', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1099, 'New Record inserted On Pathology Parameter id 27', 27, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:35:22', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1100, 'New Record inserted On pathology Test id 269', 269, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:35:41', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1101, 'New Record inserted On Unit id 18', 18, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:36:35', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1102, 'New Record inserted On Radiology Parameter id 12', 12, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:36:47', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1103, 'Record deleted On Radiology Parameter id 12', 12, 2, 'Delete', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:37:35', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1104, 'Record deleted On Unit id 18', 18, 2, 'Delete', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:37:39', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1105, 'New Record inserted On Pathology Parameter id 28', 28, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:38:20', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1106, 'New Record inserted On pathology Test id 244', 244, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:38:43', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1107, 'New Record inserted On Pathology Parameter id 29', 29, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:40:01', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1108, 'New Record inserted On pathology Test id 268', 268, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:40:23', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1109, 'New Record inserted On Pathology Parameter id 30', 30, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:41:26', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1110, 'New Record inserted On pathology Test id 266', 266, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:41:55', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1111, 'New Record inserted On Pathology Parameter id 31', 31, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:43:32', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1112, 'New Record inserted On Pathology Parameter id 32', 32, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:45:47', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1113, 'New Record inserted On Radiology Parameter id 13', 13, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:47:14', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1114, 'New Record inserted On Pathology Parameter id 33', 33, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-13 19:48:18', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1115, 'New Record inserted On Pathology Parameter id 34', 34, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 19:56:32', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1116, 'New Record inserted On pathology Test id 14', 14, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 19:58:33', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1117, 'New Record inserted On Radiology Parameter id 14', 14, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:00:19', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1118, 'New Record inserted On Radiology Parameter id 15', 15, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:03:33', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1119, 'New Record inserted On Radiology Parameter id 16', 16, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:06:21', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1120, 'New Record inserted On Pathology Parameter id 35', 35, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:07:17', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1121, 'New Record inserted On Radiology Parameter id 17', 17, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:08:25', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1122, 'New Record inserted On Radiology Parameter id 18', 18, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:12:12', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1123, 'New Record inserted On Pathology Parameter id 36', 36, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:13:19', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1124, 'New Record inserted On Radiology Parameter id 19', 19, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:15:17', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1125, 'New Record inserted On Pathology Parameter id 37', 37, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:16:30', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1126, 'New Record inserted On Radiology Parameter id 20', 20, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:18:01', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1127, 'New Record inserted On Pathology Parameter id 38', 38, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:18:39', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1128, 'New Record inserted On Radiology Parameter id 21', 21, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:20:02', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1129, 'New Record inserted On Radiology Parameter id 22', 22, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:21:39', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1130, 'New Record inserted On Radiology Parameter id 23', 23, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:22:45', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1131, 'New Record inserted On Pathology Parameter id 39', 39, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:23:32', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1132, 'New Record inserted On Pathology Parameter id 40', 40, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 20:24:18', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1133, 'New Record inserted On Unit id 19', 19, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:42:23', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1134, 'New Record inserted On Pathology Parameter id 41', 41, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:42:39', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1135, 'New Record inserted On pathology Test id 172', 172, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:43:43', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1136, 'New Record inserted On Unit id 20', 20, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:44:35', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1137, 'New Record inserted On Pathology Parameter id 42', 42, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:44:53', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1138, 'New Record inserted On pathology Test id 74', 74, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:45:37', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1139, 'New Record inserted On Pathology Parameter id 43', 43, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:46:31', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1140, 'New Record inserted On pathology Test id 27', 27, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:47:12', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1141, 'New Record inserted On Pathology Parameter id 44', 44, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:48:18', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1142, 'New Record inserted On pathology Test id 46', 46, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:48:49', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1143, 'New Record inserted On Radiology Parameter id 24', 24, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:49:51', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1144, 'New Record inserted On Pathology Parameter id 45', 45, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:51:34', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1145, 'New Record inserted On pathology Test id 22', 22, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:51:57', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1146, 'New Record inserted On Pathology Parameter id 46', 46, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:53:01', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1147, 'New Record inserted On Pathology Parameter id 47', 47, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:54:25', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1148, 'New Record inserted On Unit id 21', 21, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:55:31', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1149, 'New Record inserted On Radiology Parameter id 25', 25, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:55:45', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1150, 'New Record inserted On Pathology Parameter id 48', 48, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 21:58:25', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1151, 'New Record inserted On Radiology Parameter id 26', 26, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 22:00:23', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1152, 'New Record inserted On Radiology Parameter id 27', 27, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 22:01:42', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1153, 'New Record inserted On Radiology Parameter id 28', 28, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-13 22:03:03', '2022-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1154, 'New Record inserted On Radiology Parameter id 29', 29, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:16:40', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1155, 'New Record inserted On Pathology Parameter id 49', 49, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:18:22', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1156, 'New Record inserted On Pathology Parameter id 50', 50, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:19:32', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1157, 'New Record inserted On pathology Test id 84', 84, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:19:58', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1158, 'New Record inserted On Radiology Parameter id 30', 30, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:21:45', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1159, 'New Record inserted On Pathology Parameter id 51', 51, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:23:28', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1160, 'New Record inserted On Pathology Parameter id 52', 52, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:24:39', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1161, 'New Record inserted On pathology Test id 109', 109, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:25:03', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1162, 'New Record inserted On Pathology Parameter id 53', 53, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:25:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1163, 'New Record inserted On Radiology Parameter id 31', 31, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:27:48', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1164, 'New Record inserted On Pathology Parameter id 54', 54, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:29:54', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1165, 'New Record inserted On Pathology Parameter id 55', 55, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:31:21', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1166, 'New Record inserted On pathology Test id 114', 114, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:31:47', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1167, 'New Record inserted On Pathology Parameter id 56', 56, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:32:42', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1168, 'New Record inserted On Pathology Parameter id 57', 57, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:33:15', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1169, 'New Record inserted On Pathology Parameter id 58', 58, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:33:35', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1170, 'New Record inserted On Pathology Parameter id 59', 59, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:33:54', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1171, 'New Record inserted On Pathology Parameter id 60', 60, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:34:11', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1172, 'New Record inserted On Radiology Parameter id 32', 32, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:34:57', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1173, 'New Record inserted On Pathology Parameter id 61', 61, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:35:51', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1174, 'New Record inserted On Pathology Parameter id 62', 62, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:36:53', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1175, 'New Record inserted On Pathology Parameter id 63', 63, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:38:07', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1176, 'New Record inserted On Pathology Parameter id 64', 64, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:40:27', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1177, 'New Record inserted On Unit id 22', 22, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:42:00', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1178, 'New Record inserted On Radiology Parameter id 33', 33, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:42:16', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1179, 'New Record inserted On Pathology Parameter id 65', 65, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:43:26', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1180, 'New Record inserted On Radiology Parameter id 34', 34, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:44:36', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1181, 'New Record inserted On Radiology Parameter id 35', 35, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:44:58', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1182, 'New Record inserted On Radiology Parameter id 36', 36, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:46:32', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1183, 'New Record inserted On Radiology Parameter id 37', 37, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:46:53', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1184, 'New Record inserted On Unit id 23', 23, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:47:59', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1185, 'New Record inserted On Radiology Parameter id 38', 38, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:48:13', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1186, 'New Record inserted On Pathology Parameter id 66', 66, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:49:13', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1187, 'New Record inserted On Radiology Parameter id 39', 39, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:49:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1188, 'New Record inserted On Pathology Parameter id 67', 67, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:50:57', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1189, 'New Record inserted On Unit id 24', 24, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:52:05', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1190, 'New Record inserted On Pathology Parameter id 68', 68, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:52:27', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1191, 'New Record inserted On Pathology Parameter id 69', 69, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:53:35', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1192, 'New Record inserted On Pathology Parameter id 70', 70, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:54:44', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1193, 'New Record inserted On Radiology Parameter id 40', 40, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:55:44', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1194, 'New Record inserted On Pathology Parameter id 71', 71, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:56:22', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1195, 'New Record inserted On pathology Test id 222', 222, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:56:45', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1196, 'New Record inserted On Pathology Parameter id 72', 72, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:57:41', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1197, 'New Record inserted On Pathology Parameter id 73', 73, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:58:40', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1198, 'New Record inserted On Pathology Parameter id 74', 74, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 01:59:59', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1199, 'New Record inserted On Pathology Parameter id 75', 75, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:00:26', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1200, 'New Record inserted On Radiology Parameter id 41', 41, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:01:39', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1201, 'New Record inserted On Radiology Parameter id 42', 42, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:02:48', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1202, 'New Record inserted On Radiology Parameter id 43', 43, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:03:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1203, 'New Record inserted On Radiology Parameter id 44', 44, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:05:03', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1204, 'New Record inserted On Radiology Parameter id 45', 45, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:05:43', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1205, 'New Record inserted On Unit id 25', 25, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:06:53', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1206, 'New Record inserted On Pathology Parameter id 76', 76, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:07:04', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1207, 'New Record inserted On Radiology Parameter id 46', 46, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:07:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1208, 'New Record inserted On Unit id 26', 26, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:09:05', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1209, 'New Record inserted On Radiology Parameter id 47', 47, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:09:19', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1210, 'New Record inserted On Radiology Parameter id 48', 48, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:10:29', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1211, 'New Record inserted On Pathology Parameter id 77', 77, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:11:47', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1212, 'New Record inserted On Radiology Parameter id 49', 49, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:12:42', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1213, 'New Record inserted On Pathology Parameter id 78', 78, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:14:05', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1214, 'New Record inserted On pathology Test id 110', 110, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:14:23', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1215, 'New Record inserted On Pathology Parameter id 79', 79, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:15:11', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1216, 'New Record inserted On Radiology Parameter id 50', 50, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:16:23', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1217, 'New Record inserted On Radiology Parameter id 51', 51, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:17:24', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1218, 'New Record inserted On Unit id 27', 27, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:18:07', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1219, 'New Record inserted On Pathology Parameter id 80', 80, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:18:17', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1220, 'New Record inserted On pathology Test id 228', 228, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:18:36', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1221, 'New Record inserted On Unit id 28', 28, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:19:33', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1222, 'New Record inserted On Pathology Parameter id 81', 81, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:19:46', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1223, 'New Record inserted On pathology Test id 231', 231, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:20:06', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1224, 'New Record inserted On Radiology Parameter id 52', 52, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:21:54', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1225, 'New Record inserted On Pathology Parameter id 82', 82, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:22:45', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1226, 'New Record inserted On Radiology Parameter id 53', 53, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:23:16', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1227, 'New Record inserted On Pathology Parameter id 83', 83, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:24:15', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1228, 'New Record inserted On Pathology Parameter id 84', 84, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:24:59', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1229, 'New Record inserted On Unit id 29', 29, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:26:14', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1230, 'New Record inserted On Radiology Parameter id 54', 54, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:26:25', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1231, 'New Record inserted On Pathology Parameter id 85', 85, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:29:39', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1232, 'New Record inserted On pathology Test id 123', 123, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:29:59', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1233, 'New Record inserted On Pathology Parameter id 86', 86, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:30:43', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1234, 'New Record inserted On Pathology Parameter id 87', 87, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:31:25', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1235, 'New Record inserted On Pathology Parameter id 88', 88, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:31:46', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1236, 'New Record inserted On pathology Test id 70', 70, 2, 'Insert', '103.229.82.170', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 02:32:09', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1237, 'New Record inserted On Unit id 30', 30, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 10:53:53', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1238, 'New Record inserted On Pathology Parameter id 89', 89, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 10:54:13', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1239, 'New Record inserted On Pathology Parameter id 90', 90, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 10:55:42', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1240, 'New Record inserted On pathology Test id 239', 239, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 10:56:05', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1241, 'New Record inserted On Pathology Parameter id 91', 91, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 10:56:40', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1242, 'New Record inserted On Pathology Parameter id 92', 92, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 10:57:38', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1243, 'New Record inserted On Pathology Parameter id 93', 93, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 10:59:01', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1244, 'New Record inserted On Pathology Parameter id 94', 94, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:00:30', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1245, 'New Record inserted On Pathology Parameter id 95', 95, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:01:54', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1246, 'New Record inserted On Unit id 31', 31, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:02:45', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1247, 'New Record inserted On Pathology Parameter id 96', 96, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:02:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1248, 'New Record inserted On Pathology Parameter id 97', 97, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:04:03', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1249, 'New Record inserted On Pathology Parameter id 98', 98, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:05:04', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1250, 'New Record inserted On Pathology Parameter id 99', 99, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:06:04', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1251, 'New Record inserted On Pathology Parameter id 100', 100, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:07:02', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1252, 'New Record inserted On pathology Test id 227', 227, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:07:17', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1253, 'New Record inserted On Pathology Parameter id 101', 101, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:08:13', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1254, 'New Record inserted On pathology Test id 264', 264, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:08:29', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1255, 'New Record inserted On Pathology Parameter id 102', 102, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:09:04', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1256, 'New Record inserted On pathology Test id 217', 217, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:09:22', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1257, 'New Record inserted On Pathology Parameter id 103', 103, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:10:15', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1258, 'New Record inserted On pathology Test id 206', 206, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:10:31', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1259, 'New Record inserted On Pathology Parameter id 104', 104, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:11:09', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1260, 'New Record inserted On Pathology Parameter id 105', 105, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:11:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1261, 'New Record inserted On Pathology Parameter id 106', 106, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:13:13', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1262, 'New Record inserted On pathology Test id 261', 261, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:13:28', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1263, 'New Record inserted On Pathology Parameter id 107', 107, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:14:21', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1264, 'New Record inserted On pathology Test id 203', 203, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:14:40', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1265, 'New Record inserted On Pathology Parameter id 108', 108, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:15:31', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1266, 'New Record inserted On Pathology Parameter id 109', 109, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:16:19', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1267, 'New Record inserted On Pathology Parameter id 110', 110, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:17:08', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1268, 'New Record inserted On Pathology Parameter id 111', 111, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:17:55', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1269, 'New Record inserted On pathology Test id 200', 200, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:18:17', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1270, 'New Record inserted On Pathology Parameter id 112', 112, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:19:31', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1271, 'New Record inserted On pathology Test id 197', 197, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:19:47', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1272, 'New Record inserted On Pathology Parameter id 113', 113, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:20:24', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1273, 'New Record inserted On pathology Test id 195', 195, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:20:44', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1274, 'New Record inserted On Pathology Parameter id 114', 114, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:21:21', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1275, 'New Record inserted On Pathology Parameter id 115', 115, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:21:59', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1276, 'New Record inserted On Pathology Parameter id 116', 116, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:30:35', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1277, 'New Record inserted On Pathology Parameter id 117', 117, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:31:41', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1278, 'New Record inserted On pathology Test id 182', 182, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:31:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1279, 'New Record inserted On Pathology Parameter id 118', 118, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:33:16', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1280, 'New Record inserted On pathology Test id 177', 177, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:33:32', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1281, 'New Record inserted On Pathology Parameter id 119', 119, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:35:47', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1282, 'New Record inserted On Pathology Parameter id 120', 120, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:37:22', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1283, 'Record deleted On Pathology Parameter id 120', 120, 2, 'Delete', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:37:52', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1284, 'New Record inserted On Radiology Parameter id 55', 55, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:38:08', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1285, 'New Record inserted On Radiology Parameter id 56', 56, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:40:21', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1286, 'New Record inserted On Radiology Parameter id 57', 57, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:41:17', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1287, 'New Record inserted On Pathology Parameter id 121', 121, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:42:33', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1288, 'New Record inserted On Pathology Parameter id 122', 122, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:46:09', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1289, 'New Record inserted On pathology Test id 167', 167, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:46:28', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1290, 'New Record inserted On Pathology Parameter id 123', 123, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:47:28', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1291, 'New Record inserted On Pathology Parameter id 124', 124, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:48:30', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1292, 'New Record inserted On pathology Test id 82', 82, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:48:45', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1293, 'New Record inserted On Pathology Parameter id 125', 125, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:49:30', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1294, 'New Record inserted On Pathology Parameter id 126', 126, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:50:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1295, 'New Record inserted On pathology Test id 130', 130, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:51:14', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1296, 'New Record inserted On Pathology Parameter id 127', 127, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:51:58', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1297, 'New Record inserted On Pathology Parameter id 128', 128, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 11:53:13', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1298, 'New Record inserted On Radiology Parameter id 58', 58, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:51:07', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1299, 'New Record inserted On Radiology Parameter id 59', 59, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:52:26', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1300, 'Record updated On Radiology Parameter id 58', 58, 2, 'Update', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:52:35', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1301, 'New Record inserted On Radiology Parameter id 60', 60, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:53:46', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1302, 'New Record inserted On Unit id 32', 32, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:54:25', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1303, 'New Record inserted On Pathology Parameter id 129', 129, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:54:37', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1304, 'New Record inserted On pathology Test id 226', 226, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:55:07', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1305, 'New Record inserted On Pathology Parameter id 130', 130, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:55:56', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1306, 'Record deleted On Pathology Parameter id 130', 130, 2, 'Delete', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:57:09', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1307, 'New Record inserted On Radiology Parameter id 61', 61, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:57:27', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1308, 'New Record inserted On Unit id 33', 33, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:58:24', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1309, 'New Record inserted On Pathology Parameter id 131', 131, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 12:58:36', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1310, 'New Record inserted On Pathology Parameter id 132', 132, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:00:31', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1311, 'New Record inserted On Radiology Parameter id 62', 62, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:01:48', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1312, 'New Record inserted On Pathology Parameter id 133', 133, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:02:58', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1313, 'New Record inserted On Pathology Parameter id 134', 134, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:03:55', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1314, 'New Record inserted On Pathology Parameter id 135', 135, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:04:57', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1315, 'New Record inserted On Pathology Parameter id 136', 136, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:05:45', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1316, 'New Record inserted On Pathology Parameter id 137', 137, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:06:24', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1317, 'New Record inserted On Radiology Parameter id 63', 63, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:07:29', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1318, 'New Record inserted On Radiology Parameter id 64', 64, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:09:14', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1319, 'New Record inserted On Pathology Parameter id 138', 138, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:11:22', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1320, 'New Record inserted On Pathology Parameter id 139', 139, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:12:36', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1321, 'New Record inserted On Radiology Parameter id 65', 65, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:13:49', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1322, 'New Record inserted On Radiology Parameter id 66', 66, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:15:43', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1323, 'New Record inserted On Pathology Parameter id 140', 140, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:17:06', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1324, 'New Record inserted On Unit id 34', 34, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:18:09', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1325, 'New Record inserted On Radiology Parameter id 67', 67, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:18:20', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1326, 'New Record inserted On Radiology Parameter id 68', 68, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:19:05', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1327, 'New Record inserted On Unit id 35', 35, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:20:29', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1328, 'New Record inserted On Radiology Parameter id 69', 69, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:20:40', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1329, 'New Record inserted On Pathology Parameter id 141', 141, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:21:52', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1330, 'New Record inserted On Pathology Parameter id 142', 142, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:25:12', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1331, 'New Record inserted On Radiology Parameter id 70', 70, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:26:05', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1332, 'New Record inserted On Pathology Parameter id 143', 143, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:27:16', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1333, 'New Record inserted On Pathology Parameter id 144', 144, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:28:18', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1334, 'New Record inserted On Pathology Parameter id 145', 145, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:30:01', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1335, 'New Record inserted On pathology Test id 154', 154, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:30:19', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1336, 'New Record inserted On Pathology Parameter id 146', 146, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:31:03', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1337, 'New Record inserted On pathology Test id 153', 153, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:31:28', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1338, 'New Record inserted On Radiology Parameter id 71', 71, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:32:36', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1339, 'New Record inserted On Radiology Parameter id 72', 72, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:33:49', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1340, 'New Record inserted On Radiology Parameter id 73', 73, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:34:47', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1341, 'New Record inserted On Pathology Parameter id 147', 147, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:36:43', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1342, 'New Record inserted On Pathology Parameter id 148', 148, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:39:02', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1343, 'New Record inserted On Pathology Parameter id 149', 149, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:40:16', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1344, 'New Record inserted On pathology Test id 75', 75, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 13:40:35', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1345, 'New Record inserted On Pathology Parameter id 150', 150, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 18:38:32', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1346, 'New Record inserted On Pathology Parameter id 151', 151, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 18:39:32', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1347, 'New Record inserted On pathology Test id 121', 121, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 18:39:51', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1348, 'New Record inserted On Pathology Parameter id 152', 152, 2, 'Insert', '202.83.127.184', 'Windows 10', 'Chrome 98.0.4758.80', '2022-02-14 18:41:00', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1349, 'New Record inserted On pathology Test id 203', 203, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 23:29:10', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1350, 'New Record inserted On pathology Test id 99', 99, 2, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-14 23:47:02', '2022-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1351, 'New Record inserted On Read System Notification id 31', 31, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-15 00:14:13', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1352, 'New Record inserted On Read System Notification id 32', 32, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-15 00:14:17', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1353, 'New Record inserted On Read System Notification id 33', 33, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-15 00:14:21', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1354, 'New Record inserted On Read System Notification id 34', 34, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-15 00:14:22', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1355, 'New Record inserted On Read System Notification id 35', 35, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-15 00:14:23', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1356, 'New Record inserted On Read System Notification id 36', 36, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-15 00:14:26', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1357, 'New Record inserted On Read System Notification id 37', 37, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-15 01:26:17', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1358, 'New Record inserted On Read System Notification id 38', 38, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.82', '2022-02-15 01:26:37', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1359, 'New Record inserted On Read System Notification id 39', 39, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:46', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1360, 'New Record inserted On Read System Notification id 40', 40, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:48', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1361, 'New Record inserted On Read System Notification id 41', 41, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:48', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1362, 'New Record inserted On Read System Notification id 42', 42, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:49', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1363, 'New Record inserted On Read System Notification id 43', 43, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:49', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1364, 'New Record inserted On Read System Notification id 44', 44, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:51', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1365, 'New Record inserted On Read System Notification id 45', 45, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:52', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1366, 'New Record inserted On Read System Notification id 46', 46, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:52', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1367, 'New Record inserted On Read System Notification id 47', 47, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:53', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1368, 'New Record inserted On Read System Notification id 48', 48, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 12:56:55', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1369, 'New Record inserted On Read System Notification id 49', 49, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:09:10', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1370, 'New Record inserted On Read System Notification id 50', 50, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:09:11', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1371, 'New Record inserted On Read System Notification id 51', 51, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:09:11', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1372, 'New Record inserted On Read System Notification id 52', 52, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:09:12', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1373, 'New Record inserted On Read System Notification id 53', 53, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:06', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1374, 'New Record inserted On Read System Notification id 54', 54, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:12', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1375, 'New Record inserted On Read System Notification id 55', 55, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:13', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1376, 'New Record inserted On Read System Notification id 56', 56, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:13', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1377, 'New Record inserted On Read System Notification id 57', 57, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:14', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1378, 'New Record inserted On Read System Notification id 58', 58, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:14', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1379, 'New Record inserted On Read System Notification id 59', 59, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:15', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1380, 'New Record inserted On Read System Notification id 60', 60, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:20', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1381, 'New Record inserted On Read System Notification id 61', 61, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:26', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1382, 'New Record inserted On Read System Notification id 62', 62, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:29', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1383, 'New Record inserted On Read System Notification id 63', 63, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:30', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1384, 'New Record inserted On Read System Notification id 64', 64, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:30', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1385, 'New Record inserted On Read System Notification id 65', 65, 1, 'Insert', '103.58.75.233', 'Windows 10', 'Firefox 97.0', '2022-02-15 13:11:30', '2022-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1386, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-17 04:56:15', '2022-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1387, 'New Record inserted On Patient id 4', 4, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:06:16', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1388, 'Record updated On Patient id 4', 4, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:06:16', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1389, 'New Record inserted On Radiology Billing id 4', 4, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:06:53', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1390, 'New Record inserted On Transactions id 11', 11, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:06:53', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1391, 'New Record inserted On Transactions id 12', 12, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:06:53', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1392, 'New Record inserted On Patient id 5', 5, 1, 'Insert', '103.58.75.38', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:41:09', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1393, 'Record updated On Patient id 5', 5, 1, 'Update', '103.58.75.38', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:41:09', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1394, 'New Record inserted On Radiology Billing id 5', 5, 1, 'Insert', '103.58.75.38', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:41:58', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1395, 'New Record inserted On Transactions id 13', 13, 1, 'Insert', '103.58.75.38', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:41:58', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1396, 'New Record inserted On Transactions id 14', 14, 1, 'Insert', '103.58.75.38', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:41:58', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1397, 'New Record inserted On Floor id 1', 1, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:45:17', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1398, 'New Record inserted On Bed Group id 1', 1, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:48:49', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1399, 'New Record inserted On Bed Group id 2', 2, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:49:06', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1400, 'New Record inserted On Bed id 1', 1, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:49:52', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1401, 'New Record inserted On Bed id 2', 2, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:50:06', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1402, 'New Record inserted On Bed id 3', 3, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:50:36', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1403, 'New Record inserted On Bed id 4', 4, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:50:59', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1404, 'New Record inserted On Bed id 5', 5, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:51:27', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1405, 'New Record inserted On IPD id 1', 1, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:55:08', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1406, 'Record updated On Bed id 4', 4, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:55:08', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1407, 'New Record inserted On Patient bed history id 1', 1, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:55:08', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1408, 'Record updated On Pathology Report id 6', 6, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 11:58:10', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1409, 'New Record inserted On Read System Notification id 66', 66, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:00:46', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1410, 'New Record inserted On Read System Notification id 67', 67, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:00:57', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1411, 'New Record inserted On Charge Units id 2', 2, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:20:13', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1412, 'New Record inserted On Charge Categories id 28', 28, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:21:13', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1413, 'New Record inserted On Patient Charges id 1', 1, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:23:37', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1414, 'New Record inserted On Operation Theatre id 1', 1, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:26:28', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1415, 'New Record inserted On Charge Categories id 29', 29, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:30:13', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1416, 'New Record inserted On Patient Charges id 2', 2, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:32:16', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1417, 'New Record inserted On Transactions id 15', 15, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:33:03', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1418, 'Record updated For Staff id 13', 13, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:49:54', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1419, 'New Record inserted On Patient id 6', 6, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:50:44', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1420, 'Record updated On Patient id 6', 6, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:50:44', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1421, 'New Record inserted On Charge Categories id 30', 30, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:52:31', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1422, 'New Record inserted On Transactions id 16', 16, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:56:56', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1423, 'New Record inserted On Transactions id 17', 17, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-18 12:59:54', '2022-02-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1424, 'New Record inserted On Patient id 7', 7, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-21 16:32:31', '2022-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1425, 'Record updated On Patient id 7', 7, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-21 16:32:31', '2022-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1426, 'New Record inserted On Radiology Billing id 6', 6, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-21 16:33:04', '2022-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1427, 'New Record inserted On Transactions id 18', 18, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-21 16:33:04', '2022-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1428, 'New Record inserted On Transactions id 19', 19, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-21 16:33:04', '2022-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1429, 'New Record inserted On Patient id 8', 8, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:06:40', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1430, 'Record updated On Patient id 8', 8, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:06:40', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1431, 'New Record inserted On Radiology Billing id 7', 7, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:07:32', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1432, 'New Record inserted On Transactions id 20', 20, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:07:32', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1433, 'New Record inserted On Transactions id 21', 21, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:07:32', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1434, 'Record updated On Patient id 6', 6, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:16:15', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1435, 'Record updated On Patient id 5', 5, 1, 'Update', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:25:27', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1436, 'New Record inserted On Transactions id 22', 22, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:26:58', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1437, 'New Record inserted On Transactions id 23', 23, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:37:56', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1438, 'New Record inserted On Transactions id 24', 24, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:39:24', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1439, 'New Record inserted On Read System Notification id 68', 68, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:52:51', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1440, 'New Record inserted On Read System Notification id 69', 69, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-23 01:53:07', '2022-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1441, 'New Record inserted On Transactions id 25', 25, 1, 'Insert', '202.83.127.186', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-24 01:10:40', '2022-02-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1442, 'Record updated For Staff id 14', 14, 1, 'Update', '103.124.227.193', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 17:33:10', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1443, 'Record updated Change Password For Staff id 14', 14, 1, 'Update', '103.124.227.193', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 17:33:41', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1444, 'New Record inserted On Specialist id 2', 2, 2, 'Insert', '8.29.105.170', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 22:11:33', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1445, 'Record deleted On Specialist id 2', 2, 1, 'Delete', '103.124.227.193', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 22:11:53', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1446, 'New Record inserted On pathology Test id 381', 381, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 23:39:02', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1447, 'New Record inserted On pathology Test id 382', 382, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 23:45:38', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1448, 'New Record inserted On pathology Test id 383', 383, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 23:51:32', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1449, 'New Record inserted On pathology Test id 384', 384, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 23:52:26', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1450, 'New Record inserted On pathology Test id 385', 385, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 23:53:18', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1451, 'New Record inserted On pathology Test id 386', 386, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 23:55:11', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1452, 'New Record inserted On pathology Test id 387', 387, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-25 23:56:07', '2022-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1453, 'New Record inserted On pathology Test id 388', 388, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:00:57', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1454, 'New Record inserted On pathology Test id 389', 389, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:02:45', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1455, 'New Record inserted On pathology Test id 390', 390, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:14:37', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1456, 'New Record inserted On pathology Test id 391', 391, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:16:28', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1457, 'New Record inserted On pathology Test id 392', 392, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:17:15', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1458, 'New Record inserted On pathology Test id 393', 393, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:18:00', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1459, 'New Record inserted On pathology Test id 394', 394, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:18:46', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1460, 'New Record inserted On pathology Test id 395', 395, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:19:35', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1461, 'New Record inserted On pathology Test id 396', 396, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:20:14', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1462, 'New Record inserted On pathology Test id 397', 397, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:21:07', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1463, 'New Record inserted On pathology Test id 398', 398, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:22:08', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1464, 'New Record inserted On pathology Test id 399', 399, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:22:10', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1465, 'New Record inserted On pathology Test id 400', 400, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:22:56', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1466, 'Record updated For Staff id 15', 15, 2, 'Update', '8.29.105.170', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:23:35', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1467, 'New Record inserted On pathology Test id 401', 401, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:23:41', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1468, 'New Record inserted On pathology Test id 402', 402, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:23:49', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1469, 'New Record inserted On pathology Test id 403', 403, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:24:33', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1470, 'New Record inserted On pathology Test id 404', 404, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:25:24', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1471, 'New Record inserted On pathology Test id 405', 405, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:25:32', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1472, 'New Record inserted On pathology Test id 406', 406, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:26:28', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1473, 'New Record inserted On pathology Test id 407', 407, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:27:24', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1474, 'New Record inserted On pathology Test id 408', 408, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:27:29', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1475, 'New Record inserted On pathology Test id 409', 409, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:28:10', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1476, 'New Record inserted On pathology Test id 410', 410, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:28:55', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1477, 'New Record inserted On pathology Test id 411', 411, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:29:19', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1478, 'New Record inserted On pathology Test id 412', 412, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:30:57', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1479, 'New Record inserted On pathology Test id 413', 413, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:31:05', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1480, 'New Record inserted On pathology Test id 414', 414, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:31:54', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1481, 'New Record inserted On pathology Test id 415', 415, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:32:06', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1482, 'New Record inserted On pathology Test id 416', 416, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:32:47', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1483, 'New Record inserted On pathology Test id 417', 417, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:33:20', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1484, 'New Record inserted On pathology Test id 418', 418, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:33:43', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1485, 'New Record inserted On pathology Test id 419', 419, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:34:17', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1486, 'New Record inserted On pathology Test id 420', 420, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:34:26', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1487, 'New Record inserted On pathology Test id 421', 421, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:35:20', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1488, 'New Record inserted On pathology Test id 422', 422, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:35:51', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1489, 'New Record inserted On pathology Test id 423', 423, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:36:43', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1490, 'New Record inserted On pathology Test id 424', 424, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:37:02', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1491, 'New Record inserted On pathology Test id 425', 425, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:37:20', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1492, 'New Record inserted On pathology Test id 426', 426, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:38:07', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1493, 'New Record inserted On pathology Test id 427', 427, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:38:23', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1494, 'New Record inserted On pathology Test id 428', 428, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:38:51', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1495, 'New Record inserted On pathology Test id 429', 429, 2, 'Insert', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:39:32', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1496, 'New Record inserted On pathology Test id 430', 430, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:41:07', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1497, 'New Record inserted On pathology Test id 431', 431, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:42:11', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1498, 'Record updated For Staff id 16', 16, 2, 'Update', '8.29.105.170', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:42:15', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1499, 'Record updated For Staff id 16', 16, 2, 'Update', '8.29.105.170', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:42:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1500, 'Record updated For Staff id 16', 16, 2, 'Update', '8.29.105.170', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:42:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1501, 'New Record inserted On pathology Test id 432', 432, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:43:29', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1502, 'New Record inserted On pathology Test id 433', 433, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:44:28', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1503, 'New Record inserted On pathology Test id 434', 434, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:45:45', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1504, 'New Record inserted On pathology Test id 435', 435, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:47:27', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1505, 'New Record inserted On pathology Test id 436', 436, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:48:29', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1506, 'New Record inserted On pathology Test id 437', 437, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:49:28', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1507, 'New Record inserted On pathology Test id 438', 438, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:51:11', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1508, 'New Record inserted On pathology Test id 439', 439, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:52:06', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1509, 'New Record inserted On pathology Test id 440', 440, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:53:03', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1510, 'Record updated For Staff id 17', 17, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:53:30', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1511, 'New Record inserted On pathology Test id 441', 441, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:54:06', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1512, 'Record updated For Staff id 18', 18, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:54:47', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1513, 'New Record inserted On pathology Test id 442', 442, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:55:19', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1514, 'New Record inserted On pathology Test id 443', 443, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:56:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1515, 'New Record inserted On pathology Test id 444', 444, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 00:57:45', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1516, 'New Record inserted On Radio id 269', 269, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:02:04', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1517, 'New Record inserted On Radio id 270', 270, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:03:25', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1518, 'Record updated For Staff id 19', 19, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:04:03', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1519, 'New Record inserted On pathology Test id 445', 445, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:04:35', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1520, 'New Record inserted On Radio id 271', 271, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:05:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1521, 'Record updated For Staff id 20', 20, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:06:07', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1522, 'New Record inserted On Radio id 272', 272, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:06:44', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1523, 'New Record inserted On Radio id 273', 273, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:08:18', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1524, 'Record updated For Staff id 21', 21, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:09:12', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1525, 'New Record inserted On Radio id 274', 274, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:09:15', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1526, 'New Record inserted On Radio id 275', 275, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:10:20', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1527, 'New Record inserted On Radio id 276', 276, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:11:23', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1528, 'New Record inserted On Radio id 277', 277, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:12:51', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1529, 'Record updated For Staff id 22', 22, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:13:19', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1530, 'New Record inserted On Radio id 278', 278, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:14:45', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1531, 'Record updated For Staff id 23', 23, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:15:07', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1532, 'New Record inserted On Radio id 279', 279, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:15:54', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1533, 'New Record inserted On Radio id 280', 280, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:17:20', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1534, 'Record updated For Staff id 24', 24, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:17:40', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1535, 'New Record inserted On Radio id 281', 281, 2, 'Insert', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:18:27', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1536, 'Record updated For Staff id 25', 25, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:19:32', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1537, 'Record updated For Staff id 26', 26, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:21:35', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1538, 'Record updated For Staff id 27', 27, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:25:29', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1539, 'Record updated For Staff id 28', 28, 2, 'Update', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:29:46', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1540, 'Record updated For Staff id 29', 29, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:31:05', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1541, 'Record updated For Staff id 30', 30, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:32:27', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1542, 'Record updated For Staff id 22', 22, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:32:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1543, 'Record updated For Staff id 22', 22, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:32:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1544, 'Record updated For Staff id 31', 31, 2, 'Update', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:33:09', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1545, 'Record updated For Staff id 32', 32, 2, 'Update', '103.151.171.235', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:34:42', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1546, 'Record updated For Staff id 33', 33, 2, 'Update', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:36:29', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1547, 'Record updated For Staff id 34', 34, 2, 'Update', '103.205.68.34', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 01:38:22', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1548, 'New Record inserted On Expense Head id 1', 1, 1, 'Insert', '103.67.157.153', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 10:57:35', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1549, 'New Record inserted On Expenses id 1', 1, 1, 'Insert', '103.67.157.153', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:03:15', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1550, 'New Record inserted On Item Category id 1', 1, 1, 'Insert', '103.67.157.153', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:29:51', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1551, 'New Record inserted On Item Category id 2', 2, 1, 'Insert', '103.67.157.153', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:30:08', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1552, 'New Record inserted On Item supplier id 1', 1, 1, 'Insert', '103.67.157.153', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:30:43', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1553, 'New Record inserted On Item supplier id 2', 2, 1, 'Insert', '103.67.157.153', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:31:45', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1554, 'New Record inserted On Item Store id 1', 1, 1, 'Insert', '103.67.157.153', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:32:14', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1555, 'New Record inserted On Item Store id 2', 2, 1, 'Insert', '103.67.157.153', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:32:30', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1556, 'New Record inserted On Item id 1', 1, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:36:28', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1557, 'New Record inserted On Item Stock id 1', 1, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:38:57', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1558, 'New Record inserted On Item Issue id 1', 1, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 11:40:04', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1559, 'New Record inserted On Referral Category id 2', 2, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:04:49', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1560, 'New Record inserted On Referral Commission id 8', 8, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:06:09', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1561, 'New Record inserted On Referral Commission id 9', 9, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:06:09', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1562, 'New Record inserted On Referral Commission id 10', 10, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:06:09', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1563, 'New Record inserted On Referral Commission id 11', 11, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:06:09', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1564, 'New Record inserted On Referral Commission id 12', 12, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:06:09', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1565, 'New Record inserted On Referral Commission id 13', 13, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:06:09', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1566, 'New Record inserted On Referral Commission id 14', 14, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:06:09', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1567, 'New Record inserted On Referral Person id 2', 2, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:09:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1568, 'New Record inserted On Referral Person Commission id 8', 8, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:09:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1569, 'New Record inserted On Referral Person Commission id 9', 9, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:09:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1570, 'New Record inserted On Referral Person Commission id 10', 10, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:09:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1571, 'New Record inserted On Referral Person Commission id 11', 11, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:09:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1572, 'New Record inserted On Referral Person Commission id 12', 12, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:09:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1573, 'New Record inserted On Referral Person Commission id 13', 13, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:09:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1574, 'New Record inserted On Referral Person Commission id 14', 14, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:09:31', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1575, 'New Record inserted On Referral Person id 3', 3, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:13:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1576, 'New Record inserted On Referral Person Commission id 15', 15, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:13:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1577, 'New Record inserted On Referral Person Commission id 16', 16, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:13:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1578, 'New Record inserted On Referral Person Commission id 17', 17, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:13:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1579, 'New Record inserted On Referral Person Commission id 18', 18, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:13:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1580, 'New Record inserted On Referral Person Commission id 19', 19, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:13:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1581, 'New Record inserted On Referral Person Commission id 20', 20, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:13:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1582, 'New Record inserted On Referral Person Commission id 21', 21, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:13:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1583, 'New Record inserted On Patient id 9', 9, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:51:46', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1584, 'Record updated On Patient id 9', 9, 1, 'Update', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:51:46', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1585, 'New Record inserted On Transactions id 26', 26, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:54:51', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1586, 'New Record inserted On Radiology Billing id 8', 8, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:58:30', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1587, 'New Record inserted On Transactions id 27', 27, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:58:30', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1588, 'New Record inserted On Transactions id 28', 28, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 12:59:37', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1589, 'New Record inserted On Read System Notification id 70', 70, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:06:52', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1590, 'New Record inserted On Read System Notification id 71', 71, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:07:44', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1591, 'New Record inserted On Read System Notification id 72', 72, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:07:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1592, 'New Record inserted On Read System Notification id 73', 73, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:07:49', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1593, 'Record updated On Patient id 9', 9, 1, 'Update', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:11:34', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1594, 'New Record inserted On Patient id 10', 10, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:13:24', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1595, 'Record updated On Patient id 10', 10, 1, 'Update', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:13:24', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1596, 'New Record inserted On Radiology Billing id 9', 9, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:15:47', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1597, 'New Record inserted On Transactions id 29', 29, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:15:47', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1598, 'New Record inserted On Transactions id 30', 30, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:15:47', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1599, 'New Record inserted On Transactions id 31', 31, 1, 'Insert', '43.245.123.123', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 13:24:08', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1600, 'New Record inserted On Patient id 11', 11, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:10:52', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1601, 'Record updated On Patient id 11', 11, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:10:52', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1602, 'New Record inserted On Transactions id 32', 32, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:20:10', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1603, 'New Record inserted On Transactions id 33', 33, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:22:16', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1604, 'New Record inserted On Patient id 12', 12, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:29:04', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1605, 'Record updated On Patient id 12', 12, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:29:04', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1606, 'New Record inserted On IPD id 2', 2, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:30:23', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1607, 'Record updated On Bed id 1', 1, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:30:23', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1608, 'New Record inserted On Patient bed history id 2', 2, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:30:23', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1609, 'New Record inserted On Patient Charges id 4', 4, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:35:59', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1610, 'New Record inserted On Transactions id 34', 34, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:36:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1611, 'New Record inserted On Patient id 13', 13, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:46:21', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1612, 'Record updated On Patient id 13', 13, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:46:21', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1613, 'New Record inserted On Charge Categories id 31', 31, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:51:52', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1614, 'New Record inserted On Transactions id 35', 35, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 15:54:45', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1615, 'New Record inserted On Patient id 14', 14, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:02:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1616, 'Record updated On Patient id 14', 14, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:02:49', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1617, 'New Record inserted On Read System Notification id 74', 74, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:23', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1618, 'New Record inserted On Read System Notification id 75', 75, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:30', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1619, 'New Record inserted On Read System Notification id 76', 76, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:32', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1620, 'New Record inserted On Read System Notification id 77', 77, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:33', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1621, 'New Record inserted On Read System Notification id 78', 78, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:34', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1622, 'New Record inserted On Read System Notification id 79', 79, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:35', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1623, 'New Record inserted On Read System Notification id 80', 80, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:37', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1624, 'New Record inserted On Read System Notification id 81', 81, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:38', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1625, 'New Record inserted On Read System Notification id 82', 82, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:26:45', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1626, 'Record updated For Staff id 1', 1, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:33:57', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1627, 'Record updated For Staff id 1', 1, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:33:57', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1628, 'Record updated For Staff id 1', 1, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:33:57', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1629, 'Record updated On Radiology Report id 11', 11, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:51:42', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1630, 'New Record inserted On Patient id 15', 15, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:57:58', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1631, 'Record updated On Patient id 15', 15, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:57:58', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1632, 'New Record inserted On Radiology Billing id 10', 10, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:58:27', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1633, 'New Record inserted On Transactions id 36', 36, 1, 'Insert', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:58:27', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1634, 'Record updated On Radiology Report id 13', 13, 1, 'Update', '116.58.203.104', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 16:59:44', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1635, 'Record updated On Radiology Report id 11', 11, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 19:48:45', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1636, 'Record updated On Radiology Parameter id 1', 1, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 19:52:42', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1637, 'New Record inserted On Patient id 16', 16, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:00:59', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1638, 'Record updated On Patient id 16', 16, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:00:59', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1639, 'New Record inserted On Transactions id 37', 37, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:01:22', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1640, 'Record updated On Pathology Report id 15', 15, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:05:06', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1641, 'New Record inserted On Patient id 17', 17, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:09:37', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1642, 'Record updated On Patient id 17', 17, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:09:37', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1643, 'New Record inserted On Transactions id 38', 38, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:10:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1644, 'Record updated On Pathology Report id 16', 16, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:11:27', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1645, 'Record updated On Pathology Report id 17', 17, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:11:41', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1646, 'Record updated On Pathology Report id 18', 18, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:11:48', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1647, 'Record updated On Pathology Report id 19', 19, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:12:11', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1648, 'New Record inserted On Pathology Parameter id 153', 153, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:17:53', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1649, 'New Record inserted On pathology Test id 421', 421, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:19:15', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1650, 'New Record inserted On pathology Test id 421', 421, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:19:59', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1651, 'New Record inserted On Patient id 18', 18, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:26:37', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1652, 'Record updated On Patient id 18', 18, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:26:37', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1653, 'New Record inserted On Transactions id 39', 39, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:27:19', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1654, 'Record updated On Pathology Report id 20', 20, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:27:59', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1655, 'Record updated On Pathology Report id 21', 21, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:28:21', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1656, 'Record updated On Pathology Report id 22', 22, 1, 'Update', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:28:35', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1657, 'New Record inserted On Unit id 36', 36, 1, 'Insert', '103.67.159.2', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-26 20:35:52', '2022-02-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1658, 'Record updated On Radio id 89', 89, 1, 'Update', '::1', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-27 03:41:39', '2022-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1659, 'Record updated On Radiology Parameter id 1', 1, 1, 'Update', '::1', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-27 03:43:43', '2022-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1660, 'Record updated On Radiology Parameter id 5', 5, 1, 'Update', '::1', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-27 03:44:35', '2022-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1661, 'Record updated On Radiology Parameter id 2', 2, 1, 'Update', '::1', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-27 03:45:02', '2022-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1662, 'Record updated On Radiology Parameter id 1', 1, 1, 'Update', '::1', 'Windows 10', 'Chrome 98.0.4758.102', '2022-02-2