#
# TABLE STRUCTURE FOR: acc_coa
#

DROP TABLE IF EXISTS `acc_coa`;

CREATE TABLE `acc_coa` (
  `HeadCode` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `HeadName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `PHeadName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `HeadLevel` int(11) NOT NULL,
  `IsActive` tinyint(1) NOT NULL,
  `IsTransaction` tinyint(1) NOT NULL,
  `IsGL` tinyint(1) NOT NULL,
  `HeadType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `IsBudget` tinyint(1) NOT NULL,
  `IsDepreciation` tinyint(1) NOT NULL,
  `DepreciationRate` decimal(18,2) NOT NULL,
  `CreateBy` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `CreateDate` datetime NOT NULL,
  `UpdateBy` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `UpdateDate` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021403', 'AC', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:33:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202', 'Account Payable', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10203', 'Account Receivable', 'Current Asset', 2, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2013-09-18 15:29:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020201', 'Advance', 'Advance, Deposit And Pre-payments', 3, 1, 0, 1, 'A', 0, 0, '0.00', 'Zoherul', '2015-05-31 13:29:12', 'admin', '2015-12-31 16:46:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020103', 'Advance House Rent', 'Advance', 4, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-10-02 16:55:38', 'admin', '2016-10-02 16:57:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10202', 'Advance, Deposit And Pre-payments', 'Current Asset', 2, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-12-31 16:46:24');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020602', 'Advertisement and Publicity', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:51:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010410', 'Air Cooler', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-05-23 12:13:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020603', 'AIT Against Advertisement', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:09', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020200001', 'any-CDC5X7X2KR3ILJVQTIVG', 'Account Payable', 3, 1, 1, 0, 'L', 0, 0, '0.00', '1', '2022-02-23 23:30:57', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1', 'Assets', 'COA', 0, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010204', 'Attendance Machine', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:49:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40216', 'Audit Fee', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2017-07-18 12:54:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021002', 'Bank Charge', 'Financial Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:21:03', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30203', 'Bank Interest', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'Obaidul', '2015-01-03 14:49:54', 'admin', '2016-09-25 11:04:19');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010104', 'Book Shelf', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:46:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010407', 'Books and Journal', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:45:37', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020604', 'Business Development Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020606', 'Campaign Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:57', 'admin', '2016-09-19 14:52:48');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020502', 'Campus Rent', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:46:53', 'admin', '2017-04-27 17:02:39');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40212', 'Car Running Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:28:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10201', 'Cash & Cash Equivalent', 'Current Asset', 2, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-06-12 11:47:24', 'admin', '2015-10-15 15:57:55');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020102', 'Cash At Bank', 'Cash & Cash Equivalent', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-03-18 06:08:18', 'admin', '2015-10-15 15:32:42');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020101', 'Cash In Hand', 'Cash & Cash Equivalent', 3, 1, 1, 0, 'A', 0, 0, '0.00', '1', '2019-01-26 07:38:48', 'admin', '2016-05-23 12:05:43');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010207', 'CCTV', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:24', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020102', 'CEO Current A/C', 'Advance', 4, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-09-25 11:54:54', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010101', 'Class Room Chair', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:45:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021407', 'Close Circuit Cemera', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:35', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020601', 'Commision on Admission', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:51:21', 'admin', '2016-09-19 14:42:54');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010206', 'Computer', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:09', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021410', 'Computer (R)', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-03-24 12:38:52', 'Zoherul', '2016-03-24 12:41:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010102', 'Computer Table', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:45:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('301020401', 'Continuing Registration fee - UoL (Income)', 'Registration Fee (UOL) Income', 4, 1, 1, 0, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:40:40', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020904', 'Contratuall Staff Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:34', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020709', 'Cultural Expense', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'nasmud', '2017-04-29 12:45:10', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102', 'Current Asset', 'Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2018-07-07 11:23:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502', 'Current Liabilities', 'Liabilities', 1, 1, 0, 0, 'L', 0, 0, '0.00', 'anwarul', '2014-08-30 13:18:20', 'admin', '2015-10-15 19:49:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020301', 'Customer Receivable', 'Account Receivable', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-01-24 12:10:05', 'admin', '2018-07-07 12:31:42');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020202', 'Deposit', 'Advance, Deposit And Pre-payments', 3, 1, 0, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:40:42', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020605', 'Design & Printing Expense', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:55:00', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020404', 'Dish Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40215', 'Dividend', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2016-09-25 14:07:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020403', 'Drinking Water Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:10', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010211', 'DSLR Camera', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:53:17', 'admin', '2016-01-02 16:23:25');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020908', 'Earned Leave', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:38', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020607', 'Education Fair Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:53:42', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010602', 'Electric Equipment', 'Electrical Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:44:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010203', 'Electric Kettle', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:49:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10106', 'Electrical Equipment', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:43:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020407', 'Electricity Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:59:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50204', 'Employee Ledger', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', '1', '2019-04-08 10:36:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('404', 'Employee Salary', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-23 05:46:14', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40201', 'Entertainment', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:21:26', 'anwarul', '2013-07-17 14:21:47');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('2', 'Equity', 'COA', 0, 1, 0, 0, 'L', 0, 0, '0.00', '', '2019-08-10 11:01:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4', 'Expence', 'COA', 0, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-06-18 11:40:41', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020903', 'Faculty,Staff Salary & Allowances', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021404', 'Fax Machine', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:34:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020905', 'Festival & Incentive Bonus', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:48', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010103', 'File Cabinet', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:46:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40210', 'Financial Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-08-20 12:24:31', 'admin', '2015-10-15 19:20:36');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010403', 'Fire Extingushier', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:39:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('405', 'Fixed Assets Cost', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-29 05:32:01', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021408', 'Furniture', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:47', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10101', 'Furniture & Fixturers', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'anwarul', '2013-08-20 16:18:15', 'anwarul', '2013-08-21 13:35:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020406', 'Gas Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:59:20', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20201', 'General Reserve', 'Reserve & Surplus', 2, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-25 14:07:12', 'admin', '2016-10-02 17:48:49');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10105', 'Generator', 'Non Current Assets', 2, 1, 1, 1, 'A', 0, 0, '0.00', 'Zoherul', '2016-02-27 16:02:35', 'admin', '2016-05-23 12:05:18');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021414', 'Generator Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-06-16 10:21:05', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40213', 'Generator Running Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:29:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10103', 'Groceries and Cutleries', 'Non Current Assets', 2, 1, 1, 1, 'A', 0, 0, '0.00', '2', '2018-07-12 10:02:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010408', 'Gym Equipment', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:46:03', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020907', 'Honorarium', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:26', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40205', 'House Rent', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-08-24 10:26:56', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3', 'Income', 'COA', 0, 1, 0, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:32:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30204', 'Income from Photocopy & Printing', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'Zoherul', '2015-07-14 10:29:54', 'admin', '2016-09-25 11:04:28');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020302', 'Income Tax Payable', 'Liabilities for Expenses', 3, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2016-09-19 11:18:17', 'admin', '2016-09-28 13:18:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10107', 'Inventory', 'Non Current Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '2', '2018-07-07 15:21:58', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010210', 'LCD TV', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:52:27', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30103', 'Lease Sale', 'Store Income', 1, 1, 1, 1, 'I', 0, 0, '0.00', '2', '2018-07-08 07:51:52', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5', 'Liabilities', 'COA', 0, 1, 0, 0, 'L', 0, 0, '0.00', 'admin', '2013-07-04 12:32:07', 'admin', '2015-10-15 19:46:54');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50203', 'Liabilities for Expenses', 'Current Liabilities', 2, 1, 0, 0, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020707', 'Library Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2017-01-10 15:34:54', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021409', 'Lift', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:36:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020302', 'Loan Receivable', 'Account Receivable', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-01-26 07:37:20', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50101', 'Long Term Borrowing', 'Non Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2013-07-04 12:32:26', 'admin', '2015-10-15 19:47:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020608', 'Marketing & Promotion Exp.', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:53:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020901', 'Medical Allowance', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:11:33', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010411', 'Metal Ditector', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'Zoherul', '2016-08-22 10:55:22', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021413', 'Micro Oven', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-05-12 14:53:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30202', 'Miscellaneous (Income)', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'anwarul', '2014-02-06 15:26:31', 'admin', '2016-09-25 11:04:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020909', 'Miscellaneous Benifit', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:53', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020701', 'Miscellaneous Exp', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-09-25 12:54:39', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40207', 'Miscellaneous Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2014-04-26 16:49:56', 'admin', '2016-09-25 12:54:19');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010401', 'Mobile Phone', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-29 10:43:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010212', 'Network Accessories', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-02 16:23:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020408', 'News Paper Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-01-02 15:55:57', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('101', 'Non Current Assets', 'Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-10-15 15:29:11');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('501', 'Non Current Liabilities', 'Liabilities', 1, 1, 0, 0, 'L', 0, 0, '0.00', 'anwarul', '2014-08-30 13:18:20', 'admin', '2015-10-15 19:49:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010404', 'Office Decoration', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:40:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10102', 'Office Equipment', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'anwarul', '2013-12-06 18:08:00', 'admin', '2015-10-15 15:48:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021401', 'Office Repair & Maintenance', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:33:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30201', 'Office Stationary (Income)', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'anwarul', '2013-07-17 15:21:06', 'admin', '2016-09-25 11:04:50');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('302', 'Other Income', 'Income', 1, 1, 0, 0, 'I', 0, 0, '0.00', '2', '2018-07-07 13:40:57', 'admin', '2016-09-25 11:04:09');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40211', 'Others (Non Academic Expenses)', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'Obaidul', '2014-12-03 16:05:42', 'admin', '2015-10-15 19:22:09');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30205', 'Others (Non-Academic Income)', 'Other Income', 2, 1, 0, 1, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:23:49', 'admin', '2015-10-15 17:57:52');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10104', 'Others Assets', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2016-01-29 10:43:16', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020910', 'Outstanding Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 11:56:50', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021405', 'Oven', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:34:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021412', 'PABX-Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 14:40:18', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020902', 'Part-time Staff Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:06', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010202', 'Photocopy & Fax Machine', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:47:27', 'admin', '2016-05-23 12:14:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021411', 'Photocopy Machine Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 12:40:02', 'admin', '2017-04-27 17:03:17');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020503', 'Practical Fee', 'Others (Non-Academic Income)', 3, 1, 1, 1, 'I', 0, 0, '0.00', 'admin', '2017-07-22 18:00:37', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020203', 'Prepayment', 'Advance, Deposit And Pre-payments', 3, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:40:51', 'admin', '2015-12-31 16:49:58');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010201', 'Printer', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:47:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40202', 'Printing and Stationary', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:21:45', 'admin', '2016-09-19 14:39:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('402', 'Product Purchase', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-20 07:46:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('304', 'Product Sale', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-06-16 12:15:40', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020502', 'Professional Training Course(Oracal-1)', 'Others (Non-Academic Income)', 3, 1, 1, 0, 'I', 0, 0, '0.00', 'nasim', '2017-06-22 13:28:05', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30207', 'Professional Training Course(Oracal)', 'Other Income', 2, 1, 0, 1, 'I', 0, 0, '0.00', 'nasim', '2017-06-22 13:24:16', 'nasim', '2017-06-22 13:25:56');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010208', 'Projector', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40206', 'Promonational Expence', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-07-11 13:48:57', 'anwarul', '2013-07-17 14:23:03');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40214', 'Repair and Maintenance', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:32:46', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('202', 'Reserve & Surplus', 'Equity', 1, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2016-09-25 14:06:34', 'admin', '2016-10-02 17:48:57');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20102', 'Retained Earnings', 'Share Holders Equity', 2, 1, 1, 1, 'L', 0, 0, '0.00', 'admin', '2016-05-23 11:20:40', 'admin', '2016-09-25 14:05:06');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020708', 'River Cruse', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2017-04-24 15:35:25', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020105', 'Salary', 'Advance', 4, 1, 0, 0, 'A', 0, 0, '0.00', 'admin', '2018-07-05 11:46:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40209', 'Salary & Allowances', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-12-12 11:22:58', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010406', 'Security Equipment', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:41:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('305', 'Service Income', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-22 13:36:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20101', 'Share Capital', 'Share Holders Equity', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'anwarul', '2013-12-08 19:37:32', 'admin', '2015-10-15 19:45:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('201', 'Share Holders Equity', 'Equity', 1, 1, 0, 0, 'L', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-10-15 19:43:51');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50201', 'Short Term Borrowing', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40208', 'Software Development Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-11-21 14:13:01', 'admin', '2015-10-15 19:02:51');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020906', 'Special Allowances', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:13', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50102', 'Sponsors Loan', 'Non Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:48:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020706', 'Sports Expense', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'nasmud', '2016-11-09 13:16:53', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('301', 'Store Income', 'Income', 1, 1, 0, 0, 'I', 0, 0, '0.00', '2', '2018-07-07 13:40:37', 'admin', '2015-09-17 17:00:02');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020501', 'Students Info. Correction Fee', 'Others (Non-Academic Income)', 3, 1, 1, 0, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:24:45', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010601', 'Sub Station', 'Electrical Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:44:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50205', 'Supplier Ledger', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', '1', '2019-10-06 06:18:49', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020704', 'TB Care Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-10-08 13:03:04', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30206', 'TB Care Income', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'admin', '2016-10-08 13:00:56', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020501', 'TDS on House Rent', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:44:07', 'admin', '2016-09-19 14:40:16');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030201', 'TDS Payable House Rent', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-19 11:19:42', 'admin', '2016-09-28 13:19:37');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030203', 'TDS Payable on Advertisement Bill', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-28 13:20:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030202', 'TDS Payable on Salary', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-28 13:20:17', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020402', 'Telephone Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:57:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010209', 'Telephone Set & PABX', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:57', 'admin', '2016-10-02 17:10:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30301', 'test in 1', 'Test Income', 2, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:25:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('303', 'Test Income', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:24:33', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40203', 'Travelling & Conveyance', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:22:06', 'admin', '2015-10-15 18:45:13');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021406', 'TV', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010205', 'UPS', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:50:38', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40204', 'Utility Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-07-11 16:20:24', 'admin', '2016-01-02 15:55:22');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020503', 'VAT on House Rent Exp', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:49:22', 'admin', '2016-09-25 14:00:52');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020301', 'VAT Payable', 'Liabilities for Expenses', 3, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:51:11', 'admin', '2016-09-28 13:23:53');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010409', 'Vehicle A/C', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'Zoherul', '2016-05-12 12:13:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010405', 'Voltage Stablizer', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:40:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102030101', 'Walking Customer-P3NY6D1AKZQPHB7', 'Customer Receivable', 4, 1, 1, 0, 'A', 0, 0, '0.00', '1', '2019-05-20 06:55:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020405', 'WASA Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010402', 'Water Purifier', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-29 11:14:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020705', 'Website Development Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-10-15 12:42:47', '', '2019-08-10 11:01:12');


#
# TABLE STRUCTURE FOR: acc_transaction
#

DROP TABLE IF EXISTS `acc_transaction`;

CREATE TABLE `acc_transaction` (
  `ID` int(11) NOT NULL,
  `VNo` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Vtype` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `VDate` date DEFAULT NULL,
  `COAID` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `Narration` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `Debit` decimal(18,2) DEFAULT NULL,
  `Credit` decimal(18,2) DEFAULT NULL,
  `IsPosted` char(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CreateBy` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CreateDate` datetime DEFAULT NULL,
  `UpdateBy` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `UpdateDate` datetime DEFAULT NULL,
  `IsAppove` char(10) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (1, '20220223233214', 'Purchase', '2022-02-23', '10107', 'Inventory Debit For Purchase No20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (2, '20220223233214', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233214', '0.00', '80.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (3, '20220223233214', 'Purchase', '2022-02-23', '402', 'Company Credit For Purchase No20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (4, '20220223233214', 'Purchase', '2022-02-23', '1020101', 'Cash in Hand For Purchase No20220223233214', '0.00', '80.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (5, '20220223233214', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (6, '20220223233301', 'Purchase', '2022-02-23', '10107', 'Inventory Debit For Purchase No20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (7, '20220223233301', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233301', '0.00', '132.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (8, '20220223233301', 'Purchase', '2022-02-23', '402', 'Company Credit For Purchase No20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (9, '20220223233301', 'Purchase', '2022-02-23', '1020101', 'Cash in Hand For Purchase No20220223233301', '0.00', '132.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (10, '20220223233301', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (11, '9259592329', 'INVOICE', '2022-02-23', '10107', 'Inventory credit For Invoice No9259592329', '0.00', '8.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (12, '9259592329', 'INVOICE', '2022-02-23', '102030101', 'Customer debit For Invoice No9259592329', '6.00', '0.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (13, '9259592329', 'INVOICE', '2022-02-23', '304', 'Customer debit For Invoice No9259592329', '0.00', '6.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (14, '1877899635', 'INVOICE', '2022-02-23', '10107', 'Inventory credit For Invoice No1877899635', '0.00', '4.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (15, '1877899635', 'INVOICE', '2022-02-23', '102030101', 'Customer debit For Invoice No1877899635', '3.00', '0.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (16, '1877899635', 'INVOICE', '2022-02-23', '304', 'Customer debit For Invoice No1877899635', '0.00', '3.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');


#
# TABLE STRUCTURE FOR: accesslog
#

DROP TABLE IF EXISTS `accesslog`;

CREATE TABLE `accesslog` (
  `sl_no` bigint(20) NOT NULL,
  `action_page` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action_done` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `user_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_date` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: account_2
#

DROP TABLE IF EXISTS `account_2`;

CREATE TABLE `account_2` (
  `account_id` int(11) NOT NULL,
  `account_name` varchar(40) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `parent_id` int(1) NOT NULL,
  `status` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `account_id` varchar(20) NOT NULL,
  `account_table_name` varchar(255) NOT NULL,
  `account_name` varchar(255) NOT NULL,
  `status` int(5) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) DEFAULT NULL,
  `tax_percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  CONSTRAINT `ambulance_call_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_2` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_4` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (5, 'Low', '2021-09-24 19:28:40');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `time` time DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int(11) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `is_queue` int(11) DEFAULT NULL,
  `live_consult` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  KEY `case_reference_id` (`case_reference_id`),
  CONSTRAINT `appointment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_2` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `note` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `appointment_id` (`appointment_id`),
  CONSTRAINT `appointment_payment_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_payment_ibfk_3` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`shift_id`),
  CONSTRAINT `appointment_queue_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_3` FOREIGN KEY (`shift_id`) REFERENCES `doctor_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset_purchase
#

DROP TABLE IF EXISTS `asset_purchase`;

CREATE TABLE `asset_purchase` (
  `id` int(11) NOT NULL,
  `p_date` date NOT NULL,
  `supplier_id` varchar(30) NOT NULL,
  `grand_total` float NOT NULL,
  `payment_type` tinyint(4) DEFAULT NULL,
  `bank_id` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: attendance
#

DROP TABLE IF EXISTS `attendance`;

CREATE TABLE `attendance` (
  `att_id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `sign_in` varchar(30) NOT NULL,
  `sign_out` varchar(30) NOT NULL,
  `staytime` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bank_add
#

DROP TABLE IF EXISTS `bank_add`;

CREATE TABLE `bank_add` (
  `id` int(11) NOT NULL,
  `bank_id` varchar(50) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `ac_name` varchar(250) DEFAULT NULL,
  `ac_number` varchar(250) DEFAULT NULL,
  `branch` varchar(250) DEFAULT NULL,
  `signature_pic` varchar(250) DEFAULT NULL,
  `status` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bank_summary
#

DROP TABLE IF EXISTS `bank_summary`;

CREATE TABLE `bank_summary` (
  `id` int(11) NOT NULL,
  `bank_id` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `deposite_id` varchar(250) DEFAULT NULL,
  `date` varchar(250) DEFAULT NULL,
  `ac_type` varchar(50) DEFAULT NULL,
  `dr` decimal(12,2) DEFAULT 0.00,
  `cr` decimal(10,2) DEFAULT 0.00,
  `ammount` decimal(12,2) DEFAULT 0.00,
  `status` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `bed_ibfk_1` FOREIGN KEY (`bed_type_id`) REFERENCES `bed_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (1, '401A', 1, 3, 'no', '2022-02-18 11:49:52');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (2, '402A', 1, 3, 'no', '2022-02-18 11:50:06');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (3, '403A', 1, 3, 'no', '2022-02-18 11:50:36');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (4, '303', 2, 2, 'no', '2022-02-18 11:50:59');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (6, '208', 2, 1, 'no', '2022-02-28 09:59:56');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (7, '401B', 1, 3, 'no', '2022-02-28 10:00:48');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (8, '401C', 1, 3, 'no', '2022-02-28 10:01:04');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (9, '401D', 1, 3, 'no', '2022-02-28 10:01:15');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (10, '401E', 1, 3, 'no', '2022-02-28 10:01:32');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (11, '402B', 1, 3, 'yes', '2022-02-28 10:02:04');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (12, '402C', 1, 3, 'no', '2022-02-28 10:02:16');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (13, '402D', 1, 3, 'no', '2022-02-28 10:02:27');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (14, '402E', 1, 3, 'no', '2022-02-28 10:02:40');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (15, '403B', 1, 3, 'no', '2022-02-28 10:03:05');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (16, '403C', 1, 3, 'no', '2022-02-28 10:03:16');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (17, '403D', 1, 3, 'no', '2022-02-28 10:03:28');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (18, '403E', 1, 3, 'no', '2022-02-28 10:03:39');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (19, '303A', 2, 2, 'no', '2022-02-28 10:08:28');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (21, '303.', 2, 2, 'no', '2022-02-28 10:09:21');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `color` varchar(50) NOT NULL DEFAULT '#f4f4f4',
  `description` varchar(200) NOT NULL,
  `floor` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (1, 'Cabin', '#f4f4f4', '', 1, 0, '2022-02-28 09:54:13');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (2, 'Cabin VIP', '#a3acf5', '', 2, 0, '2022-02-28 09:55:01');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (3, 'Ward', '#9cf29d', '', 3, 0, '2022-02-28 09:55:37');


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (1, 'Ward', '2022-02-18 11:49:17');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (2, 'Cabin', '2022-02-18 11:49:28');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext DEFAULT NULL,
  `document` varchar(200) NOT NULL,
  `address` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `birth_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `birth_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  CONSTRAINT `blood_donor_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int(11) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `blood_donor_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `volume` varchar(100) DEFAULT NULL,
  `unit` int(11) DEFAULT NULL,
  `available` int(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_donor_cycle_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_2` FOREIGN KEY (`blood_donor_id`) REFERENCES `blood_donor` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `blood_donor_cycle_id` int(11) DEFAULT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `hospital_doctor` int(11) DEFAULT NULL,
  `reference` varchar(200) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `remark` mediumtext DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_issue_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_2` FOREIGN KEY (`blood_donor_cycle_id`) REFERENCES `blood_donor_cycle` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_4` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-10-22 11:21:32');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-10-22 11:21:38');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 0, '2021-10-22 11:21:40');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=400 DEFAULT CHARSET=utf8;

INSERT INTO `case_references` (`id`, `created_at`) VALUES (1, '2022-01-11 12:32:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2, '2022-02-18 11:55:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (3, '2022-02-18 12:56:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (4, '2022-02-26 15:30:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (5, '2022-02-26 15:54:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (6, '2022-02-27 20:21:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (7, '2022-02-27 21:20:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (8, '2022-02-27 21:32:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (9, '2022-03-01 00:04:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (10, '2022-03-01 09:10:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (11, '2022-03-01 13:19:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (12, '2022-03-01 18:30:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (13, '2022-03-01 18:49:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (14, '2022-03-01 19:06:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (15, '2022-03-01 19:10:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (16, '2022-03-01 19:11:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (17, '2022-03-01 19:24:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (18, '2022-03-01 19:42:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (19, '2022-03-01 19:53:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (20, '2022-03-01 23:43:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (21, '2022-03-01 23:55:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (22, '2022-03-02 00:12:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (23, '2022-03-02 00:16:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (24, '2022-03-02 08:56:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (25, '2022-03-02 18:07:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (26, '2022-03-02 18:26:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (27, '2022-03-02 18:28:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (28, '2022-03-02 18:34:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (29, '2022-03-02 18:37:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (30, '2022-03-02 18:37:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (31, '2022-03-03 11:53:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (32, '2022-03-03 12:29:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (33, '2022-03-03 12:31:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (34, '2022-03-03 12:33:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (35, '2022-03-03 16:30:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (36, '2022-03-03 23:14:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (37, '2022-03-04 16:20:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (38, '2022-03-05 09:31:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (39, '2022-03-05 17:34:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (40, '2022-03-05 17:59:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (41, '2022-03-05 18:10:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (42, '2022-03-05 18:23:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (43, '2022-03-05 18:24:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (44, '2022-03-05 18:25:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (45, '2022-03-05 18:38:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (46, '2022-03-05 18:54:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (47, '2022-03-05 18:55:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (48, '2022-03-05 18:57:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (49, '2022-03-06 08:38:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (50, '2022-03-06 09:05:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (51, '2022-03-06 15:15:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (52, '2022-03-06 15:27:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (53, '2022-03-06 15:32:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (54, '2022-03-06 15:38:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (55, '2022-03-06 15:40:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (56, '2022-03-06 19:42:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (57, '2022-03-07 00:24:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (58, '2022-03-07 01:04:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (59, '2022-03-07 08:30:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (60, '2022-03-07 08:31:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (61, '2022-03-07 20:33:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (62, '2022-03-08 14:09:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (63, '2022-03-08 14:23:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (64, '2022-03-08 14:41:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (65, '2022-03-08 22:39:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (66, '2022-03-09 21:40:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (67, '2022-03-10 00:18:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (68, '2022-03-10 00:49:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (69, '2022-03-18 21:54:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (70, '2022-03-19 10:20:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (71, '2022-03-19 10:26:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (72, '2022-03-19 11:18:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (73, '2022-03-19 12:28:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (74, '2022-03-19 12:36:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (75, '2022-03-19 12:40:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (76, '2022-03-19 18:45:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (77, '2022-03-19 18:57:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (78, '2022-03-19 19:06:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (79, '2022-03-19 19:38:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (80, '2022-03-19 19:51:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (81, '2022-03-19 22:12:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (82, '2022-03-19 22:28:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (83, '2022-03-19 22:33:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (84, '2022-03-19 23:41:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (85, '2022-03-20 09:41:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (86, '2022-03-20 10:24:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (87, '2022-03-20 12:09:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (88, '2022-03-20 13:07:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (89, '2022-03-20 18:54:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (90, '2022-03-20 18:57:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (91, '2022-03-20 20:01:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (92, '2022-03-20 23:29:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (93, '2022-03-21 10:07:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (94, '2022-03-21 11:37:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (95, '2022-03-21 13:39:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (96, '2022-03-21 15:22:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (97, '2022-03-21 16:35:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (98, '2022-03-21 16:48:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (99, '2022-03-21 17:49:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (100, '2022-03-21 19:34:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (101, '2022-03-21 20:17:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (102, '2022-03-21 20:47:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (103, '2022-03-21 22:49:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (104, '2022-03-22 08:40:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (105, '2022-03-22 11:23:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (106, '2022-03-22 11:34:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (107, '2022-03-22 11:55:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (108, '2022-03-22 11:59:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (109, '2022-03-22 12:15:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (110, '2022-03-22 13:05:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (111, '2022-03-22 13:08:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (112, '2022-03-22 13:45:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (113, '2022-03-22 19:13:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (114, '2022-03-22 19:18:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (115, '2022-03-22 19:29:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (116, '2022-03-22 19:40:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (117, '2022-03-22 22:20:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (118, '2022-03-23 08:16:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (119, '2022-03-23 11:18:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (120, '2022-03-23 12:44:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (121, '2022-03-23 17:02:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (122, '2022-03-23 17:39:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (123, '2022-03-23 18:13:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (124, '2022-03-23 18:14:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (125, '2022-03-23 19:08:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (126, '2022-03-23 21:15:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (127, '2022-03-23 21:47:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (128, '2022-03-24 09:38:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (129, '2022-03-24 10:33:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (130, '2022-03-24 11:37:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (131, '2022-03-24 12:17:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (132, '2022-03-24 13:03:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (133, '2022-03-24 13:24:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (134, '2022-03-24 17:30:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (135, '2022-03-24 17:42:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (136, '2022-03-24 18:07:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (137, '2022-03-24 19:06:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (138, '2022-03-24 19:09:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (139, '2022-03-24 19:23:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (140, '2022-03-24 19:30:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (141, '2022-03-24 21:18:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (142, '2022-03-24 22:06:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (143, '2022-03-24 23:04:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (144, '2022-03-24 23:13:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (145, '2022-03-25 10:20:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (146, '2022-03-25 11:05:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (147, '2022-03-25 11:25:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (148, '2022-03-25 12:45:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (149, '2022-03-25 12:52:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (150, '2022-03-25 13:48:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (151, '2022-03-25 18:28:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (152, '2022-03-25 18:33:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (153, '2022-03-25 20:34:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (154, '2022-03-25 21:17:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (155, '2022-03-25 22:08:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (156, '2022-03-25 22:11:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (157, '2022-03-26 10:10:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (158, '2022-03-26 11:18:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (159, '2022-03-26 15:33:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (160, '2022-03-26 15:34:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (161, '2022-03-26 16:14:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (162, '2022-03-26 16:43:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (163, '2022-03-26 19:46:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (164, '2022-03-26 20:18:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (165, '2022-03-26 21:05:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (166, '2022-03-26 21:06:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (167, '2022-03-27 08:48:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (168, '2022-03-27 09:18:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (169, '2022-03-27 09:33:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (170, '2022-03-27 10:53:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (171, '2022-03-27 11:48:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (172, '2022-03-27 16:50:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (173, '2022-03-27 17:50:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (174, '2022-03-27 18:02:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (175, '2022-03-27 18:19:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (176, '2022-03-27 18:59:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (177, '2022-03-27 19:16:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (178, '2022-03-27 20:36:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (179, '2022-03-27 20:39:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (180, '2022-03-27 22:51:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (181, '2022-03-28 11:08:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (182, '2022-03-28 13:02:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (183, '2022-03-28 13:04:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (184, '2022-03-28 14:05:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (185, '2022-03-28 16:43:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (186, '2022-03-28 17:14:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (187, '2022-03-28 18:07:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (188, '2022-03-28 19:05:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (189, '2022-03-28 20:09:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (190, '2022-03-29 12:25:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (191, '2022-03-29 12:36:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (192, '2022-03-29 12:55:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (193, '2022-03-29 14:01:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (194, '2022-03-29 14:36:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (195, '2022-03-29 14:38:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (196, '2022-03-29 17:11:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (197, '2022-03-29 17:26:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (198, '2022-03-29 18:06:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (199, '2022-03-29 19:08:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (200, '2022-03-29 19:52:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (201, '2022-03-29 19:53:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (202, '2022-03-30 10:39:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (203, '2022-03-30 11:03:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (204, '2022-03-30 12:40:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (205, '2022-03-30 14:03:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (206, '2022-03-30 16:35:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (207, '2022-03-30 16:44:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (208, '2022-03-30 17:07:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (209, '2022-03-30 19:38:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (210, '2022-03-30 19:41:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (211, '2022-03-31 09:04:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (212, '2022-03-31 10:30:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (213, '2022-03-31 11:23:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (214, '2022-03-31 12:04:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (215, '2022-03-31 12:07:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (216, '2022-03-31 13:57:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (217, '2022-03-31 15:43:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (218, '2022-03-31 17:36:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (219, '2022-03-31 18:08:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (220, '2022-03-31 18:57:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (221, '2022-03-31 19:08:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (222, '2022-03-31 20:53:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (223, '2022-03-31 22:04:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (224, '2022-04-01 05:02:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (225, '2022-04-01 10:31:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (226, '2022-04-01 11:09:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (227, '2022-04-01 11:28:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (228, '2022-04-01 13:00:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (229, '2022-04-01 13:13:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (230, '2022-04-01 16:34:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (231, '2022-04-01 17:50:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (232, '2022-04-01 18:48:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (233, '2022-04-01 20:14:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (234, '2022-04-01 22:17:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (235, '2022-04-02 09:30:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (236, '2022-04-02 10:25:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (237, '2022-04-02 11:25:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (238, '2022-04-02 11:31:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (239, '2022-04-02 14:01:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (240, '2022-04-02 15:37:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (241, '2022-04-02 17:25:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (242, '2022-04-02 17:31:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (243, '2022-04-02 18:55:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (244, '2022-04-02 19:24:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (245, '2022-04-03 11:12:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (246, '2022-04-03 11:22:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (247, '2022-04-03 12:19:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (248, '2022-04-03 12:48:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (249, '2022-04-03 19:51:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (250, '2022-04-03 20:14:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (251, '2022-04-03 22:14:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (252, '2022-04-04 09:45:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (253, '2022-04-04 10:28:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (254, '2022-04-04 11:26:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (255, '2022-04-04 11:27:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (256, '2022-04-04 12:01:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (257, '2022-04-04 12:03:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (258, '2022-04-04 13:14:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (259, '2022-04-04 16:06:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (260, '2022-04-04 18:13:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (261, '2022-04-04 21:20:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (262, '2022-04-04 22:13:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (263, '2022-04-04 22:15:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (264, '2022-04-04 22:16:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (265, '2022-04-05 09:52:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (266, '2022-04-05 10:14:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (267, '2022-04-05 10:46:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (268, '2022-04-05 15:59:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (269, '2022-04-05 18:14:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (270, '2022-04-05 21:41:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (271, '2022-04-06 09:13:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (272, '2022-04-06 09:54:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (273, '2022-04-06 10:33:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (274, '2022-04-06 10:48:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (275, '2022-04-06 19:13:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (276, '2022-04-06 19:46:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (277, '2022-04-06 20:47:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (278, '2022-04-06 23:02:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (279, '2022-04-07 09:51:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (280, '2022-04-07 10:10:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (281, '2022-04-07 10:25:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (282, '2022-04-07 10:59:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (283, '2022-04-07 11:31:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (284, '2022-04-07 11:39:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (285, '2022-04-07 15:32:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (286, '2022-04-07 15:52:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (287, '2022-04-07 21:01:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (288, '2022-04-07 21:23:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (289, '2022-04-08 09:38:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (290, '2022-04-08 09:45:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (291, '2022-04-08 10:35:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (292, '2022-04-08 10:43:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (293, '2022-04-08 10:49:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (294, '2022-04-08 11:10:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (295, '2022-04-08 11:15:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (296, '2022-04-08 12:08:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (297, '2022-04-08 12:11:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (298, '2022-04-08 12:25:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (299, '2022-04-08 14:48:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (300, '2022-04-08 16:09:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (301, '2022-04-08 20:12:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (302, '2022-04-09 06:43:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (303, '2022-04-09 07:36:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (304, '2022-04-09 07:40:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (305, '2022-04-09 11:03:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (306, '2022-04-09 11:12:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (307, '2022-04-09 11:17:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (308, '2022-04-09 11:24:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (309, '2022-04-09 12:10:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (310, '2022-04-09 12:20:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (311, '2022-04-09 15:18:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (312, '2022-04-09 15:46:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (313, '2022-04-09 17:34:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (314, '2022-04-09 17:54:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (315, '2022-04-09 17:55:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (316, '2022-04-09 19:17:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (317, '2022-04-10 08:51:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (318, '2022-04-10 09:33:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (319, '2022-04-10 09:52:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (320, '2022-04-10 10:04:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (321, '2022-04-10 12:11:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (322, '2022-04-10 12:27:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (323, '2022-04-10 12:49:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (324, '2022-04-10 12:57:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (325, '2022-04-10 14:34:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (326, '2022-04-10 15:13:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (327, '2022-04-10 15:43:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (328, '2022-04-10 17:26:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (329, '2022-04-10 17:33:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (330, '2022-04-10 17:43:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (331, '2022-04-10 19:30:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (332, '2022-04-10 19:32:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (333, '2022-04-10 19:41:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (334, '2022-04-10 20:23:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (335, '2022-04-10 20:24:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (336, '2022-04-10 22:43:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (337, '2022-04-11 01:57:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (338, '2022-04-11 10:28:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (339, '2022-04-11 11:17:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (340, '2022-04-11 11:55:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (341, '2022-04-11 12:26:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (342, '2022-04-11 17:16:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (343, '2022-04-11 19:15:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (344, '2022-04-11 20:35:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (345, '2022-04-11 20:37:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (346, '2022-04-12 08:54:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (347, '2022-04-12 09:34:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (348, '2022-04-12 10:06:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (349, '2022-04-12 10:11:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (350, '2022-04-12 10:11:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (351, '2022-04-12 11:03:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (352, '2022-04-12 11:22:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (353, '2022-04-12 11:33:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (354, '2022-04-12 12:39:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (355, '2022-04-12 15:12:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (356, '2022-04-12 15:53:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (357, '2022-04-12 16:03:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (358, '2022-04-12 16:36:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (359, '2022-04-12 16:36:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (360, '2022-04-12 21:23:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (361, '2022-04-12 22:06:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (362, '2022-04-12 23:25:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (363, '2022-04-13 09:54:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (364, '2022-04-13 10:27:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (365, '2022-04-13 10:30:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (366, '2022-04-13 11:08:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (367, '2022-04-13 11:32:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (368, '2022-04-13 11:54:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (369, '2022-04-13 12:15:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (370, '2022-04-13 12:40:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (371, '2022-04-13 13:10:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (372, '2022-04-13 15:39:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (373, '2022-04-13 17:48:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (374, '2022-04-13 19:30:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (375, '2022-04-13 20:04:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (376, '2022-04-14 01:19:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (377, '2022-04-14 09:33:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (378, '2022-04-14 10:52:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (379, '2022-04-14 11:38:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (380, '2022-04-14 11:58:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (381, '2022-04-14 12:06:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (382, '2022-04-14 12:50:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (383, '2022-04-14 19:30:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (384, '2022-04-15 09:40:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (385, '2022-04-15 10:03:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (386, '2022-04-15 11:37:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (387, '2022-04-15 11:48:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (388, '2022-04-15 11:53:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (389, '2022-04-15 12:42:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (390, '2022-04-15 16:26:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (391, '2022-04-15 19:31:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (392, '2022-04-15 21:08:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (393, '2022-04-15 21:42:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (394, '2022-04-16 10:03:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (395, '2022-04-16 11:18:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (396, '2022-04-16 11:24:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (397, '2022-04-16 11:48:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (398, '2022-04-16 12:31:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (399, '2022-04-16 12:55:11');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text DEFAULT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) NOT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `updated_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (12, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '1_(5).png', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2022-01-17 09:53:59');


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_id` int(11) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `short_code` varchar(30) DEFAULT NULL,
  `is_default` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  CONSTRAINT `charge_categories_ibfk_1` FOREIGN KEY (`charge_type_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (2, 4, 'BIO-CHEMISTRY', '0\r\n', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (3, 4, 'CANCER MARKER', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (4, 4, 'CULTURE', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (5, 4, 'ELECTROLYTES', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (6, 4, 'HAEMATOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (7, 4, 'HEPATOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (8, 4, 'HISTOPATHOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (9, 4, 'HORMONE	', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (10, 4, 'IMMUNOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (11, 4, 'MICROBIOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (12, 4, 'PBF', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (13, 4, 'SEROLOGY/IMMUNOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (14, 4, 'STOOL EXAM', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (15, 4, 'URINE EXAM', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (16, 4, 'VIRAL MARKER', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (18, 2, 'Dr. Fees', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (19, 5, 'ULTRASOUND', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (20, 5, 'X-RAY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (21, 7, 'Ambulance Charge', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (22, 4, 'ENT SURGERY	', '0\r\n', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (23, 4, 'GENERAL SURGERY	', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (24, 4, 'Gynae', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (25, 4, 'MAJOR SURGERY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (26, 4, 'MINOR SURGERY', '0', NULL, '', '2022-01-13 00:06:56');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (27, 1, 'Selim Doctor online fees', 'Virtual Consultancy', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (28, 3, 'Admission', 'IPD', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (29, 3, 'Advance', 'Take advance from patient for IPD ', NULL, '', '2022-03-05 17:57:04');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (30, 1, 'Dr.Fees', 'Visiting fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (31, 2, 'Free Doctor Visit', 'No charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (32, 3, 'Bed', 'Ward and Cabin', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (33, 3, 'Doctor Round', 'Visit', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (34, 3, 'OT Charge', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (35, 11, 'Surgeon Fees', 'Surgeon', NULL, '', '2022-03-01 08:51:32');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (36, 11, 'Anesthesia', 'Anesthesia', NULL, '', '2022-03-01 08:54:29');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (37, 11, 'Assist fees', 'Assist ', NULL, '', '2022-03-01 08:59:27');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (38, 3, 'Service Charge', 'Service', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (39, 3, 'Dressings Charges', 'Dressings', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (40, 3, 'OT Charge2', 'OT ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (41, 3, 'OT Charge3', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (42, 11, 'Operations', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (43, 11, 'Operation2.5k', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (44, 11, 'Operation3k', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (45, 12, 'Sewing Cutting', 'Sewing', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (46, 2, 'Emergency', 'eg', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (49, 2, 'Cannula Change', 'CC', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (50, 2, 'injection push', 'ip', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (51, 2, 'Nebulization Fees', 'NF', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (52, 2, 'Oxygen Fees', 'OF', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (53, 3, 'Cabin Charge', 'CC', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (54, 4, 'Urine Report', 'Full Urine test', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (55, 3, 'Doctor Round-Specialist ', 'dr-sp', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (56, 12, 'others', 'o', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (57, 3, 'Oxigen', 'ox', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (58, 5, 'ECG', 'ecg', NULL, '', NULL);


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (1, 'Appointment', 'yes', 'yes', '2021-09-24 20:10:32');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (2, 'OPD', 'yes', 'yes', '2021-09-24 20:10:02');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (3, 'IPD', 'yes', 'yes', '2021-09-24 20:10:47');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', 'yes', '2021-10-23 03:40:03');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (5, 'Radiology', 'yes', 'yes', '2021-10-23 04:10:21');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (6, 'Blood Bank', 'yes', 'yes', '2021-10-23 04:10:33');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (7, 'Ambulance', 'yes', 'yes', '2021-10-23 04:10:44');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (8, 'Procedures', 'yes', 'yes', '2018-08-17 19:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (9, 'Investigations', 'yes', 'yes', '2018-08-17 19:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (10, 'Supplier', 'yes', 'yes', '2018-08-17 19:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (11, 'Operations', 'yes', 'yes', '2018-08-17 19:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (12, 'Others', 'yes', 'yes', '2018-08-17 19:40:07');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int(11) DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_master_id` (`charge_type_master_id`),
  CONSTRAINT `charge_type_module_ibfk_1` FOREIGN KEY (`charge_type_master_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (2, 1, 'appointment', '2021-10-23 09:52:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (4, 2, 'opd', '2021-10-23 09:52:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (5, 3, 'ipd', '2021-10-23 09:52:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (6, 4, 'pathology', '2021-10-23 09:52:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (7, 5, 'radiology', '2021-10-23 09:52:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (8, 6, 'blood_bank', '2021-10-23 09:52:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (9, 7, 'ambulance', '2021-10-23 09:52:59');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (10, 8, 'opd', '2021-10-23 09:53:03');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (11, 8, 'ipd', '2021-10-23 09:53:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (13, 9, 'pathology', '2021-10-23 09:53:09');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (14, 9, 'radiology', '2021-10-23 09:53:11');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (15, 10, 'opd', '2021-10-23 09:53:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (16, 10, 'ipd', '2021-10-23 09:53:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (17, 11, 'opd', '2021-10-23 09:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (18, 11, 'ipd', '2021-10-23 09:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (19, 12, 'appointment', '2021-10-23 09:53:20');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (20, 12, 'opd', '2021-10-23 09:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (21, 12, 'ipd', '2021-10-23 09:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (24, 12, 'pathology', '2021-10-23 09:53:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (25, 12, 'radiology', '2021-10-23 09:53:27');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (26, 12, 'blood_bank', '2021-10-23 09:53:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (27, 12, 'ambulance', '2021-10-23 09:53:31');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, '0', 0, '2022-01-11 11:12:07');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (2, 'Tk.', 0, '2022-02-18 12:20:13');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_category_id` int(11) DEFAULT NULL,
  `tax_category_id` int(11) DEFAULT NULL,
  `charge_unit_id` int(10) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  CONSTRAINT `charges_ibfk_1` FOREIGN KEY (`charge_category_id`) REFERENCES `charge_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_2` FOREIGN KEY (`tax_category_id`) REFERENCES `tax_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_3` FOREIGN KEY (`charge_unit_id`) REFERENCES `charge_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=785 DEFAULT CHARSET=utf8;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (15, 2, 1, 1, '2 hrs after 75g Glucose', '150.00', NULL, '', '', '2022-01-11 13:08:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (16, 2, 1, 1, '2 hrs after breakfast', '150.00', NULL, '', '', '2022-01-11 13:12:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (17, 5, 1, 1, 'S. Electrolytes', '1000.00', NULL, '', '', '2022-01-11 13:36:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (18, 13, 1, 1, 'ASO Titre', '500.00', NULL, '', '', '2022-01-11 13:36:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (19, 10, 1, 1, 'Anti TB IgG', '1000.00', NULL, '', '', '2022-01-11 13:39:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (20, 10, 1, 1, 'Anti TB IgM', '1000.00', NULL, '', '', '2022-01-11 13:40:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (21, 10, 1, 1, 'Anti-TB IgA', '1000.00', NULL, '', '', '2022-01-11 13:42:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (22, 16, 1, 1, 'Anti DS DNA', '1000.00', NULL, '', '', '2022-01-11 13:42:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (23, 10, 1, 1, 'Antibody HSV IgG', '1000.00', NULL, '', '', '2022-01-11 13:43:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (24, 10, 1, 1, 'Antibody HSV IgM', '1000.00', NULL, '', '', '2022-01-11 13:44:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (25, 10, 1, 1, 'C3', '1000.00', NULL, '', '', '2022-01-11 13:45:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (26, 16, 1, 1, 'Anti HAV IgM', '800.00', NULL, '', '', '2022-01-11 13:47:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (27, 10, 1, 1, 'CA-125', '1500.00', NULL, '', '', '2022-01-11 13:47:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (28, 10, 1, 1, 'CFT for Filaria', '1000.00', NULL, '', '', '2022-01-11 13:49:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (29, 13, 1, 1, 'Anti Dengue IgG', '1200.00', NULL, '', '', '2022-01-11 13:50:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (30, 10, 1, 1, 'CFT for Kala-Azar', '1000.00', NULL, '', '', '2022-01-11 13:52:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (31, 16, 1, 1, 'Anti HBc/IgM', '800.00', NULL, '', '', '2022-01-11 13:53:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (32, 13, 1, 1, 'Anti Dengue IgM', '1200.00', NULL, '', '', '2022-01-11 13:53:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (33, 10, 1, 1, 'Dengue IgM IgG', '500.00', NULL, '', '', '2022-01-11 13:53:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (34, 2, 1, 1, '2 hrs after dinner', '200.00', NULL, '', '', '2022-01-11 13:54:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (35, 10, 1, 1, 'ICT for Malaria', '1000.00', NULL, '', '', '2022-01-11 13:55:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (36, 16, 1, 1, 'Anti HBe (HBe Ab)', '800.00', NULL, '', '', '2022-01-11 13:55:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (37, 2, 1, 1, '2 hrs after lunch', '200.00', NULL, '', '', '2022-01-11 13:56:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (38, 13, 1, 1, 'Anti H-Pylory', '700.00', NULL, '', '', '2022-01-11 13:56:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (39, 10, 1, 1, 'MT (Mantoux Test)', '300.00', NULL, '', '', '2022-01-11 14:01:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (40, 13, 1, 1, 'Anti- HIV (1+2)', '1000.00', NULL, '', '', '2022-01-11 14:04:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (41, 10, 1, 1, 'Rubela for IgM', '2000.00', NULL, '', '', '2022-01-11 14:04:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (42, 16, 1, 1, 'Anti HBs Ab', '800.00', NULL, '', '', '2022-01-11 14:04:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (43, 2, 1, 1, '2 hrs before dinner', '200.00', NULL, '', '', '2022-01-11 14:05:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (44, 13, 1, 1, 'B.T.C.T', '500.00', NULL, '', '', '2022-01-11 14:05:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (45, 10, 1, 1, 'S. IgE', '1200.00', NULL, '', '', '2022-01-11 14:05:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (46, 13, 1, 1, 'Blood group', '150.00', NULL, '', '', '2022-01-11 14:06:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (47, 2, 1, 1, '2 hrs before lunch', '200.00', NULL, '', '', '2022-01-11 14:06:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (48, 16, 1, 1, 'Anti HCV', '600.00', NULL, '', '', '2022-01-11 14:07:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (49, 10, 1, 1, 'TB for ICT', '1000.00', NULL, '', '', '2022-01-11 14:07:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (50, 2, 1, 1, '24 Hours UTV, UTP, CCR', '1000.00', NULL, '', '', '2022-01-11 14:07:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (51, 13, 1, 1, 'C4', '1000.00', NULL, '', '', '2022-01-11 14:07:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (52, 2, 1, 1, 'ACR (Albumin Creatinine Ratio)', '800.00', NULL, '', '', '2022-01-11 14:08:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (53, 15, 1, 1, 'Bile pigment', '100.00', NULL, '', '', '2022-01-11 14:09:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (54, 13, 1, 1, 'CRP', '500.00', NULL, '', '', '2022-01-11 14:09:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (55, 16, 1, 1, 'Anti HEV IgG', '1000.00', NULL, '', '', '2022-01-11 14:10:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (56, 2, 1, 1, 'ACTH', '1000.00', NULL, '', '', '2022-01-11 14:10:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (57, 13, 1, 1, 'Cross Matching', '500.00', NULL, '', '', '2022-01-11 14:10:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (58, 15, 1, 1, 'Bile salt', '100.00', NULL, '', '', '2022-01-11 14:10:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (59, 2, 1, 1, 'AFP', '1000.00', NULL, '', '', '2022-01-11 14:11:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (60, 13, 1, 1, 'Cross Matching (Divice)', '1200.00', NULL, '', '', '2022-01-11 14:11:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (61, 15, 1, 1, 'Pregnancy test', '200.00', NULL, '', '', '2022-01-11 14:11:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (62, 2, 1, 1, 'APTT', '800.00', NULL, '', '', '2022-01-11 14:12:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (63, 16, 1, 1, 'Anti HEV IgM', '1000.00', NULL, '', '', '2022-01-11 14:13:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (64, 13, 1, 1, 'Cross Matching with (Screeing ,VDRL, HBsAg , HIV, HCV)', '1600.00', NULL, '', '', '2022-01-11 14:13:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (65, 15, 1, 1, 'URINE FOR SP. GRAVITY', '100.00', NULL, '', '', '2022-01-11 14:13:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (66, 13, 1, 1, 'Febrile Antigen', '1200.00', NULL, '', '', '2022-01-11 14:14:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (67, 16, 1, 1, 'Beta hCG', '1000.00', NULL, '', '', '2022-01-11 14:14:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (68, 13, 1, 1, 'HBcAg', '1000.00', NULL, '', '', '2022-01-11 14:15:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (69, 15, 1, 1, 'Urine  Albumin', '200.00', NULL, '', '', '2022-01-11 14:15:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (70, 15, 1, 1, 'Urine  R/E', '200.00', NULL, '', '', '2022-01-11 14:16:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (71, 16, 1, 1, 'HBV-DNA (PCR)', '9500.00', NULL, '', '', '2022-01-11 14:16:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (72, 13, 1, 1, 'HBsAg (Screening)', '500.00', NULL, '', '', '2022-01-11 14:16:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (73, 2, 1, 1, 'Ag Ratio', '1000.00', NULL, '', '', '2022-01-11 14:16:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (74, 15, 1, 1, 'Urine Electrolytes', '1000.00', NULL, '', '', '2022-01-11 14:17:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (75, 16, 1, 1, 'HCV-RNA (PCR)', '13500.00', NULL, '', '', '2022-01-11 14:17:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (76, 13, 1, 1, 'HCG/PT', '200.00', NULL, '', '', '2022-01-11 14:17:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (77, 2, 1, 1, 'Anti CCP Antibody', '2000.00', NULL, '', '', '2022-01-11 14:17:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (78, 13, 1, 1, 'HIV', '500.00', NULL, '', '', '2022-01-11 14:17:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (79, 15, 1, 1, 'Urine Ketone Body', '200.00', NULL, '', '', '2022-01-11 14:18:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (80, 2, 1, 1, 'Anti CCP IgG', '1400.00', NULL, '', '', '2022-01-11 14:19:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (81, 13, 1, 1, 'NS-1 Antigen', '500.00', NULL, '', '', '2022-01-11 14:19:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (82, 15, 1, 1, 'Urine Sugar', '100.00', NULL, '', '', '2022-01-11 14:19:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (83, 2, 1, 1, 'BUN', '300.00', NULL, '', '', '2022-01-11 14:20:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (84, 13, 1, 1, 'RA test', '500.00', NULL, '', '', '2022-01-11 14:20:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (85, 15, 1, 1, 'Urine for Benzodiazepines', '1000.00', NULL, '', '', '2022-01-11 14:20:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (86, 2, 1, 1, 'Blood Urea', '500.00', NULL, '', '', '2022-01-11 14:20:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (87, 13, 1, 1, 'RF', '400.00', NULL, '', '', '2022-01-11 14:21:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (88, 15, 1, 1, 'Urine for Cannabinodies', '1000.00', NULL, '', '', '2022-01-11 14:21:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (89, 2, 1, 1, 'CCR', '800.00', NULL, '', '', '2022-01-11 14:21:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (90, 13, 1, 1, 'Rose-Waaler test', '600.00', NULL, '', '', '2022-01-11 14:21:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (91, 15, 1, 1, 'Urine for haemoglobin', '200.00', NULL, '', '', '2022-01-11 14:22:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (92, 14, 1, 1, 'Stool  Reducing Substance', '500.00', NULL, '', '', '2022-01-11 14:22:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (93, 2, 1, 1, 'CK-MB', '700.00', NULL, '', '', '2022-01-11 14:22:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (94, 13, 1, 1, 'Semen Analysis', '700.00', NULL, '', '', '2022-01-11 14:22:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (95, 13, 1, 1, 'TPHA', '500.00', NULL, '', '', '2022-01-11 14:23:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (96, 2, 1, 1, 'CPK', '1200.00', NULL, '', '', '2022-01-11 14:24:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (97, 15, 1, 1, 'Urine for opoids', '1000.00', NULL, '', '', '2022-01-11 14:24:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (98, 13, 1, 1, 'Torch Anti Body', '1200.00', NULL, '', '', '2022-01-11 14:24:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (99, 14, 1, 1, 'Stool OBT', '500.00', NULL, '', '', '2022-01-11 14:24:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (100, 2, 1, 1, 'CSF For Albumin', '300.00', NULL, '', '', '2022-01-11 14:24:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (101, 13, 1, 1, 'VDRL', '500.00', NULL, '', '', '2022-01-11 14:25:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (102, 14, 1, 1, 'Stool R/E', '500.00', NULL, '', '', '2022-01-11 14:25:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (103, 2, 1, 1, 'CSF For HDL', '500.00', NULL, '', '', '2022-01-11 14:25:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (104, 12, 1, 1, 'PBF (Peripheral blood film)', '200.00', NULL, '', '', '2022-01-11 14:25:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (105, 2, 1, 1, 'CSF For Protein', '300.00', NULL, '', '', '2022-01-11 14:26:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (106, 13, 1, 1, 'VDRL (Q+Q)', '400.00', NULL, '', '', '2022-01-11 14:26:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (107, 13, 1, 1, 'Widal test', '500.00', NULL, '', '', '2022-01-11 14:27:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (108, 3, 1, 1, 'CA-15.3', '1000.00', NULL, '', '', '2022-01-11 14:28:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (109, 2, 1, 1, 'CSF For Sugar', '120.00', NULL, '', '', '2022-01-11 14:29:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (110, 4, 1, 1, 'Blood C/S', '2500.00', NULL, '', '', '2022-01-11 14:29:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (111, 3, 1, 1, 'CA-19.9', '1500.00', NULL, '', '', '2022-01-11 14:29:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (112, 2, 1, 1, 'FBS', '150.00', NULL, '', '', '2022-01-11 14:30:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (113, 11, 1, 1, 'Clot Culture (salmonella inf.)', '350.00', NULL, '', '', '2022-01-11 14:30:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (114, 4, 1, 1, 'CSF R/E /S', '600.00', NULL, '', '', '2022-01-11 14:31:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (115, 2, 1, 1, 'fasting Lipid Profile', '1000.00', NULL, '', '', '2022-01-11 14:31:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (116, 3, 1, 1, 'CEA', '1200.00', NULL, '', '', '2022-01-11 14:31:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (117, 2, 1, 1, 'Ferritine', '900.00', NULL, '', '', '2022-01-11 14:31:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (118, 11, 1, 1, 'Endocervical swab for gram stain', '200.00', NULL, '', '', '2022-01-11 14:31:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (119, 4, 1, 1, 'Conjunctival swab C/S', '300.00', NULL, '', '', '2022-01-11 14:32:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (120, 2, 1, 1, 'GTT', '360.00', NULL, '', '', '2022-01-11 14:32:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (121, 2, 1, 1, 'Gamma GT', '500.00', NULL, '', '', '2022-01-11 22:35:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (122, 2, 1, 1, 'Globulin', '1000.00', NULL, '', '', '2022-01-11 23:44:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (123, 2, 1, 1, 'H. Pylori', '800.00', NULL, '', '', '2022-01-11 23:45:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (124, 11, 1, 1, 'FNAC', '1500.00', NULL, '', '', '2022-01-11 23:46:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (125, 2, 1, 1, 'HDL', '500.00', NULL, '', '', '2022-01-11 23:47:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (126, 11, 1, 1, 'FNAC Collection', '500.00', NULL, '', '', '2022-01-11 23:48:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (127, 2, 1, 1, 'HbA1C', '1000.00', NULL, '', '', '2022-01-11 23:49:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (128, 11, 1, 1, 'Gastric Level aspirate (3 Sample)', '400.00', NULL, '', '', '2022-01-11 23:50:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (129, 3, 1, 1, 'Cytology', '500.00', NULL, '', '', '2022-01-11 23:50:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (130, 2, 1, 1, 'Iron', '600.00', NULL, '', '', '2022-01-11 23:50:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (131, 11, 1, 1, 'Gramstain', '200.00', NULL, '', '', '2022-01-11 23:50:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (132, 11, 1, 1, 'HVS for Gram Stain', '200.00', NULL, '', '', '2022-01-11 23:51:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (133, 11, 1, 1, 'HVS for R/E', '200.00', NULL, '', '', '2022-01-11 23:52:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (134, 11, 1, 1, 'MT (Mantoux Test)', '500.00', NULL, '', '', '2022-01-11 23:53:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (135, 3, 1, 1, 'PSA', '700.00', NULL, '', '', '2022-01-11 23:56:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (136, 11, 1, 1, 'Malignant Cell', '800.00', NULL, '', '', '2022-01-11 23:57:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (137, 11, 1, 1, 'Prostatic smear R/E', '200.00', NULL, '', '', '2022-01-11 23:57:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (138, 2, 1, 1, 'L.F.T (Liver Function Test with)', '1500.00', NULL, '', '', '2022-01-11 23:57:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (139, 3, 1, 1, 'PSA ( Elisa)', '1200.00', NULL, '', '', '2022-01-11 23:58:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (140, 11, 1, 1, 'Prostatic smear gram stain', '200.00', NULL, '', '', '2022-01-11 23:58:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (141, 3, 1, 1, 'Pap smear', '900.00', NULL, '', '', '2022-01-11 23:59:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (142, 11, 1, 1, 'Skin Scraping   R/E', '200.00', NULL, '', '', '2022-01-11 23:59:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (143, 11, 1, 1, 'Skin Scraping for Fungus', '800.00', NULL, '', '', '2022-01-11 23:59:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (144, 11, 1, 1, 'Sputum AFB', '200.00', NULL, '', '', '2022-01-12 00:00:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (145, 7, 1, 1, 'Anti HBs', '800.00', NULL, '', '', '2022-01-12 00:00:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (146, 11, 1, 1, 'Sputum AFB 2 samples', '400.00', NULL, '', '', '2022-01-12 00:01:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (147, 11, 1, 1, 'Sputum AFB 3 samples', '600.00', NULL, '', '', '2022-01-12 00:01:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (148, 7, 1, 1, 'Anti HcV', '600.00', NULL, '', '', '2022-01-12 00:02:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (149, 11, 1, 1, 'Sputum Gene Xpert', '4000.00', NULL, '', '', '2022-01-12 00:02:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (150, 11, 1, 1, 'Sputum for gramstain', '300.00', NULL, '', '', '2022-01-12 00:03:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (151, 11, 1, 1, 'T/A for ABF Staining', '200.00', NULL, '', '', '2022-01-12 00:03:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (152, 7, 1, 1, 'HBe - ab', '1100.00', NULL, '', '', '2022-01-12 00:04:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (153, 11, 1, 1, 'Urethra smear R/E', '200.00', NULL, '', '', '2022-01-12 00:04:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (154, 11, 1, 1, 'Urothral for Gram  Stain', '200.00', NULL, '', '', '2022-01-12 00:04:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (155, 7, 1, 1, 'HBe Ag', '1100.00', NULL, '', '', '2022-01-12 00:05:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (156, 2, 1, 1, '\"SGPT,SGOT,S.Bilirubin,HBsAg) LDL\"', '500.00', NULL, '', '', '2022-01-12 00:07:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (157, 7, 1, 1, 'HBsAg (Confirmatory)', '500.00', NULL, '', '', '2022-01-12 00:07:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (158, 7, 1, 1, 'HBsAg (ELISA)', '1200.00', NULL, '', '', '2022-01-12 00:08:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (159, 4, 1, 1, 'Ear swab C/S', '800.00', NULL, '', '', '2022-01-12 00:08:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (160, 2, 1, 1, 'LDL Cholesterol', '300.00', NULL, '', '', '2022-01-12 00:10:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (161, 4, 1, 1, 'Endocervical swab C/S', '800.00', NULL, '', '', '2022-01-12 00:11:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (162, 2, 1, 1, 'Lipid Profile', '1000.00', NULL, '', '', '2022-01-12 00:11:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (163, 2, 1, 1, 'OGTT', '600.00', NULL, '', '', '2022-01-12 00:12:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (164, 6, 1, 1, 'BT', '250.00', NULL, '', '', '2022-01-12 00:12:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (165, 8, 1, 1, 'Histopathology', '1100.00', NULL, '', '', '2022-01-12 00:13:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (166, 6, 1, 1, 'BT.CT', '500.00', NULL, '', '', '2022-01-12 00:13:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (167, 4, 1, 1, 'Eye swab C/S', '800.00', NULL, '', '', '2022-01-12 00:13:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (168, 2, 1, 1, 'Pleural Fluid', '400.00', NULL, '', '', '2022-01-12 00:14:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (169, 6, 1, 1, 'CBC', '500.00', NULL, '', '', '2022-01-12 00:14:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (170, 2, 1, 1, 'Prothrombin time', '1200.00', NULL, '', '', '2022-01-12 00:15:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (171, 4, 1, 1, 'Finger Print for C/S', '600.00', NULL, '', '', '2022-01-12 00:15:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (172, 6, 1, 1, 'CEC', '300.00', NULL, '', '', '2022-01-12 00:15:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (173, 4, 1, 1, 'HVS C/S', '800.00', NULL, '', '', '2022-01-12 00:16:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (174, 2, 1, 1, 'RBS', '150.00', NULL, '', '', '2022-01-12 00:16:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (175, 6, 1, 1, 'CT', '250.00', NULL, '', '', '2022-01-12 00:16:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (176, 4, 1, 1, 'Nasal swab C/S', '800.00', NULL, '', '', '2022-01-12 00:17:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (177, 2, 1, 1, 'RBS (Random Blood Sugar)', '200.00', NULL, '', '', '2022-01-12 00:17:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (178, 9, 1, 1, 'ANA', '1200.00', NULL, '', '', '2022-01-12 00:18:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (179, 6, 1, 1, 'Coombs test', '400.00', NULL, '', '', '2022-01-12 00:18:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (180, 4, 1, 1, 'PAPS C/S', '800.00', NULL, '', '', '2022-01-12 00:19:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (181, 2, 1, 1, 'S. Albumin', '500.00', NULL, '', '', '2022-01-12 00:19:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (182, 6, 1, 1, 'DC', '150.00', NULL, '', '', '2022-01-12 00:20:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (183, 4, 1, 1, 'Prostatic smear C/S', '600.00', NULL, '', '', '2022-01-12 00:20:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (184, 2, 1, 1, 'S. Alkaline Phosphatase', '500.00', NULL, '', '', '2022-01-12 00:20:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (185, 4, 1, 1, 'Pus C/S', '800.00', NULL, '', '', '2022-01-12 00:21:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (186, 2, 1, 1, 'S. Amonia', '900.00', NULL, '', '', '2022-01-12 00:21:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (187, 6, 1, 1, 'ESR', '200.00', NULL, '', '', '2022-01-12 00:21:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (188, 2, 1, 1, 'S. Amylase', '800.00', NULL, '', '', '2022-01-12 00:22:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (189, 4, 1, 1, 'Skin Scraping for C/S', '600.00', NULL, '', '', '2022-01-12 00:22:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (190, 9, 1, 1, 'Anti Cardiolipin IgG', '1500.00', NULL, '', '', '2022-01-12 00:22:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (191, 6, 1, 1, 'ESR tube', '45.00', NULL, '', '', '2022-01-12 00:23:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (192, 2, 1, 1, 'S. Bilirubin (Direct.InDirect)', '1200.00', NULL, '', '', '2022-01-12 00:23:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (193, 4, 1, 1, 'Sputum C/S', '600.00', NULL, '', '', '2022-01-12 00:24:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (194, 9, 1, 1, 'Anti Cardiolipin IgM', '1500.00', NULL, '', '', '2022-01-12 00:24:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (195, 2, 1, 1, 'S. Bilirubin Direct', '600.00', NULL, '', '', '2022-01-12 00:24:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (196, 4, 1, 1, 'Stool C/S', '800.00', NULL, '', '', '2022-01-12 00:24:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (197, 6, 1, 1, 'Electrophroses', '1400.00', NULL, '', '', '2022-01-12 00:25:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (198, 9, 1, 1, 'Anti DNA', '1000.00', NULL, '', '', '2022-01-12 00:25:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (199, 2, 1, 1, 'S. Bilirubin Indirect', '600.00', NULL, '', '', '2022-01-12 00:25:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (200, 4, 1, 1, 'Swab C/S with Gram Stain', '300.00', NULL, '', '', '2022-01-12 00:25:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (201, 6, 1, 1, 'Hb', '200.00', NULL, '', '', '2022-01-12 00:26:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (202, 2, 1, 1, 'S. Billirubin', '500.00', NULL, '', '', '2022-01-12 00:26:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (203, 2, 1, 1, 'S. Calcium', '600.00', NULL, '', '', '2022-01-12 00:27:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (204, 4, 1, 1, 'T/A For C/S', '600.00', NULL, '', '', '2022-01-12 00:27:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (205, 9, 1, 1, 'Anti MPO(P-ANCA)', '1500.00', NULL, '', '', '2022-01-12 00:27:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (206, 2, 1, 1, 'S. Cholesterol', '500.00', NULL, '', '', '2022-01-12 00:28:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (207, 9, 1, 1, 'Anti PR-3 (C-ANCA)', '1500.00', NULL, '', '', '2022-01-12 00:28:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (208, 6, 1, 1, 'ICT for Kala-Azar', '600.00', NULL, '', '', '2022-01-12 00:28:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (209, 2, 1, 1, 'S. Creatinine', '500.00', NULL, '', '', '2022-01-12 00:29:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (210, 4, 1, 1, 'Throat Swab C/S', '800.00', NULL, '', '', '2022-01-12 00:29:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (211, 9, 1, 1, 'Anti Phospholipid Screen', '1200.00', NULL, '', '', '2022-01-12 00:29:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (212, 6, 1, 1, 'Kala Jor', '500.00', NULL, '', '', '2022-01-12 00:29:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (213, 2, 1, 1, 'S. Lipase', '1200.00', NULL, '', '', '2022-01-12 00:29:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (214, 4, 1, 1, 'Umbilical swab C/S', '800.00', NULL, '', '', '2022-01-12 00:29:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (215, 9, 1, 1, 'Anti thyroid Anti body', '1000.00', NULL, '', '', '2022-01-12 00:30:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (216, 2, 1, 1, 'S. Lipid Profile', '1000.00', NULL, '', '', '2022-01-12 00:30:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (217, 6, 1, 1, 'MP (ICT)', '500.00', NULL, '', '', '2022-01-12 00:30:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (218, 4, 1, 1, 'Urethra smear C/S', '800.00', NULL, '', '', '2022-01-12 00:31:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (219, 2, 1, 1, 'S. Magnessium', '600.00', NULL, '', '', '2022-01-12 00:31:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (220, 9, 1, 1, 'B-hcG', '1500.00', NULL, '', '', '2022-01-12 00:31:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (221, 6, 1, 1, 'MP (Slide)', '500.00', NULL, '', '', '2022-01-12 00:31:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (222, 4, 1, 1, 'Urine C/S', '1500.00', NULL, '', '', '2022-01-12 00:32:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (223, 2, 1, 1, 'S. Phosphate', '400.00', NULL, '', '', '2022-01-12 00:32:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (224, 9, 1, 1, 'Cortisol', '1000.00', NULL, '', '', '2022-01-12 00:32:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (225, 6, 1, 1, 'PBF', '500.00', NULL, '', '', '2022-01-12 00:33:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (226, 4, 1, 1, 'Wound swab C/S', '600.00', NULL, '', '', '2022-01-12 00:33:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (227, 2, 1, 1, 'S. Total Acid Phosphate', '500.00', NULL, '', '', '2022-01-12 00:33:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (228, 9, 1, 1, 'D-Dimer', '1200.00', NULL, '', '', '2022-01-12 00:33:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (229, 6, 1, 1, 'PCV/HCT', '500.00', NULL, '', '', '2022-01-12 00:34:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (230, 2, 1, 1, 'S. Total Protein', '300.00', NULL, '', '', '2022-01-12 00:34:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (231, 9, 1, 1, 'Estrodiol', '1000.00', NULL, '', '', '2022-01-12 00:34:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (232, 6, 1, 1, 'Platelet count', '500.00', NULL, '', '', '2022-01-12 00:35:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (233, 2, 1, 1, 'S. Triglycerides', '500.00', NULL, '', '', '2022-01-12 00:35:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (234, 9, 1, 1, 'Free T3', '700.00', NULL, '', '', '2022-01-12 00:36:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (235, 6, 1, 1, 'RBC Parameters', '100.00', NULL, '', '', '2022-01-12 00:36:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (236, 2, 1, 1, 'S. Urea', '500.00', NULL, '', '', '2022-01-12 00:36:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (237, 9, 1, 1, 'Free T4', '700.00', NULL, '', '', '2022-01-12 00:37:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (238, 2, 1, 1, 'S. Uric Acid', '500.00', NULL, '', '', '2022-01-12 00:37:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (239, 6, 1, 1, 'Reticulocyte count', '150.00', NULL, '', '', '2022-01-12 00:37:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (240, 9, 1, 1, 'Growth Hormone', '1800.00', NULL, '', '', '2022-01-12 00:38:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (241, 2, 1, 1, 'S. Urine', '100.00', NULL, '', '', '2022-01-12 00:38:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (242, 6, 1, 1, 'Rh- Antibody', '1200.00', NULL, '', '', '2022-01-12 00:39:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (243, 9, 1, 1, 'HDV Ab', '1000.00', NULL, '', '', '2022-01-12 00:39:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (244, 2, 1, 1, 'S.Vitamin-D3 Level', '2500.00', NULL, '', '', '2022-01-12 00:39:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (245, 2, 1, 1, 'SGOT (AST)', '500.00', NULL, '', '', '2022-01-12 00:40:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (246, 9, 1, 1, 'Iron Profile', '3000.00', NULL, '', '', '2022-01-12 00:40:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (247, 2, 1, 1, 'SGPT (ALT)', '500.00', NULL, '', '', '2022-01-12 00:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (248, 6, 1, 1, 'Sputum Eosinophil', '200.00', NULL, '', '', '2022-01-12 00:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (249, 9, 1, 1, 'Myoglobin', '2000.00', NULL, '', '', '2022-01-12 00:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (250, 2, 1, 1, 'TCO2', '250.00', NULL, '', '', '2022-01-12 00:42:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (251, 9, 1, 1, 'Oestrogen', '800.00', NULL, '', '', '2022-01-12 00:42:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (252, 6, 1, 1, 'Syringe', '5.00', NULL, '', '', '2022-01-12 00:42:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (253, 2, 1, 1, 'TIBC', '900.00', NULL, '', '', '2022-01-12 00:42:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (255, 6, 1, 1, 'TC', '150.00', NULL, '', '', '2022-01-12 00:43:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (256, 2, 1, 1, 'TROPONIN-I', '600.00', NULL, '', '', '2022-01-12 00:43:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (257, 2, 1, 1, 'Total Cholesterol', '400.00', NULL, '', '', '2022-01-12 00:44:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (258, 6, 1, 1, 'TC. DC', '300.00', NULL, '', '', '2022-01-12 00:44:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (259, 2, 1, 1, 'Total Protein', '500.00', NULL, '', '', '2022-01-12 00:45:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (260, 2, 1, 1, 'UTV (Urine Total Volume)', '100.00', NULL, '', '', '2022-01-12 00:45:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (261, 6, 1, 1, 'Urine M/E', '600.00', NULL, '', '', '2022-01-12 00:46:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (262, 9, 1, 1, 'Para Thyroid Hormone (PTH)', '1000.00', NULL, '', '', '2022-01-12 00:46:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (264, 9, 1, 1, 'Progesterone', '1200.00', NULL, '', '', '2022-01-12 00:47:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (265, 2, 1, 1, 'Vitamin-D', '2500.00', NULL, '', '', '2022-01-12 00:48:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (266, 9, 1, 1, 'S. Basal Cortisol', '1000.00', NULL, '', '', '2022-01-12 00:48:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (267, 9, 1, 1, 'S. FSH', '1200.00', NULL, '', '', '2022-01-12 00:49:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (268, 9, 1, 1, 'S. Ferritine', '1200.00', NULL, '', '', '2022-01-12 00:50:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (269, 9, 1, 1, 'S. LH', '1200.00', NULL, '', '', '2022-01-12 00:51:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (270, 9, 1, 1, 'S. Oestrogen', '1500.00', NULL, '', '', '2022-01-12 00:52:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (271, 9, 1, 1, 'S. Prolactin', '1500.00', NULL, '', '', '2022-01-12 00:53:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (272, 9, 1, 1, 'S. Testosteron', '1200.00', NULL, '', '', '2022-01-12 00:54:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (273, 9, 1, 1, 'T3', '700.00', NULL, '', '', '2022-01-12 00:55:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (274, 9, 1, 1, 'T3, T4, TSH', '2200.00', NULL, '', '', '2022-01-12 00:56:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (275, 9, 1, 1, 'T4', '700.00', NULL, '', '', '2022-01-12 00:57:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (276, 9, 1, 1, 'TH', '800.00', NULL, '', '', '2022-01-12 00:57:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (278, 9, 1, 1, 'TSH', '800.00', NULL, '', '', '2022-01-12 01:00:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (279, 9, 1, 1, 'Testosterone', '1100.00', NULL, '', '', '2022-01-12 01:01:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (280, 9, 1, 1, 'Thyroglobulin', '1500.00', NULL, '', '', '2022-01-12 01:02:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (281, 9, 1, 1, 'Trepnonema Pallidum [TP]', '1000.00', NULL, '', '', '2022-01-12 01:02:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (282, 19, 1, 1, 'TestCharge', '1.00', NULL, '', '', '2022-01-12 15:57:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (283, 19, 1, 1, 'USG of Lower abdomen Early Pregnency', '500.00', NULL, '', '', '2022-01-12 16:27:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (284, 20, 1, 1, 'X-Ray CXR L/V', '600.00', NULL, '', '', '2022-01-12 16:33:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (285, 20, 1, 1, 'X-Ray CXR Lt L/V', '600.00', NULL, '', '', '2022-01-12 16:35:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (286, 20, 1, 1, 'X-Ray Lt wrist joint B/V', '600.00', NULL, '', '', '2022-01-12 16:35:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (288, 20, 1, 1, 'X-Ray CXR O/V (Ribs) ', '600.00', NULL, '', '', '2022-01-12 16:36:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (289, 20, 1, 1, 'X-Ray CXR P/A', '600.00', NULL, '', '', '2022-01-12 16:38:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (290, 19, 1, 1, 'USG of Chest', '500.00', NULL, '', '', '2022-01-12 16:39:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (291, 20, 1, 1, 'X-Ray CXR Rt L/V', '600.00', NULL, '', '', '2022-01-12 16:39:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (292, 20, 1, 1, 'X-Ray Lumber Spine Lateral View ', '300.00', NULL, '', '', '2022-01-12 16:39:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (293, 20, 1, 1, 'X-Ray Cervical Spine A/P view ', '600.00', NULL, '', '', '2022-01-12 16:40:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (294, 20, 1, 1, 'X-Ray Lumber SpineB/V (Digital) ', '350.00', NULL, '', '', '2022-01-12 16:41:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (295, 19, 1, 1, 'USG of HBS', '400.00', NULL, '', '', '2022-01-12 16:41:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (296, 20, 1, 1, 'X-Ray Cervical Spine B/V', '900.00', NULL, '', '', '2022-01-12 16:41:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (297, 19, 1, 1, 'USG of Head', '900.00', NULL, '', '', '2022-01-12 16:45:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (298, 20, 1, 1, 'X-Ray Cervical Spine B/V Digital ', '600.00', NULL, '', '', '2022-01-12 16:45:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (299, 20, 1, 1, 'X-Ray Mandible B/V', '800.00', NULL, '', '', '2022-01-12 16:46:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (300, 19, 1, 1, 'USG of Inguinl Region', '1300.00', NULL, '', '', '2022-01-12 16:46:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (301, 20, 1, 1, 'X-Ray Cervical Spine Lateral view', '300.00', NULL, '', '', '2022-01-12 16:47:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (302, 19, 1, 1, 'USG of KUB Female', '600.00', NULL, '', '', '2022-01-12 16:47:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (303, 20, 1, 1, 'X-Ray Mandible L/V', '400.00', NULL, '', '', '2022-01-12 16:48:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (304, 20, 1, 1, 'X-Ray Cervical spine flexion and extension', '500.00', NULL, '', '', '2022-01-12 16:48:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (305, 19, 1, 1, 'USG of KUB Male', '600.00', NULL, '', '', '2022-01-12 16:48:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (306, 20, 1, 1, 'X-Ray Mandible Lateral View ', '300.00', NULL, '', '', '2022-01-12 16:49:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (307, 19, 1, 1, 'USG of Kub with lower abdomen Female', '900.00', NULL, '', '', '2022-01-12 16:49:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (308, 20, 1, 1, 'X-Ray Chest A/P Lateral View', '700.00', NULL, '', '', '2022-01-12 16:49:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (309, 19, 1, 1, 'USG of Kub with lower abdomen Male', '900.00', NULL, '', '', '2022-01-12 16:50:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (310, 20, 1, 1, 'X-Ray Chest A/P Supine ', '400.00', NULL, '', '', '2022-01-12 16:50:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (311, 20, 1, 1, 'X-Ray Mandible P/A view', '400.00', NULL, '', '', '2022-01-12 16:50:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (312, 19, 1, 1, 'USG of Lower abdomen Female', '600.00', NULL, '', '', '2022-01-12 16:51:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (313, 20, 1, 1, 'X-Ray Chest A/P for Ribs ', '400.00', NULL, '', '', '2022-01-12 16:51:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (314, 19, 1, 1, 'USG of Lower abdomen Female (2D)', '500.00', NULL, '', '', '2022-01-12 16:51:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (315, 20, 1, 1, 'X-Ray Mastoid townes view ', '600.00', NULL, '', '', '2022-01-12 16:52:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (316, 20, 1, 1, 'X-Ray Chest A/P view', '600.00', NULL, '', '', '2022-01-12 16:52:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (317, 19, 1, 1, 'USG of Lower abdomen Male', '600.00', NULL, '', '', '2022-01-12 16:52:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (318, 20, 1, 1, 'X-Ray Chest Lt Posterior obique (LPO)', '400.00', NULL, '', '', '2022-01-12 16:53:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (319, 19, 1, 1, 'USG of Molar Pregnancy', '2500.00', NULL, '', '', '2022-01-12 16:53:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (320, 19, 1, 1, 'USG of P/P', '500.00', NULL, '', '', '2022-01-12 16:55:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (321, 20, 1, 1, 'X-Ray Chest P/A Lateral Decubitus View ', '700.00', NULL, '', '', '2022-01-12 16:55:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (322, 20, 1, 1, 'X-Ray Mastoyed townes', '400.00', NULL, '', '', '2022-01-12 16:55:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (323, 20, 1, 1, 'X-Ray Chest P/A View', '600.00', NULL, '', '', '2022-01-12 16:56:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (324, 19, 1, 1, 'USG of Pregnancy Profile (4D)', '800.00', NULL, '', '', '2022-01-12 16:56:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (325, 20, 1, 1, 'X-Ray D/S A/P ', '400.00', NULL, '', '', '2022-01-12 16:57:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (326, 20, 1, 1, 'X-Ray D/S B/V ', '800.00', NULL, '', '', '2022-01-12 16:58:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (327, 20, 1, 1, 'X-Ray Maxilla Lateral oblique view ', '300.00', NULL, '', '', '2022-01-12 16:58:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (328, 19, 1, 1, 'USG of Pregnancy Profile With Anomaly Scan', '3000.00', NULL, '', '', '2022-01-12 16:58:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (329, 20, 1, 1, 'X-Ray D/S L/V', '400.00', NULL, '', '', '2022-01-12 17:00:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (330, 19, 1, 1, 'USG of Pregnency Profile', '600.00', NULL, '', '', '2022-01-12 17:00:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (331, 20, 1, 1, 'X-Ray Nasal bone lateral view', '600.00', NULL, '', '', '2022-01-12 17:00:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (332, 20, 1, 1, 'X-Ray Dental one film ', '120.00', NULL, '', '', '2022-01-12 17:01:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (333, 19, 1, 1, 'USG of Reproductive organ Female', '900.00', NULL, '', '', '2022-01-12 17:01:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (334, 20, 1, 1, 'X-Ray Nasopharynx Lateral view ', '600.00', NULL, '', '', '2022-01-12 17:01:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (335, 20, 1, 1, 'X-Ray Dental three film ', '360.00', NULL, '', '', '2022-01-12 17:03:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (336, 20, 1, 1, 'X-Ray Neck A/P', '400.00', NULL, '', '', '2022-01-12 17:03:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (337, 20, 1, 1, 'X-Ray Dental two film ', '240.00', NULL, '', '', '2022-01-12 17:03:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (338, 20, 1, 1, 'X-Ray Dorsal Spine B/V', '800.00', NULL, '', '', '2022-01-12 17:04:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (339, 20, 1, 1, 'X-Ray Dorsal Spine A/P view', '300.00', NULL, '', '', '2022-01-12 17:05:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (340, 20, 1, 1, 'X-Ray Sternum Lateral view', '300.00', NULL, '', '', '2022-01-12 17:06:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (341, 20, 1, 1, 'X-Ray Dorsal Spine Lateral view ', '300.00', NULL, '', '', '2022-01-12 17:06:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (342, 20, 1, 1, 'X-Ray Sternum oblique view', '400.00', NULL, '', '', '2022-01-12 17:07:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (343, 20, 1, 1, 'X-Ray Dorso Lumber Spine', '600.00', NULL, '', '', '2022-01-12 17:07:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (344, 19, 1, 1, 'USG of Scrotum', '900.00', NULL, '', '', '2022-01-12 17:07:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (345, 20, 1, 1, 'X-Ray Neck A/P', '300.00', NULL, '', '', '2022-01-12 17:07:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (346, 20, 1, 1, 'X-Ray Styloid Proces B/V', '400.00', NULL, '', '', '2022-01-12 17:08:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (347, 20, 1, 1, 'X-Ray Dorso-Lumber A/P view ', '300.00', NULL, '', '', '2022-01-12 17:08:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (348, 19, 1, 1, 'USG of Testis', '900.00', NULL, '', '', '2022-01-12 17:08:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (349, 20, 1, 1, 'X-Ray Throat Lateral View', '400.00', NULL, '', '', '2022-01-12 17:08:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (350, 20, 1, 1, 'X-Ray Neck B/V', '800.00', NULL, '', '', '2022-01-12 17:09:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (351, 19, 1, 1, 'USG of Thyroid', '1300.00', NULL, '', '', '2022-01-12 17:09:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (352, 20, 1, 1, 'X-Ray Dorso-Lumber B/V', '500.00', NULL, '', '', '2022-01-12 17:09:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (353, 20, 1, 1, 'X-Ray Throat P/A View', '400.00', NULL, '', '', '2022-01-12 17:09:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (354, 19, 1, 1, 'USG of Transvaginal sonography', '900.00', NULL, '', '', '2022-01-12 17:10:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (355, 20, 1, 1, 'X-Ray Neck L/V', '400.00', NULL, '', '', '2022-01-12 17:10:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (356, 20, 1, 1, 'X-Ray Throsis Spine B/V', '500.00', NULL, '', '', '2022-01-12 17:10:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (357, 20, 1, 1, 'X-Ray Dorso-Lumber Lateral view ', '300.00', NULL, '', '', '2022-01-12 17:10:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (358, 19, 1, 1, 'USG of Transvaginal sonography', '900.00', NULL, '', '', '2022-01-12 17:10:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (359, 20, 1, 1, 'X-ray L/S Spine B/V', '650.00', NULL, '', '', '2022-01-12 17:11:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (360, 19, 1, 1, 'USG of Upper abdomen Female', '600.00', NULL, '', '', '2022-01-12 17:11:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (361, 20, 1, 1, 'X-Ray Elbow with fore arm B/V ', '700.00', NULL, '', '', '2022-01-12 17:11:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (362, 20, 1, 1, 'X-Ray Neck Soft tissue L/V ', '400.00', NULL, '', '', '2022-01-12 17:11:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (363, 20, 1, 1, 'X-ray T.m Joint B/V', '600.00', NULL, '', '', '2022-01-12 17:12:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (364, 19, 1, 1, 'USG of Upper abdomen Male', '600.00', NULL, '', '', '2022-01-12 17:12:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (365, 20, 1, 1, 'X-Ray Face B/V', '400.00', NULL, '', '', '2022-01-12 17:12:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (366, 20, 1, 1, 'X-Ray OPG', '600.00', NULL, '', '', '2022-01-12 17:13:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (367, 19, 1, 1, 'USG of W/A with pregnancy', '700.00', NULL, '', '', '2022-01-12 17:13:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (368, 20, 1, 1, 'X-Ray Face Lateral View ', '400.00', NULL, '', '', '2022-01-12 17:13:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (369, 19, 1, 1, 'USG of Whole abdomen Female', '700.00', NULL, '', '', '2022-01-12 17:14:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (370, 20, 1, 1, 'X-Ray Face P/A View', '300.00', NULL, '', '', '2022-01-12 17:14:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (371, 19, 1, 1, 'USG of Whole abdomen Male', '700.00', NULL, '', '', '2022-01-12 17:15:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (372, 20, 1, 1, 'X-Ray Fore Arm B/V ', '600.00', NULL, '', '', '2022-01-12 17:15:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (373, 19, 1, 1, 'USG of Breast', '1300.00', NULL, '', '', '2022-01-12 17:16:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (374, 20, 1, 1, 'X-Ray Rt Knee A/P Standing View', '400.00', NULL, '', '', '2022-01-12 17:16:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (375, 20, 1, 1, 'X-Ray Hip joint B/V ', '800.00', NULL, '', '', '2022-01-12 17:16:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (376, 20, 1, 1, 'X-Ray Rt Knee joint B/V', '600.00', NULL, '', '', '2022-01-12 17:16:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (377, 20, 1, 1, 'X-Ray IVU', '1500.00', NULL, '', '', '2022-01-12 17:17:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (378, 20, 1, 1, 'X-Ray Rt Knee jt B/V', '600.00', NULL, '', '', '2022-01-12 17:17:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (379, 20, 1, 1, 'X-Ray IVU Let film one ', '300.00', NULL, '', '', '2022-01-12 17:17:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (380, 20, 1, 1, 'X-Ray Rt Leg B/V', '700.00', NULL, '', '', '2022-01-12 17:18:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (381, 20, 1, 1, 'X-Ray IVU Let film two ', '500.00', NULL, '', '', '2022-01-12 17:18:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (382, 19, 1, 1, 'USG of inguino - scrotal', '1300.00', NULL, '', '', '2022-01-12 17:18:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (383, 20, 1, 1, 'X-Ray Rt Leg B/V', '400.00', NULL, '', '', '2022-01-12 17:19:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (384, 20, 1, 1, 'X-Ray IVU/IVP', '1200.00', NULL, '', '', '2022-01-12 17:19:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (385, 19, 1, 1, 'utla', '600.00', NULL, '', '', '2022-01-12 17:19:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (386, 20, 1, 1, 'X-Ray Rt Leg finger B/V', '400.00', NULL, '', '', '2022-01-12 17:20:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (387, 20, 1, 1, 'X-Ray KUB', '600.00', NULL, '', '', '2022-01-12 17:20:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (388, 20, 1, 1, 'X-Ray KUB A/P view ', '500.00', NULL, '', '', '2022-01-12 17:21:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (389, 20, 1, 1, 'X-Ray Abdomen AP', '500.00', NULL, '', '', '2022-01-12 17:21:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (390, 20, 1, 1, 'X-Ray Rt Mastoid Townes View', '700.00', NULL, '', '', '2022-01-12 17:22:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (391, 20, 1, 1, 'X-Ray KUB B/V', '800.00', NULL, '', '', '2022-01-12 17:22:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (392, 20, 1, 1, 'X-Ray Abdomen EP', '550.00', NULL, '', '', '2022-01-12 17:22:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (393, 20, 1, 1, 'X-Ray Rt Middle finger B/V', '400.00', NULL, '', '', '2022-01-12 17:22:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (394, 20, 1, 1, 'X-Ray KUB L/V', '500.00', NULL, '', '', '2022-01-12 17:23:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (395, 20, 1, 1, 'X-Ray Rt Neck of Femur A/P View', '700.00', NULL, '', '', '2022-01-12 17:23:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (396, 20, 1, 1, 'X-Ray Atlas bone A/P View', '400.00', NULL, '', '', '2022-01-12 17:23:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (397, 20, 1, 1, 'X-Ray KUB errect ', '500.00', NULL, '', '', '2022-01-12 17:24:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (398, 20, 1, 1, 'X-Ray PNS B/V', '800.00', NULL, '', '', '2022-01-12 17:24:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (399, 20, 1, 1, 'X-Ray Rt Neck of Femur B/V', '700.00', NULL, '', '', '2022-01-12 17:24:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (400, 20, 1, 1, 'X-Ray KUB x-ray ', '500.00', NULL, '', '', '2022-01-12 17:25:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (401, 20, 1, 1, 'X-Ray Rt Patella P/A', '500.00', NULL, '', '', '2022-01-12 17:25:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (402, 20, 1, 1, 'X-Ray Atlas bone B/V', '400.00', NULL, '', '', '2022-01-12 17:25:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (403, 20, 1, 1, 'X-Ray Rt Patella Skyline View', '400.00', NULL, '', '', '2022-01-12 17:26:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (404, 20, 1, 1, 'X-Ray L/S A/P', '700.00', NULL, '', '', '2022-01-12 17:26:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (405, 20, 1, 1, 'X-Ray Rt Patella Skyline view', '450.00', NULL, '', '', '2022-01-12 17:26:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (406, 20, 1, 1, 'X-Ray BA ENAMA D/C', '2200.00', NULL, '', '', '2022-01-12 17:26:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (407, 20, 1, 1, 'X-Ray PNS OM View Digital ', '450.00', NULL, '', '', '2022-01-12 17:27:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (408, 20, 1, 1, 'X-Ray Rt Ring finger B/V', '400.00', NULL, '', '', '2022-01-12 17:27:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (409, 20, 1, 1, 'X-Ray BA Follow Through', '1500.00', NULL, '', '', '2022-01-12 17:28:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (410, 20, 1, 1, 'X-Ray Rt Scaphoid View', '400.00', NULL, '', '', '2022-01-12 17:28:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (411, 20, 1, 1, 'X-Ray PNS OM view', '600.00', NULL, '', '', '2022-01-12 17:28:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (412, 20, 1, 1, 'X-Ray Rt Scapula A/P View', '400.00', NULL, '', '', '2022-01-12 17:28:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (413, 20, 1, 1, 'X-Ray PNS OM view', '500.00', NULL, '', '', '2022-01-12 17:29:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (414, 20, 1, 1, 'X-Ray Pelvimetry A/P (Errect) ', '400.00', NULL, '', '', '2022-01-12 17:30:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (415, 20, 1, 1, 'X-Ray BA MEAL S/D', '1000.00', NULL, '', '', '2022-01-12 17:31:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (416, 20, 1, 1, 'X-Ray Rt Scapula B/V', '700.00', NULL, '', '', '2022-01-12 17:31:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (417, 20, 1, 1, 'X-Ray BA-Enema of Large GUT X-Ray', '1500.00', NULL, '', '', '2022-01-12 17:32:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (418, 20, 1, 1, 'X-Ray Rt Shoulder jt Swimmers View', '400.00', NULL, '', '', '2022-01-12 17:32:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (419, 20, 1, 1, 'X-Ray Rt Sole B/V View', '500.00', NULL, '', '', '2022-01-12 17:32:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (420, 20, 1, 1, 'X-Ray Pelvis A/P view', '600.00', NULL, '', '', '2022-01-12 17:32:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (421, 20, 1, 1, 'X-Ray Ba-Enema let film one', '400.00', NULL, '', '', '2022-01-12 17:32:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (422, 20, 1, 1, 'X-Ray Rt Sub-Mandibular gland Lateral oblique view', '500.00', NULL, '', '', '2022-01-12 17:33:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (423, 20, 1, 1, 'X-Ray Ba-follow through let film two', '700.00', NULL, '', '', '2022-01-12 17:34:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (424, 20, 1, 1, 'X-Ray Pelvis B/V ', '800.00', NULL, '', '', '2022-01-12 17:34:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (425, 20, 1, 1, 'X-Ray Bone Age L-1', '300.00', NULL, '', '', '2022-01-12 17:34:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (426, 20, 1, 1, 'X-Ray Rt T/F', '300.00', NULL, '', '', '2022-01-12 17:34:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (427, 20, 1, 1, 'X-Ray Pelvis L/V', '400.00', NULL, '', '', '2022-01-12 17:35:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (428, 20, 1, 1, 'X-Ray Both Knee Joint A/P View', '400.00', NULL, '', '', '2022-01-12 17:35:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (429, 20, 1, 1, 'X-Ray Plain Abdomen in E/P', '600.00', NULL, '', '', '2022-01-12 17:36:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (430, 20, 1, 1, 'X-Ray Both Knee Joint B/V', '600.00', NULL, '', '', '2022-01-12 17:36:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (431, 20, 1, 1, 'X-Ray Plain Abdomen in E/P Child ', '300.00', NULL, '', '', '2022-01-12 17:37:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (432, 20, 1, 1, 'X-Ray Both Knee jt A/P view', '400.00', NULL, '', '', '2022-01-12 17:37:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (433, 20, 1, 1, 'X-Ray Rt TM jt open mouth', '400.00', NULL, '', '', '2022-01-12 17:38:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (434, 20, 1, 1, 'X-Ray RGU + MCU', '1500.00', NULL, '', '', '2022-01-12 17:38:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (435, 20, 1, 1, 'X-Ray Both Mastoid Townes View', '500.00', NULL, '', '', '2022-01-12 17:38:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (436, 20, 1, 1, 'X-Ray Rt Zygomatic bone B/V', '400.00', NULL, '', '', '2022-01-12 17:39:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (437, 20, 1, 1, 'X-Ray Rt ankle and foot B/V', '400.00', NULL, '', '', '2022-01-12 17:39:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (438, 20, 1, 1, 'X-Ray RT Foot B/V', '600.00', NULL, '', '', '2022-01-12 17:39:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (439, 20, 1, 1, 'X-Ray Rt arm B/V', '600.00', NULL, '', '', '2022-01-12 17:40:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (440, 20, 1, 1, 'X-Ray Retrograde Cysto-Urethrogram (RCU)', '1500.00', NULL, '', '', '2022-01-12 17:40:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (441, 20, 1, 1, 'X-Ray Both clavicle A/P View', '300.00', NULL, '', '', '2022-01-12 17:40:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (442, 20, 1, 1, 'X-Ray Rt calcaneum Axial view', '400.00', NULL, '', '', '2022-01-12 17:41:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (443, 20, 1, 1, 'X-Ray Retrograde Cysto-Urethrogram with MCU ', '1500.00', NULL, '', '', '2022-01-12 17:41:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (444, 20, 1, 1, 'X-Ray Both hib joint', '600.00', NULL, '', '', '2022-01-12 17:41:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (445, 20, 1, 1, 'X-Ray Rt calcaneum B/V', '400.00', NULL, '', '', '2022-01-12 17:41:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (446, 20, 1, 1, 'X-Ray Retrograde Urethrogram (RGU)', '1000.00', NULL, '', '', '2022-01-12 17:42:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (447, 20, 1, 1, 'X-Ray Both hip A/P View', '300.00', NULL, '', '', '2022-01-12 17:42:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (448, 20, 1, 1, 'X-Ray Rt clavicle A/P view', '400.00', NULL, '', '', '2022-01-12 17:42:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (449, 20, 1, 1, 'X-Ray Rt foot B/V', '400.00', NULL, '', '', '2022-01-12 17:43:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (450, 20, 1, 1, 'X-Ray Both knee joint B/V', '900.00', NULL, '', '', '2022-01-12 17:43:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (451, 20, 1, 1, 'X-Ray Rt Mastoid Stenverse View ', '400.00', NULL, '', '', '2022-01-12 17:43:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (452, 20, 1, 1, 'X-Ray Rt fore arm B/V', '400.00', NULL, '', '', '2022-01-12 17:44:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (453, 20, 1, 1, 'X-Ray Rt Shoulder jt A/P View', '600.00', NULL, '', '', '2022-01-12 17:44:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (454, 20, 1, 1, 'X-Ray Both mastoid townes view', '500.00', NULL, '', '', '2022-01-12 17:45:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (455, 20, 1, 1, 'X-Ray Rt great toe B/V', '400.00', NULL, '', '', '2022-01-12 17:45:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (456, 20, 1, 1, 'X-Ray Rt hand B/V', '600.00', NULL, '', '', '2022-01-12 17:45:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (457, 20, 1, 1, 'X-Ray Both orbit P/A View', '300.00', NULL, '', '', '2022-01-12 17:45:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (458, 20, 1, 1, 'X-Ray Rt Ankle joint B/V ', '600.00', NULL, '', '', '2022-01-12 17:46:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (459, 20, 1, 1, 'X-Ray Rt index B/V', '400.00', NULL, '', '', '2022-01-12 17:46:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (460, 20, 1, 1, 'X-Ray C/S A/P', '400.00', NULL, '', '', '2022-01-12 17:46:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (461, 20, 1, 1, 'X-Ray Rt knee jt Tunnel view', '400.00', NULL, '', '', '2022-01-12 17:47:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (462, 20, 1, 1, 'X-Ray C/S B/V', '800.00', NULL, '', '', '2022-01-12 17:47:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (463, 20, 1, 1, 'X-Ray Rt orbit B/V', '400.00', NULL, '', '', '2022-01-12 17:47:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (464, 20, 1, 1, 'X-Ray Rt Ankle jt B/V', '600.00', NULL, '', '', '2022-01-12 17:47:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (465, 20, 1, 1, 'X-Ray C/S L/V', '600.00', NULL, '', '', '2022-01-12 17:48:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (466, 20, 1, 1, 'X-Ray Rt orbit oblique View', '500.00', NULL, '', '', '2022-01-12 17:48:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (467, 20, 1, 1, 'X-Ray Rt Ankle jt B/V', '450.00', NULL, '', '', '2022-01-12 17:49:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (468, 20, 1, 1, 'X-Ray Rt shoulder jt B/V', '600.00', NULL, '', '', '2022-01-12 17:49:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (469, 20, 1, 1, 'X-Ray Rt Elbow joint B/V', '600.00', NULL, '', '', '2022-01-12 17:50:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (470, 20, 1, 1, 'X-Ray Rt shoulder jt internal rotation', '500.00', NULL, '', '', '2022-01-12 17:51:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (471, 20, 1, 1, 'X-Ray Rt shoulder jt A/P view', '600.00', NULL, '', '', '2022-01-12 17:52:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (472, 20, 1, 1, 'X-Ray Rt Femar B/V', '400.00', NULL, '', '', '2022-01-12 17:52:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (473, 20, 1, 1, 'X-Ray Rt thumb B/V', '300.00', NULL, '', '', '2022-01-12 17:53:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (474, 20, 1, 1, 'X-Ray Rt Femur Including Hip A/P View ', '400.00', NULL, '', '', '2022-01-12 17:53:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (475, 20, 1, 1, 'X-Ray Rt wrist joint B/V', '600.00', NULL, '', '', '2022-01-12 17:53:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (476, 20, 1, 1, 'X-Ray Rt. Thigh B/V', '700.00', NULL, '', '', '2022-01-12 17:54:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (477, 20, 1, 1, 'X-Ray Rt Fore Arm B/V', '400.00', NULL, '', '', '2022-01-12 17:54:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (478, 20, 1, 1, 'X-Ray Rt.Wrist B/V', '300.00', NULL, '', '', '2022-01-12 17:55:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (479, 20, 1, 1, 'X-Ray Rt Hand B/V', '600.00', NULL, '', '', '2022-01-12 17:55:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (480, 20, 1, 1, 'X-Ray SI Joint/view', '800.00', NULL, '', '', '2022-01-12 17:55:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (481, 20, 1, 1, 'X-Ray Rt Hand finger B/V ', '400.00', NULL, '', '', '2022-01-12 17:56:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (482, 20, 1, 1, 'X-Ray Sacro-coccygeal A/P view', '300.00', NULL, '', '', '2022-01-12 17:56:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (483, 20, 1, 1, 'X-Ray Rt Heel B/V', '400.00', NULL, '', '', '2022-01-12 17:57:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (484, 20, 1, 1, 'X-Ray Sacro-coccygeal B/V', '500.00', NULL, '', '', '2022-01-12 17:57:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (485, 20, 1, 1, 'X-Ray Sacro-coccygeal Lateral', '300.00', NULL, '', '', '2022-01-12 17:58:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (486, 20, 1, 1, 'X-Ray Rt Hip A/P view ', '400.00', NULL, '', '', '2022-01-12 17:58:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (487, 20, 1, 1, 'X-Ray Rt Hip B/V', '700.00', NULL, '', '', '2022-01-12 17:59:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (488, 20, 1, 1, 'X-Ray Rt Hip joint B/V  ', '600.00', NULL, '', '', '2022-01-12 17:59:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (489, 20, 1, 1, 'X-Ray Sialogram of Lt Parotid gland', '1000.00', NULL, '', '', '2022-01-12 18:00:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (490, 20, 1, 1, 'X-Ray Sialogram of Lt Sub-Mandibular gland', '1000.00', NULL, '', '', '2022-01-12 18:01:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (491, 20, 1, 1, 'X-Ray Sialogram of Rt Sub-Mandibular gland', '1000.00', NULL, '', '', '2022-01-12 18:02:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (492, 20, 1, 1, 'X-Ray Sialogram of Rt parotid gland', '1000.00', NULL, '', '', '2022-01-12 18:06:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (493, 20, 1, 1, 'X-Ray Skull A/P', '400.00', NULL, '', '', '2022-01-12 18:06:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (494, 20, 1, 1, 'X-Ray Skull B/V', '600.00', NULL, '', '', '2022-01-12 18:07:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (495, 20, 1, 1, 'X-Ray Skull B/V', '800.00', NULL, '', '', '2022-01-12 18:08:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (496, 20, 1, 1, 'X-Ray Skull Lateral view', '400.00', NULL, '', '', '2022-01-12 18:09:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (497, 20, 1, 1, 'X-Ray Skull P/A view', '400.00', NULL, '', '', '2022-01-12 18:10:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (498, 20, 1, 1, 'X-Ray Skull SM view', '300.00', NULL, '', '', '2022-01-12 18:10:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (499, 20, 1, 1, 'X-Ray Spine A/P View (child)', '300.00', NULL, '', '', '2022-01-12 18:11:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (500, 20, 1, 1, 'X-Ray Spine B/V (child)', '500.00', NULL, '', '', '2022-01-12 18:12:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (501, 20, 1, 1, 'X-Ray Spine Lateral View (child)', '500.00', NULL, '', '', '2022-01-12 18:12:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (502, 20, 1, 1, 'X-Ray Sterno-clavicular jt P/A View', '400.00', NULL, '', '', '2022-01-12 18:15:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (503, 20, 1, 1, 'X-Ray Sternum A/P', '300.00', NULL, '', '', '2022-01-12 18:17:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (504, 20, 1, 1, 'X-Ray Sternum A/P view', '400.00', NULL, '', '', '2022-01-12 18:18:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (505, 20, 1, 1, 'X-Ray L/S B/V', '900.00', NULL, '', '', '2022-01-12 20:31:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (506, 20, 1, 1, 'X-Ray L/S L/V', '400.00', NULL, '', '', '2022-01-12 20:34:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (507, 20, 1, 1, 'X-Ray L/S Spine A/P View', '300.00', NULL, '', '', '2022-01-12 20:35:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (508, 20, 1, 1, 'X-Ray L/S Spine B/Oblique view', '500.00', NULL, '', '', '2022-01-12 20:37:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (509, 20, 1, 1, 'X-Ray L/S Spine B/V', '600.00', NULL, '', '', '2022-01-12 20:37:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (510, 20, 1, 1, 'X-Ray L/S Spine Flexion', '500.00', NULL, '', '', '2022-01-12 20:40:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (511, 20, 1, 1, 'X-Ray L/S Spine Lateral view', '600.00', NULL, '', '', '2022-01-12 20:40:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (512, 20, 1, 1, 'X-Ray L/S spine flexion and extension', '500.00', NULL, '', '', '2022-01-12 20:41:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (513, 20, 1, 1, 'X-Ray Lt Ankle B/V', '600.00', NULL, '', '', '2022-01-12 20:42:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (514, 20, 1, 1, 'X-Ray Lt Ankle joint B/V', '600.00', NULL, '', '', '2022-01-12 20:43:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (515, 20, 1, 1, 'X-Ray Lt Elbow joint B/V', '600.00', NULL, '', '', '2022-01-12 20:44:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (516, 20, 1, 1, 'X-Ray Lt Femar B/V', '400.00', NULL, '', '', '2022-01-12 20:45:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (517, 20, 1, 1, 'X-Ray Lt Femur Including Hip A/V View', '800.00', NULL, '', '', '2022-01-12 20:46:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (518, 20, 1, 1, 'X-Ray Lt Foot B/V', '600.00', NULL, '', '', '2022-01-12 20:46:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (519, 20, 1, 1, 'X-Ray Lt Fore Arm B/V', '400.00', NULL, '', '', '2022-01-12 20:47:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (520, 20, 1, 1, 'X-Ray Lt Hand B/V', '600.00', NULL, '', '', '2022-01-12 20:48:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (521, 20, 1, 1, 'X-Ray Lt Hand finger B/V', '400.00', NULL, '', '', '2022-01-12 20:49:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (522, 20, 1, 1, 'X-Ray Lt Heel B/V', '400.00', NULL, '', '', '2022-01-12 20:50:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (523, 20, 1, 1, 'X-Ray Lt Hip joint B/V', '600.00', NULL, '', '', '2022-01-12 20:51:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (524, 20, 1, 1, 'X-Ray Lt Knee B/V', '600.00', NULL, '', '', '2022-01-12 20:52:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (525, 20, 1, 1, 'X-Ray Lt Knee joint B/V', '600.00', NULL, '', '', '2022-01-12 20:53:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (526, 20, 1, 1, 'X-Ray Lt Leg B/V', '600.00', NULL, '', '', '2022-01-12 20:54:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (527, 20, 1, 1, 'X-Ray Lt Leg B/V', '700.00', NULL, '', '', '2022-01-12 20:55:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (528, 20, 1, 1, 'X-Ray Lt Leg finger B/V', '400.00', NULL, '', '', '2022-01-12 20:56:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (529, 20, 1, 1, 'X-Ray Lt Little finger B/V', '400.00', NULL, '', '', '2022-01-12 20:57:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (530, 20, 1, 1, 'X-Ray Lt Mastoid Stenverse View', '500.00', NULL, '', '', '2022-01-12 20:58:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (531, 20, 1, 1, 'X-Ray Lt Mastoid Townes View', '700.00', NULL, '', '', '2022-01-12 20:59:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (532, 20, 1, 1, 'X-Ray Lt Neck of Femur A/P View', '400.00', NULL, '', '', '2022-01-12 21:00:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (533, 20, 1, 1, 'X-Ray Lt Neck of Femur B/V', '700.00', NULL, '', '', '2022-01-12 21:01:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (534, 20, 1, 1, 'X-Ray Lt Patella P/A', '400.00', NULL, '', '', '2022-01-12 21:02:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (535, 20, 1, 1, 'X-Ray Lt Patella Skyline view', '400.00', NULL, '', '', '2022-01-12 21:03:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (536, 20, 1, 1, 'X-Ray Lt Ring finger B/V', '400.00', NULL, '', '', '2022-01-12 21:04:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (537, 20, 1, 1, 'X-Ray Lt Shouder jt Swimmers View', '400.00', NULL, '', '', '2022-01-12 21:05:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (538, 20, 1, 1, 'X-Ray Lt Shoulder jt B/V', '600.00', NULL, '', '', '2022-01-12 21:07:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (539, 20, 1, 1, 'X-Ray Lt Thigh B/V', '600.00', NULL, '', '', '2022-01-12 21:07:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (540, 20, 1, 1, 'X-Ray Lt Wrist jt B/V', '600.00', NULL, '', '', '2022-01-12 21:08:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (541, 20, 1, 1, 'X-Ray Lt ankle and foot B/V', '400.00', NULL, '', '', '2022-01-12 21:09:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (543, 20, 1, 1, 'X-Ray Lt arm B/V', '400.00', NULL, '', '', '2022-01-12 21:12:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (544, 20, 1, 1, 'X-Ray Lt calcaneum Axial view', '400.00', NULL, '', '', '2022-01-12 21:12:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (545, 20, 1, 1, 'X-Ray Lt calcaneum B/V', '400.00', NULL, '', '', '2022-01-12 21:13:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (546, 20, 1, 1, 'X-Ray Lt cavicle B/V', '500.00', NULL, '', '', '2022-01-12 21:15:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (547, 20, 1, 1, 'X-Ray Lt clavicle A/P view', '300.00', NULL, '', '', '2022-01-12 21:15:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (548, 20, 1, 1, 'X-Ray Lt elbow jt B/V', '600.00', NULL, '', '', '2022-01-12 21:16:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (552, 20, 1, 1, 'X-Ray Lt knee jt tunnel view', '400.00', NULL, '', '', '2022-01-12 21:28:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (553, 20, 1, 1, 'X-Ray Lt orbit  oblique View', '400.00', NULL, '', '', '2022-01-12 21:30:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (554, 20, 1, 1, 'X-Ray Lt orbit B/V', '500.00', NULL, '', '', '2022-01-12 21:31:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (555, 21, 1, 1, 'Ambulance Charge', '5000.00', NULL, '', '', '2022-01-13 00:02:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (556, 23, 1, 1, 'Appendicectomy', '6000.00', NULL, '', '', '2022-01-13 00:10:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (557, 24, 1, 1, 'Secondary Stitch with Catamine', '3000.00', NULL, '', '', '2022-01-13 00:11:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (558, 23, 1, 1, 'Bartholine Abcess (GA)', '5000.00', NULL, '', '', '2022-01-13 00:11:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (559, 23, 1, 1, 'Piles', '6000.00', NULL, '', '', '2022-01-13 00:12:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (560, 23, 1, 1, 'Bartholine CYST (GA)', '5000.00', NULL, '', '', '2022-01-13 00:12:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (561, 25, 1, 1, 'Gland Biopsy', '4000.00', NULL, '', '', '2022-01-13 00:12:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (562, 24, 1, 1, 'Vaginal Delevery', '1000.00', NULL, '', '', '2022-01-13 00:13:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (563, 25, 1, 1, 'Hydrocyl', '2500.00', NULL, '', '', '2022-01-13 00:13:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (564, 23, 1, 1, 'Pterygium', '5000.00', NULL, '', '', '2022-01-13 00:14:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (565, 23, 1, 1, 'Biopsy Surgery', '7000.00', NULL, '', '', '2022-01-13 00:14:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (566, 24, 1, 1, 'Vaginal Delevery (with Episiotomy)', '1500.00', NULL, '', '', '2022-01-13 00:14:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (567, 25, 1, 1, 'Hysterectomy', '4000.00', NULL, '', '', '2022-01-13 00:14:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (568, 23, 1, 1, 'Breast Abses (L)/A', '4000.00', NULL, '', '', '2022-01-13 00:15:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (569, 24, 1, 1, 'Retained Placenta', '1000.00', NULL, '', '', '2022-01-13 00:15:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (570, 24, 1, 1, 'Vaginal Histrictomy', '12000.00', NULL, '', '', '2022-01-13 00:15:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (571, 25, 1, 1, 'Incissional Hernia', '3000.00', NULL, '', '', '2022-01-13 00:16:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (572, 23, 1, 1, 'Breast Lump/Tumour', '8000.00', NULL, '', '', '2022-01-13 00:16:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (573, 25, 1, 1, 'Abdominal Histectomy (Single Surgeon)', '8000.00', NULL, '', '', '2022-01-13 00:16:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (574, 25, 1, 1, 'Kidney urinary stone', '4000.00', NULL, '', '', '2022-01-13 00:17:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (575, 24, 1, 1, 'Secondary Stitch with Catamine', '3000.00', NULL, '', '', '2022-01-13 00:17:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (576, 23, 1, 1, 'Herniotomy', '7500.00', NULL, '', '', '2022-01-13 00:17:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (577, 25, 1, 1, 'Appendicectomy', '2700.00', NULL, '', '', '2022-01-13 00:18:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (578, 25, 1, 1, 'L U C S', '3200.00', NULL, '', '', '2022-01-13 00:18:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (579, 23, 1, 1, 'Hydrocill', '2700.00', NULL, '', '', '2022-01-13 00:18:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (580, 25, 1, 1, 'Laminectomy', '4000.00', NULL, '', '', '2022-01-13 00:19:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (581, 24, 1, 1, 'Vaginal Delevery', '1000.00', NULL, '', '', '2022-01-13 00:19:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (582, 25, 1, 1, 'Biopsy', '2500.00', NULL, '', '', '2022-01-13 00:19:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (583, 23, 1, 1, 'Piles', '6000.00', NULL, '', '', '2022-01-13 00:19:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (584, 25, 1, 1, 'Laparotomy Single Cons.', '8000.00', NULL, '', '', '2022-01-13 00:19:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (585, 25, 1, 1, 'Catheterization', '700.00', NULL, '', '', '2022-01-13 00:20:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (586, 24, 1, 1, 'Vaginal Delevery (with Episiotomy)', '1500.00', NULL, '', '', '2022-01-13 00:20:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (587, 25, 1, 1, 'Laparscopy', '4000.00', NULL, '', '', '2022-01-13 00:20:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (588, 23, 1, 1, 'Pterygium', '5000.00', NULL, '', '', '2022-01-13 00:20:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (589, 25, 1, 1, 'Chest Aspiration (Local)', '1000.00', NULL, '', '', '2022-01-13 00:21:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (590, 25, 1, 1, 'Lapchole', '12000.00', NULL, '', '', '2022-01-13 00:21:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (591, 25, 1, 1, 'Lapcoly', '4000.00', NULL, '', '', '2022-01-13 00:22:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (592, 25, 1, 1, 'Chest Aspiration(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-13 00:23:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (593, 24, 1, 1, 'Vaginal Histrictomy', '12000.00', NULL, '', '', '2022-01-13 00:23:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (594, 25, 1, 1, 'Lapratomy', '4000.00', NULL, '', '', '2022-01-13 00:23:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (595, 25, 1, 1, 'Lipoma', '2500.00', NULL, '', '', '2022-01-13 00:24:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (596, 25, 1, 1, 'Circumcession(Anaesthesia)', '1000.00', NULL, '', '', '2022-01-13 00:24:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (597, 25, 1, 1, 'Abdominal Histectomy (Single Surgeon)', '8000.00', NULL, '', '', '2022-01-13 00:25:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (598, 22, 1, 1, 'Adenoidectomy', '6000.00', NULL, '', '', '2022-01-13 00:25:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (599, 25, 1, 1, 'M. R (local)', '700.00', NULL, '', '', '2022-01-13 00:25:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (600, 25, 1, 1, 'Circumcession(Local)', '700.00', NULL, '', '', '2022-01-13 00:25:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (601, 25, 1, 1, 'Mastaidioactomy', '4000.00', NULL, '', '', '2022-01-13 00:26:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (602, 25, 1, 1, 'Appendicectomy', '2700.00', NULL, '', '', '2022-01-13 00:26:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (603, 25, 1, 1, 'Cistostopy', '2000.00', NULL, '', '', '2022-01-13 00:26:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (604, 22, 1, 1, 'Amalgum Filling', '350.00', NULL, '', '', '2022-01-13 00:26:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (605, 25, 1, 1, 'Mastectomy', '4000.00', NULL, '', '', '2022-01-13 00:27:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (606, 25, 1, 1, 'Dilatation(Anaesthesia)', '2000.00', NULL, '', '', '2022-01-13 00:27:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (607, 22, 1, 1, 'Branchial Cyst - 1', '11000.00', NULL, '', '', '2022-01-13 00:27:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (608, 25, 1, 1, 'Nephroelithotomy', '4000.00', NULL, '', '', '2022-01-13 00:28:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (609, 25, 1, 1, 'Biopsy', '2500.00', NULL, '', '', '2022-01-13 00:28:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (610, 22, 1, 1, 'Ear Wash', '500.00', NULL, '', '', '2022-01-13 00:28:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (611, 25, 1, 1, 'Dilatation(Local)', '700.00', NULL, '', '', '2022-01-13 00:28:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (612, 25, 1, 1, 'OT Charge Including Assist', '1500.00', NULL, '', '', '2022-01-13 00:28:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (613, 22, 1, 1, 'Nose Surgery', '5500.00', NULL, '', '', '2022-01-13 00:29:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (614, 25, 1, 1, 'Ovarian Cyst', '4000.00', NULL, '', '', '2022-01-13 00:29:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (615, 25, 1, 1, 'Excision of the Encephalocele', '12000.00', NULL, '', '', '2022-01-13 00:29:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (616, 25, 1, 1, 'Catheterization', '700.00', NULL, '', '', '2022-01-13 00:29:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (617, 25, 1, 1, 'Poly Pectomy', '4000.00', NULL, '', '', '2022-01-13 00:30:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (618, 22, 1, 1, 'Nose Wash', '500.00', NULL, '', '', '2022-01-13 00:30:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (619, 25, 1, 1, 'Fistula(Perianal)', '2500.00', NULL, '', '', '2022-01-13 00:30:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (620, 25, 1, 1, 'SMR/SMD', '1700.00', NULL, '', '', '2022-01-13 00:31:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (621, 25, 1, 1, 'Chest Aspiration (Local)', '1000.00', NULL, '', '', '2022-01-13 00:31:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (622, 22, 1, 1, 'Nose Wash (LA)', '2000.00', NULL, '', '', '2022-01-13 00:31:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (623, 25, 1, 1, 'Gallbladder', '4000.00', NULL, '', '', '2022-01-13 00:32:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (624, 25, 1, 1, 'Skin grfting', '4000.00', NULL, '', '', '2022-01-13 00:32:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (625, 22, 1, 1, 'Septoplasty + BAWO', '7000.00', NULL, '', '', '2022-01-13 00:32:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (626, 25, 1, 1, 'Gland Biopsy', '4000.00', NULL, '', '', '2022-01-13 00:33:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (627, 25, 1, 1, 'Stich (local)', '700.00', NULL, '', '', '2022-01-13 00:33:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (628, 22, 1, 1, 'Septoplasty+SMD', '7000.00', NULL, '', '', '2022-01-13 00:33:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (629, 25, 1, 1, 'Chest Aspiration(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-13 00:33:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (630, 25, 1, 1, 'Stich(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-13 00:34:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (631, 22, 1, 1, 'Tonsilities', '6000.00', NULL, '', '', '2022-01-13 00:34:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (632, 25, 1, 1, 'Hydrocyl', '2500.00', NULL, '', '', '2022-01-13 00:35:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (633, 25, 1, 1, 'TURP', '4000.00', NULL, '', '', '2022-01-13 00:35:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (634, 25, 1, 1, 'Circumcession(Anaesthesia)', '1000.00', NULL, '', '', '2022-01-13 00:35:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (635, 25, 1, 1, 'Tendor Repair', '7000.00', NULL, '', '', '2022-01-13 00:36:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (636, 25, 1, 1, 'Circumcession(Local)', '700.00', NULL, '', '', '2022-01-13 00:37:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (637, 25, 1, 1, 'Cistostopy', '2000.00', NULL, '', '', '2022-01-13 00:39:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (638, 25, 1, 1, 'Dilatation(Anaesthesia)', '2000.00', NULL, '', '', '2022-01-13 00:41:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (639, 25, 1, 1, 'Dilatation(Local)', '700.00', NULL, '', '', '2022-01-13 00:43:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (640, 25, 1, 1, 'Excision of the Encephalocele', '12000.00', NULL, '', '', '2022-01-13 00:44:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (641, 25, 1, 1, 'Fistula(Perianal)', '2500.00', NULL, '', '', '2022-01-13 00:46:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (642, 25, 1, 1, 'Gallbladder', '4000.00', NULL, '', '', '2022-01-13 00:47:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (643, 26, 1, 1, 'Abcess Drain (LA)', '1000.00', NULL, '', '', '2022-01-13 01:52:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (644, 26, 1, 1, 'Abcess Drain with GA', '5000.00', NULL, '', '', '2022-01-13 01:53:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (645, 26, 1, 1, 'Circumcision (Adult)', '2000.00', NULL, '', '', '2022-01-13 01:55:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (646, 26, 1, 1, 'Circumcision (GA)', '4000.00', NULL, '', '', '2022-01-13 01:56:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (647, 26, 1, 1, 'Circumcision (LA)', '1500.00', NULL, '', '', '2022-01-13 01:57:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (648, 26, 1, 1, 'Consultant Fee', '1000.00', NULL, '', '', '2022-01-13 01:58:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (649, 26, 1, 1, 'Drain Abses', '500.00', NULL, '', '', '2022-01-13 01:59:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (650, 26, 1, 1, 'ECT', '2500.00', NULL, '', '', '2022-01-13 02:00:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (651, 26, 1, 1, 'Excision Biopsy (SA)', '3500.00', NULL, '', '', '2022-01-13 02:03:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (652, 26, 1, 1, 'Excision Tissue', '1500.00', NULL, '', '', '2022-01-13 02:04:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (653, 26, 1, 1, 'Fibroadinoma', '10000.00', NULL, '', '', '2022-01-13 02:05:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (654, 26, 1, 1, 'Fissurcetomy', '6000.00', NULL, '', '', '2022-01-13 02:06:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (655, 26, 1, 1, 'Foreign Body Removal', '500.00', NULL, '', '', '2022-01-13 02:07:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (656, 26, 1, 1, 'Foreign Body Removal (Catamine)', '2000.00', NULL, '', '', '2022-01-13 02:08:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (657, 26, 1, 1, 'Foreign Body Removal (La)', '800.00', NULL, '', '', '2022-01-13 02:10:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (658, 26, 1, 1, 'Ligation', '1000.00', NULL, '', '', '2022-01-13 02:11:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (659, 26, 1, 1, 'OT Team Charge', '9000.00', NULL, '', '', '2022-01-13 02:12:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (660, 26, 1, 1, 'Perinaeal Tear (1st Degree)', '1500.00', NULL, '', '', '2022-01-13 02:13:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (661, 26, 1, 1, 'Report repeat (USG)', '200.00', NULL, '', '', '2022-01-13 02:14:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (662, 27, 1, 1, 'Online Doctor Fees', '600.00', NULL, '', '', '2022-01-17 23:05:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (663, 28, 1, 2, 'Admission Fees', '100.00', NULL, '', '', '2022-02-18 12:21:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (664, 29, 1, 2, 'Advance', '2000.00', NULL, '', '', '2022-02-18 12:31:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (665, 30, 1, 2, 'Dr.Kamal FCPS-USA', '600.00', NULL, '', '', '2022-02-18 12:53:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (666, 18, 1, 2, 'Dr.Kamal FCPS-USA', '6000.00', NULL, '', '', '2022-02-18 12:56:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (667, 2, 1, 2, 'CBC/CP/Blood RE', '500.00', NULL, '', '', '2022-02-25 23:37:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (668, 2, 1, 2, 'TOTAL PLATELET COUNT', '500.00', NULL, '', '', '2022-02-25 23:45:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (669, 2, 1, 2, 'PCV (HCT)', '500.00', NULL, '', '', '2022-02-25 23:46:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (670, 2, 1, 2, 'BT. & C.T', '500.00', NULL, '', '', '2022-02-25 23:52:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (671, 2, 1, 2, 'P.B.F', '500.00', NULL, '', '', '2022-02-25 23:52:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (672, 2, 1, 2, 'MP(Malarial Parasites)', '500.00', NULL, '', '', '2022-02-25 23:54:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (673, 2, 1, 2, 'FBS/RBS/PPBS(75 glucose).', '200.00', NULL, '', '', '2022-02-25 23:55:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (674, 2, 1, 2, 'S. Bilirubin', '500.00', NULL, '', '', '2022-02-26 00:00:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (675, 2, 1, 2, 'ASO Test ', '500.00', NULL, '', '', '2022-02-26 00:02:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (676, 2, 1, 2, 'CRP(C-Reactive Protein)', '500.00', NULL, '', '', '2022-02-26 00:14:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (677, 2, 1, 2, '2 Hrs after BF/75 glucose', '200.00', NULL, '', '', '2022-02-26 00:16:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (678, 2, 1, 2, 'Alkaline Phosphates (ALP)', '500.00', NULL, '', '', '2022-02-26 00:16:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (679, 2, 1, 2, 'S. Total Cholesterol', '500.00', NULL, '', '', '2022-02-26 00:17:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (680, 2, 1, 2, 'LDL', '500.00', NULL, '', '', '2022-02-26 00:18:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (681, 2, 1, 2, 'Uric Acid', '500.00', NULL, '', '', '2022-02-26 00:19:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (682, 2, 1, 2, 'Blood Urea/BUN', '500.00', NULL, '', '', '2022-02-26 00:19:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (683, 2, 1, 2, 'Blood Grouping & RH F actor ', '150.00', NULL, '', '', '2022-02-26 00:20:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (684, 2, 1, 2, 'Anti HAV Igm', '2000.00', NULL, '', '', '2022-02-26 00:21:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (685, 2, 1, 2, 'S. Calcium (Ca++)', '600.00', NULL, '', '', '2022-02-26 00:21:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (686, 2, 1, 2, 'S. Electroytes ', '1000.00', NULL, '', '', '2022-02-26 00:22:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (687, 2, 1, 2, 'ASO (Quantitative) Test', '500.00', NULL, '', '', '2022-02-26 00:23:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (688, 2, 1, 2, 'MP (ICT Method)', '500.00', NULL, '', '', '2022-02-26 00:23:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (689, 2, 1, 2, 'Urine Albumin/ Urine Sugar', '200.00', NULL, '', '', '2022-02-26 00:24:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (690, 2, 1, 2, 'Albumin/Globulin (A/G) Ratio', '1000.00', NULL, '', '', '2022-02-26 00:25:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (691, 2, 1, 2, 'CRP (Quantitative) Test', '800.00', NULL, '', '', '2022-02-26 00:25:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (692, 2, 1, 2, 'Tuberculin Test / Mantoux test (MT)', '500.00', NULL, '', '', '2022-02-26 00:26:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (693, 2, 1, 2, 'CKMB', '700.00', NULL, '', '', '2022-02-26 00:27:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (694, 2, 1, 2, 'RA/RF (Quantitative)', '500.00', NULL, '', '', '2022-02-26 00:27:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (695, 2, 1, 2, 'PSA (ICT Method)', '700.00', NULL, '', '', '2022-02-26 00:27:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (696, 2, 1, 2, 'PSA Level (ELISA Method)', '1200.00', NULL, '', '', '2022-02-26 00:28:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (697, 2, 1, 2, 'HBeAG (Elisa/Confirmatory)', '1100.00', NULL, '', '', '2022-02-26 00:28:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (698, 2, 1, 2, 'HBeAG (ICT Method)', '600.00', NULL, '', '', '2022-02-26 00:30:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (699, 2, 1, 2, 'Iron Profile', '3000.00', NULL, '', '', '2022-02-26 00:30:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (700, 2, 1, 2, 'TIBC', '1000.00', NULL, '', '', '2022-02-26 00:31:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (701, 2, 1, 2, 'Serum Lipase', '1200.00', NULL, '', '', '2022-02-26 00:31:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (702, 2, 1, 2, 'Urine C/S', '1500.00', NULL, '', '', '2022-02-26 00:32:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (703, 2, 1, 2, 'HIV (Screening)', '500.00', NULL, '', '', '2022-02-26 00:32:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (704, 2, 1, 2, '25 (OH)vitamin D', '2000.00', NULL, '', '', '2022-02-26 00:33:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (705, 2, 1, 2, 'TPHA (ICT Method)', '500.00', NULL, '', '', '2022-02-26 00:33:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (706, 2, 1, 2, 'CEA (ELISA Method)', '1200.00', NULL, '', '', '2022-02-26 00:34:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (707, 2, 1, 2, 'Urine for R/E', '200.00', NULL, '', '', '2022-02-26 00:34:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (708, 2, 1, 2, 'Blood C/S', '2500.00', NULL, '', '', '2022-02-26 00:35:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (709, 2, 1, 2, 'Troponin-l (ELISA Method) ', '800.00', NULL, '', '', '2022-02-26 00:36:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (710, 2, 1, 2, 'Stool for R/E', '500.00', NULL, '', '', '2022-02-26 00:36:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (711, 2, 1, 2, 'Prothrombin Time(PR) INR', '1200.00', NULL, '', '', '2022-02-26 00:37:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (712, 2, 1, 2, 'Anti HAV (ELISA Method)', '800.00', NULL, '', '', '2022-02-26 00:37:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (713, 2, 1, 2, 'Stool Redu. Substance', '500.00', NULL, '', '', '2022-02-26 00:37:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (714, 2, 1, 2, 'Total Circulating Eosinophil Count (TCEC)', '500.00', NULL, '', '', '2022-02-26 00:38:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (715, 2, 1, 2, 'CA-15.3', '2000.00', NULL, '', '', '2022-02-26 00:39:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (716, 2, 1, 2, 'F, T3', '700.00', NULL, '', '', '2022-02-26 00:40:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (717, 2, 1, 2, 'F,T4', '700.00', NULL, '', '', '2022-02-26 00:41:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (718, 2, 1, 2, 'F, T3, F. T4', '1400.00', NULL, '', '', '2022-02-26 00:43:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (719, 2, 1, 2, 'CA-199.9', '2000.00', NULL, '', '', '2022-02-26 00:44:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (720, 2, 1, 2, 'ProBNP', '3500.00', NULL, '', '', '2022-02-26 00:45:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (721, 2, 1, 2, 'Vitamin D3 Level', '2500.00', NULL, '', '', '2022-02-26 00:47:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (722, 2, 1, 2, 'S. PROLACTIN (PRL)', '1200.00', NULL, '', '', '2022-02-26 00:48:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (723, 2, 1, 2, 'Serum hCG', '1100.00', NULL, '', '', '2022-02-26 00:49:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (724, 2, 1, 2, 'Β HCG', '1600.00', NULL, '', '', '2022-02-26 00:50:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (725, 2, 1, 2, 'Skin Scrapping for Fungus', '800.00', NULL, '', '', '2022-02-26 00:51:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (726, 2, 1, 2, 'Vitamin D', '500.00', NULL, '', '', '2022-02-26 00:52:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (727, 2, 1, 2, 'Cross-Matching screeing,VDRL,HBSAG,HIV,HCV', '1600.00', NULL, '', '', '2022-02-26 00:53:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (728, 2, 1, 2, 'FSH', '800.00', NULL, '', '', '2022-02-26 00:54:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (729, 2, 1, 2, 'LH', '800.00', NULL, '', '', '2022-02-26 00:56:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (730, 2, 1, 2, 'Cross-Matching', '500.00', NULL, '', '', '2022-02-26 00:57:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (731, 58, 1, 2, 'ECG', '500.00', NULL, '', '', '2022-02-26 00:59:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (732, 19, 1, 2, 'CPK', '1200.00', NULL, '', '', '2022-02-26 01:02:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (733, 2, 1, 2, 'Anti HBC IgM/ IgG', '800.00', NULL, '', '', '2022-02-26 01:04:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (734, 19, 1, 2, 'ETT', '2600.00', NULL, '', '', '2022-02-26 01:05:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (735, 19, 1, 2, 'Echocardiography (2D)', '1500.00', NULL, '', '', '2022-02-26 01:06:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (736, 19, 1, 2, 'Echocardiography (Colour Dopler)', '2500.00', NULL, '', '', '2022-02-26 01:07:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (737, 19, 1, 2, 'USG of W/A', '700.00', NULL, '', '', '2022-02-26 01:08:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (739, 19, 1, 2, 'USG of L/A', '600.00', NULL, '', '', '2022-02-26 01:10:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (740, 20, 1, 2, 'X-Ray L/S Spine B/V', '900.00', NULL, '', '', '2022-02-26 01:14:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (741, 20, 1, 2, 'X-Ray CXR', '500.00', NULL, '', '', '2022-02-26 01:15:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (742, 20, 1, 2, 'X-Ray KUB', '500.00', NULL, '', '', '2022-02-26 01:16:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (743, 20, 1, 2, 'X-Ray PNS', '500.00', NULL, '', '', '2022-02-26 01:18:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (744, 31, 1, 2, 'Free Doctor Visit', '0.01', NULL, '', '', '2022-02-26 15:52:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (746, 32, 1, 2, 'General Bed', '500.00', NULL, '', '', '2022-02-28 09:45:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (747, 32, 1, 2, 'Cabin single', '1200.00', NULL, '', '', '2022-02-28 09:50:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (748, 32, 1, 2, 'Cabin Double', '1500.00', NULL, '', '', '2022-02-28 09:51:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (749, 33, 1, 2, 'Doctor Round', '300.00', NULL, '', '', '2022-02-28 10:14:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (750, 34, 1, 2, 'OT charge(2000)', '2000.00', NULL, '', '', '2022-02-28 10:25:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (751, 34, 1, 2, 'OT Charge(2500)', '2500.00', NULL, '', '', '2022-02-28 10:32:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (752, 34, 1, 2, 'OT Charge', '3000.00', NULL, '', '', '2022-02-28 10:35:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (753, 42, 1, 2, 'Dressing Charges', '500.00', NULL, '', '', '2022-02-28 10:40:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (754, 38, 1, 2, 'Service Charges', '200.00', NULL, '', '', '2022-02-28 10:41:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (755, 37, 1, 2, 'Assist fees', '1500.00', NULL, '', '', '2022-02-28 10:42:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (756, 45, 1, 2, 'Sewing', '300.00', NULL, '', '', '2022-02-28 10:48:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (758, 46, 1, 2, 'Emergency', '100.00', NULL, '', '', '2022-02-28 22:16:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (761, 46, 1, 2, 'Nebulaization', '100.00', NULL, '', '', '2022-03-01 08:16:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (762, 46, 1, 2, 'Injection push', '100.00', NULL, '', '', '2022-03-01 08:27:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (763, 49, 1, 2, 'Cannula Change(100)', '100.00', NULL, '', '', '2022-03-01 08:35:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (764, 35, 1, 2, 'Surgeon fees', '4000.00', NULL, '', '', '2022-03-01 08:52:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (765, 18, 1, 2, 'Dr. Selim Hossen', '300.00', NULL, '', '', '2022-03-01 18:25:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (766, 18, 1, 2, 'Dr.Shohanur Rahman', '100.00', NULL, '', '', '2022-03-01 18:33:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (767, 15, 1, 2, 'Unine Exam', '900.00', NULL, '', '', '2022-03-04 21:22:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (768, 45, 1, 2, 'Cannula installation', '100.00', NULL, '', '', '2022-03-07 00:18:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (769, 55, 1, 2, 'Doctor Round-Specialist', '500.00', NULL, '', '', '2022-03-11 12:19:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (770, 36, 1, 2, 'Anesthesia', '1500.00', NULL, '', '', '2022-03-11 12:27:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (771, 2, 1, 2, 'PT-INR', '1200.00', NULL, '', '', '2022-03-12 12:51:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (772, 18, 1, 2, 'Dr. Israt Jahan MBBS(dhaka)', '300.00', NULL, '', '', '2022-03-19 12:13:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (773, 39, 1, 2, 'Dressings', '500.00', NULL, '', '', '2022-03-20 13:16:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (774, 56, 1, 2, 'othres', '500.00', NULL, '', '', '2022-03-20 13:20:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (775, 18, 1, 2, 'Dr.Asif Nawaz (Roki)', '300.00', NULL, '', '', '2022-03-21 11:34:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (776, 57, 1, 2, 'Oxygen ', '200.00', NULL, '', '', '2022-03-21 14:07:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (777, 52, 1, 2, 'Oxygen', '200.00', NULL, '', '', '2022-03-21 22:43:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (778, 2, 1, 2, 'CRP (Quantitative)', '500.00', NULL, '', '', '2022-03-24 19:33:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (779, 18, 1, 2, 'Dr.M Tanvir (MBBS, MPH)', '300.00', NULL, '', '', '2022-03-24 21:12:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (780, 2, 1, 2, 'S.Testosterone', '1200.00', NULL, '', '', '2022-03-26 15:10:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (781, 19, 1, 2, 'no_charge', '0.01', NULL, '', '', '2022-03-31 21:33:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (782, 2, 1, 2, 't4', '700.00', NULL, '', '', '2022-04-01 13:07:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (783, 18, 1, 2, 'Dr. Cap. Hosne Ara', '500.00', NULL, '', '', '2022-04-02 14:44:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (784, 19, 1, 2, 'USG of TVS', '2000.00', NULL, '', '', '2022-04-04 13:16:57');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(1) DEFAULT 0,
  `is_read` int(1) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_patient_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_patient_id` (`create_patient_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cheque_manger
#

DROP TABLE IF EXISTS `cheque_manger`;

CREATE TABLE `cheque_manger` (
  `cheque_id` varchar(100) NOT NULL,
  `transection_id` varchar(100) NOT NULL,
  `customer_id` varchar(100) NOT NULL,
  `bank_id` varchar(100) NOT NULL,
  `cheque_no` varchar(100) NOT NULL,
  `date` varchar(50) NOT NULL,
  `transection_type` varchar(100) NOT NULL,
  `cheque_status` varchar(30) NOT NULL,
  `amount` float NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: company_information
#

DROP TABLE IF EXISTS `company_information`;

CREATE TABLE `company_information` (
  `company_id` varchar(50) NOT NULL,
  `company_name` varchar(250) NOT NULL,
  `email` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `mobile` varchar(30) NOT NULL,
  `website` varchar(50) NOT NULL,
  `status` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `company_information` (`company_id`, `company_name`, `email`, `address`, `mobile`, `website`, `status`) VALUES ('NOILG8EGCRXXBWUEUQBM', 'bdtask Shop', 'bdtask@gmail.com', 'B-25, Mannan Plaza, 4th Floor, Khilkhet\r\nDhaka-1229, Bangladesh ', '1922296392', 'http://www.bdtask.com', 1);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`),
  CONSTRAINT `complaint_ibfk_1` FOREIGN KEY (`complaint_type_id`) REFERENCES `complaint_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'Any', '', '2022-03-18 03:17:35');


#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `timezone` text DEFAULT NULL,
  `return_response` text DEFAULT NULL,
  `api_type` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `created_id` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_3` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_4` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_5` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `consult_charges_ibfk_1` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`),
  CONSTRAINT `consultant_register_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consultant_register_ibfk_2` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` varchar(250) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: currency_tbl
#

DROP TABLE IF EXISTS `currency_tbl`;

CREATE TABLE `currency_tbl` (
  `id` int(11) NOT NULL,
  `currency_name` varchar(50) NOT NULL,
  `icon` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `currency_tbl` (`id`, `currency_name`, `icon`) VALUES (1, 'Taka', 'à§³');
INSERT INTO `currency_tbl` (`id`, `currency_name`, `icon`) VALUES (2, 'Azerbaijan Manat', 'â‚¼');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1754 DEFAULT CHARSET=utf8;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (76, 0, 2, '106', '2022-03-19 11:14:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (77, 0, 3, 'X-Ray', '2022-03-19 11:14:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (78, 0, 2, '106', '2022-03-19 11:13:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (79, 0, 3, 'USG', '2022-03-19 11:13:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (80, 60, 2, '106', '2022-03-19 11:13:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (81, 60, 3, 'USG', '2022-03-19 11:13:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (82, 59, 2, '106', '2022-03-19 11:14:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (83, 59, 3, 'X-Ray', '2022-03-19 11:14:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (84, 82, 1, '', '2022-03-19 12:38:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (85, 0, 2, '106', '2022-03-19 13:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (86, 0, 3, 'USG', '2022-03-19 13:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (87, 61, 2, '106', '2022-03-19 13:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (88, 61, 3, 'USG', '2022-03-19 13:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (89, 62, 2, '', '2022-03-19 17:19:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (90, 62, 3, 'X-Ray', '2022-03-19 17:19:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (91, 83, 1, '', '2022-03-19 20:15:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (92, 84, 1, '', '2022-03-19 20:46:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (93, 63, 2, '', '2022-03-19 20:52:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (94, 63, 3, 'X-Ray', '2022-03-19 20:52:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (95, 64, 2, '', '2022-03-19 21:32:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (96, 64, 3, 'X-Ray', '2022-03-19 21:32:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (97, 65, 2, '', '2022-03-19 21:42:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (98, 65, 3, 'X-Ray', '2022-03-19 21:42:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (99, 66, 2, '106', '2022-03-20 08:14:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (100, 66, 3, 'X-Ray', '2022-03-20 08:14:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (101, 85, 1, '107', '2022-03-20 08:14:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (102, 86, 1, '', '2022-03-20 09:02:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (103, 87, 1, '', '2022-03-20 10:29:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (104, 67, 2, '', '2022-03-20 10:41:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (105, 67, 3, 'USG', '2022-03-20 10:41:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (106, 88, 1, '', '2022-03-20 10:42:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (107, 68, 2, '', '2022-03-20 10:49:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (108, 68, 3, 'X-Ray', '2022-03-20 10:49:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (109, 89, 1, '', '2022-03-20 10:51:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (110, 69, 2, '', '2022-03-20 11:23:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (111, 69, 3, 'X-Ray', '2022-03-20 11:23:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (112, 90, 1, '', '2022-03-20 11:52:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (113, 91, 1, '', '2022-03-20 12:20:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (114, 92, 1, '107', '2022-03-20 14:05:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (115, 70, 2, '106', '2022-03-20 16:03:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (116, 70, 3, 'X-Ray', '2022-03-20 16:03:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (117, 93, 1, '107', '2022-03-20 16:26:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (118, 71, 2, '', '2022-03-20 17:00:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (119, 71, 3, 'X-Ray', '2022-03-20 17:00:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (120, 72, 2, '', '2022-03-20 17:45:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (121, 72, 3, 'X-Ray', '2022-03-20 17:45:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (122, 94, 1, '', '2022-03-20 18:14:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (123, 73, 2, '', '2022-03-20 19:12:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (124, 73, 3, 'USG', '2022-03-20 19:12:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (125, 95, 1, '', '2022-03-20 19:12:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (126, 96, 1, '', '2022-03-20 19:25:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (127, 74, 2, '', '2022-03-20 19:27:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (128, 74, 3, 'X-Ray', '2022-03-20 19:27:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (129, 97, 1, '107', '2022-03-20 19:50:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (130, 98, 1, '', '2022-03-20 19:53:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (131, 75, 2, '', '2022-03-20 19:56:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (132, 75, 3, 'X-Ray', '2022-03-20 19:56:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (133, 99, 1, '', '2022-03-20 19:58:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (134, 100, 1, '', '2022-03-20 19:59:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (135, 101, 1, '107', '2022-03-20 20:16:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (136, 76, 2, '', '2022-03-20 20:18:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (137, 76, 3, 'USG', '2022-03-20 20:18:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (138, 102, 1, '', '2022-03-20 21:36:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (139, 103, 1, '', '2022-03-21 09:09:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (140, 104, 1, '', '2022-03-21 09:11:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (141, 105, 1, '', '2022-03-21 09:13:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (142, 106, 1, '', '2022-03-21 09:16:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (143, 107, 1, '', '2022-03-21 09:18:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (144, 108, 1, '', '2022-03-21 09:54:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (145, 77, 2, '', '2022-03-21 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (146, 77, 3, 'USG', '2022-03-21 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (147, 109, 1, '', '2022-03-21 10:26:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (148, 78, 2, '', '2022-03-21 10:28:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (149, 78, 3, 'X-Ray', '2022-03-21 10:28:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (150, 79, 2, '', '2022-03-21 10:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (151, 79, 3, 'USG', '2022-03-21 10:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (152, 110, 1, '107', '2022-03-21 10:57:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (153, 80, 2, '', '2022-03-21 10:58:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (154, 80, 3, 'USG', '2022-03-21 10:58:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (155, 111, 1, '107', '2022-03-21 11:08:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (156, 112, 1, '', '2022-03-21 11:38:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (157, 113, 1, '', '2022-03-21 12:01:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (158, 81, 2, '', '2022-03-21 12:02:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (159, 81, 3, 'USG', '2022-03-21 12:02:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (160, 114, 1, '107', '2022-03-21 12:17:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (161, 82, 2, '', '2022-03-21 12:38:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (162, 82, 3, 'X-Ray', '2022-03-21 12:38:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (163, 83, 2, '', '2022-03-21 12:43:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (164, 83, 3, 'X-Ray', '2022-03-21 12:43:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (165, 84, 2, '', '2022-03-21 13:28:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (166, 84, 3, 'X-Ray', '2022-03-21 13:28:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (167, 115, 1, '107', '2022-03-21 13:52:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (168, 85, 2, '106', '2022-03-21 13:57:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (169, 85, 3, 'X-Ray', '2022-03-21 13:57:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (170, 116, 1, '107', '2022-03-21 14:51:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (171, 86, 2, '', '2022-03-21 14:54:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (172, 86, 3, 'USG', '2022-03-21 14:54:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (173, 87, 2, '', '2022-03-21 15:12:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (174, 87, 3, 'X-Ray', '2022-03-21 15:12:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (175, 117, 1, '', '2022-03-21 17:08:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (176, 88, 2, '', '2022-03-21 17:09:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (177, 88, 3, 'USG', '2022-03-21 17:09:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (178, 89, 2, '', '2022-03-21 17:22:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (179, 89, 3, 'X-Ray', '2022-03-21 17:22:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (180, 90, 2, '', '2022-03-21 17:30:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (181, 90, 3, 'X-Ray', '2022-03-21 17:30:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (182, 91, 2, '106', '2022-03-21 17:46:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (183, 91, 3, 'X-Ray', '2022-03-21 17:46:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (184, 92, 2, '', '2022-03-21 17:57:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (185, 92, 3, 'X-Ray', '2022-03-21 17:57:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (186, 93, 2, '', '2022-03-21 18:42:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (187, 93, 3, 'X-Ray', '2022-03-21 18:42:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (188, 118, 1, '107', '2022-03-21 18:43:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (189, 119, 1, '107', '2022-03-21 19:56:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (190, 94, 2, '106', '2022-03-21 20:01:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (191, 94, 3, 'X-Ray', '2022-03-21 20:01:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (192, 120, 1, '', '2022-03-21 20:18:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (193, 95, 2, '', '2022-03-21 21:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (194, 95, 3, 'USG', '2022-03-21 21:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (195, 96, 2, '', '2022-03-22 09:47:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (196, 96, 3, 'USG', '2022-03-22 09:47:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (197, 121, 1, '', '2022-03-22 10:27:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (198, 97, 2, '', '2022-03-22 10:31:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (199, 97, 3, 'X-Ray', '2022-03-22 10:31:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (200, 98, 2, '', '2022-03-22 10:38:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (201, 98, 3, 'X-Ray', '2022-03-22 10:38:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (202, 99, 2, '', '2022-03-22 10:41:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (203, 99, 3, 'USG', '2022-03-22 10:41:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (204, 122, 1, '', '2022-03-22 10:47:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (205, 123, 1, '', '2022-03-22 10:58:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (206, 100, 2, '', '2022-03-22 11:00:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (207, 100, 3, 'X-Ray', '2022-03-22 11:00:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (208, 101, 2, '', '2022-03-22 11:08:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (209, 101, 3, 'X-Ray', '2022-03-22 11:08:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (210, 102, 2, '', '2022-03-22 11:15:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (211, 102, 3, 'X-Ray', '2022-03-22 11:15:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (212, 103, 2, '106', '2022-03-22 11:47:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (213, 103, 3, 'X-Ray', '2022-03-22 11:47:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (214, 124, 1, '', '2022-03-22 11:57:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (215, 104, 2, '', '2022-03-22 12:01:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (216, 104, 3, 'X-Ray', '2022-03-22 12:01:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (217, 105, 2, '106', '2022-03-22 12:05:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (218, 105, 3, 'USG', '2022-03-22 12:05:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (219, 106, 2, '', '2022-03-22 12:24:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (220, 106, 3, 'USG', '2022-03-22 12:24:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (221, 107, 2, '', '2022-03-22 13:15:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (222, 107, 3, 'USG', '2022-03-22 13:15:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (223, 125, 1, '107', '2022-03-22 13:16:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (224, 108, 2, '', '2022-03-22 13:53:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (225, 108, 3, 'X-Ray', '2022-03-22 13:53:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (226, 126, 1, '', '2022-03-22 16:15:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (227, 127, 1, '', '2022-03-22 17:00:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (228, 109, 2, '', '2022-03-22 17:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (229, 109, 3, 'USG', '2022-03-22 17:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (230, 110, 2, '', '2022-03-22 17:16:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (231, 110, 3, 'X-Ray', '2022-03-22 17:16:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (232, 111, 2, '', '2022-03-22 17:41:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (233, 111, 3, 'X-Ray', '2022-03-22 17:41:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (234, 112, 2, '', '2022-03-22 17:42:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (235, 112, 3, 'USG', '2022-03-22 17:42:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (236, 113, 2, '', '2022-03-22 18:16:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (237, 113, 3, 'X-Ray', '2022-03-22 18:16:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (238, 114, 2, '', '2022-03-22 19:38:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (239, 114, 3, 'USG', '2022-03-22 19:38:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (240, 128, 1, '', '2022-03-22 19:49:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (241, 115, 2, '', '2022-03-22 19:50:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (242, 115, 3, 'X-Ray', '2022-03-22 19:50:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (243, 129, 1, '107', '2022-03-22 19:52:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (244, 116, 2, '', '2022-03-22 19:53:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (245, 116, 3, 'USG', '2022-03-22 19:53:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (246, 130, 1, '107', '2022-03-23 09:02:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (247, 131, 1, '', '2022-03-23 09:44:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (248, 132, 1, '', '2022-03-23 09:50:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (249, 117, 2, '', '2022-03-23 09:52:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (250, 117, 3, 'X-Ray', '2022-03-23 09:52:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (251, 133, 1, '', '2022-03-23 09:57:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (252, 118, 2, '', '2022-03-23 10:30:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (253, 118, 3, 'X-Ray', '2022-03-23 10:30:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (254, 134, 1, '', '2022-03-23 11:20:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (255, 119, 2, '', '2022-03-23 11:26:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (256, 119, 3, 'USG', '2022-03-23 11:26:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (257, 120, 2, '', '2022-03-23 11:28:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (258, 120, 3, 'X-Ray', '2022-03-23 11:28:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (259, 121, 2, '', '2022-03-23 11:31:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (260, 121, 3, 'X-Ray', '2022-03-23 11:31:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (261, 122, 2, '', '2022-03-23 12:02:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (262, 122, 3, 'X-Ray', '2022-03-23 12:02:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (263, 123, 2, '', '2022-03-23 12:32:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (264, 123, 3, 'X-Ray', '2022-03-23 12:32:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (265, 124, 2, '', '2022-03-23 12:49:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (266, 124, 3, 'X-Ray', '2022-03-23 12:49:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (267, 125, 2, '', '2022-03-23 13:12:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (268, 125, 3, 'USG', '2022-03-23 13:12:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (269, 126, 2, '', '2022-03-23 13:32:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (270, 126, 3, 'X-Ray', '2022-03-23 13:32:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (271, 127, 2, '', '2022-03-23 17:01:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (272, 127, 3, 'X-Ray', '2022-03-23 17:01:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (273, 128, 2, '', '2022-03-23 17:26:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (274, 128, 3, 'X-Ray', '2022-03-23 17:26:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (275, 135, 1, '', '2022-03-23 17:52:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (276, 129, 2, '', '2022-03-23 17:53:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (277, 129, 3, 'USG', '2022-03-23 17:53:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (278, 130, 2, '', '2022-03-23 18:15:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (279, 130, 3, 'X-Ray', '2022-03-23 18:15:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (280, 136, 1, '', '2022-03-24 09:17:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (281, 137, 1, '', '2022-03-24 09:32:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (282, 138, 1, '', '2022-03-24 10:12:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (283, 131, 2, '', '2022-03-24 10:14:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (284, 131, 3, 'X-Ray', '2022-03-24 10:14:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (285, 139, 1, '', '2022-03-24 11:01:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (286, 132, 2, '', '2022-03-24 11:15:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (287, 132, 3, 'X-Ray', '2022-03-24 11:15:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (288, 133, 2, '', '2022-03-24 11:17:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (289, 133, 3, 'X-Ray', '2022-03-24 11:17:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (290, 134, 2, '', '2022-03-24 11:27:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (291, 134, 3, 'USG', '2022-03-24 11:27:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (292, 135, 2, '', '2022-03-24 12:13:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (293, 135, 3, 'X-Ray', '2022-03-24 12:13:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (294, 140, 1, '', '2022-03-24 13:04:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (295, 141, 1, '', '2022-03-24 13:09:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (296, 136, 2, '', '2022-03-24 13:11:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (297, 136, 3, 'X-Ray', '2022-03-24 13:11:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (298, 137, 2, '', '2022-03-24 13:12:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (299, 137, 3, 'X-Ray', '2022-03-24 13:12:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (300, 138, 2, '', '2022-03-24 13:12:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (301, 138, 3, 'USG', '2022-03-24 13:12:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (302, 139, 2, '', '2022-03-24 16:49:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (303, 139, 3, 'X-Ray', '2022-03-24 16:49:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (304, 140, 2, '', '2022-03-24 17:27:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (305, 140, 3, 'X-Ray', '2022-03-24 17:27:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (306, 141, 2, '101', '2022-03-24 17:39:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (307, 141, 3, 'ECG', '2022-03-24 17:39:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (308, 142, 1, '', '2022-03-24 17:41:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (309, 142, 2, '', '2022-03-24 17:53:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (310, 142, 3, 'USG', '2022-03-24 17:53:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (311, 143, 2, '', '2022-03-24 18:05:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (312, 143, 3, 'X-Ray', '2022-03-24 18:05:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (313, 143, 1, '107', '2022-03-24 18:17:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (314, 144, 2, '', '2022-03-24 18:20:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (315, 144, 3, 'USG', '2022-03-24 18:20:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (316, 144, 1, '', '2022-03-24 19:21:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (317, 145, 1, '', '2022-03-24 19:34:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (318, 145, 2, '', '2022-03-24 19:51:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (319, 145, 3, 'X-Ray', '2022-03-24 19:51:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (320, 146, 2, '', '2022-03-24 19:53:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (321, 146, 3, 'X-Ray', '2022-03-24 19:53:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (322, 146, 1, '', '2022-03-24 19:54:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (323, 147, 2, '', '2022-03-24 19:57:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (324, 147, 3, 'X-Ray', '2022-03-24 19:57:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (325, 147, 1, '', '2022-03-24 20:01:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (326, 148, 2, '', '2022-03-24 20:02:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (327, 148, 3, 'X-Ray', '2022-03-24 20:02:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (328, 148, 1, '', '2022-03-24 20:08:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (329, 149, 1, '', '2022-03-24 20:09:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (330, 149, 2, '', '2022-03-24 20:11:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (331, 149, 3, 'X-Ray', '2022-03-24 20:11:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (332, 150, 2, '', '2022-03-24 20:18:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (333, 150, 3, 'USG', '2022-03-24 20:18:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (334, 150, 1, '107', '2022-03-24 20:20:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (335, 151, 1, '', '2022-03-24 20:22:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (336, 151, 2, '', '2022-03-24 20:45:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (337, 151, 3, 'USG', '2022-03-24 20:45:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (338, 152, 1, '', '2022-03-24 20:46:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (339, 153, 1, '', '2022-03-24 20:46:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (340, 152, 2, '', '2022-03-24 20:47:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (341, 152, 3, 'USG', '2022-03-24 20:47:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (342, 153, 2, '', '2022-03-24 20:49:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (343, 153, 3, 'USG', '2022-03-24 20:49:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (344, 0, 1, '', '2022-03-24 21:03:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (345, 155, 1, '', '2022-03-24 21:00:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (346, 154, 1, '', '2022-03-24 21:03:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (347, 154, 2, '', '2022-03-24 21:03:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (348, 154, 3, 'X-Ray', '2022-03-24 21:03:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (349, 155, 2, '', '2022-03-24 21:10:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (350, 155, 3, 'X-Ray', '2022-03-24 21:10:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (351, 156, 2, '', '2022-03-24 21:12:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (352, 156, 3, 'X-Ray', '2022-03-24 21:12:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (353, 157, 2, '', '2022-03-24 21:14:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (354, 157, 3, 'X-Ray', '2022-03-24 21:14:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (355, 156, 1, '', '2022-03-24 21:27:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (356, 157, 1, '', '2022-03-24 21:42:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (357, 158, 1, '', '2022-03-25 07:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (358, 159, 1, '', '2022-03-25 08:37:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (359, 160, 1, '', '2022-03-25 09:19:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (360, 161, 1, '', '2022-03-25 09:31:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (361, 162, 1, '', '2022-03-25 09:33:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (362, 163, 1, '', '2022-03-25 09:50:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (363, 164, 1, '', '2022-03-25 09:57:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (364, 165, 1, '107', '2022-03-25 09:59:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (365, 166, 1, '', '2022-03-25 10:03:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (366, 158, 2, '', '2022-03-25 10:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (367, 158, 3, 'ECG', '2022-03-25 10:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (368, 167, 1, '', '2022-03-25 10:06:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (369, 168, 1, '', '2022-03-25 10:09:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (370, 169, 1, '107', '2022-03-25 10:12:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (371, 159, 2, '', '2022-03-25 10:13:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (372, 159, 3, 'ECG', '2022-03-25 10:13:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (373, 0, 1, '', '2022-03-25 11:46:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (374, 0, 2, '', '2022-03-25 11:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (375, 0, 3, 'ECG', '2022-03-25 11:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (376, 0, 1, '', '2022-03-25 11:43:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (377, 161, 2, '', '2022-03-25 10:28:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (378, 161, 3, 'ECG', '2022-03-25 10:28:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (379, 172, 1, '', '2022-03-25 10:31:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (380, 162, 2, '', '2022-03-25 10:32:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (381, 162, 3, 'USG', '2022-03-25 10:32:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (382, 173, 1, '', '2022-03-25 10:35:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (383, 174, 1, '', '2022-03-25 10:40:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (384, 163, 2, '', '2022-03-25 10:49:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (385, 163, 3, 'X-Ray', '2022-03-25 10:49:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (386, 164, 2, '', '2022-03-25 10:52:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (387, 164, 3, 'X-Ray', '2022-03-25 10:52:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (388, 165, 2, '', '2022-03-25 10:54:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (389, 165, 3, 'X-Ray', '2022-03-25 10:54:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (390, 166, 2, '', '2022-03-25 10:55:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (391, 166, 3, 'X-Ray', '2022-03-25 10:55:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (392, 167, 2, '', '2022-03-25 10:55:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (393, 167, 3, 'X-Ray', '2022-03-25 10:55:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (394, 168, 2, '106', '2022-03-25 11:02:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (395, 168, 3, 'X-Ray', '2022-03-25 11:02:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (396, 0, 2, '', '2022-03-25 11:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (397, 0, 3, 'X-Ray', '2022-03-25 11:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (398, 170, 2, '', '2022-03-25 11:05:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (399, 170, 3, 'X-Ray', '2022-03-25 11:05:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (400, 171, 2, '', '2022-03-25 11:12:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (401, 171, 3, 'X-Ray', '2022-03-25 11:12:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (402, 175, 1, '', '2022-03-25 11:23:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (403, 176, 1, '', '2022-03-25 11:30:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (404, 177, 1, '', '2022-03-25 11:38:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (405, 172, 2, '', '2022-03-25 11:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (406, 172, 3, 'X-Ray', '2022-03-25 11:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (407, 171, 1, '', '2022-03-25 11:43:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (408, 169, 2, '', '2022-03-25 11:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (409, 169, 3, 'X-Ray', '2022-03-25 11:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (410, 178, 1, '', '2022-03-25 11:44:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (411, 170, 1, '', '2022-03-25 11:46:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (412, 179, 1, '', '2022-03-25 11:46:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (413, 160, 2, '', '2022-03-25 11:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (414, 160, 3, 'ECG', '2022-03-25 11:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (415, 180, 1, '', '2022-03-25 11:48:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (416, 173, 2, '', '2022-03-25 11:49:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (417, 173, 3, 'USG', '2022-03-25 11:49:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (418, 174, 2, '', '2022-03-25 11:50:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (419, 174, 3, 'X-Ray', '2022-03-25 11:50:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (420, 181, 1, '', '2022-03-25 11:51:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (421, 182, 1, '', '2022-03-25 11:53:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (422, 183, 1, '', '2022-03-25 12:09:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (423, 175, 2, '', '2022-03-25 12:11:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (424, 175, 3, 'USG', '2022-03-25 12:11:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (425, 176, 2, '', '2022-03-25 12:12:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (426, 176, 3, 'X-Ray', '2022-03-25 12:12:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (427, 184, 1, '', '2022-03-25 12:12:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (428, 177, 2, '', '2022-03-25 12:15:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (429, 177, 3, 'X-Ray', '2022-03-25 12:15:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (430, 178, 2, '', '2022-03-25 12:16:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (431, 178, 3, 'ECG', '2022-03-25 12:16:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (432, 185, 1, '', '2022-03-25 12:17:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (433, 179, 2, '', '2022-03-25 12:18:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (434, 179, 3, 'X-Ray', '2022-03-25 12:18:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (435, 180, 2, '', '2022-03-25 12:20:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (436, 180, 3, 'ECG', '2022-03-25 12:20:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (437, 186, 1, '', '2022-03-25 12:31:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (438, 187, 1, '', '2022-03-25 12:37:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (439, 181, 2, '', '2022-03-25 12:38:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (440, 181, 3, 'X-Ray', '2022-03-25 12:38:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (441, 182, 2, '', '2022-03-25 12:41:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (442, 182, 3, 'ECG', '2022-03-25 12:41:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (443, 0, 1, '', '2022-03-25 16:01:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (444, 189, 1, '', '2022-03-25 12:53:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (445, 183, 2, '', '2022-03-25 12:54:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (446, 183, 3, 'USG', '2022-03-25 12:54:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (447, 190, 1, '', '2022-03-25 12:57:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (448, 184, 2, '', '2022-03-25 12:58:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (449, 184, 3, 'ECG', '2022-03-25 12:58:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (450, 191, 1, '', '2022-03-25 13:10:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (451, 185, 2, '', '2022-03-25 13:11:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (452, 185, 3, 'X-Ray', '2022-03-25 13:11:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (453, 192, 1, '', '2022-03-25 13:15:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (454, 193, 1, '', '2022-03-25 13:38:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (455, 194, 1, '', '2022-03-25 13:44:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (456, 186, 2, '', '2022-03-25 13:45:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (457, 186, 3, 'USG', '2022-03-25 13:45:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (458, 187, 2, '', '2022-03-25 13:46:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (459, 187, 3, 'X-Ray', '2022-03-25 13:46:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (460, 188, 2, '', '2022-03-25 13:47:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (461, 188, 3, 'ECG', '2022-03-25 13:47:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (462, 195, 1, '', '2022-03-25 13:52:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (463, 189, 2, '', '2022-03-25 13:54:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (464, 189, 3, 'X-Ray', '2022-03-25 13:54:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (465, 190, 2, '', '2022-03-25 14:03:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (466, 190, 3, 'X-Ray', '2022-03-25 14:03:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (467, 196, 1, '', '2022-03-25 15:40:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (468, 197, 1, '', '2022-03-25 15:57:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (469, 188, 1, '', '2022-03-25 16:01:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (470, 191, 2, '', '2022-03-25 16:09:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (471, 191, 3, 'X-Ray', '2022-03-25 16:09:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (472, 198, 1, '', '2022-03-25 16:37:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (473, 192, 2, '', '2022-03-25 16:39:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (474, 192, 3, 'X-Ray', '2022-03-25 16:39:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (475, 193, 2, '', '2022-03-25 16:40:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (476, 193, 3, 'USG', '2022-03-25 16:40:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (477, 194, 2, '', '2022-03-25 16:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (478, 194, 3, 'X-Ray', '2022-03-25 16:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (479, 195, 2, '', '2022-03-25 17:30:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (480, 195, 3, 'ECG', '2022-03-25 17:30:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (481, 199, 1, '', '2022-03-25 17:39:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (482, 196, 2, '', '2022-03-25 17:42:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (483, 196, 3, 'X-Ray', '2022-03-25 17:42:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (484, 197, 2, '', '2022-03-25 17:59:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (485, 197, 3, 'X-Ray', '2022-03-25 17:59:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (486, 200, 1, '', '2022-03-25 18:03:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (487, 198, 2, '', '2022-03-25 18:04:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (488, 198, 3, 'USG', '2022-03-25 18:04:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (489, 201, 1, '', '2022-03-25 18:09:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (490, 199, 2, '', '2022-03-25 18:11:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (491, 199, 3, 'X-Ray', '2022-03-25 18:11:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (492, 200, 2, '', '2022-03-25 18:44:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (493, 200, 3, 'X-Ray', '2022-03-25 18:44:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (494, 201, 2, '', '2022-03-25 19:16:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (495, 201, 3, 'X-Ray', '2022-03-25 19:16:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (496, 202, 2, '', '2022-03-25 19:38:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (497, 202, 3, 'X-Ray', '2022-03-25 19:38:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (498, 202, 1, '', '2022-03-25 20:34:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (499, 203, 2, '', '2022-03-25 20:36:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (500, 203, 3, 'ECG', '2022-03-25 20:36:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (501, 204, 2, '', '2022-03-25 20:41:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (502, 204, 3, 'X-Ray', '2022-03-25 20:41:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (503, 205, 2, '', '2022-03-25 20:44:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (504, 205, 3, 'X-Ray', '2022-03-25 20:44:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (505, 206, 2, '', '2022-03-25 20:53:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (506, 206, 3, 'X-Ray', '2022-03-25 20:53:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (507, 207, 2, '', '2022-03-25 21:05:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (508, 207, 3, 'USG', '2022-03-25 21:05:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (509, 208, 2, '', '2022-03-25 21:39:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (510, 208, 3, 'X-Ray', '2022-03-25 21:39:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (511, 209, 2, '', '2022-03-25 21:46:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (512, 209, 3, 'USG', '2022-03-25 21:46:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (513, 203, 1, '', '2022-03-26 09:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (514, 210, 2, '', '2022-03-26 10:05:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (515, 210, 3, 'X-Ray', '2022-03-26 10:05:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (516, 204, 1, '', '2022-03-26 10:16:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (517, 211, 2, '', '2022-03-26 10:17:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (518, 211, 3, 'USG', '2022-03-26 10:17:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (519, 212, 2, '', '2022-03-26 10:42:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (520, 212, 3, 'X-Ray', '2022-03-26 10:42:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (521, 213, 2, '', '2022-03-26 10:49:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (522, 213, 3, 'X-Ray', '2022-03-26 10:49:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (523, 205, 1, '', '2022-03-26 10:50:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (524, 206, 1, '', '2022-03-26 10:53:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (525, 207, 1, '', '2022-03-26 11:13:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (526, 208, 1, '107', '2022-03-26 11:47:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (527, 214, 2, '', '2022-03-26 11:56:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (528, 214, 3, 'X-Ray', '2022-03-26 11:56:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (529, 215, 2, '', '2022-03-26 12:13:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (530, 215, 3, 'USG', '2022-03-26 12:13:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (531, 209, 1, '', '2022-03-26 12:13:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (532, 210, 1, '107', '2022-03-26 12:14:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (533, 216, 2, '', '2022-03-26 12:17:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (534, 216, 3, 'X-Ray', '2022-03-26 12:17:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (535, 217, 2, '', '2022-03-26 12:27:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (536, 217, 3, 'USG', '2022-03-26 12:27:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (537, 211, 1, '', '2022-03-26 12:28:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (538, 218, 2, '', '2022-03-26 13:33:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (539, 218, 3, 'X-Ray', '2022-03-26 13:33:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (540, 212, 1, '107', '2022-03-26 13:42:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (541, 219, 2, '', '2022-03-26 13:44:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (542, 219, 3, 'ECG', '2022-03-26 13:44:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (543, 220, 2, '', '2022-03-26 13:45:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (544, 220, 3, 'X-Ray', '2022-03-26 13:45:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (545, 213, 1, '', '2022-03-26 15:14:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (546, 221, 2, '', '2022-03-26 16:49:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (547, 221, 3, 'X-Ray', '2022-03-26 16:49:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (548, 222, 2, '', '2022-03-26 17:19:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (549, 222, 3, 'USG', '2022-03-26 17:19:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (550, 223, 2, '', '2022-03-26 17:57:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (551, 223, 3, 'X-Ray', '2022-03-26 17:57:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (552, 214, 1, '', '2022-03-26 18:00:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (553, 215, 1, '', '2022-03-26 18:02:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (554, 224, 2, '', '2022-03-26 18:51:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (555, 224, 3, 'X-Ray', '2022-03-26 18:51:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (556, 225, 2, '', '2022-03-26 19:18:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (557, 225, 3, 'X-Ray', '2022-03-26 19:18:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (558, 216, 1, '', '2022-03-26 19:26:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (559, 226, 2, '', '2022-03-26 19:27:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (560, 226, 3, 'ECG', '2022-03-26 19:27:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (561, 227, 2, '', '2022-03-26 19:47:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (562, 227, 3, 'ECG', '2022-03-26 19:47:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (563, 228, 2, '', '2022-03-26 20:30:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (564, 228, 3, 'X-Ray', '2022-03-26 20:30:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (565, 229, 2, '', '2022-03-27 08:49:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (566, 229, 3, 'ECG', '2022-03-27 08:49:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (567, 230, 2, '', '2022-03-27 09:35:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (568, 230, 3, 'ECG', '2022-03-27 09:35:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (569, 231, 2, '', '2022-03-27 09:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (570, 231, 3, 'X-Ray', '2022-03-27 09:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (571, 217, 1, '', '2022-03-27 10:45:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (572, 232, 2, '', '2022-03-27 10:46:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (573, 232, 3, 'USG', '2022-03-27 10:46:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (574, 233, 2, '', '2022-03-27 11:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (575, 233, 3, 'X-Ray', '2022-03-27 11:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (576, 234, 2, '', '2022-03-27 12:06:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (577, 234, 3, 'X-Ray', '2022-03-27 12:06:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (578, 218, 1, '107', '2022-03-27 12:16:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (579, 219, 1, '', '2022-03-27 13:29:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (580, 235, 2, '', '2022-03-27 14:27:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (581, 235, 3, 'X-Ray', '2022-03-27 14:27:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (582, 220, 1, '', '2022-03-27 15:33:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (583, 236, 2, '', '2022-03-27 15:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (584, 236, 3, 'X-Ray', '2022-03-27 15:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (585, 221, 1, '', '2022-03-27 15:55:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (586, 237, 2, '', '2022-03-27 16:00:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (587, 237, 3, 'X-Ray', '2022-03-27 16:00:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (588, 238, 2, '', '2022-03-27 16:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (589, 238, 3, 'X-Ray', '2022-03-27 16:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (590, 239, 2, '', '2022-03-27 17:31:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (591, 239, 3, 'X-Ray', '2022-03-27 17:31:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (592, 240, 2, '', '2022-03-27 17:39:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (593, 240, 3, 'X-Ray', '2022-03-27 17:39:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (594, 222, 1, '', '2022-03-27 17:40:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (595, 241, 2, '', '2022-03-27 17:54:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (596, 241, 3, 'X-Ray', '2022-03-27 17:54:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (597, 223, 1, '', '2022-03-27 18:05:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (598, 242, 2, '', '2022-03-27 18:06:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (599, 242, 3, 'USG', '2022-03-27 18:06:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (600, 243, 2, '', '2022-03-27 18:24:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (601, 243, 3, 'X-Ray', '2022-03-27 18:24:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (602, 224, 1, '', '2022-03-27 19:01:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (603, 244, 2, '', '2022-03-27 19:02:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (604, 244, 3, 'USG', '2022-03-27 19:02:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (605, 225, 1, '', '2022-03-27 19:07:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (606, 245, 2, '', '2022-03-27 19:21:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (607, 245, 3, 'X-Ray', '2022-03-27 19:21:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (608, 226, 1, '', '2022-03-27 19:28:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (609, 246, 2, '', '2022-03-27 19:29:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (610, 246, 3, 'USG', '2022-03-27 19:29:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (611, 227, 1, '', '2022-03-27 19:32:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (612, 247, 2, '', '2022-03-27 19:37:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (613, 247, 3, 'X-Ray', '2022-03-27 19:37:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (614, 248, 2, '', '2022-03-27 19:47:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (615, 248, 3, 'X-Ray', '2022-03-27 19:47:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (616, 249, 2, '', '2022-03-27 20:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (617, 249, 3, 'ECG', '2022-03-27 20:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (618, 228, 1, '', '2022-03-28 10:40:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (619, 250, 2, '', '2022-03-28 10:46:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (620, 250, 3, 'X-Ray', '2022-03-28 10:46:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (621, 251, 2, '', '2022-03-28 10:49:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (622, 251, 3, 'X-Ray', '2022-03-28 10:49:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (623, 252, 2, '', '2022-03-28 10:56:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (624, 252, 3, 'X-Ray', '2022-03-28 10:56:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (625, 253, 2, '', '2022-03-28 11:27:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (626, 253, 3, 'USG', '2022-03-28 11:27:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (627, 229, 1, '', '2022-03-28 11:31:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (628, 230, 1, '', '2022-03-28 12:18:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (629, 231, 1, '', '2022-03-28 12:32:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (630, 254, 2, '', '2022-03-28 12:34:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (631, 254, 3, 'X-Ray', '2022-03-28 12:34:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (632, 255, 2, '', '2022-03-28 13:39:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (633, 255, 3, 'USG', '2022-03-28 13:39:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (634, 256, 2, '', '2022-03-28 15:23:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (635, 256, 3, 'USG', '2022-03-28 15:23:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (636, 232, 1, '107', '2022-03-28 17:43:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (637, 257, 2, '', '2022-03-28 19:33:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (638, 257, 3, 'X-Ray', '2022-03-28 19:33:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (639, 233, 1, '', '2022-03-28 19:58:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (640, 258, 2, '', '2022-03-28 19:58:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (641, 258, 3, 'USG', '2022-03-28 19:58:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (642, 234, 1, '', '2022-03-28 20:24:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (643, 259, 2, '', '2022-03-28 21:09:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (644, 259, 3, 'X-Ray', '2022-03-28 21:09:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (645, 235, 1, '', '2022-03-28 22:52:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (646, 236, 1, '', '2022-03-29 06:48:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (647, 260, 2, '', '2022-03-29 08:24:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (648, 260, 3, 'USG', '2022-03-29 08:24:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (649, 261, 2, '', '2022-03-29 09:50:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (650, 261, 3, 'X-Ray', '2022-03-29 09:50:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (651, 262, 2, '', '2022-03-29 09:58:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (652, 262, 3, 'X-Ray', '2022-03-29 09:58:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (653, 263, 2, '', '2022-03-29 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (654, 263, 3, 'X-Ray', '2022-03-29 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (655, 264, 2, '', '2022-03-29 10:00:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (656, 264, 3, 'X-Ray', '2022-03-29 10:00:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (657, 0, 1, '', '2022-03-29 10:47:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (658, 0, 1, '', '2022-03-29 10:50:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (659, 237, 1, '', '2022-03-29 10:50:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (660, 238, 1, '', '2022-03-29 10:51:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (661, 265, 2, '', '2022-03-29 10:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (662, 265, 3, 'X-Ray', '2022-03-29 10:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (663, 266, 2, '', '2022-03-29 11:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (664, 266, 3, 'X-Ray', '2022-03-29 11:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (665, 267, 2, '', '2022-03-29 12:43:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (666, 267, 3, 'USG', '2022-03-29 12:43:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (667, 268, 2, '', '2022-03-29 14:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (668, 268, 3, 'ECG', '2022-03-29 14:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (669, 269, 2, '', '2022-03-29 14:39:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (670, 269, 3, 'X-Ray', '2022-03-29 14:39:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (671, 270, 2, '106', '2022-03-29 17:16:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (672, 270, 3, 'X-Ray', '2022-03-29 17:16:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (673, 271, 2, '106', '2022-03-29 17:24:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (674, 271, 3, 'USG', '2022-03-29 17:24:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (675, 239, 1, '107', '2022-03-29 17:24:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (676, 240, 1, '', '2022-03-29 17:37:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (677, 272, 2, '', '2022-03-29 18:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (678, 272, 3, 'X-Ray', '2022-03-29 18:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (682, 274, 2, '', '2022-03-29 20:25:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (683, 274, 3, 'USG', '2022-03-29 20:25:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (684, 275, 2, '', '2022-03-29 20:41:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (685, 275, 3, '', '2022-03-29 20:41:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (692, 244, 1, '', '2022-03-30 08:42:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (693, 278, 2, '', '2022-03-30 10:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (694, 278, 3, 'X-Ray', '2022-03-30 10:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (695, 279, 2, '', '2022-03-30 10:57:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (696, 279, 3, 'X-Ray', '2022-03-30 10:57:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (697, 280, 2, '', '2022-03-30 11:19:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (698, 280, 3, '', '2022-03-30 11:19:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (699, 245, 1, '', '2022-03-30 13:20:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (700, 281, 2, '101', '2022-03-30 13:57:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (701, 281, 3, 'X-Ray', '2022-03-30 13:57:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (702, 282, 2, '', '2022-03-30 15:57:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (703, 282, 3, '', '2022-03-30 15:57:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (704, 246, 1, '', '2022-03-30 16:59:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (705, 283, 2, '', '2022-03-30 16:59:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (706, 283, 3, '', '2022-03-30 16:59:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (707, 247, 1, '', '2022-03-30 17:39:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (708, 248, 1, '', '2022-03-30 18:04:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (709, 284, 2, '', '2022-03-30 18:05:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (710, 284, 3, '', '2022-03-30 18:05:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (711, 249, 1, '', '2022-03-30 18:13:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (712, 285, 2, '', '2022-03-30 19:02:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (713, 285, 3, '', '2022-03-30 19:02:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (714, 250, 1, '', '2022-03-30 19:40:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (715, 286, 2, '', '2022-03-30 19:52:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (716, 286, 3, '', '2022-03-30 19:52:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (717, 251, 1, '', '2022-03-30 21:20:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (718, 287, 2, '', '2022-03-30 22:02:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (719, 287, 3, 'X-Ray', '2022-03-30 22:02:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (720, 288, 2, '', '2022-03-30 22:48:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (721, 288, 3, 'X-Ray', '2022-03-30 22:48:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (722, 252, 1, '', '2022-03-31 08:16:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (723, 289, 2, '', '2022-03-31 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (724, 289, 3, '', '2022-03-31 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (725, 290, 2, '', '2022-03-31 10:07:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (726, 290, 3, '', '2022-03-31 10:07:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (727, 291, 2, '106', '2022-03-31 10:20:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (728, 291, 3, 'USG', '2022-03-31 10:20:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (729, 292, 2, '', '2022-03-31 10:38:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (730, 292, 3, '', '2022-03-31 10:38:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (731, 293, 2, '', '2022-03-31 10:53:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (732, 293, 3, 'USG', '2022-03-31 10:53:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (733, 294, 2, '', '2022-03-31 11:54:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (734, 294, 3, 'X-Ray', '2022-03-31 11:54:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (735, 253, 1, '', '2022-03-31 11:56:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (736, 295, 2, '', '2022-03-31 11:58:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (737, 295, 3, '', '2022-03-31 11:58:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (738, 254, 1, '', '2022-03-31 12:39:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (739, 296, 2, '', '2022-03-31 13:28:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (740, 296, 3, '', '2022-03-31 13:28:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (741, 255, 1, '', '2022-03-31 13:31:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (742, 297, 2, '', '2022-03-31 13:59:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (743, 297, 3, 'USG', '2022-03-31 13:59:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (744, 256, 1, '107', '2022-03-31 14:16:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (745, 298, 2, '', '2022-03-31 15:39:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (746, 298, 3, '', '2022-03-31 15:39:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (747, 257, 1, '107', '2022-03-31 16:17:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (748, 258, 1, '', '2022-03-31 16:34:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (749, 299, 2, '', '2022-03-31 16:35:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (750, 299, 3, '', '2022-03-31 16:35:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (751, 0, 2, '', '2022-03-31 21:35:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (752, 0, 3, '', '2022-03-31 21:35:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (753, 259, 1, '', '2022-03-31 17:16:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (754, 301, 2, '', '2022-03-31 17:16:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (755, 301, 3, 'X-Ray', '2022-03-31 17:16:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (756, 302, 2, '', '2022-03-31 17:18:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (757, 302, 3, '', '2022-03-31 17:18:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (758, 303, 2, '', '2022-03-31 17:20:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (759, 303, 3, '', '2022-03-31 17:20:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (760, 260, 1, '', '2022-03-31 17:25:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (761, 304, 2, '', '2022-03-31 17:31:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (762, 304, 3, '', '2022-03-31 17:31:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (763, 261, 1, '', '2022-03-31 17:32:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (764, 305, 2, '', '2022-03-31 17:36:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (765, 305, 3, '', '2022-03-31 17:36:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (766, 262, 1, '', '2022-03-31 17:44:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (767, 306, 2, '', '2022-03-31 17:44:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (768, 306, 3, '', '2022-03-31 17:44:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (769, 307, 2, '', '2022-03-31 17:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (770, 307, 3, '', '2022-03-31 17:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (771, 308, 2, '', '2022-03-31 17:53:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (772, 308, 3, '', '2022-03-31 17:53:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (773, 263, 1, '', '2022-03-31 17:54:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (774, 264, 1, '', '2022-03-31 17:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (775, 309, 2, '', '2022-03-31 17:56:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (776, 309, 3, '', '2022-03-31 17:56:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (777, 265, 1, '', '2022-03-31 18:03:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (778, 310, 2, '', '2022-03-31 18:04:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (779, 310, 3, '', '2022-03-31 18:04:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (780, 266, 1, '', '2022-03-31 18:07:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (781, 311, 2, '', '2022-03-31 18:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (782, 311, 3, '', '2022-03-31 18:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (783, 267, 1, '', '2022-03-31 18:22:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (784, 312, 2, '', '2022-03-31 18:34:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (785, 312, 3, '', '2022-03-31 18:34:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (786, 268, 1, '', '2022-03-31 18:35:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (787, 269, 1, '', '2022-03-31 18:40:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (788, 313, 2, '', '2022-03-31 18:44:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (789, 313, 3, '', '2022-03-31 18:44:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (790, 270, 1, '', '2022-03-31 18:46:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (791, 271, 1, '', '2022-03-31 19:09:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (792, 272, 1, '', '2022-03-31 19:27:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (793, 273, 1, '', '2022-03-31 19:31:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (794, 314, 2, '', '2022-03-31 19:43:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (795, 314, 3, '', '2022-03-31 19:43:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (796, 315, 2, '', '2022-03-31 19:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (797, 315, 3, 'X-Ray', '2022-03-31 19:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (798, 274, 1, '', '2022-03-31 20:08:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (799, 275, 1, '', '2022-03-31 20:24:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (800, 276, 1, '', '2022-03-31 20:35:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (801, 316, 2, '', '2022-03-31 20:36:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (802, 316, 3, '', '2022-03-31 20:36:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (803, 277, 1, '', '2022-03-31 20:37:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (804, 278, 1, '', '2022-03-31 20:49:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (805, 279, 1, '', '2022-03-31 20:58:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (806, 317, 2, '', '2022-03-31 20:58:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (807, 317, 3, '', '2022-03-31 20:58:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (808, 318, 2, '', '2022-03-31 20:59:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (809, 318, 3, '', '2022-03-31 20:59:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (810, 319, 2, '', '2022-03-31 21:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (811, 319, 3, '', '2022-03-31 21:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (812, 320, 2, '', '2022-03-31 21:05:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (813, 320, 3, '', '2022-03-31 21:05:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (814, 321, 2, '', '2022-03-31 21:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (815, 321, 3, '', '2022-03-31 21:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (816, 280, 1, '', '2022-03-31 21:19:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (817, 322, 2, '', '2022-03-31 21:21:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (818, 322, 3, '', '2022-03-31 21:21:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (819, 281, 1, '', '2022-03-31 21:22:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (820, 282, 1, '', '2022-03-31 21:24:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (821, 323, 2, '', '2022-03-31 21:25:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (822, 323, 3, '', '2022-03-31 21:25:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (823, 0, 2, '', '2022-03-31 21:37:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (824, 0, 3, '', '2022-03-31 21:37:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (825, 324, 2, '', '2022-03-31 21:36:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (826, 324, 3, '', '2022-03-31 21:36:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (829, 283, 1, '', '2022-03-31 21:40:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (830, 325, 2, '', '2022-03-31 22:11:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (831, 325, 3, '', '2022-03-31 22:11:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (832, 284, 1, '', '2022-03-31 22:18:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (833, 326, 2, '', '2022-03-31 22:19:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (834, 326, 3, '', '2022-03-31 22:19:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (835, 285, 1, '', '2022-03-31 23:04:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (836, 327, 2, '', '2022-03-31 23:05:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (837, 327, 3, '', '2022-03-31 23:05:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (838, 286, 1, '', '2022-04-01 08:30:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (839, 287, 1, '', '2022-04-01 08:50:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (840, 328, 2, '', '2022-04-01 09:06:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (841, 328, 3, '', '2022-04-01 09:06:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (842, 288, 1, '', '2022-04-01 09:48:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (843, 289, 1, '', '2022-04-01 09:57:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (844, 329, 2, '', '2022-04-01 09:59:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (845, 329, 3, '', '2022-04-01 09:59:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (846, 290, 1, '', '2022-04-01 10:04:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (847, 291, 1, '', '2022-04-01 10:07:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (848, 292, 1, '', '2022-04-01 10:09:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (849, 293, 1, '', '2022-04-01 10:09:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (850, 330, 2, '', '2022-04-01 10:13:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (851, 330, 3, '', '2022-04-01 10:13:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (852, 294, 1, '', '2022-04-01 10:14:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (853, 295, 1, '', '2022-04-01 10:15:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (854, 331, 2, '', '2022-04-01 10:16:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (855, 331, 3, '', '2022-04-01 10:16:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (856, 332, 2, '', '2022-04-01 10:18:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (857, 332, 3, '', '2022-04-01 10:18:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (858, 296, 1, '', '2022-04-01 10:19:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (859, 297, 1, '', '2022-04-01 10:23:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (860, 333, 2, '', '2022-04-01 10:25:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (861, 333, 3, '', '2022-04-01 10:25:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (862, 298, 1, '', '2022-04-01 10:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (863, 299, 1, '', '2022-04-01 10:43:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (864, 300, 1, '', '2022-04-01 10:44:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (865, 334, 2, '', '2022-04-01 10:44:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (866, 334, 3, '', '2022-04-01 10:44:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (867, 335, 2, '', '2022-04-01 10:45:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (868, 335, 3, '', '2022-04-01 10:45:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (869, 336, 2, '', '2022-04-01 10:52:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (870, 336, 3, '', '2022-04-01 10:52:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (871, 301, 1, '', '2022-04-01 10:55:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (872, 302, 1, '', '2022-04-01 10:57:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (873, 337, 2, '', '2022-04-01 11:02:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (874, 337, 3, '', '2022-04-01 11:02:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (875, 303, 1, '', '2022-04-01 11:04:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (876, 338, 2, '', '2022-04-01 11:05:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (877, 338, 3, '', '2022-04-01 11:05:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (878, 304, 1, '', '2022-04-01 11:10:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (879, 339, 2, '', '2022-04-01 11:12:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (880, 339, 3, '', '2022-04-01 11:12:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (881, 340, 2, '', '2022-04-01 11:12:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (882, 340, 3, '', '2022-04-01 11:12:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (883, 305, 1, '', '2022-04-01 11:16:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (884, 341, 2, '', '2022-04-01 11:18:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (885, 341, 3, '', '2022-04-01 11:18:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (886, 306, 1, '', '2022-04-01 11:28:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (887, 307, 1, '', '2022-04-01 11:31:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (888, 0, 1, '', '2022-04-01 11:48:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (889, 342, 2, '', '2022-04-01 11:40:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (890, 342, 3, '', '2022-04-01 11:40:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (891, 309, 1, '', '2022-04-01 11:43:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (892, 343, 2, '', '2022-04-01 11:43:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (893, 343, 3, '', '2022-04-01 11:43:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (894, 308, 1, '', '2022-04-01 11:48:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (895, 0, 1, '', '2022-04-01 11:54:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (896, 310, 1, '', '2022-04-01 11:54:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (897, 311, 1, '', '2022-04-01 11:59:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (898, 312, 1, '', '2022-04-01 12:00:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (899, 344, 2, '', '2022-04-01 12:49:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (900, 344, 3, '', '2022-04-01 12:49:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (901, 313, 1, '', '2022-04-01 13:01:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (902, 345, 2, '', '2022-04-01 13:23:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (903, 345, 3, '', '2022-04-01 13:23:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (904, 346, 2, '', '2022-04-01 14:41:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (905, 346, 3, '', '2022-04-01 14:41:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (906, 314, 1, '', '2022-04-01 16:12:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (907, 347, 2, '', '2022-04-01 16:19:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (908, 347, 3, '', '2022-04-01 16:19:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (909, 315, 1, '', '2022-04-01 16:20:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (910, 316, 1, '', '2022-04-01 17:10:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (911, 348, 2, '', '2022-04-01 17:11:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (912, 348, 3, '', '2022-04-01 17:11:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (913, 349, 2, '', '2022-04-01 17:30:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (914, 349, 3, '', '2022-04-01 17:30:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (915, 317, 1, '', '2022-04-01 17:38:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (916, 0, 2, '', '2022-04-01 18:12:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (917, 0, 3, '', '2022-04-01 18:12:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (918, 351, 2, '', '2022-04-01 17:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (919, 351, 3, '', '2022-04-01 17:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (920, 0, 2, '', '2022-04-01 20:01:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (921, 0, 3, '', '2022-04-01 20:01:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (922, 352, 2, '', '2022-04-01 18:20:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (923, 352, 3, '', '2022-04-01 18:20:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (924, 353, 2, '', '2022-04-01 18:27:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (925, 353, 3, '', '2022-04-01 18:27:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (926, 318, 1, '', '2022-04-01 18:34:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (927, 354, 2, '', '2022-04-01 19:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (928, 354, 3, '', '2022-04-01 19:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (929, 355, 2, '', '2022-04-01 19:14:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (930, 355, 3, '', '2022-04-01 19:14:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (931, 356, 2, '', '2022-04-01 19:33:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (932, 356, 3, '', '2022-04-01 19:33:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (933, 357, 2, '', '2022-04-01 19:42:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (934, 357, 3, '', '2022-04-01 19:42:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (935, 358, 2, '', '2022-04-01 19:47:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (936, 358, 3, '', '2022-04-01 19:47:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (937, 350, 2, '', '2022-04-01 20:01:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (938, 350, 3, '', '2022-04-01 20:01:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (939, 319, 1, '', '2022-04-01 20:19:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (940, 359, 2, '', '2022-04-01 20:29:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (941, 359, 3, '', '2022-04-01 20:29:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (942, 320, 1, '', '2022-04-01 20:32:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (943, 360, 2, '', '2022-04-01 20:44:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (944, 360, 3, '', '2022-04-01 20:44:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (945, 321, 1, '', '2022-04-01 20:56:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (946, 361, 2, '', '2022-04-01 20:57:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (947, 361, 3, '', '2022-04-01 20:57:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (948, 322, 1, '', '2022-04-01 22:21:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (949, 362, 2, '', '2022-04-02 07:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (950, 362, 3, '', '2022-04-02 07:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (951, 323, 1, '', '2022-04-02 09:28:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (952, 324, 1, '', '2022-04-02 09:34:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (953, 363, 2, '', '2022-04-02 09:36:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (954, 363, 3, '', '2022-04-02 09:36:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (955, 325, 1, '', '2022-04-02 10:31:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (956, 364, 2, '', '2022-04-02 10:41:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (957, 364, 3, '', '2022-04-02 10:41:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (958, 326, 1, '', '2022-04-02 11:07:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (959, 365, 2, '', '2022-04-02 11:09:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (960, 365, 3, '', '2022-04-02 11:09:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (961, 366, 2, '', '2022-04-02 11:11:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (962, 366, 3, '', '2022-04-02 11:11:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (963, 327, 1, '', '2022-04-02 11:14:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (964, 367, 2, '', '2022-04-02 11:16:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (965, 367, 3, '', '2022-04-02 11:16:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (966, 328, 1, '', '2022-04-02 11:28:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (967, 368, 2, '', '2022-04-02 11:35:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (968, 368, 3, '', '2022-04-02 11:35:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (969, 369, 2, '', '2022-04-02 11:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (970, 369, 3, '', '2022-04-02 11:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (971, 329, 1, '', '2022-04-02 12:08:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (972, 370, 2, '', '2022-04-02 12:12:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (973, 370, 3, '', '2022-04-02 12:12:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (974, 330, 1, '', '2022-04-02 12:18:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (975, 371, 2, '', '2022-04-02 12:18:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (976, 371, 3, '', '2022-04-02 12:18:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (977, 331, 1, '', '2022-04-02 12:31:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (978, 372, 2, '', '2022-04-02 12:34:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (979, 372, 3, '', '2022-04-02 12:34:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (980, 373, 2, '', '2022-04-02 12:50:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (981, 373, 3, '', '2022-04-02 12:50:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (982, 374, 2, '', '2022-04-02 13:14:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (983, 374, 3, '', '2022-04-02 13:14:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (984, 332, 1, '', '2022-04-02 13:40:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (985, 375, 2, '', '2022-04-02 13:41:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (986, 375, 3, '', '2022-04-02 13:41:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (987, 376, 2, '', '2022-04-02 14:57:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (988, 376, 3, '', '2022-04-02 14:57:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (989, 333, 1, '', '2022-04-02 16:35:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (990, 377, 2, '', '2022-04-02 17:23:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (991, 377, 3, '', '2022-04-02 17:23:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (992, 378, 2, '', '2022-04-02 17:33:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (993, 378, 3, '', '2022-04-02 17:33:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (994, 379, 2, '', '2022-04-02 17:43:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (995, 379, 3, '', '2022-04-02 17:43:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (996, 334, 1, '', '2022-04-02 17:44:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (997, 335, 1, '', '2022-04-02 18:59:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (998, 336, 1, '', '2022-04-02 19:00:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (999, 337, 1, '', '2022-04-02 19:02:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1000, 0, 1, '', '2022-04-02 21:31:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1001, 380, 2, '', '2022-04-02 19:48:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1002, 380, 3, '', '2022-04-02 19:48:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1003, 381, 2, '', '2022-04-02 20:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1004, 381, 3, '', '2022-04-02 20:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1005, 338, 1, '', '2022-04-02 21:31:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1006, 339, 1, '107', '2022-04-03 09:56:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1007, 382, 2, '101', '2022-04-03 09:58:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1008, 382, 3, 'USG', '2022-04-03 09:58:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1009, 383, 2, '', '2022-04-03 11:18:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1010, 383, 3, '', '2022-04-03 11:18:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1013, 340, 1, '107', '2022-04-03 12:08:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1014, 341, 1, '', '2022-04-03 12:43:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1015, 385, 2, '', '2022-04-03 12:44:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1016, 385, 3, 'ECG', '2022-04-03 12:44:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1017, 386, 2, '101', '2022-04-03 12:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1018, 386, 3, 'USG', '2022-04-03 12:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1019, 342, 1, '107', '2022-04-03 12:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1020, 343, 1, '', '2022-04-03 14:36:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1021, 344, 1, '', '2022-04-03 15:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1022, 387, 2, '', '2022-04-03 16:11:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1023, 387, 3, '', '2022-04-03 16:11:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1024, 388, 2, '', '2022-04-03 19:05:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1025, 388, 3, '', '2022-04-03 19:05:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1026, 389, 2, '', '2022-04-03 19:30:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1027, 389, 3, '', '2022-04-03 19:30:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1028, 390, 2, '', '2022-04-04 09:34:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1029, 390, 3, 'ECG', '2022-04-04 09:34:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1030, 345, 1, '', '2022-04-04 09:34:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1031, 391, 2, '', '2022-04-04 10:50:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1032, 391, 3, '', '2022-04-04 10:50:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1033, 346, 1, '', '2022-04-04 10:57:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1034, 392, 2, '', '2022-04-04 10:57:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1035, 392, 3, '', '2022-04-04 10:57:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1036, 393, 2, '', '2022-04-04 11:10:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1037, 393, 3, '', '2022-04-04 11:10:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1038, 347, 1, '', '2022-04-04 11:12:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1039, 394, 2, '', '2022-04-04 11:39:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1040, 394, 3, '', '2022-04-04 11:39:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1041, 395, 2, '', '2022-04-04 11:57:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1042, 395, 3, 'X-Ray', '2022-04-04 11:57:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1043, 396, 2, '', '2022-04-04 12:12:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1044, 396, 3, 'ECG', '2022-04-04 12:12:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1045, 348, 1, '', '2022-04-04 12:17:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1046, 397, 2, '', '2022-04-04 12:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1047, 397, 3, '', '2022-04-04 12:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1048, 398, 2, '', '2022-04-04 12:21:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1049, 398, 3, '', '2022-04-04 12:21:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1050, 399, 2, '', '2022-04-04 12:31:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1051, 399, 3, 'X-Ray', '2022-04-04 12:31:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1052, 400, 2, '', '2022-04-04 12:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1053, 400, 3, '', '2022-04-04 12:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1054, 401, 2, '', '2022-04-04 12:52:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1055, 401, 3, '', '2022-04-04 12:52:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1056, 402, 2, '', '2022-04-04 13:20:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1057, 402, 3, '', '2022-04-04 13:20:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1058, 403, 2, '', '2022-04-04 13:30:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1059, 403, 3, '', '2022-04-04 13:30:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1060, 349, 1, '', '2022-04-04 16:19:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1061, 404, 2, '', '2022-04-04 16:40:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1062, 404, 3, 'X-Ray', '2022-04-04 16:40:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1063, 350, 1, '', '2022-04-04 19:32:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1064, 351, 1, '', '2022-04-04 19:36:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1065, 352, 1, '', '2022-04-04 19:40:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1066, 405, 2, '', '2022-04-04 19:41:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1067, 405, 3, '', '2022-04-04 19:41:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1068, 353, 1, '', '2022-04-04 20:19:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1069, 406, 2, '', '2022-04-04 21:15:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1070, 406, 3, '', '2022-04-04 21:15:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1071, 354, 1, '', '2022-04-05 08:36:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1072, 407, 2, '', '2022-04-05 09:33:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1073, 407, 3, '', '2022-04-05 09:33:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1074, 355, 1, '', '2022-04-05 10:20:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1075, 408, 2, '', '2022-04-05 10:21:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1076, 408, 3, '', '2022-04-05 10:21:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1077, 409, 2, '', '2022-04-05 10:31:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1078, 409, 3, '', '2022-04-05 10:31:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1079, 356, 1, '', '2022-04-05 10:43:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1080, 410, 2, '', '2022-04-05 10:52:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1081, 410, 3, '', '2022-04-05 10:52:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1082, 411, 2, '', '2022-04-05 11:01:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1083, 411, 3, '', '2022-04-05 11:01:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1084, 412, 2, '', '2022-04-05 11:03:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1085, 412, 3, '', '2022-04-05 11:03:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1086, 413, 2, '', '2022-04-05 11:05:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1087, 413, 3, '', '2022-04-05 11:05:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1088, 414, 2, '', '2022-04-05 11:25:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1089, 414, 3, 'X-Ray', '2022-04-05 11:25:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1090, 357, 1, '', '2022-04-05 11:33:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1091, 358, 1, '', '2022-04-05 11:41:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1092, 415, 2, '', '2022-04-05 11:46:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1093, 415, 3, '', '2022-04-05 11:46:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1094, 359, 1, '', '2022-04-05 11:48:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1095, 360, 1, '', '2022-04-05 13:05:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1096, 416, 2, '', '2022-04-05 16:11:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1097, 416, 3, 'ECG', '2022-04-05 16:11:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1098, 417, 2, '', '2022-04-05 16:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1099, 417, 3, 'X-Ray', '2022-04-05 16:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1100, 418, 2, '', '2022-04-05 18:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1101, 418, 3, 'ECG', '2022-04-05 18:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1102, 361, 1, '', '2022-04-05 18:21:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1103, 419, 2, '', '2022-04-05 19:02:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1104, 419, 3, 'USG', '2022-04-05 19:02:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1105, 420, 2, '', '2022-04-05 19:47:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1106, 420, 3, 'X-Ray', '2022-04-05 19:47:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1107, 421, 2, '', '2022-04-05 20:28:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1108, 421, 3, 'USG', '2022-04-05 20:28:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1109, 422, 2, '', '2022-04-05 21:29:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1110, 422, 3, '', '2022-04-05 21:29:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1111, 423, 2, '', '2022-04-06 09:32:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1112, 423, 3, '', '2022-04-06 09:32:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1113, 362, 1, '', '2022-04-06 10:01:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1114, 424, 2, '', '2022-04-06 10:02:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1115, 424, 3, '', '2022-04-06 10:02:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1116, 425, 2, '', '2022-04-06 10:26:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1117, 425, 3, '', '2022-04-06 10:26:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1118, 363, 1, '', '2022-04-06 10:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1119, 426, 2, '', '2022-04-06 10:58:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1120, 426, 3, '', '2022-04-06 10:58:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1121, 427, 2, '', '2022-04-06 11:39:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1122, 427, 3, '', '2022-04-06 11:39:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1123, 428, 2, '', '2022-04-06 11:46:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1124, 428, 3, '', '2022-04-06 11:46:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1125, 429, 2, '', '2022-04-06 12:08:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1126, 429, 3, '', '2022-04-06 12:08:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1127, 430, 2, '', '2022-04-06 12:12:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1128, 430, 3, '', '2022-04-06 12:12:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1129, 431, 2, '', '2022-04-06 20:30:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1130, 431, 3, '', '2022-04-06 20:30:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1131, 364, 1, '', '2022-04-06 20:40:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1132, 432, 2, '', '2022-04-06 20:44:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1133, 432, 3, 'ECG', '2022-04-06 20:44:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1134, 433, 2, '', '2022-04-06 21:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1135, 433, 3, '', '2022-04-06 21:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1136, 365, 1, '', '2022-04-07 09:37:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1137, 366, 1, '', '2022-04-07 09:43:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1138, 434, 2, '', '2022-04-07 09:44:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1139, 434, 3, '', '2022-04-07 09:44:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1140, 435, 2, '', '2022-04-07 10:04:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1141, 435, 3, '', '2022-04-07 10:04:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1142, 367, 1, '', '2022-04-07 10:23:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1143, 436, 2, '', '2022-04-07 10:28:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1144, 436, 3, '', '2022-04-07 10:28:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1145, 368, 1, '', '2022-04-07 10:52:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1146, 437, 2, '', '2022-04-07 10:52:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1147, 437, 3, '', '2022-04-07 10:52:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1148, 369, 1, '', '2022-04-07 11:10:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1149, 370, 1, '', '2022-04-07 11:23:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1150, 438, 2, '', '2022-04-07 11:25:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1151, 438, 3, '', '2022-04-07 11:25:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1152, 371, 1, '', '2022-04-07 11:43:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1153, 439, 2, '', '2022-04-07 11:45:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1154, 439, 3, '', '2022-04-07 11:45:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1155, 440, 2, '', '2022-04-07 11:56:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1156, 440, 3, '', '2022-04-07 11:56:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1157, 441, 2, '', '2022-04-07 13:57:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1158, 441, 3, '', '2022-04-07 13:57:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1159, 372, 1, '', '2022-04-07 15:18:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1160, 442, 2, '', '2022-04-07 15:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1161, 442, 3, '', '2022-04-07 15:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1162, 443, 2, '', '2022-04-07 15:28:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1163, 443, 3, 'X-Ray', '2022-04-07 15:28:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1164, 444, 2, '', '2022-04-07 15:36:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1165, 444, 3, 'USG', '2022-04-07 15:36:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1166, 373, 1, '', '2022-04-07 16:37:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1167, 445, 2, '', '2022-04-07 16:39:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1168, 445, 3, '', '2022-04-07 16:39:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1169, 374, 1, '', '2022-04-07 17:34:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1170, 446, 2, '', '2022-04-07 17:35:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1171, 446, 3, '', '2022-04-07 17:35:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1172, 375, 1, '', '2022-04-07 17:53:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1173, 447, 2, '', '2022-04-07 17:56:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1174, 447, 3, '', '2022-04-07 17:56:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1175, 376, 1, '', '2022-04-07 18:06:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1176, 377, 1, '', '2022-04-07 18:07:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1177, 448, 2, '', '2022-04-07 18:08:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1178, 448, 3, '', '2022-04-07 18:08:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1179, 378, 1, '', '2022-04-07 18:14:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1180, 449, 2, '', '2022-04-07 18:15:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1181, 449, 3, '', '2022-04-07 18:15:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1182, 0, 1, '', '2022-04-07 21:00:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1183, 450, 2, '', '2022-04-07 18:55:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1184, 450, 3, '', '2022-04-07 18:55:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1185, 380, 1, '', '2022-04-07 18:58:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1186, 451, 2, '', '2022-04-07 18:59:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1187, 451, 3, '', '2022-04-07 18:59:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1188, 381, 1, '', '2022-04-07 19:02:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1189, 452, 2, '', '2022-04-07 19:03:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1190, 452, 3, '', '2022-04-07 19:03:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1191, 453, 2, '', '2022-04-07 19:14:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1192, 453, 3, '', '2022-04-07 19:14:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1193, 382, 1, '', '2022-04-07 19:16:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1194, 383, 1, '', '2022-04-07 19:32:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1195, 454, 2, '', '2022-04-07 19:34:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1196, 454, 3, '', '2022-04-07 19:34:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1197, 384, 1, '', '2022-04-07 19:36:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1198, 385, 1, '', '2022-04-07 19:40:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1199, 455, 2, '', '2022-04-07 19:43:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1200, 455, 3, '', '2022-04-07 19:43:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1201, 386, 1, '', '2022-04-07 19:47:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1202, 0, 2, '', '2022-04-07 21:02:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1203, 0, 3, '', '2022-04-07 21:02:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1204, 457, 2, '', '2022-04-07 19:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1205, 457, 3, '', '2022-04-07 19:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1206, 458, 2, '', '2022-04-07 19:52:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1207, 458, 3, '', '2022-04-07 19:52:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1208, 387, 1, '', '2022-04-07 19:58:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1209, 459, 2, '', '2022-04-07 20:01:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1210, 459, 3, '', '2022-04-07 20:01:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1211, 388, 1, '', '2022-04-07 20:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1212, 460, 2, '', '2022-04-07 20:06:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1213, 460, 3, '', '2022-04-07 20:06:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1214, 461, 2, '', '2022-04-07 20:12:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1215, 461, 3, '', '2022-04-07 20:12:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1216, 389, 1, '', '2022-04-07 20:19:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1217, 462, 2, '', '2022-04-07 20:20:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1218, 462, 3, '', '2022-04-07 20:20:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1219, 390, 1, '', '2022-04-07 20:25:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1220, 463, 2, '', '2022-04-07 20:26:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1221, 463, 3, '', '2022-04-07 20:26:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1222, 464, 2, '', '2022-04-07 20:29:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1223, 464, 3, '', '2022-04-07 20:29:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1224, 379, 1, '', '2022-04-07 21:00:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1225, 0, 2, '', '2022-04-07 21:03:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1226, 0, 3, '', '2022-04-07 21:03:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1227, 456, 2, '', '2022-04-07 21:03:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1228, 456, 3, '', '2022-04-07 21:03:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1229, 391, 1, '', '2022-04-07 23:18:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1230, 392, 1, '', '2022-04-08 08:18:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1231, 465, 2, '', '2022-04-08 09:42:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1232, 465, 3, '', '2022-04-08 09:42:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1233, 393, 1, '', '2022-04-08 09:43:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1234, 394, 1, '', '2022-04-08 09:50:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1235, 466, 2, '', '2022-04-08 09:53:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1236, 466, 3, '', '2022-04-08 09:53:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1237, 395, 1, '', '2022-04-08 10:07:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1238, 467, 2, '', '2022-04-08 10:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1239, 467, 3, '', '2022-04-08 10:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1240, 396, 1, '', '2022-04-08 10:15:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1241, 397, 1, '', '2022-04-08 10:22:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1242, 398, 1, '', '2022-04-08 10:26:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1243, 468, 2, '', '2022-04-08 10:27:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1244, 468, 3, '', '2022-04-08 10:27:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1245, 399, 1, '', '2022-04-08 10:29:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1246, 469, 2, '', '2022-04-08 10:30:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1247, 469, 3, '', '2022-04-08 10:30:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1248, 400, 1, '', '2022-04-08 10:39:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1249, 470, 2, '', '2022-04-08 10:40:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1250, 470, 3, '', '2022-04-08 10:40:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1251, 471, 2, '', '2022-04-08 10:45:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1252, 471, 3, '', '2022-04-08 10:45:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1253, 401, 1, '', '2022-04-08 10:50:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1254, 402, 1, '', '2022-04-08 10:53:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1255, 472, 2, '', '2022-04-08 10:53:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1256, 472, 3, '', '2022-04-08 10:53:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1257, 403, 1, '', '2022-04-08 10:55:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1258, 473, 2, '', '2022-04-08 10:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1259, 473, 3, '', '2022-04-08 10:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1260, 474, 2, '', '2022-04-08 10:58:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1261, 474, 3, '', '2022-04-08 10:58:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1262, 404, 1, '', '2022-04-08 10:59:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1263, 475, 2, '', '2022-04-08 11:00:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1264, 475, 3, '', '2022-04-08 11:00:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1265, 476, 2, '', '2022-04-08 11:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1266, 476, 3, '', '2022-04-08 11:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1267, 405, 1, '', '2022-04-08 11:07:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1268, 477, 2, '', '2022-04-08 11:08:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1269, 477, 3, '', '2022-04-08 11:08:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1270, 478, 2, '', '2022-04-08 11:15:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1271, 478, 3, '', '2022-04-08 11:15:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1272, 406, 1, '', '2022-04-08 11:18:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1273, 479, 2, '', '2022-04-08 11:23:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1274, 479, 3, '', '2022-04-08 11:23:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1275, 480, 2, '', '2022-04-08 11:25:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1276, 480, 3, '', '2022-04-08 11:25:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1277, 407, 1, '', '2022-04-08 11:27:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1278, 481, 2, '', '2022-04-08 11:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1279, 481, 3, '', '2022-04-08 11:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1280, 408, 1, '', '2022-04-08 11:32:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1281, 409, 1, '', '2022-04-08 11:38:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1282, 482, 2, '', '2022-04-08 11:38:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1283, 482, 3, '', '2022-04-08 11:38:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1284, 483, 2, '', '2022-04-08 11:46:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1285, 483, 3, '', '2022-04-08 11:46:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1286, 484, 2, '', '2022-04-08 11:49:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1287, 484, 3, '', '2022-04-08 11:49:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1288, 485, 2, '', '2022-04-08 11:51:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1289, 485, 3, '', '2022-04-08 11:51:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1290, 410, 1, '', '2022-04-08 12:15:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1291, 486, 2, '', '2022-04-08 12:17:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1292, 486, 3, '', '2022-04-08 12:17:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1293, 411, 1, '', '2022-04-08 12:19:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1294, 487, 2, '', '2022-04-08 12:21:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1295, 487, 3, '', '2022-04-08 12:21:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1296, 488, 2, '', '2022-04-08 12:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1297, 488, 3, '', '2022-04-08 12:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1298, 412, 1, '', '2022-04-08 12:52:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1299, 413, 1, '', '2022-04-08 12:57:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1300, 414, 1, '', '2022-04-08 13:30:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1301, 415, 1, '', '2022-04-08 15:06:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1302, 489, 2, '', '2022-04-08 15:07:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1303, 489, 3, '', '2022-04-08 15:07:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1304, 490, 2, '', '2022-04-08 16:02:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1305, 490, 3, '', '2022-04-08 16:02:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1306, 491, 2, '', '2022-04-08 16:13:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1307, 491, 3, '', '2022-04-08 16:13:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1308, 492, 2, '', '2022-04-08 16:23:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1309, 492, 3, 'X-Ray', '2022-04-08 16:23:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1310, 493, 2, '', '2022-04-08 16:38:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1311, 493, 3, '', '2022-04-08 16:38:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1312, 416, 1, '', '2022-04-08 17:22:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1313, 417, 1, '', '2022-04-08 17:42:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1314, 418, 1, '', '2022-04-08 20:10:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1315, 494, 2, '', '2022-04-08 20:10:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1316, 494, 3, '', '2022-04-08 20:10:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1317, 495, 2, '', '2022-04-08 20:12:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1318, 495, 3, '', '2022-04-08 20:12:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1319, 419, 1, '', '2022-04-08 20:33:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1320, 496, 2, '', '2022-04-08 20:34:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1321, 496, 3, '', '2022-04-08 20:34:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1322, 420, 1, '', '2022-04-08 20:53:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1323, 421, 1, '', '2022-04-08 21:30:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1324, 497, 2, '', '2022-04-08 21:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1325, 497, 3, '', '2022-04-08 21:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1326, 498, 2, '', '2022-04-09 06:44:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1327, 498, 3, '', '2022-04-09 06:44:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1328, 422, 1, '', '2022-04-09 07:27:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1329, 499, 2, '', '2022-04-09 10:17:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1330, 499, 3, 'X-Ray', '2022-04-09 10:17:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1331, 500, 2, '', '2022-04-09 10:18:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1332, 500, 3, '', '2022-04-09 10:18:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1333, 423, 1, '', '2022-04-09 10:22:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1334, 501, 2, '', '2022-04-09 10:25:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1335, 501, 3, '', '2022-04-09 10:25:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1336, 502, 2, '', '2022-04-09 10:27:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1337, 502, 3, '', '2022-04-09 10:27:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1338, 503, 2, '', '2022-04-09 10:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1339, 503, 3, '', '2022-04-09 10:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1340, 504, 2, '', '2022-04-09 11:07:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1341, 504, 3, '', '2022-04-09 11:07:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1342, 424, 1, '', '2022-04-09 11:09:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1343, 425, 1, '', '2022-04-09 11:14:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1344, 426, 1, '', '2022-04-09 11:20:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1345, 505, 2, '', '2022-04-09 11:21:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1346, 505, 3, '', '2022-04-09 11:21:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1347, 427, 1, '', '2022-04-09 11:35:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1348, 506, 2, '', '2022-04-09 11:36:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1349, 506, 3, '', '2022-04-09 11:36:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1350, 428, 1, '', '2022-04-09 11:43:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1351, 507, 2, '', '2022-04-09 11:53:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1352, 507, 3, '', '2022-04-09 11:53:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1353, 429, 1, '', '2022-04-09 11:54:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1354, 508, 2, '', '2022-04-09 11:56:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1355, 508, 3, '', '2022-04-09 11:56:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1356, 509, 2, '', '2022-04-09 12:00:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1357, 509, 3, '', '2022-04-09 12:00:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1358, 510, 2, '', '2022-04-09 12:05:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1359, 510, 3, '', '2022-04-09 12:05:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1360, 430, 1, '', '2022-04-09 12:09:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1361, 511, 2, '', '2022-04-09 12:10:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1362, 511, 3, '', '2022-04-09 12:10:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1363, 431, 1, '', '2022-04-09 12:14:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1364, 432, 1, '', '2022-04-09 12:31:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1365, 512, 2, '', '2022-04-09 12:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1366, 512, 3, 'USG', '2022-04-09 12:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1367, 433, 1, '', '2022-04-09 12:36:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1368, 513, 2, '', '2022-04-09 12:37:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1369, 513, 3, '', '2022-04-09 12:37:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1370, 434, 1, '', '2022-04-09 12:37:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1371, 514, 2, '', '2022-04-09 12:39:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1372, 514, 3, '', '2022-04-09 12:39:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1373, 515, 2, '', '2022-04-09 12:42:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1374, 515, 3, '', '2022-04-09 12:42:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1375, 435, 1, '', '2022-04-09 15:28:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1376, 436, 1, '', '2022-04-09 15:53:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1377, 516, 2, '', '2022-04-09 15:54:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1378, 516, 3, '', '2022-04-09 15:54:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1379, 517, 2, '', '2022-04-09 20:42:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1380, 517, 3, '', '2022-04-09 20:42:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1381, 437, 1, '', '2022-04-10 08:59:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1382, 518, 2, '', '2022-04-10 08:59:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1383, 518, 3, '', '2022-04-10 08:59:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1384, 438, 1, '', '2022-04-10 09:42:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1385, 519, 2, '', '2022-04-10 09:44:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1386, 519, 3, '', '2022-04-10 09:44:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1387, 439, 1, '', '2022-04-10 09:57:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1388, 520, 2, '', '2022-04-10 09:58:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1389, 520, 3, '', '2022-04-10 09:58:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1390, 440, 1, '', '2022-04-10 10:35:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1391, 441, 1, '', '2022-04-10 10:42:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1392, 521, 2, '', '2022-04-10 10:43:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1393, 521, 3, '', '2022-04-10 10:43:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1394, 522, 2, '', '2022-04-10 10:46:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1395, 522, 3, '', '2022-04-10 10:46:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1396, 523, 2, '', '2022-04-10 10:54:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1397, 523, 3, '', '2022-04-10 10:54:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1398, 524, 2, '', '2022-04-10 10:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1399, 524, 3, '', '2022-04-10 10:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1400, 525, 2, '', '2022-04-10 11:27:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1401, 525, 3, '', '2022-04-10 11:27:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1402, 442, 1, '', '2022-04-10 12:02:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1403, 526, 2, '', '2022-04-10 12:05:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1404, 526, 3, '', '2022-04-10 12:05:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1405, 443, 1, '', '2022-04-10 12:07:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1406, 527, 2, '', '2022-04-10 13:16:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1407, 527, 3, '', '2022-04-10 13:16:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1408, 528, 2, '', '2022-04-10 14:24:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1409, 528, 3, '', '2022-04-10 14:24:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1410, 444, 1, '', '2022-04-10 15:06:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1411, 529, 2, '', '2022-04-10 15:07:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1412, 529, 3, '', '2022-04-10 15:07:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1413, 530, 2, '', '2022-04-10 15:49:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1414, 530, 3, '', '2022-04-10 15:49:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1415, 445, 1, '', '2022-04-10 15:53:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1416, 446, 1, '', '2022-04-10 16:15:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1417, 531, 2, '', '2022-04-10 16:15:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1418, 531, 3, '', '2022-04-10 16:15:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1419, 532, 2, '', '2022-04-10 16:32:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1420, 532, 3, '', '2022-04-10 16:32:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1421, 533, 2, '', '2022-04-10 16:36:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1422, 533, 3, 'USG', '2022-04-10 16:36:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1423, 534, 2, '', '2022-04-10 17:07:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1424, 534, 3, '', '2022-04-10 17:07:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1425, 447, 1, '', '2022-04-10 17:18:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1426, 448, 1, '', '2022-04-10 19:22:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1427, 449, 1, '', '2022-04-10 19:43:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1428, 535, 2, '', '2022-04-10 19:45:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1429, 535, 3, '', '2022-04-10 19:45:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1430, 450, 1, '', '2022-04-10 19:55:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1431, 536, 2, '', '2022-04-10 19:55:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1432, 536, 3, '', '2022-04-10 19:55:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1433, 451, 1, '', '2022-04-10 20:17:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1434, 537, 2, '', '2022-04-10 23:03:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1435, 537, 3, '', '2022-04-10 23:03:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1436, 452, 1, '', '2022-04-11 08:41:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1437, 538, 2, '', '2022-04-11 08:54:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1438, 538, 3, '', '2022-04-11 08:54:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1439, 453, 1, '', '2022-04-11 09:11:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1440, 539, 2, '', '2022-04-11 11:20:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1441, 539, 3, '', '2022-04-11 11:20:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1442, 454, 1, '', '2022-04-11 11:27:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1443, 540, 2, '', '2022-04-11 11:29:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1444, 540, 3, '', '2022-04-11 11:29:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1445, 541, 2, '', '2022-04-11 11:34:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1446, 541, 3, '', '2022-04-11 11:34:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1447, 455, 1, '', '2022-04-11 12:07:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1448, 542, 2, '', '2022-04-11 12:13:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1449, 542, 3, '', '2022-04-11 12:13:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1450, 456, 1, '', '2022-04-11 12:34:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1451, 543, 2, '', '2022-04-11 13:19:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1452, 543, 3, '', '2022-04-11 13:19:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1453, 457, 1, '', '2022-04-11 15:09:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1454, 544, 2, '', '2022-04-11 15:11:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1455, 544, 3, 'USG', '2022-04-11 15:11:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1459, 546, 2, '', '2022-04-11 17:29:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1460, 546, 3, '', '2022-04-11 17:29:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1461, 459, 1, '', '2022-04-11 17:37:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1462, 547, 2, '', '2022-04-11 19:57:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1463, 547, 3, '', '2022-04-11 19:57:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1464, 460, 1, '', '2022-04-11 20:36:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1465, 461, 1, '', '2022-04-11 20:42:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1466, 462, 1, '', '2022-04-12 08:55:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1467, 548, 2, '', '2022-04-12 08:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1468, 548, 3, '', '2022-04-12 08:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1469, 463, 1, '', '2022-04-12 09:44:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1470, 549, 2, '', '2022-04-12 09:50:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1471, 549, 3, '', '2022-04-12 09:50:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1472, 464, 1, '', '2022-04-12 09:57:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1473, 465, 1, '', '2022-04-12 10:15:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1474, 466, 1, '', '2022-04-12 10:21:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1475, 467, 1, '', '2022-04-12 10:24:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1476, 550, 2, '', '2022-04-12 10:25:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1477, 550, 3, '', '2022-04-12 10:25:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1478, 551, 2, '', '2022-04-12 10:36:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1479, 551, 3, '', '2022-04-12 10:36:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1480, 552, 2, '', '2022-04-12 10:38:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1481, 552, 3, '', '2022-04-12 10:38:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1482, 553, 2, '', '2022-04-12 10:41:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1483, 553, 3, '', '2022-04-12 10:41:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1484, 554, 2, '', '2022-04-12 10:42:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1485, 554, 3, '', '2022-04-12 10:42:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1486, 468, 1, '', '2022-04-12 10:57:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1487, 469, 1, '', '2022-04-12 11:13:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1488, 555, 2, '', '2022-04-12 11:24:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1489, 555, 3, '', '2022-04-12 11:24:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1490, 470, 1, '', '2022-04-12 11:26:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1491, 556, 2, '', '2022-04-12 11:53:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1492, 556, 3, '', '2022-04-12 11:53:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1493, 557, 2, '', '2022-04-12 12:01:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1494, 557, 3, '', '2022-04-12 12:01:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1495, 471, 1, '', '2022-04-12 14:08:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1496, 558, 2, '', '2022-04-12 15:36:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1497, 558, 3, '', '2022-04-12 15:36:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1498, 472, 1, '', '2022-04-12 16:42:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1499, 559, 2, '', '2022-04-12 17:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1500, 559, 3, '', '2022-04-12 17:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1501, 560, 2, '', '2022-04-12 19:29:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1502, 560, 3, '', '2022-04-12 19:29:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1503, 473, 1, '', '2022-04-12 19:52:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1504, 561, 2, '', '2022-04-12 20:26:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1505, 561, 3, '', '2022-04-12 20:26:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1506, 562, 2, '', '2022-04-12 22:09:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1507, 562, 3, '', '2022-04-12 22:09:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1508, 563, 2, '', '2022-04-12 22:28:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1509, 563, 3, '', '2022-04-12 22:28:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1510, 474, 1, '', '2022-04-12 22:58:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1511, 475, 1, '', '2022-04-12 23:01:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1512, 476, 1, '', '2022-04-12 23:19:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1513, 564, 2, '', '2022-04-12 23:28:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1514, 564, 3, '', '2022-04-12 23:28:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1515, 565, 2, '', '2022-04-13 09:49:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1516, 565, 3, '', '2022-04-13 09:49:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1517, 566, 2, '', '2022-04-13 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1518, 566, 3, '', '2022-04-13 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1519, 477, 1, '', '2022-04-13 10:39:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1520, 567, 2, '', '2022-04-13 10:41:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1521, 567, 3, '', '2022-04-13 10:41:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1522, 568, 2, '', '2022-04-13 10:41:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1523, 568, 3, '', '2022-04-13 10:41:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1524, 478, 1, '', '2022-04-13 10:48:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1525, 569, 2, '', '2022-04-13 10:49:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1526, 569, 3, '', '2022-04-13 10:49:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1527, 479, 1, '', '2022-04-13 10:56:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1528, 570, 2, '', '2022-04-13 10:58:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1529, 570, 3, '', '2022-04-13 10:58:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1530, 571, 2, '', '2022-04-13 11:06:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1531, 571, 3, '', '2022-04-13 11:06:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1532, 572, 2, '', '2022-04-13 11:10:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1533, 572, 3, '', '2022-04-13 11:10:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1534, 573, 2, '', '2022-04-13 11:14:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1535, 573, 3, '', '2022-04-13 11:14:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1536, 480, 1, '', '2022-04-13 11:16:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1537, 574, 2, '', '2022-04-13 13:22:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1538, 574, 3, '', '2022-04-13 13:22:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1539, 481, 1, '', '2022-04-13 13:37:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1540, 575, 2, '', '2022-04-13 13:39:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1541, 575, 3, '', '2022-04-13 13:39:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1542, 482, 1, '', '2022-04-13 17:32:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1543, 576, 2, '', '2022-04-13 17:58:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1544, 576, 3, '', '2022-04-13 17:58:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1545, 577, 2, '', '2022-04-13 19:33:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1546, 577, 3, '', '2022-04-13 19:33:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1547, 483, 1, '', '2022-04-13 19:51:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1548, 578, 2, '', '2022-04-13 20:02:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1549, 578, 3, '', '2022-04-13 20:02:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1550, 484, 1, '', '2022-04-13 21:20:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1551, 579, 2, '', '2022-04-14 09:49:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1552, 579, 3, '', '2022-04-14 09:49:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1553, 485, 1, '', '2022-04-14 10:07:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1554, 580, 2, '', '2022-04-14 10:08:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1555, 580, 3, '', '2022-04-14 10:08:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1556, 486, 1, '', '2022-04-14 11:03:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1557, 487, 1, '', '2022-04-14 11:05:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1558, 581, 2, '', '2022-04-14 11:39:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1559, 581, 3, '', '2022-04-14 11:39:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1560, 488, 1, '', '2022-04-14 11:45:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1561, 582, 2, '', '2022-04-14 11:48:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1562, 582, 3, '', '2022-04-14 11:48:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1563, 489, 1, '', '2022-04-14 12:12:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1564, 490, 1, '', '2022-04-14 12:45:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1565, 491, 1, '', '2022-04-14 12:51:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1566, 583, 2, '', '2022-04-14 12:53:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1567, 583, 3, '', '2022-04-14 12:53:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1568, 492, 1, '', '2022-04-14 15:28:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1569, 584, 2, '', '2022-04-14 16:14:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1570, 584, 3, '', '2022-04-14 16:14:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1571, 585, 2, '', '2022-04-14 16:41:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1572, 585, 3, 'X-Ray', '2022-04-14 16:41:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1573, 586, 2, '', '2022-04-14 16:56:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1574, 586, 3, '', '2022-04-14 16:56:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1575, 493, 1, '', '2022-04-14 17:12:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1576, 587, 2, '', '2022-04-14 17:13:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1577, 587, 3, '', '2022-04-14 17:13:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1578, 494, 1, '', '2022-04-14 17:27:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1579, 588, 2, '', '2022-04-14 17:28:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1580, 588, 3, '', '2022-04-14 17:28:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1581, 495, 1, '', '2022-04-14 17:37:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1582, 496, 1, '', '2022-04-14 17:44:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1583, 589, 2, '', '2022-04-14 17:45:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1584, 589, 3, '', '2022-04-14 17:45:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1585, 497, 1, '', '2022-04-14 17:55:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1586, 498, 1, '', '2022-04-14 18:29:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1587, 499, 1, '', '2022-04-14 19:43:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1588, 590, 2, '', '2022-04-14 19:44:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1589, 590, 3, '', '2022-04-14 19:44:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1590, 591, 2, '', '2022-04-14 19:48:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1591, 591, 3, '', '2022-04-14 19:48:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1592, 592, 2, '', '2022-04-14 19:59:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1593, 592, 3, '', '2022-04-14 19:59:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1594, 500, 1, '', '2022-04-14 20:07:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1595, 593, 2, '', '2022-04-14 20:08:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1596, 593, 3, '', '2022-04-14 20:08:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1597, 501, 1, '', '2022-04-14 20:12:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1598, 502, 1, '', '2022-04-14 20:15:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1599, 594, 2, '', '2022-04-14 20:16:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1600, 594, 3, '', '2022-04-14 20:16:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1601, 503, 1, '', '2022-04-14 20:18:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1602, 504, 1, '', '2022-04-14 20:19:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1603, 595, 2, '', '2022-04-14 20:19:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1604, 595, 3, '', '2022-04-14 20:19:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1605, 596, 2, '', '2022-04-14 20:20:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1606, 596, 3, '', '2022-04-14 20:20:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1607, 505, 1, '', '2022-04-14 20:24:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1608, 597, 2, '', '2022-04-14 20:25:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1609, 597, 3, '', '2022-04-14 20:25:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1610, 598, 2, '', '2022-04-14 20:25:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1611, 598, 3, '', '2022-04-14 20:25:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1612, 599, 2, '', '2022-04-14 20:29:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1613, 599, 3, '', '2022-04-14 20:29:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1614, 506, 1, '', '2022-04-14 20:36:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1615, 600, 2, '', '2022-04-14 20:40:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1616, 600, 3, '', '2022-04-14 20:40:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1617, 507, 1, '', '2022-04-14 20:40:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1618, 601, 2, '', '2022-04-14 20:41:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1619, 601, 3, '', '2022-04-14 20:41:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1620, 508, 1, '', '2022-04-14 20:52:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1621, 602, 2, '', '2022-04-14 20:53:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1622, 602, 3, '', '2022-04-14 20:53:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1623, 603, 2, '', '2022-04-14 21:18:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1624, 603, 3, '', '2022-04-14 21:18:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1625, 604, 2, '', '2022-04-14 21:26:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1626, 604, 3, '', '2022-04-14 21:26:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1627, 605, 2, '', '2022-04-14 21:26:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1628, 605, 3, '', '2022-04-14 21:26:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1629, 606, 2, '', '2022-04-14 21:28:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1630, 606, 3, '', '2022-04-14 21:28:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1631, 509, 1, '', '2022-04-14 21:36:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1632, 607, 2, '', '2022-04-14 21:37:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1633, 607, 3, '', '2022-04-14 21:37:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1634, 608, 2, '', '2022-04-14 21:39:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1635, 608, 3, '', '2022-04-14 21:39:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1636, 609, 2, '', '2022-04-14 21:47:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1637, 609, 3, '', '2022-04-14 21:47:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1638, 510, 1, '', '2022-04-14 21:48:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1639, 511, 1, '', '2022-04-14 22:19:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1640, 610, 2, '', '2022-04-15 08:05:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1641, 610, 3, '', '2022-04-15 08:05:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1642, 512, 1, '', '2022-04-15 08:19:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1643, 513, 1, '', '2022-04-15 09:50:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1644, 611, 2, '', '2022-04-15 09:51:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1645, 611, 3, '', '2022-04-15 09:51:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1646, 514, 1, '', '2022-04-15 10:29:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1647, 515, 1, '', '2022-04-15 10:31:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1648, 612, 2, '', '2022-04-15 10:31:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1649, 612, 3, '', '2022-04-15 10:31:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1650, 613, 2, '', '2022-04-15 10:32:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1651, 613, 3, '', '2022-04-15 10:32:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1652, 516, 1, '', '2022-04-15 10:39:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1653, 517, 1, '', '2022-04-15 10:50:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1654, 518, 1, '', '2022-04-15 10:57:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1655, 614, 2, '', '2022-04-15 10:58:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1656, 614, 3, '', '2022-04-15 10:58:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1657, 519, 1, '', '2022-04-15 11:01:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1658, 615, 2, '', '2022-04-15 11:02:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1659, 615, 3, '', '2022-04-15 11:02:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1660, 520, 1, '', '2022-04-15 11:17:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1661, 616, 2, '', '2022-04-15 11:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1662, 616, 3, '', '2022-04-15 11:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1663, 521, 1, '', '2022-04-15 11:32:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1664, 0, 2, '', '2022-04-15 12:40:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1665, 0, 3, '', '2022-04-15 12:40:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1666, 522, 1, '', '2022-04-15 11:43:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1667, 523, 1, '', '2022-04-15 11:53:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1668, 524, 1, '', '2022-04-15 11:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1669, 618, 2, '', '2022-04-15 11:58:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1670, 618, 3, '', '2022-04-15 11:58:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1671, 525, 1, '', '2022-04-15 12:01:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1672, 619, 2, '', '2022-04-15 12:02:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1673, 619, 3, '', '2022-04-15 12:02:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1674, 620, 2, '', '2022-04-15 12:03:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1675, 620, 3, '', '2022-04-15 12:03:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1676, 621, 2, '', '2022-04-15 12:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1677, 621, 3, '', '2022-04-15 12:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1678, 622, 2, '', '2022-04-15 12:07:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1679, 622, 3, '', '2022-04-15 12:07:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1680, 623, 2, '', '2022-04-15 12:09:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1681, 623, 3, '', '2022-04-15 12:09:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1682, 624, 2, '', '2022-04-15 12:10:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1683, 624, 3, '', '2022-04-15 12:10:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1684, 625, 2, '', '2022-04-15 12:11:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1685, 625, 3, '', '2022-04-15 12:11:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1686, 626, 2, '', '2022-04-15 12:15:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1687, 626, 3, '', '2022-04-15 12:15:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1688, 526, 1, '', '2022-04-15 12:15:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1689, 627, 2, '', '2022-04-15 12:19:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1690, 627, 3, '', '2022-04-15 12:19:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1691, 617, 2, '', '2022-04-15 12:40:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1692, 617, 3, '', '2022-04-15 12:40:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1693, 527, 1, '', '2022-04-15 12:46:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1694, 528, 1, '', '2022-04-15 13:11:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1695, 628, 2, '', '2022-04-15 13:13:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1696, 628, 3, '', '2022-04-15 13:13:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1697, 629, 2, '', '2022-04-15 13:14:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1698, 629, 3, '', '2022-04-15 13:14:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1699, 529, 1, '', '2022-04-15 13:15:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1700, 630, 2, '', '2022-04-15 14:12:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1701, 630, 3, '', '2022-04-15 14:12:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1702, 631, 2, '', '2022-04-15 16:28:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1703, 631, 3, '', '2022-04-15 16:28:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1704, 530, 1, '', '2022-04-15 16:30:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1705, 632, 2, '', '2022-04-15 16:51:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1706, 632, 3, '', '2022-04-15 16:51:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1707, 531, 1, '', '2022-04-15 17:01:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1708, 633, 2, '', '2022-04-15 17:02:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1709, 633, 3, '', '2022-04-15 17:02:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1710, 532, 1, '', '2022-04-15 17:12:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1711, 634, 2, '', '2022-04-15 17:12:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1712, 634, 3, '', '2022-04-15 17:12:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1713, 533, 1, '', '2022-04-15 17:33:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1714, 534, 1, '', '2022-04-15 17:56:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1715, 635, 2, '', '2022-04-15 18:55:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1716, 635, 3, '', '2022-04-15 18:55:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1717, 535, 1, '', '2022-04-15 19:32:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1718, 636, 2, '', '2022-04-15 19:52:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1719, 636, 3, '', '2022-04-15 19:52:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1720, 637, 2, '', '2022-04-15 20:11:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1721, 637, 3, '', '2022-04-15 20:11:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1722, 638, 2, '', '2022-04-15 21:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1723, 638, 3, '', '2022-04-15 21:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1724, 536, 1, '', '2022-04-16 09:44:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1725, 639, 2, '', '2022-04-16 09:46:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1726, 639, 3, '', '2022-04-16 09:46:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1727, 640, 2, '', '2022-04-16 09:58:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1728, 640, 3, '', '2022-04-16 09:58:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1729, 641, 2, '', '2022-04-16 10:28:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1730, 641, 3, '', '2022-04-16 10:28:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1731, 537, 1, '', '2022-04-16 10:29:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1732, 642, 2, '', '2022-04-16 10:30:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1733, 642, 3, '', '2022-04-16 10:30:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1734, 538, 1, '', '2022-04-16 10:55:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1735, 643, 2, '', '2022-04-16 10:55:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1736, 643, 3, '', '2022-04-16 10:55:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1737, 539, 1, '', '2022-04-16 11:01:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1738, 644, 2, '', '2022-04-16 11:12:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1739, 644, 3, '', '2022-04-16 11:12:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1740, 540, 1, '', '2022-04-16 11:14:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1741, 541, 1, '', '2022-04-16 11:50:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1742, 645, 2, '', '2022-04-16 11:54:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1743, 645, 3, '', '2022-04-16 11:54:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1744, 646, 2, '', '2022-04-16 11:59:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1745, 646, 3, '', '2022-04-16 11:59:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1746, 542, 1, '', '2022-04-16 12:29:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1747, 647, 2, '', '2022-04-16 12:31:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1748, 647, 3, 'X-Ray', '2022-04-16 12:31:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1749, 543, 1, '', '2022-04-16 12:47:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1750, 648, 2, '', '2022-04-16 12:49:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1751, 648, 3, '', '2022-04-16 12:49:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1752, 649, 2, '', '2022-04-16 13:00:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1753, 649, 3, 'X-Ray', '2022-04-16 13:00:45');


#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `visible_on_print` int(11) DEFAULT NULL,
  `visible_on_report` int(11) DEFAULT NULL,
  `visible_on_table` int(11) DEFAULT NULL,
  `visible_on_patient_panel` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (1, 'Pathology Room', 'pathology', 'select', 12, 0, '107', 1, 0, 1, 0, NULL, 0, '2022-03-11 17:00:01');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (2, 'Radiology Room', 'radiology', 'select', 12, 0, '106,101', 1, 0, 1, 0, NULL, 0, '2022-03-24 17:38:49');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (3, 'Radiology Group', 'radiology', 'select', 12, 0, 'USG,X-Ray,ECG', 0, 0, 1, 0, NULL, 0, '2022-03-29 17:57:21');


#
# TABLE STRUCTURE FOR: customer_information
#

DROP TABLE IF EXISTS `customer_information`;

CREATE TABLE `customer_information` (
  `id` int(11) NOT NULL,
  `customer_id` varchar(30) NOT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_address` varchar(255) NOT NULL,
  `customer_mobile` varchar(100) NOT NULL,
  `customer_email` varchar(100) NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `customer_information` (`id`, `customer_id`, `customer_name`, `customer_address`, `customer_mobile`, `customer_email`, `status`) VALUES (1, 'P3NY6D1AKZQPHB7', 'Walking Customer', '', '465645', '', 1);


#
# TABLE STRUCTURE FOR: customer_ledger
#

DROP TABLE IF EXISTS `customer_ledger`;

CREATE TABLE `customer_ledger` (
  `transaction_id` varchar(100) NOT NULL,
  `customer_id` varchar(100) NOT NULL,
  `invoice_no` varchar(100) DEFAULT NULL,
  `receipt_no` varchar(50) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT 0.00,
  `description` varchar(255) NOT NULL,
  `payment_type` varchar(255) NOT NULL,
  `cheque_no` varchar(255) NOT NULL,
  `date` varchar(50) NOT NULL,
  `status` int(2) NOT NULL,
  `id` int(11) NOT NULL,
  `d_c` varchar(1) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('TLT8FQ3FV1QJKWV', 'P3NY6D1AKZQPHB7', '9259592329', NULL, '0.00', 'Cash Paid By Customer', '', '', '2022-02-23', 1, 1, 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('TLT8FQ3FV1QJKWV', 'P3NY6D1AKZQPHB7', NULL, 'SEC4WOUJ4A', '6.00', 'Medicine Received By Customer', '1', '', '2022-02-23', 1, 2, 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('A32NOO3TOJ2ZXQM', 'P3NY6D1AKZQPHB7', '1877899635', NULL, '0.00', 'Cash Paid By Customer', '', '', '2022-02-23', 1, 3, 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('A32NOO3TOJ2ZXQM', 'P3NY6D1AKZQPHB7', NULL, 'GBGUX5XLAU', '3.00', 'Medicine Received By Customer', '1', '', '2022-02-23', 1, 4, 'd');


#
# TABLE STRUCTURE FOR: daily_banking_add
#

DROP TABLE IF EXISTS `daily_banking_add`;

CREATE TABLE `daily_banking_add` (
  `banking_id` varchar(255) NOT NULL,
  `date` varchar(50) NOT NULL,
  `bank_id` varchar(100) NOT NULL,
  `deposit_type` varchar(255) NOT NULL,
  `transaction_type` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `amount` float NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: daily_closing
#

DROP TABLE IF EXISTS `daily_closing`;

CREATE TABLE `daily_closing` (
  `closing_id` varchar(255) NOT NULL,
  `last_day_closing` float NOT NULL,
  `cash_in` float NOT NULL,
  `cash_out` float NOT NULL,
  `date` varchar(50) NOT NULL,
  `amount` float NOT NULL,
  `adjustment` float NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `attachment` varchar(200) NOT NULL,
  `attachment_name` text DEFAULT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `death_report` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `death_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `death_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (1, 'pathology', 'yes', '2022-01-11 13:10:12');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (2, 'Reception', 'yes', '2022-01-17 10:14:12');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (3, 'Account', 'yes', '2022-01-17 10:27:14');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (4, 'Admin_Hospital', 'yes', '2022-01-17 10:27:48');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (5, 'Radiology ', 'yes', '2022-01-17 10:28:29');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (6, 'Ultrasound', 'yes', '2022-01-17 10:29:49');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (7, 'Report', 'yes', '2022-01-17 10:30:37');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (8, 'Pharmacy', 'yes', '2022-01-17 10:33:15');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (9, 'Doctor', 'yes', '2022-01-17 10:33:57');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (10, 'IT', 'yes', '2022-01-17 10:35:08');


#
# TABLE STRUCTURE FOR: designation
#

DROP TABLE IF EXISTS `designation`;

CREATE TABLE `designation` (
  `id` int(11) NOT NULL,
  `designation` varchar(150) NOT NULL,
  `details` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: discharge_card
#

DROP TABLE IF EXISTS `discharge_card`;

CREATE TABLE `discharge_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_details_id` int(11) DEFAULT NULL,
  `discharge_by` int(11) DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_status` int(10) NOT NULL,
  `death_date` datetime DEFAULT NULL,
  `refer_date` datetime DEFAULT NULL,
  `refer_to_hospital` varchar(255) DEFAULT NULL,
  `reason_for_referral` varchar(255) DEFAULT NULL,
  `operation` varchar(225) NOT NULL,
  `diagnosis` varchar(255) NOT NULL,
  `investigations` text DEFAULT NULL,
  `treatment_home` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `discharge_by` (`discharge_by`),
  CONSTRAINT `discharge_card_ibfk_1` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_2` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_4` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_5` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_6` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (25, 88, NULL, 31, 1, '2022-03-20 13:35:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'old software patients billed here.', '2022-03-20 13:35:29');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (26, 98, 65, NULL, 44, '2022-03-21 17:29:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'Note', '2022-03-21 17:29:22');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (27, 96, NULL, 33, 44, '2022-03-21 18:08:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'Patient Discharge', '2022-03-21 18:10:50');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (28, 95, NULL, 32, 44, '2022-03-21 18:59:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'Patient Discharge', '2022-03-21 19:00:26');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (29, 83, NULL, 29, 44, '2022-03-23 10:48:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'payment 9500 ordered by AMD Sir', '2022-03-23 10:48:55');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (30, 72, NULL, 27, 44, '2022-03-23 10:53:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully payment', '2022-03-23 10:54:16');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (31, 133, NULL, 37, 43, '2022-03-26 16:48:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully payment', '2022-03-26 16:50:54');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (32, 118, NULL, 35, 43, '2022-03-27 09:55:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully payment', '2022-03-27 09:56:26');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (33, 148, NULL, 41, 44, '2022-03-27 11:47:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'Patient discharge by fully payment', '2022-03-27 11:48:35');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (34, 166, NULL, 43, 44, '2022-03-27 12:38:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'Patient discharge by fully payment', '2022-03-27 12:39:02');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (35, 150, NULL, 42, 44, '2022-03-29 10:42:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'Patient Discharge by fully Payment', '2022-03-29 10:43:26');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (36, 145, NULL, 40, 43, '2022-03-31 13:25:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully payment', '2022-03-31 13:27:01');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (37, 251, NULL, 52, 43, '2022-04-07 10:50:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully payment ', '2022-04-07 10:51:30');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (38, 278, NULL, 55, 43, '2022-04-07 12:38:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully payment ', '2022-04-07 12:39:42');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (39, 240, NULL, 50, 43, '2022-04-08 10:59:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'Patient discharge by fully payment ', '2022-04-12 11:24:35');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (40, 328, NULL, 60, 43, '2022-04-11 12:37:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully pasyment ', '2022-04-14 12:38:45');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (41, 261, NULL, 54, 43, '2022-04-10 12:42:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully payment', '2022-04-14 12:43:08');
INSERT INTO `discharge_card` (`id`, `case_reference_id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (42, 287, NULL, 56, 43, '2022-04-11 12:43:00', 3, NULL, NULL, NULL, '', '', '', '', '', 'patient discharge by fully payment', '2022-04-14 12:44:19');


#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `image` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_absent_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_global_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_global_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (2, 46, 1, '2022-03-01 18:56:18');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (3, 46, 2, '2022-03-02 23:01:30');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (4, 24, 1, '2022-03-02 23:01:53');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (5, 24, 2, '2022-03-02 23:01:57');


#
# TABLE STRUCTURE FOR: doctor_shift
#

DROP TABLE IF EXISTS `doctor_shift`;

CREATE TABLE `doctor_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (1, 'Monday', 46, 1, '00:04:00', '01:04:00', '2022-03-02 23:05:14');


#
# TABLE STRUCTURE FOR: dose_duration
#

DROP TABLE IF EXISTS `dose_duration`;

CREATE TABLE `dose_duration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (1, '3', '2022-03-11 04:26:39');


#
# TABLE STRUCTURE FOR: dose_interval
#

DROP TABLE IF EXISTS `dose_interval`;

CREATE TABLE `dose_interval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (1, '3', '2022-03-11 04:26:44');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (1, 'sendmail', '', '', '', '', '', 'true', 'yes', '2021-09-24 18:44:21');


#
# TABLE STRUCTURE FOR: employee_history
#

DROP TABLE IF EXISTS `employee_history`;

CREATE TABLE `employee_history` (
  `id` int(11) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `rate_type` int(11) NOT NULL,
  `hrate` float NOT NULL,
  `email` varchar(50) NOT NULL,
  `blood_group` varchar(10) NOT NULL,
  `address_line_1` text NOT NULL,
  `address_line_2` text NOT NULL,
  `image` text DEFAULT NULL,
  `country` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `zip` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: employee_salary_payment
#

DROP TABLE IF EXISTS `employee_salary_payment`;

CREATE TABLE `employee_salary_payment` (
  `emp_sal_pay_id` int(11) NOT NULL,
  `generate_id` int(11) NOT NULL,
  `employee_id` varchar(50) CHARACTER SET latin1 NOT NULL,
  `total_salary` decimal(18,2) NOT NULL DEFAULT 0.00,
  `total_working_minutes` varchar(50) CHARACTER SET latin1 NOT NULL,
  `working_period` varchar(50) CHARACTER SET latin1 NOT NULL,
  `payment_due` varchar(50) CHARACTER SET latin1 NOT NULL,
  `payment_date` varchar(50) CHARACTER SET latin1 NOT NULL,
  `paid_by` varchar(50) CHARACTER SET latin1 NOT NULL,
  `salary_month` varchar(70) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: employee_salary_setup
#

DROP TABLE IF EXISTS `employee_salary_setup`;

CREATE TABLE `employee_salary_setup` (
  `e_s_s_id` int(11) unsigned NOT NULL,
  `employee_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `sal_type` varchar(30) NOT NULL,
  `salary_type_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `create_date` date DEFAULT NULL,
  `update_date` datetime(6) DEFAULT NULL,
  `update_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `gross_salary` float NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense
#

DROP TABLE IF EXISTS `expense`;

CREATE TABLE `expense` (
  `id` int(11) NOT NULL,
  `date` date NOT NULL,
  `type` varchar(100) NOT NULL,
  `voucher_no` varchar(50) NOT NULL,
  `amount` float NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Administrative', 'Test', 'yes', 'no', '2022-02-26 10:57:35');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Doctors Remuneration', '', 'yes', 'no', '2022-03-27 18:09:58');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'Consultant & Surgeon Remuneration', '', 'yes', 'no', '2022-03-27 18:10:39');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 'PC Commission', '', 'yes', 'no', '2022-03-27 18:14:44');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (5, 'Patient Bill Return', '', 'yes', 'no', '2022-03-27 18:19:43');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (6, 'Laboratory Expenses', 'Pathology Related  Expense', 'yes', 'no', '2022-03-28 13:03:30');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (7, 'Salary and Allowance', 'Employee salary and benefits ', 'yes', 'no', '2022-03-29 16:07:42');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (8, 'Entertainment Expense', 'For Doctors , Stuffs and Guest Entertainment Purpose ', 'yes', 'no', '2022-03-29 16:19:35');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (9, 'Repair and Maintenance', 'Hospital and Other Maintenance Purpose', 'yes', 'no', '2022-03-29 16:45:44');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (10, 'Marketing Expense', 'Expense to Improve Sales and Hospital Patient Flow', 'yes', 'no', '2022-03-29 16:50:55');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (11, 'Mobile bill', 'use for official work', 'yes', 'no', '2022-03-31 19:48:41');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (12, 'O.T  Accesories', 'use for o.t room', 'yes', 'no', '2022-04-02 19:50:30');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (13, 'Conveyance', '', 'yes', 'no', '2022-04-12 16:02:18');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (14, 'Lab Test Commission', '', 'yes', 'no', '2022-04-12 18:02:22');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (15, 'Miscellaneous Expense', '', 'yes', 'no', '2022-04-14 12:38:10');


#
# TABLE STRUCTURE FOR: expense_item
#

DROP TABLE IF EXISTS `expense_item`;

CREATE TABLE `expense_item` (
  `id` int(11) NOT NULL,
  `expense_item_name` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES (1, 'Gass Bill');
INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES (2, 'Pc');
INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES (3, 'Nasta');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `expenses_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (2, 2, 'Echo Expense', '01', '2022-03-19', '13250.00', NULL, 'Being the amount paid against remuneration for ECHO to Dr. Monir Hossain Khan\r\n', 'yes', 'no', 42, '2022-03-27 18:41:30');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (3, 2, 'ETT Expense', '02', '2022-03-19', '3600.00', NULL, 'Being the amount paid against remuneration for ETT to Dr. Monir Hossain Khan\r\n', 'yes', 'no', 42, '2022-03-27 18:42:50');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (4, 3, 'Surgeon Fee', '03', '2022-03-19', '4000.00', NULL, 'Being the amount paid  to Dr. Sayada Siddique Eliza against Caesar operation', 'yes', 'no', 1, '2022-03-29 18:16:32');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (5, 3, 'Anesthesiologist Fee', '04', '2022-03-19', '1500.00', NULL, 'Being the amount paid  to Dr. Selim Hossain against anesthesia purpose\r\n\r\n', 'yes', 'no', 42, '2022-03-27 19:33:59');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (6, 3, 'Surgeon Fee', '05', '2022-03-19', '4500.00', NULL, 'Being the amount paid  to Dr. Sayada Siddique Eliza against Caesar operation.', 'yes', 'no', 42, '2022-03-27 19:44:06');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (7, 3, 'Anesthesiologist Fee', '06', '2022-03-19', '2000.00', NULL, 'Being the amount paid  to Dr. Selim Hossain against anesthesia purpose\r\n', 'yes', 'no', 42, '2022-03-27 19:45:02');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (8, 3, 'Surgeon Assistant Fee', '07', '2022-03-19', '500.00', NULL, 'Being the amount paid  to Mr. Shuvo against surgeon assistant fee purpose.\r\n', 'yes', 'no', 42, '2022-03-27 19:50:01');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (9, 3, 'Anesthesiologist Fee', '08', '2022-03-19', '3000.00', NULL, 'Being the amount paid  to Dr. Selim Hossain against anesthesia purpose.\r\n', 'yes', 'no', 42, '2022-03-27 19:51:26');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (10, 4, 'PC Commission', '09', '2022-03-19', '3100.00', NULL, 'Being the amount paid against PC Commission\r\n', 'yes', 'no', 42, '2022-03-27 20:00:46');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (11, 2, 'USG Expense', '10', '2022-03-19', '200.00', NULL, 'Being the amount paid  to Dr. Sayada Siddique Eliza against USG Fee\r\n', 'yes', 'no', 42, '2022-03-27 20:02:55');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (12, 1, 'Cleaning Expense', '11', '2022-03-19', '100.00', NULL, 'Being the amount paid against Cleaning purpose', 'yes', 'no', 42, '2022-03-27 20:06:50');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (13, 5, 'Cash Return', '12', '2022-03-19', '100.00', NULL, 'Being the amount return to the patient as per direction from Mr. Mofizur Rahman -AMD', 'yes', 'no', 42, '2022-03-27 20:10:50');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (14, 5, 'Cash Return', '13', '2022-03-19', '650.00', NULL, 'Being the amount return to the patient as per direction from Dr. Selim Hossen for wrong information of the patient\r\n', 'yes', 'no', 42, '2022-03-27 20:13:49');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (15, 3, 'Anesthesiologist Fee', '14', '2022-03-20', '2000.00', NULL, 'Being the amount paid  to Dr. Selim Hossain against anesthesia purpose.', 'yes', 'no', 42, '2022-03-28 12:26:12');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (16, 3, 'Surgeon Assistant Fee', '15', '2022-03-20', '500.00', NULL, 'Being the amount paid  to Mr. Akash against surgeon assistant fee purpose.\r\n', 'yes', 'no', 42, '2022-03-28 12:27:33');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (17, 6, 'Commission - Cross Matching', '16', '2022-03-20', '2000.00', NULL, 'Being the amount paid to Ashraful aginst lab test commission\r\n', 'yes', 'no', 42, '2022-03-29 16:05:34');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (18, 7, 'Special Duty', '17', '2022-03-20', '1300.00', NULL, 'Being the amount paid  against Special duty of Dr. Monir Hossen Khan Sir ', 'yes', 'no', 42, '2022-03-29 16:12:10');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (19, 4, 'PC Commission', '18', '2022-03-20', '660.00', NULL, 'Being the amount paid against PC Commission\r\n', 'yes', 'no', 42, '2022-03-29 16:13:31');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (20, 6, 'Lab test', '19', '2022-03-20', '600.00', NULL, 'Being the amount paid against ANA test from Thyroid Care And Diagnostic Centre\r\n', 'yes', 'no', 42, '2022-03-29 16:17:51');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (21, 8, 'Staffs Entertainment', '20', '2022-03-20', '400.00', NULL, 'Being the amount paid against Water bill for Stuffs.\r\n', 'yes', 'no', 42, '2022-03-29 16:21:07');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (22, 1, 'Conveyance Expense', '21', '2022-03-20', '40.00', NULL, 'Being the amount paid to Mr. Partho against Conveyance for going to Bank\r\n', 'yes', 'no', 42, '2022-03-29 16:24:57');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (23, 9, 'Lift Servicing', '22', '2022-03-21', '5000.00', NULL, 'Being the amount paid for Lift Servicing purpose \r\n', 'yes', 'no', 42, '2022-03-29 17:05:12');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (24, 10, 'Banner, Poster, Festoon', '23', '2022-03-21', '3000.00', NULL, 'Being the amount paid  for Banner hanging purpose \r\n', 'yes', 'no', 42, '2022-03-29 17:10:06');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (25, 10, 'Banner, Poster, Festoon', '24', '2022-03-21', '1980.00', NULL, 'Being the amount paid against hanging Banner', 'yes', 'no', 42, '2022-03-29 17:17:24');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (26, 1, 'Gas - cooking', '25', '2022-03-21', '1450.00', NULL, 'Being the amount paid against Gas for cooking in Nurse Stuff Hostel', 'yes', 'no', 42, '2022-03-29 17:20:31');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (27, 4, 'PC Commission', '26', '2022-03-21', '100.00', NULL, 'Being the amount paid against PC Commission\r\n', 'yes', 'no', 42, '2022-03-29 17:21:25');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (28, 1, 'Conveyance Expense', '27', '2022-03-21', '40.00', NULL, 'Being the amount paid to Mr. Partho against Conveyance for going to Bank', 'yes', 'no', 42, '2022-03-29 17:23:08');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (29, 10, 'Day Observe', '28', '2022-03-22', '10000.00', NULL, 'Being the amount paid to DC Office against Independence day observe . ', 'yes', 'no', 42, '2022-03-29 18:01:31');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (30, 10, 'Calendar', '29', '2022-03-22', '21000.00', NULL, 'Being the amount paid against Calendar making for Ramadan ', 'yes', 'no', 42, '2022-03-29 18:04:54');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (31, 9, 'AC Repair', '30', '2022-03-22', '6000.00', NULL, 'Being the amount paid against A/c Repair of Dr. Monir Sir and Accounts room A/C ', 'yes', 'no', 42, '2022-03-29 18:27:27');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (32, 10, 'Fuel for Motorcycle', '31', '2022-03-22', '1000.00', NULL, 'Being the amount paid against Fuel for Motorcycle of Marketing team', 'yes', 'no', 42, '2022-03-29 18:30:47');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (33, 10, 'Fuel for Motorcycle', '32', '2022-03-22', '500.00', NULL, 'Being the amount paid against Fuel for Motorcycle of Marketing team\r\n', 'yes', 'no', 42, '2022-03-29 18:36:43');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (34, 8, 'Staffs Entertainment', '33', '2022-03-22', '300.00', NULL, 'Being the amount paid against Water bill for Stuffs.\r\n', 'yes', 'no', 42, '2022-03-29 18:38:22');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (35, 8, 'Staffs Entertainment', '34', '2022-03-22', '90.00', NULL, 'Being the amount paid against sugar purchase.\r\n', 'yes', 'no', 42, '2022-03-29 18:39:45');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (36, 1, 'Office Stationary', '35', '2022-03-22', '10.00', NULL, 'Being the amount paid against Pen Purchase for Accounts ', 'yes', 'no', 42, '2022-03-29 18:41:57');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (37, 7, 'Dr .Tanvir  Salary', '36', '2022-03-23', '50000.00', NULL, 'Being the amount paid against advanced salary for the month of April', 'yes', 'no', 43, '2022-03-30 13:06:31');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (38, 10, 'Mike fare', '37', '2022-03-23', '2800.00', NULL, 'Being the  amount paid against mike fare purpose ', 'yes', 'no', 43, '2022-03-30 13:11:31');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (39, 4, 'PC Commission', '38', '2022-03-23', '595.00', NULL, 'Being the amount paid against PC Commission\r\n', 'yes', 'no', 43, '2022-03-30 13:13:16');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (40, 1, 'Gas - cooking', '39', '2022-03-23', '1390.00', NULL, 'Being the amount paid against Gas for cooking in Lab assistant\r\n', 'yes', 'no', 43, '2022-03-30 13:15:20');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (41, 1, 'carrying cost', '44', '2022-03-24', '18000.00', NULL, 'Being the amount paid against  carrying  cost for furniture  of  Dr. M tanvir ', 'yes', 'no', 43, '2022-03-30 17:37:31');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (42, 3, 'Surgeon Fee', '45', '2022-03-24', '4500.00', NULL, 'Being the amount paid  to Dr. Mahbuba sultana  against Caesar operation.\r\n', 'yes', 'no', 43, '2022-03-30 17:40:51');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (43, 3, 'Anesthesiologist Fee', '46', '2022-03-24', '1500.00', NULL, 'Being the amount paid  to Dr. Nizam  against anesthesia purpose\r\n', 'yes', 'no', 43, '2022-03-30 17:42:43');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (44, 3, 'Surgeon Assistant Fee', '47', '2022-03-24', '500.00', NULL, 'Being the amount paid  to Mrs.Shuly  against surgeon assistant fee purpose.\r\n', 'yes', 'no', 43, '2022-03-30 17:44:55');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (45, 1, 'labour bill', '48', '2022-03-24', '1800.00', NULL, 'Being the amount paid for labour bill to carry furniture of Dr. M tanvir ', 'yes', 'no', 43, '2022-03-30 17:48:15');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (46, 8, 'Staffs Entertainment', '49', '2022-03-24', '300.00', NULL, 'Being the amount paid against Water bill for Stuffs.\r\n', 'yes', 'no', 43, '2022-03-30 17:49:54');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (47, 10, 'Mike fare', '50', '2022-03-24', '3100.00', NULL, 'Being the  amount paid against mike fare purpose\r\n', 'yes', 'no', 43, '2022-03-30 18:39:52');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (48, 6, 'Lab test', '51', '2022-03-24', '1500.00', NULL, 'Being the amount paid against Vitamin D3 from Thyroid Care And Diagnostic Centre\r\n', 'yes', 'no', 43, '2022-03-30 18:42:08');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (49, 10, 'Entertainment', '52', '2022-03-24', '3600.00', NULL, 'Being the amount paid against marketing officer entertainment purpose ', 'yes', 'no', 43, '2022-03-30 18:47:27');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (50, 7, 'staff salary', '57', '2022-03-25', '568640.00', NULL, 'Being the amount paid against staff salary for the month of February\'2022', 'yes', 'no', 43, '2022-03-30 19:00:52');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (51, 3, 'Surgeon Fee', '58', '2022-03-25', '4500.00', NULL, 'Being the amount paid  to Dr. Sayada Siddique Eliza against Caesar operation\r\n', 'yes', 'no', 43, '2022-03-30 19:02:16');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (52, 3, 'Anesthesiologist Fee', '59', '2022-03-25', '1500.00', NULL, 'Being the amount paid  to Dr. Abdus Samad  against anesthesia purpose\r\n', 'yes', 'no', 43, '2022-03-30 19:04:52');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (53, 3, 'Surgeon Fee', '60', '2022-03-25', '4000.00', NULL, 'Being the amount paid  to Dr. Mahbuba sultana against Caesar operation\r\n', 'yes', 'no', 43, '2022-03-30 19:06:27');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (54, 3, 'Anesthesiologist Fee', '61', '2022-03-25', '1500.00', NULL, 'Being the amount paid  to Dr.  Nizam  hossain against anesthesia purpose\r\n', 'yes', 'no', 43, '2022-03-30 19:08:05');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (55, 3, 'Surgeon Assistant Fee', '62', '2022-03-25', '500.00', NULL, 'Being the amount paid  to Mrs. Shuly  against surgeon assistant fee purpose.\r\n', 'yes', 'no', 43, '2022-03-30 19:09:22');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (56, 2, 'Ultra fee', '63', '2022-03-25', '600.00', NULL, 'Being the amount paid to Dr.Aliza against ultra purpose', 'yes', 'no', 43, '2022-03-30 19:12:06');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (57, 1, 'Conveyance Expense', '64', '2022-03-25', '100.00', NULL, 'Being the amount paid to Mr. Partho against Conveyance for going to Bank\r\n', 'yes', 'no', 43, '2022-03-30 19:13:44');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (58, 10, 'Fuel for Motorcycle', '69', '2022-03-26', '500.00', NULL, 'Being the amount paid against Fuel for Motorcycle of Marketing team\r\n', 'yes', 'no', 43, '2022-03-30 19:31:13');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (59, 8, 'Staffs Entertainment', '70', '2022-03-26', '300.00', NULL, 'Being the amount paid against Water bill for Stuffs.\r\n', 'yes', 'no', 43, '2022-03-30 19:32:12');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (60, 9, 'water line', '79', '2022-03-28', '3310.00', NULL, 'Being the amount paid against repair and maintenance', 'yes', 'no', 43, '2022-03-30 20:35:01');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (61, 9, 'O.T equipment', '84', '2022-03-29', '5000.00', NULL, 'Being the amount paid against o.t equipment servicing purpose ', 'yes', 'no', 43, '2022-03-30 20:44:01');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (62, 3, 'Surgeon Fee', '85', '2022-03-29', '4000.00', NULL, 'Being the amount paid  to Dr. Runia begum alo against Caesar operation.\r\n', 'yes', 'no', 43, '2022-03-30 20:45:44');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (63, 3, 'Anesthesiologist Fee', '86', '2022-03-29', '1500.00', NULL, 'Being the amount paid  to Dr. Selim Hossain against anesthesia purpose.\r\n', 'yes', 'no', 43, '2022-03-30 20:47:24');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (64, 3, 'Surgeon Assistant Fee', '87', '2022-03-29', '500.00', NULL, 'Being the amount paid  to Mr. Akash against surgeon assistant fee purpose.\r\n', 'yes', 'no', 43, '2022-03-30 20:48:29');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (65, 3, 'Surgeon Fee', '88', '2022-03-29', '4500.00', NULL, 'Being the amount paid  to Dr. Sayada Siddique Eliza against Caesar operation.\r\n', 'yes', 'no', 43, '2022-03-30 20:49:27');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (66, 3, 'Anesthesiologist Fee', '89', '2022-03-29', '2000.00', NULL, 'Being the amount paid  to Dr. Nizam against anesthesia purpose.\r\n', 'yes', 'no', 43, '2022-03-30 20:50:27');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (67, 8, 'Doctors', '90', '2022-03-29', '4515.00', NULL, 'Being the amount paid against doctors entertainment purpose', 'yes', 'no', 43, '2022-03-30 20:52:42');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (68, 10, 'signboard', '91', '2022-03-29', '650.00', NULL, 'Being the amount paid against doctors signboard purpose', 'yes', 'no', 43, '2022-03-30 20:54:37');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (69, 1, 'printing stationary', '92', '2022-03-29', '180.00', NULL, 'Being the amount paid against printing stationary purpose ', 'yes', 'no', 43, '2022-03-30 20:59:19');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (70, 6, 'Commission - Cross Matching/stool,seamen', '97', '2022-03-30', '1900.00', NULL, 'Being the amount paid to Ashraful aginst lab test commission\r\n', 'yes', 'no', 43, '2022-03-31 19:44:43');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (71, 1, 'Office Stationary', '98', '2022-03-30', '310.00', NULL, 'Being the amount paid against office stafionary purpose\r\n', 'yes', 'no', 43, '2022-03-31 19:47:00');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (72, 11, 'mobile bill', '99', '2022-03-30', '705.00', NULL, 'Being the amount paid against mobile bill for receiption purpose', 'yes', 'no', 43, '2022-03-31 19:50:58');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (73, 8, 'Guest  Entertainment', '100', '2022-03-30', '235.00', NULL, 'Being the amount paid against guest entertainment purpose', 'yes', 'no', 43, '2022-03-31 19:54:07');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (74, 8, 'Doctors entertainment', '101', '2022-03-30', '225.00', NULL, 'Being the amount paid against doctors entertainment purpose ', 'yes', 'no', 43, '2022-03-31 19:56:11');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (75, 8, 'Staffs Entertainment', '102', '2022-03-30', '1680.00', NULL, 'Being the amount paid against  staffs entertainment ( staff nurse lunch bill,O.T incharge snacks, water jar )\r\n', 'yes', 'no', 43, '2022-03-31 19:59:32');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (76, 2, 'Round fee', '103', '2022-03-30', '300.00', NULL, 'Being the amount paid against dr . round fee purpose ', 'yes', 'no', 43, '2022-03-31 20:00:42');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (77, 1, 'Conveyance', '104', '2022-03-30', '80.00', NULL, 'Being the amount paid to Mr. Partho against Conveyance for going to Bank\r\n', 'yes', 'no', 43, '2022-03-31 20:01:37');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (78, 1, 'Gas - cooking', '105', '2022-03-30', '1400.00', NULL, 'Being the amount paid against Gas for cooking purpose\r\n', 'yes', 'no', 43, '2022-03-31 20:03:37');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (79, 4, 'p.c commission', '106', '2022-03-30', '4590.00', NULL, 'Being the amount paid against PC Commission\r\n', 'yes', 'no', 43, '2022-03-31 20:04:37');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (80, 10, 'Mike fare', '107', '2022-03-30', '4100.00', NULL, 'Being the  amount paid against mike fare purpose\r\n', 'yes', 'no', 43, '2022-03-31 20:06:09');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (81, 10, 'Mike fare', '112', '2022-03-31', '4100.00', NULL, 'Being the  amount paid against mike fare purpose\r\n', 'yes', 'no', 43, '2022-04-02 19:25:57');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (82, 9, 'Lift Servicing', '113', '2022-03-31', '1220.00', NULL, 'Being the amount paid for Lift Servicing purpose\r\n', 'yes', 'no', 43, '2022-04-02 19:28:04');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (83, 1, 'Fuel for generator', '114', '2022-03-31', '11685.00', NULL, 'Being the amount paid against Fuel for generator purpose\r\n', 'yes', 'no', 43, '2022-04-02 19:31:35');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (84, 1, 'Gas - cooking', '115', '2022-03-31', '6800.00', NULL, 'Being the amount paid against Gas for cooking in  Dr.Tanvir residence \r\n', 'yes', 'no', 43, '2022-04-02 19:35:05');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (85, 8, 'Doctors Entertainment', '116', '2022-03-31', '710.00', NULL, 'Being the amount paid against doctors entertainment purpose \r\n', 'yes', 'no', 43, '2022-04-02 19:40:05');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (86, 8, 'guest  Entertainment', '117', '2022-03-31', '3880.00', NULL, 'Being the amount paid against guest entertainment purpose \r\n', 'yes', 'no', 43, '2022-04-02 19:43:21');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (87, 1, 'Office Stationary', '118', '2022-03-31', '900.00', NULL, 'Being the amount paid against office stationary purpose \r\n', 'yes', 'no', 43, '2022-04-02 19:45:40');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (88, 1, 'Conveyance', '119', '2022-03-31', '1000.00', NULL, 'Being the amount paid to Mr. Partho against Conveyance for going to Dhaka head office\r\n', 'yes', 'no', 43, '2022-04-02 19:47:13');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (89, 1, 'courier service', '120', '2022-03-31', '220.00', NULL, 'Being the amount paid against courier service purpose ', 'yes', 'no', 43, '2022-04-02 19:49:07');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (90, 12, 'distild water', '121', '2022-03-31', '1850.00', NULL, 'Being the amount paid against  o.t accesories purpose ', 'yes', 'no', 43, '2022-04-02 19:51:41');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (91, 1, 'A.C  & Refrigerator', '126', '2022-04-01', '100701.00', NULL, 'Being the amount paid against A.C & refrigerator  purchase purpose ', 'yes', 'no', 43, '2022-04-09 18:10:17');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (92, 1, 'special duty', '127', '2022-04-01', '1500.00', NULL, 'Being the amount paid  against Special duty of Dr. Monir Hossen Khan Sir\r\n', 'yes', 'no', 43, '2022-04-09 18:13:53');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (93, 1, 'carrying cost', '128', '2022-04-01', '500.00', NULL, 'Being the amount paid against carrying purpose ', 'yes', 'no', 43, '2022-04-09 18:16:29');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (94, 10, 'Marketing  expense', '129', '2022-04-01', '750.00', NULL, 'Being the amount paid against marketing purpose (Mr.Faysal  Ahmed )', 'yes', 'no', 43, '2022-04-10 12:05:40');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (95, 10, 'Marketing expense', '130', '2022-04-01', '750.00', NULL, 'Being the amount paid against marketing purpose ( zillur  rahman )', 'yes', 'no', 43, '2022-04-10 12:12:49');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (96, 10, 'Marketing expense', '131', '2022-04-01', '900.00', NULL, 'Being the amount paid against marketing purpose ( Zubayer mullah )', 'yes', 'no', 43, '2022-04-10 12:14:01');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (97, 10, 'Marketing purpose', '132', '2022-04-01', '900.00', NULL, 'Being the amount paid against marketing purpose ( Sayed Atiq )', 'yes', 'no', 43, '2022-04-10 12:14:54');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (98, 8, 'Staff Entertainment', '133', '2022-04-02', '500.00', NULL, '10 pc filter water jar purchase (50*10=500)', 'yes', 'no', 63, '2022-04-12 11:49:04');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (99, 7, 'Special/Overtime Duty', '134', '2022-04-02', '400.00', NULL, 'Cash Paid to Mrs. Sharmin & Akhi for Special duty on 31.03.2022.', 'yes', 'no', 63, '2022-04-12 11:56:12');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (100, 8, 'Staff Entertainment', '135', '2022-04-03', '500.00', NULL, 'Paid to Mr. Ahmad for 10 Jar Filtering water jar purchase.\r\n', 'yes', 'no', 63, '2022-04-12 13:15:24');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (101, 1, 'Gas - Cooking', '136', '2022-04-03', '1400.00', NULL, 'Paid to Manik raja for Purchase of 1 sylinder Gas.', 'yes', 'no', 63, '2022-04-12 13:20:30');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (102, 5, 'Wrong Entry', '137', '2022-04-03', '500.00', NULL, 'Wrong entry correction. ', 'yes', 'no', 63, '2022-04-12 14:12:41');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (103, 2, 'Echo', '138', '2022-04-04', '9600.00', NULL, 'Paid to Dr. Monir Sir for Echo purpose. ', 'yes', 'no', 63, '2022-04-12 14:59:25');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (104, 2, 'E.T.T', '139', '2022-04-12', '5000.00', NULL, 'Paid to Dr. Monir Sir for E.T.T Purpose.', 'yes', 'no', 63, '2022-04-12 15:04:12');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (105, 3, 'Surgeon Fee', '140', '2022-04-04', '4500.00', NULL, 'Cash Paid to Dr. Eliza mam for Surgeon fee. ', 'yes', 'no', 63, '2022-04-12 15:16:02');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (106, 3, 'Anesthesia Fee', '141', '2022-04-04', '1500.00', NULL, 'Paid to Dr. Selim for Anesthesia fee.', 'yes', 'no', 63, '2022-04-12 15:19:49');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (107, 3, 'Surgeon Fee', '142', '2022-04-04', '4000.00', NULL, 'Paid to Dr. Eliza mam for Surgeon fee.', 'yes', 'no', 63, '2022-04-12 15:24:25');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (108, 3, 'Anesthesia Fee', '143', '2022-04-04', '1500.00', NULL, 'Paid to Dr. Sumon for Anesthesia fee.', 'yes', 'no', 63, '2022-04-12 15:27:54');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (109, 3, 'Anesthesia Fee', '144', '2022-04-04', '1500.00', NULL, 'Paid to Dr. Nizam sir for Anesthesia fee.', 'yes', 'no', 63, '2022-04-12 15:30:54');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (110, 6, 'Lab Test', '145', '2022-04-04', '6520.00', NULL, 'Paid of outsite Lab test purpose. ', 'yes', 'no', 63, '2022-04-12 15:39:03');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (111, 6, 'Lab Test', '146', '2022-04-04', '2200.00', NULL, 'Paid of outsite lab test purpose.', 'yes', 'no', 63, '2022-04-12 15:50:47');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (112, 7, 'Salary', '147', '2022-04-04', '8000.00', NULL, 'Paid to Mr. Sumon molla for monthly Salary March/22.', 'yes', 'no', 63, '2022-04-12 15:55:24');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (113, 10, 'Marketing expense', '148', '2022-04-04', '500.00', NULL, 'Paid to Mr. Foysal for purchase of petrol.', 'yes', 'no', 63, '2022-04-12 15:58:07');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (114, 13, 'Conveyance Exp.', '149', '2022-04-04', '20000.00', NULL, 'Paid to Mr. Abish for Dr. Hosne Ara mam pays car rental to bring her goods from Dhaka.', 'yes', 'no', 63, '2022-04-12 16:09:08');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (115, 1, 'Labour bill', '150', '2022-04-04', '1800.00', NULL, 'Dr. Hosne Ara mam pays labor rent to lift her goods to the 3rd floor.', 'yes', 'no', 63, '2022-04-12 16:21:37');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (116, 7, 'Salary', '151', '2022-04-05', '6000.00', NULL, 'Paid to Mr. Mannan for monthly salary March/22.', 'yes', 'no', 63, '2022-04-12 17:01:20');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (117, 10, 'Marketing Expense', '152', '2022-04-05', '3300.00', NULL, 'Paid to Mr. Shaon for doctor nameplate writing.', 'yes', 'no', 63, '2022-04-12 17:07:06');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (118, 10, 'Marketing Expense', '153', '2022-04-05', '1710.00', NULL, 'Payment for putting up banners', 'yes', 'no', 63, '2022-04-12 17:09:36');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (119, 1, 'Stationary', '154', '2022-04-05', '164.00', NULL, 'Purchase of stationary for office use.', 'yes', 'no', 63, '2022-04-12 17:16:08');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (120, 11, 'Mobile bill', '155', '2022-04-05', '500.00', NULL, 'Paid to Salahuddin for mobile bill for march/22.\r\n', 'yes', 'no', 63, '2022-04-12 17:45:24');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (121, 1, 'Linen Exp.', '156', '2022-04-05', '1100.00', NULL, 'Purchase of Mattress & pillow  for office staff.', 'yes', 'no', 63, '2022-04-12 17:50:01');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (122, 8, 'Doctor Entertainment', '157', '2022-04-05', '2935.00', NULL, 'Paid to Mr. Shaon for purchase of tea, suger, etc. for Doctor.', 'yes', 'no', 63, '2022-04-12 17:53:39');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (123, 8, 'Staff entertainment', '158', '2022-04-05', '705.00', NULL, 'Paid to Mr. Shaun for purchase of tea, sugar, etc. for staff.', 'yes', 'no', 63, '2022-04-12 17:58:22');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (124, 14, 'Lab Test Commission', '159', '2022-04-05', '1750.00', NULL, 'Paid to Mr. Ashraful for Lab test commission.', 'yes', 'no', 63, '2022-04-12 18:05:49');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (125, 12, 'Oxygen', '160', '2022-04-06', '1760.00', NULL, 'Purchase of oxygen to refill the cylinder 8pc X 220=1760/- use for OT & Emergency.', 'yes', 'no', 63, '2022-04-13 10:32:24');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (126, 12, 'Distilled Water', '161', '2022-04-06', '1800.00', NULL, 'Purchase of 5 litter distilled water.', 'yes', 'no', 63, '2022-04-13 11:09:28');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (127, 10, 'Marketing Expense', '162', '2022-04-06', '1000.00', NULL, 'Dr. Hosne Ara mam rented an autorickshaw and mic to promote her.', 'yes', 'no', 63, '2022-04-13 11:18:23');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (128, 1, 'Stationary', '163', '2022-04-06', '1100.00', NULL, 'Purchase of flim kham, L.E.D, silicon, ', 'yes', 'no', 63, '2022-04-13 11:24:55');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (129, 11, 'Mobile bill', '164', '2022-04-13', '600.00', NULL, '600 taka recharge of mobile no. 01777515767 for 1 month.', 'yes', 'no', 63, '2022-04-13 11:28:45');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (130, 3, 'Anesthesia Fee', '165', '2022-04-06', '1500.00', NULL, 'Paid to Dr. Nijam for Anesthesia fee for saesar of patient sumi.', 'yes', 'no', 63, '2022-04-13 11:34:29');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (131, 8, 'Guest Entertainment', '166', '2022-04-06', '450.00', NULL, 'Paid to Mr. Mannan for purchase of biriyani, cake, banana & biscuits.', 'yes', 'no', 63, '2022-04-13 11:38:16');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (132, 8, 'Guest Entertainment', '167', '2022-04-06', '500.00', NULL, 'Paid to Mr. Shahabul for purchase of rich, fish, vesitable & dal for incoming IT people from dhaka.', 'yes', 'no', 63, '2022-04-13 11:43:14');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (133, 1, 'Gas - Cooking', '168', '2022-04-06', '1430.00', NULL, 'Purchase of Gas for staff living room for cooking.', 'yes', 'no', 63, '2022-04-13 11:45:50');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (134, 1, 'Gas - cooking', '169', '2022-04-06', '1400.00', NULL, 'Paid to Mrs. Sharmin for purchase of Gas for staff living room for cooking.', 'yes', 'no', 63, '2022-04-13 11:48:55');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (135, 2, 'Doctor Fee', '170', '2022-04-06', '22225.00', NULL, 'Paid to Dr. Al-Amin for 99 USG commission.', 'yes', 'no', 63, '2022-04-13 11:52:34');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (136, 1, 'Courier charge', '171', '2022-04-06', '200.00', NULL, 'Paid to courier charge for X-ray file from dhaka.', 'yes', 'no', 63, '2022-04-13 11:57:32');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (137, 13, 'Van vara', '172', '2022-04-06', '200.00', NULL, 'Paid to Mr. Ahmad for van vara for bring gas cylinder.', 'yes', 'no', 63, '2022-04-13 12:02:29');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (138, 13, 'conveyance', '173', '2022-04-06', '50.00', NULL, 'Paid to Mr. Sahabul for vara for purchase of kham.', 'yes', 'no', 63, '2022-04-13 12:04:42');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (139, 4, 'PC Commission', '174', '2022-04-06', '2050.00', NULL, 'Paid to Mr. Salahuddin for PC Commission.', 'yes', 'no', 63, '2022-04-13 12:07:57');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (140, 10, 'Marketing Expense', '175', '2022-04-07', '3800.00', NULL, 'Paid to Belal for mike rent, easibike 2*1400=2800/- & autoriska=1000/- for Thursday and Friday to promote the names of the coming doctors. ', 'yes', 'no', 63, '2022-04-13 12:43:46');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (141, 10, 'Baner, Po', '176', '2022-04-13', '1750.00', NULL, '', 'yes', 'no', 63, '2022-04-13 12:45:56');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (142, 8, 'Staff Entertainment', '177', '2022-04-07', '400.00', NULL, 'Purchase of filtering water jar for Staff (8*50=400)', 'yes', 'no', 63, '2022-04-13 12:56:53');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (143, 10, 'Marketing Expense', '178', '2022-04-07', '450.00', NULL, 'Paid to Mr. Salahuddin for participate of promotion Mr. Akkas 2 day X 150=300/- & Mr. Sumon 1 day X 150=150/-', 'yes', 'no', 63, '2022-04-13 13:06:05');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (144, 10, 'Marketing Expense', '179', '2022-04-08', '900.00', NULL, 'Paid to Mr. Zobair for lunch on 01.04.22 to 07.04.22.', 'yes', 'no', 63, '2022-04-13 15:01:37');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (145, 10, 'Marketing Expense', '180', '2022-04-08', '750.00', NULL, 'Paid to Mr. Zillur rohman for lunch on 01.04.22 to 07.04.22.', 'yes', 'no', 63, '2022-04-13 15:03:25');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (146, 10, 'Marketing Expense', '181', '2022-04-08', '900.00', NULL, 'Paid to Mr. Atik for lunch on 01.04.22 to 08.04.22.', 'yes', 'no', 63, '2022-04-13 15:05:08');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (147, 10, 'Marketing Expense', '182', '2022-04-08', '900.00', NULL, 'Paid to Mr. Foysal for lunch on 01.04.22 to 07.04.22', 'yes', 'no', 63, '2022-04-13 15:06:27');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (148, 10, 'Marketing Expense', '183', '2022-04-08', '1000.00', NULL, 'Paid to Mr. Atic for purchase of petrol for marketing purpose.', 'yes', 'no', 63, '2022-04-13 15:07:47');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (149, 9, 'Repair & Maintenance', '184', '2022-04-08', '1250.00', NULL, 'Paid to Mr. Zillur rohman for motorcycle repair.', 'yes', 'no', 63, '2022-04-13 15:14:59');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (150, 10, 'Marketing Expense', '185', '2022-04-08', '300.00', NULL, 'Paid to Mr. Akkas for participate on marketing.', 'yes', 'no', 63, '2022-04-13 15:18:53');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (151, 10, 'Marketing Expense', '186', '2022-04-08', '3000.00', NULL, 'Paid to Mr. Taijul for 20pc banar & 1000pc poster hanging purpose.', 'yes', 'no', 63, '2022-04-13 15:31:28');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (152, 10, 'Marketing Expense', '187', '2022-04-13', '3800.00', NULL, 'Paid to Mr. Rubel for Rent a mic for the campaign of doctors who arrive on Fridays and Saturdays.', 'yes', 'no', 63, '2022-04-13 15:40:44');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (153, 10, 'Marketing Expense', '188', '2022-04-08', '200.00', NULL, 'Paid to Mr. Taijul for Iftari purpose.', 'yes', 'no', 63, '2022-04-13 15:43:05');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (154, 13, 'Conveyance', '189', '2022-04-09', '100.00', NULL, 'Paid to Mr. Rahee for Travel fare for making LED boards & Nameplate.', 'yes', 'no', 63, '2022-04-13 16:20:00');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (155, 10, 'LED Board', '190', '2022-04-09', '2200.00', NULL, 'Paid to Mr. Rahee for purchase of LED board  & nameplate  for Dr. Aliza mam & Dr. Hosne ara mam.', 'yes', 'no', 63, '2022-04-13 16:30:32');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (156, 8, 'Staff Entertainment', '191', '2022-04-09', '400.00', NULL, 'Paid to Mr. Ahmad for Purchase of filtering water jar 8*50=400/-', 'yes', 'no', 63, '2022-04-13 16:32:56');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (157, 1, 'Special/Overtime Duty', '192', '2022-04-09', '1500.00', NULL, 'Paid to Mr. Umit poddar for 6 employer overtime duty for Dr. Monir sir.', 'yes', 'no', 63, '2022-04-13 16:37:55');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (158, 8, 'Doctor Entertainment', '193', '2022-04-10', '1070.00', NULL, 'Paid to Mr. Shaun for purchase of tea, suger, porata, egg, coffee, jus, chiken, fish & rice for Doctor.', 'yes', 'no', 63, '2022-04-14 11:12:43');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (159, 8, 'Staff Entertainment', '194', '2022-04-14', '500.00', NULL, 'Paid to Mr. Shahabul for purchase of filtering water jar 10pc X 50=500/-', 'yes', 'no', 63, '2022-04-14 11:16:52');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (160, 8, 'Iftar Expense', '195', '2022-04-10', '6770.00', NULL, 'Paid to Mr. Mannan for Iftar purpose on 03.04.22 to 07.04.22.', 'yes', 'no', 63, '2022-04-14 11:30:08');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (161, 13, 'conveyance', '196', '2022-04-10', '200.00', NULL, 'Paid to Mr. Shahabul for conveyance.', 'yes', 'no', 63, '2022-04-14 11:32:27');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (162, 7, 'Salary', '197', '2022-04-10', '50000.00', NULL, 'Paid to Dr. Selim for salary on march/22.', 'yes', 'no', 63, '2022-04-14 11:34:38');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (163, 7, 'Salary', '198', '2022-04-10', '17770.00', NULL, 'Paid to Dr. Asif Neyaj Rocy for Salary on march/22.', 'yes', 'no', 63, '2022-04-14 11:45:37');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (164, 10, 'petrol', '199', '2022-04-10', '1000.00', NULL, 'Paid to Mr. Zillur rohman for purchase of petrol.', 'yes', 'no', 63, '2022-04-14 11:48:38');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (165, 10, 'Signboard', '200', '2022-04-10', '3500.00', NULL, 'Paid to Mr. Shaun for lighting on LED Board.', 'yes', 'no', 63, '2022-04-14 11:57:22');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (166, 1, 'Courier Charge', '201', '2022-04-10', '200.00', NULL, 'Paid to Mr. Shahabul for carrier charges for X-ray film.', 'yes', 'no', 63, '2022-04-14 12:01:04');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (167, 1, 'Stationary', '202', '2022-04-10', '4650.00', NULL, 'Paid to Mr. Shahabul for purchase of 30pc plate X 155=4650/-', 'yes', 'no', 63, '2022-04-14 12:05:48');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (168, 1, 'Stationary', '203', '2022-04-10', '270.00', NULL, 'Paid to Mr. Shahabul for purchase of Savlon & Mask.', 'yes', 'no', 63, '2022-04-14 12:08:57');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (169, 3, 'Anesthesia Fee', '204', '2022-04-10', '1500.00', NULL, 'Paid to Mr. Nizam for Anesthesia fee.', 'yes', 'no', 63, '2022-04-14 12:14:32');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (170, 3, 'Anesthesia Fee', '205', '2022-04-10', '1500.00', NULL, 'Paid to Dr. Selim for anesthesia fee for Sumi Akhtar\'s Caesarean.', 'yes', 'no', 63, '2022-04-14 12:18:40');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (171, 2, 'ETT & Echo', '206', '2022-04-10', '14450.00', NULL, 'Paid to Dr. Monir sir for ETT=3700/- & Echo=10750/-', 'yes', 'no', 63, '2022-04-14 12:24:45');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (172, 1, 'New Paper', '207', '2022-04-10', '320.00', NULL, 'Paid to Mr. Shahabul for monthly new paper bill march/22 .', 'yes', 'no', 63, '2022-04-14 12:35:38');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (173, 15, 'Cleaning Expense', '208', '2022-04-10', '5000.00', NULL, 'Paid to Mr. Zahid for monthly dirty cleaning bill march/22.', 'yes', 'no', 63, '2022-04-14 12:41:13');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (174, 8, 'Staff Entertainment', '209', '2022-04-11', '400.00', NULL, 'Paid to Mr. Ahmad for purchase of filtering water jar 8pc X 50=400/-', 'yes', 'no', 63, '2022-04-14 14:10:49');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (175, 7, 'Salary', '210', '2022-04-11', '3000.00', NULL, 'Paid to Mr. Rasel for monthly salary march/22.', 'yes', 'no', 63, '2022-04-14 14:13:17');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (176, 7, 'Salary', '211', '2022-04-11', '3000.00', NULL, 'Paid to Mr. Laiju for monthly salary march/22.', 'yes', 'no', 63, '2022-04-14 14:23:57');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (177, 7, 'Salary', '212', '2022-04-11', '17740.00', NULL, 'Paid to Dr. Tanvir for salary march/22.', 'yes', 'no', 63, '2022-04-14 14:26:20');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (178, 7, 'Salary', '213', '2022-04-11', '4000.00', NULL, 'Paid to Sumi for salary on march/22.', 'yes', 'no', 63, '2022-04-14 14:28:57');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (179, 4, 'PC Commission', '214', '2022-04-11', '3365.00', NULL, 'Paid to Mr. Salahuddin for PC Commission.', 'yes', 'no', 63, '2022-04-14 14:32:17');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (180, 15, 'Labour Bill', '215', '2022-04-11', '500.00', NULL, 'Paid to Mr. Ahmad for cleaning of fan & wale.', 'yes', 'no', 63, '2022-04-14 14:37:51');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (181, 1, 'Electricity bill', '216', '2022-04-11', '144864.00', NULL, 'Paid to Mr. Badol dhaly for Electricity bill on 3 month Jan, Feb & March/22.', 'yes', 'no', 63, '2022-04-14 14:43:11');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (182, 1, 'Internet Bill', '217', '2022-04-11', '12600.00', NULL, 'Paid to Adorsh Online network for monthly net bill march/22.', 'yes', 'no', 63, '2022-04-14 14:46:55');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (183, 1, 'Printing Expense', '218', '2022-04-12', '8000.00', NULL, 'Paid to Mr. Shahabul for debit voucher printing expense (100 Books X 80=8000/-', 'yes', 'no', 63, '2022-04-14 15:47:57');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (184, 15, 'Courier Charge', '219', '2022-04-12', '1100.00', NULL, 'Paid to Mr. Shahabul for courier charge and freight for the arrival of surgical goods & mojaik stone from Dhaka.', 'yes', 'no', 63, '2022-04-14 15:53:53');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (185, 13, 'Traveling Expense', '220', '2022-04-12', '160.00', NULL, 'Paid to Mr. Badol Dhaly for traveling expense for cash deposit to bank.', 'yes', 'no', 63, '2022-04-14 15:57:31');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (186, 13, 'Octane', '221', '2022-04-12', '2000.00', NULL, 'Paid to Mr. Ahmad for Purchase of fuel for transporting Dr. Monir Sir to Kathalbari Ghat', 'yes', 'no', 63, '2022-04-14 16:04:58');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (187, 1, 'Stationary', '222', '2022-04-13', '3480.00', NULL, 'Paid to Mr. Shahabul for purchase of A4 size paper (12 pc X 290=3480)', 'yes', 'no', 63, '2022-04-16 12:46:02');


#
# TABLE STRUCTURE FOR: finding
#

DROP TABLE IF EXISTS `finding`;

CREATE TABLE `finding` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `finding_category_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `finding_category_id` (`finding_category_id`),
  CONSTRAINT `finding_ibfk_1` FOREIGN KEY (`finding_category_id`) REFERENCES `finding_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: finding_category
#

DROP TABLE IF EXISTS `finding_category`;

CREATE TABLE `finding_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fixed_assets
#

DROP TABLE IF EXISTS `fixed_assets`;

CREATE TABLE `fixed_assets` (
  `id` int(11) NOT NULL,
  `item_code` varchar(50) NOT NULL,
  `item_name` varchar(100) NOT NULL,
  `price` float NOT NULL,
  `insert_date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (1, '2nd floor', '', '2022-02-18 11:45:17');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (2, '3rd Floor', '', '2022-02-28 09:53:03');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (3, '4 th Floor', '', '2022-02-28 09:53:33');


#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext DEFAULT NULL,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 09:14:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', 1, 0, NULL, 'no', '2022-01-17 09:20:36');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 16:54:41');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (6, 1, 'Farmacy login', 0, 0, '1', 1, 'http://10.8.99.99/100/', 'farmacy-login', 3, 0, NULL, 'no', '2022-03-18 02:23:45');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (7, 1, 'Hospital Login', 0, 0, '1', 1, 'http://10.8.99.99/99/site/login', 'hospital-login', 5, 0, NULL, 'no', '2022-03-18 02:23:14');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` mediumtext DEFAULT NULL,
  `ext_url_link` mediumtext DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:54:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home page first new', 'page/home-page-first-new', 'page', 'home-page-first-new', '', '', '', '', '<p>Home page first</p>', '0000-00-00', 1, 1, 'no', '2021-09-28 21:49:10');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 09:00:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<title></title>\r\n<p>404 page found</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 17:35:15');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 12:27:54');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (5, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">First name: <input name=\"fname\" type=\"text\" /><br />\r\nLast name: <input name=\"lname\" type=\"text\" /><br />\r\n<input type=\"submit\" value=\"Submit\" />&nbsp;</form>', '0000-00-00', 0, 1, 'no', '2021-09-24 17:35:25');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` mediumtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) NOT NULL DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_online_appointment` int(11) DEFAULT NULL,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext DEFAULT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_online_appointment`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'darkgray', NULL, 1, 1, NULL, './uploads/hospital_content/logo/front_logo-61e4f70b06a6b4.63157873.png', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', 'Copyright@ hilfulsoft- China', './uploads/hospital_content/logo/front_fav_icon-61e4f70b06bb65.03308344.png', '2022-01-17 10:56:43');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` text DEFAULT NULL,
  `follow_up_date` date DEFAULT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (1, 'Jaman', '01712142411', '2022-03-12', 'Dr,Amin', NULL, '', '', 'Incoming', '2022-03-12 23:41:04');


#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (1, 'morning', '00:00:00', '08:00:00', '2022-03-02 22:58:42');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (2, 'evening', '12:30:00', '13:00:00', '2022-03-02 23:01:00');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_deleted` varchar(10) DEFAULT 'no',
  `documents` varchar(255) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `inc_head_id` (`inc_head_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`inc_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `income_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8;

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (1, 1, 'Indoor Patient Department (IPD)', '', '2022-03-19', '5000.00', '', 'no', NULL, 42, 'yes', '2022-03-22 17:35:55');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (2, 1, 'Outdoor Patient Department (OPD)', '', '2022-03-19', '1000.00', 'Being the amount received against OPD Patient ', 'no', NULL, 1, 'yes', '2022-03-29 18:15:53');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (3, 1, 'Outdoor Patient Department (OPD)', '', '2022-03-19', '1000.00', 'Being the amount received against OPD  patient', 'no', NULL, 42, 'yes', '2022-03-22 17:45:25');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (4, 3, 'Pathology', '', '2022-03-19', '1640.00', 'Outdoor Patient Department (OPD)', 'no', NULL, 42, 'yes', '2022-03-22 17:46:11');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (5, 3, 'Radiology', '', '2022-03-19', '5350.00', 'Being the amount Collected against Radiology income', 'no', NULL, 42, 'yes', '2022-03-22 17:48:03');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (6, 1, 'Outdoor Patient Department (OPD)', '', '2022-03-20', '900.00', 'Being the amount collected against OPD patient income', 'no', NULL, 42, 'yes', '2022-03-22 18:01:20');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (7, 1, 'Indoor Patient Department (IPD)', '', '2022-03-20', '11500.00', 'Being the amount received against IPD patient ', 'no', NULL, 42, 'yes', '2022-03-22 18:02:31');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (8, 3, 'Pathology', '', '2022-03-20', '8190.00', '', 'no', NULL, 42, 'yes', '2022-03-22 18:02:56');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (9, 3, 'Radiology', '', '2022-03-20', '6600.00', 'Being the amount collected against Radiology Income', 'no', NULL, 42, 'yes', '2022-03-22 18:05:02');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (10, 1, 'Outdoor Patient Department (OPD)', '', '2022-03-21', '900.00', 'Being amount collected against OPD patient', 'no', NULL, 42, 'yes', '2022-03-25 19:51:33');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (11, 1, 'Indoor Patient Department (IPD)', '', '2022-03-21', '15000.00', 'Being amount collected against IPD patient\r\n', 'no', NULL, 42, 'yes', '2022-03-25 19:52:37');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (12, 3, 'Radiology', '', '2022-03-21', '11700.00', 'Being the amount Collected against Radiology income\r\n', 'no', NULL, 42, 'yes', '2022-03-25 19:54:44');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (13, 3, 'Pathology', '', '2022-03-21', '10450.00', 'Being the amount Collected against Pathology income\r\n', 'no', NULL, 42, 'yes', '2022-03-25 19:55:55');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (14, 1, 'Outdoor Patient Department (OPD)', '14', '2022-03-22', '1150.00', 'Being the amount collected against Outdoor Patient Department (OPD)', 'no', NULL, 42, 'yes', '2022-03-29 18:58:36');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (15, 1, 'Indoor Patient Department (IPD)', '15', '2022-03-22', '6500.00', 'Being the amount Collected against Indoor Patient Department IPD', 'no', NULL, 42, 'yes', '2022-03-29 19:02:23');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (16, 3, 'Pathology', '16', '2022-03-22', '6600.00', 'Being the amount collected against Pathology Income', 'no', NULL, 42, 'yes', '2022-03-29 19:04:54');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (17, 3, 'Radiology', '17', '2022-03-22', '12500.00', 'Being the amount collected against Radiology income', 'no', NULL, 42, 'yes', '2022-03-29 19:06:34');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (18, 1, 'Indoor Patient Department (IPD)', '18', '2022-03-23', '17700.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-03-30 12:58:18');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (19, 1, 'Outdoor Patient Department (OPD)', '19', '2022-03-23', '800.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-03-30 12:59:31');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (20, 3, 'Pathology', '20', '2022-03-23', '6950.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 13:00:38');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (21, 3, 'Radiology', '21', '2022-03-23', '8850.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 13:01:25');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (22, 1, 'Indoor Patient Department (IPD)', '40', '2022-03-24', '1000.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-03-30 17:28:57');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (23, 1, 'Outdoor Patient Department (OPD)', '41', '2022-03-24', '1550.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-03-30 17:29:48');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (24, 3, 'Pathology', '42', '2022-03-24', '16050.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 17:30:59');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (25, 3, 'Radiology', '43', '2022-03-24', '15040.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 17:32:09');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (26, 1, 'Indoor Patient Department (IPD)', '53', '2022-03-25', '7900.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-03-30 18:51:07');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (27, 1, 'Outdoor Patient Department (OPD)', '54', '2022-03-25', '1200.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-03-30 18:52:21');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (28, 3, 'Pathology', '55', '2022-03-25', '40230.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 18:53:40');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (29, 3, 'Radiology', '56', '2022-03-25', '27751.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 18:55:18');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (30, 1, 'Indoor Patient Department (IPD)', '65', '2022-03-26', '4000.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-03-30 19:27:17');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (31, 1, 'Outdoor Patient Department (OPD)', '66', '2022-03-26', '800.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-03-30 19:28:02');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (32, 3, 'Pathology', '67', '2022-03-26', '14050.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 19:28:48');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (33, 3, 'Radiology', '68', '2022-03-26', '10000.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 19:29:29');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (34, 1, 'Indoor Patient Department (IPD)', '71', '2022-03-27', '8900.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-03-30 19:33:57');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (35, 1, 'Outdoor Patient Department (OPD)', '72', '2022-03-27', '2600.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-03-30 19:35:02');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (36, 3, 'Pathology', '73', '2022-03-27', '7600.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 19:35:50');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (37, 3, 'Radiology', '74', '2022-03-27', '11800.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 19:36:36');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (38, 1, 'Indoor Patient Department (IPD)', '75', '2022-03-28', '1000.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-03-30 20:26:19');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (39, 1, 'Outdoor Patient Department (OPD)', '76', '2022-03-28', '800.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-03-30 20:27:05');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (40, 3, 'Pathology', '77', '2022-03-28', '6450.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 20:29:02');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (41, 3, 'Radiology', '78', '2022-03-28', '5850.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 20:29:47');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (42, 1, 'Indoor Patient Department (IPD)', '80', '2022-03-29', '15000.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-03-30 20:35:58');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (43, 1, 'Outdoor Patient Department (OPD)', '81', '2022-03-29', '1500.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-03-30 20:36:48');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (44, 3, 'Pathology', '82', '2022-03-29', '2288.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 20:38:09');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (45, 3, 'Radiology', '83', '2022-03-29', '8562.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-03-30 20:39:15');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (46, 1, 'Indoor Patient Department (IPD)', '93', '2022-03-30', '300.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-03-31 19:39:42');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (47, 1, 'Outdoor Patient Department (OPD)', '94', '2022-03-30', '1700.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-03-31 19:40:51');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (48, 3, 'Pathology', '95', '2022-03-30', '4700.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-03-31 19:41:51');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (49, 3, 'Radiology', '96', '2022-03-30', '6650.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-03-31 19:42:33');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (50, 1, 'Indoor Patient Department (IPD)', '108', '2022-03-31', '17000.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-04-02 19:15:03');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (51, 1, 'Outdoor Patient Department (OPD)', '109', '2022-03-31', '1100.00', 'Being the amount collected against Outdoor Patient Department (OPD)\r\n', 'no', NULL, 43, 'yes', '2022-04-02 19:15:43');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (52, 3, 'Pathology', '110', '2022-03-31', '30960.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-04-02 19:19:26');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (53, 3, 'Radiology', '111', '2022-03-31', '44000.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 43, 'yes', '2022-04-02 19:20:25');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (54, 1, 'Indoor Patient Department (IPD)', '122', '2022-04-01', '1000.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-04-09 17:53:15');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (55, 1, 'Outdoor Patient Department (OPD)', '123', '2022-04-01', '1600.00', '', 'no', NULL, 1, 'yes', '2022-04-12 10:55:44');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (56, 3, 'Pathology', '124', '2022-04-01', '36075.00', 'Being the amount collected against Pathology Income\r\n', 'no', NULL, 43, 'yes', '2022-04-09 17:55:50');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (57, 3, 'Radiology', '125', '2022-04-01', '20101.00', 'Being the amount collected against Radiology income\r\n', 'no', NULL, 1, 'yes', '2022-04-12 10:57:48');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (58, 1, 'Indoor Patient Department (IPD)', '133', '2022-04-02', '1600.00', 'Being the amount Collected against Indoor Patient Department IPD\r\n', 'no', NULL, 43, 'yes', '2022-04-10 12:23:25');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (59, 1, 'OPD', '134', '2022-04-02', '800.00', 'Cash Receipt from  Outdoor Patient Department.', 'no', NULL, 63, 'yes', '2022-04-12 11:31:27');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (60, 3, 'Pathology', '135', '2022-04-02', '9650.00', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-12 11:36:30');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (61, 3, 'Radiology Income', '135', '2022-04-02', '14500.00', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-12 11:40:32');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (62, 1, 'IPD', '137', '2022-04-03', '9600.00', 'Cash receipt from IPD Income.', 'no', NULL, 63, 'yes', '2022-04-12 12:28:36');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (63, 1, 'OPD', '138', '2022-04-03', '1150.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-12 12:30:19');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (64, 3, 'Pathology', '139', '2022-04-03', '3549.95', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-12 12:35:25');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (65, 3, 'Radiology', '140', '2022-04-03', '3900.05', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-12 12:37:41');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (66, 1, 'IPD', '141', '2022-04-04', '12100.00', 'Cash receipt from IPT Income.', 'no', NULL, 63, 'yes', '2022-04-12 14:34:26');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (67, 1, 'OPD', '142', '2022-04-04', '1950.00', 'Cash receipt from OPD Income.\r\n', 'no', NULL, 63, 'yes', '2022-04-12 14:36:19');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (68, 3, 'Pathology', '143', '2022-04-04', '7300.04', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-12 14:41:59');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (69, 3, 'Radiology', '144', '2022-04-04', '11099.96', 'Cash receipt from Radiology. ', 'no', NULL, 63, 'yes', '2022-04-12 14:44:29');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (70, 1, 'IPD', '145', '2022-04-05', '9100.00', 'Cash receipt from IPD Income.', 'no', NULL, 63, 'yes', '2022-04-12 16:45:52');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (71, 1, 'OPD', '146', '2022-04-05', '1200.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-12 16:48:12');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (72, 3, 'Pathology', '147', '2022-04-05', '6919.00', 'Cash receipt from pathology Income.', 'no', NULL, 63, 'yes', '2022-04-12 16:51:18');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (73, 3, 'Radiology', '148', '2022-04-05', '11681.00', 'Cash receipt from radiology income.', 'no', NULL, 63, 'yes', '2022-04-12 16:53:56');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (74, 1, 'IPD', '149', '2022-04-06', '100.00', 'Cash receipt from IPD Income.', 'no', NULL, 63, 'yes', '2022-04-13 10:00:42');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (75, 1, 'OPD', '150', '2022-04-06', '1900.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-13 10:02:32');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (76, 3, 'Pathology', '151', '2022-04-06', '3350.00', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-13 10:05:11');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (77, 3, 'Radiology', '152', '2022-04-06', '8300.00', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-13 10:06:36');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (78, 1, 'IPD', '153', '2022-04-07', '9000.00', 'Cash receipt from IPD Income.', 'no', NULL, 63, 'yes', '2022-04-13 12:27:41');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (79, 1, 'OPD', '154', '2022-04-07', '1500.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-13 12:34:24');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (80, 3, 'Pathology', '155', '2022-04-07', '20250.00', 'Cash receipt from Pathology income.', 'no', NULL, 63, 'yes', '2022-04-13 12:35:38');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (81, 3, 'Radiology', '156', '2022-04-07', '44660.00', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-13 12:36:53');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (82, 1, 'IPD', '157', '2022-04-08', '10000.00', 'Cash receipt from IPD Income.', 'no', NULL, 63, 'yes', '2022-04-13 14:01:16');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (83, 1, 'OPD', '158', '2022-04-08', '5200.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-13 14:02:34');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (84, 3, 'Pathology', '159', '2022-04-08', '29840.00', 'Cash receipt from Pathology.', 'no', NULL, 63, 'yes', '2022-04-13 14:04:19');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (85, 3, 'Radiology', '160', '2022-04-08', '22020.00', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-13 14:06:00');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (86, 1, 'OPD', '160', '2022-04-09', '3800.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-13 16:07:00');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (87, 3, 'Pathology', '162', '2022-04-09', '15660.00', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-13 16:11:03');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (88, 3, 'Radiology', '163', '2022-04-09', '12000.00', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-13 16:12:59');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (89, 1, 'IPD', '163', '2022-04-10', '15700.00', 'Cash receipt from IPD Income.', 'no', NULL, 63, 'yes', '2022-04-14 10:47:21');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (90, 1, 'OPD', '164', '2022-04-10', '2900.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-14 10:49:16');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (91, 3, 'Pathology', '165', '2022-04-10', '14550.00', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-14 10:52:04');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (92, 3, 'Radiology', '166', '2022-04-10', '11200.00', 'Cash receipt from Ratiology Income.', 'no', NULL, 63, 'yes', '2022-04-14 10:54:47');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (93, 1, 'IPD', '167', '2022-04-11', '10100.00', 'Cash receipt from IPD Income.', 'no', NULL, 63, 'yes', '2022-04-14 13:59:44');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (94, 1, 'OPD', '168', '2022-04-11', '2400.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-14 14:01:05');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (95, 3, 'Pathology', '169', '2022-04-11', '8050.00', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-14 14:03:30');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (96, 3, 'Radiology', '170', '2022-04-11', '5400.00', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-14 14:04:45');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (97, 1, 'IPD', '171', '2022-04-12', '100.00', 'Cash receipt from IPD Income.', 'no', NULL, 63, 'yes', '2022-04-14 15:12:07');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (98, 1, 'OPD', '172', '2022-04-12', '3500.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-14 15:14:46');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (99, 3, 'Pathology', '173', '2022-04-12', '13800.00', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-14 15:16:56');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (100, 3, 'Radiology', '174', '2022-04-12', '11000.00', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-14 15:19:32');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (101, 1, 'IPD', '175', '2022-04-13', '100.00', 'Cash receipt from IPD Income', 'no', NULL, 63, 'yes', '2022-04-16 12:00:03');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (102, 1, 'OPD', '176', '2022-04-13', '2550.00', 'Cash receipt from OPD Income.', 'no', NULL, 63, 'yes', '2022-04-16 12:07:03');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (103, 3, 'Pathology', '177', '2022-04-13', '9400.00', 'Cash receipt from Pathology Income.', 'no', NULL, 63, 'yes', '2022-04-16 12:10:16');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (104, 3, 'Radiology', '178', '2022-04-13', '8100.00', 'Cash receipt from Radiology Income.', 'no', NULL, 63, 'yes', '2022-04-16 12:12:11');


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Hospital', 'Indoor Patient Department (IPD)', 'yes', 'no', '2022-03-22 17:24:56');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Hospital', 'Outdoor Patient Department', 'yes', 'no', '2022-03-22 17:26:12');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'Diagnostic', 'Radiology\r\nPathology\r\n', 'yes', 'no', '2022-03-22 17:29:51');


#
# TABLE STRUCTURE FOR: invoice
#

DROP TABLE IF EXISTS `invoice`;

CREATE TABLE `invoice` (
  `id` int(11) NOT NULL,
  `invoice_id` varchar(30) DEFAULT NULL,
  `customer_id` varchar(100) NOT NULL,
  `date` date DEFAULT NULL,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `invoice` varchar(255) NOT NULL,
  `total_discount` decimal(10,2) DEFAULT 0.00 COMMENT 'total invoice discount',
  `invoice_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_tax` decimal(10,2) DEFAULT 0.00,
  `prevous_due` decimal(10,2) NOT NULL DEFAULT 0.00,
  `sales_by` varchar(30) DEFAULT NULL,
  `invoice_details` varchar(200) DEFAULT NULL,
  `status` int(2) NOT NULL,
  `payment_type` int(11) NOT NULL DEFAULT 1,
  `bank_id` varchar(30) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES (1, '9259592329', 'P3NY6D1AKZQPHB7', '2022-02-23', '6.00', '1000', '0.00', '0.00', '0.00', '0.00', '1', '', 1, 1, NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES (2, '1877899635', 'P3NY6D1AKZQPHB7', '2022-02-23', '3.00', '1001', '0.00', '0.00', '0.00', '0.00', '1', '', 1, 1, NULL);


#
# TABLE STRUCTURE FOR: invoice_details
#

DROP TABLE IF EXISTS `invoice_details`;

CREATE TABLE `invoice_details` (
  `id` int(11) NOT NULL,
  `invoice_details_id` varchar(30) NOT NULL,
  `invoice_id` varchar(100) NOT NULL,
  `product_id` varchar(100) NOT NULL,
  `batch_id` varchar(30) NOT NULL,
  `cartoon` float DEFAULT NULL,
  `quantity` float NOT NULL,
  `rate` decimal(12,2) NOT NULL DEFAULT 0.00,
  `manufacturer_rate` decimal(10,2) DEFAULT 0.00,
  `total_price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `discount` decimal(12,0) DEFAULT 0,
  `tax` decimal(10,2) DEFAULT 0.00,
  `paid_amount` decimal(12,0) DEFAULT 0,
  `due_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` int(2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `invoice_details` (`id`, `invoice_details_id`, `invoice_id`, `product_id`, `batch_id`, `cartoon`, `quantity`, `rate`, `manufacturer_rate`, `total_price`, `discount`, `tax`, `paid_amount`, `due_amount`, `status`) VALUES (1, '158396893255633', '9259592329', '58967225', '11', NULL, '2', '3.00', '4.00', '6.00', '0', NULL, '0', '6.00', 1);
INSERT INTO `invoice_details` (`id`, `invoice_details_id`, `invoice_id`, `product_id`, `batch_id`, `cartoon`, `quantity`, `rate`, `manufacturer_rate`, `total_price`, `discount`, `tax`, `paid_amount`, `due_amount`, `status`) VALUES (2, '628395523414933', '1877899635', '58967225', '11', NULL, '1', '3.00', '4.00', '3.00', '0', NULL, '0', '3.00', 1);


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `bed` varchar(100) NOT NULL,
  `bed_group_id` int(10) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` varchar(200) NOT NULL,
  `known_allergies` varchar(200) DEFAULT NULL,
  `patient_old` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `cons_doctor` (`cons_doctor`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `ipd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_4` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_5` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (27, 120, 72, '', '', '', '', '', '', '15', 3, 'Pregnancy', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-03-19 11:12:00', 'yes', 'no', 51, '2022-03-23 10:54:16');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (28, 135, 81, '', '', '', '', '', '', '1', 3, '', 'No', '', NULL, '', NULL, '', 34, NULL, '2000', '', '2022-03-19 22:12:00', 'no', 'no', 48, '2022-03-19 22:12:17');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (29, 137, 83, '', '', '', '', '', '', '3', 3, '', 'No', '', NULL, '', NULL, 'Atik Vai', 54, NULL, '2000', '', '2022-03-19 22:32:00', 'yes', 'no', 48, '2022-03-23 10:48:55');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (30, 134, 84, '', '', '', '', '', '', '9', 3, '', 'No', '', NULL, '', NULL, '', 34, NULL, '2000', '', '2022-03-19 23:40:00', 'no', 'no', 48, '2022-03-19 23:41:18');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (31, 149, 88, '', '', '', '', '', '', '6', 1, '(LSCS)', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-20 13:06:00', 'yes', 'no', 35, '2022-03-20 13:35:29');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (32, 183, 95, '', '', '', '', '', '', '21', 2, '', 'No', '', NULL, '', NULL, '', 22, NULL, '2000', '', '2022-03-21 13:38:00', 'yes', 'no', 36, '2022-03-21 19:00:26');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (33, 188, 96, '', '', '', '', '', '', '6', 1, '', 'No', '', NULL, '', NULL, '', 46, NULL, '2000', '', '2022-03-21 15:21:00', 'yes', 'no', 36, '2022-03-21 18:08:12');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (34, 217, 111, '', '', '', '', '', '', '21', 2, '', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-03-22 13:05:00', 'no', 'no', 36, '2022-03-22 13:08:47');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (35, 229, 118, '', '', '', '', '', '', '6', 1, '', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-03-23 08:15:00', 'yes', 'no', 48, '2022-03-27 09:56:26');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (36, 246, 126, '', '', '', '', '', '', '19', 2, '', 'No', '', NULL, '', NULL, '', 59, NULL, '2000', '', '2022-03-23 21:15:00', 'no', 'no', 48, '2022-03-23 21:15:39');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (37, 258, 133, '', '', '', '', '', '', '3', 3, 'Medecine', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-03-24 13:23:00', 'yes', 'no', 35, '2022-03-26 16:50:54');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (38, 272, 140, '', '', '', '', '', '', '7', 3, 'Bliding', 'No', '', NULL, '', NULL, '', 20, NULL, '2000', '', '2022-03-24 19:29:00', 'no', 'no', 35, '2022-03-24 19:30:03');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (39, 291, 143, '', '', '', '', '', '', '8', 3, '', 'No', '', NULL, '', NULL, '', 61, NULL, '2000', '', '2022-03-24 23:03:00', 'no', 'no', 48, '2022-03-24 23:04:23');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (40, 283, 145, '', '', '', '', '', '', '10', 3, 'LSCS', 'No', '', NULL, '', NULL, '', 17, NULL, '2000', '', '2022-03-25 10:19:00', 'yes', 'no', 35, '2022-03-31 13:27:01');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (41, 324, 148, '', '', '', '', '', '', '13', 3, '', 'No', '', NULL, '', NULL, '', 28, NULL, '2000', '', '2022-03-25 12:44:00', 'yes', 'no', 35, '2022-03-27 11:48:35');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (42, 326, 150, '', '', '', '', '', '', '12', 3, '', 'Yes', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-03-25 13:47:00', 'yes', 'no', 36, '2022-03-29 10:43:26');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (43, 383, 166, '', '', '', '', '', '', '3', 3, '', 'No', '', NULL, '', NULL, '', 59, NULL, '2000', '', '2022-03-26 21:06:00', 'yes', 'no', 48, '2022-03-27 12:39:02');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (44, 421, 181, '', '', '', '', '', '', '1', 3, 'Pregnancy', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-03-28 11:07:00', 'no', 'no', 51, '2022-03-28 11:08:39');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (45, 426, 184, '', '', '', '', '', '', '9', 3, 'LSCS', 'Yes', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-03-28 14:05:00', 'no', 'no', 35, '2022-03-28 14:05:57');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (46, 476, 210, '', '', '', '', '', '', '3', 3, 'Medecine', 'No', '', NULL, '', NULL, '', 46, NULL, '2000', '', '2022-03-30 19:40:00', 'no', 'no', 36, '2022-03-30 19:41:34');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (47, 493, 216, '', '', '', '', '', '', '21', 2, 'LSCS', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-03-31 13:56:00', 'no', 'no', 35, '2022-03-31 13:57:14');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (48, 536, 224, '', '', '', '', '', '', '10', 3, '', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-04-01 05:02:00', 'no', 'no', 48, '2022-04-01 05:02:44');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (49, 574, 230, '', '', '', '', '', '', '13', 3, 'LUCS', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-04-01 16:33:00', 'no', 'no', 35, '2022-04-01 16:34:36');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (50, 614, 240, '', '', '', '', '', '', '19', 2, 'LSCS', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-02 15:35:00', 'yes', 'no', 35, '2022-04-12 11:24:35');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (51, 621, 244, '', '', '', '', '', '', '14', 3, 'Cross Mathing', 'No', '', NULL, '', NULL, '', 46, NULL, '2000', '', '2022-04-02 19:24:00', 'no', 'no', 35, '2022-04-02 19:24:46');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (52, 631, 251, '', '', '', '', '', '', '7', 3, '', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-03 22:14:00', 'yes', 'no', 48, '2022-04-07 10:51:30');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (53, 640, 255, '', '', '', '', '', '', '8', 3, '', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-04 11:27:00', 'no', 'no', 51, '2022-04-04 11:27:38');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (54, 351, 261, '', '', '', '', '', '', '12', 3, '', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-04 21:19:00', 'yes', 'no', 48, '2022-04-14 12:43:08');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (55, 700, 278, '', '', '', '', '', '', '11', 3, '', 'No', '', NULL, '', NULL, '', 46, NULL, '2000', '', '2022-04-06 23:02:00', 'yes', 'no', 48, '2022-04-07 12:39:42');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (56, 707, 287, '', '', '', '', '', '', '11', 3, '', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-07 21:01:00', 'yes', 'no', 51, '2022-04-14 12:44:19');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (57, 547, 288, '', '', '', '', '', '', '15', 3, '', 'No', '', NULL, '', NULL, '', 21, NULL, '2000', '', '2022-04-07 21:22:00', 'no', 'no', 48, '2022-04-07 21:23:18');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (58, 789, 304, '', '', '', '', '', '', '16', 3, '', 'No', '', NULL, '', NULL, '', 59, NULL, '2000', '', '2022-04-09 07:39:00', 'no', 'no', 48, '2022-04-09 07:40:16');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (59, 829, 327, '', '', '', '', '', '', '6', 1, 'LSCS', 'No', '', NULL, '', NULL, 'Esmotara Unti', 62, NULL, '2000', '', '2022-04-10 15:42:00', 'no', 'no', 35, '2022-04-10 15:43:18');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (60, 830, 328, '', '', '', '', '', '', '7', 3, '', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-10 17:25:00', 'yes', 'no', 35, '2022-04-14 12:38:45');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (61, 857, 345, '', '', '', '', '', '', '7', 3, 'Medecine', 'No', '', NULL, '', NULL, '', 59, NULL, '2000', '', '2022-04-11 20:36:00', 'no', 'no', 35, '2022-04-11 20:37:28');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (62, 793, 353, '', '', '', '', '', '', '19', 2, '', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-12 11:32:00', 'no', 'no', 51, '2022-04-12 11:33:25');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (63, 900, 375, '', '', '', '', '', '', '17', 3, 'LSCS', 'No', '', NULL, '', NULL, 'Priyangka Dhaki', 62, NULL, '2000', '', '2022-04-13 20:02:00', 'no', 'no', 35, '2022-04-13 20:04:24');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (64, 906, 376, '', '', '', '', '', '', '18', 3, '', 'No', '', NULL, '', NULL, '', 54, NULL, '2000', '', '2022-04-14 01:18:00', 'no', 'no', 48, '2022-04-14 01:19:33');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (65, 909, 382, '', '', '', '', '', '', '7', 3, 'LSCS', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-14 12:49:00', 'no', 'no', 35, '2022-04-14 12:50:05');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (66, 830, 388, '', '', '', '', '', '', '12', 3, 'Medecine', 'No', '', NULL, '', NULL, '', 62, NULL, '2000', '', '2022-04-15 11:53:00', 'no', 'no', 35, '2022-04-15 11:53:58');


#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `consult_doctor` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `consult_doctor` (`consult_doctor`),
  CONSTRAINT `ipd_doctors_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_doctors_ibfk_2` FOREIGN KEY (`consult_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (1, 42, 17, '2022-03-25 23:08:10');


#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `header_note` text DEFAULT NULL,
  `footer_note` text DEFAULT NULL,
  `finding_description` text DEFAULT NULL,
  `is_finding_print` varchar(100) DEFAULT NULL,
  `date` date NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `prescribe_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `visit_details_id` (`visit_details_id`),
  CONSTRAINT `ipd_prescription_basic_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_2` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (4, 30, NULL, '', '', ' ', 'yes', '2022-03-19', 1, 34, '2022-03-19 23:48:41');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (5, 30, NULL, '', '', ' ', 'yes', '2022-03-19', 1, 34, '2022-03-19 23:51:37');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(10) DEFAULT NULL,
  `dosage` int(11) DEFAULT NULL,
  `dose_interval_id` int(11) DEFAULT NULL,
  `dose_duration_id` int(11) DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `basic_id` (`basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  CONSTRAINT `ipd_prescription_details_ibfk_1` FOREIGN KEY (`basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (4, 4, 2, 2, 0, 0, '', '2022-03-19 23:48:41');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (5, 5, 2, 2, 0, 0, '', '2022-03-19 23:51:37');


#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_prescription_basic_id` int(100) DEFAULT NULL,
  `pathology_id` int(11) DEFAULT NULL,
  `radiology_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `radiology_id` (`radiology_id`),
  CONSTRAINT `ipd_prescription_test_ibfk_1` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_2` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_3` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (1, 1, 'x-ray film', 'pcs', NULL, '', 0, NULL, '2022-02-26 11:36:28');


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'Radiology', 'yes', '', '2022-02-26 11:29:51');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (2, 'Pathology', 'yes', '', '2022-02-26 11:30:08');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` int(11) DEFAULT NULL,
  `issue_to` int(11) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text DEFAULT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (1, 1, 1, '+', 2, 100, '5000.00', '2022-02-26', NULL, 'Challan not found', 'yes', '2022-02-26 11:38:57');


#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (1, 'Pathology', '101', '', '2022-02-26 11:32:14');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (2, 'Radiology', '', '', '2022-02-26 11:32:30');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (1, 'Satu estationary', '', '', '', '', '', '', '', '2022-02-26 11:30:43');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (2, 'Others Stotionary', '', '', '', '', '', '', '', '2022-02-26 11:31:45');


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (1, 'ULTRASOUND', '2022-01-12 01:02:53');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (2, 'X-RAY', '2022-01-12 01:03:55');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (3, 'ULTRASOUND-Template', '2022-03-24 22:34:35');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (4, 'ECG', '2022-03-25 18:55:46');


#
# TABLE STRUCTURE FOR: language
#

DROP TABLE IF EXISTS `language`;

CREATE TABLE `language` (
  `id` int(11) unsigned NOT NULL,
  `phrase` text NOT NULL,
  `english` text DEFAULT NULL,
  `bangla` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (1, 'user_profile', 'User Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (2, 'setting', 'Web Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (3, 'language', 'Language', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (4, 'manage_users', 'Manage Users', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (5, 'add_user', 'Add User', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (6, 'manage_company', 'Manage Company', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (7, 'web_settings', 'Software Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (8, 'manage_accounts', 'Manage Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (9, 'create_accounts', 'Create Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (10, 'manage_bank', 'Manage Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (11, 'add_new_bank', 'Add New Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (12, 'settings', 'Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (13, 'closing_report', 'Closing Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (14, 'closing', 'Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (15, 'cheque_manager', 'Cheque Manager', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (16, 'accounts_summary', 'Accounts Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (17, 'expense', 'Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (18, 'income', 'Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (19, 'accounts', 'Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (20, 'stock_report', 'Stock Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (21, 'stock', 'Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (22, 'pos_invoice', 'POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (23, 'manage_invoice', 'Manage Invoice ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (24, 'new_invoice', 'New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (25, 'invoice', 'Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (26, 'manage_purchase', 'Manage Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (27, 'add_purchase', 'Add Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (28, 'purchase', 'Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (29, 'paid_customer', 'Paid Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (30, 'manage_customer', 'Manage Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (31, 'add_customer', 'Add Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (32, 'customer', 'Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (33, 'manufacturer_payment_actual', 'Manufacturer Payment Actual', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (34, 'manufacturer_sales_summary', 'Manufacturer  Sales Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (35, 'manufacturer_sales_details', 'Manufacturer Sales Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (36, 'manufacturer_ledger', 'Manufacturer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (37, 'manage_manufacturer', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (38, 'add_manufacturer', 'Add Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (39, 'manufacturer', 'Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (40, 'product_statement', 'Medicine Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (41, 'manage_product', 'Manage Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (42, 'add_product', 'Add Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (43, 'product', 'Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (44, 'manage_category', 'Manage Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (45, 'add_category', 'Add Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (46, 'category', 'Medicine Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (47, 'sales_report_product_wise', 'Sales Report (Medicine Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (48, 'purchase_report', 'Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (49, 'sales_report', 'Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (50, 'todays_report', 'Todays Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (51, 'report', 'Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (52, 'dashboard', 'Dashboard', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (53, 'online', 'Online', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (54, 'logout', 'Logout', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (56, 'total_purchase', 'Total Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (57, 'total_amount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (58, 'manufacturer_name', 'Manufacturer  Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (59, 'invoice_no', 'Invoice No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (60, 'purchase_date', 'Purchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (61, 'todays_purchase_report', 'Todays Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (62, 'total_sales', 'Total Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (63, 'customer_name', 'Customer Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (64, 'sales_date', 'Sales Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (65, 'todays_sales_report', 'Todays Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (66, 'home', 'Home', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (67, 'todays_sales_and_purchase_report', 'Todays sales and purchase report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (68, 'total_ammount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (69, 'rate', 'Sale Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (70, 'product_model', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (71, 'product_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (72, 'search', 'Search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (73, 'end_date', 'End Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (74, 'start_date', 'Start Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (75, 'total_purchase_report', 'Total Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (76, 'total_sales_report', 'Total Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (77, 'total_seles', 'Total Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (78, 'all_stock_report', 'All Stock Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (79, 'search_by_product', 'Search By Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (80, 'date', 'Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (81, 'print', 'Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (82, 'stock_date', 'Stock Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (83, 'print_date', 'Print Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (84, 'sales', 'Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (85, 'price', 'Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (86, 'sl', 'SL.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (87, 'add_new_category', 'Add new category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (88, 'category_name', 'Category Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (89, 'save', 'Save', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (90, 'delete', 'Delete', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (91, 'update', 'Update', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (92, 'action', 'Action', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (93, 'manage_your_category', 'Manage your category ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (94, 'category_edit', 'Category Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (95, 'status', 'Status', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (96, 'active', 'Active', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (97, 'inactive', 'Inactive', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (98, 'save_changes', 'Save Changes', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (99, 'save_and_add_another', 'Save And Add Another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (100, 'model', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (101, 'manufacturer_price', 'Manufacturer Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (102, 'sell_price', 'Sell Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (103, 'image', 'Image', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (104, 'select_one', 'Select One', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (105, 'details', 'Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (106, 'new_product', 'New Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (107, 'add_new_product', 'Add new medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (108, 'barcode', 'Barcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (109, 'qr_code', 'Qr-Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (110, 'product_details', 'Medicine Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (111, 'manage_your_product', 'Manage your medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (112, 'product_edit', 'Medicine Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (113, 'edit_your_product', 'Edit your medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (114, 'cancel', 'Cancel', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (115, 'incl_vat', 'Incl. Vat', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (116, 'money', 'Dollar', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (117, 'grand_total', 'Grand Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (118, 'quantity', 'Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (119, 'product_report', 'Medicine Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (120, 'product_sales_and_purchase_report', 'Medicine sales and purchase report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (121, 'previous_stock', 'Previous Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (122, 'out', 'Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (123, 'in', 'In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (124, 'to', 'To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (125, 'previous_balance', 'Previous Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (126, 'customer_address', 'Customer Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (127, 'customer_mobile', 'Customer Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (128, 'customer_email', 'Customer Email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (129, 'add_new_customer', 'Add new customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (130, 'balance', 'Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (131, 'mobile', 'Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (132, 'address', 'Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (133, 'manage_your_customer', 'Manage your customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (134, 'customer_edit', 'Customer Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (135, 'paid_customer_list', 'Paid Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (136, 'ammount', 'Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (137, 'customer_ledger', 'Customer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (138, 'manage_customer_ledger', 'Manage Customer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (139, 'customer_information', 'Customer Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (140, 'debit_ammount', 'Debit Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (141, 'credit_ammount', 'Credit Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (142, 'balance_ammount', 'Balance Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (143, 'receipt_no', 'Receipt NO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (144, 'description', 'Description', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (145, 'debit', 'Debit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (146, 'credit', 'Credit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (147, 'item_information', 'Item Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (148, 'total', 'Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (149, 'please_select_manufacturer', 'Please Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (150, 'submit', 'Submit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (151, 'submit_and_add_another', 'Submit And Add Another One', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (152, 'add_new_item', 'Add New Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (153, 'manage_your_purchase', 'Manage your purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (154, 'purchase_edit', 'Purchase Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (155, 'purchase_ledger', 'Purchase Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (156, 'invoice_information', 'Invoice Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (157, 'paid_ammount', 'Paid Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (158, 'discount', 'Discount / Pcs.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (159, 'save_and_paid', 'Save And Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (160, 'payee_name', 'Payee Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (161, 'manage_your_invoice', 'Manage your invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (162, 'invoice_edit', 'Invoice Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (163, 'new_pos_invoice', 'New POS invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (164, 'add_new_pos_invoice', 'Add new pos invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (165, 'product_id', 'Medicine ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (166, 'paid_amount', 'Paid Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (167, 'authorised_by', 'Authorised By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (168, 'checked_by', 'Checked By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (169, 'received_by', 'Received By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (170, 'prepared_by', 'Prepared By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (171, 'memo_no', 'Memo No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (172, 'website', 'Website', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (173, 'email', 'Email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (174, 'invoice_details', 'Invoice Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (175, 'reset', 'Reset', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (176, 'payment_account', 'Payment Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (177, 'bank_name', 'Bank Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (178, 'cheque_or_pay_order_no', 'Cheque/Pay Order No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (179, 'payment_type', 'Payment Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (180, 'payment_from', 'Payment From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (181, 'payment_date', 'Payment Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (182, 'add_income', 'Add Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (183, 'cash', 'Cash', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (184, 'cheque', 'Cheque', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (185, 'pay_order', 'Pay Order', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (186, 'payment_to', 'Payment To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (187, 'total_expense_ammount', 'Total Expense Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (188, 'transections', 'Transactions', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (189, 'accounts_name', 'Accounts Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (190, 'outflow_report', 'Expense Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (191, 'inflow_report', 'Income Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (192, 'all', 'All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (193, 'account', 'Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (194, 'from', 'From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (195, 'account_summary_report', 'Account Summary Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (196, 'search_by_date', 'Search By Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (197, 'cheque_no', 'Cheque No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (198, 'name', 'Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (199, 'closing_account', 'Closing Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (200, 'close_your_account', 'Close your account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (201, 'last_day_closing', 'Last Day Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (202, 'cash_in', 'Cash In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (203, 'cash_out', 'Cash Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (204, 'cash_in_hand', 'Cash In Hand', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (205, 'add_new_bank', 'Add New Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (206, 'day_closing', 'Day Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (207, 'account_closing_report', 'Account Closing Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (208, 'last_day_ammount', 'Last Day Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (209, 'adjustment', 'Adjustment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (210, 'pay_type', 'Pay Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (211, 'customer_or_manufacturer', 'Customer,Manufacturer Or Others', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (212, 'transection_id', 'Transactions ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (213, 'accounts_summary_report', 'Accounts Summary Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (214, 'bank_list', 'Bank List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (215, 'bank_edit', 'Bank Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (216, 'debit_plus', 'Debit (+)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (217, 'credit_minus', 'Credit (-)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (218, 'account_name', 'Account Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (219, 'account_type', 'Account Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (220, 'account_real_name', 'Account Real Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (221, 'manage_account', 'Manage Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (222, 'company_name', 'Company Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (223, 'edit_your_company_information', 'Edit your company information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (224, 'company_edit', 'Company Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (225, 'admin', 'Admin', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (226, 'user', 'User', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (227, 'password', 'Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (228, 'last_name', 'Last Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (229, 'first_name', 'First Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (230, 'add_new_user_information', 'Add new user information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (231, 'user_type', 'User Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (232, 'user_edit', 'User Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (233, 'rtr', 'RTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (234, 'ltr', 'LTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (235, 'ltr_or_rtr', 'LTR/RTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (236, 'footer_text', 'Footer Text', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (237, 'favicon', 'Favicon', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (238, 'logo', 'Logo', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (239, 'update_setting', 'Update Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (240, 'update_your_web_setting', 'Update your Web setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (241, 'login', 'Login', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (242, 'your_strong_password', 'Your strong password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (243, 'your_unique_email', 'Your unique email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (244, 'please_enter_your_login_information', 'Please enter your login information.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (245, 'update_profile', 'Update Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (246, 'your_profile', 'Your Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (247, 're_type_password', 'Re-Type Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (248, 'new_password', 'New Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (249, 'old_password', 'Old Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (250, 'new_information', 'New Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (251, 'old_information', 'Old Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (252, 'change_your_information', 'Change your information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (253, 'change_your_profile', 'Change your profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (254, 'profile', 'Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (255, 'wrong_username_or_password', 'Wrong User Name Or Password !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (256, 'successfully_updated', 'Successfully Updated.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (257, 'blank_field_does_not_accept', 'Blank Field Does Not Accept !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (258, 'successfully_changed_password', 'Successfully changed password.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (259, 'you_are_not_authorised_person', 'You are not authorised person !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (260, 'password_and_repassword_does_not_match', 'Passwor and re-password does not match !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (261, 'new_password_at_least_six_character', 'New Password At Least 6 Character.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (262, 'you_put_wrong_email_address', 'You put wrong email address !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (263, 'cheque_ammount_asjusted', 'Cheque amount adjusted.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (264, 'successfully_payment_paid', 'Successfully Payment Paid.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (265, 'successfully_added', 'Successfully Added.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (266, 'successfully_updated_2_closing_ammount_not_changeale', 'Successfully Updated -2. Note: Closing Amount Not Changeable.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (267, 'successfully_payment_received', 'Successfully Payment Received.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (268, 'already_inserted', 'Already Inserted !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (269, 'successfully_delete', 'Successfully Delete.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (270, 'successfully_created', 'Successfully Created.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (271, 'logo_not_uploaded', 'Logo not uploaded !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (272, 'favicon_not_uploaded', 'Favicon not uploaded !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (273, 'manufacturer_mobile', 'Manufacturer  Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (274, 'manufacturer_address', 'Manufacturer  Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (275, 'manufacturer_details', 'Manufacturer Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (276, 'add_new_manufacturer', 'Add New Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (277, 'manage_suppiler', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (278, 'manage_your_manufacturer', 'Manage your Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (279, 'manage_manufacturer_ledger', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (280, 'invoice_id', 'Invoice ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (281, 'deposite_id', 'Deposit ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (282, 'manufacturer_actual_ledger', 'Manufacturer Actual Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (283, 'manufacturer_information', 'Manufacturer Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (284, 'event', 'Event', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (285, 'add_new_income', 'Add New Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (286, 'add_expese', 'Add Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (287, 'add_new_expense', 'Add New Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (288, 'total_income_ammount', 'Total Income Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (289, 'create_new_invoice', 'Create New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (290, 'create_pos_invoice', 'Create POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (291, 'total_profit', 'Total Profit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (292, 'monthly_progress_report', 'Monthly Progress Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (293, 'total_invoice', 'Total Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (294, 'account_summary', 'Account Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (295, 'total_manufacturer', 'Total manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (296, 'total_product', 'Total Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (297, 'total_customer', 'Total Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (298, 'manufacturer_edit', 'Manufacturer Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (299, 'add_new_invoice', 'Add New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (300, 'add_new_purchase', 'Add new purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (301, 'currency', 'Currency', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (302, 'currency_position', 'Currency Position', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (303, 'left', 'Left', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (304, 'right', 'Right', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (305, 'add_tax', 'Add Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (306, 'manage_tax', 'Manage Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (307, 'add_new_tax', 'Add new tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (308, 'enter_tax', 'Enter Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (309, 'already_exists', 'Already Exists !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (310, 'successfully_inserted', 'Successfully Inserted.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (311, 'tax', 'Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (312, 'tax_edit', 'Tax Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (313, 'product_not_added', 'Medicine not added !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (314, 'total_tax', 'Total Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (315, 'manage_your_manufacturer_details', 'Manage your Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (316, 'invoice_description', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s                                       standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (317, 'thank_you_for_choosing_us', 'Thank you very much for choosing us.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (318, 'billing_date', 'Billing Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (319, 'billing_to', 'Billing To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (320, 'billing_from', 'Billing From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (321, 'you_cant_delete_this_product', 'Sorry !!  You can\'t delete this medicine.This medicine already used in calculation system!', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (322, 'old_customer', 'Old Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (323, 'new_customer', 'New Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (324, 'new_manufacturer', 'New Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (325, 'old_manufacturer', 'Old Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (326, 'credit_customer', 'Credit Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (327, 'account_already_exists', 'This Account Already Exists !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (328, 'edit_income', 'Edit Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (329, 'you_are_not_access_this_part', 'You are not authorised person !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (330, 'account_edit', 'Account Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (331, 'due', 'Due', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (332, 'expense_edit', 'Expense Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (333, 'please_select_customer', 'Please select customer !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (334, 'profit_report', 'Profit Report (Invoice Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (335, 'total_profit_report', 'Total profit report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (336, 'please_enter_valid_captcha', 'Please enter valid captcha.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (337, 'category_not_selected', 'Category not selected.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (338, 'manufacturer_not_selected', 'Manufacturer not selected.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (339, 'please_select_product', 'Please select medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (340, 'product_model_already_exist', 'Medicine model already exist !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (341, 'invoice_logo', 'Invoice Logo', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (342, 'available_quantity', 'Available Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (343, 'you_can_not_buy_greater_than_available_quantity', 'You can not select grater than availale quantity !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (344, 'customer_details', 'Customer details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (345, 'manage_customer_details', 'Manage customer details.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (346, 'box_size', 'Box size', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (347, 'expire_date', 'Expiry  date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (348, 'product_location', 'Medicine  Shelf', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (349, 'generic_name', 'Generic name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (350, 'payment_method', 'Payment Method', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (351, 'card_no', 'Card no', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (352, 'medicine', 'Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (353, 'medicine_search', 'Medicine Search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (354, 'what_you_search', 'Enter what you search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (355, 'company', 'Company', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (356, 'customer_search', 'Customer search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (357, 'invoice_search', 'Invoice search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (358, 'purchase_search', 'Purchase search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (359, 'daily_closing_report', 'Daily closing report.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (360, 'closing_search_report', 'Closing Search Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (361, 'category_list', 'Category List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (362, 'company_list', 'Company List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (363, 'customers_list', 'Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (364, 'credit_customer_list', 'Credit Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (365, 'previous_balance_adjustment', 'Previous Balance Adjustment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (366, 'invoice_list', 'Invoice List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (367, 'add_pos_invoice', 'Add POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (368, 'add_invoice', 'Add Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (369, 'product_list', 'Medicine List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (370, 'purchases_list', 'Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (371, 'purchase_list', 'Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (372, 'stock_list', 'Stock List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (373, 'all_report', 'All Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (374, 'daily_sales_report', 'Daily sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (375, 'product_wise_sales_report', 'Medicine Wise Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (376, 'bank_update', 'Bank Update', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (377, 'account_list', 'Account List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (378, 'manufacturer_list', 'Manufacturer  List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (379, 'manufacturer_search_item', 'Manufacturer  Search Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (380, 'user_list', 'User List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (381, 'user_search_item', 'User Search Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (382, 'change_password', 'Change Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (383, 'admin_login_area', 'Admin Login Area', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (384, 'accounts_inflow_form', 'Account Inflow Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (385, 'accounts_outflow_form', 'Accounts Outflow Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (386, 'accounts_tax_form', 'Accounts Tax Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (387, 'accounts_manage_tax', 'Accounts Manage Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (388, 'accounts_tax_edit', 'Accounts Tax Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (389, 'accounts_summary_data', 'Accounts Summary Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (390, 'accounts_details_data', 'Accounts Details Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (391, 'datewise_summary_data', 'Datewise Summary Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (392, 'accounts_cheque_manager', 'Account Cheque Manager', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (393, 'accounts_edit_data', 'Accounts Edit Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (394, 'print_barcode', 'Print Barcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (395, 'print_qrcode', 'Print Qrcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (396, 'add_new_account', 'Add New Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (397, 'table_edit', 'Table Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (398, 'secret_key', 'Secret Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (399, 'site_key', 'Site Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (400, 'captcha', 'Captcha', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (401, 'please_add_walking_customer_for_default_customer', 'Please add walking customer for default customer. ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (402, 'barcode_qrcode_scan_here', 'Barcode Or QRcode scan here', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (403, 'manage_your_credit_customer', 'Manage your credit customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (404, 'unit', 'Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (405, 'total_discount', 'Total Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (406, 'meter_m', 'Meter (M)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (407, 'piece_pc', 'Piece (Pc)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (408, 'kilogram_kg', 'Kilogram (Kg)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (409, 'import_product_csv', 'Import Medicine (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (410, 'close', 'Close', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (411, 'csv_file_informaion', 'File Information (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (412, 'download_example_file', 'Download Example File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (413, 'upload_csv_file', 'Upload CSV File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (414, 'manufacturer_id', 'Manufacturer ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (415, 'category_id', 'Category ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (416, 'are_you_sure_to_delete', 'Are you sure,want to delete ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (417, 'stock_report_manufacturer_wise', 'Stock Report (Manufacturer Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (418, 'stock_report_product_wise', 'Stock Report (Medicine Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (419, 'select_manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (420, 'select_product', 'Select Medicine ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (421, 'phone', 'Phone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (422, 'in_quantity', 'In Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (423, 'out_quantity', 'Sold QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (424, 'in_taka', 'In Taka', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (425, 'out_taka', 'Out Taka', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (426, 'data_synchronizer', 'Data Synchronizer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (427, 'synchronize', 'Synchronize', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (428, 'backup_restore', 'Backup And Restore', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (429, 'synchronizer_setting', 'Synchronizer Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (430, 'backup_and_restore', 'Backup And Restore', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (431, 'hostname', 'Host Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (432, 'username', 'User Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (433, 'ftp_port', 'FTP Port', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (434, 'ftp_debug', 'FTP Debug', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (435, 'project_root', 'Project Root', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (436, 'internet_connection', 'Internet connection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (437, 'ok', 'Ok', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (438, 'not_available', 'Not available', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (439, 'outgoing_file', 'Outgoing File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (440, 'available', 'Available', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (441, 'incoming_file', 'Incoming file', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (442, 'data_upload_to_server', 'Data upload to server', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (443, 'download_data_from_server', 'Download data from server', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (444, 'data_import_to_database', 'Data import to database', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (445, 'please_wait', 'Please Wait', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (446, 'ooops_something_went_wrong', 'Ooops something went wrong', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (447, 'file_information', 'File Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (448, 'size', 'Size', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (449, 'backup_date', 'Backup date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (450, 'backup_now', 'Backup Now', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (451, 'are_you_sure', 'Are you sure ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (452, 'download', 'Downlaod', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (453, 'database_backup', 'Database Backup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (454, 'backup_successfully', 'Backup Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (455, 'please_try_again', 'Please Try Again', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (456, 'restore_successfully', 'Restore successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (457, 'download_successfully', 'Download Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (458, 'delete_successfully', 'Delete Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (459, 'ftp_setting', 'FTP Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (460, 'save_successfully', 'Save successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (461, 'upload_successfully', 'Upload successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (462, 'unable_to_upload_file_please_check_configuration', 'unable to upload file please check configuration.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (463, 'please_configure_synchronizer_settings', 'Please Configure Synchronizer Settings ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (464, 'unable_to_download_file_please_check_configuration', 'Unable To Download File,Please Check Configuration.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (465, 'data_import_first', 'Data Import First', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (466, 'data_import_successfully', 'Data Import Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (467, 'unable_to_import_data_please_check_config_or_sql_file', 'Unable to import data please check config or sql file.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (468, 'restore_now', 'Restore Now', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (469, 'out_of_stock', 'Out Of Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (470, 'others', 'Others', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (471, 'shelf', 'Shelf', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (472, 'discount_type', 'Discount Type ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (473, 'discount_percentage', 'Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (474, 'fixed_dis', 'Fixed Dis', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (475, 'full_paid', 'Full Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (476, 'available_qnty', 'Ava.Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (477, 'stock_ctn', 'Stock/Qnt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (478, 'sale_price', 'Sale Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (479, 'manufacturer_rate', 'Manufacturer  Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (480, 'please_upload_image_type', 'Sorry!!! Please Upload jpg,jpeg,png,gif typeimage', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (481, 'ml', 'Milli liter(ml)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (482, 'mg', 'Milli Gram(mg)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (483, 'you_can_not_buy_greater_than_available_qnty', 'You can not sale more than available quantity ! please purchase this Product', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (484, 'due_amount', 'Due Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (485, 'return_invoice', 'Return Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (486, 'sold_qty', 'Sold Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (487, 'ret_quantity', 'Return QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (488, 'deduction', 'Deduction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (489, 'return', 'Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (490, 'note', 'Return Reasone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (491, 'usablilties', 'Return Usability', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (492, 'adjs_with_stck', 'Adjust With Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (493, 'return_to_manufacturer', 'Return To Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (494, 'wastage', 'Wastage', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (495, 'to_deduction', 'Total Deduction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (496, 'nt_return', 'Net Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (497, 'return_id', 'Return Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (498, 'return_details', 'Return Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (499, 'add_return', 'Add Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (500, 'return_list', 'Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (501, 'stock_return_list', 'Stock Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (502, 'wastage_return_list', 'Wastage Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (503, 'check_return', 'Check Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (504, 'quantity_must_be_fillup', 'Return Quantity Must be Fill Up', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (505, 'expeire_date', 'Expiry  date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (506, 'batch_id', 'Batch ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (507, 'manufacturer_return_list', 'Manufacturer  Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (508, 'c_r_slist', 'Customer Return List ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (509, 'manufacturer_return', 'Manufacturer  Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (510, 'wastage_list', 'Wastage List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (511, 'in_qnty', 'In Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (512, 'out_qnty', 'Sold QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (513, 'stock_sale', 'Stock Sell Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (514, 'add_product_csv', 'Import Medicine (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (515, 'purchase_id', 'Purchase ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (516, 'add_payment', 'Add Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (517, 'add_new_payment', 'Add new Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (518, 'transaction', 'Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (519, 'manage_transaction', 'Manage Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (520, 'choose_transaction', 'Choose Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (521, 'receipt', 'Receipt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (522, 'payment', 'Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (523, 'transaction_categry', 'Transaction Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (524, 'transaction_mood', 'Transaction Mood', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (525, 'payment_amount', 'Payment Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (526, 'receipt_amount', 'Receipt Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (527, 'daily_summary', 'Daily Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (528, 'daily_cash_flow', 'Daily  Cashflow', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (529, 'custom_report', 'Custom Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (530, 'root_account', 'Root Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (531, 'office', 'Office', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (532, 'loan', 'Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (533, 'successfully_saved', 'Successfully Saved', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (534, 'bank', 'Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (535, 'bank_transaction', 'Bank Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (536, 'office_loan', 'Office Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (537, 'add_person', 'Add Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (538, 'manage_loan', 'Manage Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (539, 'add_loan', 'Add Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (540, 'ac_name', 'Account Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (541, 'ac_no', 'Account No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (542, 'branch', 'Branch', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (543, 'signature_pic', 'Signature ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (544, 'withdraw_deposite_id', 'Withdraw Deposit ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (545, 'select_report', 'Select Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (546, 'per_qty', 'Purchase Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (547, 'stock_report_batch_wise', 'Stock Report(Batch Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (548, 'box', 'Box', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (549, 'gram', 'Gram', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (550, 'profit_report_manufacturer_wise', 'Profit/Loss Report(Manufacturer)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (551, 'calculate', 'Calculate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (552, 'profit_report_product_wise', 'Profit/Loss  Report Product Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (553, 'view_report', 'View Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (554, 'report_for', 'Report For', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (555, 'total_sale_qty', 'Total Sale QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (556, 'total_purchase_pric', 'Total purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (557, 'total_sale', 'Total Sale', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (558, 'net_profit', 'Net Profit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (559, 'loss', 'Loss', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (560, 'product_type', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (561, 'add_type', 'Add Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (562, 'add_new_type', 'Add New Medicine  Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (563, 'type', 'Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (564, 'type_name', 'Type Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (565, 'manage_type', 'Manage Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (566, 'type_id', 'Type Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (567, 'type_edit', 'Edit Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (568, 'profitloss', 'profit/Loss', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (569, 'manufacturer_wise', 'Manufacturer Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (570, 'product_wise', 'Medicine Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (571, 'medicine_info', 'Medicine Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (572, 'choose_another_invno', 'Choose Another Invoice No !!', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (573, 'return_manufacturers', 'Return Manufacturers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (574, 'return_manufacturer', 'Return Manufacturers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (575, 'please_input_correct_invoice_no', 'Please Input Correct Invoice No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (576, 'stock_purchase_price', 'Stock Purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (577, 'manufacturer_returns', 'Manufacturer  Return ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (578, 'invoice_discount', 'Invoice Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (579, 'qty', 'Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (580, 'discounts', 'Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (581, 'sub_total', 'Sub Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (582, 'paid', 'Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (583, 'change', 'Change', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (584, 'purchase_price', 'Purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (585, 'expiry', 'Expiry', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (586, 'batch', 'Batch', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (587, 'role_permission', 'Role Permission', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (588, 'user_assign_role', 'Assign  User Role', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (589, 'permission', 'Permission', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (590, 'personal_loan', 'Personal Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (591, 'role_name', 'Role Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (592, 'create', 'Create', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (593, 'read', 'Read', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (594, 'add_role', 'Add Role', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (595, 'You do not have permission to access. Please contact with administrator.', 'You do not have permission to access. Please contact with administrator.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (596, 'role_permission_added_successfully', 'Role Permission Added successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (597, 'role_list', 'Role List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (598, 'role_permission_updated_successfully', 'Role Permission Updated Successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (599, 'add_phrase', 'Add Phrase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (600, 'language_home', 'Language Home', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (601, 'phrase_edit', 'Phrase Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (602, 'no_role_selected', 'No Role Selected', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (603, 'category_added_successfully', 'Category added successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (604, 'category_already_exist', 'Category already exist', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (605, 'select_manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (607, 'select_tax', 'Select Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (608, 'must_input_numbers', 'Must input numbers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (609, 'please_check_your_price', 'Please Check Your Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (610, 'your_profit_is', 'Your Profit is', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (611, 'failed', 'Failed', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (612, 'you_have_reached_the_limit_of_adding', 'You have reached the limit of adding', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (613, 'inputs', 'inputs', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (614, 'expiry_date_should_be_greater_than_puchase_date', 'Expiry Date should be greater than Puchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (615, 'expiry_date_should_be_greater_than_puchase_date', 'Expiry Date should be greater than Puchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (616, 'product_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (617, 'total_quantity', 'Total Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (618, 'rates', 'Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (619, 'total_amount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (621, 'receipt_detail', 'Receipt Detail', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (622, 'amount', 'Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (623, 'save_and_add_another_one', 'Save and add another one', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (624, 'checque_number', 'Checque Number', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (625, 'edit_receipt', 'Edit Receipt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (626, 'receipt_list', 'Receipt List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (627, 'search_by_customer_name', 'Search By Customer Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (628, 'actions', 'Actions', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (629, 'no_data_found', 'No Data Found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (630, 'edit', 'Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (631, 'product_not_found', 'Medicine  not found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (632, 'request_failed_please_check_your_code_and_try_again', 'Request Failed, Please check your code and try again', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (633, 'You_can_not_return_more_than_sold_quantity', 'You Can Not Return More than Sold quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (634, 'you_can_not_return_less_than_1', 'You Can Not Return Less than 1', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (635, 'transection_details', 'Transection Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (636, 'transection_details_datewise', 'Transection  Details Datewise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (637, 'transection_id', 'Transactions ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (638, 'select_option', 'Select Option', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (639, 'loan_list', 'Loan List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (640, 'todays_details', 'Todays Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (641, 'transaction_details', 'Transaction Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (642, 'person_id', 'Person ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (643, 'total_transection', 'Total Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (644, 'transaction_id', 'Transaction ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (645, 'transection_report', 'Transection Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (646, 'add_transection', 'Add Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (647, 'manage_transection', 'Manage Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (648, 'select_id', 'Select ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (649, 'choose_transection', 'Choose Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (650, 'update_transection', 'Update Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (651, 'manufacturer_all', 'Manufacturer All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (652, 'select_all', 'Select All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (653, 'all', 'All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (654, 'max_rate', 'Max Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (655, 'min_rate', 'Min Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (656, 'average_rate', 'Average Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (657, 'date_expired_please_choose_another.', 'Date Expired!! Please Choose another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (658, 'your_medicine_is_date_expiry_Please_choose_another', 'Your Medicine is Date Expiry !! Please Choose another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (659, 'meno', 'MEMO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (660, 'out_of_stock_and_date_expired_medicine', 'Out of Stock and Date Expired Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (661, 'edit_profile', 'Edit Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (662, 'deposit_detail', 'Deposit detail', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (663, 'new_deposit', 'New Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (664, 'edit_deposit', 'Edit Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (665, 'select_customer', 'Select Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (666, 'draw', 'Draw', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (667, 'deposit', 'Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (668, 'select_type', 'Select Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (669, 'transaction_type', 'Transaction Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (670, 'cash', 'Cash', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (671, 'select_bank', 'Select Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (672, 'drawing', 'Drawing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (673, 'expenses', 'Expenses', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (674, 'banking', 'Banking', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (675, 'daily_closing', 'Daily Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (676, 'title', 'Title', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (677, 'error_get_data_from_ajax', 'Error get data from ajax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (678, 'toggle_navigation', 'Toggle Navigation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (679, 'this_product_not_found', 'This Medicine  Not Found !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (680, 'search_by_date_from', 'Search By Date: From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (681, 'manufacturer_sales_report', 'Manufacturer Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (682, 'transection', 'Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (683, 'transection_mood', 'Transection Mood', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (684, 'transection_categry', 'Transection Categry', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (685, 'export_csv', 'Export CSV', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (686, 'select manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (687, 'customer_return', 'Customer Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (688, 'return_form', 'Return Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (689, 'data_not_found', 'Data Not Found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (690, 'export_csv', 'Export CSV', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (691, 'manage_person', 'Manage Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (692, 'backup', 'Back Up', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (693, 'total_balance', 'Total Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (694, 'product_id_model_manufacturer_id_can_not_null', 'Medicine Id & Medicine Type & Manufacturer Id Can not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (695, 'product_name_can_not_be_null', 'Medicine  Name can Not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (696, 'product_model_can_not_be_null', 'Medicine  Model Can Not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (697, 'sms', 'SMS', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (698, 'sms_configure', 'Sms Configuration', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (699, 'url', 'Url', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (700, 'sender_id', 'Sender ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (701, 'api_key', 'Api Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (702, 'barcode_or_qrcode', 'Barcode Or QRcode ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (703, 'currency_name', 'Currency Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (704, 'add_currency', 'Add Currency', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (705, 'currency_icon', 'Currency Icon', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (706, 'currency_list', 'Currency List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (707, 'import', 'Import', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (708, 'c_o_a', 'Chart Of Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (709, 'supplier_payment', 'Supplier Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (710, 'customer_receive', 'Customer Receive', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (711, 'debit_voucher', 'Debit Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (712, 'credit_voucher', 'Credit voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (713, 'voucher_approval', 'Voucher Approval', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (714, 'contra_voucher', 'Contra Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (715, 'journal_voucher', 'Journal Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (716, 'voucher_report', 'Voucher Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (717, 'cash_book', 'Cash Book', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (718, 'inventory_ledger', 'Inventory Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (719, 'bank_book', 'Bank Book', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (720, 'general_ledger', 'General Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (721, 'trial_balance', 'Trial Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (722, 'profit_loss_report', 'Profit Loss Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (723, 'cash_flow', 'Cash Flow', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (724, 'coa_print', 'COA Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (725, 'manufacturer_payment', 'Manufacturer Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (726, 'add_more', 'Add More', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (727, 'code', 'Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (728, 'remark', 'Transaction Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (729, 'voucher_no', 'Voucher NO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (730, 'accounts_tree_view', 'Accounts Tree view', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (731, 'find', 'Find', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (732, 'voucher_type', 'Voucher Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (733, 'particulars', 'Particulars', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (734, 'cash_flow_statement', 'Cash Flow Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (735, 'amount_in_dollar', 'Amount In Dollar', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (736, 'opening_cash_and_equivalent', 'Opening Cash and Equivalent', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (737, 'with_details', 'With Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (738, 'transaction_head', 'Transaction Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (739, 'gl_head', 'General Ledger Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (740, 'no_report', 'No Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (741, 'pre_balance', 'Pre Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (742, 'current_balance', 'Current Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (743, 'from_date', 'From Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (744, 'to_date', 'To Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (745, 'profit_loss', 'Profit Loss Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (746, 'add_expense_item', 'Add Expense Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (747, 'manage_expense_item', 'Manage Expense Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (748, 'add_expense', 'Add Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (749, 'manage_expense', 'Manage Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (750, 'expense_statement', 'Expense Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (751, 'expense_type', 'Expense Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (752, 'expense_item_name', 'Expense Item Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (753, 'opening_balance', 'Opening Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (754, 'tax_settings', 'Tax Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (755, 'add_incometax', 'Add Income Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (756, 'manage_income_tax', 'Manage Income tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (757, 'tax_report', 'Tax Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (758, 'invoice_wise_tax_report', 'Invoice Wise Tax Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (759, 'number_of_tax', 'Number of Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (760, 'default_value', 'Default Value', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (761, 'reg_no', 'Registration No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (762, 'tax_name', 'Tax Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (763, 'service_id', 'Service Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (764, 'service', 'Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (765, 'add_service', 'Add Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (766, 'manage_service', 'Manage Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (767, 'service_invoice', 'Service Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (768, 'manage_service_invoice', 'Manage Service Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (769, 'service_name', 'Service Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (770, 'charge', 'Charge', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (771, 'add', 'Add', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (772, 'previous', 'Previous', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (773, 'net_total', 'Net Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (774, 'hanging_over', 'Estimated Time Of Departure', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (775, 'service_discount', 'Service Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (776, 'hrm', 'HRM', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (777, 'add_designation', 'Add Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (778, 'manage_designation', 'Manage Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (779, 'add_employee', 'Add Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (780, 'manage_employee', 'Manage Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (781, 'attendance', 'Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (782, 'add_attendance', 'Add Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (783, 'manage_attendance', 'Manage Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (784, 'attendance_report', 'Attendance Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (785, 'payroll', 'Payroll', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (786, 'add_benefits', 'Add Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (787, 'manage_benefits', 'Manage Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (788, 'add_salary_setup', 'Add Salary Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (789, 'manage_salary_setup', 'Manage Salary Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (790, 'salary_generate', 'Salary Generate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (791, 'manage_salary_generate', 'Manage Salary Generate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (792, 'salary_payment', 'Salary Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (793, 'designation', 'Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (794, 'rate_type', 'Rate Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (795, 'hour_rate_or_salary', 'Hourly Rate/Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (796, 'blood_group', 'Blood Group', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (797, 'address_line_1', 'Address Line 1', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (798, 'address_line_2', 'Address Line 2', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (799, 'picture', 'Picture', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (800, 'country', 'Country', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (801, 'city', 'City', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (802, 'zip', 'Zip code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (803, 'single_checkin', 'Single Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (804, 'bulk_checkin', 'Bulk Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (805, 'checkin', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (806, 'employee_name', 'Employee Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (807, 'check_in', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (808, 'checkout', 'Check Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (809, 'confirm_clock', 'Confirm Clock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (810, 'stay', 'Stay', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (811, 'download_sample_file', 'Download Sample File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (812, 'employee', 'Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (813, 'sign_in', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (814, 'sign_out', 'Check  Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (815, 'staytime', 'Stay Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (816, 'benefits_list', 'Benefit List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (817, 'benefits', 'Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (818, 'benefit_type', 'Benefit Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (819, 'salary_benefits', 'Salary Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (820, 'salary_benefits_type', 'Salary Benefits Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (821, 'hourly', 'Hourly', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (822, 'salary', 'Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (823, 'timezone', 'Time Zone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (824, 'request', 'Request', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (825, 'datewise_report', 'Date Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (826, 'work_hour', 'Work Hours', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (827, 'employee_wise_report', 'Employee Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (828, 'date_in_time_report', 'In Time Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (829, 'successfully_checkout', 'Successfully Checked Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (830, 'setup_tax', 'Setup Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (831, 'start_amount', 'Start Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (832, 'end_amount', 'End Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (833, 'tax_rate', 'Tax Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (834, 'setup', 'Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (835, 'income_tax_updateform', 'Income Tax Update Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (836, 'salary_type', 'Salary Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (837, 'addition', 'Addition', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (838, 'gross_salary', 'Gross Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (839, 'set', 'Set', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (840, 'salary_month', 'Salary Month', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (841, 'generate', 'Generate ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (842, 'total_salary', 'Total Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (843, 'total_working_minutes', 'Total Working Hours', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (844, 'working_period', 'Total Working Days', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (845, 'paid_by', 'Paid By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (846, 'pay_now', 'Pay Now ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (847, 'confirm', 'Confirm', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (848, 'generate_by', 'Generate By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (849, 'gui_pos', 'GUI POS', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (850, 'add_fixed_assets', 'Add Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (851, 'fixed_assets_list', 'Fixed Asset List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (852, 'fixed_assets_purchase', 'Purchase Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (853, 'fixed_assets_purchase_manage', 'Fixed Assets Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (854, 'fixed_assets', 'Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (855, 'item_code', 'Item code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (856, 'item_name', 'Item Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (857, 'opening_assets', 'Assets Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (858, 'edit_fixed_asset', 'Edit Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (859, 'save_change', 'Save Change', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (860, 'in_word', 'In Word', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (861, 'purchase_pad_print', 'Purchase Pad Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (862, 'fixed_assets_purchase_details', 'Fixed Assets Purchase Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (863, 'manage_language', 'Manage Language', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (864, 'person_edit', 'Person Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (865, 'person_ledger', 'Person Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (866, 'medicine_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (867, 'unit_list', 'Unit List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (868, 'add_unit', 'Add Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (869, 'edit_unit', 'Edit Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (870, 'unit_name', 'Unit Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (871, 'unit_not_selected', 'Unit did not Selected', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (872, 'supplier', 'Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (873, 'add_supplier', 'Add Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (874, 'manage_supplier', 'Manage Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (875, 'supplier_ledger', 'Supplier Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (876, 'supplier_sales_details', 'Supplier Sales Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (877, 'purchase_detail', 'Purchase details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (878, 'purchase_information', 'Purchase Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (879, 'account_head', 'Account Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (880, 'transaction_date', 'Transaction Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (881, 'approved', 'Approve', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (882, 'date_wise_report', 'Date Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (883, 'time_wise_report', 'Time Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (884, 'report_date', 'Report Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (885, 's_time', 'Start Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (886, 'e_time', 'End Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (887, 'basic', 'Basic', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (888, 'supplier_name', 'Supplier Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (889, 'supplier_mobile', 'Supplier Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (890, 'supplier_address', 'Supplier Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (891, 'supplier_details', 'Supplier Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (892, 'select_supplier', 'Select Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (893, 'accounts_report', 'Accounts Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (894, 'account_code', 'Account Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (895, 'human_resource_management', 'Human Resource ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (896, 'menu_name', 'Menu Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (897, 'head_of_account', 'Account Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (898, 'successfully_approved', 'Successfully Approved', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (899, 'supplier_edit', 'Supplier Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES (900, 'supplier_id', 'Supplier ID', NULL);


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_rtl` varchar(10) NOT NULL DEFAULT 'no',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', 'no', '2021-09-28 15:51:22', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', 'no', '2021-09-28 16:08:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', 'no', '2021-09-28 15:50:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', 'no', '2021-09-16 11:20:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', 'no', '2021-09-28 15:50:48', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Afrikaans', 'af', 'af', 'no', 'no', 'no', '2021-09-28 16:51:19', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Basque', 'eu', 'es', 'no', 'no', 'no', '2021-09-24 12:58:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Bengali', 'bn', 'in', 'no', 'no', 'no', '2021-09-24 12:58:25', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Bosnian', 'bs', 'bs', 'no', 'no', 'no', '2021-09-24 12:58:28', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Welsh', 'cy', 'cy', 'no', 'no', 'no', '2021-09-24 12:58:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Hungarian', 'hu', 'hu', 'no', 'no', 'no', '2021-09-24 12:58:35', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Vietnamese', 'vi', 'vi', 'no', 'no', 'no', '2021-09-24 12:58:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Haitian', 'ht', 'ht', 'no', 'no', 'no', '2021-09-24 12:58:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Galician', 'gl', 'gl', 'no', 'no', 'no', '2021-09-24 12:58:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'nl', 'nl', 'no', 'no', 'no', '2021-09-24 12:58:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Greek', 'el', 'gr', 'no', 'no', 'no', '2021-09-24 12:58:53', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Georgian', 'ka', 'ge', 'no', 'no', 'no', '2021-09-24 12:58:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Gujarati', 'gu', 'in', 'no', 'no', 'no', '2021-09-24 12:58:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Danish', 'da', 'dk', 'no', 'no', 'no', '2021-09-24 12:59:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'Hebrew', 'he', 'il', 'no', 'no', 'no', '2021-09-24 12:59:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Yiddish', 'yi', 'il', 'no', 'no', 'no', '2021-09-24 12:59:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Indonesian', 'id', 'id', 'no', 'no', 'no', '2021-09-24 12:59:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Irish', 'ga', 'ga', 'no', 'no', 'no', '2021-09-24 12:59:14', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Italian', 'it', 'it', 'no', 'no', 'no', '2021-09-24 12:59:17', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Icelandic', 'is', 'is', 'no', 'no', 'no', '2021-09-24 12:59:20', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Spanish', 'es', 'es', 'no', 'no', 'no', '2021-09-24 12:59:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Kannada', 'kn', 'kn', 'no', 'no', 'no', '2021-09-24 12:59:32', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Catalan', 'ca', 'ca', 'no', 'no', 'no', '2021-09-24 12:59:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Chinese', 'zh', 'cn', 'no', 'no', 'no', '2021-09-24 12:59:36', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Korean', 'ko', 'kr', 'no', 'no', 'no', '2021-09-24 12:59:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Xhosa', 'xh', 'ls', 'no', 'no', 'no', '2021-09-24 12:59:42', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'Latin', 'la', 'la', 'no', 'no', 'no', '2021-09-24 12:59:45', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Latvian', 'lv', 'lv', 'no', 'no', 'no', '2021-09-24 12:59:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Lithuanian', 'lt', 'lt', 'no', 'no', 'no', '2021-09-24 12:59:50', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'Malagasy', 'mg', 'mg', 'no', 'no', 'no', '2021-09-24 12:59:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Malay', 'ms', 'ms', 'no', 'no', 'no', '2021-09-24 13:00:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Malayalam', 'ml', 'ml', 'no', 'no', 'no', '2021-09-24 13:00:05', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Maltese', 'mt', 'mt', 'no', 'no', 'no', '2021-09-24 13:00:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Macedonian', 'mk', 'mk', 'no', 'no', 'no', '2021-09-24 13:00:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Maori', 'mi', 'nz', 'no', 'no', 'no', '2021-09-24 13:00:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Marathi', 'mr', 'in', 'no', 'no', 'no', '2021-09-24 13:00:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'Mongolian', 'mn', 'mn', 'no', 'no', 'no', '2021-09-24 13:01:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'German', 'de', 'de', 'no', 'no', 'no', '2021-09-24 13:01:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Nepali', 'ne', 'ne', 'no', 'no', 'no', '2021-09-24 13:01:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Norwegian', 'no', 'no', 'no', 'no', 'no', '2021-09-24 13:01:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Punjabi', 'pa', 'in', 'no', 'no', 'no', '2021-09-24 13:01:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Persian', 'fa', 'ir', 'no', 'no', 'no', '2021-09-24 13:01:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Portuguese', 'pt', 'pt', 'no', 'no', 'no', '2021-09-24 13:01:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Romanian', 'ro', 'ro', 'no', 'no', 'no', '2021-09-24 13:01:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'Russian', 'ru', 'ru', 'no', 'no', 'no', '2021-09-24 13:01:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Cebuano', 'ceb', 'ph', 'no', 'no', 'no', '2021-09-24 13:02:02', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'Sinhala', 'si', 'si', 'no', 'no', 'no', '2021-09-24 13:02:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Slovakian', 'sk', 'sk', 'no', 'no', 'no', '2021-09-24 13:02:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Slovenian', 'sl', 'sl', 'no', 'no', 'no', '2021-09-24 13:02:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Swahili', 'sw', 'ke', 'no', 'no', 'no', '2021-09-24 13:02:12', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'Sundanese', 'su', 'sd', 'no', 'no', 'no', '2021-09-24 13:02:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Thai', 'th', 'th', 'no', 'no', 'no', '2021-09-24 13:02:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'Tagalog', 'tl', 'tl', 'no', 'no', 'no', '2021-09-24 13:02:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Tamil', 'ta', 'in', 'no', 'no', 'no', '2021-09-24 13:02:23', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Telugu', 'te', 'in', 'no', 'no', 'no', '2021-09-24 13:02:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Turkish', 'tr', 'tr', 'no', 'no', 'no', '2021-09-24 13:02:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Uzbek', 'uz', 'uz', 'no', 'no', 'no', '2021-09-24 13:02:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'Urdu', 'ur', 'pk', 'no', 'no', 'no', '2021-09-24 13:02:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Finnish', 'fi', 'fi', 'no', 'no', 'no', '2021-09-24 13:02:37', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'French', 'fr', 'fr', 'no', 'no', 'no', '2021-09-24 13:02:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Hindi', 'hi', 'in', 'no', 'no', 'no', '2021-09-24 13:02:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Czech', 'cs', 'cz', 'no', 'no', 'no', '2021-09-24 13:02:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Swedish', 'sv', 'sv', 'no', 'no', 'no', '2021-09-24 13:02:46', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'Scottish', 'gd', 'gd', 'no', 'no', 'no', '2021-09-24 13:02:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Estonian', 'et', 'et', 'no', 'no', 'no', '2021-09-24 13:02:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Esperanto', 'eo', 'br', 'no', 'no', 'no', '2021-09-24 13:02:55', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Javanese', 'jv', 'id', 'no', 'no', 'no', '2021-09-24 13:02:58', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'Japanese', 'ja', 'jp', 'no', 'no', 'no', '2021-09-24 13:03:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Polish', 'pl', 'pl', 'no', 'no', 'no', '2021-09-28 12:39:06', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Croatia ', 'hr', 'hr', 'no', 'no', 'no', '2021-10-25 13:56:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'Kurdish', 'ku', 'iq', 'no', 'no', 'no', '2021-10-25 13:56:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Lao', 'lo', 'la', 'no', 'no', 'no', '2021-10-25 13:56:47', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `record_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `ip_address` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `agent` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10279 DEFAULT CHARSET=utf8;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-09 19:32:34', '2022-01-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-09 19:32:45', '2022-01-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-09 19:33:06', '2022-01-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-09 19:33:17', '2022-01-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:48:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:48:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:49:16', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:49:16', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:49:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:49:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:50:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'Record updated On Print Setting id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:50:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'Record updated On Print Setting id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:50:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'Record updated On Print Setting id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:50:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'Record updated On Print Setting id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:03', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'Record updated On Print Setting id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:03', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'Record updated On Print Setting id 4', 4, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:13', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'Record updated On Print Setting id 4', 4, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:13', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'Record updated On Print Setting id 5', 5, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'Record updated On Print Setting id 5', 5, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'Record updated On Print Setting id 6', 6, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'Record updated On Print Setting id 6', 6, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'Record updated On Print Setting id 7', 7, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'Record updated On Print Setting id 7', 7, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'Record updated On Print Setting id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'Record updated On Print Setting id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:51:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'Record updated On Print Setting id 9', 9, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:52:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'Record updated On Print Setting id 9', 9, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:52:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'Record updated On Print Setting id 10', 10, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:52:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'Record updated On Print Setting id 10', 10, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:52:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'Record updated On Print Setting id 11', 11, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:52:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'Record updated On Print Setting id 11', 11, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:52:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'Record updated On Print Setting id 12', 12, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:53:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'Record updated On Print Setting id 12', 12, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:53:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'Record updated On Print Setting id 13', 13, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:53:39', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'Record updated On Print Setting id 13', 13, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:53:39', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'Record updated On Print Setting id 14', 14, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:53:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'Record updated On Print Setting id 14', 14, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:53:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'Record updated On Print Setting id 15', 15, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:54:08', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'Record updated On Print Setting id 15', 15, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:54:08', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'Record updated On Print Setting id 16', 16, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:54:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'Record updated On Print Setting id 16', 16, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 03:54:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:02:11', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 04:03:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:04:37', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'Record updated For Staff id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:06:15', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'Record updated For Staff id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:07:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'Record updated Change Password For Staff id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:09:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:10:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'Record updated For Staff id 4', 4, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:49:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:49:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'Record updated For Staff id 5', 5, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:51:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'Record updated Change Password For Staff id 5', 5, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:51:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'Record updated For Staff id 6', 6, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:52:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'Record updated Change Password For Staff id 6', 6, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 10:53:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted On Pathology Category id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:10:37', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'New Record inserted On Charge Units id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:11:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'Record updated On Charge Units id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:12:07', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'New Record inserted On Tax Category id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:12:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'New Record inserted On Charge Categories id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:13:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'Record updated On Charge Categories id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:15:00', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'New Record inserted On Unit id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:18:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'New Record inserted On Radiology Parameter id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:18:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'New Record inserted On Unit id 2', 2, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:20:39', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'New Record inserted On Pathology Parameter id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:21:01', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On pathology Test id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:21:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'Record deleted On roles Permissions where Role id  2', 2, 1, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 11:34:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'New Record inserted On Pathology Category id 2', 2, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:38:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'New Record inserted On pathology Test id 2', 2, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:50:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'New Record inserted On pathology Test id 3', 3, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:51:49', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'New Record inserted On Pathology Category id 3', 3, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:52:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On Pathology Category id 4', 4, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:53:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On Pathology Category id 5', 5, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:54:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'New Record inserted On Pathology Category id 6', 6, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:54:28', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'New Record inserted On Pathology Category id 7', 7, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:54:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'New Record inserted On Pathology Category id 8', 8, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:55:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'New Record inserted On Pathology Category id 9', 9, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:55:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'New Record inserted On Pathology Category id 10', 10, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:55:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'New Record inserted On Pathology Category id 11', 11, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:56:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'New Record inserted On Pathology Category id 12', 12, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:56:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'New Record inserted On Pathology Category id 13', 13, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:57:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'New Record inserted On Pathology Category id 14', 14, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:57:30', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'New Record inserted On Pathology Category id 15', 15, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:57:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'New Record inserted On Pathology Category id 16', 16, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:57:50', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'Record updated On Pathology Category id 16', 16, 2, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 11:58:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'New Record inserted On Charge Categories id 2', 2, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:06:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On Charge Categories id 3', 3, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:07:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'New Record inserted On Charge Categories id 4', 4, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:07:47', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'New Record inserted On Charge Categories id 5', 5, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:08:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'New Record inserted On Charge Categories id 6', 6, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:08:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'New Record inserted On Charge Categories id 7', 7, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:09:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'New Record inserted On Charge Categories id 8', 8, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:09:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'New Record inserted On Charge Categories id 9', 9, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:09:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'New Record inserted On Charge Categories id 10', 10, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:10:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On Charge Categories id 11', 11, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:13:50', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'New Record inserted On Charge Categories id 12', 12, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:14:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'New Record inserted On Charge Categories id 13', 13, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:15:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'New Record inserted On Charge Categories id 14', 14, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:15:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'New Record inserted On Charge Categories id 15', 15, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:16:14', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'New Record inserted On Charge Categories id 16', 16, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:16:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'Record updated For Staff id 7', 7, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:16:37', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'New Record inserted On Charge Categories id 17', 17, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:16:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'Record deleted On Charge Categories id 17', 17, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:16:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'New Record inserted On Patient id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:17:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'Record updated On Patient id 1', 1, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:17:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'New Record inserted On Transactions id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:18:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'New Record inserted On pathology Test id 4', 4, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:21:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'New Record inserted On pathology Test id 5', 5, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:23:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On pathology Test id 6', 6, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:28:18', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'New Record inserted On Patient id 2', 2, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:28:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'Record updated On Patient id 2', 2, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:28:30', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'New Record inserted On Charge Categories id 18', 18, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:29:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'New Record inserted On pathology Test id 7', 7, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:30:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'New Record inserted On Transactions id 2', 2, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:32:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'New Record inserted On pathology Test id 8', 8, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:32:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'New Record inserted On pathology Test id 9', 9, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:35:23', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'New Record inserted On pathology Test id 10', 10, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:36:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'New Record inserted On Transactions id 3', 3, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 12:43:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'New Record inserted On pathology Test id 11', 11, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:47:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'Record deleted On Charges id 13', 13, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'Record deleted On Charges id 12', 12, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'Record deleted On Charges id 12', 12, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:43', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'Record deleted On Charges id 12', 12, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'Record deleted On Charges id 11', 11, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:48:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'Record deleted On Charges id 10', 10, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'Record deleted On Charges id 9', 9, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'Record deleted On Charges id 8', 8, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:16', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'Record deleted On Charges id 7', 7, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'Record deleted On Charges id 6', 6, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:34', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'Record deleted On Charges id 6', 6, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:46', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:46', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:49:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:15', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'Record deleted On Charges id 5', 5, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:26', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'Record deleted On Charges id 4', 4, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:39', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'Record deleted On Charges id 4', 4, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'Record deleted On Charges id 4', 4, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:45', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'Record deleted On Charges id 3', 3, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'Record deleted On Charges id 3', 3, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'Record deleted On Charges id 1', 1, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 12:50:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:02:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On pathology Test id 12', 12, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:02:50', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'New Record inserted On Transactions id 4', 4, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:04:14', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:05:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:05:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'Record deleted On Charges id 14', 14, 2, 'Delete', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:08:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'New Record inserted On Staff Designation id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:09:49', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'New Record inserted On Department id 1', 1, 1, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:10:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:10:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'Record updated For Staff id 8', 8, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:10:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'New Record inserted On pathology Test id 13', 13, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:11:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'Record updated On Pathology Report id 3', 3, 1, 'Update', '202.83.127.189', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:11:30', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'New Record inserted On pathology Test id 14', 14, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:13:38', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'New Record inserted On pathology Test id 15', 15, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:37:11', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'New Record inserted On pathology Test id 16', 16, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:39:48', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'New Record inserted On pathology Test id 17', 17, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:41:18', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'New Record inserted On pathology Test id 18', 18, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:42:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'New Record inserted On pathology Test id 19', 19, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:43:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'New Record inserted On pathology Test id 20', 20, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:44:00', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'New Record inserted On pathology Test id 21', 21, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:44:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On pathology Test id 22', 22, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:45:27', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'New Record inserted On pathology Test id 23', 23, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:46:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'New Record inserted On pathology Test id 24', 24, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:48:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'New Record inserted On pathology Test id 25', 25, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:49:59', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'New Record inserted On pathology Test id 26', 26, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:51:46', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'New Record inserted On pathology Test id 27', 27, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:52:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'New Record inserted On pathology Test id 28', 28, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:53:13', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'New Record inserted On pathology Test id 29', 29, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:54:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'New Record inserted On pathology Test id 30', 30, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:54:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'New Record inserted On pathology Test id 31', 31, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:54:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'New Record inserted On pathology Test id 32', 32, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:55:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'New Record inserted On pathology Test id 33', 33, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:56:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'New Record inserted On pathology Test id 34', 34, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 13:56:51', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'New Record inserted On pathology Test id 35', 35, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:59:38', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'New Record inserted On pathology Test id 36', 36, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 13:59:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'New Record inserted On pathology Test id 37', 37, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:02:27', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'New Record inserted On pathology Test id 38', 38, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:04:57', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'New Record inserted On pathology Test id 39', 39, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:05:08', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On pathology Test id 40', 40, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:05:26', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'New Record inserted On pathology Test id 41', 41, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:06:07', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'New Record inserted On pathology Test id 42', 42, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:06:08', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'New Record inserted On pathology Test id 43', 43, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:06:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'New Record inserted On pathology Test id 44', 44, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:07:07', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'New Record inserted On pathology Test id 45', 45, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:07:11', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'New Record inserted On pathology Test id 46', 46, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:07:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'New Record inserted On pathology Test id 47', 47, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:07:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'New Record inserted On pathology Test id 48', 48, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:08:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'New Record inserted On pathology Test id 49', 49, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:08:14', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'New Record inserted On pathology Test id 50', 50, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:09:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'New Record inserted On pathology Test id 51', 51, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:09:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On pathology Test id 52', 52, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:09:56', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'New Record inserted On pathology Test id 53', 53, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:10:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'New Record inserted On pathology Test id 54', 54, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:10:38', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'New Record inserted On pathology Test id 55', 55, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:10:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'New Record inserted On pathology Test id 56', 56, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:11:02', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'New Record inserted On pathology Test id 57', 57, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:11:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On pathology Test id 58', 58, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:12:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'New Record inserted On pathology Test id 59', 59, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:12:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On pathology Test id 60', 60, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:12:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'New Record inserted On pathology Test id 61', 61, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:14:00', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'New Record inserted On pathology Test id 62', 62, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:14:06', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'New Record inserted On pathology Test id 63', 63, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:14:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On pathology Test id 64', 64, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:14:44', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'New Record inserted On pathology Test id 65', 65, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:15:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'New Record inserted On pathology Test id 66', 66, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:15:31', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'New Record inserted On pathology Test id 67', 67, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:15:53', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On pathology Test id 68', 68, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:16:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'New Record inserted On pathology Test id 69', 69, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:16:36', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'New Record inserted On pathology Test id 70', 70, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:16:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On pathology Test id 71', 71, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:17:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'New Record inserted On pathology Test id 72', 72, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:17:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'New Record inserted On pathology Test id 73', 73, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:17:38', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'New Record inserted On pathology Test id 74', 74, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:18:17', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'New Record inserted On pathology Test id 75', 75, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:18:23', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'New Record inserted On pathology Test id 76', 76, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:18:37', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On pathology Test id 77', 77, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:19:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'New Record inserted On pathology Test id 78', 78, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:19:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'New Record inserted On pathology Test id 79', 79, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:19:32', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'New Record inserted On pathology Test id 80', 80, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:19:58', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'New Record inserted On pathology Test id 81', 81, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:20:21', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'New Record inserted On pathology Test id 82', 82, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:20:23', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'New Record inserted On pathology Test id 83', 83, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:21:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On pathology Test id 84', 84, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:21:11', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'New Record inserted On pathology Test id 85', 85, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:21:35', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'New Record inserted On pathology Test id 86', 86, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:22:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'New Record inserted On pathology Test id 87', 87, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:22:09', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'New Record inserted On pathology Test id 88', 88, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:22:20', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'New Record inserted On pathology Test id 89', 89, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:23:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'New Record inserted On pathology Test id 90', 90, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:23:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'New Record inserted On pathology Test id 91', 91, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:23:23', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'New Record inserted On pathology Test id 92', 92, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:23:24', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'New Record inserted On pathology Test id 93', 93, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:24:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'New Record inserted On pathology Test id 94', 94, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:24:26', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'New Record inserted On pathology Test id 95', 95, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:24:36', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'New Record inserted On pathology Test id 96', 96, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:24:54', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'New Record inserted On pathology Test id 97', 97, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:25:01', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'New Record inserted On pathology Test id 98', 98, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:25:19', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'New Record inserted On pathology Test id 99', 99, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:26:03', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'New Record inserted On pathology Test id 100', 100, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:26:05', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'New Record inserted On pathology Test id 101', 101, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:26:12', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'New Record inserted On pathology Test id 102', 102, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:26:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'New Record inserted On pathology Test id 103', 103, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:26:55', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'New Record inserted On pathology Test id 104', 104, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:27:33', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'New Record inserted On Pathology Category id 17', 17, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:28:29', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'New Record inserted On pathology Test id 105', 105, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:28:52', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'New Record inserted On pathology Test id 106', 106, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:29:10', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'New Record inserted On pathology Test id 107', 107, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:29:50', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'New Record inserted On pathology Test id 108', 108, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:30:22', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'New Record inserted On pathology Test id 109', 109, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:30:40', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'New Record inserted On pathology Test id 110', 110, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:30:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'New Record inserted On pathology Test id 111', 111, 6, 'Insert', '103.120.160.173', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:31:35', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'New Record inserted On pathology Test id 112', 112, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:31:41', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'New Record inserted On pathology Test id 113', 113, 2, 'Insert', '202.83.127.189', 'Windows 10', 'Chrome 96.0.4664.110', '2022-01-11 14:32:01', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'New Record inserted On pathology Test id 114', 114, 5, 'Insert', '43.250.83.89', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:32:25', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'New Record inserted On pathology Test id 115', 115, 4, 'Insert', '103.102.246.3', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-11 14:32:42', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 04:25:04', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 04:25:15', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 04:25:28', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'Record updated On Settings id 1', 1, 1, 'Update', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 04:26:36', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'New Record inserted On pathology Test id 116', 116, 2, 'Insert', '202.83.127.191', 'Windows 10', 'Chrome 97.0.4692.71', '2022-01-12 04:35:43', '2022-01-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, 