#
# TABLE STRUCTURE FOR: acc_coa
#

DROP TABLE IF EXISTS `acc_coa`;

CREATE TABLE `acc_coa` (
  `HeadCode` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `HeadName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `PHeadName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `HeadLevel` int(11) NOT NULL,
  `IsActive` tinyint(1) NOT NULL,
  `IsTransaction` tinyint(1) NOT NULL,
  `IsGL` tinyint(1) NOT NULL,
  `HeadType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `IsBudget` tinyint(1) NOT NULL,
  `IsDepreciation` tinyint(1) NOT NULL,
  `DepreciationRate` decimal(18,2) NOT NULL,
  `CreateBy` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `CreateDate` datetime NOT NULL,
  `UpdateBy` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `UpdateDate` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021403', 'AC', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:33:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202', 'Account Payable', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10203', 'Account Receivable', 'Current Asset', 2, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2013-09-18 15:29:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020201', 'Advance', 'Advance, Deposit And Pre-payments', 3, 1, 0, 1, 'A', 0, 0, '0.00', 'Zoherul', '2015-05-31 13:29:12', 'admin', '2015-12-31 16:46:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020103', 'Advance House Rent', 'Advance', 4, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-10-02 16:55:38', 'admin', '2016-10-02 16:57:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10202', 'Advance, Deposit And Pre-payments', 'Current Asset', 2, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-12-31 16:46:24');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020602', 'Advertisement and Publicity', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:51:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010410', 'Air Cooler', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-05-23 12:13:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020603', 'AIT Against Advertisement', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:09', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020200001', 'any-CDC5X7X2KR3ILJVQTIVG', 'Account Payable', 3, 1, 1, 0, 'L', 0, 0, '0.00', '1', '2022-02-23 23:30:57', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1', 'Assets', 'COA', 0, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010204', 'Attendance Machine', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:49:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40216', 'Audit Fee', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2017-07-18 12:54:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021002', 'Bank Charge', 'Financial Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:21:03', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30203', 'Bank Interest', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'Obaidul', '2015-01-03 14:49:54', 'admin', '2016-09-25 11:04:19');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010104', 'Book Shelf', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:46:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010407', 'Books and Journal', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:45:37', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020604', 'Business Development Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020606', 'Campaign Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:52:57', 'admin', '2016-09-19 14:52:48');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020502', 'Campus Rent', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:46:53', 'admin', '2017-04-27 17:02:39');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40212', 'Car Running Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:28:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10201', 'Cash & Cash Equivalent', 'Current Asset', 2, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-06-12 11:47:24', 'admin', '2015-10-15 15:57:55');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020102', 'Cash At Bank', 'Cash & Cash Equivalent', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-03-18 06:08:18', 'admin', '2015-10-15 15:32:42');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020101', 'Cash In Hand', 'Cash & Cash Equivalent', 3, 1, 1, 0, 'A', 0, 0, '0.00', '1', '2019-01-26 07:38:48', 'admin', '2016-05-23 12:05:43');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010207', 'CCTV', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:24', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020102', 'CEO Current A/C', 'Advance', 4, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-09-25 11:54:54', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010101', 'Class Room Chair', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:45:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021407', 'Close Circuit Cemera', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:35', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020601', 'Commision on Admission', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:51:21', 'admin', '2016-09-19 14:42:54');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010206', 'Computer', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:09', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021410', 'Computer (R)', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-03-24 12:38:52', 'Zoherul', '2016-03-24 12:41:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010102', 'Computer Table', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:45:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('301020401', 'Continuing Registration fee - UoL (Income)', 'Registration Fee (UOL) Income', 4, 1, 1, 0, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:40:40', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020904', 'Contratuall Staff Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:34', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020709', 'Cultural Expense', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'nasmud', '2017-04-29 12:45:10', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102', 'Current Asset', 'Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2018-07-07 11:23:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502', 'Current Liabilities', 'Liabilities', 1, 1, 0, 0, 'L', 0, 0, '0.00', 'anwarul', '2014-08-30 13:18:20', 'admin', '2015-10-15 19:49:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020301', 'Customer Receivable', 'Account Receivable', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-01-24 12:10:05', 'admin', '2018-07-07 12:31:42');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020202', 'Deposit', 'Advance, Deposit And Pre-payments', 3, 1, 0, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:40:42', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020605', 'Design & Printing Expense', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:55:00', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020404', 'Dish Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40215', 'Dividend', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2016-09-25 14:07:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020403', 'Drinking Water Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:10', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010211', 'DSLR Camera', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:53:17', 'admin', '2016-01-02 16:23:25');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020908', 'Earned Leave', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:38', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020607', 'Education Fair Expenses', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:53:42', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010602', 'Electric Equipment', 'Electrical Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:44:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010203', 'Electric Kettle', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:49:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10106', 'Electrical Equipment', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:43:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020407', 'Electricity Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:59:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50204', 'Employee Ledger', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', '1', '2019-04-08 10:36:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('404', 'Employee Salary', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-23 05:46:14', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40201', 'Entertainment', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:21:26', 'anwarul', '2013-07-17 14:21:47');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('2', 'Equity', 'COA', 0, 1, 0, 0, 'L', 0, 0, '0.00', '', '2019-08-10 11:01:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4', 'Expence', 'COA', 0, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-06-18 11:40:41', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020903', 'Faculty,Staff Salary & Allowances', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021404', 'Fax Machine', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:34:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020905', 'Festival & Incentive Bonus', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:48', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010103', 'File Cabinet', 'Furniture & Fixturers', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:46:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40210', 'Financial Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-08-20 12:24:31', 'admin', '2015-10-15 19:20:36');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010403', 'Fire Extingushier', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:39:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('405', 'Fixed Assets Cost', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-29 05:32:01', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021408', 'Furniture', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:47', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10101', 'Furniture & Fixturers', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'anwarul', '2013-08-20 16:18:15', 'anwarul', '2013-08-21 13:35:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020406', 'Gas Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:59:20', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20201', 'General Reserve', 'Reserve & Surplus', 2, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-25 14:07:12', 'admin', '2016-10-02 17:48:49');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10105', 'Generator', 'Non Current Assets', 2, 1, 1, 1, 'A', 0, 0, '0.00', 'Zoherul', '2016-02-27 16:02:35', 'admin', '2016-05-23 12:05:18');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021414', 'Generator Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-06-16 10:21:05', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40213', 'Generator Running Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:29:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10103', 'Groceries and Cutleries', 'Non Current Assets', 2, 1, 1, 1, 'A', 0, 0, '0.00', '2', '2018-07-12 10:02:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010408', 'Gym Equipment', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:46:03', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020907', 'Honorarium', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:26', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40205', 'House Rent', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-08-24 10:26:56', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3', 'Income', 'COA', 0, 1, 0, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:32:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30204', 'Income from Photocopy & Printing', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'Zoherul', '2015-07-14 10:29:54', 'admin', '2016-09-25 11:04:28');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020302', 'Income Tax Payable', 'Liabilities for Expenses', 3, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2016-09-19 11:18:17', 'admin', '2016-09-28 13:18:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10107', 'Inventory', 'Non Current Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '2', '2018-07-07 15:21:58', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010210', 'LCD TV', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:52:27', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30103', 'Lease Sale', 'Store Income', 1, 1, 1, 1, 'I', 0, 0, '0.00', '2', '2018-07-08 07:51:52', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5', 'Liabilities', 'COA', 0, 1, 0, 0, 'L', 0, 0, '0.00', 'admin', '2013-07-04 12:32:07', 'admin', '2015-10-15 19:46:54');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50203', 'Liabilities for Expenses', 'Current Liabilities', 2, 1, 0, 0, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020707', 'Library Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2017-01-10 15:34:54', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021409', 'Lift', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:36:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020302', 'Loan Receivable', 'Account Receivable', 3, 1, 0, 1, 'A', 0, 0, '0.00', '1', '2019-01-26 07:37:20', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50101', 'Long Term Borrowing', 'Non Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2013-07-04 12:32:26', 'admin', '2015-10-15 19:47:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020608', 'Marketing & Promotion Exp.', 'Promonational Expence', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:53:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020901', 'Medical Allowance', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:11:33', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010411', 'Metal Ditector', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'Zoherul', '2016-08-22 10:55:22', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021413', 'Micro Oven', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-05-12 14:53:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30202', 'Miscellaneous (Income)', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'anwarul', '2014-02-06 15:26:31', 'admin', '2016-09-25 11:04:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020909', 'Miscellaneous Benifit', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:53', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020701', 'Miscellaneous Exp', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-09-25 12:54:39', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40207', 'Miscellaneous Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2014-04-26 16:49:56', 'admin', '2016-09-25 12:54:19');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010401', 'Mobile Phone', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-29 10:43:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010212', 'Network Accessories', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-02 16:23:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020408', 'News Paper Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-01-02 15:55:57', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('101', 'Non Current Assets', 'Assets', 1, 1, 0, 0, 'A', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-10-15 15:29:11');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('501', 'Non Current Liabilities', 'Liabilities', 1, 1, 0, 0, 'L', 0, 0, '0.00', 'anwarul', '2014-08-30 13:18:20', 'admin', '2015-10-15 19:49:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010404', 'Office Decoration', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:40:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10102', 'Office Equipment', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'anwarul', '2013-12-06 18:08:00', 'admin', '2015-10-15 15:48:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021401', 'Office Repair & Maintenance', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:33:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30201', 'Office Stationary (Income)', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'anwarul', '2013-07-17 15:21:06', 'admin', '2016-09-25 11:04:50');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('302', 'Other Income', 'Income', 1, 1, 0, 0, 'I', 0, 0, '0.00', '2', '2018-07-07 13:40:57', 'admin', '2016-09-25 11:04:09');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40211', 'Others (Non Academic Expenses)', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'Obaidul', '2014-12-03 16:05:42', 'admin', '2015-10-15 19:22:09');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30205', 'Others (Non-Academic Income)', 'Other Income', 2, 1, 0, 1, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:23:49', 'admin', '2015-10-15 17:57:52');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10104', 'Others Assets', 'Non Current Assets', 2, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2016-01-29 10:43:16', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020910', 'Outstanding Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 11:56:50', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021405', 'Oven', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:34:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021412', 'PABX-Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 14:40:18', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020902', 'Part-time Staff Salary', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:12:06', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010202', 'Photocopy & Fax Machine', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:47:27', 'admin', '2016-05-23 12:14:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021411', 'Photocopy Machine Repair', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'Zoherul', '2016-04-24 12:40:02', 'admin', '2017-04-27 17:03:17');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020503', 'Practical Fee', 'Others (Non-Academic Income)', 3, 1, 1, 1, 'I', 0, 0, '0.00', 'admin', '2017-07-22 18:00:37', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020203', 'Prepayment', 'Advance, Deposit And Pre-payments', 3, 1, 0, 1, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:40:51', 'admin', '2015-12-31 16:49:58');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010201', 'Printer', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:47:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40202', 'Printing and Stationary', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:21:45', 'admin', '2016-09-19 14:39:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('402', 'Product Purchase', 'Expence', 1, 1, 1, 0, 'E', 0, 0, '0.00', '1', '2019-05-20 07:46:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('304', 'Product Sale', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-06-16 12:15:40', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020502', 'Professional Training Course(Oracal-1)', 'Others (Non-Academic Income)', 3, 1, 1, 0, 'I', 0, 0, '0.00', 'nasim', '2017-06-22 13:28:05', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30207', 'Professional Training Course(Oracal)', 'Other Income', 2, 1, 0, 1, 'I', 0, 0, '0.00', 'nasim', '2017-06-22 13:24:16', 'nasim', '2017-06-22 13:25:56');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010208', 'Projector', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40206', 'Promonational Expence', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-07-11 13:48:57', 'anwarul', '2013-07-17 14:23:03');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40214', 'Repair and Maintenance', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:32:46', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('202', 'Reserve & Surplus', 'Equity', 1, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2016-09-25 14:06:34', 'admin', '2016-10-02 17:48:57');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20102', 'Retained Earnings', 'Share Holders Equity', 2, 1, 1, 1, 'L', 0, 0, '0.00', 'admin', '2016-05-23 11:20:40', 'admin', '2016-09-25 14:05:06');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020708', 'River Cruse', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2017-04-24 15:35:25', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020105', 'Salary', 'Advance', 4, 1, 0, 0, 'A', 0, 0, '0.00', 'admin', '2018-07-05 11:46:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40209', 'Salary & Allowances', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-12-12 11:22:58', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010406', 'Security Equipment', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:41:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('305', 'Service Income', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-22 13:36:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20101', 'Share Capital', 'Share Holders Equity', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'anwarul', '2013-12-08 19:37:32', 'admin', '2015-10-15 19:45:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('201', 'Share Holders Equity', 'Equity', 1, 1, 0, 0, 'L', 0, 0, '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-10-15 19:43:51');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50201', 'Short Term Borrowing', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:50:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40208', 'Software Development Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-11-21 14:13:01', 'admin', '2015-10-15 19:02:51');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020906', 'Special Allowances', 'Salary & Allowances', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:13:13', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50102', 'Sponsors Loan', 'Non Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:48:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020706', 'Sports Expense', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'nasmud', '2016-11-09 13:16:53', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('301', 'Store Income', 'Income', 1, 1, 0, 0, 'I', 0, 0, '0.00', '2', '2018-07-07 13:40:37', 'admin', '2015-09-17 17:00:02');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020501', 'Students Info. Correction Fee', 'Others (Non-Academic Income)', 3, 1, 1, 0, 'I', 0, 0, '0.00', 'admin', '2015-10-15 17:24:45', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010601', 'Sub Station', 'Electrical Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:44:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50205', 'Supplier Ledger', 'Current Liabilities', 2, 1, 0, 1, 'L', 0, 0, '0.00', '1', '2019-10-06 06:18:49', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020704', 'TB Care Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-10-08 13:03:04', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30206', 'TB Care Income', 'Other Income', 2, 1, 1, 1, 'I', 0, 0, '0.00', 'admin', '2016-10-08 13:00:56', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020501', 'TDS on House Rent', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:44:07', 'admin', '2016-09-19 14:40:16');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030201', 'TDS Payable House Rent', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-19 11:19:42', 'admin', '2016-09-28 13:19:37');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030203', 'TDS Payable on Advertisement Bill', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-28 13:20:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030202', 'TDS Payable on Salary', 'Income Tax Payable', 4, 1, 1, 0, 'L', 0, 0, '0.00', 'admin', '2016-09-28 13:20:17', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020402', 'Telephone Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:57:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010209', 'Telephone Set & PABX', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:51:57', 'admin', '2016-10-02 17:10:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30301', 'test in 1', 'Test Income', 2, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:25:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('303', 'Test Income', 'Income', 1, 1, 1, 0, 'I', 0, 0, '0.00', '1', '2019-05-20 05:24:33', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40203', 'Travelling & Conveyance', 'Other Expenses', 2, 1, 1, 1, 'E', 0, 0, '0.00', 'admin', '2013-07-08 16:22:06', 'admin', '2015-10-15 18:45:13');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021406', 'TV', 'Repair and Maintenance', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 19:35:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010205', 'UPS', 'Office Equipment', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2015-10-15 15:50:38', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40204', 'Utility Expenses', 'Other Expenses', 2, 1, 0, 1, 'E', 0, 0, '0.00', 'anwarul', '2013-07-11 16:20:24', 'admin', '2016-01-02 15:55:22');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020503', 'VAT on House Rent Exp', 'House Rent', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:49:22', 'admin', '2016-09-25 14:00:52');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020301', 'VAT Payable', 'Liabilities for Expenses', 3, 1, 0, 1, 'L', 0, 0, '0.00', 'admin', '2015-10-15 19:51:11', 'admin', '2016-09-28 13:23:53');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010409', 'Vehicle A/C', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'Zoherul', '2016-05-12 12:13:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010405', 'Voltage Stablizer', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-03-27 10:40:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102030101', 'Walking Customer-P3NY6D1AKZQPHB7', 'Customer Receivable', 4, 1, 1, 0, 'A', 0, 0, '0.00', '1', '2019-05-20 06:55:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020405', 'WASA Bill', 'Utility Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2015-10-15 18:58:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010402', 'Water Purifier', 'Others Assets', 3, 1, 1, 0, 'A', 0, 0, '0.00', 'admin', '2016-01-29 11:14:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020705', 'Website Development Expenses', 'Miscellaneous Expenses', 3, 1, 1, 0, 'E', 0, 0, '0.00', 'admin', '2016-10-15 12:42:47', '', '2019-08-10 11:01:12');


#
# TABLE STRUCTURE FOR: acc_transaction
#

DROP TABLE IF EXISTS `acc_transaction`;

CREATE TABLE `acc_transaction` (
  `ID` int(11) NOT NULL,
  `VNo` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Vtype` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `VDate` date DEFAULT NULL,
  `COAID` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `Narration` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `Debit` decimal(18,2) DEFAULT NULL,
  `Credit` decimal(18,2) DEFAULT NULL,
  `IsPosted` char(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CreateBy` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CreateDate` datetime DEFAULT NULL,
  `UpdateBy` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `UpdateDate` datetime DEFAULT NULL,
  `IsAppove` char(10) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (1, '20220223233214', 'Purchase', '2022-02-23', '10107', 'Inventory Debit For Purchase No20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (2, '20220223233214', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233214', '0.00', '80.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (3, '20220223233214', 'Purchase', '2022-02-23', '402', 'Company Credit For Purchase No20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (4, '20220223233214', 'Purchase', '2022-02-23', '1020101', 'Cash in Hand For Purchase No20220223233214', '0.00', '80.00', '1', '1', '2022-02-23 23:32:14', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (5, '20220223233214', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233214', '80.00', '0.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (6, '20220223233301', 'Purchase', '2022-02-23', '10107', 'Inventory Debit For Purchase No20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (7, '20220223233301', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233301', '0.00', '132.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (8, '20220223233301', 'Purchase', '2022-02-23', '402', 'Company Credit For Purchase No20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (9, '20220223233301', 'Purchase', '2022-02-23', '1020101', 'Cash in Hand For Purchase No20220223233301', '0.00', '132.00', '1', '1', '2022-02-23 23:33:01', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (10, '20220223233301', 'Purchase', '2022-02-23', '5020200001', 'Purchase No.20220223233301', '132.00', '0.00', '1', '1', '2022-02-23 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (11, '9259592329', 'INVOICE', '2022-02-23', '10107', 'Inventory credit For Invoice No9259592329', '0.00', '8.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (12, '9259592329', 'INVOICE', '2022-02-23', '102030101', 'Customer debit For Invoice No9259592329', '6.00', '0.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (13, '9259592329', 'INVOICE', '2022-02-23', '304', 'Customer debit For Invoice No9259592329', '0.00', '6.00', '1', '1', '2022-02-23 23:33:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (14, '1877899635', 'INVOICE', '2022-02-23', '10107', 'Inventory credit For Invoice No1877899635', '0.00', '4.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (15, '1877899635', 'INVOICE', '2022-02-23', '102030101', 'Customer debit For Invoice No1877899635', '3.00', '0.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES (16, '1877899635', 'INVOICE', '2022-02-23', '304', 'Customer debit For Invoice No1877899635', '0.00', '3.00', '1', '1', '2022-02-23 23:41:54', NULL, NULL, '1');


#
# TABLE STRUCTURE FOR: accesslog
#

DROP TABLE IF EXISTS `accesslog`;

CREATE TABLE `accesslog` (
  `sl_no` bigint(20) NOT NULL,
  `action_page` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action_done` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `user_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_date` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: account_2
#

DROP TABLE IF EXISTS `account_2`;

CREATE TABLE `account_2` (
  `account_id` int(11) NOT NULL,
  `account_name` varchar(40) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `parent_id` int(1) NOT NULL,
  `status` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `account_id` varchar(20) NOT NULL,
  `account_table_name` varchar(255) NOT NULL,
  `account_name` varchar(255) NOT NULL,
  `status` int(5) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) DEFAULT NULL,
  `tax_percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  CONSTRAINT `ambulance_call_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_2` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_4` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (5, 'Low', '2021-09-24 19:28:40');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `time` time DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int(11) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `is_queue` int(11) DEFAULT NULL,
  `live_consult` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  KEY `case_reference_id` (`case_reference_id`),
  CONSTRAINT `appointment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_2` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=392 DEFAULT CHARSET=utf8;

INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (1, 99, 1586, 1366, '2022-07-15 23:24:00', NULL, '1', '', 58, '', 'test', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-07-15 23:24:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (2, 100, 1587, 1367, '2022-07-15 23:26:00', NULL, '1', '', 60, '', 'test2', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-07-15 23:27:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (3, 100, 1640, 1413, '2022-07-18 20:34:00', NULL, '1', '', 60, '', 'Test', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-07-18 20:34:19');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (10, 4683, 1881, 1615, '2022-08-01 11:24:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-01 11:25:33');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (11, 5408, 1882, 1616, '2022-08-01 11:54:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-01 11:54:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (12, 5412, 1883, 1617, '2022-08-01 12:41:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-01 12:42:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (13, 5413, 1884, 1618, '2022-08-01 12:51:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-01 12:51:34');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (14, 5415, 1885, 1619, '2022-08-01 13:33:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-01 13:33:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (15, 5421, 1887, 1620, '2022-08-01 15:03:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-01 15:04:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (17, 2267, 1891, 1622, '2022-08-01 18:20:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-01 18:21:39');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (18, 5445, 1893, 1624, '2022-08-02 09:27:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 09:27:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (19, 5447, 1895, 1626, '2022-08-02 09:33:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 09:33:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (20, 1395, 1896, 1627, '2022-08-02 10:47:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 10:48:26');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (21, 5451, 1897, 1628, '2022-08-02 10:56:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 10:55:49');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (22, 5459, 1898, 1629, '2022-08-02 12:43:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 12:43:15');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (23, 5461, 1899, 1630, '2022-08-02 12:53:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 12:53:10');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (24, 5464, 1900, 1631, '2022-08-02 15:53:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 15:54:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (25, 1500, 1901, 1632, '2022-08-02 16:56:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 16:55:54');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (26, 5467, 1902, 1633, '2022-08-02 17:17:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 17:16:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (27, 5468, 1903, 1634, '2022-08-02 17:20:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 17:20:38');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (28, 5470, 1905, 1635, '2022-08-02 18:24:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-02 18:24:00');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (29, 5482, 1910, 1640, '2022-08-03 09:52:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-03 09:52:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (30, 5489, 1912, 1642, '2022-08-03 12:12:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-03 12:13:33');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (31, 5492, 1913, 1643, '2022-08-03 12:51:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-03 12:52:12');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (32, 5515, 1921, 1651, '2022-08-04 10:19:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-04 10:20:12');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (33, 5516, 1922, 1652, '2022-08-04 11:07:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-04 11:09:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (34, 5526, 1924, 1654, '2022-08-04 14:09:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-04 14:09:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (35, 5529, 1925, 1655, '2022-08-04 16:13:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-04 16:12:46');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (36, 5603, 1932, 1658, '2022-08-05 10:21:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-05 10:22:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (37, 2299, 1933, 1659, '2022-08-05 15:55:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-05 16:01:06');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (38, 5667, 1936, 1661, '2022-08-05 18:08:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-05 18:08:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (39, 5678, 1937, 1662, '2022-08-05 19:59:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-05 20:00:35');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (40, 5701, 1943, 1668, '2022-08-06 11:55:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-06 11:56:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (41, 5705, 1944, 1669, '2022-08-06 12:22:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-06 12:24:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (42, 5707, 1946, 1671, '2022-08-06 13:57:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-06 13:57:50');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (43, 5710, 1948, 1673, '2022-08-06 18:37:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-06 18:38:50');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (44, 5013, 1950, 1675, '2022-08-07 21:04:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-07 21:06:01');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (45, 5761, 1954, 1679, '2022-08-08 09:16:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 09:16:49');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (46, 5762, 1956, 1681, '2022-08-08 09:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 09:36:17');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (47, 5765, 1958, 1682, '2022-08-08 10:30:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 10:31:36');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (48, 5769, 1959, 1683, '2022-08-08 11:29:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 11:29:25');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (49, 5770, 1960, 1684, '2022-08-08 11:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 11:36:54');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (50, 5773, 1962, 1686, '2022-08-08 12:11:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 12:12:13');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (51, 5774, 1963, 1687, '2022-08-08 12:48:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 12:48:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (52, 5785, 1965, 1689, '2022-08-08 17:24:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 17:25:13');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (53, 4273, 1966, 1690, '2022-08-08 18:34:00', NULL, '1', '', 62, '', '2nd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 18:34:28');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (54, 5795, 1967, 1691, '2022-08-08 19:10:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 19:11:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (55, 2013, 1970, 1694, '2022-08-08 19:16:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 19:17:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (56, 5799, 1971, 1695, '2022-08-08 19:35:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-08 19:35:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (57, 5805, 1974, 1698, '2022-08-09 09:12:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 09:13:13');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (58, 5808, 1975, 1699, '2022-08-09 10:33:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 10:33:31');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (59, 2013, 1976, 1700, '2022-08-09 10:35:00', NULL, '1', '', 62, '', '3r Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 10:36:13');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (60, 5809, 1977, 1701, '2022-08-09 10:39:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 10:41:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (61, 5013, 1978, 1702, '2022-08-09 10:52:00', NULL, '1', '', 46, '', '2nd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 10:53:02');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (62, 5814, 1979, 1703, '2022-08-09 10:55:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 10:56:53');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (63, 5822, 1981, 1705, '2022-08-09 11:40:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 11:41:37');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (65, 5827, 1983, 1707, '2022-08-09 13:35:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 13:36:36');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (66, 5829, 1984, 1708, '2022-08-09 17:18:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 17:21:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (67, 5002, 1985, 1709, '2022-08-09 17:43:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 17:45:49');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (68, 5830, 1986, 1710, '2022-08-09 18:01:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 18:02:20');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (69, 5834, 1987, 1711, '2022-08-09 18:30:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-09 18:31:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (70, 5480, 1990, 1712, '2022-08-10 11:24:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 11:26:05');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (71, 5174, 1991, 1713, '2022-08-10 12:48:00', NULL, '1', '', 62, '', '3rd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 12:49:47');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (72, 5864, 1993, 1714, '2022-08-10 13:31:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 13:31:30');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (73, 5480, 1994, 1715, '2022-08-10 17:39:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 17:42:56');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (74, 5873, 1995, 1716, '2022-08-10 17:58:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 17:58:25');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (75, 5874, 1996, 1717, '2022-08-10 18:01:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 18:02:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (76, 5875, 1997, 1718, '2022-08-10 18:09:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 18:11:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (77, 5876, 1999, 1720, '2022-08-10 18:27:00', NULL, '1', '', 62, '', '3rd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 18:27:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (78, 5871, 2000, 1721, '2022-08-10 18:34:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 18:35:13');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (79, 4757, 2003, 1722, '2022-08-10 19:24:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 19:26:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (80, 5880, 2005, 1724, '2022-08-10 19:30:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 19:32:18');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (81, 3748, 2007, 1725, '2022-08-10 20:01:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 20:02:21');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (82, 5883, 2009, 1727, '2022-08-10 21:01:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-10 21:01:52');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (83, 954, 2010, 1728, '2022-08-11 06:41:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-11 06:45:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (84, 5886, 2012, 1729, '2022-08-11 09:18:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-11 09:19:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (85, 5890, 2013, 1730, '2022-08-11 10:32:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-11 10:32:17');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (86, 4568, 2014, 1731, '2022-08-11 10:50:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-11 10:50:47');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (87, 5896, 2016, 1732, '2022-08-11 11:40:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-11 11:40:39');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (88, 5906, 2017, 1733, '2022-08-11 17:15:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-11 17:16:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (89, 5952, 2022, 1735, '2022-08-12 09:25:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-12 09:25:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (90, 3366, 2023, 1736, '2022-08-12 09:27:00', NULL, '1', '', 62, '', '2nd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-12 09:28:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (91, 5979, 2024, 1737, '2022-08-12 11:05:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-12 11:05:30');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (92, 2021, 2025, 1738, '2022-08-12 11:26:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-12 11:27:53');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (93, 4533, 2026, 1739, '2022-08-12 12:29:00', NULL, '1', '', 62, '', '3rd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-12 12:30:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (94, 3279, 2027, 1740, '2022-08-12 17:07:00', NULL, '1', '', 62, '', '2nd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-12 17:07:35');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (95, 6045, 2028, 1741, '2022-08-12 19:23:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-12 19:23:17');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (96, 6070, 2029, 1742, '2022-08-13 00:09:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 00:09:54');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (97, 5934, 2031, 1744, '2022-08-13 10:19:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 10:19:45');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (98, 6076, 2033, 1745, '2022-08-13 11:06:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 11:08:00');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (99, 6094, 2035, 1746, '2022-08-13 17:27:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 17:27:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (100, 6098, 2036, 1747, '2022-08-13 18:13:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 18:13:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (101, 6099, 2037, 1748, '2022-08-13 18:27:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 18:27:53');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (102, 5937, 2039, 1749, '2022-08-13 19:18:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 19:19:45');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (103, 6101, 2040, 1750, '2022-08-13 19:42:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 19:42:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (104, 1385, 2041, 1751, '2022-08-13 19:53:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 19:55:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (105, 6103, 2042, 1752, '2022-08-13 20:16:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 20:18:09');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (106, 6109, 2044, 1754, '2022-08-13 23:06:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-13 23:06:35');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (107, 6110, 2045, 1755, '2022-08-14 01:30:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-14 01:30:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (109, 6129, 2050, 1758, '2022-08-14 21:58:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-14 21:58:31');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (110, 6138, 2052, 1759, '2022-08-15 11:01:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-15 11:04:27');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (111, 6142, 2054, 1761, '2022-08-15 11:39:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-15 11:40:51');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (112, 4768, 2055, 1762, '2022-08-15 11:42:00', NULL, '1', '', 62, '', '2nd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-15 11:45:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (113, 6144, 2057, 1763, '2022-08-15 11:56:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-15 11:58:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (114, 6145, 2058, 1764, '2022-08-15 12:04:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-15 12:04:15');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (115, 6149, 2059, 1765, '2022-08-15 12:44:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-15 12:45:34');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (116, 6154, 2060, 1766, '2022-08-15 15:22:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-15 15:23:36');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (117, 6171, 2063, 1767, '2022-08-15 22:09:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-15 22:09:47');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (118, 6174, 2065, 1768, '2022-08-16 04:17:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 04:17:20');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (119, 6185, 2067, 1770, '2022-08-16 10:13:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 10:14:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (120, 6190, 2069, 1771, '2022-08-16 11:00:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 11:01:56');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (121, 5308, 2072, 1774, '2022-08-16 11:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 11:09:49');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (122, 5421, 2073, 1775, '2022-08-16 11:15:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 11:17:28');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (123, 6191, 2074, 1776, '2022-08-16 11:27:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 11:29:10');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (124, 5111, 2076, 1777, '2022-08-16 11:39:00', NULL, '1', '', 62, '', '3rd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 11:39:54');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (125, 6204, 2080, 1780, '2022-08-16 16:23:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 16:23:50');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (126, 2497, 2081, 1781, '2022-08-16 17:39:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 17:39:47');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (127, 6210, 2082, 1782, '2022-08-16 18:16:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 18:16:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (128, 6212, 2083, 1783, '2022-08-16 18:27:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 18:28:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (129, 6214, 2084, 1784, '2022-08-16 19:32:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 19:34:25');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (130, 6217, 2087, 1787, '2022-08-16 19:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-16 19:38:08');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (131, 6234, 2090, 1790, '2022-08-17 09:27:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 09:29:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (132, 6235, 2091, 1791, '2022-08-17 09:46:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 09:46:33');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (133, 6236, 2094, 1794, '2022-08-17 10:01:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 10:01:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (134, 2567, 2095, 1795, '2022-08-17 10:22:00', NULL, '1', '', 62, '', '3rd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 10:22:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (135, 6241, 2096, 1796, '2022-08-17 11:08:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 11:10:04');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (136, 6243, 2097, 1797, '2022-08-17 11:20:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 11:20:19');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (137, 6250, 2098, 1798, '2022-08-17 12:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 12:07:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (138, 6252, 2099, 1799, '2022-08-17 12:48:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 12:48:01');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (139, 6264, 2102, 1801, '2022-08-17 18:13:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 18:13:20');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (140, 6265, 2103, 1802, '2022-08-17 18:14:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 18:14:17');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (141, 6268, 2104, 1803, '2022-08-17 18:23:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 18:23:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (142, 6269, 2106, 1804, '2022-08-17 18:44:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 18:44:51');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (143, 6272, 2107, 1805, '2022-08-17 20:12:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 20:12:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (144, 6276, 2109, 1807, '2022-08-17 23:25:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-17 23:25:10');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (145, 6276, 2111, 1809, '2022-08-18 08:49:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 08:49:20');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (146, 6281, 2112, 1810, '2022-08-18 09:28:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 09:28:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (147, 6282, 2113, 1811, '2022-08-18 09:59:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 09:59:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (148, 4879, 2115, 1813, '2022-08-18 10:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 10:37:34');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (149, 3845, 2116, 1814, '2022-08-18 10:44:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 10:44:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (150, 6286, 2117, 1815, '2022-08-18 10:59:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 10:59:15');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (151, 6287, 2118, 1816, '2022-08-18 11:46:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 11:46:45');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (152, 6289, 2119, 1817, '2022-08-18 11:51:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 11:52:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (153, 6290, 2120, 1818, '2022-08-18 11:55:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 11:55:46');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (154, 6295, 2121, 1819, '2022-08-18 12:19:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 12:20:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (155, 6297, 2122, 1820, '2022-08-18 12:27:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 12:27:46');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (156, 6298, 2123, 1821, '2022-08-18 12:37:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 12:37:02');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (157, 6302, 2124, 1822, '2022-08-18 13:03:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 13:05:06');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (158, 6314, 2125, 1823, '2022-08-18 17:48:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 17:47:43');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (159, 6318, 2126, 1824, '2022-08-18 18:26:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 18:26:24');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (160, 6321, 2127, 1825, '2022-08-18 18:53:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 18:54:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (161, 2413, 2129, 1826, '2022-08-18 19:59:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-18 19:58:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (162, 4627, 2133, 1827, '2022-08-19 13:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 13:06:39');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (163, 6417, 2138, 1828, '2022-08-19 16:58:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 16:57:55');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (164, 6418, 2139, 1829, '2022-08-19 17:01:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 17:02:15');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (165, 6420, 2140, 1830, '2022-08-19 17:05:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 17:05:21');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (166, 6422, 2142, 1832, '2022-08-19 17:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 17:08:21');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (167, 6423, 2143, 1833, '2022-08-19 17:08:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 17:08:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (168, 6424, 2144, 1834, '2022-08-19 17:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 17:37:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (169, 6429, 2145, 1835, '2022-08-19 18:12:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 18:13:54');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (170, 6431, 2146, 1836, '2022-08-19 18:30:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 18:29:54');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (171, 6433, 2147, 1837, '2022-08-19 18:44:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 18:44:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (172, 6447, 2148, 1838, '2022-08-19 22:17:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-19 22:17:50');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (173, 6448, 2150, 1839, '2022-08-20 00:34:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 00:34:26');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (174, 6449, 2151, 1840, '2022-08-20 01:50:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 01:50:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (175, 4568, 2153, 1842, '2022-08-20 10:05:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 10:05:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (176, 5979, 2154, 1843, '2022-08-20 10:56:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 10:56:02');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (177, 3002, 2157, 1846, '2022-08-20 11:17:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 11:18:52');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (178, 4224, 2159, 1847, '2022-08-20 12:14:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 12:16:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (179, 6475, 2160, 1848, '2022-08-20 17:29:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 17:31:17');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (180, 6479, 2161, 1849, '2022-08-20 18:33:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 18:34:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (181, 6481, 2162, 1850, '2022-08-20 18:39:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 18:40:55');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (182, 6484, 2163, 1851, '2022-08-20 19:11:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 19:12:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (183, 6487, 2165, 1853, '2022-08-20 20:11:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-20 20:12:56');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (184, 5499, 2167, 1855, '2022-08-21 11:02:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-21 11:04:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (185, 6495, 2168, 1856, '2022-08-21 11:04:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-21 11:06:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (186, 6498, 2169, 1857, '2022-08-21 11:48:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-21 11:49:39');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (187, 6514, 2171, 1859, '2022-08-21 19:22:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-21 19:23:25');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (188, 6516, 2173, 1861, '2022-08-21 22:38:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-21 22:38:28');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (189, 6519, 2174, 1862, '2022-08-22 09:37:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-22 09:38:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (190, 6529, 2175, 1863, '2022-08-22 11:48:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-22 11:48:00');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (191, 6542, 2176, 1864, '2022-08-22 17:52:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-22 17:54:12');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (192, 1840, 2177, 1865, '2022-08-22 18:10:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-22 18:10:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (193, 6547, 2179, 1867, '2022-08-22 19:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-22 19:08:48');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (194, 2262, 2180, 1868, '2022-08-23 10:10:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 10:12:43');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (195, 6557, 2181, 1869, '2022-08-23 10:47:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 10:48:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (196, 6561, 2182, 1870, '2022-08-23 11:40:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 11:41:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (197, 6563, 2183, 1871, '2022-08-23 11:42:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 11:44:52');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (198, 4311, 2184, 1872, '2022-08-23 11:57:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 11:58:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (199, 741, 2185, 1873, '2022-08-23 12:12:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 12:13:01');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (200, 3954, 2186, 1874, '2022-08-23 13:09:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 13:11:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (201, 6569, 2187, 1875, '2022-08-23 13:29:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 13:31:52');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (202, 6570, 2188, 1876, '2022-08-23 14:14:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 14:16:06');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (203, 6575, 2189, 1877, '2022-08-23 16:56:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 16:56:35');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (204, 4863, 2192, 1880, '2022-08-23 17:05:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 17:05:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (205, 6185, 2193, 1881, '2022-08-23 17:55:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 17:56:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (206, 6582, 2195, 1882, '2022-08-23 23:40:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-23 23:41:26');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (207, 6587, 2196, 1883, '2022-08-24 10:12:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-24 10:13:19');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (208, 6588, 2199, 1886, '2022-08-24 10:21:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-24 10:21:24');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (209, 6590, 2201, 1888, '2022-08-24 11:10:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-24 11:11:49');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (210, 6591, 2203, 1890, '2022-08-24 11:14:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-24 11:15:04');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (211, 6592, 2204, 1891, '2022-08-24 12:28:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-24 12:29:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (212, 6595, 2205, 1892, '2022-08-24 14:55:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-24 14:55:27');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (213, 6600, 2208, 1893, '2022-08-24 18:09:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-24 18:10:18');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (214, 6617, 2210, 1895, '2022-08-25 10:12:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 10:12:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (215, 6618, 2211, 1896, '2022-08-25 10:18:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 10:18:23');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (216, 6619, 2212, 1897, '2022-08-25 10:22:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 10:22:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (217, 6620, 2213, 1898, '2022-08-25 10:26:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 10:27:01');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (218, 6621, 2214, 1899, '2022-08-25 10:32:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 10:34:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (219, 6420, 2215, 1900, '2022-08-25 10:57:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 10:58:34');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (220, 6628, 2216, 1901, '2022-08-25 11:30:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 11:30:43');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (221, 6629, 2217, 1902, '2022-08-25 11:34:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 11:35:04');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (222, 6630, 2218, 1903, '2022-08-25 11:39:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 11:40:01');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (223, 4958, 2219, 1904, '2022-08-25 12:18:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 12:20:20');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (224, 6640, 2220, 1905, '2022-08-25 12:29:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 12:32:21');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (225, 5413, 2221, 1906, '2022-08-25 12:52:00', NULL, '1', '', 62, '', '2nd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 12:54:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (226, 6643, 2222, 1907, '2022-08-25 13:21:00', NULL, '1', '', 46, '', 'Less By DMD Mam', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 13:24:09');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (227, 6644, 2223, 1908, '2022-08-25 13:24:00', NULL, '1', '', 46, '', 'Less By DMD Mam', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 13:26:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (228, 6645, 2224, 1909, '2022-08-25 13:28:00', NULL, '1', '', 46, '', 'Less By DMD Mam', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 13:31:04');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (229, 6651, 2228, 1912, '2022-08-25 16:59:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 17:00:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (230, 6652, 2229, 1913, '2022-08-25 17:34:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 17:35:19');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (231, 6653, 2230, 1914, '2022-08-25 17:35:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 17:37:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (232, 6654, 2231, 1915, '2022-08-25 17:46:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 17:47:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (233, 5799, 2232, 1916, '2022-08-25 17:57:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 17:57:52');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (234, 4533, 2233, 1917, '2022-08-25 17:56:00', NULL, '1', '', 62, '', '2nd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 18:00:20');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (235, 6664, 2234, 1918, '2022-08-25 18:35:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-25 18:37:36');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (236, 6709, 2237, 1919, '2022-08-26 10:24:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 10:25:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (237, 6712, 2238, 1920, '2022-08-26 10:34:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 10:35:19');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (238, 6714, 2239, 1921, '2022-08-26 10:37:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 10:39:24');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (239, 6715, 2240, 1922, '2022-08-26 10:41:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 10:43:46');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (240, 6718, 2241, 1923, '2022-08-26 10:47:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 10:47:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (241, 6741, 2243, 1924, '2022-08-26 11:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 11:37:36');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (242, 6755, 2244, 1925, '2022-08-26 12:03:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 12:04:07');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (243, 4224, 2245, 1926, '2022-08-26 12:37:00', NULL, '1', '', 62, '', '2nd Visit', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 12:39:28');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (244, 1603, 2246, 1927, '2022-08-26 17:11:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 17:11:47');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (245, 6799, 2247, 1928, '2022-08-26 17:29:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 17:31:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (246, 6803, 2248, 1929, '2022-08-26 18:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 18:10:22');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (247, 6816, 2249, 1930, '2022-08-26 20:20:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-26 20:20:42');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (248, 3616, 2251, 1931, '2022-08-27 11:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-27 11:08:09');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (249, 807, 2252, 1932, '2022-08-27 11:57:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-27 11:58:17');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (250, 3899, 2253, 1933, '2022-08-27 17:19:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-27 17:19:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (251, 6855, 2254, 1934, '2022-08-27 19:40:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-27 19:41:02');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (252, 6858, 2255, 1935, '2022-08-27 21:33:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-27 21:33:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (253, 6860, 2257, 1936, '2022-08-28 09:41:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-28 09:42:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (254, 6895, 2261, 1938, '2022-08-28 22:33:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-28 22:34:43');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (255, 6907, 2263, 1940, '2022-08-29 10:38:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-29 10:40:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (256, 6911, 2264, 1941, '2022-08-29 11:03:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-29 11:04:05');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (257, 6927, 2267, 1943, '2022-08-29 17:26:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-29 17:26:25');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (258, 6929, 2268, 1944, '2022-08-29 18:09:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-29 18:09:17');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (259, 6185, 2269, 1945, '2022-08-29 18:30:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-29 18:30:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (260, 6935, 2271, 1946, '2022-08-29 21:21:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-29 21:22:02');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (261, 6937, 2272, 1947, '2022-08-30 00:19:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 00:22:46');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (262, 6138, 2273, 1948, '2022-08-30 10:17:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 10:19:27');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (263, 6943, 2274, 1949, '2022-08-30 10:19:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 10:19:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (264, 6948, 2275, 1950, '2022-08-30 11:20:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 11:20:34');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (265, 6955, 2277, 1952, '2022-08-30 12:19:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 12:21:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (266, 6956, 2278, 1953, '2022-08-30 12:24:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 12:24:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (267, 6957, 2280, 1955, '2022-08-30 12:28:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 12:30:06');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (268, 6959, 2282, 1957, '2022-08-30 15:45:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 15:45:53');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (269, 6963, 2283, 1958, '2022-08-30 17:00:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 17:01:02');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (270, 4871, 2284, 1959, '2022-08-30 17:32:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 17:35:28');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (271, 6968, 2285, 1960, '2022-08-30 18:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 18:09:46');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (272, 6974, 2286, 1961, '2022-08-30 19:06:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-30 19:06:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (273, 6989, 2287, 1962, '2022-08-31 10:33:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-31 10:36:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (274, 6998, 2288, 1963, '2022-08-31 12:35:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-31 12:38:00');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (275, 7000, 2289, 1964, '2022-08-31 14:37:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-08-31 14:40:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (276, 536, 2291, 1966, '2022-09-01 10:35:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-01 10:37:36');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (277, 4483, 2293, 1967, '2022-09-01 13:41:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-01 13:44:33');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (278, 7043, 2297, 1968, '2022-09-01 18:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-01 18:36:20');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (279, 7050, 2299, 1969, '2022-09-01 19:15:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-01 19:20:39');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (280, 7051, 2300, 1970, '2022-09-01 19:19:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-01 19:21:49');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (281, 7058, 2303, 1973, '2022-09-01 20:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-01 20:36:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (282, 7075, 2304, 1974, '2022-09-02 09:57:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-02 09:57:47');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (283, 6185, 2306, 1975, '2022-09-02 17:25:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-02 17:27:10');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (284, 7143, 2307, 1976, '2022-09-02 17:34:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-02 17:34:51');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (285, 7156, 2308, 1977, '2022-09-02 20:05:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-02 20:07:49');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (286, 6640, 2310, 1978, '2022-09-03 10:15:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-03 10:17:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (287, 7173, 2311, 1979, '2022-09-03 11:04:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-03 11:06:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (288, 7175, 2312, 1980, '2022-09-03 11:24:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-03 11:25:06');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (289, 6343, 2313, 1981, '2022-09-03 12:16:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-03 12:16:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (290, 7183, 2314, 1982, '2022-09-03 16:04:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-03 16:03:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (291, 7185, 2315, 1983, '2022-09-03 17:14:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-03 17:14:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (292, 7192, 2316, 1984, '2022-10-03 20:26:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-03 20:26:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (293, 7295, 2317, 1985, '2022-09-04 21:16:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-04 21:16:54');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (294, 7297, 2319, 1986, '2022-09-05 00:38:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-05 00:37:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (295, 7296, 2320, 1987, '2022-09-05 01:18:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-05 01:19:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (296, 7299, 2322, 1988, '2022-09-05 06:57:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-05 06:57:34');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (297, 7301, 2324, 1990, '2022-09-05 10:38:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-05 10:40:36');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (298, 7305, 2325, 1991, '2022-09-05 11:35:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-05 11:37:27');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (299, 7306, 2326, 1992, '2022-09-05 11:48:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-05 11:50:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (300, 7318, 2328, 1993, '2022-09-05 18:03:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-05 18:05:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (301, 7325, 2329, 1994, '2022-09-06 08:55:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-06 09:00:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (302, 7327, 2330, 1995, '2022-09-06 09:17:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-06 09:20:26');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (303, 7328, 2331, 1996, '2022-09-06 09:19:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-06 09:27:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (304, 6268, 2333, 1998, '2022-09-06 11:43:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-06 11:43:52');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (305, 1500, 2334, 1999, '2022-09-06 12:01:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-06 12:04:37');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (306, 7338, 2335, 2000, '2022-09-06 12:09:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-06 12:12:27');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (307, 7342, 2336, 2001, '2022-09-06 16:49:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-06 16:49:31');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (308, 7346, 2337, 2002, '2022-09-06 17:10:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-06 17:11:12');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (309, 7351, 2340, 2003, '2022-09-07 04:26:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 04:28:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (310, 7356, 2341, 2004, '2022-09-07 09:34:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 09:35:10');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (311, 7357, 2343, 2006, '2022-09-07 09:39:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 09:40:06');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (312, 3562, 2344, 2007, '2022-09-07 10:36:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 10:36:43');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (313, 5979, 2345, 2008, '2022-09-07 11:29:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 11:30:35');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (314, 6568, 2346, 2009, '2022-09-07 12:21:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 12:22:31');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (315, 7375, 2347, 2010, '2022-09-07 14:03:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 14:03:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (316, 7375, 2348, 2011, '2022-09-07 14:35:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 14:35:39');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (317, 7379, 2349, 2012, '2022-09-07 18:56:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 18:57:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (318, 6987, 2351, 2014, '2022-09-07 19:01:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-07 19:02:09');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (319, 7388, 2354, 2015, '2022-09-08 08:12:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-08 08:13:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (320, 1924, 2357, 2016, '2022-09-08 11:30:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-08 11:33:10');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (321, 7404, 2358, 2017, '2022-09-08 11:49:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-08 11:52:13');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (322, 5231, 2360, 2018, '2022-09-08 12:14:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-08 12:17:12');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (323, 7399, 2361, 2019, '2022-09-08 13:54:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-08 13:57:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (324, 7414, 2362, 2020, '2022-09-08 16:50:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-08 16:53:41');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (325, 7428, 2364, 2021, '2022-09-08 18:33:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-08 18:34:25');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (326, 7430, 2365, 2022, '2022-09-08 19:13:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-08 19:13:48');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (327, 5158, 2367, 2023, '2022-09-09 10:47:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 10:50:30');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (328, 7480, 2368, 2024, '2022-09-09 11:13:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 11:14:36');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (329, 6264, 2369, 2025, '2022-09-09 11:13:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 11:15:59');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (330, 7483, 2370, 2026, '2022-09-09 11:16:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 11:19:28');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (331, 7510, 2372, 2028, '2022-09-09 13:31:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 13:32:25');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (332, 5359, 2373, 2029, '2022-09-09 13:44:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 13:45:33');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (333, 7517, 2374, 2030, '2022-09-09 16:56:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 16:58:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (334, 7518, 2376, 2032, '2022-09-09 17:00:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 17:02:53');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (335, 7527, 2380, 2034, '2022-09-09 19:13:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 19:16:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (336, 7530, 2381, 2035, '2022-09-09 19:33:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 19:37:32');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (337, 7540, 2383, 2036, '2022-09-09 22:47:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-09 22:47:37');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (338, 7542, 2385, 2038, '2022-09-10 09:42:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 09:43:40');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (339, 7543, 2386, 2039, '2022-09-10 10:04:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 10:08:00');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (340, 7544, 2387, 2040, '2022-09-10 10:12:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 10:15:10');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (341, 4975, 2389, 2041, '2022-09-10 12:11:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 12:12:05');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (342, 7569, 2390, 2042, '2022-09-10 12:43:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 12:44:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (343, 7572, 2391, 2043, '2022-09-10 13:26:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 13:29:10');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (344, 7576, 2393, 2044, '2022-09-10 16:28:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 16:28:29');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (345, 7580, 2394, 2045, '2022-09-10 17:57:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 18:00:50');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (346, 7584, 2395, 2046, '2022-09-10 18:39:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 18:40:02');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (347, 6287, 2396, 2047, '2022-09-10 19:11:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 19:14:15');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (348, 7586, 2397, 2048, '2022-09-10 19:42:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-10 19:43:12');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (349, 7603, 2399, 2050, '2022-09-11 12:05:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-11 12:09:05');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (350, 7616, 2400, 2051, '2022-09-11 17:35:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-11 17:39:26');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (351, 7617, 2401, 2052, '2022-09-11 18:14:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-11 18:17:05');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (352, 7619, 2402, 2053, '2022-09-11 23:35:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-11 23:35:33');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (353, 7620, 2403, 2054, '2022-09-12 04:14:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-12 04:14:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (354, 7621, 2405, 2056, '2022-09-12 10:09:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-12 10:09:56');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (355, 7624, 2406, 2057, '2022-09-12 11:35:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-12 11:36:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (356, 7630, 2408, 2058, '2022-09-12 16:37:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-12 16:38:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (357, 7638, 2409, 2059, '2022-09-12 22:07:00', NULL, '1', '', 78, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-12 22:09:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (358, 7650, 2414, 2064, '2022-09-13 11:52:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-13 11:57:12');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (359, 7640, 2415, 2065, '2022-09-13 12:04:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-13 12:07:03');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (360, 7659, 2416, 2066, '2022-09-13 19:41:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-13 19:44:28');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (361, 7660, 2418, 2067, '2022-09-13 22:25:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-13 22:26:11');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (362, 7661, 2419, 2068, '2022-09-13 23:21:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-13 23:21:50');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (363, 5174, 2420, 2069, '2022-09-14 17:22:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-14 17:23:47');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (364, 7685, 2421, 2070, '2022-09-15 10:37:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 10:37:27');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (365, 7687, 2422, 2071, '2022-09-15 10:55:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 10:58:01');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (366, 7694, 2423, 2072, '2022-09-15 13:05:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 13:07:58');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (367, 7705, 2427, 2074, '2022-09-15 17:11:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 17:11:39');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (368, 4958, 2428, 2075, '2022-09-15 17:15:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 17:18:06');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (369, 7709, 2429, 2076, '2022-09-15 17:54:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 17:57:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (370, 7710, 2430, 2077, '2022-09-15 18:09:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 18:09:52');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (371, 7711, 2431, 2078, '2022-09-15 18:07:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 18:09:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (372, 6484, 2434, 2079, '2022-09-15 18:39:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 18:39:43');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (373, 3642, 2435, 2080, '2022-09-15 18:56:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 18:59:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (374, 6929, 2436, 2081, '2022-09-15 19:14:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-15 19:14:47');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (375, 7740, 2439, 2082, '2022-09-16 00:59:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 00:59:01');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (376, 7741, 2440, 2083, '2022-09-16 02:15:00', NULL, '1', '', 72, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 02:15:04');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (377, 6243, 2441, 2084, '2022-09-16 09:01:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 09:01:50');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (378, 7746, 2442, 2085, '2022-09-16 10:16:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 10:17:08');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (379, 7748, 2443, 2086, '2022-09-16 10:19:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 10:19:22');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (380, 7751, 2444, 2087, '2022-09-16 10:26:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 10:26:21');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (381, 7753, 2445, 2088, '2022-09-16 10:33:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 10:34:14');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (382, 7807, 2449, 2089, '2022-09-16 17:18:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 17:18:55');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (383, 1691, 2450, 2090, '2022-09-16 17:23:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 17:23:31');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (384, 7809, 2451, 2091, '2022-09-16 17:34:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 17:34:26');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (385, 7821, 2453, 2092, '2022-09-16 20:18:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 20:20:30');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (386, 7822, 2454, 2093, '2022-09-16 20:21:00', NULL, '1', '', 46, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-16 20:21:16');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (387, 7342, 2456, 2094, '2022-09-17 09:51:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-17 09:54:06');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (388, 7839, 2458, 2095, '2022-09-17 11:09:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-17 11:09:44');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (389, 7840, 2459, 2096, '2022-09-17 11:12:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-17 11:16:28');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (390, 7862, 2461, 2097, '2022-09-17 17:16:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-17 17:16:24');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (391, 7866, 2462, 2098, '2022-09-17 18:31:00', NULL, '1', '', 62, '', '', 'approved', 'Offline', '', '', 0, 0, 0, 'no', '2022-09-17 18:31:39');


#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `note` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `appointment_id` (`appointment_id`),
  CONSTRAINT `appointment_payment_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_payment_ibfk_3` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=418 DEFAULT CHARSET=utf8;

INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (10, 10, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-01 11:25:33');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (11, 11, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-01 11:54:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (12, 12, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-01 12:42:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (13, 13, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-01 12:51:34');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (14, 14, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-01 13:33:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (15, 15, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-01 15:04:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (17, 17, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-01 18:21:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (18, 18, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-02 09:27:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (20, 19, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-02 09:33:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (21, 20, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-02 10:48:26');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (22, 21, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-02 10:55:49');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (23, 22, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-02 12:43:15');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (24, 23, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-02 12:53:10');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (25, 24, 857, '200.00', NULL, 'Offline', NULL, NULL, '2022-08-02 15:54:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (26, 25, 857, '200.00', NULL, 'Offline', NULL, NULL, '2022-08-02 16:55:54');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (27, 26, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-02 17:16:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (28, 27, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-02 17:20:38');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (29, 28, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-02 18:24:00');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (30, 29, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-03 09:52:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (31, 30, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-03 12:13:33');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (32, 31, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-03 12:52:12');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (33, 32, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-04 10:20:12');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (34, 33, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-04 11:09:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (35, 34, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-04 14:09:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (36, 35, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-04 16:12:46');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (37, 36, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-05 10:22:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (38, 37, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-05 16:01:06');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (39, 38, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-05 18:08:58');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (40, 39, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-05 20:00:35');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (41, 40, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-06 11:56:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (42, 41, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-06 12:24:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (43, 42, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-06 13:57:50');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (44, 43, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-06 18:38:50');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (45, 44, 857, '200.00', NULL, 'Offline', NULL, NULL, '2022-08-07 21:06:01');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (46, 45, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-08 09:16:49');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (48, 46, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-08 09:36:17');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (49, 47, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-08 10:31:36');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (50, 48, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-08 11:29:25');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (51, 49, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-08 11:36:54');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (52, 50, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-08 12:12:13');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (53, 51, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-08 12:48:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (54, 52, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-08 17:25:13');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (55, 53, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-08 18:34:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (56, 54, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-08 19:11:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (59, 55, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-08 19:17:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (60, 56, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-08 19:35:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (62, 57, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-09 09:13:13');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (63, 58, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-09 10:33:31');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (64, 59, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-09 10:36:13');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (65, 60, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-09 10:41:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (66, 61, 857, '200.00', NULL, 'Offline', NULL, NULL, '2022-08-09 10:53:02');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (67, 62, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-09 10:56:53');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (68, 63, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-09 11:41:37');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (70, 65, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-09 13:36:36');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (71, 66, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-09 17:21:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (72, 67, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-09 17:45:49');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (73, 68, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-09 18:02:20');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (74, 69, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-09 18:31:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (75, 70, 860, '200.00', NULL, 'Offline', NULL, NULL, '2022-08-10 11:26:05');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (76, 71, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-10 12:49:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (77, 72, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-10 13:31:30');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (78, 73, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-10 17:42:56');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (79, 74, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-10 17:58:25');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (80, 75, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-10 18:02:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (81, 76, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-10 18:11:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (83, 77, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-10 18:27:29');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (84, 78, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-10 18:35:13');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (85, 79, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-10 19:26:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (87, 80, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-10 19:32:18');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (88, 81, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-10 20:02:21');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (90, 82, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-10 21:01:52');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (91, 83, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-11 06:45:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (92, 84, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-11 09:19:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (93, 85, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-11 10:32:17');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (94, 86, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-11 10:50:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (95, 87, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-11 11:40:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (96, 88, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-11 17:16:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (97, 89, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-12 09:25:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (98, 90, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-12 09:28:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (99, 91, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-12 11:05:30');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (100, 92, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-12 11:27:53');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (101, 93, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-12 12:30:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (102, 94, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-12 17:07:35');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (103, 95, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-12 19:23:17');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (104, 96, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-13 00:09:54');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (105, 97, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-13 10:19:45');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (106, 98, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-13 11:08:00');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (107, 99, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-13 17:27:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (108, 100, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-13 18:13:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (109, 101, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-13 18:27:53');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (110, 102, 860, '200.00', NULL, 'Offline', NULL, NULL, '2022-08-13 19:19:45');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (111, 103, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-13 19:42:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (112, 104, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-13 19:55:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (113, 105, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-13 20:18:09');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (114, 106, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-13 23:06:35');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (115, 107, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-14 01:30:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (117, 109, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-14 21:58:31');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (118, 110, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-15 11:04:27');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (119, 111, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-15 11:40:51');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (120, 112, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-15 11:45:58');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (121, 113, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-15 11:58:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (122, 114, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-15 12:04:15');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (123, 115, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-15 12:45:34');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (124, 116, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-15 15:23:36');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (125, 117, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-15 22:09:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (126, 118, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-16 04:17:20');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (127, 119, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 10:14:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (128, 120, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-16 11:01:56');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (129, 121, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-16 11:09:49');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (130, 122, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 11:17:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (131, 123, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 11:29:10');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (132, 124, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-16 11:39:54');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (133, 125, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 16:23:50');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (134, 126, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 17:39:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (135, 127, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 18:16:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (136, 128, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 18:28:58');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (137, 129, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 19:34:25');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (140, 130, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-16 19:38:08');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (141, 131, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-17 09:29:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (142, 132, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-17 09:46:33');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (145, 133, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-17 10:01:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (146, 134, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-17 10:22:58');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (147, 135, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-17 11:10:04');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (148, 136, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-17 11:20:19');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (149, 137, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-17 12:07:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (150, 138, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-17 12:48:01');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (151, 139, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-17 18:13:20');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (152, 140, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-17 18:14:17');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (153, 141, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-17 18:23:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (154, 142, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-17 18:44:51');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (155, 143, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-17 20:12:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (156, 144, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-17 23:25:10');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (157, 145, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-18 08:49:20');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (158, 146, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-18 09:28:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (159, 147, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-18 09:59:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (160, 148, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-18 10:37:34');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (161, 149, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-18 10:44:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (162, 150, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-18 10:59:15');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (163, 151, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-18 11:46:45');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (164, 152, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-18 11:52:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (165, 153, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-18 11:55:46');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (166, 154, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-18 12:20:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (167, 155, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-18 12:27:46');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (168, 156, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-18 12:37:02');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (169, 157, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-18 13:05:06');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (170, 158, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-18 17:47:43');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (171, 159, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-18 18:26:24');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (172, 160, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-18 18:54:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (173, 161, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-18 19:58:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (174, 162, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-19 13:06:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (175, 163, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-19 16:57:55');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (176, 164, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-19 17:02:15');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (177, 165, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-19 17:05:21');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (179, 166, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-19 17:08:21');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (180, 167, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-19 17:08:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (181, 168, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-19 17:37:58');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (182, 169, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-19 18:13:54');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (183, 170, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-19 18:29:54');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (184, 171, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-19 18:44:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (185, 172, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-19 22:17:50');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (186, 173, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-20 00:34:26');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (187, 174, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-20 01:50:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (188, 175, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-20 10:05:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (189, 176, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-20 10:56:02');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (190, 177, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-20 11:18:52');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (191, 178, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-20 12:16:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (192, 179, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-20 17:31:17');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (193, 180, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-20 18:34:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (194, 181, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-20 18:40:55');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (195, 182, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-20 19:12:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (196, 183, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-20 20:12:56');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (197, 184, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-21 11:04:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (198, 185, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-21 11:06:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (199, 186, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-21 11:49:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (200, 187, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-21 19:23:25');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (201, 188, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-21 22:38:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (202, 189, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-22 09:38:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (203, 190, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-22 11:48:00');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (204, 191, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-22 17:54:12');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (205, 192, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-22 18:10:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (206, 193, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-22 19:08:48');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (207, 194, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-23 10:12:43');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (208, 195, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-23 10:48:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (209, 196, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-23 11:41:58');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (210, 197, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-23 11:44:52');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (211, 198, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-23 11:58:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (212, 199, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-23 12:13:01');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (213, 200, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-23 13:11:29');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (214, 201, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-23 13:31:52');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (215, 202, 859, '200.00', NULL, 'Offline', NULL, NULL, '2022-08-23 14:16:06');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (216, 203, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-23 16:56:35');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (219, 204, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-23 17:05:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (220, 205, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-23 17:56:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (221, 206, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-23 23:41:27');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (222, 207, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-24 10:13:19');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (225, 208, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-24 10:21:24');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (226, 209, 857, '200.00', NULL, 'Offline', NULL, NULL, '2022-08-24 11:11:49');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (228, 210, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-24 11:15:04');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (229, 211, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-24 12:29:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (230, 212, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-24 14:55:27');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (231, 213, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-24 18:10:18');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (232, 214, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 10:12:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (233, 215, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 10:18:23');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (234, 216, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 10:22:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (235, 217, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 10:27:01');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (236, 218, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-25 10:34:29');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (237, 219, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-25 10:58:34');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (238, 220, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 11:30:43');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (239, 221, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 11:35:04');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (240, 222, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 11:40:01');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (241, 223, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-25 12:20:20');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (242, 224, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-25 12:32:21');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (243, 225, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-25 12:54:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (244, 226, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 13:24:09');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (245, 227, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 13:26:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (246, 228, 857, '150.00', NULL, 'Offline', NULL, NULL, '2022-08-25 13:31:04');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (247, 229, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-25 17:00:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (248, 230, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-25 17:35:19');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (249, 231, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-25 17:37:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (250, 232, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-25 17:47:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (251, 233, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-25 17:57:52');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (252, 234, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-25 18:00:20');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (253, 235, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-25 18:37:36');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (254, 236, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-26 10:25:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (255, 237, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-26 10:35:19');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (256, 238, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-26 10:39:24');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (257, 239, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-26 10:43:46');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (258, 240, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-26 10:47:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (259, 241, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-26 11:37:36');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (260, 242, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-26 12:04:07');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (261, 243, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-26 12:39:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (262, 244, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-26 17:11:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (263, 245, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-26 17:31:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (264, 246, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-26 18:10:22');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (265, 247, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-26 20:20:42');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (266, 248, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-27 11:08:09');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (267, 249, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-27 11:58:17');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (268, 250, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-27 17:19:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (269, 251, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-27 19:41:02');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (270, 252, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-27 21:33:29');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (271, 253, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-28 09:42:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (272, 254, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-28 22:34:43');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (273, 255, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-29 10:40:58');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (274, 256, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-29 11:04:05');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (275, 257, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-29 17:26:25');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (276, 258, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-29 18:09:17');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (277, 259, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-29 18:30:29');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (278, 260, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-29 21:22:02');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (279, 261, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-30 00:22:46');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (280, 262, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-30 10:19:27');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (281, 263, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-30 10:19:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (282, 264, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-30 11:20:34');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (283, 265, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-30 12:21:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (284, 266, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-30 12:24:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (286, 267, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-30 12:30:06');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (287, 268, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-30 15:45:53');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (288, 269, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-30 17:01:02');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (289, 270, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-30 17:35:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (290, 271, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-08-30 18:09:46');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (291, 272, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-30 19:06:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (292, 273, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-08-31 10:36:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (293, 274, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-31 12:38:00');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (294, 275, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-08-31 14:40:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (296, 276, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-01 10:37:36');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (297, 277, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-01 13:44:33');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (298, 278, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-01 18:36:20');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (299, 279, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-01 19:20:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (300, 280, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-01 19:21:49');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (303, 281, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-01 20:36:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (304, 282, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-02 09:57:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (305, 283, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-02 17:27:10');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (306, 284, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-02 17:34:51');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (307, 285, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-02 20:07:49');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (308, 286, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-03 10:17:29');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (309, 287, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-03 11:06:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (310, 288, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-03 11:25:06');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (311, 289, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-03 12:16:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (312, 290, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-03 16:03:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (313, 291, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-03 17:14:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (314, 292, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-03 20:26:29');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (315, 293, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-04 21:16:54');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (316, 294, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-05 00:37:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (317, 295, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-05 01:19:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (318, 296, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-05 06:57:34');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (319, 297, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-05 10:40:36');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (320, 298, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-05 11:37:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (321, 299, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-05 11:50:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (322, 300, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-05 18:05:58');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (323, 301, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-06 09:00:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (324, 302, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-06 09:20:26');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (325, 303, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-06 09:27:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (327, 304, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-06 11:43:52');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (328, 305, 857, '200.00', NULL, 'Offline', NULL, NULL, '2022-09-06 12:04:37');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (329, 306, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-06 12:12:27');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (330, 307, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-06 16:49:31');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (331, 308, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-06 17:11:12');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (332, 309, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-07 04:28:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (333, 310, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-07 09:35:10');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (335, 311, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-07 09:40:06');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (336, 312, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-07 10:36:43');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (337, 313, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-07 11:30:35');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (338, 314, 860, '200.00', NULL, 'Offline', NULL, NULL, '2022-09-07 12:22:31');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (339, 315, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-07 14:03:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (340, 316, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-07 14:35:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (341, 317, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-07 18:57:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (343, 318, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-07 19:02:09');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (344, 319, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-08 08:13:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (345, 320, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-08 11:33:10');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (346, 321, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-08 11:52:13');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (347, 322, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-08 12:17:12');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (348, 323, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-08 13:57:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (349, 324, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-08 16:53:41');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (350, 325, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-08 18:34:25');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (351, 326, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-08 19:13:48');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (352, 327, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-09 10:50:30');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (353, 328, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-09 11:14:36');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (354, 329, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-09 11:15:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (355, 330, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-09 11:19:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (356, 331, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-09 13:32:25');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (357, 332, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-09 13:45:33');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (358, 333, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-09 16:58:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (360, 334, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-09 17:02:53');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (361, 335, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-09 19:16:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (362, 336, 859, '200.00', NULL, 'Offline', NULL, NULL, '2022-09-09 19:37:32');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (363, 337, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-09 22:47:37');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (364, 338, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-10 09:43:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (365, 339, 857, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-10 10:08:00');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (366, 340, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-10 10:15:10');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (367, 341, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-10 12:12:05');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (368, 342, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-10 12:44:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (369, 343, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-10 13:29:10');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (370, 344, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-10 16:28:29');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (371, 345, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-10 18:00:50');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (372, 346, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-10 18:40:02');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (373, 347, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-10 19:14:15');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (374, 348, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-10 19:43:12');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (375, 349, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-11 12:09:05');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (376, 350, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-11 17:39:26');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (377, 351, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-11 18:17:05');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (378, 352, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-11 23:35:33');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (379, 353, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-12 04:14:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (380, 354, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-12 10:09:56');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (381, 355, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-12 11:36:03');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (382, 356, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-12 16:38:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (383, 357, 860, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-12 22:09:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (384, 358, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-13 11:57:12');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (385, 359, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-13 12:07:04');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (386, 360, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-13 19:44:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (387, 361, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-13 22:26:11');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (388, 362, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-13 23:21:50');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (389, 363, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-14 17:23:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (390, 364, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-15 10:37:27');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (391, 365, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-15 10:58:01');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (392, 366, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-15 13:07:59');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (393, 367, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-15 17:11:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (394, 368, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-15 17:18:06');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (395, 369, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-15 17:57:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (396, 370, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-15 18:09:52');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (397, 371, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-15 18:09:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (398, 372, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-15 18:39:43');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (399, 373, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-15 18:59:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (400, 374, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-15 19:14:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (401, 375, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-16 00:59:01');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (402, 376, 859, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-16 02:15:04');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (403, 377, 857, '200.00', NULL, 'Offline', NULL, NULL, '2022-09-16 09:01:50');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (404, 378, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-16 10:17:08');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (405, 379, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-16 10:19:22');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (406, 380, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-16 10:26:21');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (407, 381, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-16 10:34:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (408, 382, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-16 17:18:55');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (409, 383, 858, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-16 17:23:31');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (410, 384, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-16 17:34:26');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (411, 385, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-16 20:20:30');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (412, 386, 857, '300.00', NULL, 'Offline', NULL, NULL, '2022-09-16 20:21:16');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (413, 387, 858, '400.00', NULL, 'Offline', NULL, NULL, '2022-09-17 09:54:06');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (414, 388, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-17 11:09:44');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (415, 389, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-17 11:16:28');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (416, 390, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-17 17:16:24');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (417, 391, 858, '500.00', NULL, 'Offline', NULL, NULL, '2022-09-17 18:31:39');


#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`shift_id`),
  CONSTRAINT `appointment_queue_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_3` FOREIGN KEY (`shift_id`) REFERENCES `doctor_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset_purchase
#

DROP TABLE IF EXISTS `asset_purchase`;

CREATE TABLE `asset_purchase` (
  `id` int(11) NOT NULL,
  `p_date` date NOT NULL,
  `supplier_id` varchar(30) NOT NULL,
  `grand_total` float NOT NULL,
  `payment_type` tinyint(4) DEFAULT NULL,
  `bank_id` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: attendance
#

DROP TABLE IF EXISTS `attendance`;

CREATE TABLE `attendance` (
  `att_id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `sign_in` varchar(30) NOT NULL,
  `sign_out` varchar(30) NOT NULL,
  `staytime` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bank_add
#

DROP TABLE IF EXISTS `bank_add`;

CREATE TABLE `bank_add` (
  `id` int(11) NOT NULL,
  `bank_id` varchar(50) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `ac_name` varchar(250) DEFAULT NULL,
  `ac_number` varchar(250) DEFAULT NULL,
  `branch` varchar(250) DEFAULT NULL,
  `signature_pic` varchar(250) DEFAULT NULL,
  `status` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bank_summary
#

DROP TABLE IF EXISTS `bank_summary`;

CREATE TABLE `bank_summary` (
  `id` int(11) NOT NULL,
  `bank_id` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `deposite_id` varchar(250) DEFAULT NULL,
  `date` varchar(250) DEFAULT NULL,
  `ac_type` varchar(50) DEFAULT NULL,
  `dr` decimal(12,2) DEFAULT 0.00,
  `cr` decimal(10,2) DEFAULT 0.00,
  `ammount` decimal(12,2) DEFAULT 0.00,
  `status` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `bed_ibfk_1` FOREIGN KEY (`bed_type_id`) REFERENCES `bed_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (1, '401A', 1, 3, 'no', '2022-02-18 11:49:52');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (2, '402A', 1, 3, 'no', '2022-02-18 11:50:06');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (3, '403A', 1, 3, 'no', '2022-02-18 11:50:36');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (4, '303', 2, 2, 'no', '2022-02-18 11:50:59');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (6, '208', 2, 1, 'yes', '2022-02-28 09:59:56');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (7, '401B', 1, 3, 'no', '2022-02-28 10:00:48');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (8, '401C', 1, 3, 'no', '2022-02-28 10:01:04');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (9, '401D', 1, 3, 'no', '2022-02-28 10:01:15');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (10, '401E', 1, 3, 'no', '2022-02-28 10:01:32');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (11, '402B', 1, 3, 'no', '2022-02-28 10:02:04');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (12, '402C', 1, 3, 'yes', '2022-02-28 10:02:16');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (13, '402D', 1, 3, 'no', '2022-02-28 10:02:27');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (14, '402E', 1, 3, 'yes', '2022-02-28 10:02:40');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (15, '403B', 1, 3, 'yes', '2022-02-28 10:03:05');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (16, '403C', 1, 3, 'yes', '2022-02-28 10:03:16');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (17, '403D', 1, 3, 'yes', '2022-02-28 10:03:28');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (18, '403E', 1, 3, 'yes', '2022-02-28 10:03:39');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (19, '303A', 2, 2, 'yes', '2022-02-28 10:08:28');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (21, '303.', 2, 2, 'yes', '2022-02-28 10:09:21');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (22, '601', 3, 4, 'no', '2022-04-17 21:55:56');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (23, '602', 3, 4, 'no', '2022-04-17 21:56:21');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (24, '603', 3, 4, 'no', '2022-04-17 21:56:35');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (25, '604', 3, 4, 'no', '2022-04-17 21:56:50');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (26, '605', 3, 4, 'no', '2022-04-17 21:57:18');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (27, '607', 3, 4, 'no', '2022-04-17 21:57:38');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (28, '608', 3, 4, 'no', '2022-04-17 21:57:56');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (29, '609', 3, 4, 'no', '2022-04-17 21:58:24');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (30, '610', 3, 4, 'no', '2022-04-17 21:58:44');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `color` varchar(50) NOT NULL DEFAULT '#f4f4f4',
  `description` varchar(200) NOT NULL,
  `floor` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (1, 'Cabin', '#f4f4f4', '', 1, 0, '2022-02-28 09:54:13');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (2, 'Cabin VIP', '#a3acf5', '', 2, 0, '2022-02-28 09:55:01');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (3, 'Ward', '#9cf29d', '', 3, 0, '2022-02-28 09:55:37');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (4, 'Single Cabin', '#ff6bb3', '', 4, 0, '2022-04-17 21:55:26');


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (1, 'Ward', '2022-02-18 11:49:17');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (2, 'Cabin', '2022-02-18 11:49:28');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (3, 'Single', '2022-04-17 21:52:10');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (4, 'Double ', '2022-04-17 21:52:26');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext DEFAULT NULL,
  `document` varchar(200) NOT NULL,
  `address` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `birth_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `birth_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  CONSTRAINT `blood_donor_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int(11) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `blood_donor_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `volume` varchar(100) DEFAULT NULL,
  `unit` int(11) DEFAULT NULL,
  `available` int(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_donor_cycle_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_2` FOREIGN KEY (`blood_donor_id`) REFERENCES `blood_donor` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `blood_donor_cycle_id` int(11) DEFAULT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `hospital_doctor` int(11) DEFAULT NULL,
  `reference` varchar(200) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `remark` mediumtext DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_issue_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_2` FOREIGN KEY (`blood_donor_cycle_id`) REFERENCES `blood_donor_cycle` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_4` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-10-22 11:21:32');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-10-22 11:21:38');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 0, '2021-10-22 11:21:40');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2463 DEFAULT CHARSET=utf8;

INSERT INTO `case_references` (`id`, `created_at`) VALUES (1, '2022-01-11 12:32:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2, '2022-02-18 11:55:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (3, '2022-02-18 12:56:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (4, '2022-02-26 15:30:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (5, '2022-02-26 15:54:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (6, '2022-02-27 20:21:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (7, '2022-02-27 21:20:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (8, '2022-02-27 21:32:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (9, '2022-03-01 00:04:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (10, '2022-03-01 09:10:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (11, '2022-03-01 13:19:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (12, '2022-03-01 18:30:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (13, '2022-03-01 18:49:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (14, '2022-03-01 19:06:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (15, '2022-03-01 19:10:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (16, '2022-03-01 19:11:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (17, '2022-03-01 19:24:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (18, '2022-03-01 19:42:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (19, '2022-03-01 19:53:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (20, '2022-03-01 23:43:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (21, '2022-03-01 23:55:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (22, '2022-03-02 00:12:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (23, '2022-03-02 00:16:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (24, '2022-03-02 08:56:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (25, '2022-03-02 18:07:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (26, '2022-03-02 18:26:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (27, '2022-03-02 18:28:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (28, '2022-03-02 18:34:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (29, '2022-03-02 18:37:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (30, '2022-03-02 18:37:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (31, '2022-03-03 11:53:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (32, '2022-03-03 12:29:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (33, '2022-03-03 12:31:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (34, '2022-03-03 12:33:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (35, '2022-03-03 16:30:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (36, '2022-03-03 23:14:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (37, '2022-03-04 16:20:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (38, '2022-03-05 09:31:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (39, '2022-03-05 17:34:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (40, '2022-03-05 17:59:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (41, '2022-03-05 18:10:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (42, '2022-03-05 18:23:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (43, '2022-03-05 18:24:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (44, '2022-03-05 18:25:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (45, '2022-03-05 18:38:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (46, '2022-03-05 18:54:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (47, '2022-03-05 18:55:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (48, '2022-03-05 18:57:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (49, '2022-03-06 08:38:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (50, '2022-03-06 09:05:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (51, '2022-03-06 15:15:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (52, '2022-03-06 15:27:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (53, '2022-03-06 15:32:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (54, '2022-03-06 15:38:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (55, '2022-03-06 15:40:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (56, '2022-03-06 19:42:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (57, '2022-03-07 00:24:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (58, '2022-03-07 01:04:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (59, '2022-03-07 08:30:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (60, '2022-03-07 08:31:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (61, '2022-03-07 20:33:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (62, '2022-03-08 14:09:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (63, '2022-03-08 14:23:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (64, '2022-03-08 14:41:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (65, '2022-03-08 22:39:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (66, '2022-03-09 21:40:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (67, '2022-03-10 00:18:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (68, '2022-03-10 00:49:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (69, '2022-03-18 21:54:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (70, '2022-03-19 10:20:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (71, '2022-03-19 10:26:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (72, '2022-03-19 11:18:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (73, '2022-03-19 12:28:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (74, '2022-03-19 12:36:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (75, '2022-03-19 12:40:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (76, '2022-03-19 18:45:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (77, '2022-03-19 18:57:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (78, '2022-03-19 19:06:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (79, '2022-03-19 19:38:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (80, '2022-03-19 19:51:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (81, '2022-03-19 22:12:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (82, '2022-03-19 22:28:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (83, '2022-03-19 22:33:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (84, '2022-03-19 23:41:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (85, '2022-03-20 09:41:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (86, '2022-03-20 10:24:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (87, '2022-03-20 12:09:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (88, '2022-03-20 13:07:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (89, '2022-03-20 18:54:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (90, '2022-03-20 18:57:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (91, '2022-03-20 20:01:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (92, '2022-03-20 23:29:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (93, '2022-03-21 10:07:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (94, '2022-03-21 11:37:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (95, '2022-03-21 13:39:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (96, '2022-03-21 15:22:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (97, '2022-03-21 16:35:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (98, '2022-03-21 16:48:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (99, '2022-03-21 17:49:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (100, '2022-03-21 19:34:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (101, '2022-03-21 20:17:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (102, '2022-03-21 20:47:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (103, '2022-03-21 22:49:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (104, '2022-03-22 08:40:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (105, '2022-03-22 11:23:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (106, '2022-03-22 11:34:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (107, '2022-03-22 11:55:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (108, '2022-03-22 11:59:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (109, '2022-03-22 12:15:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (110, '2022-03-22 13:05:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (111, '2022-03-22 13:08:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (112, '2022-03-22 13:45:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (113, '2022-03-22 19:13:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (114, '2022-03-22 19:18:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (115, '2022-03-22 19:29:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (116, '2022-03-22 19:40:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (117, '2022-03-22 22:20:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (118, '2022-03-23 08:16:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (119, '2022-03-23 11:18:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (120, '2022-03-23 12:44:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (121, '2022-03-23 17:02:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (122, '2022-03-23 17:39:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (123, '2022-03-23 18:13:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (124, '2022-03-23 18:14:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (125, '2022-03-23 19:08:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (126, '2022-03-23 21:15:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (127, '2022-03-23 21:47:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (128, '2022-03-24 09:38:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (129, '2022-03-24 10:33:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (130, '2022-03-24 11:37:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (131, '2022-03-24 12:17:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (132, '2022-03-24 13:03:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (133, '2022-03-24 13:24:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (134, '2022-03-24 17:30:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (135, '2022-03-24 17:42:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (136, '2022-03-24 18:07:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (137, '2022-03-24 19:06:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (138, '2022-03-24 19:09:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (139, '2022-03-24 19:23:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (140, '2022-03-24 19:30:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (141, '2022-03-24 21:18:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (142, '2022-03-24 22:06:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (143, '2022-03-24 23:04:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (144, '2022-03-24 23:13:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (145, '2022-03-25 10:20:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (146, '2022-03-25 11:05:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (147, '2022-03-25 11:25:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (148, '2022-03-25 12:45:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (149, '2022-03-25 12:52:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (150, '2022-03-25 13:48:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (151, '2022-03-25 18:28:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (152, '2022-03-25 18:33:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (153, '2022-03-25 20:34:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (154, '2022-03-25 21:17:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (155, '2022-03-25 22:08:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (156, '2022-03-25 22:11:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (157, '2022-03-26 10:10:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (158, '2022-03-26 11:18:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (159, '2022-03-26 15:33:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (160, '2022-03-26 15:34:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (161, '2022-03-26 16:14:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (162, '2022-03-26 16:43:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (163, '2022-03-26 19:46:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (164, '2022-03-26 20:18:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (165, '2022-03-26 21:05:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (166, '2022-03-26 21:06:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (167, '2022-03-27 08:48:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (168, '2022-03-27 09:18:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (169, '2022-03-27 09:33:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (170, '2022-03-27 10:53:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (171, '2022-03-27 11:48:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (172, '2022-03-27 16:50:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (173, '2022-03-27 17:50:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (174, '2022-03-27 18:02:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (175, '2022-03-27 18:19:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (176, '2022-03-27 18:59:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (177, '2022-03-27 19:16:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (178, '2022-03-27 20:36:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (179, '2022-03-27 20:39:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (180, '2022-03-27 22:51:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (181, '2022-03-28 11:08:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (182, '2022-03-28 13:02:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (183, '2022-03-28 13:04:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (184, '2022-03-28 14:05:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (185, '2022-03-28 16:43:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (186, '2022-03-28 17:14:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (187, '2022-03-28 18:07:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (188, '2022-03-28 19:05:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (189, '2022-03-28 20:09:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (190, '2022-03-29 12:25:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (191, '2022-03-29 12:36:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (192, '2022-03-29 12:55:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (193, '2022-03-29 14:01:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (194, '2022-03-29 14:36:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (195, '2022-03-29 14:38:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (196, '2022-03-29 17:11:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (197, '2022-03-29 17:26:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (198, '2022-03-29 18:06:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (199, '2022-03-29 19:08:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (200, '2022-03-29 19:52:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (201, '2022-03-29 19:53:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (202, '2022-03-30 10:39:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (203, '2022-03-30 11:03:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (204, '2022-03-30 12:40:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (205, '2022-03-30 14:03:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (206, '2022-03-30 16:35:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (207, '2022-03-30 16:44:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (208, '2022-03-30 17:07:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (209, '2022-03-30 19:38:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (210, '2022-03-30 19:41:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (211, '2022-03-31 09:04:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (212, '2022-03-31 10:30:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (213, '2022-03-31 11:23:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (214, '2022-03-31 12:04:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (215, '2022-03-31 12:07:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (216, '2022-03-31 13:57:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (217, '2022-03-31 15:43:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (218, '2022-03-31 17:36:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (219, '2022-03-31 18:08:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (220, '2022-03-31 18:57:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (221, '2022-03-31 19:08:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (222, '2022-03-31 20:53:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (223, '2022-03-31 22:04:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (224, '2022-04-01 05:02:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (225, '2022-04-01 10:31:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (226, '2022-04-01 11:09:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (227, '2022-04-01 11:28:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (228, '2022-04-01 13:00:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (229, '2022-04-01 13:13:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (230, '2022-04-01 16:34:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (231, '2022-04-01 17:50:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (232, '2022-04-01 18:48:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (233, '2022-04-01 20:14:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (234, '2022-04-01 22:17:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (235, '2022-04-02 09:30:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (236, '2022-04-02 10:25:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (237, '2022-04-02 11:25:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (238, '2022-04-02 11:31:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (239, '2022-04-02 14:01:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (240, '2022-04-02 15:37:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (241, '2022-04-02 17:25:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (242, '2022-04-02 17:31:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (243, '2022-04-02 18:55:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (244, '2022-04-02 19:24:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (245, '2022-04-03 11:12:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (246, '2022-04-03 11:22:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (247, '2022-04-03 12:19:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (248, '2022-04-03 12:48:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (249, '2022-04-03 19:51:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (250, '2022-04-03 20:14:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (251, '2022-04-03 22:14:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (252, '2022-04-04 09:45:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (253, '2022-04-04 10:28:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (254, '2022-04-04 11:26:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (255, '2022-04-04 11:27:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (256, '2022-04-04 12:01:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (257, '2022-04-04 12:03:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (258, '2022-04-04 13:14:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (259, '2022-04-04 16:06:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (260, '2022-04-04 18:13:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (261, '2022-04-04 21:20:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (262, '2022-04-04 22:13:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (263, '2022-04-04 22:15:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (264, '2022-04-04 22:16:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (265, '2022-04-05 09:52:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (266, '2022-04-05 10:14:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (267, '2022-04-05 10:46:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (268, '2022-04-05 15:59:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (269, '2022-04-05 18:14:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (270, '2022-04-05 21:41:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (271, '2022-04-06 09:13:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (272, '2022-04-06 09:54:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (273, '2022-04-06 10:33:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (274, '2022-04-06 10:48:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (275, '2022-04-06 19:13:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (276, '2022-04-06 19:46:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (277, '2022-04-06 20:47:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (278, '2022-04-06 23:02:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (279, '2022-04-07 09:51:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (280, '2022-04-07 10:10:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (281, '2022-04-07 10:25:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (282, '2022-04-07 10:59:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (283, '2022-04-07 11:31:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (284, '2022-04-07 11:39:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (285, '2022-04-07 15:32:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (286, '2022-04-07 15:52:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (287, '2022-04-07 21:01:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (288, '2022-04-07 21:23:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (289, '2022-04-08 09:38:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (290, '2022-04-08 09:45:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (291, '2022-04-08 10:35:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (292, '2022-04-08 10:43:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (293, '2022-04-08 10:49:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (294, '2022-04-08 11:10:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (295, '2022-04-08 11:15:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (296, '2022-04-08 12:08:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (297, '2022-04-08 12:11:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (298, '2022-04-08 12:25:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (299, '2022-04-08 14:48:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (300, '2022-04-08 16:09:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (301, '2022-04-08 20:12:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (302, '2022-04-09 06:43:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (303, '2022-04-09 07:36:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (304, '2022-04-09 07:40:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (305, '2022-04-09 11:03:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (306, '2022-04-09 11:12:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (307, '2022-04-09 11:17:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (308, '2022-04-09 11:24:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (309, '2022-04-09 12:10:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (310, '2022-04-09 12:20:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (311, '2022-04-09 15:18:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (312, '2022-04-09 15:46:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (313, '2022-04-09 17:34:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (314, '2022-04-09 17:54:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (315, '2022-04-09 17:55:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (316, '2022-04-09 19:17:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (317, '2022-04-10 08:51:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (318, '2022-04-10 09:33:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (319, '2022-04-10 09:52:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (320, '2022-04-10 10:04:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (321, '2022-04-10 12:11:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (322, '2022-04-10 12:27:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (323, '2022-04-10 12:49:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (324, '2022-04-10 12:57:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (325, '2022-04-10 14:34:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (326, '2022-04-10 15:13:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (327, '2022-04-10 15:43:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (328, '2022-04-10 17:26:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (329, '2022-04-10 17:33:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (330, '2022-04-10 17:43:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (331, '2022-04-10 19:30:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (332, '2022-04-10 19:32:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (333, '2022-04-10 19:41:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (334, '2022-04-10 20:23:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (335, '2022-04-10 20:24:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (336, '2022-04-10 22:43:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (337, '2022-04-11 01:57:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (338, '2022-04-11 10:28:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (339, '2022-04-11 11:17:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (340, '2022-04-11 11:55:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (341, '2022-04-11 12:26:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (342, '2022-04-11 17:16:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (343, '2022-04-11 19:15:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (344, '2022-04-11 20:35:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (345, '2022-04-11 20:37:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (346, '2022-04-12 08:54:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (347, '2022-04-12 09:34:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (348, '2022-04-12 10:06:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (349, '2022-04-12 10:11:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (350, '2022-04-12 10:11:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (351, '2022-04-12 11:03:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (352, '2022-04-12 11:22:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (353, '2022-04-12 11:33:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (354, '2022-04-12 12:39:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (355, '2022-04-12 15:12:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (356, '2022-04-12 15:53:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (357, '2022-04-12 16:03:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (358, '2022-04-12 16:36:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (359, '2022-04-12 16:36:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (360, '2022-04-12 21:23:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (361, '2022-04-12 22:06:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (362, '2022-04-12 23:25:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (363, '2022-04-13 09:54:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (364, '2022-04-13 10:27:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (365, '2022-04-13 10:30:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (366, '2022-04-13 11:08:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (367, '2022-04-13 11:32:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (368, '2022-04-13 11:54:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (369, '2022-04-13 12:15:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (370, '2022-04-13 12:40:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (371, '2022-04-13 13:10:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (372, '2022-04-13 15:39:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (373, '2022-04-13 17:48:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (374, '2022-04-13 19:30:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (375, '2022-04-13 20:04:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (376, '2022-04-14 01:19:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (377, '2022-04-14 09:33:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (378, '2022-04-14 10:52:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (379, '2022-04-14 11:38:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (380, '2022-04-14 11:58:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (381, '2022-04-14 12:06:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (382, '2022-04-14 12:50:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (383, '2022-04-14 19:30:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (384, '2022-04-15 09:40:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (385, '2022-04-15 10:03:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (386, '2022-04-15 11:37:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (387, '2022-04-15 11:48:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (388, '2022-04-15 11:53:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (389, '2022-04-15 12:42:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (390, '2022-04-15 16:26:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (391, '2022-04-15 19:31:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (392, '2022-04-15 21:08:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (393, '2022-04-15 21:42:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (394, '2022-04-16 10:03:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (395, '2022-04-16 11:18:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (396, '2022-04-16 11:24:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (397, '2022-04-16 11:48:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (398, '2022-04-16 12:31:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (399, '2022-04-16 12:55:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (400, '2022-04-16 14:18:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (401, '2022-04-16 14:19:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (402, '2022-04-16 16:45:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (403, '2022-04-16 19:16:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (404, '2022-04-16 19:19:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (405, '2022-04-16 19:56:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (406, '2022-04-16 19:58:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (407, '2022-04-17 09:29:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (408, '2022-04-17 10:39:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (409, '2022-04-17 10:59:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (410, '2022-04-17 11:54:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (411, '2022-04-17 12:36:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (412, '2022-04-17 13:19:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (413, '2022-04-17 15:01:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (414, '2022-04-17 15:43:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (415, '2022-04-17 17:06:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (416, '2022-04-17 17:14:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (417, '2022-04-17 17:33:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (418, '2022-04-17 22:15:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (419, '2022-04-17 22:36:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (420, '2022-04-18 09:36:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (421, '2022-04-18 10:04:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (422, '2022-04-18 11:00:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (423, '2022-04-18 11:35:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (424, '2022-04-18 11:38:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (425, '2022-04-18 11:53:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (426, '2022-04-18 12:23:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (427, '2022-04-18 12:29:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (428, '2022-04-18 15:15:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (429, '2022-04-18 15:57:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (430, '2022-04-18 19:32:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (431, '2022-04-18 20:08:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (432, '2022-04-19 09:27:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (433, '2022-04-19 10:21:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (434, '2022-04-19 10:29:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (435, '2022-04-19 10:46:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (436, '2022-04-19 10:52:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (437, '2022-04-19 11:01:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (438, '2022-04-19 11:07:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (439, '2022-04-19 11:26:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (440, '2022-04-19 11:32:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (441, '2022-04-19 11:41:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (442, '2022-04-19 12:57:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (443, '2022-04-19 13:45:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (444, '2022-04-19 20:15:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (445, '2022-04-20 09:54:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (446, '2022-04-20 11:16:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (447, '2022-04-20 12:58:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (448, '2022-04-20 14:56:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (449, '2022-04-21 02:33:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (450, '2022-04-21 02:44:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (451, '2022-04-21 10:01:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (452, '2022-04-21 10:25:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (453, '2022-04-21 11:02:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (454, '2022-04-21 12:41:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (455, '2022-04-21 15:03:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (456, '2022-04-21 17:14:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (457, '2022-04-24 21:46:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (458, '2022-04-24 22:50:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (459, '2022-04-25 07:02:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (460, '2022-04-25 09:26:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (461, '2022-04-25 09:55:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (462, '2022-04-25 10:06:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (463, '2022-04-25 11:23:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (464, '2022-04-25 12:10:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (465, '2022-04-25 12:49:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (466, '2022-04-25 12:49:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (467, '2022-04-25 12:58:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (468, '2022-04-25 13:14:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (469, '2022-04-25 13:51:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (470, '2022-04-25 16:51:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (471, '2022-04-25 17:40:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (472, '2022-04-25 19:22:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (473, '2022-04-25 20:05:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (474, '2022-04-25 20:33:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (475, '2022-04-26 09:15:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (476, '2022-04-26 10:31:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (477, '2022-04-26 12:13:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (478, '2022-04-26 12:35:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (479, '2022-04-26 12:39:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (480, '2022-04-26 13:44:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (481, '2022-04-26 21:30:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (482, '2022-04-27 11:09:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (483, '2022-04-27 21:27:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (484, '2022-04-28 16:07:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (485, '2022-04-28 17:49:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (486, '2022-04-28 19:52:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (487, '2022-04-28 22:57:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (488, '2022-04-29 12:55:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (489, '2022-04-29 14:12:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (490, '2022-04-29 19:38:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (491, '2022-04-29 22:11:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (492, '2022-04-29 23:54:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (493, '2022-04-30 10:02:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (494, '2022-04-30 10:31:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (495, '2022-04-30 12:05:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (496, '2022-04-30 13:08:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (497, '2022-04-30 13:52:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (498, '2022-04-30 13:54:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (499, '2022-04-30 13:58:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (500, '2022-05-01 10:32:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (501, '2022-05-01 14:32:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (502, '2022-05-01 14:40:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (503, '2022-05-01 15:25:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (504, '2022-05-01 15:27:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (505, '2022-05-01 18:05:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (506, '2022-05-02 12:15:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (507, '2022-05-02 13:44:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (508, '2022-05-02 13:48:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (509, '2022-05-02 15:02:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (510, '2022-05-02 16:28:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (511, '2022-05-02 22:34:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (512, '2022-05-03 12:14:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (513, '2022-05-03 19:03:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (514, '2022-05-03 19:52:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (515, '2022-05-03 21:00:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (516, '2022-05-04 00:35:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (517, '2022-05-04 10:58:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (518, '2022-05-04 11:19:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (519, '2022-05-04 12:10:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (520, '2022-05-04 12:36:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (521, '2022-05-04 20:15:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (522, '2022-05-04 20:37:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (523, '2022-05-05 11:42:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (524, '2022-05-05 11:54:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (525, '2022-05-05 13:28:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (526, '2022-05-05 19:12:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (527, '2022-05-06 12:23:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (528, '2022-05-06 12:26:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (529, '2022-05-06 12:42:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (530, '2022-05-06 17:05:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (531, '2022-05-06 17:35:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (532, '2022-05-06 19:15:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (533, '2022-05-06 19:38:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (534, '2022-05-06 19:42:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (535, '2022-05-07 09:52:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (536, '2022-05-07 10:10:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (537, '2022-05-07 10:43:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (538, '2022-05-07 11:26:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (539, '2022-05-07 11:54:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (540, '2022-05-07 12:39:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (541, '2022-05-07 12:43:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (542, '2022-05-07 13:00:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (543, '2022-05-07 13:01:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (544, '2022-05-07 13:03:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (545, '2022-05-07 13:21:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (546, '2022-05-07 17:43:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (547, '2022-05-07 19:01:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (548, '2022-05-07 21:46:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (549, '2022-05-07 23:38:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (550, '2022-05-08 01:10:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (551, '2022-05-08 08:17:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (552, '2022-05-08 09:16:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (553, '2022-05-08 10:05:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (554, '2022-05-08 10:34:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (555, '2022-05-08 11:19:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (556, '2022-05-08 11:34:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (557, '2022-05-08 11:42:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (558, '2022-05-08 16:43:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (559, '2022-05-08 18:31:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (560, '2022-05-08 19:21:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (561, '2022-05-09 09:18:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (562, '2022-05-09 10:30:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (563, '2022-05-09 10:31:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (564, '2022-05-09 11:44:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (565, '2022-05-09 11:50:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (566, '2022-05-09 12:52:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (567, '2022-05-09 13:11:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (568, '2022-05-09 13:17:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (569, '2022-05-09 14:00:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (570, '2022-05-09 14:01:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (571, '2022-05-09 15:34:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (572, '2022-05-09 16:53:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (573, '2022-05-09 18:06:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (574, '2022-05-09 18:12:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (575, '2022-05-09 19:28:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (576, '2022-05-09 19:37:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (577, '2022-05-09 20:20:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (578, '2022-05-09 20:22:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (579, '2022-05-10 08:33:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (580, '2022-05-10 11:21:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (581, '2022-05-10 11:29:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (582, '2022-05-10 11:31:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (583, '2022-05-10 11:55:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (584, '2022-05-10 11:55:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (585, '2022-05-10 11:58:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (586, '2022-05-10 12:12:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (587, '2022-05-10 12:28:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (588, '2022-05-10 16:58:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (589, '2022-05-10 17:12:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (590, '2022-05-10 19:43:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (591, '2022-05-10 19:47:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (592, '2022-05-10 20:35:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (593, '2022-05-11 09:43:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (594, '2022-05-11 10:18:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (595, '2022-05-11 10:35:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (596, '2022-05-11 10:46:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (597, '2022-05-11 11:13:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (598, '2022-05-11 12:49:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (599, '2022-05-11 13:46:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (600, '2022-05-12 06:23:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (601, '2022-05-12 07:16:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (602, '2022-05-12 10:20:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (603, '2022-05-12 10:36:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (604, '2022-05-12 11:41:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (605, '2022-05-12 11:45:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (606, '2022-05-12 12:06:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (607, '2022-05-12 17:28:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (608, '2022-05-12 17:37:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (609, '2022-05-12 19:20:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (610, '2022-05-12 19:46:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (611, '2022-05-12 20:48:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (612, '2022-05-12 21:37:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (613, '2022-05-12 21:37:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (614, '2022-05-12 21:42:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (615, '2022-05-12 22:03:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (616, '2022-05-12 22:50:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (617, '2022-05-13 05:38:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (618, '2022-05-13 05:40:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (619, '2022-05-13 09:16:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (620, '2022-05-13 09:17:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (621, '2022-05-13 09:36:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (622, '2022-05-13 10:16:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (623, '2022-05-13 10:40:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (624, '2022-05-13 11:14:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (625, '2022-05-13 11:25:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (626, '2022-05-13 12:15:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (627, '2022-05-13 16:47:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (628, '2022-05-13 17:16:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (629, '2022-05-13 17:23:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (630, '2022-05-13 17:24:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (631, '2022-05-13 19:02:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (632, '2022-05-13 19:05:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (633, '2022-05-13 20:38:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (634, '2022-05-13 23:46:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (635, '2022-05-13 23:48:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (636, '2022-05-14 01:31:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (637, '2022-05-14 01:33:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (638, '2022-05-14 08:16:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (639, '2022-05-14 09:29:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (640, '2022-05-14 09:57:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (641, '2022-05-14 10:00:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (642, '2022-05-14 10:40:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (643, '2022-05-14 10:47:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (644, '2022-05-14 10:48:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (645, '2022-05-14 11:00:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (646, '2022-05-14 12:12:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (647, '2022-05-14 12:34:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (648, '2022-05-14 15:16:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (649, '2022-05-14 17:38:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (650, '2022-05-14 17:49:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (651, '2022-05-14 18:24:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (652, '2022-05-14 21:02:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (653, '2022-05-15 09:22:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (654, '2022-05-15 10:12:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (655, '2022-05-15 10:23:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (656, '2022-05-15 10:30:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (657, '2022-05-15 10:34:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (658, '2022-05-15 10:49:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (659, '2022-05-15 10:56:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (660, '2022-05-15 11:20:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (661, '2022-05-15 11:54:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (662, '2022-05-15 11:56:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (663, '2022-05-15 12:16:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (664, '2022-05-15 12:22:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (665, '2022-05-15 12:47:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (666, '2022-05-15 13:44:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (667, '2022-05-15 14:23:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (668, '2022-05-15 17:19:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (669, '2022-05-15 18:23:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (670, '2022-05-15 19:43:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (671, '2022-05-15 20:46:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (672, '2022-05-16 10:25:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (673, '2022-05-16 10:37:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (674, '2022-05-16 12:02:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (675, '2022-05-16 16:41:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (676, '2022-05-16 17:43:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (677, '2022-05-16 20:15:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (678, '2022-05-16 20:25:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (679, '2022-05-16 20:27:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (680, '2022-05-16 20:34:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (681, '2022-05-16 20:38:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (682, '2022-05-16 22:51:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (683, '2022-05-17 10:03:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (684, '2022-05-17 10:05:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (685, '2022-05-17 11:06:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (686, '2022-05-17 11:17:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (687, '2022-05-17 11:29:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (688, '2022-05-17 12:34:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (689, '2022-05-17 16:33:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (690, '2022-05-17 16:50:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (691, '2022-05-17 17:03:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (692, '2022-05-17 17:21:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (693, '2022-05-17 19:21:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (694, '2022-05-17 19:33:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (695, '2022-05-17 22:06:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (696, '2022-05-17 22:07:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (697, '2022-05-18 01:29:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (698, '2022-05-18 01:33:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (699, '2022-05-18 01:35:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (700, '2022-05-18 03:02:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (701, '2022-05-18 03:03:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (702, '2022-05-18 05:07:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (703, '2022-05-18 05:08:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (704, '2022-05-18 08:37:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (705, '2022-05-18 09:18:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (706, '2022-05-18 09:53:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (707, '2022-05-18 10:21:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (708, '2022-05-18 10:22:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (709, '2022-05-18 10:30:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (710, '2022-05-18 10:56:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (711, '2022-05-18 11:03:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (712, '2022-05-18 12:05:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (713, '2022-05-18 12:35:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (714, '2022-05-18 12:53:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (715, '2022-05-18 15:35:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (716, '2022-05-18 15:53:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (717, '2022-05-18 16:13:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (718, '2022-05-18 16:47:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (719, '2022-05-18 17:39:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (720, '2022-05-18 18:11:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (721, '2022-05-18 18:20:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (722, '2022-05-18 19:32:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (723, '2022-05-18 20:18:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (724, '2022-05-19 10:30:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (725, '2022-05-19 11:13:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (726, '2022-05-19 11:27:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (727, '2022-05-19 12:20:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (728, '2022-05-19 12:37:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (729, '2022-05-19 13:11:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (730, '2022-05-19 13:16:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (731, '2022-05-19 18:06:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (732, '2022-05-19 19:06:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (733, '2022-05-19 20:19:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (734, '2022-05-19 20:27:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (735, '2022-05-20 09:35:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (736, '2022-05-20 09:49:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (737, '2022-05-20 09:55:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (738, '2022-05-20 10:19:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (739, '2022-05-20 10:21:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (740, '2022-05-20 10:40:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (741, '2022-05-20 10:48:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (742, '2022-05-20 11:41:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (743, '2022-05-20 12:16:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (744, '2022-05-20 14:28:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (745, '2022-05-20 16:25:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (746, '2022-05-20 17:56:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (747, '2022-05-20 18:23:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (748, '2022-05-20 18:39:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (749, '2022-05-20 19:41:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (750, '2022-05-20 20:11:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (751, '2022-05-20 22:32:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (752, '2022-05-20 23:58:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (753, '2022-05-21 23:30:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (754, '2022-05-21 23:51:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (755, '2022-05-22 00:19:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (756, '2022-05-22 00:57:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (757, '2022-05-22 01:10:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (758, '2022-05-22 01:19:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (759, '2022-05-22 01:28:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (760, '2022-05-22 01:30:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (761, '2022-05-22 01:34:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (762, '2022-05-22 01:49:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (763, '2022-05-22 07:00:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (764, '2022-05-22 07:28:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (765, '2022-05-22 09:04:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (766, '2022-05-23 00:02:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (767, '2022-05-23 00:19:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (768, '2022-05-23 00:32:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (769, '2022-05-23 01:02:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (770, '2022-05-23 01:47:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (771, '2022-05-23 01:52:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (772, '2022-05-23 01:54:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (773, '2022-05-23 03:10:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (774, '2022-05-23 03:41:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (775, '2022-05-23 03:42:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (776, '2022-05-23 07:16:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (777, '2022-05-22 18:51:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (778, '2022-05-22 19:03:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (779, '2022-05-22 20:46:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (780, '2022-05-23 00:02:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (781, '2022-05-23 00:04:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (782, '2022-05-23 09:41:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (783, '2022-05-23 10:02:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (784, '2022-05-23 10:18:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (785, '2022-05-23 11:03:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (786, '2022-05-23 11:07:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (787, '2022-05-23 11:50:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (788, '2022-05-23 12:09:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (789, '2022-05-23 12:24:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (790, '2022-05-23 12:43:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (791, '2022-05-23 18:53:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (792, '2022-05-23 19:22:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (793, '2022-05-23 19:48:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (794, '2022-05-23 22:35:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (795, '2022-05-23 23:49:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (796, '2022-05-24 10:01:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (797, '2022-05-24 10:33:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (798, '2022-05-24 10:43:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (799, '2022-05-24 11:28:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (800, '2022-05-24 11:48:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (801, '2022-05-24 12:01:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (802, '2022-05-24 18:01:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (803, '2022-05-24 19:02:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (804, '2022-05-24 19:13:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (805, '2022-05-25 09:34:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (806, '2022-05-25 09:58:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (807, '2022-05-25 10:13:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (808, '2022-05-25 10:17:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (809, '2022-05-25 11:00:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (810, '2022-05-25 11:23:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (811, '2022-05-25 13:01:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (812, '2022-05-25 18:31:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (813, '2022-05-25 18:34:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (814, '2022-05-25 18:47:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (815, '2022-05-25 19:20:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (816, '2022-05-26 10:46:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (817, '2022-05-26 11:09:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (818, '2022-05-26 12:12:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (819, '2022-05-26 12:15:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (820, '2022-05-26 12:42:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (821, '2022-05-26 17:01:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (822, '2022-05-26 17:35:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (823, '2022-05-26 17:49:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (824, '2022-05-26 18:50:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (825, '2022-05-27 06:37:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (826, '2022-05-27 09:53:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (827, '2022-05-27 10:09:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (828, '2022-05-27 10:11:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (829, '2022-05-27 10:27:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (830, '2022-05-27 10:34:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (831, '2022-05-27 10:36:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (832, '2022-05-27 10:50:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (833, '2022-05-27 11:02:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (834, '2022-05-27 11:30:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (835, '2022-05-27 11:46:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (836, '2022-05-27 12:35:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (837, '2022-05-27 12:40:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (838, '2022-05-27 16:07:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (839, '2022-05-27 16:11:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (840, '2022-05-27 16:32:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (841, '2022-05-27 16:41:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (842, '2022-05-27 17:12:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (843, '2022-05-27 17:38:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (844, '2022-05-27 18:30:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (845, '2022-05-27 18:32:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (846, '2022-05-27 18:55:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (847, '2022-05-27 23:14:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (848, '2022-05-27 23:27:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (849, '2022-05-27 23:47:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (850, '2022-05-28 10:16:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (851, '2022-05-28 10:42:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (852, '2022-05-28 10:54:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (853, '2022-05-28 11:36:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (854, '2022-05-28 12:17:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (855, '2022-05-28 13:19:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (856, '2022-05-28 13:22:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (857, '2022-05-28 18:38:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (858, '2022-05-29 11:26:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (859, '2022-05-29 12:05:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (860, '2022-05-29 13:21:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (861, '2022-05-29 17:54:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (862, '2022-05-29 18:24:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (863, '2022-05-29 19:38:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (864, '2022-05-30 04:53:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (865, '2022-05-30 10:13:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (866, '2022-05-30 10:27:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (867, '2022-05-30 11:50:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (868, '2022-05-30 12:43:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (869, '2022-05-30 15:16:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (870, '2022-05-30 16:01:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (871, '2022-05-30 16:44:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (872, '2022-05-30 17:53:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (873, '2022-05-30 17:58:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (874, '2022-05-30 18:20:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (875, '2022-05-30 18:58:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (876, '2022-05-31 09:37:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (877, '2022-05-31 10:15:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (878, '2022-05-31 10:29:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (879, '2022-05-31 10:34:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (880, '2022-05-31 11:04:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (881, '2022-05-31 12:27:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (882, '2022-05-31 16:13:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (883, '2022-05-31 16:37:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (884, '2022-05-31 16:49:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (885, '2022-05-31 17:38:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (886, '2022-05-31 17:51:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (887, '2022-05-31 17:55:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (888, '2022-05-31 18:05:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (889, '2022-05-31 19:13:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (890, '2022-06-01 09:40:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (891, '2022-06-01 10:05:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (892, '2022-06-01 10:23:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (893, '2022-06-01 10:32:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (894, '2022-06-01 15:58:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (895, '2022-06-01 17:03:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (896, '2022-06-01 18:00:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (897, '2022-06-01 18:01:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (898, '2022-06-01 18:04:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (899, '2022-06-01 18:17:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (900, '2022-06-01 19:17:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (901, '2022-06-01 19:46:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (902, '2022-06-01 21:10:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (903, '2022-06-02 10:17:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (904, '2022-06-02 11:02:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (905, '2022-06-02 11:11:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (906, '2022-06-02 11:36:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (907, '2022-06-02 11:40:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (908, '2022-06-02 11:48:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (909, '2022-06-02 11:53:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (910, '2022-06-02 12:02:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (911, '2022-06-02 12:11:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (912, '2022-06-02 12:56:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (913, '2022-06-02 13:10:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (914, '2022-06-02 14:01:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (915, '2022-06-02 15:54:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (916, '2022-06-02 17:36:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (917, '2022-06-03 09:55:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (918, '2022-06-03 09:58:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (919, '2022-06-03 09:59:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (920, '2022-06-03 10:04:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (921, '2022-06-03 10:14:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (922, '2022-06-03 10:26:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (923, '2022-06-03 10:36:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (924, '2022-06-03 11:01:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (925, '2022-06-03 11:34:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (926, '2022-06-03 11:43:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (927, '2022-06-03 12:12:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (928, '2022-06-03 16:01:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (929, '2022-06-03 17:44:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (930, '2022-06-03 17:48:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (931, '2022-06-03 18:23:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (932, '2022-06-03 19:26:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (933, '2022-06-03 19:35:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (934, '2022-06-03 19:54:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (935, '2022-06-03 21:35:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (936, '2022-06-04 09:08:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (937, '2022-06-04 12:17:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (938, '2022-06-04 12:53:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (939, '2022-06-04 15:01:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (940, '2022-06-04 17:53:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (941, '2022-06-04 17:55:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (942, '2022-06-04 18:28:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (943, '2022-06-04 19:12:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (944, '2022-06-04 20:36:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (945, '2022-06-05 10:28:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (946, '2022-06-05 10:39:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (947, '2022-06-05 10:50:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (948, '2022-06-05 11:29:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (949, '2022-06-05 12:49:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (950, '2022-06-05 16:24:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (951, '2022-06-05 17:29:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (952, '2022-06-05 18:28:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (953, '2022-06-05 19:00:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (954, '2022-06-05 19:25:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (955, '2022-06-05 20:42:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (956, '2022-06-05 21:51:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (957, '2022-06-06 09:03:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (958, '2022-06-06 09:58:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (959, '2022-06-06 11:18:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (960, '2022-06-06 11:22:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (961, '2022-06-06 11:25:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (962, '2022-06-06 11:37:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (963, '2022-06-06 16:32:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (964, '2022-06-07 10:19:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (965, '2022-06-07 10:26:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (966, '2022-06-07 10:35:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (967, '2022-06-07 11:05:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (968, '2022-06-07 19:03:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (969, '2022-06-07 19:31:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (970, '2022-06-07 22:53:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (971, '2022-06-08 09:54:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (972, '2022-06-08 10:13:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (973, '2022-06-08 10:17:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (974, '2022-06-08 10:45:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (975, '2022-06-08 11:10:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (976, '2022-06-08 11:25:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (977, '2022-06-08 12:17:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (978, '2022-06-08 13:34:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (979, '2022-06-08 13:59:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (980, '2022-06-08 16:09:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (981, '2022-06-08 16:59:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (982, '2022-06-08 17:08:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (983, '2022-06-08 19:19:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (984, '2022-06-08 22:54:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (985, '2022-06-08 22:55:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (986, '2022-06-09 08:46:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (987, '2022-06-09 09:43:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (988, '2022-06-09 09:44:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (989, '2022-06-09 09:48:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (990, '2022-06-09 10:01:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (991, '2022-06-09 10:04:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (992, '2022-06-09 10:44:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (993, '2022-06-09 10:50:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (994, '2022-06-09 10:58:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (995, '2022-06-09 11:00:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (996, '2022-06-09 11:09:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (997, '2022-06-09 11:28:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (998, '2022-06-09 11:28:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (999, '2022-06-09 11:36:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1000, '2022-06-09 12:17:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1001, '2022-06-09 14:05:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1002, '2022-06-09 16:52:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1003, '2022-06-09 17:40:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1004, '2022-06-09 18:21:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1005, '2022-06-09 19:54:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1006, '2022-06-09 19:57:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1007, '2022-06-09 20:21:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1008, '2022-06-09 20:53:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1009, '2022-06-09 21:31:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1010, '2022-06-10 01:31:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1011, '2022-06-10 01:33:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1012, '2022-06-10 01:36:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1013, '2022-06-10 09:35:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1014, '2022-06-10 10:25:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1015, '2022-06-10 10:44:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1016, '2022-06-10 10:49:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1017, '2022-06-10 10:58:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1018, '2022-06-10 11:24:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1019, '2022-06-10 12:14:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1020, '2022-06-10 13:14:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1021, '2022-06-10 16:11:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1022, '2022-06-10 17:59:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1023, '2022-06-10 18:35:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1024, '2022-06-10 18:39:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1025, '2022-06-10 21:49:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1026, '2022-06-11 01:18:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1027, '2022-06-11 01:20:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1028, '2022-06-11 02:23:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1029, '2022-06-11 02:24:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1030, '2022-06-11 02:25:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1031, '2022-06-11 11:08:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1032, '2022-06-11 11:31:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1033, '2022-06-11 12:10:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1034, '2022-06-11 12:36:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1035, '2022-06-11 12:41:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1036, '2022-06-11 16:51:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1037, '2022-06-11 17:30:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1038, '2022-06-11 18:01:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1039, '2022-06-11 18:07:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1040, '2022-06-11 18:25:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1041, '2022-06-11 18:40:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1042, '2022-06-11 19:25:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1043, '2022-06-12 08:25:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1044, '2022-06-12 10:46:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1045, '2022-06-12 10:55:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1046, '2022-06-12 11:05:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1047, '2022-06-12 11:43:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1048, '2022-06-12 11:55:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1049, '2022-06-12 18:03:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1050, '2022-06-12 18:43:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1051, '2022-06-12 19:29:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1052, '2022-06-12 19:32:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1053, '2022-06-12 19:33:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1054, '2022-06-12 19:41:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1055, '2022-06-12 19:54:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1056, '2022-06-12 22:22:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1057, '2022-06-13 09:08:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1058, '2022-06-13 10:00:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1059, '2022-06-13 10:16:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1060, '2022-06-13 10:29:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1061, '2022-06-13 10:30:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1062, '2022-06-13 10:52:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1063, '2022-06-13 10:58:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1064, '2022-06-13 11:30:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1065, '2022-06-13 11:30:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1066, '2022-06-13 11:31:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1067, '2022-06-13 12:06:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1068, '2022-06-13 12:55:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1069, '2022-06-13 17:01:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1070, '2022-06-13 17:52:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1071, '2022-06-13 18:37:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1072, '2022-06-13 19:18:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1073, '2022-06-13 19:28:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1074, '2022-06-13 21:50:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1075, '2022-06-13 21:58:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1076, '2022-06-13 23:32:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1077, '2022-06-14 09:13:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1078, '2022-06-14 10:30:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1079, '2022-06-14 10:49:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1080, '2022-06-14 10:57:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1081, '2022-06-14 11:06:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1082, '2022-06-14 12:35:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1083, '2022-06-14 12:44:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1084, '2022-06-14 16:33:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1085, '2022-06-14 17:37:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1086, '2022-06-14 19:30:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1087, '2022-06-14 20:09:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1088, '2022-06-14 21:19:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1089, '2022-06-14 23:07:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1090, '2022-06-14 23:21:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1091, '2022-06-15 04:16:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1092, '2022-06-15 04:39:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1093, '2022-06-15 04:40:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1094, '2022-06-15 09:02:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1095, '2022-06-15 09:36:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1096, '2022-06-15 10:09:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1097, '2022-06-15 10:22:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1098, '2022-06-15 10:23:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1099, '2022-06-15 10:39:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1100, '2022-06-15 10:44:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1101, '2022-06-15 10:50:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1102, '2022-06-15 10:55:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1103, '2022-06-15 12:15:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1104, '2022-06-15 12:23:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1105, '2022-06-15 14:07:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1106, '2022-06-15 17:57:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1107, '2022-06-16 09:56:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1108, '2022-06-16 10:08:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1109, '2022-06-16 11:28:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1110, '2022-06-16 11:51:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1111, '2022-06-16 14:05:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1112, '2022-06-16 16:59:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1113, '2022-06-16 17:37:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1114, '2022-06-16 18:23:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1115, '2022-06-16 18:44:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1116, '2022-06-16 18:52:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1117, '2022-06-16 19:29:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1118, '2022-06-16 20:04:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1119, '2022-06-16 21:34:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1120, '2022-06-17 02:46:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1121, '2022-06-17 03:27:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1122, '2022-06-17 09:17:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1123, '2022-06-17 10:30:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1124, '2022-06-17 10:43:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1125, '2022-06-17 10:54:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1126, '2022-06-17 11:28:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1127, '2022-06-17 12:27:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1128, '2022-06-17 12:29:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1129, '2022-06-17 17:53:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1130, '2022-06-17 17:54:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1131, '2022-06-17 17:58:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1132, '2022-06-17 18:19:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1133, '2022-06-17 19:12:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1134, '2022-06-17 19:27:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1135, '2022-06-17 21:42:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1136, '2022-06-17 22:33:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1137, '2022-06-17 22:35:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1138, '2022-06-17 22:37:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1139, '2022-06-18 07:34:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1140, '2022-06-18 09:32:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1141, '2022-06-18 09:39:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1142, '2022-06-18 09:52:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1143, '2022-06-18 10:11:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1144, '2022-06-18 10:47:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1145, '2022-06-18 10:49:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1146, '2022-06-18 11:11:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1147, '2022-06-18 11:30:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1148, '2022-06-18 11:37:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1149, '2022-06-18 12:23:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1150, '2022-06-18 13:05:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1151, '2022-06-18 13:09:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1152, '2022-06-18 16:33:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1153, '2022-06-18 17:20:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1154, '2022-06-18 17:41:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1155, '2022-06-18 17:55:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1156, '2022-06-18 18:35:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1157, '2022-06-18 18:36:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1158, '2022-06-18 19:45:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1159, '2022-06-18 21:59:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1160, '2022-06-19 10:23:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1161, '2022-06-19 10:30:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1162, '2022-06-19 10:49:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1163, '2022-06-19 11:05:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1164, '2022-06-19 11:08:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1165, '2022-06-19 11:34:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1166, '2022-06-19 11:55:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1167, '2022-06-19 12:24:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1168, '2022-06-19 13:52:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1169, '2022-06-19 16:02:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1170, '2022-06-19 17:08:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1171, '2022-06-19 18:13:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1172, '2022-06-19 20:10:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1173, '2022-06-19 20:26:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1174, '2022-06-20 10:04:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1175, '2022-06-20 10:29:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1176, '2022-06-20 10:40:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1177, '2022-06-20 10:46:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1178, '2022-06-20 10:47:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1179, '2022-06-20 10:51:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1180, '2022-06-20 11:01:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1181, '2022-06-20 11:40:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1182, '2022-06-20 11:47:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1183, '2022-06-20 12:23:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1184, '2022-06-20 13:11:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1185, '2022-06-20 13:19:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1186, '2022-06-20 14:12:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1187, '2022-06-20 14:31:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1188, '2022-06-20 17:17:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1189, '2022-06-20 20:07:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1190, '2022-06-20 20:23:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1191, '2022-06-20 21:02:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1192, '2022-06-21 04:08:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1193, '2022-06-21 05:16:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1194, '2022-06-21 08:15:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1195, '2022-06-21 09:51:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1196, '2022-06-21 10:38:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1197, '2022-06-21 11:43:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1198, '2022-06-21 11:58:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1199, '2022-06-21 12:01:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1200, '2022-06-21 14:02:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1201, '2022-06-21 16:59:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1202, '2022-06-21 17:39:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1203, '2022-06-21 17:49:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1204, '2022-06-21 17:55:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1205, '2022-06-22 12:04:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1206, '2022-06-22 15:53:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1207, '2022-06-22 16:17:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1208, '2022-06-22 16:33:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1209, '2022-06-22 16:36:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1210, '2022-06-22 17:26:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1211, '2022-06-22 17:27:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1212, '2022-06-22 18:06:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1213, '2022-06-22 18:28:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1214, '2022-06-22 20:02:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1215, '2022-06-22 22:58:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1216, '2022-06-23 00:30:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1217, '2022-06-23 09:51:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1218, '2022-06-23 10:11:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1219, '2022-06-23 10:16:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1220, '2022-06-23 10:57:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1221, '2022-06-23 11:07:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1222, '2022-06-23 11:13:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1223, '2022-06-23 11:19:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1224, '2022-06-23 12:15:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1225, '2022-06-23 17:22:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1226, '2022-06-23 17:54:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1227, '2022-06-23 18:03:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1228, '2022-06-23 18:05:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1229, '2022-06-23 18:11:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1230, '2022-06-23 18:52:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1231, '2022-06-23 19:25:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1232, '2022-06-23 20:42:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1233, '2022-06-23 21:35:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1234, '2022-06-23 23:04:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1235, '2022-06-24 09:22:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1236, '2022-06-24 09:53:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1237, '2022-06-24 11:07:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1238, '2022-06-24 12:30:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1239, '2022-06-24 12:35:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1240, '2022-06-24 12:36:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1241, '2022-06-24 16:14:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1242, '2022-06-24 16:26:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1243, '2022-06-24 16:30:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1244, '2022-06-24 18:10:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1245, '2022-06-24 18:20:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1246, '2022-06-24 20:57:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1247, '2022-06-24 21:45:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1248, '2022-06-25 00:02:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1249, '2022-06-25 00:16:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1250, '2022-06-25 00:22:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1251, '2022-06-25 00:24:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1252, '2022-06-25 01:03:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1253, '2022-06-25 09:19:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1254, '2022-06-25 10:03:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1255, '2022-06-25 10:04:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1256, '2022-06-25 17:06:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1257, '2022-06-25 17:49:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1258, '2022-06-25 17:57:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1259, '2022-06-25 17:58:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1260, '2022-06-25 17:59:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1261, '2022-06-25 18:40:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1262, '2022-06-25 19:02:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1263, '2022-06-25 19:25:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1264, '2022-06-26 09:41:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1265, '2022-06-26 10:21:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1266, '2022-06-26 10:30:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1267, '2022-06-26 10:38:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1268, '2022-06-26 11:10:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1269, '2022-06-26 11:14:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1270, '2022-06-26 11:30:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1271, '2022-06-26 11:44:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1272, '2022-06-26 12:11:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1273, '2022-06-26 12:25:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1274, '2022-06-26 18:06:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1275, '2022-06-26 18:39:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1276, '2022-06-26 19:46:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1277, '2022-06-27 10:21:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1278, '2022-06-27 10:53:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1279, '2022-06-27 11:00:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1280, '2022-06-27 11:26:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1281, '2022-06-27 11:32:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1282, '2022-06-27 11:34:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1283, '2022-06-27 13:05:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1284, '2022-06-27 14:32:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1285, '2022-06-27 16:51:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1286, '2022-06-27 16:53:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1287, '2022-06-27 16:54:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1288, '2022-06-27 16:56:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1289, '2022-06-27 17:02:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1290, '2022-06-27 17:33:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1291, '2022-06-27 17:57:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1292, '2022-06-27 18:09:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1293, '2022-06-27 18:38:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1294, '2022-06-27 19:59:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1295, '2022-06-27 22:32:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1296, '2022-06-28 00:52:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1297, '2022-06-28 00:54:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1298, '2022-06-28 10:58:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1299, '2022-06-28 11:40:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1300, '2022-06-28 11:52:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1301, '2022-06-28 11:54:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1302, '2022-06-28 12:42:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1303, '2022-06-28 12:51:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1304, '2022-06-28 16:40:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1305, '2022-06-28 17:55:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1306, '2022-06-28 17:58:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1307, '2022-06-28 18:36:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1308, '2022-06-28 19:04:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1309, '2022-06-29 09:27:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1310, '2022-06-29 09:48:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1311, '2022-06-29 10:59:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1312, '2022-06-29 12:31:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1313, '2022-06-29 12:35:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1314, '2022-06-29 16:21:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1315, '2022-06-29 16:52:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1316, '2022-06-29 17:06:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1317, '2022-06-29 17:13:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1318, '2022-06-29 18:27:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1319, '2022-06-29 18:33:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1320, '2022-06-29 18:45:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1321, '2022-06-29 20:44:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1322, '2022-06-29 20:46:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1323, '2022-06-30 00:42:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1324, '2022-06-30 01:04:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1325, '2022-06-30 01:19:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1326, '2022-06-30 07:25:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1327, '2022-06-30 09:16:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1328, '2022-06-30 10:25:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1329, '2022-06-30 10:34:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1330, '2022-06-30 10:49:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1331, '2022-06-30 11:04:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1332, '2022-06-30 11:22:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1333, '2022-06-30 11:41:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1334, '2022-06-30 14:27:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1335, '2022-06-30 22:35:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1336, '2022-07-01 00:51:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1337, '2022-07-01 01:01:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1338, '2022-07-01 09:29:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1339, '2022-07-01 11:05:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1340, '2022-07-01 11:14:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1341, '2022-07-01 11:15:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1342, '2022-07-01 11:16:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1343, '2022-07-01 11:27:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1344, '2022-07-01 11:28:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1345, '2022-07-01 13:04:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1346, '2022-07-01 17:36:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1347, '2022-07-01 17:50:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1348, '2022-07-01 17:55:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1349, '2022-07-01 18:03:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1350, '2022-07-01 18:04:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1351, '2022-07-01 18:14:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1352, '2022-07-01 18:16:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1353, '2022-07-01 19:19:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1354, '2022-07-01 19:25:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1355, '2022-07-01 19:55:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1356, '2022-07-01 20:32:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1357, '2022-07-01 20:33:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1358, '2022-07-02 00:10:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1359, '2022-07-02 00:49:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1360, '2022-07-02 00:51:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1361, '2022-07-02 09:44:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1362, '2022-07-02 10:34:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1363, '2022-07-02 16:38:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1364, '2022-07-02 17:21:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1365, '2022-07-02 17:45:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1366, '2022-07-02 17:52:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1367, '2022-07-02 17:54:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1368, '2022-07-02 18:21:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1369, '2022-07-02 18:45:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1370, '2022-07-02 18:56:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1371, '2022-07-02 19:14:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1372, '2022-07-02 19:32:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1373, '2022-07-02 22:08:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1374, '2022-07-03 08:35:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1375, '2022-07-03 09:36:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1376, '2022-07-03 10:28:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1377, '2022-07-03 12:01:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1378, '2022-07-03 16:08:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1379, '2022-07-03 17:14:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1380, '2022-07-03 17:35:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1381, '2022-07-03 18:15:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1382, '2022-07-04 00:20:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1383, '2022-07-04 00:26:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1384, '2022-07-04 00:35:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1385, '2022-07-04 09:58:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1386, '2022-07-04 11:24:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1387, '2022-07-04 12:03:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1388, '2022-07-04 12:04:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1389, '2022-07-04 12:09:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1390, '2022-07-04 12:09:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1391, '2022-07-04 13:14:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1392, '2022-07-04 13:51:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1393, '2022-07-04 13:52:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1394, '2022-07-04 13:56:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1395, '2022-07-04 13:57:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1396, '2022-07-04 13:58:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1397, '2022-07-04 16:50:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1398, '2022-07-04 17:22:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1399, '2022-07-04 17:32:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1400, '2022-07-04 18:59:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1401, '2022-07-04 19:01:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1402, '2022-07-05 08:55:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1403, '2022-07-05 09:12:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1404, '2022-07-05 09:14:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1405, '2022-07-05 09:51:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1406, '2022-07-05 10:34:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1407, '2022-07-05 11:46:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1408, '2022-07-05 17:00:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1409, '2022-07-05 17:47:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1410, '2022-07-05 17:50:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1411, '2022-07-05 18:05:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1412, '2022-07-05 18:10:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1413, '2022-07-05 18:26:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1414, '2022-07-05 20:00:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1415, '2022-07-06 09:26:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1416, '2022-07-06 09:41:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1417, '2022-07-06 10:05:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1418, '2022-07-06 11:37:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1419, '2022-07-06 12:09:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1420, '2022-07-06 12:16:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1421, '2022-07-06 17:23:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1422, '2022-07-06 17:29:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1423, '2022-07-06 17:36:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1424, '2022-07-06 17:41:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1425, '2022-07-06 17:43:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1426, '2022-07-06 17:49:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1427, '2022-07-07 06:51:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1428, '2022-07-07 10:29:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1429, '2022-07-07 10:57:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1430, '2022-07-07 10:58:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1431, '2022-07-07 11:19:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1432, '2022-07-07 12:19:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1433, '2022-07-07 12:24:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1434, '2022-07-07 13:09:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1435, '2022-07-07 13:54:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1436, '2022-07-07 13:55:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1437, '2022-07-07 14:12:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1438, '2022-07-07 18:02:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1439, '2022-07-07 18:14:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1440, '2022-07-07 22:23:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1441, '2022-07-07 22:25:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1442, '2022-07-08 10:29:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1443, '2022-07-08 11:28:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1444, '2022-07-08 12:13:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1445, '2022-07-08 12:54:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1446, '2022-07-08 13:03:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1447, '2022-07-08 18:05:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1448, '2022-07-08 18:06:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1449, '2022-07-08 18:13:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1450, '2022-07-08 18:41:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1451, '2022-07-08 19:30:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1452, '2022-07-08 20:05:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1453, '2022-07-08 20:26:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1454, '2022-07-08 20:37:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1455, '2022-07-08 21:04:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1456, '2022-07-08 22:10:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1457, '2022-07-08 22:41:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1458, '2022-07-08 22:55:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1459, '2022-07-09 10:33:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1460, '2022-07-09 10:34:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1461, '2022-07-09 13:39:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1462, '2022-07-09 14:19:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1463, '2022-07-09 16:52:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1464, '2022-07-09 17:58:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1465, '2022-07-09 18:07:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1466, '2022-07-09 18:10:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1467, '2022-07-09 18:23:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1468, '2022-07-09 19:24:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1469, '2022-07-09 22:01:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1470, '2022-07-10 00:09:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1471, '2022-07-10 00:10:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1472, '2022-07-10 07:48:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1473, '2022-07-10 08:04:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1474, '2022-07-10 08:06:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1475, '2022-07-10 15:21:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1476, '2022-07-10 16:58:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1477, '2022-07-10 17:48:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1478, '2022-07-10 18:33:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1479, '2022-07-10 19:11:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1480, '2022-07-10 19:36:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1481, '2022-07-10 20:08:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1482, '2022-07-10 22:02:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1483, '2022-07-10 22:51:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1484, '2022-07-11 09:00:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1485, '2022-07-11 10:31:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1486, '2022-07-11 10:47:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1487, '2022-07-11 11:03:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1488, '2022-07-11 11:05:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1489, '2022-07-11 11:10:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1490, '2022-07-11 11:11:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1491, '2022-07-11 11:28:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1492, '2022-07-11 12:05:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1493, '2022-07-11 12:22:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1494, '2022-07-11 14:16:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1495, '2022-07-11 14:47:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1496, '2022-07-11 14:48:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1497, '2022-07-11 15:56:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1498, '2022-07-11 15:57:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1499, '2022-07-11 16:09:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1500, '2022-07-11 18:43:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1501, '2022-07-11 20:19:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1502, '2022-07-11 23:53:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1503, '2022-07-12 00:17:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1504, '2022-07-12 00:41:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1505, '2022-07-12 04:29:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1506, '2022-07-12 06:47:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1507, '2022-07-12 10:01:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1508, '2022-07-12 10:04:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1509, '2022-07-12 10:24:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1510, '2022-07-12 10:26:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1511, '2022-07-12 10:57:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1512, '2022-07-12 11:04:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1513, '2022-07-12 11:32:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1514, '2022-07-12 11:35:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1515, '2022-07-12 12:28:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1516, '2022-07-12 17:20:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1517, '2022-07-12 18:13:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1518, '2022-07-12 18:54:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1519, '2022-07-12 19:45:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1520, '2022-07-12 20:08:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1521, '2022-07-12 21:24:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1522, '2022-07-13 00:14:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1523, '2022-07-13 00:20:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1524, '2022-07-13 00:23:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1525, '2022-07-13 08:46:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1526, '2022-07-13 09:30:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1527, '2022-07-13 10:15:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1528, '2022-07-13 16:31:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1529, '2022-07-13 16:37:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1530, '2022-07-13 16:39:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1531, '2022-07-13 17:27:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1532, '2022-07-13 18:18:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1533, '2022-07-13 18:55:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1534, '2022-07-13 18:58:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1535, '2022-07-13 19:13:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1536, '2022-07-13 19:34:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1537, '2022-07-13 20:26:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1538, '2022-07-13 21:38:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1539, '2022-07-13 22:01:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1540, '2022-07-14 08:21:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1541, '2022-07-14 09:21:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1542, '2022-07-14 10:23:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1543, '2022-07-14 10:56:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1544, '2022-07-14 11:20:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1545, '2022-07-14 11:28:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1546, '2022-07-14 11:47:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1547, '2022-07-14 11:49:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1548, '2022-07-14 12:16:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1549, '2022-07-14 13:24:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1550, '2022-07-14 16:20:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1551, '2022-07-14 16:20:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1552, '2022-07-14 16:47:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1553, '2022-07-14 16:54:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1554, '2022-07-14 17:59:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1555, '2022-07-14 18:49:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1556, '2022-07-14 18:54:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1557, '2022-07-14 18:56:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1558, '2022-07-14 19:01:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1559, '2022-07-14 19:22:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1560, '2022-07-14 19:32:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1561, '2022-07-14 19:51:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1562, '2022-07-14 19:53:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1563, '2022-07-14 19:55:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1564, '2022-07-14 21:02:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1565, '2022-07-14 22:02:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1566, '2022-07-14 23:20:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1567, '2022-07-15 10:04:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1568, '2022-07-15 10:15:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1569, '2022-07-15 10:23:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1570, '2022-07-15 10:25:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1571, '2022-07-15 10:31:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1572, '2022-07-15 11:43:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1573, '2022-07-15 12:19:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1574, '2022-07-15 12:59:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1575, '2022-07-15 17:22:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1576, '2022-07-15 17:51:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1577, '2022-07-15 18:54:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1578, '2022-07-15 18:59:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1579, '2022-07-15 19:01:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1580, '2022-07-15 19:38:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1581, '2022-07-15 19:55:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1582, '2022-07-15 19:59:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1583, '2022-07-15 20:32:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1584, '2022-07-15 21:19:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1585, '2022-07-15 22:55:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1586, '2022-07-15 23:24:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1587, '2022-07-15 23:27:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1588, '2022-07-16 09:51:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1589, '2022-07-16 11:22:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1590, '2022-07-16 11:26:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1591, '2022-07-16 13:34:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1592, '2022-07-16 13:46:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1593, '2022-07-16 13:47:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1594, '2022-07-16 13:51:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1595, '2022-07-16 14:08:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1596, '2022-07-16 14:11:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1597, '2022-07-16 16:47:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1598, '2022-07-16 17:40:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1599, '2022-07-16 18:12:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1600, '2022-07-16 18:18:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1601, '2022-07-16 18:51:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1602, '2022-07-16 19:11:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1603, '2022-07-16 23:57:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1604, '2022-07-17 05:27:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1605, '2022-07-17 05:29:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1606, '2022-07-17 07:11:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1607, '2022-07-17 10:01:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1608, '2022-07-17 10:04:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1609, '2022-07-17 10:05:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1610, '2022-07-17 10:46:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1611, '2022-07-17 10:49:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1612, '2022-07-17 10:49:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1613, '2022-07-17 11:41:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1614, '2022-07-17 11:46:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1615, '2022-07-17 13:12:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1616, '2022-07-17 15:18:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1617, '2022-07-17 16:39:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1618, '2022-07-17 17:38:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1619, '2022-07-17 18:01:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1620, '2022-07-17 18:52:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1621, '2022-07-17 19:48:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1622, '2022-07-18 08:43:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1623, '2022-07-18 09:23:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1624, '2022-07-18 09:51:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1625, '2022-07-18 10:35:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1626, '2022-07-18 10:42:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1627, '2022-07-18 10:47:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1628, '2022-07-18 10:53:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1629, '2022-07-18 11:02:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1630, '2022-07-18 11:05:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1631, '2022-07-18 11:31:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1632, '2022-07-18 11:38:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1633, '2022-07-18 12:12:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1634, '2022-07-18 14:23:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1635, '2022-07-18 17:13:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1636, '2022-07-18 17:27:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1637, '2022-07-18 18:12:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1638, '2022-07-18 18:28:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1639, '2022-07-18 18:47:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1640, '2022-07-18 20:34:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1641, '2022-07-18 20:53:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1642, '2022-07-19 09:28:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1643, '2022-07-19 09:37:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1644, '2022-07-19 09:55:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1645, '2022-07-19 09:59:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1646, '2022-07-19 10:14:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1647, '2022-07-19 10:50:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1648, '2022-07-19 11:15:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1649, '2022-07-19 11:46:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1650, '2022-07-19 11:58:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1651, '2022-07-19 12:03:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1652, '2022-07-19 12:15:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1653, '2022-07-19 12:20:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1654, '2022-07-19 12:22:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1655, '2022-07-19 12:34:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1656, '2022-07-19 13:02:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1657, '2022-07-19 17:11:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1658, '2022-07-19 17:12:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1659, '2022-07-19 17:32:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1660, '2022-07-19 18:36:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1661, '2022-07-19 20:44:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1662, '2022-07-19 21:03:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1663, '2022-07-20 09:51:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1664, '2022-07-20 09:59:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1665, '2022-07-20 11:24:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1666, '2022-07-20 11:31:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1667, '2022-07-20 12:00:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1668, '2022-07-20 12:30:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1669, '2022-07-20 12:49:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1670, '2022-07-20 14:25:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1671, '2022-07-20 14:42:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1672, '2022-07-20 15:29:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1673, '2022-07-20 16:15:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1674, '2022-07-20 16:39:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1675, '2022-07-20 17:26:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1676, '2022-07-20 17:55:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1677, '2022-07-20 17:56:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1678, '2022-07-20 18:16:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1679, '2022-07-20 18:33:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1680, '2022-07-20 18:36:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1681, '2022-07-20 19:18:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1682, '2022-07-20 19:41:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1683, '2022-07-20 20:24:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1684, '2022-07-20 21:07:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1685, '2022-07-20 21:47:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1686, '2022-07-21 08:30:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1687, '2022-07-21 09:48:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1688, '2022-07-21 10:28:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1689, '2022-07-21 11:03:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1690, '2022-07-21 11:51:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1691, '2022-07-21 12:21:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1692, '2022-07-21 12:39:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1693, '2022-07-21 13:23:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1694, '2022-07-21 17:47:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1695, '2022-07-21 17:54:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1696, '2022-07-21 18:28:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1697, '2022-07-21 18:51:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1698, '2022-07-21 18:53:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1699, '2022-07-21 19:20:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1700, '2022-07-21 19:33:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1701, '2022-07-21 19:50:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1702, '2022-07-21 22:10:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1703, '2022-07-21 22:24:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1704, '2022-07-21 23:05:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1705, '2022-07-22 06:14:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1706, '2022-07-22 09:27:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1707, '2022-07-22 09:38:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1708, '2022-07-22 09:43:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1709, '2022-07-22 09:45:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1710, '2022-07-22 10:22:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1711, '2022-07-22 10:55:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1712, '2022-07-22 11:04:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1713, '2022-07-22 12:21:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1714, '2022-07-22 16:26:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1715, '2022-07-22 16:28:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1716, '2022-07-22 16:59:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1717, '2022-07-22 17:57:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1718, '2022-07-22 18:07:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1719, '2022-07-22 18:13:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1720, '2022-07-22 18:17:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1721, '2022-07-22 18:27:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1722, '2022-07-22 19:27:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1723, '2022-07-22 19:34:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1724, '2022-07-22 19:50:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1725, '2022-07-22 23:39:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1726, '2022-07-22 23:42:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1727, '2022-07-23 04:25:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1728, '2022-07-23 09:41:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1729, '2022-07-23 10:35:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1730, '2022-07-23 10:38:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1731, '2022-07-23 11:02:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1732, '2022-07-23 12:14:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1733, '2022-07-23 14:51:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1734, '2022-07-23 14:57:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1735, '2022-07-23 17:30:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1736, '2022-07-23 17:41:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1737, '2022-07-23 18:11:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1738, '2022-07-23 19:49:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1739, '2022-07-23 21:53:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1740, '2022-07-24 00:17:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1741, '2022-07-24 09:47:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1742, '2022-07-24 10:07:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1743, '2022-07-24 12:32:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1744, '2022-07-24 12:51:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1745, '2022-07-24 13:02:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1746, '2022-07-24 13:32:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1747, '2022-07-24 14:10:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1748, '2022-07-24 17:09:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1749, '2022-07-24 17:15:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1750, '2022-07-24 18:59:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1751, '2022-07-24 20:14:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1752, '2022-07-24 21:22:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1753, '2022-07-25 10:01:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1754, '2022-07-25 10:14:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1755, '2022-07-25 12:55:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1756, '2022-07-25 17:24:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1757, '2022-07-25 18:31:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1758, '2022-07-25 19:35:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1759, '2022-07-25 19:36:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1760, '2022-07-25 19:42:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1761, '2022-07-25 20:39:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1762, '2022-07-25 20:46:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1763, '2022-07-25 20:50:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1764, '2022-07-25 20:57:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1765, '2022-07-25 21:06:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1766, '2022-07-25 21:17:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1767, '2022-07-25 21:53:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1768, '2022-07-26 10:21:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1769, '2022-07-26 12:23:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1770, '2022-07-26 16:16:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1771, '2022-07-26 16:22:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1772, '2022-07-26 17:17:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1773, '2022-07-26 17:19:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1774, '2022-07-26 18:02:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1775, '2022-07-26 19:58:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1776, '2022-07-26 20:05:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1777, '2022-07-26 20:33:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1778, '2022-07-26 20:46:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1779, '2022-07-26 20:53:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1780, '2022-07-26 20:59:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1781, '2022-07-27 00:27:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1782, '2022-07-27 00:31:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1783, '2022-07-27 00:37:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1784, '2022-07-27 09:21:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1785, '2022-07-27 09:55:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1786, '2022-07-27 10:05:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1787, '2022-07-27 10:24:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1788, '2022-07-27 10:25:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1789, '2022-07-27 10:29:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1790, '2022-07-27 10:55:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1791, '2022-07-27 11:24:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1792, '2022-07-27 11:26:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1793, '2022-07-27 11:40:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1794, '2022-07-27 12:14:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1795, '2022-07-27 13:21:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1796, '2022-07-27 15:20:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1797, '2022-07-27 16:10:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1798, '2022-07-27 19:38:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1799, '2022-07-27 19:41:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1800, '2022-07-27 19:50:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1801, '2022-07-27 21:40:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1802, '2022-07-27 22:15:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1803, '2022-07-27 23:14:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1804, '2022-07-27 23:57:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1805, '2022-07-28 09:19:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1806, '2022-07-28 10:22:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1807, '2022-07-28 10:23:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1808, '2022-07-28 11:18:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1809, '2022-07-28 11:39:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1810, '2022-07-28 11:50:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1811, '2022-07-28 12:07:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1812, '2022-07-28 12:33:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1813, '2022-07-28 12:36:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1814, '2022-07-28 12:58:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1815, '2022-07-28 17:16:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1816, '2022-07-28 17:22:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1817, '2022-07-28 17:26:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1818, '2022-07-28 17:47:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1819, '2022-07-28 19:49:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1820, '2022-07-28 19:58:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1821, '2022-07-28 21:37:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1822, '2022-07-28 21:38:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1823, '2022-07-28 22:17:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1824, '2022-07-29 00:44:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1825, '2022-07-29 09:15:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1826, '2022-07-29 09:49:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1827, '2022-07-29 10:07:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1828, '2022-07-29 10:10:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1829, '2022-07-29 10:21:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1830, '2022-07-29 10:24:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1831, '2022-07-29 11:37:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1832, '2022-07-29 11:59:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1833, '2022-07-29 12:02:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1834, '2022-07-29 15:26:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1835, '2022-07-29 17:45:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1836, '2022-07-29 17:55:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1837, '2022-07-29 19:31:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1838, '2022-07-29 20:48:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1839, '2022-07-30 04:13:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1840, '2022-07-30 08:59:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1841, '2022-07-30 09:19:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1842, '2022-07-30 09:24:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1843, '2022-07-30 10:06:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1844, '2022-07-30 10:19:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1845, '2022-07-30 10:19:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1846, '2022-07-30 10:25:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1847, '2022-07-30 10:27:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1848, '2022-07-30 10:55:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1849, '2022-07-30 11:17:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1850, '2022-07-30 11:22:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1851, '2022-07-30 12:08:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1852, '2022-07-30 12:16:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1853, '2022-07-30 12:45:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1854, '2022-07-30 13:17:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1855, '2022-07-30 17:37:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1856, '2022-07-30 18:38:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1857, '2022-07-30 18:40:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1858, '2022-07-30 19:36:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1859, '2022-07-30 23:22:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1860, '2022-07-31 10:04:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1861, '2022-07-31 10:41:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1862, '2022-07-31 10:44:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1863, '2022-07-31 10:48:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1864, '2022-07-31 11:02:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1865, '2022-07-31 11:06:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1866, '2022-07-31 11:38:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1867, '2022-07-31 12:21:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1868, '2022-07-31 12:28:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1869, '2022-07-31 15:47:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1870, '2022-07-31 16:58:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1871, '2022-07-31 16:59:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1872, '2022-07-31 17:01:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1873, '2022-07-31 17:03:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1874, '2022-07-31 19:06:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1875, '2022-07-31 19:24:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1876, '2022-07-31 20:08:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1877, '2022-07-31 20:21:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1878, '2022-07-31 20:43:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1879, '2022-07-31 21:55:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1880, '2022-08-01 09:10:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1881, '2022-08-01 11:25:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1882, '2022-08-01 11:54:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1883, '2022-08-01 12:42:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1884, '2022-08-01 12:51:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1885, '2022-08-01 13:33:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1886, '2022-08-01 14:34:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1887, '2022-08-01 15:04:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1888, '2022-08-01 15:24:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1889, '2022-08-01 17:46:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1890, '2022-08-01 18:05:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1891, '2022-08-01 18:21:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1892, '2022-08-02 05:38:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1893, '2022-08-02 09:27:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1894, '2022-08-02 09:31:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1895, '2022-08-02 09:33:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1896, '2022-08-02 10:48:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1897, '2022-08-02 10:55:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1898, '2022-08-02 12:43:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1899, '2022-08-02 12:53:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1900, '2022-08-02 15:54:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1901, '2022-08-02 16:55:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1902, '2022-08-02 17:16:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1903, '2022-08-02 17:20:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1904, '2022-08-02 18:21:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1905, '2022-08-02 18:24:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1906, '2022-08-02 21:04:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1907, '2022-08-02 21:43:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1908, '2022-08-02 23:23:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1909, '2022-08-03 00:24:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1910, '2022-08-03 09:52:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1911, '2022-08-03 12:03:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1912, '2022-08-03 12:13:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1913, '2022-08-03 12:52:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1914, '2022-08-03 12:53:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1915, '2022-08-03 12:56:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1916, '2022-08-03 16:43:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1917, '2022-08-03 16:45:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1918, '2022-08-03 18:48:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1919, '2022-08-03 21:54:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1920, '2022-08-04 09:17:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1921, '2022-08-04 10:20:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1922, '2022-08-04 11:09:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1923, '2022-08-04 11:52:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1924, '2022-08-04 14:09:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1925, '2022-08-04 16:12:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1926, '2022-08-04 16:13:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1927, '2022-08-04 20:09:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1928, '2022-08-05 00:35:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1929, '2022-08-05 01:25:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1930, '2022-08-05 08:41:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1931, '2022-08-05 09:02:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1932, '2022-08-05 10:22:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1933, '2022-08-05 16:01:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1934, '2022-08-05 16:12:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1935, '2022-08-05 17:15:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1936, '2022-08-05 18:08:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1937, '2022-08-05 20:00:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1938, '2022-08-05 20:22:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1939, '2022-08-06 00:06:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1940, '2022-08-06 03:32:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1941, '2022-08-06 05:23:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1942, '2022-08-06 11:24:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1943, '2022-08-06 11:56:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1944, '2022-08-06 12:24:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1945, '2022-08-06 12:36:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1946, '2022-08-06 13:57:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1947, '2022-08-06 17:53:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1948, '2022-08-06 18:38:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1949, '2022-08-07 11:42:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1950, '2022-08-07 21:06:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1951, '2022-08-08 07:24:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1952, '2022-08-08 08:13:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1953, '2022-08-08 08:25:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1954, '2022-08-08 09:16:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1955, '2022-08-08 09:35:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1956, '2022-08-08 09:36:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1957, '2022-08-08 10:02:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1958, '2022-08-08 10:31:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1959, '2022-08-08 11:29:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1960, '2022-08-08 11:36:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1961, '2022-08-08 12:04:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1962, '2022-08-08 12:12:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1963, '2022-08-08 12:48:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1964, '2022-08-08 15:49:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1965, '2022-08-08 17:25:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1966, '2022-08-08 18:34:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1967, '2022-08-08 19:11:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1968, '2022-08-08 19:15:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1969, '2022-08-08 19:16:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1970, '2022-08-08 19:17:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1971, '2022-08-08 19:35:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1972, '2022-08-08 23:53:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1973, '2022-08-09 00:21:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1974, '2022-08-09 09:13:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1975, '2022-08-09 10:33:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1976, '2022-08-09 10:36:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1977, '2022-08-09 10:41:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1978, '2022-08-09 10:53:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1979, '2022-08-09 10:56:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1980, '2022-08-09 11:25:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1981, '2022-08-09 11:41:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1982, '2022-08-09 11:56:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1983, '2022-08-09 13:36:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1984, '2022-08-09 17:21:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1985, '2022-08-09 17:45:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1986, '2022-08-09 18:02:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1987, '2022-08-09 18:31:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1988, '2022-08-09 18:56:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1989, '2022-08-09 18:58:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1990, '2022-08-10 11:26:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1991, '2022-08-10 12:49:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1992, '2022-08-10 12:50:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1993, '2022-08-10 13:31:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1994, '2022-08-10 17:42:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1995, '2022-08-10 17:58:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1996, '2022-08-10 18:02:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1997, '2022-08-10 18:11:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1998, '2022-08-10 18:26:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (1999, '2022-08-10 18:27:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2000, '2022-08-10 18:35:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2001, '2022-08-10 19:07:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2002, '2022-08-10 19:22:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2003, '2022-08-10 19:26:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2004, '2022-08-10 19:30:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2005, '2022-08-10 19:32:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2006, '2022-08-10 19:49:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2007, '2022-08-10 20:02:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2008, '2022-08-10 20:55:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2009, '2022-08-10 21:01:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2010, '2022-08-11 06:45:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2011, '2022-08-11 08:03:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2012, '2022-08-11 09:19:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2013, '2022-08-11 10:32:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2014, '2022-08-11 10:50:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2015, '2022-08-11 10:54:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2016, '2022-08-11 11:40:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2017, '2022-08-11 17:16:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2018, '2022-08-11 18:41:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2019, '2022-08-11 20:09:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2020, '2022-08-12 00:56:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2021, '2022-08-12 08:58:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2022, '2022-08-12 09:25:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2023, '2022-08-12 09:28:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2024, '2022-08-12 11:05:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2025, '2022-08-12 11:27:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2026, '2022-08-12 12:30:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2027, '2022-08-12 17:07:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2028, '2022-08-12 19:23:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2029, '2022-08-13 00:09:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2030, '2022-08-13 01:47:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2031, '2022-08-13 10:19:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2032, '2022-08-13 11:03:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2033, '2022-08-13 11:08:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2034, '2022-08-13 13:54:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2035, '2022-08-13 17:27:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2036, '2022-08-13 18:13:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2037, '2022-08-13 18:27:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2038, '2022-08-13 19:18:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2039, '2022-08-13 19:19:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2040, '2022-08-13 19:42:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2041, '2022-08-13 19:55:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2042, '2022-08-13 20:18:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2043, '2022-08-13 21:08:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2044, '2022-08-13 23:06:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2045, '2022-08-14 01:30:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2046, '2022-08-14 12:27:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2047, '2022-08-14 13:36:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2048, '2022-08-14 14:57:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2049, '2022-08-14 16:14:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2050, '2022-08-14 21:58:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2051, '2022-08-15 09:28:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2052, '2022-08-15 11:04:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2053, '2022-08-15 11:23:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2054, '2022-08-15 11:40:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2055, '2022-08-15 11:45:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2056, '2022-08-15 11:47:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2057, '2022-08-15 11:58:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2058, '2022-08-15 12:04:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2059, '2022-08-15 12:45:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2060, '2022-08-15 15:23:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2061, '2022-08-15 17:11:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2062, '2022-08-15 19:18:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2063, '2022-08-15 22:09:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2064, '2022-08-15 22:23:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2065, '2022-08-16 04:17:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2066, '2022-08-16 08:14:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2067, '2022-08-16 10:14:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2068, '2022-08-16 10:59:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2069, '2022-08-16 11:01:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2070, '2022-08-16 11:02:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2071, '2022-08-16 11:03:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2072, '2022-08-16 11:09:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2073, '2022-08-16 11:17:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2074, '2022-08-16 11:29:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2075, '2022-08-16 11:33:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2076, '2022-08-16 11:39:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2077, '2022-08-16 12:20:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2078, '2022-08-16 12:26:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2079, '2022-08-16 13:10:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2080, '2022-08-16 16:23:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2081, '2022-08-16 17:39:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2082, '2022-08-16 18:16:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2083, '2022-08-16 18:28:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2084, '2022-08-16 19:34:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2085, '2022-08-16 19:36:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2086, '2022-08-16 19:37:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2087, '2022-08-16 19:38:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2088, '2022-08-16 19:46:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2089, '2022-08-16 21:31:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2090, '2022-08-17 09:29:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2091, '2022-08-17 09:46:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2092, '2022-08-17 10:00:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2093, '2022-08-17 10:01:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2094, '2022-08-17 10:01:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2095, '2022-08-17 10:22:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2096, '2022-08-17 11:10:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2097, '2022-08-17 11:20:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2098, '2022-08-17 12:07:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2099, '2022-08-17 12:48:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2100, '2022-08-17 13:37:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2101, '2022-08-17 16:25:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2102, '2022-08-17 18:13:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2103, '2022-08-17 18:14:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2104, '2022-08-17 18:23:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2105, '2022-08-17 18:41:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2106, '2022-08-17 18:44:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2107, '2022-08-17 20:12:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2108, '2022-08-17 21:20:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2109, '2022-08-17 23:25:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2110, '2022-08-18 00:22:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2111, '2022-08-18 08:49:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2112, '2022-08-18 09:28:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2113, '2022-08-18 09:59:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2114, '2022-08-18 10:25:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2115, '2022-08-18 10:37:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2116, '2022-08-18 10:44:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2117, '2022-08-18 10:59:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2118, '2022-08-18 11:46:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2119, '2022-08-18 11:52:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2120, '2022-08-18 11:55:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2121, '2022-08-18 12:20:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2122, '2022-08-18 12:27:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2123, '2022-08-18 12:37:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2124, '2022-08-18 13:05:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2125, '2022-08-18 17:47:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2126, '2022-08-18 18:26:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2127, '2022-08-18 18:54:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2128, '2022-08-18 19:20:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2129, '2022-08-18 19:58:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2130, '2022-08-18 20:18:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2131, '2022-08-18 22:03:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2132, '2022-08-19 13:00:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2133, '2022-08-19 13:06:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2134, '2022-08-19 13:16:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2135, '2022-08-19 13:53:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2136, '2022-08-19 13:57:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2137, '2022-08-19 14:16:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2138, '2022-08-19 16:57:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2139, '2022-08-19 17:02:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2140, '2022-08-19 17:05:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2141, '2022-08-19 17:07:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2142, '2022-08-19 17:08:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2143, '2022-08-19 17:08:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2144, '2022-08-19 17:37:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2145, '2022-08-19 18:13:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2146, '2022-08-19 18:29:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2147, '2022-08-19 18:44:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2148, '2022-08-19 22:17:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2149, '2022-08-19 22:19:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2150, '2022-08-20 00:34:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2151, '2022-08-20 01:50:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2152, '2022-08-20 02:18:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2153, '2022-08-20 10:05:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2154, '2022-08-20 10:56:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2155, '2022-08-20 11:04:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2156, '2022-08-20 11:17:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2157, '2022-08-20 11:18:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2158, '2022-08-20 12:04:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2159, '2022-08-20 12:16:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2160, '2022-08-20 17:31:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2161, '2022-08-20 18:34:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2162, '2022-08-20 18:40:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2163, '2022-08-20 19:12:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2164, '2022-08-20 19:27:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2165, '2022-08-20 20:12:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2166, '2022-08-21 07:48:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2167, '2022-08-21 11:04:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2168, '2022-08-21 11:06:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2169, '2022-08-21 11:49:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2170, '2022-08-21 17:12:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2171, '2022-08-21 19:23:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2172, '2022-08-21 19:51:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2173, '2022-08-21 22:38:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2174, '2022-08-22 09:38:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2175, '2022-08-22 11:48:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2176, '2022-08-22 17:54:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2177, '2022-08-22 18:10:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2178, '2022-08-22 18:50:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2179, '2022-08-22 19:08:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2180, '2022-08-23 10:12:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2181, '2022-08-23 10:48:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2182, '2022-08-23 11:41:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2183, '2022-08-23 11:44:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2184, '2022-08-23 11:58:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2185, '2022-08-23 12:13:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2186, '2022-08-23 13:11:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2187, '2022-08-23 13:31:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2188, '2022-08-23 14:16:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2189, '2022-08-23 16:56:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2190, '2022-08-23 17:04:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2191, '2022-08-23 17:04:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2192, '2022-08-23 17:05:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2193, '2022-08-23 17:56:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2194, '2022-08-23 18:43:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2195, '2022-08-23 23:41:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2196, '2022-08-24 10:13:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2197, '2022-08-24 10:20:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2198, '2022-08-24 10:20:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2199, '2022-08-24 10:21:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2200, '2022-08-24 11:06:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2201, '2022-08-24 11:11:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2202, '2022-08-24 11:14:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2203, '2022-08-24 11:15:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2204, '2022-08-24 12:29:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2205, '2022-08-24 14:55:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2206, '2022-08-24 15:33:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2207, '2022-08-24 17:27:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2208, '2022-08-24 18:10:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2209, '2022-08-24 21:10:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2210, '2022-08-25 10:12:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2211, '2022-08-25 10:18:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2212, '2022-08-25 10:22:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2213, '2022-08-25 10:27:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2214, '2022-08-25 10:34:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2215, '2022-08-25 10:58:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2216, '2022-08-25 11:30:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2217, '2022-08-25 11:35:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2218, '2022-08-25 11:40:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2219, '2022-08-25 12:20:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2220, '2022-08-25 12:32:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2221, '2022-08-25 12:54:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2222, '2022-08-25 13:24:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2223, '2022-08-25 13:26:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2224, '2022-08-25 13:31:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2225, '2022-08-25 14:09:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2226, '2022-08-25 16:19:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2227, '2022-08-25 16:44:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2228, '2022-08-25 17:00:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2229, '2022-08-25 17:35:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2230, '2022-08-25 17:37:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2231, '2022-08-25 17:47:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2232, '2022-08-25 17:57:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2233, '2022-08-25 18:00:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2234, '2022-08-25 18:37:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2235, '2022-08-25 21:34:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2236, '2022-08-26 00:06:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2237, '2022-08-26 10:25:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2238, '2022-08-26 10:35:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2239, '2022-08-26 10:39:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2240, '2022-08-26 10:43:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2241, '2022-08-26 10:47:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2242, '2022-08-26 11:17:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2243, '2022-08-26 11:37:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2244, '2022-08-26 12:04:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2245, '2022-08-26 12:39:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2246, '2022-08-26 17:11:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2247, '2022-08-26 17:31:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2248, '2022-08-26 18:10:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2249, '2022-08-26 20:20:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2250, '2022-08-26 20:32:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2251, '2022-08-27 11:08:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2252, '2022-08-27 11:58:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2253, '2022-08-27 17:19:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2254, '2022-08-27 19:41:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2255, '2022-08-27 21:33:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2256, '2022-08-27 23:10:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2257, '2022-08-28 09:42:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2258, '2022-08-28 14:44:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2259, '2022-08-28 19:23:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2260, '2022-08-28 20:57:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2261, '2022-08-28 22:34:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2262, '2022-08-29 09:14:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2263, '2022-08-29 10:40:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2264, '2022-08-29 11:04:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2265, '2022-08-29 14:42:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2266, '2022-08-29 15:18:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2267, '2022-08-29 17:26:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2268, '2022-08-29 18:09:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2269, '2022-08-29 18:30:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2270, '2022-08-29 19:01:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2271, '2022-08-29 21:22:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2272, '2022-08-30 00:22:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2273, '2022-08-30 10:19:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2274, '2022-08-30 10:19:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2275, '2022-08-30 11:20:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2276, '2022-08-30 11:58:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2277, '2022-08-30 12:21:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2278, '2022-08-30 12:24:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2279, '2022-08-30 12:29:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2280, '2022-08-30 12:30:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2281, '2022-08-30 13:11:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2282, '2022-08-30 15:45:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2283, '2022-08-30 17:01:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2284, '2022-08-30 17:35:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2285, '2022-08-30 18:09:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2286, '2022-08-30 19:06:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2287, '2022-08-31 10:36:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2288, '2022-08-31 12:38:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2289, '2022-08-31 14:40:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2290, '2022-08-31 18:20:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2291, '2022-09-01 10:37:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2292, '2022-09-01 11:23:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2293, '2022-09-01 13:44:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2294, '2022-09-01 14:11:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2295, '2022-09-01 17:56:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2296, '2022-09-01 18:06:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2297, '2022-09-01 18:36:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2298, '2022-09-01 18:43:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2299, '2022-09-01 19:20:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2300, '2022-09-01 19:21:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2301, '2022-09-01 20:35:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2302, '2022-09-01 20:36:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2303, '2022-09-01 20:36:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2304, '2022-09-02 09:57:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2305, '2022-09-02 16:36:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2306, '2022-09-02 17:27:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2307, '2022-09-02 17:34:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2308, '2022-09-02 20:07:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2309, '2022-09-02 20:08:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2310, '2022-09-03 10:17:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2311, '2022-09-03 11:06:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2312, '2022-09-03 11:25:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2313, '2022-09-03 12:16:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2314, '2022-09-03 16:03:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2315, '2022-09-03 17:14:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2316, '2022-09-03 20:26:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2317, '2022-09-04 21:16:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2318, '2022-09-04 22:20:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2319, '2022-09-05 00:37:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2320, '2022-09-05 01:19:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2321, '2022-09-05 02:04:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2322, '2022-09-05 06:57:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2323, '2022-09-05 07:31:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2324, '2022-09-05 10:40:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2325, '2022-09-05 11:37:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2326, '2022-09-05 11:50:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2327, '2022-09-05 12:14:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2328, '2022-09-05 18:05:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2329, '2022-09-06 09:00:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2330, '2022-09-06 09:20:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2331, '2022-09-06 09:27:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2332, '2022-09-06 11:42:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2333, '2022-09-06 11:43:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2334, '2022-09-06 12:04:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2335, '2022-09-06 12:12:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2336, '2022-09-06 16:49:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2337, '2022-09-06 17:11:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2338, '2022-09-06 20:26:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2339, '2022-09-06 21:01:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2340, '2022-09-07 04:28:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2341, '2022-09-07 09:35:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2342, '2022-09-07 09:39:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2343, '2022-09-07 09:40:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2344, '2022-09-07 10:36:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2345, '2022-09-07 11:30:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2346, '2022-09-07 12:22:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2347, '2022-09-07 14:03:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2348, '2022-09-07 14:35:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2349, '2022-09-07 18:57:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2350, '2022-09-07 19:01:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2351, '2022-09-07 19:02:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2352, '2022-09-07 19:22:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2353, '2022-09-07 20:32:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2354, '2022-09-08 08:13:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2355, '2022-09-08 08:15:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2356, '2022-09-08 10:48:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2357, '2022-09-08 11:33:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2358, '2022-09-08 11:52:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2359, '2022-09-08 12:05:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2360, '2022-09-08 12:17:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2361, '2022-09-08 13:57:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2362, '2022-09-08 16:53:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2363, '2022-09-08 18:16:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2364, '2022-09-08 18:34:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2365, '2022-09-08 19:13:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2366, '2022-09-08 20:44:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2367, '2022-09-09 10:50:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2368, '2022-09-09 11:14:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2369, '2022-09-09 11:15:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2370, '2022-09-09 11:19:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2371, '2022-09-09 12:23:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2372, '2022-09-09 13:32:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2373, '2022-09-09 13:45:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2374, '2022-09-09 16:58:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2375, '2022-09-09 17:01:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2376, '2022-09-09 17:02:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2377, '2022-09-09 17:41:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2378, '2022-09-09 17:51:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2379, '2022-09-09 18:29:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2380, '2022-09-09 19:16:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2381, '2022-09-09 19:37:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2382, '2022-09-09 20:42:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2383, '2022-09-09 22:47:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2384, '2022-09-10 00:07:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2385, '2022-09-10 09:43:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2386, '2022-09-10 10:08:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2387, '2022-09-10 10:15:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2388, '2022-09-10 10:57:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2389, '2022-09-10 12:12:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2390, '2022-09-10 12:44:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2391, '2022-09-10 13:29:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2392, '2022-09-10 14:41:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2393, '2022-09-10 16:28:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2394, '2022-09-10 18:00:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2395, '2022-09-10 18:40:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2396, '2022-09-10 19:14:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2397, '2022-09-10 19:43:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2398, '2022-09-10 21:34:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2399, '2022-09-11 12:09:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2400, '2022-09-11 17:39:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2401, '2022-09-11 18:17:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2402, '2022-09-11 23:35:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2403, '2022-09-12 04:14:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2404, '2022-09-12 05:42:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2405, '2022-09-12 10:09:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2406, '2022-09-12 11:36:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2407, '2022-09-12 13:07:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2408, '2022-09-12 16:38:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2409, '2022-09-12 22:09:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2410, '2022-09-12 22:11:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2411, '2022-09-12 22:58:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2412, '2022-09-13 09:39:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2413, '2022-09-13 10:58:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2414, '2022-09-13 11:57:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2415, '2022-09-13 12:07:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2416, '2022-09-13 19:44:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2417, '2022-09-13 22:09:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2418, '2022-09-13 22:26:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2419, '2022-09-13 23:21:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2420, '2022-09-14 17:23:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2421, '2022-09-15 10:37:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2422, '2022-09-15 10:58:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2423, '2022-09-15 13:07:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2424, '2022-09-15 14:28:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2425, '2022-09-15 15:25:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2426, '2022-09-15 17:07:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2427, '2022-09-15 17:11:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2428, '2022-09-15 17:18:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2429, '2022-09-15 17:57:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2430, '2022-09-15 18:09:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2431, '2022-09-15 18:09:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2432, '2022-09-15 18:27:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2433, '2022-09-15 18:31:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2434, '2022-09-15 18:39:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2435, '2022-09-15 18:59:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2436, '2022-09-15 19:14:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2437, '2022-09-15 20:33:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2438, '2022-09-15 22:59:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2439, '2022-09-16 00:59:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2440, '2022-09-16 02:15:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2441, '2022-09-16 09:01:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2442, '2022-09-16 10:17:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2443, '2022-09-16 10:19:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2444, '2022-09-16 10:26:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2445, '2022-09-16 10:34:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2446, '2022-09-16 11:12:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2447, '2022-09-16 11:41:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2448, '2022-09-16 14:04:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2449, '2022-09-16 17:18:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2450, '2022-09-16 17:23:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2451, '2022-09-16 17:34:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2452, '2022-09-16 20:12:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2453, '2022-09-16 20:20:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2454, '2022-09-16 20:21:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2455, '2022-09-16 21:01:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2456, '2022-09-17 09:54:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2457, '2022-09-17 10:27:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2458, '2022-09-17 11:09:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2459, '2022-09-17 11:16:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2460, '2022-09-17 12:04:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2461, '2022-09-17 17:16:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2462, '2022-09-17 18:31:39');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text DEFAULT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) NOT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `updated_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (12, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '1_(5).png', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2022-01-17 09:53:59');


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_id` int(11) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `short_code` varchar(30) DEFAULT NULL,
  `is_default` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  CONSTRAINT `charge_categories_ibfk_1` FOREIGN KEY (`charge_type_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (2, 4, 'BIO-CHEMISTRY', '0\r\n', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (3, 4, 'CANCER MARKER', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (4, 4, 'CULTURE', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (5, 4, 'ELECTROLYTES', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (6, 4, 'HAEMATOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (7, 4, 'HEPATOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (8, 4, 'HISTOPATHOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (9, 4, 'HORMONE	', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (10, 4, 'IMMUNOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (11, 4, 'MICROBIOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (12, 4, 'PBF', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (13, 4, 'SEROLOGY/IMMUNOLOGY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (14, 4, 'STOOL EXAM', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (15, 4, 'URINE EXAM', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (16, 4, 'VIRAL MARKER', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (18, 2, 'Dr. Fees', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (19, 5, 'ULTRASOUND', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (20, 5, 'X-RAY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (21, 7, 'Ambulance Charge', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (22, 4, 'ENT SURGERY	', '0\r\n', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (23, 4, 'GENERAL SURGERY	', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (24, 4, 'Gynae', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (25, 4, 'MAJOR SURGERY', '0', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (26, 4, 'MINOR SURGERY', '0', NULL, '', '2022-01-13 00:06:56');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (27, 1, 'Selim Doctor online fees', 'Virtual Consultancy', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (28, 3, 'Admission', 'IPD', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (29, 3, 'Advance', 'Take advance from patient for IPD ', NULL, '', '2022-03-05 17:57:04');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (30, 1, 'Dr.Fees', 'Visiting fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (31, 2, 'Free Doctor Visit', 'No charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (32, 3, 'Bed', 'Ward and Cabin', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (33, 3, 'Doctor Round', 'Visit', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (34, 3, 'OT Charge', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (35, 11, 'Surgeon Fees', 'Surgeon', NULL, '', '2022-03-01 08:51:32');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (36, 11, 'Anesthesia', 'Anesthesia', NULL, '', '2022-03-01 08:54:29');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (37, 11, 'Assist fees', 'Assist ', NULL, '', '2022-03-01 08:59:27');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (38, 3, 'Service Charge', 'Service', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (39, 3, 'Dressings Charges', 'Dressings', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (40, 3, 'OT Charge2', 'OT ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (41, 3, 'OT Charge3', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (42, 11, 'Operations', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (43, 11, 'Operation2.5k', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (44, 11, 'Operation3k', 'OT', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (45, 12, 'Sewing Cutting', 'Sewing', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (46, 2, 'Emergency', 'eg', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (49, 2, 'Cannula Change', 'CC', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (50, 2, 'injection push', 'ip', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (51, 2, 'Nebulization Fees', 'NF', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (52, 2, 'Oxygen Fees', 'OF', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (53, 3, 'Cabin Charge', 'CC', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (54, 4, 'Urine Report', 'Full Urine test', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (55, 3, 'Doctor Round-Specialist ', 'dr-sp', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (56, 12, 'others', 'o', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (57, 3, 'Oxigen', 'ox', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (58, 5, 'ECG', 'ecg', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (59, 3, 'Package ', 'Package ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (60, 5, 'CT Scan', 'CT Scan', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (61, 5, 'Physiotherapy', 'ph', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (62, 1, 'Dr. Cap. Hosne Ara ', 'self', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (63, 1, 'Dr.Sumaiya', 'self', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (64, 1, 'Dr.Mahfuza Akter', 'self', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (65, 3, 'Photo Therapy', 'PT', NULL, '', NULL);


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (1, 'Appointment', 'yes', 'yes', '2021-09-24 20:10:32');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (2, 'OPD', 'yes', 'yes', '2021-09-24 20:10:02');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (3, 'IPD', 'yes', 'yes', '2021-09-24 20:10:47');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', 'yes', '2021-10-23 03:40:03');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (5, 'Radiology', 'yes', 'yes', '2021-10-23 04:10:21');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (6, 'Blood Bank', 'yes', 'yes', '2021-10-23 04:10:33');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (7, 'Ambulance', 'yes', 'yes', '2021-10-23 04:10:44');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (8, 'Procedures', 'yes', 'yes', '2018-08-17 19:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (9, 'Investigations', 'yes', 'yes', '2018-08-17 19:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (10, 'Supplier', 'yes', 'yes', '2018-08-17 19:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (11, 'Operations', 'yes', 'yes', '2018-08-17 19:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (12, 'Others', 'yes', 'yes', '2018-08-17 19:40:07');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int(11) DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_master_id` (`charge_type_master_id`),
  CONSTRAINT `charge_type_module_ibfk_1` FOREIGN KEY (`charge_type_master_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (2, 1, 'appointment', '2021-10-23 09:52:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (4, 2, 'opd', '2021-10-23 09:52:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (5, 3, 'ipd', '2021-10-23 09:52:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (6, 4, 'pathology', '2021-10-23 09:52:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (7, 5, 'radiology', '2021-10-23 09:52:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (8, 6, 'blood_bank', '2021-10-23 09:52:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (9, 7, 'ambulance', '2021-10-23 09:52:59');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (10, 8, 'opd', '2021-10-23 09:53:03');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (11, 8, 'ipd', '2021-10-23 09:53:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (13, 9, 'pathology', '2021-10-23 09:53:09');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (14, 9, 'radiology', '2021-10-23 09:53:11');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (15, 10, 'opd', '2021-10-23 09:53:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (16, 10, 'ipd', '2021-10-23 09:53:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (17, 11, 'opd', '2021-10-23 09:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (18, 11, 'ipd', '2021-10-23 09:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (19, 12, 'appointment', '2021-10-23 09:53:20');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (20, 12, 'opd', '2021-10-23 09:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (21, 12, 'ipd', '2021-10-23 09:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (24, 12, 'pathology', '2021-10-23 09:53:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (25, 12, 'radiology', '2021-10-23 09:53:27');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (26, 12, 'blood_bank', '2021-10-23 09:53:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (27, 12, 'ambulance', '2021-10-23 09:53:31');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, '0', 0, '2022-01-11 11:12:07');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (2, 'Tk.', 0, '2022-02-18 12:20:13');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_category_id` int(11) DEFAULT NULL,
  `tax_category_id` int(11) DEFAULT NULL,
  `charge_unit_id` int(10) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  CONSTRAINT `charges_ibfk_1` FOREIGN KEY (`charge_category_id`) REFERENCES `charge_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_2` FOREIGN KEY (`tax_category_id`) REFERENCES `tax_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_3` FOREIGN KEY (`charge_unit_id`) REFERENCES `charge_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=917 DEFAULT CHARSET=utf8;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (15, 2, 1, 1, '2 hrs after 75g Glucose', '150.00', NULL, '', '', '2022-01-11 13:08:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (16, 2, 1, 1, '2 hrs after breakfast', '150.00', NULL, '', '', '2022-01-11 13:12:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (17, 5, 1, 1, 'S. Electrolytes', '1000.00', NULL, '', '', '2022-01-11 13:36:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (18, 13, 1, 1, 'ASO Titre', '500.00', NULL, '', '', '2022-01-11 13:36:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (19, 10, 1, 1, 'Anti TB IgG', '1000.00', NULL, '', '', '2022-01-11 13:39:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (20, 10, 1, 1, 'Anti TB IgM', '1000.00', NULL, '', '', '2022-01-11 13:40:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (21, 10, 1, 1, 'Anti-TB IgA', '1000.00', NULL, '', '', '2022-01-11 13:42:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (22, 16, 1, 1, 'Anti DS DNA', '1000.00', NULL, '', '', '2022-01-11 13:42:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (23, 10, 1, 1, 'Antibody HSV IgG', '1000.00', NULL, '', '', '2022-01-11 13:43:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (24, 10, 1, 1, 'Antibody HSV IgM', '1000.00', NULL, '', '', '2022-01-11 13:44:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (25, 10, 1, 1, 'C3', '1000.00', NULL, '', '', '2022-01-11 13:45:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (26, 16, 1, 1, 'Anti HAV IgM', '800.00', NULL, '', '', '2022-01-11 13:47:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (27, 10, 1, 1, 'CA-125', '1500.00', NULL, '', '', '2022-01-11 13:47:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (28, 10, 1, 1, 'CFT for Filaria', '1000.00', NULL, '', '', '2022-01-11 13:49:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (29, 13, 1, 1, 'Anti Dengue IgG', '1200.00', NULL, '', '', '2022-01-11 13:50:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (30, 10, 1, 1, 'CFT for Kala-Azar', '1000.00', NULL, '', '', '2022-01-11 13:52:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (31, 16, 1, 1, 'Anti HBc/IgM', '800.00', NULL, '', '', '2022-01-11 13:53:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (32, 13, 1, 1, 'Anti Dengue IgM', '1200.00', NULL, '', '', '2022-01-11 13:53:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (33, 10, 1, 1, 'Dengue IgM IgG', '500.00', NULL, '', '', '2022-01-11 13:53:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (34, 2, 1, 1, '2 hrs after dinner', '200.00', NULL, '', '', '2022-01-11 13:54:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (35, 10, 1, 1, 'ICT for Malaria', '1000.00', NULL, '', '', '2022-01-11 13:55:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (36, 16, 1, 1, 'Anti HBe (HBe Ab)', '800.00', NULL, '', '', '2022-01-11 13:55:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (37, 2, 1, 1, '2 hrs after lunch', '200.00', NULL, '', '', '2022-01-11 13:56:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (38, 13, 1, 1, 'Anti H-Pylory', '700.00', NULL, '', '', '2022-01-11 13:56:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (39, 10, 1, 1, 'MT (Mantoux Test)', '300.00', NULL, '', '', '2022-01-11 14:01:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (40, 13, 1, 1, 'Anti- HIV (1+2)', '1000.00', NULL, '', '', '2022-01-11 14:04:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (41, 10, 1, 1, 'Rubela for IgM', '2000.00', NULL, '', '', '2022-01-11 14:04:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (42, 16, 1, 1, 'Anti HBs Ab', '800.00', NULL, '', '', '2022-01-11 14:04:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (43, 2, 1, 1, '2 hrs before dinner', '200.00', NULL, '', '', '2022-01-11 14:05:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (44, 13, 1, 1, 'B.T.C.T', '500.00', NULL, '', '', '2022-01-11 14:05:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (45, 10, 1, 1, 'S. IgE', '1200.00', NULL, '', '', '2022-01-11 14:05:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (46, 13, 1, 1, 'Blood group', '150.00', NULL, '', '', '2022-01-11 14:06:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (47, 2, 1, 1, '2 hrs before lunch', '200.00', NULL, '', '', '2022-01-11 14:06:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (48, 16, 1, 1, 'Anti HCV', '600.00', NULL, '', '', '2022-01-11 14:07:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (49, 10, 1, 1, 'TB for ICT', '1000.00', NULL, '', '', '2022-01-11 14:07:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (50, 2, 1, 1, '24 Hours UTV, UTP, CCR', '1000.00', NULL, '', '', '2022-01-11 14:07:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (51, 13, 1, 1, 'C4', '1000.00', NULL, '', '', '2022-01-11 14:07:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (52, 2, 1, 1, 'ACR (Albumin Creatinine Ratio)', '800.00', NULL, '', '', '2022-01-11 14:08:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (53, 15, 1, 1, 'Bile pigment', '100.00', NULL, '', '', '2022-01-11 14:09:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (54, 13, 1, 1, 'CRP', '500.00', NULL, '', '', '2022-01-11 14:09:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (55, 16, 1, 1, 'Anti HEV IgG', '1000.00', NULL, '', '', '2022-01-11 14:10:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (56, 2, 1, 1, 'ACTH', '1000.00', NULL, '', '', '2022-01-11 14:10:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (57, 13, 1, 1, 'Cross Matching', '500.00', NULL, '', '', '2022-01-11 14:10:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (58, 15, 1, 1, 'Bile salt', '100.00', NULL, '', '', '2022-01-11 14:10:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (59, 2, 1, 1, 'AFP', '1000.00', NULL, '', '', '2022-01-11 14:11:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (60, 13, 1, 1, 'Cross Matching (Divice)', '1200.00', NULL, '', '', '2022-01-11 14:11:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (61, 15, 1, 1, 'Pregnancy test', '200.00', NULL, '', '', '2022-01-11 14:11:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (62, 2, 1, 1, 'APTT', '1500.00', NULL, '', '', '2022-01-11 14:12:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (63, 16, 1, 1, 'Anti HEV IgM', '1000.00', NULL, '', '', '2022-01-11 14:13:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (64, 13, 1, 1, 'Cross Matching with (Screeing ,VDRL, HBsAg , HIV, HCV)', '1600.00', NULL, '', '', '2022-01-11 14:13:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (65, 15, 1, 1, 'URINE FOR SP. GRAVITY', '100.00', NULL, '', '', '2022-01-11 14:13:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (66, 13, 1, 1, 'Febrile Antigen', '1200.00', NULL, '', '', '2022-01-11 14:14:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (67, 16, 1, 1, 'Beta hCG', '1000.00', NULL, '', '', '2022-01-11 14:14:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (68, 13, 1, 1, 'HBcAg', '1000.00', NULL, '', '', '2022-01-11 14:15:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (69, 15, 1, 1, 'Urine  Albumin', '200.00', NULL, '', '', '2022-01-11 14:15:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (70, 15, 1, 1, 'Urine  R/E', '200.00', NULL, '', '', '2022-01-11 14:16:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (71, 16, 1, 1, 'HBV-DNA (PCR)', '9500.00', NULL, '', '', '2022-01-11 14:16:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (72, 13, 1, 1, 'HBsAg (Screening)', '500.00', NULL, '', '', '2022-01-11 14:16:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (73, 2, 1, 1, 'Ag Ratio', '1000.00', NULL, '', '', '2022-01-11 14:16:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (74, 15, 1, 1, 'Urine Electrolytes', '1000.00', NULL, '', '', '2022-01-11 14:17:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (75, 16, 1, 1, 'HCV-RNA (PCR)', '13500.00', NULL, '', '', '2022-01-11 14:17:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (76, 13, 1, 1, 'HCG/PT', '200.00', NULL, '', '', '2022-01-11 14:17:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (77, 2, 1, 1, 'Anti CCP Antibody', '2000.00', NULL, '', '', '2022-01-11 14:17:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (78, 13, 1, 1, 'HIV', '500.00', NULL, '', '', '2022-01-11 14:17:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (79, 15, 1, 1, 'Urine Ketone Body', '200.00', NULL, '', '', '2022-01-11 14:18:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (80, 2, 1, 1, 'Anti CCP IgG', '1400.00', NULL, '', '', '2022-01-11 14:19:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (81, 13, 1, 1, 'NS-1 Antigen', '500.00', NULL, '', '', '2022-01-11 14:19:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (82, 15, 1, 1, 'Urine Sugar', '100.00', NULL, '', '', '2022-01-11 14:19:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (83, 2, 1, 1, 'BUN', '300.00', NULL, '', '', '2022-01-11 14:20:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (84, 13, 1, 1, 'RA test', '500.00', NULL, '', '', '2022-01-11 14:20:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (85, 15, 1, 1, 'Urine for Benzodiazepines', '1000.00', NULL, '', '', '2022-01-11 14:20:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (86, 2, 1, 1, 'Blood Urea', '500.00', NULL, '', '', '2022-01-11 14:20:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (87, 13, 1, 1, 'RF', '400.00', NULL, '', '', '2022-01-11 14:21:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (88, 15, 1, 1, 'Urine for Cannabinodies', '1000.00', NULL, '', '', '2022-01-11 14:21:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (89, 2, 1, 1, 'CCR', '800.00', NULL, '', '', '2022-01-11 14:21:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (90, 13, 1, 1, 'Rose-Waaler test', '600.00', NULL, '', '', '2022-01-11 14:21:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (91, 15, 1, 1, 'Urine for haemoglobin', '200.00', NULL, '', '', '2022-01-11 14:22:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (92, 14, 1, 1, 'Stool  Reducing Substance', '500.00', NULL, '', '', '2022-01-11 14:22:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (93, 2, 1, 1, 'CK-MB', '700.00', NULL, '', '', '2022-01-11 14:22:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (94, 13, 1, 1, 'Semen Analysis', '700.00', NULL, '', '', '2022-01-11 14:22:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (95, 13, 1, 1, 'TPHA', '500.00', NULL, '', '', '2022-01-11 14:23:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (96, 2, 1, 1, 'CPK', '1200.00', NULL, '', '', '2022-01-11 14:24:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (97, 15, 1, 1, 'Urine for opoids', '1000.00', NULL, '', '', '2022-01-11 14:24:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (98, 13, 1, 1, 'Torch Anti Body', '1200.00', NULL, '', '', '2022-01-11 14:24:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (99, 14, 1, 1, 'Stool OBT', '500.00', NULL, '', '', '2022-01-11 14:24:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (100, 2, 1, 1, 'CSF For Albumin', '300.00', NULL, '', '', '2022-01-11 14:24:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (101, 13, 1, 1, 'VDRL', '500.00', NULL, '', '', '2022-01-11 14:25:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (102, 14, 1, 1, 'Stool R/E', '500.00', NULL, '', '', '2022-01-11 14:25:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (103, 2, 1, 1, 'CSF For HDL', '500.00', NULL, '', '', '2022-01-11 14:25:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (104, 12, 1, 1, 'PBF (Peripheral blood film)', '200.00', NULL, '', '', '2022-01-11 14:25:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (105, 2, 1, 1, 'CSF For Protein', '300.00', NULL, '', '', '2022-01-11 14:26:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (106, 13, 1, 1, 'VDRL (Q+Q)', '400.00', NULL, '', '', '2022-01-11 14:26:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (107, 13, 1, 1, 'Widal test', '500.00', NULL, '', '', '2022-01-11 14:27:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (108, 3, 1, 1, 'CA-15.3', '1000.00', NULL, '', '', '2022-01-11 14:28:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (109, 2, 1, 1, 'CSF For Sugar', '120.00', NULL, '', '', '2022-01-11 14:29:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (110, 4, 1, 1, 'Blood C/S', '2500.00', NULL, '', '', '2022-01-11 14:29:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (111, 3, 1, 1, 'CA-19.9', '1500.00', NULL, '', '', '2022-01-11 14:29:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (112, 2, 1, 1, 'FBS', '100.00', NULL, '', '', '2022-01-11 14:30:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (113, 11, 1, 1, 'Clot Culture (salmonella inf.)', '350.00', NULL, '', '', '2022-01-11 14:30:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (114, 4, 1, 1, 'CSF R/E /S', '600.00', NULL, '', '', '2022-01-11 14:31:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (115, 2, 1, 1, 'fasting Lipid Profile', '1000.00', NULL, '', '', '2022-01-11 14:31:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (116, 3, 1, 1, 'CEA', '1200.00', NULL, '', '', '2022-01-11 14:31:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (117, 2, 1, 1, 'Ferritine', '900.00', NULL, '', '', '2022-01-11 14:31:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (118, 11, 1, 1, 'Endocervical swab for gram stain', '200.00', NULL, '', '', '2022-01-11 14:31:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (119, 4, 1, 1, 'Conjunctival swab C/S', '300.00', NULL, '', '', '2022-01-11 14:32:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (120, 2, 1, 1, 'GTT', '360.00', NULL, '', '', '2022-01-11 14:32:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (121, 2, 1, 1, 'Gamma GT', '500.00', NULL, '', '', '2022-01-11 22:35:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (122, 2, 1, 1, 'Globulin', '1000.00', NULL, '', '', '2022-01-11 23:44:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (123, 2, 1, 1, 'H. Pylori', '800.00', NULL, '', '', '2022-01-11 23:45:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (124, 11, 1, 1, 'FNAC', '1500.00', NULL, '', '', '2022-01-11 23:46:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (125, 2, 1, 1, 'HDL', '500.00', NULL, '', '', '2022-01-11 23:47:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (126, 11, 1, 1, 'FNAC Collection', '500.00', NULL, '', '', '2022-01-11 23:48:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (127, 2, 1, 1, 'HbA1C', '1000.00', NULL, '', '', '2022-01-11 23:49:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (128, 11, 1, 1, 'Gastric Level aspirate (3 Sample)', '400.00', NULL, '', '', '2022-01-11 23:50:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (129, 3, 1, 1, 'Cytology', '500.00', NULL, '', '', '2022-01-11 23:50:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (130, 2, 1, 1, 'Iron', '600.00', NULL, '', '', '2022-01-11 23:50:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (131, 11, 1, 1, 'Gramstain', '200.00', NULL, '', '', '2022-01-11 23:50:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (132, 11, 1, 1, 'HVS for Gram Stain', '200.00', NULL, '', '', '2022-01-11 23:51:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (133, 11, 1, 1, 'HVS for R/E', '200.00', NULL, '', '', '2022-01-11 23:52:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (134, 11, 1, 1, 'MT (Mantoux Test)', '500.00', NULL, '', '', '2022-01-11 23:53:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (135, 3, 1, 1, 'PSA', '700.00', NULL, '', '', '2022-01-11 23:56:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (136, 11, 1, 1, 'Malignant Cell', '800.00', NULL, '', '', '2022-01-11 23:57:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (137, 11, 1, 1, 'Prostatic smear R/E', '200.00', NULL, '', '', '2022-01-11 23:57:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (138, 2, 1, 1, 'L.F.T (Liver Function Test with)', '1500.00', NULL, '', '', '2022-01-11 23:57:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (139, 3, 1, 1, 'PSA ( Elisa)', '1200.00', NULL, '', '', '2022-01-11 23:58:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (140, 11, 1, 1, 'Prostatic smear gram stain', '200.00', NULL, '', '', '2022-01-11 23:58:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (141, 3, 1, 1, 'Pap smear', '900.00', NULL, '', '', '2022-01-11 23:59:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (142, 11, 1, 1, 'Skin Scraping   R/E', '200.00', NULL, '', '', '2022-01-11 23:59:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (143, 11, 1, 1, 'Skin Scraping for Fungus', '800.00', NULL, '', '', '2022-01-11 23:59:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (144, 11, 1, 1, 'Sputum AFB', '200.00', NULL, '', '', '2022-01-12 00:00:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (145, 7, 1, 1, 'Anti HBs', '800.00', NULL, '', '', '2022-01-12 00:00:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (146, 11, 1, 1, 'Sputum AFB 2 samples', '400.00', NULL, '', '', '2022-01-12 00:01:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (147, 11, 1, 1, 'Sputum AFB 3 samples', '600.00', NULL, '', '', '2022-01-12 00:01:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (148, 7, 1, 1, 'Anti HcV', '600.00', NULL, '', '', '2022-01-12 00:02:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (149, 11, 1, 1, 'Sputum Gene Xpert', '4000.00', NULL, '', '', '2022-01-12 00:02:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (150, 11, 1, 1, 'Sputum for gramstain', '300.00', NULL, '', '', '2022-01-12 00:03:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (151, 11, 1, 1, 'T/A for ABF Staining', '200.00', NULL, '', '', '2022-01-12 00:03:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (152, 7, 1, 1, 'HBe - ab', '1100.00', NULL, '', '', '2022-01-12 00:04:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (153, 11, 1, 1, 'Urethra smear R/E', '200.00', NULL, '', '', '2022-01-12 00:04:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (154, 11, 1, 1, 'Urothral for Gram  Stain', '200.00', NULL, '', '', '2022-01-12 00:04:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (155, 7, 1, 1, 'HBe Ag', '1100.00', NULL, '', '', '2022-01-12 00:05:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (156, 2, 1, 1, '\"SGPT,SGOT,S.Bilirubin,HBsAg) LDL\"', '500.00', NULL, '', '', '2022-01-12 00:07:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (157, 7, 1, 1, 'HBsAg (Confirmatory)', '500.00', NULL, '', '', '2022-01-12 00:07:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (158, 7, 1, 1, 'HBsAg (ELISA)', '1200.00', NULL, '', '', '2022-01-12 00:08:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (159, 4, 1, 1, 'Ear swab C/S', '800.00', NULL, '', '', '2022-01-12 00:08:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (160, 2, 1, 1, 'LDL Cholesterol', '300.00', NULL, '', '', '2022-01-12 00:10:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (161, 4, 1, 1, 'Endocervical swab C/S', '800.00', NULL, '', '', '2022-01-12 00:11:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (162, 2, 1, 1, 'Lipid Profile', '1000.00', NULL, '', '', '2022-01-12 00:11:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (163, 2, 1, 1, 'OGTT', '600.00', NULL, '', '', '2022-01-12 00:12:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (164, 6, 1, 1, 'BT', '250.00', NULL, '', '', '2022-01-12 00:12:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (165, 8, 1, 1, 'Histopathology', '1100.00', NULL, '', '', '2022-01-12 00:13:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (166, 6, 1, 1, 'BT.CT', '500.00', NULL, '', '', '2022-01-12 00:13:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (167, 4, 1, 1, 'Eye swab C/S', '800.00', NULL, '', '', '2022-01-12 00:13:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (168, 2, 1, 1, 'Pleural Fluid', '400.00', NULL, '', '', '2022-01-12 00:14:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (169, 6, 1, 1, 'CBC', '500.00', NULL, '', '', '2022-01-12 00:14:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (170, 2, 1, 1, 'Prothrombin time', '1200.00', NULL, '', '', '2022-01-12 00:15:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (171, 4, 1, 1, 'Finger Print for C/S', '600.00', NULL, '', '', '2022-01-12 00:15:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (172, 6, 1, 1, 'CEC', '300.00', NULL, '', '', '2022-01-12 00:15:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (173, 4, 1, 1, 'HVS C/S', '800.00', NULL, '', '', '2022-01-12 00:16:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (174, 2, 1, 1, 'RBS', '150.00', NULL, '', '', '2022-01-12 00:16:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (175, 6, 1, 1, 'CT', '250.00', NULL, '', '', '2022-01-12 00:16:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (176, 4, 1, 1, 'Nasal swab C/S', '800.00', NULL, '', '', '2022-01-12 00:17:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (177, 2, 1, 1, 'RBS (Random Blood Sugar)', '200.00', NULL, '', '', '2022-01-12 00:17:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (178, 9, 1, 1, 'ANA', '1500.00', NULL, '', '', '2022-01-12 00:18:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (179, 6, 1, 1, 'Coombs test', '400.00', NULL, '', '', '2022-01-12 00:18:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (180, 4, 1, 1, 'PAPS C/S', '800.00', NULL, '', '', '2022-01-12 00:19:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (181, 2, 1, 1, 'S. Albumin', '500.00', NULL, '', '', '2022-01-12 00:19:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (182, 6, 1, 1, 'DC', '150.00', NULL, '', '', '2022-01-12 00:20:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (183, 4, 1, 1, 'Prostatic smear C/S', '600.00', NULL, '', '', '2022-01-12 00:20:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (184, 2, 1, 1, 'S. Alkaline Phosphatase', '500.00', NULL, '', '', '2022-01-12 00:20:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (185, 4, 1, 1, 'Pus C/S', '800.00', NULL, '', '', '2022-01-12 00:21:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (186, 2, 1, 1, 'S. Amonia', '900.00', NULL, '', '', '2022-01-12 00:21:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (187, 6, 1, 1, 'ESR', '200.00', NULL, '', '', '2022-01-12 00:21:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (188, 2, 1, 1, 'S. Amylase', '800.00', NULL, '', '', '2022-01-12 00:22:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (189, 4, 1, 1, 'Skin Scraping for C/S', '600.00', NULL, '', '', '2022-01-12 00:22:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (190, 9, 1, 1, 'Anti Cardiolipin IgG', '1500.00', NULL, '', '', '2022-01-12 00:22:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (191, 6, 1, 1, 'ESR tube', '45.00', NULL, '', '', '2022-01-12 00:23:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (192, 2, 1, 1, 'S. Bilirubin (Direct.InDirect)', '1200.00', NULL, '', '', '2022-01-12 00:23:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (193, 4, 1, 1, 'Sputum C/S', '600.00', NULL, '', '', '2022-01-12 00:24:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (194, 9, 1, 1, 'Anti Cardiolipin IgM', '1500.00', NULL, '', '', '2022-01-12 00:24:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (195, 2, 1, 1, 'S. Bilirubin Direct', '600.00', NULL, '', '', '2022-01-12 00:24:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (196, 4, 1, 1, 'Stool C/S', '800.00', NULL, '', '', '2022-01-12 00:24:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (197, 6, 1, 1, 'Electrophroses', '1400.00', NULL, '', '', '2022-01-12 00:25:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (198, 9, 1, 1, 'Anti DNA', '1000.00', NULL, '', '', '2022-01-12 00:25:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (199, 2, 1, 1, 'S. Bilirubin Indirect', '600.00', NULL, '', '', '2022-01-12 00:25:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (200, 4, 1, 1, 'Swab C/S with Gram Stain', '300.00', NULL, '', '', '2022-01-12 00:25:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (201, 6, 1, 1, 'Hb', '200.00', NULL, '', '', '2022-01-12 00:26:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (202, 2, 1, 1, 'S. Billirubin', '500.00', NULL, '', '', '2022-01-12 00:26:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (203, 2, 1, 1, 'S. Calcium', '600.00', NULL, '', '', '2022-01-12 00:27:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (204, 4, 1, 1, 'T/A For C/S', '600.00', NULL, '', '', '2022-01-12 00:27:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (205, 9, 1, 1, 'Anti MPO(P-ANCA)', '1500.00', NULL, '', '', '2022-01-12 00:27:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (206, 2, 1, 1, 'S. Cholesterol', '500.00', NULL, '', '', '2022-01-12 00:28:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (207, 9, 1, 1, 'Anti PR-3 (C-ANCA)', '1500.00', NULL, '', '', '2022-01-12 00:28:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (208, 6, 1, 1, 'ICT for Kala-Azar', '600.00', NULL, '', '', '2022-01-12 00:28:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (209, 2, 1, 1, 'S. Creatinine', '500.00', NULL, '', '', '2022-01-12 00:29:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (210, 4, 1, 1, 'Throat Swab C/S', '800.00', NULL, '', '', '2022-01-12 00:29:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (211, 9, 1, 1, 'Anti Phospholipid Screen', '1200.00', NULL, '', '', '2022-01-12 00:29:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (212, 6, 1, 1, 'Kala Jor', '500.00', NULL, '', '', '2022-01-12 00:29:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (213, 2, 1, 1, 'S. Lipase', '1200.00', NULL, '', '', '2022-01-12 00:29:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (214, 4, 1, 1, 'Umbilical swab C/S', '800.00', NULL, '', '', '2022-01-12 00:29:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (215, 9, 1, 1, 'Anti thyroid Anti body', '2000.00', NULL, '', '', '2022-01-12 00:30:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (216, 2, 1, 1, 'S. Lipid Profile', '1000.00', NULL, '', '', '2022-01-12 00:30:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (217, 6, 1, 1, 'MP (ICT)', '500.00', NULL, '', '', '2022-01-12 00:30:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (218, 4, 1, 1, 'Urethra smear C/S', '800.00', NULL, '', '', '2022-01-12 00:31:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (219, 2, 1, 1, 'S. Magnessium', '600.00', NULL, '', '', '2022-01-12 00:31:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (220, 9, 1, 1, 'B-hcG', '1500.00', NULL, '', '', '2022-01-12 00:31:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (221, 6, 1, 1, 'MP (Slide)', '500.00', NULL, '', '', '2022-01-12 00:31:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (222, 4, 1, 1, 'Urine C/S', '1500.00', NULL, '', '', '2022-01-12 00:32:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (223, 2, 1, 1, 'S. Phosphate', '400.00', NULL, '', '', '2022-01-12 00:32:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (224, 9, 1, 1, 'Cortisol', '1000.00', NULL, '', '', '2022-01-12 00:32:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (225, 6, 1, 1, 'PBF', '500.00', NULL, '', '', '2022-01-12 00:33:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (226, 4, 1, 1, 'Wound swab C/S', '600.00', NULL, '', '', '2022-01-12 00:33:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (227, 2, 1, 1, 'S. Total Acid Phosphate', '500.00', NULL, '', '', '2022-01-12 00:33:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (228, 9, 1, 1, 'D-Dimer', '1200.00', NULL, '', '', '2022-01-12 00:33:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (229, 6, 1, 1, 'PCV/HCT', '500.00', NULL, '', '', '2022-01-12 00:34:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (230, 2, 1, 1, 'S. Total Protein', '300.00', NULL, '', '', '2022-01-12 00:34:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (231, 9, 1, 1, 'Estrodiol', '1500.00', NULL, '', '', '2022-01-12 00:34:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (232, 6, 1, 1, 'Platelet count', '300.00', NULL, '', '', '2022-01-12 00:35:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (233, 2, 1, 1, 'S. Triglycerides', '500.00', NULL, '', '', '2022-01-12 00:35:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (234, 9, 1, 1, 'Free T3', '700.00', NULL, '', '', '2022-01-12 00:36:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (235, 6, 1, 1, 'RBC Parameters', '100.00', NULL, '', '', '2022-01-12 00:36:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (236, 2, 1, 1, 'S. Urea', '500.00', NULL, '', '', '2022-01-12 00:36:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (237, 9, 1, 1, 'Free T4', '700.00', NULL, '', '', '2022-01-12 00:37:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (238, 2, 1, 1, 'S. Uric Acid', '500.00', NULL, '', '', '2022-01-12 00:37:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (239, 6, 1, 1, 'Reticulocyte count', '150.00', NULL, '', '', '2022-01-12 00:37:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (240, 9, 1, 1, 'Growth Hormone', '1800.00', NULL, '', '', '2022-01-12 00:38:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (241, 2, 1, 1, 'S. Urine', '100.00', NULL, '', '', '2022-01-12 00:38:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (242, 6, 1, 1, 'Rh- Antibody', '1200.00', NULL, '', '', '2022-01-12 00:39:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (243, 9, 1, 1, 'HDV Ab', '1000.00', NULL, '', '', '2022-01-12 00:39:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (244, 2, 1, 1, 'S.Vitamin-D3 Level', '2500.00', NULL, '', '', '2022-01-12 00:39:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (245, 2, 1, 1, 'SGOT (AST)', '500.00', NULL, '', '', '2022-01-12 00:40:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (246, 9, 1, 1, 'Iron Profile', '3000.00', NULL, '', '', '2022-01-12 00:40:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (247, 2, 1, 1, 'SGPT (ALT)', '500.00', NULL, '', '', '2022-01-12 00:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (248, 6, 1, 1, 'Sputum Eosinophil', '200.00', NULL, '', '', '2022-01-12 00:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (249, 9, 1, 1, 'Myoglobin', '2000.00', NULL, '', '', '2022-01-12 00:41:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (250, 2, 1, 1, 'TCO2', '250.00', NULL, '', '', '2022-01-12 00:42:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (251, 9, 1, 1, 'Oestrogen', '800.00', NULL, '', '', '2022-01-12 00:42:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (252, 6, 1, 1, 'Syringe', '5.00', NULL, '', '', '2022-01-12 00:42:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (253, 2, 1, 1, 'TIBC', '900.00', NULL, '', '', '2022-01-12 00:42:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (255, 6, 1, 1, 'TC', '150.00', NULL, '', '', '2022-01-12 00:43:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (256, 2, 1, 1, 'TROPONIN-I', '1200.00', NULL, '', '', '2022-01-12 00:43:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (257, 2, 1, 1, 'Total Cholesterol', '400.00', NULL, '', '', '2022-01-12 00:44:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (258, 6, 1, 1, 'TC. DC', '300.00', NULL, '', '', '2022-01-12 00:44:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (259, 2, 1, 1, 'Total Protein', '500.00', NULL, '', '', '2022-01-12 00:45:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (260, 2, 1, 1, 'UTV (Urine Total Volume)', '100.00', NULL, '', '', '2022-01-12 00:45:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (261, 6, 1, 1, 'Urine M/E', '600.00', NULL, '', '', '2022-01-12 00:46:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (262, 9, 1, 1, 'Para Thyroid Hormone (PTH)', '1000.00', NULL, '', '', '2022-01-12 00:46:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (264, 9, 1, 1, 'Progesterone', '1200.00', NULL, '', '', '2022-01-12 00:47:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (265, 2, 1, 1, 'Vitamin-D', '2500.00', NULL, '', '', '2022-01-12 00:48:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (266, 9, 1, 1, 'S. Basal Cortisol', '1000.00', NULL, '', '', '2022-01-12 00:48:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (267, 9, 1, 1, 'S. FSH', '1200.00', NULL, '', '', '2022-01-12 00:49:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (268, 9, 1, 1, 'S. Ferritine', '1200.00', NULL, '', '', '2022-01-12 00:50:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (269, 9, 1, 1, 'S. LH', '1200.00', NULL, '', '', '2022-01-12 00:51:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (270, 9, 1, 1, 'S. Oestrogen', '1500.00', NULL, '', '', '2022-01-12 00:52:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (271, 9, 1, 1, 'S. Prolactin', '1500.00', NULL, '', '', '2022-01-12 00:53:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (272, 9, 1, 1, 'S. Testosteron', '1200.00', NULL, '', '', '2022-01-12 00:54:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (273, 9, 1, 1, 'T3', '700.00', NULL, '', '', '2022-01-12 00:55:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (274, 9, 1, 1, 'T3, T4, TSH', '2200.00', NULL, '', '', '2022-01-12 00:56:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (275, 9, 1, 1, 'T4', '700.00', NULL, '', '', '2022-01-12 00:57:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (276, 9, 1, 1, 'TH', '800.00', NULL, '', '', '2022-01-12 00:57:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (278, 9, 1, 1, 'TSH', '800.00', NULL, '', '', '2022-01-12 01:00:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (279, 9, 1, 1, 'Testosterone', '1100.00', NULL, '', '', '2022-01-12 01:01:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (280, 9, 1, 1, 'Thyroglobulin', '1500.00', NULL, '', '', '2022-01-12 01:02:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (281, 9, 1, 1, 'Trepnonema Pallidum [TP]', '1000.00', NULL, '', '', '2022-01-12 01:02:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (282, 19, 1, 1, 'TestCharge', '1.00', NULL, '', '', '2022-01-12 15:57:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (283, 19, 1, 1, 'USG of Lower abdomen Early Pregnency', '500.00', NULL, '', '', '2022-01-12 16:27:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (284, 20, 1, 1, 'X-Ray CXR L/V', '600.00', NULL, '', '', '2022-01-12 16:33:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (285, 20, 1, 1, 'X-Ray CXR Lt L/V', '600.00', NULL, '', '', '2022-01-12 16:35:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (286, 20, 1, 1, 'X-Ray Lt wrist joint B/V', '600.00', NULL, '', '', '2022-01-12 16:35:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (288, 20, 1, 1, 'X-Ray CXR O/V (Ribs) ', '600.00', NULL, '', '', '2022-01-12 16:36:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (289, 20, 1, 1, 'X-Ray CXR P/A', '600.00', NULL, '', '', '2022-01-12 16:38:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (290, 19, 1, 1, 'USG of Chest', '500.00', NULL, '', '', '2022-01-12 16:39:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (291, 20, 1, 1, 'X-Ray CXR Rt L/V', '600.00', NULL, '', '', '2022-01-12 16:39:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (292, 20, 1, 1, 'X-Ray Lumber Spine Lateral View ', '300.00', NULL, '', '', '2022-01-12 16:39:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (293, 20, 1, 1, 'X-Ray Cervical Spine A/P view ', '600.00', NULL, '', '', '2022-01-12 16:40:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (294, 20, 1, 1, 'X-Ray Lumber SpineB/V (Digital) ', '350.00', NULL, '', '', '2022-01-12 16:41:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (295, 19, 1, 1, 'USG of HBS', '800.00', NULL, '', '', '2022-01-12 16:41:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (296, 20, 1, 1, 'X-Ray Cervical Spine B/V', '900.00', NULL, '', '', '2022-01-12 16:41:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (297, 19, 1, 1, 'USG of Head', '900.00', NULL, '', '', '2022-01-12 16:45:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (298, 20, 1, 1, 'X-Ray Cervical Spine B/V Digital ', '600.00', NULL, '', '', '2022-01-12 16:45:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (299, 20, 1, 1, 'X-Ray Mandible B/V', '800.00', NULL, '', '', '2022-01-12 16:46:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (300, 19, 1, 1, 'USG of Inguinl Region', '1300.00', NULL, '', '', '2022-01-12 16:46:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (301, 20, 1, 1, 'X-Ray Cervical Spine Lateral view', '300.00', NULL, '', '', '2022-01-12 16:47:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (302, 19, 1, 1, 'USG of KUB Female', '600.00', NULL, '', '', '2022-01-12 16:47:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (303, 20, 1, 1, 'X-Ray Mandible L/V', '400.00', NULL, '', '', '2022-01-12 16:48:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (304, 20, 1, 1, 'X-Ray Cervical spine flexion and extension', '500.00', NULL, '', '', '2022-01-12 16:48:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (305, 19, 1, 1, 'USG of KUB Male', '600.00', NULL, '', '', '2022-01-12 16:48:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (306, 20, 1, 1, 'X-Ray Mandible Lateral View ', '300.00', NULL, '', '', '2022-01-12 16:49:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (307, 19, 1, 1, 'USG of Kub with lower abdomen Female', '900.00', NULL, '', '', '2022-01-12 16:49:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (308, 20, 1, 1, 'X-Ray Chest A/P Lateral View', '700.00', NULL, '', '', '2022-01-12 16:49:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (309, 19, 1, 1, 'USG of Kub with lower abdomen Male', '900.00', NULL, '', '', '2022-01-12 16:50:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (310, 20, 1, 1, 'X-Ray Chest A/P Supine ', '400.00', NULL, '', '', '2022-01-12 16:50:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (311, 20, 1, 1, 'X-Ray Mandible P/A view', '400.00', NULL, '', '', '2022-01-12 16:50:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (312, 19, 1, 1, 'USG of Lower abdomen Female', '600.00', NULL, '', '', '2022-01-12 16:51:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (313, 20, 1, 1, 'X-Ray Chest A/P for Ribs ', '400.00', NULL, '', '', '2022-01-12 16:51:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (314, 19, 1, 1, 'USG of Lower abdomen Female (2D)', '500.00', NULL, '', '', '2022-01-12 16:51:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (315, 20, 1, 1, 'X-Ray Mastoid townes view ', '600.00', NULL, '', '', '2022-01-12 16:52:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (316, 20, 1, 1, 'X-Ray Chest A/P view', '600.00', NULL, '', '', '2022-01-12 16:52:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (317, 19, 1, 1, 'USG of Lower abdomen Male', '600.00', NULL, '', '', '2022-01-12 16:52:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (318, 20, 1, 1, 'X-Ray Chest Lt Posterior obique (LPO)', '400.00', NULL, '', '', '2022-01-12 16:53:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (319, 19, 1, 1, 'USG of Molar Pregnancy', '2500.00', NULL, '', '', '2022-01-12 16:53:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (320, 19, 1, 1, 'USG of P/P', '500.00', NULL, '', '', '2022-01-12 16:55:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (321, 20, 1, 1, 'X-Ray Chest P/A Lateral Decubitus View ', '700.00', NULL, '', '', '2022-01-12 16:55:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (322, 20, 1, 1, 'X-Ray Mastoyed townes', '400.00', NULL, '', '', '2022-01-12 16:55:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (323, 20, 1, 1, 'X-Ray Chest P/A View', '600.00', NULL, '', '', '2022-01-12 16:56:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (324, 19, 1, 1, 'USG of Pregnancy Profile (4D)', '800.00', NULL, '', '', '2022-01-12 16:56:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (325, 20, 1, 1, 'X-Ray D/S A/P ', '400.00', NULL, '', '', '2022-01-12 16:57:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (326, 20, 1, 1, 'X-Ray D/S B/V ', '800.00', NULL, '', '', '2022-01-12 16:58:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (327, 20, 1, 1, 'X-Ray Maxilla Lateral oblique view ', '300.00', NULL, '', '', '2022-01-12 16:58:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (328, 19, 1, 1, 'USG of Pregnancy Profile With Anomaly Scan', '3000.00', NULL, '', '', '2022-01-12 16:58:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (329, 20, 1, 1, 'X-Ray D/S L/V', '400.00', NULL, '', '', '2022-01-12 17:00:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (330, 19, 1, 1, 'USG of Pregnency Profile', '600.00', NULL, '', '', '2022-01-12 17:00:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (331, 20, 1, 1, 'X-Ray Nasal bone lateral view', '600.00', NULL, '', '', '2022-01-12 17:00:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (332, 20, 1, 1, 'X-Ray Dental one film ', '120.00', NULL, '', '', '2022-01-12 17:01:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (333, 19, 1, 1, 'USG of Reproductive organ Female', '900.00', NULL, '', '', '2022-01-12 17:01:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (334, 20, 1, 1, 'X-Ray Nasopharynx Lateral view ', '600.00', NULL, '', '', '2022-01-12 17:01:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (335, 20, 1, 1, 'X-Ray Dental three film ', '360.00', NULL, '', '', '2022-01-12 17:03:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (336, 20, 1, 1, 'X-Ray Neck A/P', '400.00', NULL, '', '', '2022-01-12 17:03:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (337, 20, 1, 1, 'X-Ray Dental two film ', '240.00', NULL, '', '', '2022-01-12 17:03:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (338, 20, 1, 1, 'X-Ray Dorsal Spine B/V', '800.00', NULL, '', '', '2022-01-12 17:04:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (339, 20, 1, 1, 'X-Ray Dorsal Spine A/P view', '300.00', NULL, '', '', '2022-01-12 17:05:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (340, 20, 1, 1, 'X-Ray Sternum Lateral view', '300.00', NULL, '', '', '2022-01-12 17:06:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (341, 20, 1, 1, 'X-Ray Dorsal Spine Lateral view ', '300.00', NULL, '', '', '2022-01-12 17:06:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (342, 20, 1, 1, 'X-Ray Sternum oblique view', '400.00', NULL, '', '', '2022-01-12 17:07:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (343, 20, 1, 1, 'X-Ray Dorso Lumber Spine', '600.00', NULL, '', '', '2022-01-12 17:07:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (344, 19, 1, 1, 'USG of Scrotum', '900.00', NULL, '', '', '2022-01-12 17:07:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (345, 20, 1, 1, 'X-Ray Neck A/P', '300.00', NULL, '', '', '2022-01-12 17:07:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (346, 20, 1, 1, 'X-Ray Styloid Proces B/V', '400.00', NULL, '', '', '2022-01-12 17:08:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (347, 20, 1, 1, 'X-Ray Dorso-Lumber A/P view ', '300.00', NULL, '', '', '2022-01-12 17:08:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (348, 19, 1, 1, 'USG of Testis', '900.00', NULL, '', '', '2022-01-12 17:08:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (349, 20, 1, 1, 'X-Ray Throat Lateral View', '400.00', NULL, '', '', '2022-01-12 17:08:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (350, 20, 1, 1, 'X-Ray Neck B/V', '800.00', NULL, '', '', '2022-01-12 17:09:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (351, 19, 1, 1, 'USG of Thyroid', '1300.00', NULL, '', '', '2022-01-12 17:09:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (352, 20, 1, 1, 'X-Ray Dorso-Lumber B/V', '500.00', NULL, '', '', '2022-01-12 17:09:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (353, 20, 1, 1, 'X-Ray Throat P/A View', '400.00', NULL, '', '', '2022-01-12 17:09:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (354, 19, 1, 1, 'USG of Transvaginal sonography', '900.00', NULL, '', '', '2022-01-12 17:10:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (355, 20, 1, 1, 'X-Ray Neck L/V', '400.00', NULL, '', '', '2022-01-12 17:10:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (356, 20, 1, 1, 'X-Ray Throsis Spine B/V', '500.00', NULL, '', '', '2022-01-12 17:10:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (357, 20, 1, 1, 'X-Ray Dorso-Lumber Lateral view ', '300.00', NULL, '', '', '2022-01-12 17:10:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (358, 19, 1, 1, 'USG of Transvaginal sonography', '900.00', NULL, '', '', '2022-01-12 17:10:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (359, 20, 1, 1, 'X-ray L/S Spine B/V', '650.00', NULL, '', '', '2022-01-12 17:11:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (360, 19, 1, 1, 'USG of Upper abdomen Female', '600.00', NULL, '', '', '2022-01-12 17:11:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (361, 20, 1, 1, 'X-Ray Elbow with fore arm B/V ', '700.00', NULL, '', '', '2022-01-12 17:11:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (362, 20, 1, 1, 'X-Ray Neck Soft tissue L/V ', '400.00', NULL, '', '', '2022-01-12 17:11:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (363, 20, 1, 1, 'X-ray T.m Joint B/V', '600.00', NULL, '', '', '2022-01-12 17:12:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (364, 19, 1, 1, 'USG of Upper abdomen Male', '600.00', NULL, '', '', '2022-01-12 17:12:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (365, 20, 1, 1, 'X-Ray Face B/V', '400.00', NULL, '', '', '2022-01-12 17:12:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (366, 20, 1, 1, 'X-Ray OPG', '600.00', NULL, '', '', '2022-01-12 17:13:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (367, 19, 1, 1, 'USG of W/A with pregnancy', '700.00', NULL, '', '', '2022-01-12 17:13:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (368, 20, 1, 1, 'X-Ray Face Lateral View ', '400.00', NULL, '', '', '2022-01-12 17:13:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (369, 19, 1, 1, 'USG of Whole abdomen Female', '700.00', NULL, '', '', '2022-01-12 17:14:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (370, 20, 1, 1, 'X-Ray Face P/A View', '300.00', NULL, '', '', '2022-01-12 17:14:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (371, 19, 1, 1, 'USG of Whole abdomen Male', '700.00', NULL, '', '', '2022-01-12 17:15:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (372, 20, 1, 1, 'X-Ray Fore Arm B/V ', '600.00', NULL, '', '', '2022-01-12 17:15:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (373, 19, 1, 1, 'USG of Breast', '1300.00', NULL, '', '', '2022-01-12 17:16:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (374, 20, 1, 1, 'X-Ray Rt Knee A/P Standing View', '400.00', NULL, '', '', '2022-01-12 17:16:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (375, 20, 1, 1, 'X-Ray Hip joint B/V ', '800.00', NULL, '', '', '2022-01-12 17:16:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (376, 20, 1, 1, 'X-Ray Rt Knee joint B/V', '600.00', NULL, '', '', '2022-01-12 17:16:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (377, 20, 1, 1, 'X-Ray IVU', '1500.00', NULL, '', '', '2022-01-12 17:17:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (378, 20, 1, 1, 'X-Ray Rt Knee jt B/V', '600.00', NULL, '', '', '2022-01-12 17:17:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (379, 20, 1, 1, 'X-Ray IVU Let film one ', '300.00', NULL, '', '', '2022-01-12 17:17:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (380, 20, 1, 1, 'X-Ray Rt Leg B/V', '700.00', NULL, '', '', '2022-01-12 17:18:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (381, 20, 1, 1, 'X-Ray IVU Let film two ', '500.00', NULL, '', '', '2022-01-12 17:18:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (382, 19, 1, 1, 'USG of inguino - scrotal', '1300.00', NULL, '', '', '2022-01-12 17:18:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (383, 20, 1, 1, 'X-Ray Rt Leg B/V', '400.00', NULL, '', '', '2022-01-12 17:19:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (384, 20, 1, 1, 'X-Ray IVU/IVP', '1200.00', NULL, '', '', '2022-01-12 17:19:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (385, 19, 1, 1, 'utla', '600.00', NULL, '', '', '2022-01-12 17:19:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (386, 20, 1, 1, 'X-Ray Rt Leg finger B/V', '400.00', NULL, '', '', '2022-01-12 17:20:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (387, 20, 1, 1, 'X-Ray KUB', '600.00', NULL, '', '', '2022-01-12 17:20:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (388, 20, 1, 1, 'X-Ray KUB A/P view ', '500.00', NULL, '', '', '2022-01-12 17:21:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (389, 20, 1, 1, 'X-Ray Abdomen AP', '500.00', NULL, '', '', '2022-01-12 17:21:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (390, 20, 1, 1, 'X-Ray Rt Mastoid Townes View', '700.00', NULL, '', '', '2022-01-12 17:22:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (391, 20, 1, 1, 'X-Ray KUB B/V', '800.00', NULL, '', '', '2022-01-12 17:22:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (392, 20, 1, 1, 'X-Ray Abdomen EP', '550.00', NULL, '', '', '2022-01-12 17:22:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (393, 20, 1, 1, 'X-Ray Rt Middle finger B/V', '400.00', NULL, '', '', '2022-01-12 17:22:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (394, 20, 1, 1, 'X-Ray KUB L/V', '500.00', NULL, '', '', '2022-01-12 17:23:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (395, 20, 1, 1, 'X-Ray Rt Neck of Femur A/P View', '700.00', NULL, '', '', '2022-01-12 17:23:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (396, 20, 1, 1, 'X-Ray Atlas bone A/P View', '400.00', NULL, '', '', '2022-01-12 17:23:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (397, 20, 1, 1, 'X-Ray KUB errect ', '500.00', NULL, '', '', '2022-01-12 17:24:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (398, 20, 1, 1, 'X-Ray PNS B/V', '800.00', NULL, '', '', '2022-01-12 17:24:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (399, 20, 1, 1, 'X-Ray Rt Neck of Femur B/V', '700.00', NULL, '', '', '2022-01-12 17:24:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (400, 20, 1, 1, 'X-Ray KUB x-ray ', '500.00', NULL, '', '', '2022-01-12 17:25:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (401, 20, 1, 1, 'X-Ray Rt Patella P/A', '500.00', NULL, '', '', '2022-01-12 17:25:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (402, 20, 1, 1, 'X-Ray Atlas bone B/V', '400.00', NULL, '', '', '2022-01-12 17:25:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (403, 20, 1, 1, 'X-Ray Rt Patella Skyline View', '400.00', NULL, '', '', '2022-01-12 17:26:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (404, 20, 1, 1, 'X-Ray L/S A/P', '700.00', NULL, '', '', '2022-01-12 17:26:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (405, 20, 1, 1, 'X-Ray Rt Patella Skyline view', '450.00', NULL, '', '', '2022-01-12 17:26:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (406, 20, 1, 1, 'X-Ray BA ENAMA D/C', '2200.00', NULL, '', '', '2022-01-12 17:26:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (407, 20, 1, 1, 'X-Ray PNS OM View Digital ', '450.00', NULL, '', '', '2022-01-12 17:27:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (408, 20, 1, 1, 'X-Ray Rt Ring finger B/V', '400.00', NULL, '', '', '2022-01-12 17:27:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (409, 20, 1, 1, 'X-Ray BA Follow Through', '1500.00', NULL, '', '', '2022-01-12 17:28:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (410, 20, 1, 1, 'X-Ray Rt Scaphoid View', '400.00', NULL, '', '', '2022-01-12 17:28:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (411, 20, 1, 1, 'X-Ray PNS OM view', '600.00', NULL, '', '', '2022-01-12 17:28:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (412, 20, 1, 1, 'X-Ray Rt Scapula A/P View', '400.00', NULL, '', '', '2022-01-12 17:28:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (413, 20, 1, 1, 'X-Ray PNS OM view', '500.00', NULL, '', '', '2022-01-12 17:29:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (414, 20, 1, 1, 'X-Ray Pelvimetry A/P (Errect) ', '400.00', NULL, '', '', '2022-01-12 17:30:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (415, 20, 1, 1, 'X-Ray BA MEAL S/D', '1000.00', NULL, '', '', '2022-01-12 17:31:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (416, 20, 1, 1, 'X-Ray Rt Scapula B/V', '700.00', NULL, '', '', '2022-01-12 17:31:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (417, 20, 1, 1, 'X-Ray BA-Enema of Large GUT X-Ray', '1500.00', NULL, '', '', '2022-01-12 17:32:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (418, 20, 1, 1, 'X-Ray Rt Shoulder jt Swimmers View', '400.00', NULL, '', '', '2022-01-12 17:32:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (419, 20, 1, 1, 'X-Ray Rt Sole B/V View', '500.00', NULL, '', '', '2022-01-12 17:32:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (420, 20, 1, 1, 'X-Ray Pelvis A/P view', '600.00', NULL, '', '', '2022-01-12 17:32:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (421, 20, 1, 1, 'X-Ray Ba-Enema let film one', '400.00', NULL, '', '', '2022-01-12 17:32:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (422, 20, 1, 1, 'X-Ray Rt Sub-Mandibular gland Lateral oblique view', '500.00', NULL, '', '', '2022-01-12 17:33:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (423, 20, 1, 1, 'X-Ray Ba-follow through let film two', '700.00', NULL, '', '', '2022-01-12 17:34:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (424, 20, 1, 1, 'X-Ray Pelvis B/V ', '800.00', NULL, '', '', '2022-01-12 17:34:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (425, 20, 1, 1, 'X-Ray Bone Age L-1', '300.00', NULL, '', '', '2022-01-12 17:34:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (426, 20, 1, 1, 'X-Ray Rt T/F', '300.00', NULL, '', '', '2022-01-12 17:34:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (427, 20, 1, 1, 'X-Ray Pelvis L/V', '400.00', NULL, '', '', '2022-01-12 17:35:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (428, 20, 1, 1, 'X-Ray Both Knee Joint A/P View', '400.00', NULL, '', '', '2022-01-12 17:35:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (429, 20, 1, 1, 'X-Ray Plain Abdomen in E/P', '600.00', NULL, '', '', '2022-01-12 17:36:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (430, 20, 1, 1, 'X-Ray Both Knee Joint B/V', '600.00', NULL, '', '', '2022-01-12 17:36:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (431, 20, 1, 1, 'X-Ray Plain Abdomen in E/P Child ', '300.00', NULL, '', '', '2022-01-12 17:37:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (432, 20, 1, 1, 'X-Ray Both Knee jt A/P view', '400.00', NULL, '', '', '2022-01-12 17:37:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (433, 20, 1, 1, 'X-Ray Rt TM jt open mouth', '400.00', NULL, '', '', '2022-01-12 17:38:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (434, 20, 1, 1, 'X-Ray RGU + MCU', '1500.00', NULL, '', '', '2022-01-12 17:38:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (435, 20, 1, 1, 'X-Ray Both Mastoid Townes View', '500.00', NULL, '', '', '2022-01-12 17:38:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (436, 20, 1, 1, 'X-Ray Rt Zygomatic bone B/V', '400.00', NULL, '', '', '2022-01-12 17:39:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (437, 20, 1, 1, 'X-Ray Rt ankle and foot B/V', '400.00', NULL, '', '', '2022-01-12 17:39:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (438, 20, 1, 1, 'X-Ray RT Foot B/V', '600.00', NULL, '', '', '2022-01-12 17:39:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (439, 20, 1, 1, 'X-Ray Rt arm B/V', '600.00', NULL, '', '', '2022-01-12 17:40:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (440, 20, 1, 1, 'X-Ray Retrograde Cysto-Urethrogram (RCU)', '1500.00', NULL, '', '', '2022-01-12 17:40:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (441, 20, 1, 1, 'X-Ray Both clavicle A/P View', '300.00', NULL, '', '', '2022-01-12 17:40:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (442, 20, 1, 1, 'X-Ray Rt calcaneum Axial view', '400.00', NULL, '', '', '2022-01-12 17:41:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (443, 20, 1, 1, 'X-Ray Retrograde Cysto-Urethrogram with MCU ', '1500.00', NULL, '', '', '2022-01-12 17:41:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (444, 20, 1, 1, 'X-Ray Both hib joint', '600.00', NULL, '', '', '2022-01-12 17:41:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (445, 20, 1, 1, 'X-Ray Rt calcaneum B/V', '400.00', NULL, '', '', '2022-01-12 17:41:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (446, 20, 1, 1, 'X-Ray Retrograde Urethrogram (RGU)', '1000.00', NULL, '', '', '2022-01-12 17:42:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (447, 20, 1, 1, 'X-Ray Both hip A/P View', '300.00', NULL, '', '', '2022-01-12 17:42:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (448, 20, 1, 1, 'X-Ray Rt clavicle A/P view', '400.00', NULL, '', '', '2022-01-12 17:42:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (449, 20, 1, 1, 'X-Ray Rt foot B/V', '400.00', NULL, '', '', '2022-01-12 17:43:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (450, 20, 1, 1, 'X-Ray Both knee joint B/V', '900.00', NULL, '', '', '2022-01-12 17:43:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (451, 20, 1, 1, 'X-Ray Rt Mastoid Stenverse View ', '400.00', NULL, '', '', '2022-01-12 17:43:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (452, 20, 1, 1, 'X-Ray Rt fore arm B/V', '400.00', NULL, '', '', '2022-01-12 17:44:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (453, 20, 1, 1, 'X-Ray Rt Shoulder jt A/P View', '600.00', NULL, '', '', '2022-01-12 17:44:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (454, 20, 1, 1, 'X-Ray Both mastoid townes view', '500.00', NULL, '', '', '2022-01-12 17:45:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (455, 20, 1, 1, 'X-Ray Rt great toe B/V', '400.00', NULL, '', '', '2022-01-12 17:45:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (456, 20, 1, 1, 'X-Ray Rt hand B/V', '600.00', NULL, '', '', '2022-01-12 17:45:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (457, 20, 1, 1, 'X-Ray Both orbit P/A View', '300.00', NULL, '', '', '2022-01-12 17:45:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (458, 20, 1, 1, 'X-Ray Rt Ankle joint B/V ', '600.00', NULL, '', '', '2022-01-12 17:46:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (459, 20, 1, 1, 'X-Ray Rt index B/V', '400.00', NULL, '', '', '2022-01-12 17:46:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (460, 20, 1, 1, 'X-Ray C/S A/P', '400.00', NULL, '', '', '2022-01-12 17:46:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (461, 20, 1, 1, 'X-Ray Rt knee jt Tunnel view', '400.00', NULL, '', '', '2022-01-12 17:47:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (462, 20, 1, 1, 'X-Ray C/S B/V', '800.00', NULL, '', '', '2022-01-12 17:47:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (463, 20, 1, 1, 'X-Ray Rt orbit B/V', '400.00', NULL, '', '', '2022-01-12 17:47:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (464, 20, 1, 1, 'X-Ray Rt Ankle jt B/V', '600.00', NULL, '', '', '2022-01-12 17:47:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (465, 20, 1, 1, 'X-Ray C/S L/V', '600.00', NULL, '', '', '2022-01-12 17:48:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (466, 20, 1, 1, 'X-Ray Rt orbit oblique View', '500.00', NULL, '', '', '2022-01-12 17:48:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (467, 20, 1, 1, 'X-Ray Rt Ankle jt B/V', '450.00', NULL, '', '', '2022-01-12 17:49:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (468, 20, 1, 1, 'X-Ray Rt shoulder jt B/V', '600.00', NULL, '', '', '2022-01-12 17:49:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (469, 20, 1, 1, 'X-Ray Rt Elbow joint B/V', '600.00', NULL, '', '', '2022-01-12 17:50:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (470, 20, 1, 1, 'X-Ray Rt shoulder jt internal rotation', '500.00', NULL, '', '', '2022-01-12 17:51:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (471, 20, 1, 1, 'X-Ray Rt shoulder jt A/P view', '600.00', NULL, '', '', '2022-01-12 17:52:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (472, 20, 1, 1, 'X-Ray Rt Femar B/V', '400.00', NULL, '', '', '2022-01-12 17:52:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (473, 20, 1, 1, 'X-Ray Rt thumb B/V', '300.00', NULL, '', '', '2022-01-12 17:53:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (474, 20, 1, 1, 'X-Ray Rt Femur Including Hip A/P View ', '400.00', NULL, '', '', '2022-01-12 17:53:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (475, 20, 1, 1, 'X-Ray Rt wrist joint B/V', '600.00', NULL, '', '', '2022-01-12 17:53:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (476, 20, 1, 1, 'X-Ray Rt. Thigh B/V', '700.00', NULL, '', '', '2022-01-12 17:54:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (477, 20, 1, 1, 'X-Ray Rt Fore Arm B/V', '400.00', NULL, '', '', '2022-01-12 17:54:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (478, 20, 1, 1, 'X-Ray Rt.Wrist B/V', '300.00', NULL, '', '', '2022-01-12 17:55:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (479, 20, 1, 1, 'X-Ray Rt Hand B/V', '600.00', NULL, '', '', '2022-01-12 17:55:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (480, 20, 1, 1, 'X-Ray SI Joint/view', '800.00', NULL, '', '', '2022-01-12 17:55:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (481, 20, 1, 1, 'X-Ray Rt Hand finger B/V ', '400.00', NULL, '', '', '2022-01-12 17:56:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (482, 20, 1, 1, 'X-Ray Sacro-coccygeal A/P view', '300.00', NULL, '', '', '2022-01-12 17:56:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (483, 20, 1, 1, 'X-Ray Rt Heel B/V', '400.00', NULL, '', '', '2022-01-12 17:57:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (484, 20, 1, 1, 'X-Ray Sacro-coccygeal B/V', '500.00', NULL, '', '', '2022-01-12 17:57:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (485, 20, 1, 1, 'X-Ray Sacro-coccygeal Lateral', '300.00', NULL, '', '', '2022-01-12 17:58:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (486, 20, 1, 1, 'X-Ray Rt Hip A/P view ', '400.00', NULL, '', '', '2022-01-12 17:58:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (487, 20, 1, 1, 'X-Ray Rt Hip B/V', '700.00', NULL, '', '', '2022-01-12 17:59:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (488, 20, 1, 1, 'X-Ray Rt Hip joint B/V  ', '600.00', NULL, '', '', '2022-01-12 17:59:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (489, 20, 1, 1, 'X-Ray Sialogram of Lt Parotid gland', '1000.00', NULL, '', '', '2022-01-12 18:00:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (490, 20, 1, 1, 'X-Ray Sialogram of Lt Sub-Mandibular gland', '1000.00', NULL, '', '', '2022-01-12 18:01:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (491, 20, 1, 1, 'X-Ray Sialogram of Rt Sub-Mandibular gland', '1000.00', NULL, '', '', '2022-01-12 18:02:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (492, 20, 1, 1, 'X-Ray Sialogram of Rt parotid gland', '1000.00', NULL, '', '', '2022-01-12 18:06:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (493, 20, 1, 1, 'X-Ray Skull A/P', '400.00', NULL, '', '', '2022-01-12 18:06:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (494, 20, 1, 1, 'X-Ray Skull B/V', '600.00', NULL, '', '', '2022-01-12 18:07:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (495, 20, 1, 1, 'X-Ray Skull B/V', '800.00', NULL, '', '', '2022-01-12 18:08:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (496, 20, 1, 1, 'X-Ray Skull Lateral view', '400.00', NULL, '', '', '2022-01-12 18:09:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (497, 20, 1, 1, 'X-Ray Skull P/A view', '400.00', NULL, '', '', '2022-01-12 18:10:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (498, 20, 1, 1, 'X-Ray Skull SM view', '300.00', NULL, '', '', '2022-01-12 18:10:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (499, 20, 1, 1, 'X-Ray Spine A/P View (child)', '300.00', NULL, '', '', '2022-01-12 18:11:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (500, 20, 1, 1, 'X-Ray Spine B/V (child)', '500.00', NULL, '', '', '2022-01-12 18:12:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (501, 20, 1, 1, 'X-Ray Spine Lateral View (child)', '500.00', NULL, '', '', '2022-01-12 18:12:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (502, 20, 1, 1, 'X-Ray Sterno-clavicular jt P/A View', '400.00', NULL, '', '', '2022-01-12 18:15:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (503, 20, 1, 1, 'X-Ray Sternum A/P', '300.00', NULL, '', '', '2022-01-12 18:17:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (504, 20, 1, 1, 'X-Ray Sternum A/P view', '400.00', NULL, '', '', '2022-01-12 18:18:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (505, 20, 1, 1, 'X-Ray L/S B/V', '900.00', NULL, '', '', '2022-01-12 20:31:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (506, 20, 1, 1, 'X-Ray L/S L/V', '400.00', NULL, '', '', '2022-01-12 20:34:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (507, 20, 1, 1, 'X-Ray L/S Spine A/P View', '300.00', NULL, '', '', '2022-01-12 20:35:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (508, 20, 1, 1, 'X-Ray L/S Spine B/Oblique view', '500.00', NULL, '', '', '2022-01-12 20:37:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (509, 20, 1, 1, 'X-Ray L/S Spine B/V', '600.00', NULL, '', '', '2022-01-12 20:37:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (510, 20, 1, 1, 'X-Ray L/S Spine Flexion', '500.00', NULL, '', '', '2022-01-12 20:40:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (511, 20, 1, 1, 'X-Ray L/S Spine Lateral view', '600.00', NULL, '', '', '2022-01-12 20:40:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (512, 20, 1, 1, 'X-Ray L/S spine flexion and extension', '500.00', NULL, '', '', '2022-01-12 20:41:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (513, 20, 1, 1, 'X-Ray Lt Ankle B/V', '600.00', NULL, '', '', '2022-01-12 20:42:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (514, 20, 1, 1, 'X-Ray Lt Ankle joint B/V', '600.00', NULL, '', '', '2022-01-12 20:43:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (515, 20, 1, 1, 'X-Ray Lt Elbow joint B/V', '600.00', NULL, '', '', '2022-01-12 20:44:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (516, 20, 1, 1, 'X-Ray Lt Femar B/V', '400.00', NULL, '', '', '2022-01-12 20:45:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (517, 20, 1, 1, 'X-Ray Lt Femur Including Hip A/V View', '800.00', NULL, '', '', '2022-01-12 20:46:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (518, 20, 1, 1, 'X-Ray Lt Foot B/V', '600.00', NULL, '', '', '2022-01-12 20:46:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (519, 20, 1, 1, 'X-Ray Lt Fore Arm B/V', '400.00', NULL, '', '', '2022-01-12 20:47:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (520, 20, 1, 1, 'X-Ray Lt Hand B/V', '600.00', NULL, '', '', '2022-01-12 20:48:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (521, 20, 1, 1, 'X-Ray Lt Hand finger B/V', '400.00', NULL, '', '', '2022-01-12 20:49:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (522, 20, 1, 1, 'X-Ray Lt Heel B/V', '400.00', NULL, '', '', '2022-01-12 20:50:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (523, 20, 1, 1, 'X-Ray Lt Hip joint B/V', '600.00', NULL, '', '', '2022-01-12 20:51:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (524, 20, 1, 1, 'X-Ray Lt Knee B/V', '600.00', NULL, '', '', '2022-01-12 20:52:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (525, 20, 1, 1, 'X-Ray Lt Knee joint B/V', '600.00', NULL, '', '', '2022-01-12 20:53:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (526, 20, 1, 1, 'X-Ray Lt Leg B/V', '600.00', NULL, '', '', '2022-01-12 20:54:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (527, 20, 1, 1, 'X-Ray Lt Leg B/V', '700.00', NULL, '', '', '2022-01-12 20:55:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (528, 20, 1, 1, 'X-Ray Lt Leg finger B/V', '400.00', NULL, '', '', '2022-01-12 20:56:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (529, 20, 1, 1, 'X-Ray Lt Little finger B/V', '400.00', NULL, '', '', '2022-01-12 20:57:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (530, 20, 1, 1, 'X-Ray Lt Mastoid Stenverse View', '500.00', NULL, '', '', '2022-01-12 20:58:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (531, 20, 1, 1, 'X-Ray Lt Mastoid Townes View', '700.00', NULL, '', '', '2022-01-12 20:59:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (532, 20, 1, 1, 'X-Ray Lt Neck of Femur A/P View', '400.00', NULL, '', '', '2022-01-12 21:00:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (533, 20, 1, 1, 'X-Ray Lt Neck of Femur B/V', '700.00', NULL, '', '', '2022-01-12 21:01:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (534, 20, 1, 1, 'X-Ray Lt Patella P/A', '400.00', NULL, '', '', '2022-01-12 21:02:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (535, 20, 1, 1, 'X-Ray Lt Patella Skyline view', '400.00', NULL, '', '', '2022-01-12 21:03:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (536, 20, 1, 1, 'X-Ray Lt Ring finger B/V', '400.00', NULL, '', '', '2022-01-12 21:04:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (537, 20, 1, 1, 'X-Ray Lt Shouder jt Swimmers View', '400.00', NULL, '', '', '2022-01-12 21:05:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (538, 20, 1, 1, 'X-Ray Lt Shoulder jt B/V', '600.00', NULL, '', '', '2022-01-12 21:07:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (539, 20, 1, 1, 'X-Ray Lt Thigh B/V', '600.00', NULL, '', '', '2022-01-12 21:07:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (540, 20, 1, 1, 'X-Ray Lt Wrist jt B/V', '600.00', NULL, '', '', '2022-01-12 21:08:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (541, 20, 1, 1, 'X-Ray Lt ankle and foot B/V', '400.00', NULL, '', '', '2022-01-12 21:09:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (543, 20, 1, 1, 'X-Ray Lt arm B/V', '400.00', NULL, '', '', '2022-01-12 21:12:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (544, 20, 1, 1, 'X-Ray Lt calcaneum Axial view', '400.00', NULL, '', '', '2022-01-12 21:12:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (545, 20, 1, 1, 'X-Ray Lt calcaneum B/V', '400.00', NULL, '', '', '2022-01-12 21:13:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (546, 20, 1, 1, 'X-Ray Lt cavicle B/V', '500.00', NULL, '', '', '2022-01-12 21:15:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (547, 20, 1, 1, 'X-Ray Lt clavicle A/P view', '300.00', NULL, '', '', '2022-01-12 21:15:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (548, 20, 1, 1, 'X-Ray Lt elbow jt B/V', '600.00', NULL, '', '', '2022-01-12 21:16:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (552, 20, 1, 1, 'X-Ray Lt knee jt tunnel view', '400.00', NULL, '', '', '2022-01-12 21:28:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (553, 20, 1, 1, 'X-Ray Lt orbit  oblique View', '400.00', NULL, '', '', '2022-01-12 21:30:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (554, 20, 1, 1, 'X-Ray Lt orbit B/V', '500.00', NULL, '', '', '2022-01-12 21:31:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (555, 21, 1, 1, 'Ambulance Charge', '5000.00', NULL, '', '', '2022-01-13 00:02:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (556, 23, 1, 1, 'Appendicectomy', '6000.00', NULL, '', '', '2022-01-13 00:10:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (557, 24, 1, 1, 'Secondary Stitch with Catamine', '3000.00', NULL, '', '', '2022-01-13 00:11:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (558, 23, 1, 1, 'Bartholine Abcess (GA)', '5000.00', NULL, '', '', '2022-01-13 00:11:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (559, 23, 1, 1, 'Piles', '6000.00', NULL, '', '', '2022-01-13 00:12:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (560, 23, 1, 1, 'Bartholine CYST (GA)', '5000.00', NULL, '', '', '2022-01-13 00:12:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (561, 25, 1, 1, 'Gland Biopsy', '4000.00', NULL, '', '', '2022-01-13 00:12:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (562, 24, 1, 1, 'Vaginal Delevery', '1000.00', NULL, '', '', '2022-01-13 00:13:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (563, 25, 1, 1, 'Hydrocyl', '2500.00', NULL, '', '', '2022-01-13 00:13:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (564, 23, 1, 1, 'Pterygium', '5000.00', NULL, '', '', '2022-01-13 00:14:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (565, 23, 1, 1, 'Biopsy Surgery', '7000.00', NULL, '', '', '2022-01-13 00:14:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (566, 24, 1, 1, 'Vaginal Delevery (with Episiotomy)', '1500.00', NULL, '', '', '2022-01-13 00:14:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (567, 25, 1, 1, 'Hysterectomy', '4000.00', NULL, '', '', '2022-01-13 00:14:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (568, 23, 1, 1, 'Breast Abses (L)/A', '4000.00', NULL, '', '', '2022-01-13 00:15:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (569, 24, 1, 1, 'Retained Placenta', '1000.00', NULL, '', '', '2022-01-13 00:15:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (570, 24, 1, 1, 'Vaginal Histrictomy', '12000.00', NULL, '', '', '2022-01-13 00:15:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (571, 25, 1, 1, 'Incissional Hernia', '3000.00', NULL, '', '', '2022-01-13 00:16:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (572, 23, 1, 1, 'Breast Lump/Tumour', '8000.00', NULL, '', '', '2022-01-13 00:16:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (573, 25, 1, 1, 'Abdominal Histectomy (Single Surgeon)', '8000.00', NULL, '', '', '2022-01-13 00:16:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (574, 25, 1, 1, 'Kidney urinary stone', '4000.00', NULL, '', '', '2022-01-13 00:17:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (575, 24, 1, 1, 'Secondary Stitch with Catamine', '3000.00', NULL, '', '', '2022-01-13 00:17:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (576, 23, 1, 1, 'Herniotomy', '7500.00', NULL, '', '', '2022-01-13 00:17:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (577, 25, 1, 1, 'Appendicectomy', '2700.00', NULL, '', '', '2022-01-13 00:18:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (578, 25, 1, 1, 'L U C S', '3200.00', NULL, '', '', '2022-01-13 00:18:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (579, 23, 1, 1, 'Hydrocill', '2700.00', NULL, '', '', '2022-01-13 00:18:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (580, 25, 1, 1, 'Laminectomy', '4000.00', NULL, '', '', '2022-01-13 00:19:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (581, 24, 1, 1, 'Vaginal Delevery', '1000.00', NULL, '', '', '2022-01-13 00:19:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (582, 25, 1, 1, 'Biopsy', '2500.00', NULL, '', '', '2022-01-13 00:19:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (583, 23, 1, 1, 'Piles', '6000.00', NULL, '', '', '2022-01-13 00:19:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (584, 25, 1, 1, 'Laparotomy Single Cons.', '8000.00', NULL, '', '', '2022-01-13 00:19:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (585, 25, 1, 1, 'Catheterization', '700.00', NULL, '', '', '2022-01-13 00:20:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (586, 24, 1, 1, 'Vaginal Delevery (with Episiotomy)', '1500.00', NULL, '', '', '2022-01-13 00:20:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (587, 25, 1, 1, 'Laparscopy', '4000.00', NULL, '', '', '2022-01-13 00:20:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (588, 23, 1, 1, 'Pterygium', '5000.00', NULL, '', '', '2022-01-13 00:20:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (589, 25, 1, 1, 'Chest Aspiration (Local)', '1000.00', NULL, '', '', '2022-01-13 00:21:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (590, 25, 1, 1, 'Lapchole', '12000.00', NULL, '', '', '2022-01-13 00:21:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (591, 25, 1, 1, 'Lapcoly', '4000.00', NULL, '', '', '2022-01-13 00:22:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (592, 25, 1, 1, 'Chest Aspiration(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-13 00:23:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (593, 24, 1, 1, 'Vaginal Histrictomy', '12000.00', NULL, '', '', '2022-01-13 00:23:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (594, 25, 1, 1, 'Lapratomy', '4000.00', NULL, '', '', '2022-01-13 00:23:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (595, 25, 1, 1, 'Lipoma', '2500.00', NULL, '', '', '2022-01-13 00:24:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (596, 25, 1, 1, 'Circumcession(Anaesthesia)', '1000.00', NULL, '', '', '2022-01-13 00:24:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (597, 25, 1, 1, 'Abdominal Histectomy (Single Surgeon)', '8000.00', NULL, '', '', '2022-01-13 00:25:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (598, 22, 1, 1, 'Adenoidectomy', '6000.00', NULL, '', '', '2022-01-13 00:25:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (599, 25, 1, 1, 'M. R (local)', '700.00', NULL, '', '', '2022-01-13 00:25:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (600, 25, 1, 1, 'Circumcession(Local)', '700.00', NULL, '', '', '2022-01-13 00:25:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (601, 25, 1, 1, 'Mastaidioactomy', '4000.00', NULL, '', '', '2022-01-13 00:26:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (602, 25, 1, 1, 'Appendicectomy', '2700.00', NULL, '', '', '2022-01-13 00:26:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (603, 25, 1, 1, 'Cistostopy', '2000.00', NULL, '', '', '2022-01-13 00:26:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (604, 22, 1, 1, 'Amalgum Filling', '350.00', NULL, '', '', '2022-01-13 00:26:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (605, 25, 1, 1, 'Mastectomy', '4000.00', NULL, '', '', '2022-01-13 00:27:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (606, 25, 1, 1, 'Dilatation(Anaesthesia)', '2000.00', NULL, '', '', '2022-01-13 00:27:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (607, 22, 1, 1, 'Branchial Cyst - 1', '11000.00', NULL, '', '', '2022-01-13 00:27:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (608, 25, 1, 1, 'Nephroelithotomy', '4000.00', NULL, '', '', '2022-01-13 00:28:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (609, 25, 1, 1, 'Biopsy', '2500.00', NULL, '', '', '2022-01-13 00:28:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (610, 22, 1, 1, 'Ear Wash', '500.00', NULL, '', '', '2022-01-13 00:28:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (611, 25, 1, 1, 'Dilatation(Local)', '700.00', NULL, '', '', '2022-01-13 00:28:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (612, 25, 1, 1, 'OT Charge Including Assist', '1500.00', NULL, '', '', '2022-01-13 00:28:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (613, 22, 1, 1, 'Nose Surgery', '5500.00', NULL, '', '', '2022-01-13 00:29:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (614, 25, 1, 1, 'Ovarian Cyst', '4000.00', NULL, '', '', '2022-01-13 00:29:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (615, 25, 1, 1, 'Excision of the Encephalocele', '12000.00', NULL, '', '', '2022-01-13 00:29:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (616, 25, 1, 1, 'Catheterization', '700.00', NULL, '', '', '2022-01-13 00:29:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (617, 25, 1, 1, 'Poly Pectomy', '4000.00', NULL, '', '', '2022-01-13 00:30:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (618, 22, 1, 1, 'Nose Wash', '500.00', NULL, '', '', '2022-01-13 00:30:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (619, 25, 1, 1, 'Fistula(Perianal)', '2500.00', NULL, '', '', '2022-01-13 00:30:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (620, 25, 1, 1, 'SMR/SMD', '1700.00', NULL, '', '', '2022-01-13 00:31:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (621, 25, 1, 1, 'Chest Aspiration (Local)', '1000.00', NULL, '', '', '2022-01-13 00:31:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (622, 22, 1, 1, 'Nose Wash (LA)', '2000.00', NULL, '', '', '2022-01-13 00:31:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (623, 25, 1, 1, 'Gallbladder', '4000.00', NULL, '', '', '2022-01-13 00:32:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (624, 25, 1, 1, 'Skin grfting', '4000.00', NULL, '', '', '2022-01-13 00:32:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (625, 22, 1, 1, 'Septoplasty + BAWO', '7000.00', NULL, '', '', '2022-01-13 00:32:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (626, 25, 1, 1, 'Gland Biopsy', '4000.00', NULL, '', '', '2022-01-13 00:33:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (627, 25, 1, 1, 'Stich (local)', '700.00', NULL, '', '', '2022-01-13 00:33:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (628, 22, 1, 1, 'Septoplasty+SMD', '7000.00', NULL, '', '', '2022-01-13 00:33:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (629, 25, 1, 1, 'Chest Aspiration(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-13 00:33:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (630, 25, 1, 1, 'Stich(Anaesthesia)', '2500.00', NULL, '', '', '2022-01-13 00:34:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (631, 22, 1, 1, 'Tonsilities', '6000.00', NULL, '', '', '2022-01-13 00:34:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (632, 25, 1, 1, 'Hydrocyl', '2500.00', NULL, '', '', '2022-01-13 00:35:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (633, 25, 1, 1, 'TURP', '4000.00', NULL, '', '', '2022-01-13 00:35:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (634, 25, 1, 1, 'Circumcession(Anaesthesia)', '1000.00', NULL, '', '', '2022-01-13 00:35:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (635, 25, 1, 1, 'Tendor Repair', '7000.00', NULL, '', '', '2022-01-13 00:36:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (636, 25, 1, 1, 'Circumcession(Local)', '700.00', NULL, '', '', '2022-01-13 00:37:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (637, 25, 1, 1, 'Cistostopy', '2000.00', NULL, '', '', '2022-01-13 00:39:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (638, 25, 1, 1, 'Dilatation(Anaesthesia)', '2000.00', NULL, '', '', '2022-01-13 00:41:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (639, 25, 1, 1, 'Dilatation(Local)', '700.00', NULL, '', '', '2022-01-13 00:43:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (640, 25, 1, 1, 'Excision of the Encephalocele', '12000.00', NULL, '', '', '2022-01-13 00:44:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (641, 25, 1, 1, 'Fistula(Perianal)', '2500.00', NULL, '', '', '2022-01-13 00:46:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (642, 25, 1, 1, 'Gallbladder', '4000.00', NULL, '', '', '2022-01-13 00:47:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (643, 26, 1, 1, 'Abcess Drain (LA)', '1000.00', NULL, '', '', '2022-01-13 01:52:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (644, 26, 1, 1, 'Abcess Drain with GA', '5000.00', NULL, '', '', '2022-01-13 01:53:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (645, 26, 1, 1, 'Circumcision (Adult)', '2000.00', NULL, '', '', '2022-01-13 01:55:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (646, 26, 1, 1, 'Circumcision (GA)', '4000.00', NULL, '', '', '2022-01-13 01:56:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (647, 26, 1, 1, 'Circumcision (LA)', '1500.00', NULL, '', '', '2022-01-13 01:57:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (648, 26, 1, 1, 'Consultant Fee', '1000.00', NULL, '', '', '2022-01-13 01:58:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (649, 26, 1, 1, 'Drain Abses', '500.00', NULL, '', '', '2022-01-13 01:59:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (650, 26, 1, 1, 'ECT', '2500.00', NULL, '', '', '2022-01-13 02:00:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (651, 26, 1, 1, 'Excision Biopsy (SA)', '3500.00', NULL, '', '', '2022-01-13 02:03:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (652, 26, 1, 1, 'Excision Tissue', '1500.00', NULL, '', '', '2022-01-13 02:04:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (653, 26, 1, 1, 'Fibroadinoma', '10000.00', NULL, '', '', '2022-01-13 02:05:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (654, 26, 1, 1, 'Fissurcetomy', '6000.00', NULL, '', '', '2022-01-13 02:06:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (655, 26, 1, 1, 'Foreign Body Removal', '500.00', NULL, '', '', '2022-01-13 02:07:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (656, 26, 1, 1, 'Foreign Body Removal (Catamine)', '2000.00', NULL, '', '', '2022-01-13 02:08:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (657, 26, 1, 1, 'Foreign Body Removal (La)', '800.00', NULL, '', '', '2022-01-13 02:10:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (658, 26, 1, 1, 'Ligation', '1000.00', NULL, '', '', '2022-01-13 02:11:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (659, 26, 1, 1, 'OT Team Charge', '9000.00', NULL, '', '', '2022-01-13 02:12:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (660, 26, 1, 1, 'Perinaeal Tear (1st Degree)', '1500.00', NULL, '', '', '2022-01-13 02:13:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (661, 26, 1, 1, 'Report repeat (USG)', '200.00', NULL, '', '', '2022-01-13 02:14:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (663, 28, 1, 2, 'Admission Fees', '100.00', NULL, '', '', '2022-02-18 12:21:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (664, 29, 1, 2, 'Advance', '2000.00', NULL, '', '', '2022-02-18 12:31:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (666, 18, 1, 2, 'Dr.Kamal FCPS-USA', '6000.00', NULL, '', '', '2022-02-18 12:56:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (667, 2, 1, 2, 'CBC/CP/Blood RE', '500.00', NULL, '', '', '2022-02-25 23:37:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (668, 2, 1, 2, 'TOTAL PLATELET COUNT', '500.00', NULL, '', '', '2022-02-25 23:45:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (669, 2, 1, 2, 'PCV (HCT)', '500.00', NULL, '', '', '2022-02-25 23:46:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (670, 2, 1, 2, 'BT. & C.T', '500.00', NULL, '', '', '2022-02-25 23:52:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (671, 2, 1, 2, 'P.B.F', '500.00', NULL, '', '', '2022-02-25 23:52:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (672, 2, 1, 2, 'MP(Malarial Parasites)', '500.00', NULL, '', '', '2022-02-25 23:54:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (673, 2, 1, 2, 'FBS/RBS/PPBS(75 glucose).', '200.00', NULL, '', '', '2022-02-25 23:55:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (674, 2, 1, 2, 'S. Bilirubin', '500.00', NULL, '', '', '2022-02-26 00:00:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (675, 2, 1, 2, 'ASO Test ', '500.00', NULL, '', '', '2022-02-26 00:02:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (676, 2, 1, 2, 'CRP(C-Reactive Protein)', '500.00', NULL, '', '', '2022-02-26 00:14:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (677, 2, 1, 2, '2 Hrs after BF/75 glucose', '200.00', NULL, '', '', '2022-02-26 00:16:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (678, 2, 1, 2, 'Alkaline Phosphates (ALP)', '500.00', NULL, '', '', '2022-02-26 00:16:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (679, 2, 1, 2, 'S. Total Cholesterol', '500.00', NULL, '', '', '2022-02-26 00:17:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (680, 2, 1, 2, 'LDL', '500.00', NULL, '', '', '2022-02-26 00:18:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (681, 2, 1, 2, 'Uric Acid', '500.00', NULL, '', '', '2022-02-26 00:19:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (682, 2, 1, 2, 'Blood Urea/BUN', '500.00', NULL, '', '', '2022-02-26 00:19:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (683, 2, 1, 2, 'Blood Grouping & RH F actor ', '100.00', NULL, '', '', '2022-02-26 00:20:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (684, 2, 1, 2, 'Anti HAV Igm', '2000.00', NULL, '', '', '2022-02-26 00:21:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (685, 2, 1, 2, 'S. Calcium (Ca++)', '600.00', NULL, '', '', '2022-02-26 00:21:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (686, 2, 1, 2, 'S. Electroytes ', '1000.00', NULL, '', '', '2022-02-26 00:22:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (687, 2, 1, 2, 'ASO (Quantitative) Test', '500.00', NULL, '', '', '2022-02-26 00:23:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (688, 2, 1, 2, 'MP (ICT Method)', '500.00', NULL, '', '', '2022-02-26 00:23:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (689, 2, 1, 2, 'Urine Albumin/ Urine Sugar', '200.00', NULL, '', '', '2022-02-26 00:24:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (690, 2, 1, 2, 'Albumin/Globulin (A/G) Ratio', '1000.00', NULL, '', '', '2022-02-26 00:25:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (691, 2, 1, 2, 'CRP (Quantitative) Test', '800.00', NULL, '', '', '2022-02-26 00:25:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (692, 2, 1, 2, 'Tuberculin Test / Mantoux test (MT)', '500.00', NULL, '', '', '2022-02-26 00:26:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (693, 2, 1, 2, 'CKMB', '700.00', NULL, '', '', '2022-02-26 00:27:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (694, 2, 1, 2, 'RA/RF (Quantitative)', '500.00', NULL, '', '', '2022-02-26 00:27:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (695, 2, 1, 2, 'PSA (ICT Method)', '700.00', NULL, '', '', '2022-02-26 00:27:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (696, 2, 1, 2, 'PSA Level (ELISA Method)', '1200.00', NULL, '', '', '2022-02-26 00:28:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (697, 2, 1, 2, 'HBeAG (Elisa/Confirmatory)', '1100.00', NULL, '', '', '2022-02-26 00:28:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (698, 2, 1, 2, 'HBeAG (ICT Method)', '600.00', NULL, '', '', '2022-02-26 00:30:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (699, 2, 1, 2, 'Iron Profile', '3000.00', NULL, '', '', '2022-02-26 00:30:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (700, 2, 1, 2, 'TIBC', '1000.00', NULL, '', '', '2022-02-26 00:31:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (701, 2, 1, 2, 'Serum Lipase', '1200.00', NULL, '', '', '2022-02-26 00:31:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (702, 2, 1, 2, 'Urine C/S', '1500.00', NULL, '', '', '2022-02-26 00:32:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (703, 2, 1, 2, 'HIV (Screening)', '500.00', NULL, '', '', '2022-02-26 00:32:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (704, 2, 1, 2, '25 (OH)vitamin D', '2000.00', NULL, '', '', '2022-02-26 00:33:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (705, 2, 1, 2, 'TPHA (ICT Method)', '500.00', NULL, '', '', '2022-02-26 00:33:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (706, 2, 1, 2, 'CEA (ELISA Method)', '1200.00', NULL, '', '', '2022-02-26 00:34:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (707, 2, 1, 2, 'Urine for R/E', '200.00', NULL, '', '', '2022-02-26 00:34:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (708, 2, 1, 2, 'Blood C/S', '2500.00', NULL, '', '', '2022-02-26 00:35:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (709, 2, 1, 2, 'Troponin-l (ELISA Method) ', '800.00', NULL, '', '', '2022-02-26 00:36:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (710, 2, 1, 2, 'Stool for R/E', '500.00', NULL, '', '', '2022-02-26 00:36:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (711, 2, 1, 2, 'Prothrombin Time(PR) INR', '1200.00', NULL, '', '', '2022-02-26 00:37:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (712, 2, 1, 2, 'Anti HAV (ELISA Method)', '800.00', NULL, '', '', '2022-02-26 00:37:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (713, 2, 1, 2, 'Stool Redu. Substance', '500.00', NULL, '', '', '2022-02-26 00:37:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (714, 2, 1, 2, 'Total Circulating Eosinophil Count (TCEC)', '500.00', NULL, '', '', '2022-02-26 00:38:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (715, 2, 1, 2, 'CA-15.3', '2000.00', NULL, '', '', '2022-02-26 00:39:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (716, 2, 1, 2, 'F, T3', '700.00', NULL, '', '', '2022-02-26 00:40:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (717, 2, 1, 2, 'F,T4', '700.00', NULL, '', '', '2022-02-26 00:41:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (718, 2, 1, 2, 'F, T3, F. T4', '1400.00', NULL, '', '', '2022-02-26 00:43:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (719, 2, 1, 2, 'CA-199.9', '2000.00', NULL, '', '', '2022-02-26 00:44:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (720, 2, 1, 2, 'ProBNP', '3500.00', NULL, '', '', '2022-02-26 00:45:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (721, 2, 1, 2, 'Vitamin D3 Level', '2500.00', NULL, '', '', '2022-02-26 00:47:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (722, 2, 1, 2, 'S. PROLACTIN (PRL)', '1200.00', NULL, '', '', '2022-02-26 00:48:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (723, 2, 1, 2, 'Serum hCG', '1100.00', NULL, '', '', '2022-02-26 00:49:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (724, 2, 1, 2, 'Β HCG', '1600.00', NULL, '', '', '2022-02-26 00:50:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (725, 2, 1, 2, 'Skin Scrapping for Fungus', '800.00', NULL, '', '', '2022-02-26 00:51:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (726, 2, 1, 2, 'Vitamin D', '500.00', NULL, '', '', '2022-02-26 00:52:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (727, 2, 1, 2, 'Cross-Matching screeing,VDRL,HBSAG,HIV,HCV', '1600.00', NULL, '', '', '2022-02-26 00:53:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (728, 2, 1, 2, 'FSH', '800.00', NULL, '', '', '2022-02-26 00:54:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (729, 2, 1, 2, 'LH', '800.00', NULL, '', '', '2022-02-26 00:56:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (730, 2, 1, 2, 'Cross-Matching', '500.00', NULL, '', '', '2022-02-26 00:57:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (731, 58, 1, 2, 'ECG', '500.00', NULL, '', '', '2022-02-26 00:59:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (732, 19, 1, 2, 'CPK', '1200.00', NULL, '', '', '2022-02-26 01:02:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (733, 2, 1, 2, 'Anti HBC IgM/ IgG', '800.00', NULL, '', '', '2022-02-26 01:04:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (734, 19, 1, 2, 'ETT', '2600.00', NULL, '', '', '2022-02-26 01:05:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (735, 19, 1, 2, 'Echocardiography (2D)', '1500.00', NULL, '', '', '2022-02-26 01:06:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (736, 19, 1, 2, 'Echocardiography (Colour Dopler)', '2500.00', NULL, '', '', '2022-02-26 01:07:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (737, 19, 1, 2, 'USG of W/A', '700.00', NULL, '', '', '2022-02-26 01:08:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (739, 19, 1, 2, 'USG of L/A', '600.00', NULL, '', '', '2022-02-26 01:10:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (740, 20, 1, 2, 'X-Ray L/S Spine B/V', '900.00', NULL, '', '', '2022-02-26 01:14:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (741, 20, 1, 2, 'X-Ray CXR', '500.00', NULL, '', '', '2022-02-26 01:15:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (742, 20, 1, 2, 'X-Ray KUB', '500.00', NULL, '', '', '2022-02-26 01:16:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (743, 20, 1, 2, 'X-Ray PNS', '500.00', NULL, '', '', '2022-02-26 01:18:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (744, 31, 1, 2, 'Free Doctor Visit', '0.01', NULL, '', '', '2022-02-26 15:52:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (746, 32, 1, 2, 'General Bed', '500.00', NULL, '', '', '2022-02-28 09:45:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (747, 32, 1, 2, 'Cabin single', '1200.00', NULL, '', '', '2022-02-28 09:50:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (748, 32, 1, 2, 'Cabin Double', '1500.00', NULL, '', '', '2022-02-28 09:51:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (749, 33, 1, 2, 'Doctor Round', '300.00', NULL, '', '', '2022-02-28 10:14:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (750, 34, 1, 2, 'OT charge(2000)', '2000.00', NULL, '', '', '2022-02-28 10:25:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (751, 34, 1, 2, 'OT Charge(2500)', '2500.00', NULL, '', '', '2022-02-28 10:32:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (752, 34, 1, 2, 'OT Charge', '3000.00', NULL, '', '', '2022-02-28 10:35:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (753, 42, 1, 2, 'Dressing Charges', '500.00', NULL, '', '', '2022-02-28 10:40:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (754, 38, 1, 2, 'Service Charges', '200.00', NULL, '', '', '2022-02-28 10:41:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (755, 37, 1, 2, 'Assist fees', '1500.00', NULL, '', '', '2022-02-28 10:42:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (756, 45, 1, 2, 'Sewing', '300.00', NULL, '', '', '2022-02-28 10:48:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (758, 46, 1, 2, 'Emergency', '100.00', NULL, '', '', '2022-02-28 22:16:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (761, 46, 1, 2, 'Nebulaization', '100.00', NULL, '', '', '2022-03-01 08:16:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (762, 46, 1, 2, 'Injection push', '100.00', NULL, '', '', '2022-03-01 08:27:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (763, 49, 1, 2, 'Cannula Change(100)', '100.00', NULL, '', '', '2022-03-01 08:35:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (764, 35, 1, 2, 'Surgeon fees', '4000.00', NULL, '', '', '2022-03-01 08:52:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (765, 18, 1, 2, 'Dr. Selim Hossen', '300.00', NULL, '', '', '2022-03-01 18:25:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (766, 18, 1, 2, 'Dr.Sumaiya MBBS (DU)', '300.00', NULL, '', '', '2022-03-01 18:33:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (767, 15, 1, 2, 'Unine Exam', '900.00', NULL, '', '', '2022-03-04 21:22:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (768, 45, 1, 2, 'Cannula installation', '100.00', NULL, '', '', '2022-03-07 00:18:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (769, 55, 1, 2, 'Doctor Round-Specialist', '500.00', NULL, '', '', '2022-03-11 12:19:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (770, 36, 1, 2, 'Anesthesia', '1500.00', NULL, '', '', '2022-03-11 12:27:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (771, 2, 1, 2, 'PT-INR', '1200.00', NULL, '', '', '2022-03-12 12:51:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (772, 18, 1, 2, 'Dr. Israt Jahan MBBS(dhaka)', '300.00', NULL, '', '', '2022-03-19 12:13:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (773, 39, 1, 2, 'Dressings', '500.00', NULL, '', '', '2022-03-20 13:16:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (774, 56, 1, 2, 'othres', '500.00', NULL, '', '', '2022-03-20 13:20:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (775, 18, 1, 2, 'Dr.Asif Nawaz (Roki)', '300.00', NULL, '', '', '2022-03-21 11:34:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (776, 57, 1, 2, 'Oxygen ', '200.00', NULL, '', '', '2022-03-21 14:07:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (777, 52, 1, 2, 'Oxygen', '200.00', NULL, '', '', '2022-03-21 22:43:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (778, 2, 1, 2, 'CRP (Quantitative)', '500.00', NULL, '', '', '2022-03-24 19:33:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (779, 18, 1, 2, 'Dr.M Tanvir (MBBS, MPH)', '300.00', NULL, '', '', '2022-03-24 21:12:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (780, 2, 1, 2, 'S.Testosterone', '1200.00', NULL, '', '', '2022-03-26 15:10:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (781, 19, 1, 2, 'no_charge', '0.01', NULL, '', '', '2022-03-31 21:33:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (782, 2, 1, 2, 't4', '700.00', NULL, '', '', '2022-04-01 13:07:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (783, 18, 1, 2, 'Dr. Cap. Hosne Ara', '500.00', NULL, '', '', '2022-04-02 14:44:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (784, 19, 1, 2, 'USG of TVS', '2000.00', NULL, '', '', '2022-04-04 13:16:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (785, 19, 1, 2, 'USG of Pregnancy Profile Congenital anomaly C ', '2500.00', NULL, '', '', '2022-04-24 20:03:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (786, 59, 1, 2, 'Package', '7000.00', NULL, '', '', '2022-05-06 12:09:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (787, 2, 1, 2, 'S.eoscrogen', '1500.00', NULL, '', '', '2022-05-16 11:35:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (788, 2, 1, 2, 'Urinary Amylase', '500.00', NULL, '', '', '2022-05-16 11:37:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (789, 2, 1, 2, 'PBF', '800.00', NULL, '', '', '2022-05-19 18:01:09');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (790, 19, 1, 2, 'CTG-Cardiotocography', '500.00', NULL, '', '', '2022-05-26 12:01:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (791, 2, 1, 2, 'Anti DS DNA', '1200.00', NULL, '', '', '2022-06-01 11:08:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (792, 60, 1, 2, 'CT Scan PNS', '5000.00', NULL, '', '', '2022-06-01 12:43:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (793, 60, 1, 2, 'CT Scan of Brain', '4000.00', NULL, '', '', '2022-06-02 20:28:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (794, 19, 1, 2, 'FOL', '2000.00', NULL, '', '', '2022-06-02 21:27:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (795, 60, 1, 2, 'CT Scan of Orbits', '5000.00', NULL, '', '', '2022-06-03 11:12:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (796, 60, 1, 2, 'CT Scan of Mastoid', '5000.00', NULL, '', '', '2022-06-03 11:18:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (797, 60, 1, 2, 'CT Scan of Neck', '5500.00', NULL, '', '', '2022-06-03 11:21:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (798, 60, 1, 2, 'CT Scan of Chest', '5500.00', NULL, '', '', '2022-06-03 11:24:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (799, 19, 1, 2, 'HRCT of Chest', '6000.00', NULL, '', '', '2022-06-03 11:26:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (801, 60, 1, 2, 'CT Scan of Cervical Spine', '5500.00', NULL, '', '', '2022-06-03 11:33:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (802, 60, 1, 2, 'CT Scan of Dorsal Spine', '5500.00', NULL, '', '', '2022-06-03 11:35:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (803, 60, 1, 2, 'CT Scan of L/S Spine', '5500.00', NULL, '', '', '2022-06-03 11:45:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (804, 60, 1, 2, 'CT Scan of Upper Abdomen', '5500.00', NULL, '', '', '2022-06-03 11:55:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (805, 60, 1, 2, 'CT Scan of Lower Abdomen', '5500.00', NULL, '', '', '2022-06-03 11:58:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (806, 60, 1, 2, 'CT Scan of Whole Abdomen', '10000.00', NULL, '', '', '2022-06-03 12:01:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (807, 60, 1, 2, 'CT Scan of Pelvic', '5500.00', NULL, '', '', '2022-06-03 12:05:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (808, 60, 1, 2, 'CT scan of Thigh/Knee/Leg/Ankle/Foot', '5500.00', NULL, '', '', '2022-06-03 12:10:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (809, 60, 1, 2, 'CT scan of Nasopharynx', '5000.00', NULL, '', '', '2022-06-03 12:13:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (810, 60, 1, 2, 'CT scan of KUB', '10000.00', NULL, '', '', '2022-06-03 12:17:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (811, 60, 1, 2, 'CT scan of Maxillo-Facial', '5000.00', NULL, '', '', '2022-06-03 12:34:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (812, 60, 1, 2, 'CT scan of Skull', '4000.00', NULL, '', '', '2022-06-03 12:39:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (813, 60, 1, 2, 'CT scan of Pituitary Fossa', '5500.00', NULL, '', '', '2022-06-03 12:41:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (814, 60, 1, 2, 'CT scan of Wrist', '5500.00', NULL, '', '', '2022-06-03 12:43:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (815, 60, 1, 2, 'CT scan of HBS', '5500.00', NULL, '', '', '2022-06-03 12:46:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (816, 19, 1, 2, 'CT Film (Re-print-Per Flim)', '250.00', NULL, '', '', '2022-06-03 12:48:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (817, 19, 1, 2, 'Usg of anterior chest wall', '900.00', NULL, '', '', '2022-06-10 17:36:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (818, 19, 1, 2, 'Contrast (single)', '1500.00', NULL, '', '', '2022-06-20 22:02:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (819, 19, 1, 2, 'Contrast (Duble)', '2500.00', NULL, '', '', '2022-06-20 22:05:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (820, 2, 1, 2, 'Anti HBc (Total)', '1200.00', NULL, '', '', '2022-06-26 12:24:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (822, 2, 1, 2, 'CUS', '200.00', NULL, '', '', '2022-07-01 12:09:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (823, 18, 1, 2, 'Dr.Mahfuza Akter RMO MBBS (DU)', '300.00', NULL, '', '', '2022-07-07 12:48:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (824, 2, 1, 2, 'Triple Antigen', '800.00', NULL, ' ', '', '2022-07-26 18:29:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (825, 61, 1, 2, 'SWD', '200.00', NULL, '', '', '2022-07-27 16:13:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (826, 61, 1, 2, 'Traction', '200.00', NULL, '', '', '2022-07-27 16:40:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (827, 61, 1, 2, 'Tens', '200.00', NULL, '', '', '2022-07-27 16:46:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (828, 61, 1, 2, 'UST', '200.00', NULL, '', '', '2022-07-27 16:49:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (829, 61, 1, 2, 'IRR', '50.00', NULL, '', '', '2022-07-27 16:51:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (830, 61, 1, 2, 'Vibrator', '50.00', NULL, '', '', '2022-07-27 16:54:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (831, 61, 1, 2, 'IFT', '150.00', NULL, '', '', '2022-07-27 16:57:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (832, 61, 1, 2, 'MST', '200.00', NULL, '', '', '2022-07-27 17:01:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (833, 61, 1, 2, 'Waxbath', '150.00', NULL, '', '', '2022-07-27 17:03:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (834, 61, 1, 2, 'Static Cycling', '50.00', NULL, '', '', '2022-07-27 17:05:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (835, 61, 1, 2, 'Stroke', '200.00', NULL, '', '', '2022-07-27 17:07:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (836, 61, 1, 2, 'Bell\'s Palsy', '100.00', NULL, '', '', '2022-07-27 17:14:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (837, 61, 1, 2, 'Parkinson', '200.00', NULL, '', '', '2022-07-27 17:16:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (838, 61, 1, 2, 'LBP', '200.00', NULL, '', '', '2022-07-27 17:17:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (839, 61, 1, 2, 'Frozen Shoulder', '150.00', NULL, '', '', '2022-07-27 17:19:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (840, 61, 1, 2, 'Neck Pain', '100.00', NULL, '', '', '2022-07-27 17:21:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (841, 61, 1, 2, 'Elbow Pain', '100.00', NULL, '', '', '2022-07-27 17:23:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (842, 61, 1, 2, 'Wrist Pain', '100.00', NULL, '', '', '2022-07-27 17:29:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (843, 61, 1, 2, 'Knee Pain', '100.00', NULL, '', '', '2022-07-27 17:31:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (844, 61, 1, 2, 'Ankle Pain', '100.00', NULL, '', '', '2022-07-27 17:33:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (845, 61, 1, 2, 'Any Fracture', '200.00', NULL, '', '', '2022-07-27 17:37:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (846, 61, 1, 2, 'Rheumatoid Arthritis', '200.00', NULL, '', '', '2022-07-27 17:40:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (847, 61, 1, 2, 'Multiple Sclerosis', '200.00', NULL, '', '', '2022-07-27 17:43:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (848, 61, 1, 2, 'Head Injury', '100.00', NULL, '', '', '2022-07-27 17:45:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (849, 61, 1, 2, 'Acupuncture Therapy', '400.00', NULL, '', '', '2022-07-27 17:47:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (850, 61, 1, 2, 'PLID', '150.00', NULL, '', '', '2022-07-27 17:50:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (851, 61, 1, 2, 'Musculoskeletal', '150.00', NULL, '', '', '2022-07-27 17:53:04');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (852, 61, 1, 2, 'Neurological', '150.00', NULL, '', '', '2022-07-27 17:55:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (853, 60, 1, 2, 'CT Scan of Neck to chest ', '7500.00', NULL, '', '', '2022-07-28 20:53:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (854, 20, 1, 2, 'Naso-Endoscopy', '1000.00', NULL, '', '', '2022-07-29 13:26:32');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (855, 20, 1, 2, 'Micro Endoscopy', '1500.00', NULL, '', '', '2022-07-29 16:07:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (856, 55, 1, 2, 'Doctor Round-Specialist', '600.00', NULL, '', '', '2022-07-29 17:54:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (857, 30, 1, 2, 'Dr. Selim Hossen', '300.00', NULL, '', '', '2022-07-30 08:58:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (858, 62, 1, 2, 'Dr. Cap. Hosne Ara', '300.00', NULL, '', '', '2022-07-30 09:18:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (859, 63, 1, 2, 'Dr.Sumaiya', '300.00', NULL, '', '', '2022-07-30 09:22:05');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (860, 64, 1, 2, 'Dr.Mahfuza Akter', '300.00', NULL, '', '', '2022-07-30 09:23:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (861, 61, 1, 2, 'Stroke', '400.00', NULL, '', '', '2022-08-03 14:25:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (862, 61, 1, 2, 'LBP', '400.00', NULL, '', '', '2022-08-03 14:30:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (863, 61, 1, 2, 'PLID', '400.00', NULL, '', '', '2022-08-03 14:32:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (864, 61, 1, 2, 'GBS', '400.00', NULL, '', '', '2022-08-03 14:34:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (865, 61, 1, 2, 'Frozen Shoulder (Shoulder Pain)', '300.00', NULL, '', '', '2022-08-03 14:36:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (866, 61, 1, 2, 'Cervical Pain (Neck Pain)', '300.00', NULL, '', '', '2022-08-03 14:41:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (867, 61, 1, 2, 'Spinal Cord Injury', '300.00', NULL, '', '', '2022-08-03 14:43:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (868, 61, 1, 2, 'Tennis elbow (Elbow pain)', '300.00', NULL, '', '', '2022-08-03 14:51:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (869, 61, 1, 2, 'Knee pain', '300.00', NULL, '', '', '2022-08-03 14:56:41');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (870, 61, 1, 2, 'Osteoarthritis', '300.00', NULL, '', '', '2022-08-03 14:58:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (871, 61, 1, 2, 'Rheumatoid arthritis', '300.00', NULL, '', '', '2022-08-03 15:08:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (872, 61, 1, 2, 'Wrist pain', '300.00', NULL, '', '', '2022-08-03 15:10:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (873, 61, 1, 2, 'Post-operative fracture', '300.00', NULL, '', '', '2022-08-03 15:12:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (874, 61, 1, 2, 'Fracture', '300.00', NULL, '', '', '2022-08-03 15:14:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (875, 61, 1, 2, 'Hip joint pain', '300.00', NULL, '', '', '2022-08-03 15:15:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (876, 61, 1, 2, 'Ankle pain', '250.00', NULL, '', '', '2022-08-03 15:17:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (877, 61, 1, 2, 'Planter fasciitis', '250.00', NULL, '', '', '2022-08-03 15:19:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (878, 61, 1, 2, 'Sports injury', '300.00', NULL, '', '', '2022-08-03 15:20:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (879, 61, 1, 2, 'Bell\'s palsy / Facial palsy', '300.00', NULL, '', '', '2022-08-03 15:22:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (880, 61, 1, 2, 'Cerebral palsy', '300.00', NULL, '', '', '2022-08-03 15:24:45');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (881, 61, 1, 2, 'Acupuncture \\ Dry needing therapy', '500.00', NULL, '', '', '2022-08-03 15:26:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (882, 61, 1, 2, 'Hijama therapy', '1000.00', NULL, '', '', '2022-08-03 15:29:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (883, 61, 1, 2, 'Muscle pain', '250.00', NULL, '', '', '2022-08-03 15:30:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (884, 65, 1, 2, 'Photo Therapy', '500.00', NULL, '', '', '2022-08-04 16:21:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (885, 65, 1, 2, 'Service Charge', '200.00', NULL, '', '', '2022-08-04 16:27:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (886, 65, 1, 2, 'Bed Charge', '500.00', NULL, '', '', '2022-08-04 16:28:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (887, 65, 1, 2, 'Baby Cott', '500.00', NULL, '', '', '2022-08-04 16:31:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (888, 65, 1, 2, 'Pulse Oxymeter', '200.00', NULL, '', '', '2022-08-04 16:32:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (889, 65, 1, 2, 'Doctor Round Fee', '300.00', NULL, '', '', '2022-08-04 16:32:59');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (890, 2, 1, 2, 'Biopsy of Breast', '3500.00', NULL, '', '', '2022-08-07 11:33:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (891, 19, 1, 2, 'USG of Popliteal Fossa', '900.00', NULL, '', '', '2022-08-07 20:45:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (892, 2, 1, 2, 'Wound Swab for C/S', '1500.00', NULL, '', '', '2022-08-24 17:08:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (893, 19, 1, 2, 'USG of Neck', '900.00', NULL, '', '', '2022-08-26 18:08:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (894, 38, 1, 2, 'NG-Tube', '500.00', NULL, '', '', '2022-08-27 12:50:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (895, 32, 1, 2, 'Single AC Cabin', '2500.00', NULL, '', '', '2022-08-31 18:13:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (896, 53, 1, 2, 'VIP AC Cabin', '3500.00', NULL, '', '', '2022-08-31 19:58:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (897, 53, 1, 2, 'Single AC Cabin', '2500.00', NULL, '', '', '2022-08-31 20:10:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (898, 53, 1, 2, 'Single Non AC Cabin', '1200.00', NULL, '', '', '2022-08-31 20:15:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (899, 53, 1, 2, 'Double AC Cabin (Sharing)', '1500.00', NULL, '', '', '2022-08-31 20:16:55');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (900, 53, 1, 2, 'Double AC Cabin (Single Full)', '3000.00', NULL, '', '', '2022-08-31 20:18:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (901, 53, 1, 2, 'Double Non AC Cabin (Sharing)', '1000.00', NULL, '', '', '2022-08-31 20:20:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (902, 53, 1, 2, 'Double Non AC Cabin (Single Full)', '2000.00', NULL, '', '', '2022-08-31 20:22:35');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (903, 53, 1, 2, 'General Bed', '500.00', NULL, '', '', '2022-08-31 20:24:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (904, 19, 1, 2, 'USG of both Axilla', '1300.00', NULL, '', '', '2022-09-02 11:11:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (905, 20, 1, 2, 'Barium swallow of esophagus', '1200.00', NULL, '', '', '2022-09-02 11:13:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (906, 20, 1, 2, 'Barium Meal stomach and duodenum', '1200.00', NULL, '', '', '2022-09-02 11:15:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (907, 20, 1, 2, 'IVU (intravenous urogram)', '2500.00', NULL, '', '', '2022-09-02 11:22:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (908, 20, 1, 2, 'RGU & MCU (Retrograde Urethrography & Micturating Cystourethrography)', '2500.00', NULL, '', '', '2022-09-02 11:26:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (909, 20, 1, 2, 'Fistulogram', '2500.00', NULL, '', '', '2022-09-02 11:28:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (910, 20, 1, 2, 'Sinogram', '2500.00', NULL, '', '', '2022-09-02 11:30:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (911, 20, 1, 2, 'T-tube cholangiogram', '2500.00', NULL, '', '', '2022-09-02 11:32:06');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (912, 20, 1, 2, 'Distal Loopogram', '2500.00', NULL, '', '', '2022-09-02 11:33:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (913, 2, 1, 2, 'L.F.T (Liver Function Test)', '1600.00', NULL, '', '', '2022-09-15 20:03:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (914, 2, 1, 2, 'HB- Electrophoresis', '2200.00', NULL, '', '', '2022-09-15 20:05:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (915, 30, 1, 2, 'Dr. MD. Radoyanul Islam', '300.00', NULL, '', '', '2022-09-17 18:32:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (916, 30, 1, 2, 'Dr. Sirazul Islam Khan', '300.00', NULL, '', '', '2022-09-17 18:37:14');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(1) DEFAULT 0,
  `is_read` int(1) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_patient_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_patient_id` (`create_patient_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cheque_manger
#

DROP TABLE IF EXISTS `cheque_manger`;

CREATE TABLE `cheque_manger` (
  `cheque_id` varchar(100) NOT NULL,
  `transection_id` varchar(100) NOT NULL,
  `customer_id` varchar(100) NOT NULL,
  `bank_id` varchar(100) NOT NULL,
  `cheque_no` varchar(100) NOT NULL,
  `date` varchar(50) NOT NULL,
  `transection_type` varchar(100) NOT NULL,
  `cheque_status` varchar(30) NOT NULL,
  `amount` float NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: company_information
#

DROP TABLE IF EXISTS `company_information`;

CREATE TABLE `company_information` (
  `company_id` varchar(50) NOT NULL,
  `company_name` varchar(250) NOT NULL,
  `email` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `mobile` varchar(30) NOT NULL,
  `website` varchar(50) NOT NULL,
  `status` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `company_information` (`company_id`, `company_name`, `email`, `address`, `mobile`, `website`, `status`) VALUES ('NOILG8EGCRXXBWUEUQBM', 'bdtask Shop', 'bdtask@gmail.com', 'B-25, Mannan Plaza, 4th Floor, Khilkhet\r\nDhaka-1229, Bangladesh ', '1922296392', 'http://www.bdtask.com', 1);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`),
  CONSTRAINT `complaint_ibfk_1` FOREIGN KEY (`complaint_type_id`) REFERENCES `complaint_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'Any', '', '2022-03-18 03:17:35');


#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `timezone` text DEFAULT NULL,
  `return_response` text DEFAULT NULL,
  `api_type` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `created_id` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_3` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_4` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_5` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `consult_charges_ibfk_1` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`),
  CONSTRAINT `consultant_register_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consultant_register_ibfk_2` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` varchar(250) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: currency_tbl
#

DROP TABLE IF EXISTS `currency_tbl`;

CREATE TABLE `currency_tbl` (
  `id` int(11) NOT NULL,
  `currency_name` varchar(50) NOT NULL,
  `icon` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `currency_tbl` (`id`, `currency_name`, `icon`) VALUES (1, 'Taka', 'à§³');
INSERT INTO `currency_tbl` (`id`, `currency_name`, `icon`) VALUES (2, 'Azerbaijan Manat', 'â‚¼');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15825 DEFAULT CHARSET=utf8;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (76, 0, 2, '106', '2022-03-19 11:14:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (77, 0, 3, 'X-Ray', '2022-03-19 11:14:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (78, 0, 2, '106', '2022-03-19 11:13:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (79, 0, 3, 'USG', '2022-03-19 11:13:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (80, 60, 2, '106', '2022-03-19 11:13:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (81, 60, 3, 'USG', '2022-03-19 11:13:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (82, 59, 2, '106', '2022-03-19 11:14:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (83, 59, 3, 'X-Ray', '2022-03-19 11:14:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (84, 82, 1, '', '2022-03-19 12:38:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (85, 0, 2, '106', '2022-03-19 13:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (86, 0, 3, 'USG', '2022-03-19 13:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (87, 61, 2, '106', '2022-03-19 13:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (88, 61, 3, 'USG', '2022-03-19 13:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (89, 62, 2, '', '2022-03-19 17:19:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (90, 62, 3, 'X-Ray', '2022-03-19 17:19:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (91, 83, 1, '', '2022-03-19 20:15:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (92, 84, 1, '', '2022-03-19 20:46:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (93, 63, 2, '', '2022-03-19 20:52:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (94, 63, 3, 'X-Ray', '2022-03-19 20:52:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (95, 64, 2, '', '2022-03-19 21:32:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (96, 64, 3, 'X-Ray', '2022-03-19 21:32:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (97, 65, 2, '', '2022-03-19 21:42:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (98, 65, 3, 'X-Ray', '2022-03-19 21:42:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (99, 66, 2, '106', '2022-03-20 08:14:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (100, 66, 3, 'X-Ray', '2022-03-20 08:14:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (101, 85, 1, '107', '2022-03-20 08:14:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (102, 86, 1, '', '2022-03-20 09:02:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (103, 87, 1, '', '2022-03-20 10:29:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (104, 67, 2, '', '2022-03-20 10:41:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (105, 67, 3, 'USG', '2022-03-20 10:41:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (106, 88, 1, '', '2022-03-20 10:42:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (107, 68, 2, '', '2022-03-20 10:49:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (108, 68, 3, 'X-Ray', '2022-03-20 10:49:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (109, 89, 1, '', '2022-03-20 10:51:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (110, 69, 2, '', '2022-03-20 11:23:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (111, 69, 3, 'X-Ray', '2022-03-20 11:23:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (112, 90, 1, '', '2022-03-20 11:52:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (113, 91, 1, '', '2022-03-20 12:20:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (114, 92, 1, '107', '2022-03-20 14:05:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (115, 70, 2, '106', '2022-03-20 16:03:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (116, 70, 3, 'X-Ray', '2022-03-20 16:03:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (117, 93, 1, '107', '2022-03-20 16:26:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (118, 71, 2, '', '2022-03-20 17:00:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (119, 71, 3, 'X-Ray', '2022-03-20 17:00:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (120, 72, 2, '', '2022-03-20 17:45:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (121, 72, 3, 'X-Ray', '2022-03-20 17:45:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (122, 94, 1, '', '2022-03-20 18:14:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (123, 73, 2, '', '2022-03-20 19:12:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (124, 73, 3, 'USG', '2022-03-20 19:12:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (125, 95, 1, '', '2022-03-20 19:12:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (126, 96, 1, '', '2022-03-20 19:25:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (127, 74, 2, '', '2022-03-20 19:27:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (128, 74, 3, 'X-Ray', '2022-03-20 19:27:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (129, 97, 1, '107', '2022-03-20 19:50:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (130, 98, 1, '', '2022-03-20 19:53:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (131, 75, 2, '', '2022-03-20 19:56:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (132, 75, 3, 'X-Ray', '2022-03-20 19:56:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (133, 99, 1, '', '2022-03-20 19:58:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (134, 100, 1, '', '2022-03-20 19:59:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (135, 101, 1, '107', '2022-03-20 20:16:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (136, 76, 2, '', '2022-03-20 20:18:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (137, 76, 3, 'USG', '2022-03-20 20:18:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (138, 102, 1, '', '2022-03-20 21:36:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (139, 103, 1, '', '2022-03-21 09:09:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (140, 104, 1, '', '2022-03-21 09:11:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (141, 105, 1, '', '2022-03-21 09:13:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (142, 106, 1, '', '2022-03-21 09:16:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (143, 107, 1, '', '2022-03-21 09:18:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (144, 108, 1, '', '2022-03-21 09:54:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (145, 77, 2, '', '2022-03-21 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (146, 77, 3, 'USG', '2022-03-21 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (147, 109, 1, '', '2022-03-21 10:26:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (148, 78, 2, '', '2022-03-21 10:28:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (149, 78, 3, 'X-Ray', '2022-03-21 10:28:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (150, 79, 2, '', '2022-03-21 10:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (151, 79, 3, 'USG', '2022-03-21 10:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (152, 110, 1, '107', '2022-03-21 10:57:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (153, 80, 2, '', '2022-03-21 10:58:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (154, 80, 3, 'USG', '2022-03-21 10:58:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (155, 111, 1, '107', '2022-03-21 11:08:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (156, 112, 1, '', '2022-03-21 11:38:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (157, 113, 1, '', '2022-03-21 12:01:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (158, 81, 2, '', '2022-03-21 12:02:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (159, 81, 3, 'USG', '2022-03-21 12:02:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (160, 114, 1, '107', '2022-03-21 12:17:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (161, 82, 2, '', '2022-03-21 12:38:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (162, 82, 3, 'X-Ray', '2022-03-21 12:38:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (163, 83, 2, '', '2022-03-21 12:43:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (164, 83, 3, 'X-Ray', '2022-03-21 12:43:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (165, 84, 2, '', '2022-03-21 13:28:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (166, 84, 3, 'X-Ray', '2022-03-21 13:28:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (167, 115, 1, '107', '2022-03-21 13:52:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (168, 85, 2, '106', '2022-03-21 13:57:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (169, 85, 3, 'X-Ray', '2022-03-21 13:57:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (170, 116, 1, '107', '2022-03-21 14:51:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (171, 86, 2, '', '2022-03-21 14:54:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (172, 86, 3, 'USG', '2022-03-21 14:54:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (173, 87, 2, '', '2022-03-21 15:12:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (174, 87, 3, 'X-Ray', '2022-03-21 15:12:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (175, 117, 1, '', '2022-03-21 17:08:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (176, 88, 2, '', '2022-03-21 17:09:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (177, 88, 3, 'USG', '2022-03-21 17:09:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (178, 89, 2, '', '2022-03-21 17:22:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (179, 89, 3, 'X-Ray', '2022-03-21 17:22:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (180, 90, 2, '', '2022-03-21 17:30:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (181, 90, 3, 'X-Ray', '2022-03-21 17:30:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (182, 91, 2, '106', '2022-03-21 17:46:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (183, 91, 3, 'X-Ray', '2022-03-21 17:46:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (184, 92, 2, '', '2022-03-21 17:57:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (185, 92, 3, 'X-Ray', '2022-03-21 17:57:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (186, 93, 2, '', '2022-03-21 18:42:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (187, 93, 3, 'X-Ray', '2022-03-21 18:42:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (188, 118, 1, '107', '2022-03-21 18:43:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (189, 119, 1, '107', '2022-03-21 19:56:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (190, 94, 2, '106', '2022-03-21 20:01:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (191, 94, 3, 'X-Ray', '2022-03-21 20:01:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (192, 120, 1, '', '2022-03-21 20:18:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (193, 95, 2, '', '2022-03-21 21:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (194, 95, 3, 'USG', '2022-03-21 21:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (195, 96, 2, '', '2022-03-22 09:47:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (196, 96, 3, 'USG', '2022-03-22 09:47:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (197, 121, 1, '', '2022-03-22 10:27:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (198, 97, 2, '', '2022-03-22 10:31:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (199, 97, 3, 'X-Ray', '2022-03-22 10:31:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (200, 98, 2, '', '2022-03-22 10:38:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (201, 98, 3, 'X-Ray', '2022-03-22 10:38:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (202, 99, 2, '', '2022-03-22 10:41:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (203, 99, 3, 'USG', '2022-03-22 10:41:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (204, 122, 1, '', '2022-03-22 10:47:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (205, 123, 1, '', '2022-03-22 10:58:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (206, 100, 2, '', '2022-03-22 11:00:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (207, 100, 3, 'X-Ray', '2022-03-22 11:00:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (208, 101, 2, '', '2022-03-22 11:08:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (209, 101, 3, 'X-Ray', '2022-03-22 11:08:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (210, 102, 2, '', '2022-03-22 11:15:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (211, 102, 3, 'X-Ray', '2022-03-22 11:15:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (212, 103, 2, '106', '2022-03-22 11:47:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (213, 103, 3, 'X-Ray', '2022-03-22 11:47:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (214, 124, 1, '', '2022-03-22 11:57:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (215, 104, 2, '', '2022-03-22 12:01:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (216, 104, 3, 'X-Ray', '2022-03-22 12:01:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (217, 105, 2, '106', '2022-03-22 12:05:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (218, 105, 3, 'USG', '2022-03-22 12:05:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (219, 106, 2, '', '2022-03-22 12:24:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (220, 106, 3, 'USG', '2022-03-22 12:24:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (221, 107, 2, '', '2022-03-22 13:15:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (222, 107, 3, 'USG', '2022-03-22 13:15:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (223, 125, 1, '107', '2022-03-22 13:16:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (224, 108, 2, '', '2022-03-22 13:53:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (225, 108, 3, 'X-Ray', '2022-03-22 13:53:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (226, 126, 1, '', '2022-03-22 16:15:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (227, 127, 1, '', '2022-03-22 17:00:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (228, 109, 2, '', '2022-03-22 17:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (229, 109, 3, 'USG', '2022-03-22 17:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (230, 110, 2, '', '2022-03-22 17:16:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (231, 110, 3, 'X-Ray', '2022-03-22 17:16:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (232, 111, 2, '', '2022-03-22 17:41:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (233, 111, 3, 'X-Ray', '2022-03-22 17:41:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (234, 112, 2, '', '2022-03-22 17:42:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (235, 112, 3, 'USG', '2022-03-22 17:42:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (236, 113, 2, '', '2022-03-22 18:16:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (237, 113, 3, 'X-Ray', '2022-03-22 18:16:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (238, 114, 2, '', '2022-03-22 19:38:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (239, 114, 3, 'USG', '2022-03-22 19:38:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (240, 128, 1, '', '2022-03-22 19:49:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (241, 115, 2, '', '2022-03-22 19:50:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (242, 115, 3, 'X-Ray', '2022-03-22 19:50:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (243, 129, 1, '107', '2022-03-22 19:52:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (244, 116, 2, '', '2022-03-22 19:53:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (245, 116, 3, 'USG', '2022-03-22 19:53:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (246, 130, 1, '107', '2022-03-23 09:02:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (247, 131, 1, '', '2022-03-23 09:44:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (248, 132, 1, '', '2022-03-23 09:50:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (249, 117, 2, '', '2022-03-23 09:52:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (250, 117, 3, 'X-Ray', '2022-03-23 09:52:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (251, 133, 1, '', '2022-03-23 09:57:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (252, 118, 2, '', '2022-03-23 10:30:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (253, 118, 3, 'X-Ray', '2022-03-23 10:30:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (254, 134, 1, '', '2022-03-23 11:20:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (255, 119, 2, '', '2022-03-23 11:26:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (256, 119, 3, 'USG', '2022-03-23 11:26:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (257, 120, 2, '', '2022-03-23 11:28:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (258, 120, 3, 'X-Ray', '2022-03-23 11:28:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (259, 121, 2, '', '2022-03-23 11:31:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (260, 121, 3, 'X-Ray', '2022-03-23 11:31:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (261, 122, 2, '', '2022-03-23 12:02:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (262, 122, 3, 'X-Ray', '2022-03-23 12:02:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (263, 123, 2, '', '2022-03-23 12:32:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (264, 123, 3, 'X-Ray', '2022-03-23 12:32:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (265, 124, 2, '', '2022-03-23 12:49:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (266, 124, 3, 'X-Ray', '2022-03-23 12:49:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (267, 125, 2, '', '2022-03-23 13:12:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (268, 125, 3, 'USG', '2022-03-23 13:12:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (269, 126, 2, '', '2022-03-23 13:32:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (270, 126, 3, 'X-Ray', '2022-03-23 13:32:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (271, 127, 2, '', '2022-03-23 17:01:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (272, 127, 3, 'X-Ray', '2022-03-23 17:01:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (273, 128, 2, '', '2022-03-23 17:26:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (274, 128, 3, 'X-Ray', '2022-03-23 17:26:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (275, 135, 1, '', '2022-03-23 17:52:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (276, 129, 2, '', '2022-03-23 17:53:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (277, 129, 3, 'USG', '2022-03-23 17:53:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (278, 130, 2, '', '2022-03-23 18:15:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (279, 130, 3, 'X-Ray', '2022-03-23 18:15:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (280, 136, 1, '', '2022-03-24 09:17:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (281, 137, 1, '', '2022-03-24 09:32:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (282, 138, 1, '', '2022-03-24 10:12:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (283, 131, 2, '', '2022-03-24 10:14:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (284, 131, 3, 'X-Ray', '2022-03-24 10:14:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (285, 139, 1, '', '2022-03-24 11:01:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (286, 132, 2, '', '2022-03-24 11:15:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (287, 132, 3, 'X-Ray', '2022-03-24 11:15:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (288, 133, 2, '', '2022-03-24 11:17:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (289, 133, 3, 'X-Ray', '2022-03-24 11:17:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (290, 134, 2, '', '2022-03-24 11:27:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (291, 134, 3, 'USG', '2022-03-24 11:27:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (292, 135, 2, '', '2022-03-24 12:13:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (293, 135, 3, 'X-Ray', '2022-03-24 12:13:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (294, 140, 1, '', '2022-03-24 13:04:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (295, 141, 1, '', '2022-03-24 13:09:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (296, 136, 2, '', '2022-03-24 13:11:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (297, 136, 3, 'X-Ray', '2022-03-24 13:11:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (298, 137, 2, '', '2022-03-24 13:12:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (299, 137, 3, 'X-Ray', '2022-03-24 13:12:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (300, 138, 2, '', '2022-03-24 13:12:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (301, 138, 3, 'USG', '2022-03-24 13:12:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (302, 139, 2, '', '2022-03-24 16:49:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (303, 139, 3, 'X-Ray', '2022-03-24 16:49:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (304, 140, 2, '', '2022-03-24 17:27:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (305, 140, 3, 'X-Ray', '2022-03-24 17:27:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (306, 141, 2, '101', '2022-03-24 17:39:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (307, 141, 3, 'ECG', '2022-03-24 17:39:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (308, 142, 1, '', '2022-03-24 17:41:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (309, 142, 2, '', '2022-03-24 17:53:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (310, 142, 3, 'USG', '2022-03-24 17:53:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (311, 143, 2, '', '2022-03-24 18:05:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (312, 143, 3, 'X-Ray', '2022-03-24 18:05:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (313, 143, 1, '107', '2022-03-24 18:17:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (314, 144, 2, '', '2022-03-24 18:20:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (315, 144, 3, 'USG', '2022-03-24 18:20:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (316, 144, 1, '', '2022-03-24 19:21:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (317, 145, 1, '', '2022-03-24 19:34:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (318, 145, 2, '', '2022-03-24 19:51:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (319, 145, 3, 'X-Ray', '2022-03-24 19:51:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (320, 146, 2, '', '2022-03-24 19:53:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (321, 146, 3, 'X-Ray', '2022-03-24 19:53:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (322, 146, 1, '', '2022-03-24 19:54:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (323, 147, 2, '', '2022-03-24 19:57:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (324, 147, 3, 'X-Ray', '2022-03-24 19:57:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (325, 147, 1, '', '2022-03-24 20:01:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (326, 148, 2, '', '2022-03-24 20:02:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (327, 148, 3, 'X-Ray', '2022-03-24 20:02:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (328, 148, 1, '', '2022-03-24 20:08:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (329, 149, 1, '', '2022-03-24 20:09:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (330, 149, 2, '', '2022-03-24 20:11:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (331, 149, 3, 'X-Ray', '2022-03-24 20:11:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (332, 150, 2, '', '2022-03-24 20:18:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (333, 150, 3, 'USG', '2022-03-24 20:18:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (334, 150, 1, '107', '2022-03-24 20:20:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (335, 151, 1, '', '2022-03-24 20:22:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (336, 151, 2, '', '2022-03-24 20:45:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (337, 151, 3, 'USG', '2022-03-24 20:45:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (338, 152, 1, '', '2022-03-24 20:46:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (339, 153, 1, '', '2022-03-24 20:46:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (340, 152, 2, '', '2022-03-24 20:47:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (341, 152, 3, 'USG', '2022-03-24 20:47:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (342, 153, 2, '', '2022-03-24 20:49:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (343, 153, 3, 'USG', '2022-03-24 20:49:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (344, 0, 1, '', '2022-03-24 21:03:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (345, 155, 1, '', '2022-03-24 21:00:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (346, 154, 1, '', '2022-03-24 21:03:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (347, 154, 2, '', '2022-03-24 21:03:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (348, 154, 3, 'X-Ray', '2022-03-24 21:03:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (349, 155, 2, '', '2022-03-24 21:10:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (350, 155, 3, 'X-Ray', '2022-03-24 21:10:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (351, 156, 2, '', '2022-03-24 21:12:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (352, 156, 3, 'X-Ray', '2022-03-24 21:12:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (353, 157, 2, '', '2022-03-24 21:14:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (354, 157, 3, 'X-Ray', '2022-03-24 21:14:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (355, 156, 1, '', '2022-03-24 21:27:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (356, 157, 1, '', '2022-03-24 21:42:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (357, 158, 1, '', '2022-03-25 07:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (358, 159, 1, '', '2022-03-25 08:37:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (359, 160, 1, '', '2022-03-25 09:19:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (360, 161, 1, '', '2022-03-25 09:31:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (361, 162, 1, '', '2022-03-25 09:33:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (362, 163, 1, '', '2022-03-25 09:50:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (363, 164, 1, '', '2022-03-25 09:57:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (364, 165, 1, '107', '2022-03-25 09:59:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (365, 166, 1, '', '2022-03-25 10:03:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (366, 158, 2, '', '2022-03-25 10:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (367, 158, 3, 'ECG', '2022-03-25 10:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (368, 167, 1, '', '2022-03-25 10:06:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (369, 168, 1, '', '2022-03-25 10:09:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (370, 169, 1, '107', '2022-03-25 10:12:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (371, 159, 2, '', '2022-03-25 10:13:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (372, 159, 3, 'ECG', '2022-03-25 10:13:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (373, 0, 1, '', '2022-03-25 11:46:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (374, 0, 2, '', '2022-03-25 11:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (375, 0, 3, 'ECG', '2022-03-25 11:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (376, 0, 1, '', '2022-03-25 11:43:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (377, 161, 2, '', '2022-03-25 10:28:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (378, 161, 3, 'ECG', '2022-03-25 10:28:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (379, 172, 1, '', '2022-03-25 10:31:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (380, 162, 2, '', '2022-03-25 10:32:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (381, 162, 3, 'USG', '2022-03-25 10:32:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (382, 173, 1, '', '2022-03-25 10:35:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (383, 174, 1, '', '2022-03-25 10:40:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (384, 163, 2, '', '2022-03-25 10:49:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (385, 163, 3, 'X-Ray', '2022-03-25 10:49:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (386, 164, 2, '', '2022-03-25 10:52:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (387, 164, 3, 'X-Ray', '2022-03-25 10:52:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (388, 165, 2, '', '2022-03-25 10:54:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (389, 165, 3, 'X-Ray', '2022-03-25 10:54:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (390, 166, 2, '', '2022-03-25 10:55:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (391, 166, 3, 'X-Ray', '2022-03-25 10:55:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (392, 167, 2, '', '2022-03-25 10:55:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (393, 167, 3, 'X-Ray', '2022-03-25 10:55:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (394, 168, 2, '106', '2022-03-25 11:02:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (395, 168, 3, 'X-Ray', '2022-03-25 11:02:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (396, 0, 2, '', '2022-03-25 11:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (397, 0, 3, 'X-Ray', '2022-03-25 11:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (398, 170, 2, '', '2022-03-25 11:05:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (399, 170, 3, 'X-Ray', '2022-03-25 11:05:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (400, 171, 2, '', '2022-03-25 11:12:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (401, 171, 3, 'X-Ray', '2022-03-25 11:12:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (402, 175, 1, '', '2022-03-25 11:23:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (403, 176, 1, '', '2022-03-25 11:30:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (404, 177, 1, '', '2022-03-25 11:38:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (405, 172, 2, '', '2022-03-25 11:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (406, 172, 3, 'X-Ray', '2022-03-25 11:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (407, 171, 1, '', '2022-03-25 11:43:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (408, 169, 2, '', '2022-03-25 11:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (409, 169, 3, 'X-Ray', '2022-03-25 11:44:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (410, 178, 1, '', '2022-03-25 11:44:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (411, 170, 1, '', '2022-03-25 11:46:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (412, 179, 1, '', '2022-03-25 11:46:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (413, 160, 2, '', '2022-03-25 11:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (414, 160, 3, 'ECG', '2022-03-25 11:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (415, 180, 1, '', '2022-03-25 11:48:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (416, 173, 2, '', '2022-03-25 11:49:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (417, 173, 3, 'USG', '2022-03-25 11:49:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (418, 174, 2, '', '2022-03-25 11:50:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (419, 174, 3, 'X-Ray', '2022-03-25 11:50:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (420, 181, 1, '', '2022-03-25 11:51:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (421, 182, 1, '', '2022-03-25 11:53:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (422, 183, 1, '', '2022-03-25 12:09:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (423, 175, 2, '', '2022-03-25 12:11:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (424, 175, 3, 'USG', '2022-03-25 12:11:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (425, 176, 2, '', '2022-03-25 12:12:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (426, 176, 3, 'X-Ray', '2022-03-25 12:12:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (427, 184, 1, '', '2022-03-25 12:12:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (428, 177, 2, '', '2022-03-25 12:15:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (429, 177, 3, 'X-Ray', '2022-03-25 12:15:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (430, 178, 2, '', '2022-03-25 12:16:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (431, 178, 3, 'ECG', '2022-03-25 12:16:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (432, 185, 1, '', '2022-03-25 12:17:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (433, 179, 2, '', '2022-03-25 12:18:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (434, 179, 3, 'X-Ray', '2022-03-25 12:18:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (435, 180, 2, '', '2022-03-25 12:20:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (436, 180, 3, 'ECG', '2022-03-25 12:20:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (437, 186, 1, '', '2022-03-25 12:31:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (438, 187, 1, '', '2022-03-25 12:37:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (439, 181, 2, '', '2022-03-25 12:38:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (440, 181, 3, 'X-Ray', '2022-03-25 12:38:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (441, 182, 2, '', '2022-03-25 12:41:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (442, 182, 3, 'ECG', '2022-03-25 12:41:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (443, 0, 1, '', '2022-03-25 16:01:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (444, 189, 1, '', '2022-03-25 12:53:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (445, 183, 2, '', '2022-03-25 12:54:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (446, 183, 3, 'USG', '2022-03-25 12:54:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (447, 190, 1, '', '2022-03-25 12:57:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (448, 184, 2, '', '2022-03-25 12:58:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (449, 184, 3, 'ECG', '2022-03-25 12:58:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (450, 191, 1, '', '2022-03-25 13:10:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (451, 185, 2, '', '2022-03-25 13:11:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (452, 185, 3, 'X-Ray', '2022-03-25 13:11:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (453, 192, 1, '', '2022-03-25 13:15:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (454, 193, 1, '', '2022-03-25 13:38:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (455, 194, 1, '', '2022-03-25 13:44:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (456, 186, 2, '', '2022-03-25 13:45:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (457, 186, 3, 'USG', '2022-03-25 13:45:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (458, 187, 2, '', '2022-03-25 13:46:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (459, 187, 3, 'X-Ray', '2022-03-25 13:46:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (460, 188, 2, '', '2022-03-25 13:47:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (461, 188, 3, 'ECG', '2022-03-25 13:47:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (462, 195, 1, '', '2022-03-25 13:52:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (463, 189, 2, '', '2022-03-25 13:54:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (464, 189, 3, 'X-Ray', '2022-03-25 13:54:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (465, 190, 2, '', '2022-03-25 14:03:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (466, 190, 3, 'X-Ray', '2022-03-25 14:03:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (467, 196, 1, '', '2022-03-25 15:40:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (468, 197, 1, '', '2022-03-25 15:57:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (469, 188, 1, '', '2022-03-25 16:01:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (470, 191, 2, '', '2022-03-25 16:09:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (471, 191, 3, 'X-Ray', '2022-03-25 16:09:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (472, 198, 1, '', '2022-03-25 16:37:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (473, 192, 2, '', '2022-03-25 16:39:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (474, 192, 3, 'X-Ray', '2022-03-25 16:39:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (475, 193, 2, '', '2022-03-25 16:40:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (476, 193, 3, 'USG', '2022-03-25 16:40:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (477, 194, 2, '', '2022-03-25 16:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (478, 194, 3, 'X-Ray', '2022-03-25 16:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (479, 195, 2, '', '2022-03-25 17:30:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (480, 195, 3, 'ECG', '2022-03-25 17:30:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (481, 199, 1, '', '2022-03-25 17:39:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (482, 196, 2, '', '2022-03-25 17:42:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (483, 196, 3, 'X-Ray', '2022-03-25 17:42:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (484, 197, 2, '', '2022-03-25 17:59:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (485, 197, 3, 'X-Ray', '2022-03-25 17:59:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (486, 200, 1, '', '2022-03-25 18:03:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (487, 198, 2, '', '2022-03-25 18:04:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (488, 198, 3, 'USG', '2022-03-25 18:04:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (489, 201, 1, '', '2022-03-25 18:09:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (490, 199, 2, '', '2022-03-25 18:11:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (491, 199, 3, 'X-Ray', '2022-03-25 18:11:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (492, 200, 2, '', '2022-03-25 18:44:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (493, 200, 3, 'X-Ray', '2022-03-25 18:44:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (494, 201, 2, '', '2022-03-25 19:16:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (495, 201, 3, 'X-Ray', '2022-03-25 19:16:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (496, 202, 2, '', '2022-03-25 19:38:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (497, 202, 3, 'X-Ray', '2022-03-25 19:38:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (498, 202, 1, '', '2022-03-25 20:34:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (499, 203, 2, '', '2022-03-25 20:36:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (500, 203, 3, 'ECG', '2022-03-25 20:36:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (501, 204, 2, '', '2022-03-25 20:41:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (502, 204, 3, 'X-Ray', '2022-03-25 20:41:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (503, 205, 2, '', '2022-03-25 20:44:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (504, 205, 3, 'X-Ray', '2022-03-25 20:44:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (505, 206, 2, '', '2022-03-25 20:53:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (506, 206, 3, 'X-Ray', '2022-03-25 20:53:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (507, 207, 2, '', '2022-03-25 21:05:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (508, 207, 3, 'USG', '2022-03-25 21:05:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (509, 208, 2, '', '2022-03-25 21:39:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (510, 208, 3, 'X-Ray', '2022-03-25 21:39:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (511, 209, 2, '', '2022-03-25 21:46:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (512, 209, 3, 'USG', '2022-03-25 21:46:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (513, 203, 1, '', '2022-03-26 09:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (514, 210, 2, '', '2022-03-26 10:05:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (515, 210, 3, 'X-Ray', '2022-03-26 10:05:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (516, 204, 1, '', '2022-03-26 10:16:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (517, 211, 2, '', '2022-03-26 10:17:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (518, 211, 3, 'USG', '2022-03-26 10:17:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (519, 212, 2, '', '2022-03-26 10:42:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (520, 212, 3, 'X-Ray', '2022-03-26 10:42:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (521, 213, 2, '', '2022-03-26 10:49:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (522, 213, 3, 'X-Ray', '2022-03-26 10:49:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (523, 205, 1, '', '2022-03-26 10:50:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (524, 206, 1, '', '2022-03-26 10:53:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (525, 207, 1, '', '2022-03-26 11:13:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (526, 208, 1, '107', '2022-03-26 11:47:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (527, 214, 2, '', '2022-03-26 11:56:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (528, 214, 3, 'X-Ray', '2022-03-26 11:56:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (529, 215, 2, '', '2022-03-26 12:13:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (530, 215, 3, 'USG', '2022-03-26 12:13:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (531, 209, 1, '', '2022-03-26 12:13:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (532, 210, 1, '107', '2022-03-26 12:14:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (533, 216, 2, '', '2022-03-26 12:17:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (534, 216, 3, 'X-Ray', '2022-03-26 12:17:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (535, 217, 2, '', '2022-03-26 12:27:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (536, 217, 3, 'USG', '2022-03-26 12:27:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (537, 211, 1, '', '2022-03-26 12:28:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (538, 218, 2, '', '2022-03-26 13:33:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (539, 218, 3, 'X-Ray', '2022-03-26 13:33:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (540, 212, 1, '107', '2022-03-26 13:42:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (541, 219, 2, '', '2022-03-26 13:44:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (542, 219, 3, 'ECG', '2022-03-26 13:44:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (543, 220, 2, '', '2022-03-26 13:45:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (544, 220, 3, 'X-Ray', '2022-03-26 13:45:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (545, 213, 1, '', '2022-03-26 15:14:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (546, 221, 2, '', '2022-03-26 16:49:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (547, 221, 3, 'X-Ray', '2022-03-26 16:49:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (548, 222, 2, '', '2022-03-26 17:19:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (549, 222, 3, 'USG', '2022-03-26 17:19:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (550, 223, 2, '', '2022-03-26 17:57:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (551, 223, 3, 'X-Ray', '2022-03-26 17:57:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (552, 214, 1, '', '2022-03-26 18:00:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (553, 215, 1, '', '2022-03-26 18:02:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (554, 224, 2, '', '2022-03-26 18:51:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (555, 224, 3, 'X-Ray', '2022-03-26 18:51:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (556, 225, 2, '', '2022-03-26 19:18:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (557, 225, 3, 'X-Ray', '2022-03-26 19:18:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (558, 216, 1, '', '2022-03-26 19:26:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (559, 226, 2, '', '2022-03-26 19:27:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (560, 226, 3, 'ECG', '2022-03-26 19:27:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (561, 227, 2, '', '2022-03-26 19:47:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (562, 227, 3, 'ECG', '2022-03-26 19:47:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (563, 228, 2, '', '2022-03-26 20:30:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (564, 228, 3, 'X-Ray', '2022-03-26 20:30:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (565, 229, 2, '', '2022-03-27 08:49:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (566, 229, 3, 'ECG', '2022-03-27 08:49:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (567, 230, 2, '', '2022-03-27 09:35:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (568, 230, 3, 'ECG', '2022-03-27 09:35:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (569, 231, 2, '', '2022-03-27 09:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (570, 231, 3, 'X-Ray', '2022-03-27 09:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (571, 217, 1, '', '2022-03-27 10:45:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (572, 232, 2, '', '2022-03-27 10:46:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (573, 232, 3, 'USG', '2022-03-27 10:46:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (574, 233, 2, '', '2022-03-27 11:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (575, 233, 3, 'X-Ray', '2022-03-27 11:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (576, 234, 2, '', '2022-03-27 12:06:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (577, 234, 3, 'X-Ray', '2022-03-27 12:06:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (578, 218, 1, '107', '2022-03-27 12:16:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (579, 219, 1, '', '2022-03-27 13:29:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (580, 235, 2, '', '2022-03-27 14:27:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (581, 235, 3, 'X-Ray', '2022-03-27 14:27:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (582, 220, 1, '', '2022-03-27 15:33:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (583, 236, 2, '', '2022-03-27 15:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (584, 236, 3, 'X-Ray', '2022-03-27 15:43:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (585, 221, 1, '', '2022-03-27 15:55:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (586, 237, 2, '', '2022-03-27 16:00:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (587, 237, 3, 'X-Ray', '2022-03-27 16:00:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (588, 238, 2, '', '2022-03-27 16:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (589, 238, 3, 'X-Ray', '2022-03-27 16:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (590, 239, 2, '', '2022-03-27 17:31:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (591, 239, 3, 'X-Ray', '2022-03-27 17:31:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (592, 240, 2, '', '2022-03-27 17:39:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (593, 240, 3, 'X-Ray', '2022-03-27 17:39:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (594, 222, 1, '', '2022-03-27 17:40:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (595, 241, 2, '', '2022-03-27 17:54:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (596, 241, 3, 'X-Ray', '2022-03-27 17:54:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (597, 223, 1, '', '2022-03-27 18:05:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (598, 242, 2, '', '2022-03-27 18:06:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (599, 242, 3, 'USG', '2022-03-27 18:06:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (600, 243, 2, '', '2022-03-27 18:24:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (601, 243, 3, 'X-Ray', '2022-03-27 18:24:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (602, 224, 1, '', '2022-03-27 19:01:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (603, 244, 2, '', '2022-03-27 19:02:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (604, 244, 3, 'USG', '2022-03-27 19:02:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (605, 225, 1, '', '2022-03-27 19:07:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (606, 245, 2, '', '2022-03-27 19:21:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (607, 245, 3, 'X-Ray', '2022-03-27 19:21:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (608, 226, 1, '', '2022-03-27 19:28:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (609, 246, 2, '', '2022-03-27 19:29:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (610, 246, 3, 'USG', '2022-03-27 19:29:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (611, 227, 1, '', '2022-03-27 19:32:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (612, 247, 2, '', '2022-03-27 19:37:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (613, 247, 3, 'X-Ray', '2022-03-27 19:37:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (614, 248, 2, '', '2022-03-27 19:47:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (615, 248, 3, 'X-Ray', '2022-03-27 19:47:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (616, 249, 2, '', '2022-03-27 20:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (617, 249, 3, 'ECG', '2022-03-27 20:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (618, 228, 1, '', '2022-03-28 10:40:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (619, 250, 2, '', '2022-03-28 10:46:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (620, 250, 3, 'X-Ray', '2022-03-28 10:46:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (621, 251, 2, '', '2022-03-28 10:49:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (622, 251, 3, 'X-Ray', '2022-03-28 10:49:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (623, 252, 2, '', '2022-03-28 10:56:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (624, 252, 3, 'X-Ray', '2022-03-28 10:56:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (625, 253, 2, '', '2022-03-28 11:27:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (626, 253, 3, 'USG', '2022-03-28 11:27:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (627, 229, 1, '', '2022-03-28 11:31:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (628, 230, 1, '', '2022-03-28 12:18:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (629, 231, 1, '', '2022-03-28 12:32:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (630, 254, 2, '', '2022-03-28 12:34:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (631, 254, 3, 'X-Ray', '2022-03-28 12:34:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (632, 255, 2, '', '2022-03-28 13:39:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (633, 255, 3, 'USG', '2022-03-28 13:39:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (634, 256, 2, '', '2022-03-28 15:23:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (635, 256, 3, 'USG', '2022-03-28 15:23:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (636, 232, 1, '107', '2022-03-28 17:43:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (637, 257, 2, '', '2022-03-28 19:33:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (638, 257, 3, 'X-Ray', '2022-03-28 19:33:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (639, 233, 1, '', '2022-03-28 19:58:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (640, 258, 2, '', '2022-03-28 19:58:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (641, 258, 3, 'USG', '2022-03-28 19:58:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (642, 234, 1, '', '2022-03-28 20:24:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (643, 259, 2, '', '2022-03-28 21:09:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (644, 259, 3, 'X-Ray', '2022-03-28 21:09:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (645, 235, 1, '', '2022-03-28 22:52:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (646, 236, 1, '', '2022-03-29 06:48:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (647, 260, 2, '', '2022-03-29 08:24:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (648, 260, 3, 'USG', '2022-03-29 08:24:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (649, 261, 2, '', '2022-03-29 09:50:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (650, 261, 3, 'X-Ray', '2022-03-29 09:50:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (651, 262, 2, '', '2022-03-29 09:58:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (652, 262, 3, 'X-Ray', '2022-03-29 09:58:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (653, 263, 2, '', '2022-03-29 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (654, 263, 3, 'X-Ray', '2022-03-29 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (655, 264, 2, '', '2022-03-29 10:00:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (656, 264, 3, 'X-Ray', '2022-03-29 10:00:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (657, 0, 1, '', '2022-03-29 10:47:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (658, 0, 1, '', '2022-03-29 10:50:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (659, 237, 1, '', '2022-03-29 10:50:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (660, 238, 1, '', '2022-03-29 10:51:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (661, 265, 2, '', '2022-03-29 10:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (662, 265, 3, 'X-Ray', '2022-03-29 10:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (663, 266, 2, '', '2022-03-29 11:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (664, 266, 3, 'X-Ray', '2022-03-29 11:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (665, 267, 2, '', '2022-03-29 12:43:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (666, 267, 3, 'USG', '2022-03-29 12:43:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (667, 268, 2, '', '2022-03-29 14:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (668, 268, 3, 'ECG', '2022-03-29 14:01:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (669, 269, 2, '', '2022-03-29 14:39:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (670, 269, 3, 'X-Ray', '2022-03-29 14:39:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (671, 270, 2, '106', '2022-03-29 17:16:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (672, 270, 3, 'X-Ray', '2022-03-29 17:16:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (673, 271, 2, '106', '2022-03-29 17:24:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (674, 271, 3, 'USG', '2022-03-29 17:24:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (675, 239, 1, '107', '2022-03-29 17:24:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (676, 240, 1, '', '2022-03-29 17:37:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (677, 272, 2, '', '2022-03-29 18:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (678, 272, 3, 'X-Ray', '2022-03-29 18:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (682, 274, 2, '', '2022-03-29 20:25:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (683, 274, 3, 'USG', '2022-03-29 20:25:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (684, 275, 2, '', '2022-03-29 20:41:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (685, 275, 3, '', '2022-03-29 20:41:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (692, 244, 1, '', '2022-03-30 08:42:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (693, 278, 2, '', '2022-03-30 10:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (694, 278, 3, 'X-Ray', '2022-03-30 10:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (695, 279, 2, '', '2022-03-30 10:57:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (696, 279, 3, 'X-Ray', '2022-03-30 10:57:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (697, 280, 2, '', '2022-03-30 11:19:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (698, 280, 3, '', '2022-03-30 11:19:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (699, 245, 1, '', '2022-03-30 13:20:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (700, 281, 2, '101', '2022-03-30 13:57:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (701, 281, 3, 'X-Ray', '2022-03-30 13:57:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (702, 282, 2, '', '2022-03-30 15:57:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (703, 282, 3, '', '2022-03-30 15:57:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (704, 246, 1, '', '2022-03-30 16:59:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (705, 283, 2, '', '2022-03-30 16:59:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (706, 283, 3, '', '2022-03-30 16:59:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (707, 247, 1, '', '2022-03-30 17:39:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (708, 248, 1, '', '2022-03-30 18:04:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (709, 284, 2, '', '2022-03-30 18:05:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (710, 284, 3, '', '2022-03-30 18:05:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (711, 249, 1, '', '2022-03-30 18:13:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (712, 285, 2, '', '2022-03-30 19:02:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (713, 285, 3, '', '2022-03-30 19:02:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (714, 250, 1, '', '2022-03-30 19:40:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (715, 286, 2, '', '2022-03-30 19:52:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (716, 286, 3, '', '2022-03-30 19:52:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (717, 251, 1, '', '2022-03-30 21:20:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (718, 287, 2, '', '2022-03-30 22:02:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (719, 287, 3, 'X-Ray', '2022-03-30 22:02:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (720, 288, 2, '', '2022-03-30 22:48:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (721, 288, 3, 'X-Ray', '2022-03-30 22:48:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (722, 252, 1, '', '2022-03-31 08:16:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (723, 289, 2, '', '2022-03-31 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (724, 289, 3, '', '2022-03-31 09:59:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (725, 290, 2, '', '2022-03-31 10:07:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (726, 290, 3, '', '2022-03-31 10:07:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (727, 291, 2, '106', '2022-03-31 10:20:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (728, 291, 3, 'USG', '2022-03-31 10:20:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (729, 292, 2, '', '2022-03-31 10:38:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (730, 292, 3, '', '2022-03-31 10:38:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (731, 293, 2, '', '2022-03-31 10:53:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (732, 293, 3, 'USG', '2022-03-31 10:53:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (733, 294, 2, '', '2022-03-31 11:54:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (734, 294, 3, 'X-Ray', '2022-03-31 11:54:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (735, 253, 1, '', '2022-03-31 11:56:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (736, 295, 2, '', '2022-03-31 11:58:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (737, 295, 3, '', '2022-03-31 11:58:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (738, 254, 1, '', '2022-03-31 12:39:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (739, 296, 2, '', '2022-03-31 13:28:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (740, 296, 3, '', '2022-03-31 13:28:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (741, 255, 1, '', '2022-03-31 13:31:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (742, 297, 2, '', '2022-03-31 13:59:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (743, 297, 3, 'USG', '2022-03-31 13:59:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (744, 256, 1, '107', '2022-03-31 14:16:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (745, 298, 2, '', '2022-03-31 15:39:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (746, 298, 3, '', '2022-03-31 15:39:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (747, 257, 1, '107', '2022-03-31 16:17:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (748, 258, 1, '', '2022-03-31 16:34:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (749, 299, 2, '', '2022-03-31 16:35:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (750, 299, 3, '', '2022-03-31 16:35:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (751, 0, 2, '', '2022-03-31 21:35:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (752, 0, 3, '', '2022-03-31 21:35:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (753, 259, 1, '', '2022-03-31 17:16:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (754, 301, 2, '', '2022-03-31 17:16:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (755, 301, 3, 'X-Ray', '2022-03-31 17:16:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (756, 302, 2, '', '2022-03-31 17:18:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (757, 302, 3, '', '2022-03-31 17:18:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (758, 303, 2, '', '2022-03-31 17:20:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (759, 303, 3, '', '2022-03-31 17:20:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (760, 260, 1, '', '2022-03-31 17:25:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (761, 304, 2, '', '2022-03-31 17:31:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (762, 304, 3, '', '2022-03-31 17:31:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (763, 261, 1, '', '2022-03-31 17:32:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (764, 305, 2, '', '2022-03-31 17:36:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (765, 305, 3, '', '2022-03-31 17:36:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (766, 262, 1, '', '2022-03-31 17:44:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (767, 306, 2, '', '2022-03-31 17:44:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (768, 306, 3, '', '2022-03-31 17:44:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (769, 307, 2, '', '2022-03-31 17:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (770, 307, 3, '', '2022-03-31 17:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (771, 308, 2, '', '2022-03-31 17:53:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (772, 308, 3, '', '2022-03-31 17:53:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (773, 263, 1, '', '2022-03-31 17:54:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (774, 264, 1, '', '2022-03-31 17:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (775, 309, 2, '', '2022-03-31 17:56:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (776, 309, 3, '', '2022-03-31 17:56:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (777, 265, 1, '', '2022-03-31 18:03:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (778, 310, 2, '', '2022-03-31 18:04:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (779, 310, 3, '', '2022-03-31 18:04:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (780, 266, 1, '', '2022-03-31 18:07:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (781, 311, 2, '', '2022-03-31 18:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (782, 311, 3, '', '2022-03-31 18:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (783, 267, 1, '', '2022-03-31 18:22:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (784, 312, 2, '', '2022-03-31 18:34:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (785, 312, 3, '', '2022-03-31 18:34:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (786, 268, 1, '', '2022-03-31 18:35:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (787, 269, 1, '', '2022-03-31 18:40:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (788, 313, 2, '', '2022-03-31 18:44:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (789, 313, 3, '', '2022-03-31 18:44:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (790, 270, 1, '', '2022-03-31 18:46:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (791, 271, 1, '', '2022-03-31 19:09:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (792, 272, 1, '', '2022-03-31 19:27:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (793, 273, 1, '', '2022-03-31 19:31:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (794, 314, 2, '', '2022-03-31 19:43:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (795, 314, 3, '', '2022-03-31 19:43:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (796, 315, 2, '', '2022-03-31 19:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (797, 315, 3, 'X-Ray', '2022-03-31 19:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (798, 274, 1, '', '2022-03-31 20:08:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (799, 275, 1, '', '2022-03-31 20:24:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (800, 276, 1, '', '2022-03-31 20:35:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (801, 316, 2, '', '2022-03-31 20:36:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (802, 316, 3, '', '2022-03-31 20:36:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (803, 277, 1, '', '2022-03-31 20:37:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (804, 278, 1, '', '2022-03-31 20:49:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (805, 279, 1, '', '2022-03-31 20:58:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (806, 317, 2, '', '2022-03-31 20:58:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (807, 317, 3, '', '2022-03-31 20:58:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (808, 318, 2, '', '2022-03-31 20:59:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (809, 318, 3, '', '2022-03-31 20:59:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (810, 319, 2, '', '2022-03-31 21:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (811, 319, 3, '', '2022-03-31 21:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (812, 320, 2, '', '2022-03-31 21:05:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (813, 320, 3, '', '2022-03-31 21:05:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (814, 321, 2, '', '2022-03-31 21:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (815, 321, 3, '', '2022-03-31 21:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (816, 280, 1, '', '2022-03-31 21:19:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (817, 322, 2, '', '2022-03-31 21:21:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (818, 322, 3, '', '2022-03-31 21:21:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (819, 281, 1, '', '2022-03-31 21:22:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (820, 282, 1, '', '2022-03-31 21:24:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (821, 323, 2, '', '2022-03-31 21:25:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (822, 323, 3, '', '2022-03-31 21:25:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (823, 0, 2, '', '2022-03-31 21:37:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (824, 0, 3, '', '2022-03-31 21:37:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (825, 324, 2, '', '2022-03-31 21:36:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (826, 324, 3, '', '2022-03-31 21:36:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (829, 283, 1, '', '2022-03-31 21:40:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (830, 325, 2, '', '2022-03-31 22:11:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (831, 325, 3, '', '2022-03-31 22:11:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (832, 284, 1, '', '2022-03-31 22:18:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (833, 326, 2, '', '2022-03-31 22:19:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (834, 326, 3, '', '2022-03-31 22:19:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (835, 285, 1, '', '2022-03-31 23:04:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (836, 327, 2, '', '2022-03-31 23:05:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (837, 327, 3, '', '2022-03-31 23:05:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (838, 286, 1, '', '2022-04-01 08:30:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (839, 287, 1, '', '2022-04-01 08:50:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (840, 328, 2, '', '2022-04-01 09:06:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (841, 328, 3, '', '2022-04-01 09:06:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (842, 288, 1, '', '2022-04-01 09:48:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (843, 289, 1, '', '2022-04-01 09:57:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (844, 329, 2, '', '2022-04-01 09:59:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (845, 329, 3, '', '2022-04-01 09:59:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (846, 290, 1, '', '2022-04-01 10:04:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (847, 291, 1, '', '2022-04-01 10:07:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (848, 292, 1, '', '2022-04-01 10:09:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (849, 293, 1, '', '2022-04-01 10:09:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (850, 330, 2, '', '2022-04-01 10:13:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (851, 330, 3, '', '2022-04-01 10:13:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (852, 294, 1, '', '2022-04-01 10:14:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (853, 295, 1, '', '2022-04-01 10:15:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (854, 331, 2, '', '2022-04-01 10:16:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (855, 331, 3, '', '2022-04-01 10:16:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (856, 332, 2, '', '2022-04-01 10:18:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (857, 332, 3, '', '2022-04-01 10:18:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (858, 296, 1, '', '2022-04-01 10:19:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (859, 297, 1, '', '2022-04-01 10:23:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (860, 333, 2, '', '2022-04-01 10:25:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (861, 333, 3, '', '2022-04-01 10:25:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (862, 298, 1, '', '2022-04-01 10:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (863, 299, 1, '', '2022-04-01 10:43:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (864, 300, 1, '', '2022-04-01 10:44:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (865, 334, 2, '', '2022-04-01 10:44:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (866, 334, 3, '', '2022-04-01 10:44:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (867, 335, 2, '', '2022-04-01 10:45:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (868, 335, 3, '', '2022-04-01 10:45:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (869, 336, 2, '', '2022-04-01 10:52:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (870, 336, 3, '', '2022-04-01 10:52:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (871, 301, 1, '', '2022-04-01 10:55:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (872, 302, 1, '', '2022-04-01 10:57:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (873, 337, 2, '', '2022-04-01 11:02:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (874, 337, 3, '', '2022-04-01 11:02:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (875, 303, 1, '', '2022-04-01 11:04:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (876, 338, 2, '', '2022-04-01 11:05:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (877, 338, 3, '', '2022-04-01 11:05:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (878, 304, 1, '', '2022-04-01 11:10:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (879, 339, 2, '', '2022-04-01 11:12:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (880, 339, 3, '', '2022-04-01 11:12:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (881, 340, 2, '', '2022-04-01 11:12:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (882, 340, 3, '', '2022-04-01 11:12:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (883, 305, 1, '', '2022-04-01 11:16:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (884, 341, 2, '', '2022-04-01 11:18:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (885, 341, 3, '', '2022-04-01 11:18:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (886, 306, 1, '', '2022-04-01 11:28:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (887, 307, 1, '', '2022-04-01 11:31:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (888, 0, 1, '', '2022-04-01 11:48:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (889, 342, 2, '', '2022-04-01 11:40:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (890, 342, 3, '', '2022-04-01 11:40:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (891, 309, 1, '', '2022-04-01 11:43:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (892, 343, 2, '', '2022-04-01 11:43:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (893, 343, 3, '', '2022-04-01 11:43:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (894, 308, 1, '', '2022-04-01 11:48:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (895, 0, 1, '', '2022-04-01 11:54:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (896, 310, 1, '', '2022-04-01 11:54:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (897, 311, 1, '', '2022-04-01 11:59:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (898, 312, 1, '', '2022-04-01 12:00:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (899, 344, 2, '', '2022-04-01 12:49:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (900, 344, 3, '', '2022-04-01 12:49:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (901, 313, 1, '', '2022-04-01 13:01:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (902, 345, 2, '', '2022-04-01 13:23:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (903, 345, 3, '', '2022-04-01 13:23:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (904, 346, 2, '', '2022-04-01 14:41:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (905, 346, 3, '', '2022-04-01 14:41:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (906, 314, 1, '', '2022-04-01 16:12:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (907, 347, 2, '', '2022-04-01 16:19:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (908, 347, 3, '', '2022-04-01 16:19:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (909, 315, 1, '', '2022-04-01 16:20:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (910, 316, 1, '', '2022-04-01 17:10:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (911, 348, 2, '', '2022-04-01 17:11:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (912, 348, 3, '', '2022-04-01 17:11:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (913, 349, 2, '', '2022-04-01 17:30:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (914, 349, 3, '', '2022-04-01 17:30:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (915, 317, 1, '', '2022-04-01 17:38:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (916, 0, 2, '', '2022-04-01 18:12:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (917, 0, 3, '', '2022-04-01 18:12:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (918, 351, 2, '', '2022-04-01 17:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (919, 351, 3, '', '2022-04-01 17:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (920, 0, 2, '', '2022-04-01 20:01:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (921, 0, 3, '', '2022-04-01 20:01:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (922, 352, 2, '', '2022-04-01 18:20:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (923, 352, 3, '', '2022-04-01 18:20:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (924, 353, 2, '', '2022-04-01 18:27:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (925, 353, 3, '', '2022-04-01 18:27:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (926, 318, 1, '', '2022-04-01 18:34:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (927, 354, 2, '', '2022-04-01 19:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (928, 354, 3, '', '2022-04-01 19:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (929, 355, 2, '', '2022-04-01 19:14:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (930, 355, 3, '', '2022-04-01 19:14:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (931, 356, 2, '', '2022-04-01 19:33:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (932, 356, 3, '', '2022-04-01 19:33:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (933, 357, 2, '', '2022-04-01 19:42:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (934, 357, 3, '', '2022-04-01 19:42:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (935, 358, 2, '', '2022-04-01 19:47:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (936, 358, 3, '', '2022-04-01 19:47:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (937, 350, 2, '', '2022-04-01 20:01:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (938, 350, 3, '', '2022-04-01 20:01:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (939, 319, 1, '', '2022-04-01 20:19:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (940, 359, 2, '', '2022-04-01 20:29:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (941, 359, 3, '', '2022-04-01 20:29:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (942, 320, 1, '', '2022-04-01 20:32:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (943, 360, 2, '', '2022-04-01 20:44:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (944, 360, 3, '', '2022-04-01 20:44:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (945, 321, 1, '', '2022-04-01 20:56:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (946, 361, 2, '', '2022-04-01 20:57:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (947, 361, 3, '', '2022-04-01 20:57:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (948, 322, 1, '', '2022-04-01 22:21:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (949, 362, 2, '', '2022-04-02 07:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (950, 362, 3, '', '2022-04-02 07:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (951, 323, 1, '', '2022-04-02 09:28:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (952, 324, 1, '', '2022-04-02 09:34:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (953, 363, 2, '', '2022-04-02 09:36:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (954, 363, 3, '', '2022-04-02 09:36:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (955, 325, 1, '', '2022-04-02 10:31:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (956, 364, 2, '', '2022-04-02 10:41:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (957, 364, 3, '', '2022-04-02 10:41:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (958, 326, 1, '', '2022-04-02 11:07:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (959, 365, 2, '', '2022-04-02 11:09:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (960, 365, 3, '', '2022-04-02 11:09:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (961, 366, 2, '', '2022-04-02 11:11:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (962, 366, 3, '', '2022-04-02 11:11:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (963, 327, 1, '', '2022-04-02 11:14:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (964, 367, 2, '', '2022-04-02 11:16:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (965, 367, 3, '', '2022-04-02 11:16:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (966, 328, 1, '', '2022-04-02 11:28:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (967, 368, 2, '', '2022-04-02 11:35:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (968, 368, 3, '', '2022-04-02 11:35:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (969, 369, 2, '', '2022-04-02 11:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (970, 369, 3, '', '2022-04-02 11:56:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (971, 329, 1, '', '2022-04-02 12:08:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (972, 370, 2, '', '2022-04-02 12:12:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (973, 370, 3, '', '2022-04-02 12:12:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (974, 330, 1, '', '2022-04-02 12:18:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (975, 371, 2, '', '2022-04-02 12:18:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (976, 371, 3, '', '2022-04-02 12:18:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (977, 331, 1, '', '2022-04-02 12:31:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (978, 372, 2, '', '2022-04-02 12:34:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (979, 372, 3, '', '2022-04-02 12:34:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (980, 373, 2, '', '2022-04-02 12:50:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (981, 373, 3, '', '2022-04-02 12:50:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (982, 374, 2, '', '2022-04-02 13:14:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (983, 374, 3, '', '2022-04-02 13:14:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (984, 332, 1, '', '2022-04-02 13:40:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (985, 375, 2, '', '2022-04-02 13:41:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (986, 375, 3, '', '2022-04-02 13:41:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (987, 376, 2, '', '2022-04-02 14:57:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (988, 376, 3, '', '2022-04-02 14:57:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (989, 333, 1, '', '2022-04-02 16:35:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (990, 377, 2, '', '2022-04-02 17:23:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (991, 377, 3, '', '2022-04-02 17:23:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (992, 378, 2, '', '2022-04-02 17:33:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (993, 378, 3, '', '2022-04-02 17:33:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (994, 379, 2, '', '2022-04-02 17:43:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (995, 379, 3, '', '2022-04-02 17:43:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (996, 334, 1, '', '2022-04-02 17:44:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (997, 335, 1, '', '2022-04-02 18:59:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (998, 336, 1, '', '2022-04-02 19:00:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (999, 337, 1, '', '2022-04-02 19:02:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1000, 0, 1, '', '2022-04-02 21:31:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1001, 380, 2, '', '2022-04-02 19:48:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1002, 380, 3, '', '2022-04-02 19:48:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1003, 381, 2, '', '2022-04-02 20:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1004, 381, 3, '', '2022-04-02 20:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1005, 338, 1, '', '2022-04-02 21:31:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1006, 339, 1, '107', '2022-04-03 09:56:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1007, 382, 2, '101', '2022-04-03 09:58:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1008, 382, 3, 'USG', '2022-04-03 09:58:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1009, 383, 2, '', '2022-04-03 11:18:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1010, 383, 3, '', '2022-04-03 11:18:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1013, 340, 1, '107', '2022-04-03 12:08:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1014, 341, 1, '', '2022-04-03 12:43:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1015, 385, 2, '', '2022-04-03 12:44:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1016, 385, 3, 'ECG', '2022-04-03 12:44:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1017, 386, 2, '101', '2022-04-03 12:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1018, 386, 3, 'USG', '2022-04-03 12:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1019, 342, 1, '107', '2022-04-03 12:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1020, 343, 1, '', '2022-04-03 14:36:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1021, 344, 1, '', '2022-04-03 15:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1022, 387, 2, '', '2022-04-03 16:11:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1023, 387, 3, '', '2022-04-03 16:11:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1024, 388, 2, '', '2022-04-03 19:05:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1025, 388, 3, '', '2022-04-03 19:05:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1026, 389, 2, '', '2022-04-03 19:30:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1027, 389, 3, '', '2022-04-03 19:30:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1028, 390, 2, '', '2022-04-04 09:34:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1029, 390, 3, 'ECG', '2022-04-04 09:34:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1030, 345, 1, '', '2022-04-04 09:34:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1031, 391, 2, '', '2022-04-04 10:50:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1032, 391, 3, '', '2022-04-04 10:50:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1033, 346, 1, '', '2022-04-04 10:57:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1034, 392, 2, '', '2022-04-04 10:57:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1035, 392, 3, '', '2022-04-04 10:57:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1036, 393, 2, '', '2022-04-04 11:10:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1037, 393, 3, '', '2022-04-04 11:10:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1038, 347, 1, '', '2022-04-04 11:12:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1039, 394, 2, '', '2022-04-04 11:39:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1040, 394, 3, '', '2022-04-04 11:39:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1041, 395, 2, '', '2022-04-04 11:57:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1042, 395, 3, 'X-Ray', '2022-04-04 11:57:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1043, 396, 2, '', '2022-04-04 12:12:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1044, 396, 3, 'ECG', '2022-04-04 12:12:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1045, 348, 1, '', '2022-04-04 12:17:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1046, 397, 2, '', '2022-04-04 12:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1047, 397, 3, '', '2022-04-04 12:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1048, 398, 2, '', '2022-04-04 12:21:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1049, 398, 3, '', '2022-04-04 12:21:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1050, 399, 2, '', '2022-04-04 12:31:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1051, 399, 3, 'X-Ray', '2022-04-04 12:31:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1052, 400, 2, '', '2022-04-04 12:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1053, 400, 3, '', '2022-04-04 12:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1054, 401, 2, '', '2022-04-04 12:52:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1055, 401, 3, '', '2022-04-04 12:52:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1056, 402, 2, '', '2022-04-04 13:20:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1057, 402, 3, '', '2022-04-04 13:20:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1058, 403, 2, '', '2022-04-04 13:30:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1059, 403, 3, '', '2022-04-04 13:30:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1060, 349, 1, '', '2022-04-04 16:19:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1061, 404, 2, '', '2022-04-04 16:40:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1062, 404, 3, 'X-Ray', '2022-04-04 16:40:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1063, 350, 1, '', '2022-04-04 19:32:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1064, 351, 1, '', '2022-04-04 19:36:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1065, 352, 1, '', '2022-04-04 19:40:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1066, 405, 2, '', '2022-04-04 19:41:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1067, 405, 3, '', '2022-04-04 19:41:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1068, 353, 1, '', '2022-04-04 20:19:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1069, 406, 2, '', '2022-04-04 21:15:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1070, 406, 3, '', '2022-04-04 21:15:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1071, 354, 1, '', '2022-04-05 08:36:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1072, 407, 2, '', '2022-04-05 09:33:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1073, 407, 3, '', '2022-04-05 09:33:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1074, 355, 1, '', '2022-04-05 10:20:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1075, 408, 2, '', '2022-04-05 10:21:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1076, 408, 3, '', '2022-04-05 10:21:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1077, 409, 2, '', '2022-04-05 10:31:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1078, 409, 3, '', '2022-04-05 10:31:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1079, 356, 1, '', '2022-04-05 10:43:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1080, 410, 2, '', '2022-04-05 10:52:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1081, 410, 3, '', '2022-04-05 10:52:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1082, 411, 2, '', '2022-04-05 11:01:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1083, 411, 3, '', '2022-04-05 11:01:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1084, 412, 2, '', '2022-04-05 11:03:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1085, 412, 3, '', '2022-04-05 11:03:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1086, 413, 2, '', '2022-04-05 11:05:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1087, 413, 3, '', '2022-04-05 11:05:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1088, 414, 2, '', '2022-04-05 11:25:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1089, 414, 3, 'X-Ray', '2022-04-05 11:25:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1090, 357, 1, '', '2022-04-05 11:33:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1091, 358, 1, '', '2022-04-05 11:41:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1092, 415, 2, '', '2022-04-05 11:46:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1093, 415, 3, '', '2022-04-05 11:46:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1094, 359, 1, '', '2022-04-05 11:48:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1095, 360, 1, '', '2022-04-05 13:05:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1096, 416, 2, '', '2022-04-05 16:11:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1097, 416, 3, 'ECG', '2022-04-05 16:11:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1098, 417, 2, '', '2022-04-05 16:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1099, 417, 3, 'X-Ray', '2022-04-05 16:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1100, 418, 2, '', '2022-04-05 18:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1101, 418, 3, 'ECG', '2022-04-05 18:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1102, 361, 1, '', '2022-04-05 18:21:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1103, 419, 2, '', '2022-04-05 19:02:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1104, 419, 3, 'USG', '2022-04-05 19:02:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1105, 420, 2, '', '2022-04-05 19:47:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1106, 420, 3, 'X-Ray', '2022-04-05 19:47:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1107, 421, 2, '', '2022-04-05 20:28:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1108, 421, 3, 'USG', '2022-04-05 20:28:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1109, 422, 2, '', '2022-04-05 21:29:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1110, 422, 3, '', '2022-04-05 21:29:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1111, 423, 2, '', '2022-04-06 09:32:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1112, 423, 3, '', '2022-04-06 09:32:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1113, 362, 1, '', '2022-04-06 10:01:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1114, 424, 2, '', '2022-04-06 10:02:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1115, 424, 3, '', '2022-04-06 10:02:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1116, 425, 2, '', '2022-04-06 10:26:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1117, 425, 3, '', '2022-04-06 10:26:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1118, 363, 1, '', '2022-04-06 10:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1119, 426, 2, '', '2022-04-06 10:58:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1120, 426, 3, '', '2022-04-06 10:58:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1121, 427, 2, '', '2022-04-06 11:39:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1122, 427, 3, '', '2022-04-06 11:39:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1123, 428, 2, '', '2022-04-06 11:46:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1124, 428, 3, '', '2022-04-06 11:46:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1125, 429, 2, '', '2022-04-06 12:08:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1126, 429, 3, '', '2022-04-06 12:08:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1127, 430, 2, '', '2022-04-06 12:12:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1128, 430, 3, '', '2022-04-06 12:12:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1129, 431, 2, '', '2022-04-06 20:30:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1130, 431, 3, '', '2022-04-06 20:30:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1131, 364, 1, '', '2022-04-06 20:40:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1132, 432, 2, '', '2022-04-06 20:44:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1133, 432, 3, 'ECG', '2022-04-06 20:44:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1134, 433, 2, '', '2022-04-06 21:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1135, 433, 3, '', '2022-04-06 21:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1136, 365, 1, '', '2022-04-07 09:37:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1137, 366, 1, '', '2022-04-07 09:43:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1138, 434, 2, '', '2022-04-07 09:44:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1139, 434, 3, '', '2022-04-07 09:44:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1140, 435, 2, '', '2022-04-07 10:04:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1141, 435, 3, '', '2022-04-07 10:04:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1142, 367, 1, '', '2022-04-07 10:23:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1143, 436, 2, '', '2022-04-07 10:28:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1144, 436, 3, '', '2022-04-07 10:28:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1145, 368, 1, '', '2022-04-07 10:52:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1146, 437, 2, '', '2022-04-07 10:52:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1147, 437, 3, '', '2022-04-07 10:52:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1148, 369, 1, '', '2022-04-07 11:10:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1149, 370, 1, '', '2022-04-07 11:23:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1150, 438, 2, '', '2022-04-07 11:25:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1151, 438, 3, '', '2022-04-07 11:25:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1152, 371, 1, '', '2022-04-07 11:43:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1153, 439, 2, '', '2022-04-07 11:45:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1154, 439, 3, '', '2022-04-07 11:45:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1155, 440, 2, '', '2022-04-07 11:56:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1156, 440, 3, '', '2022-04-07 11:56:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1157, 441, 2, '', '2022-04-07 13:57:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1158, 441, 3, '', '2022-04-07 13:57:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1159, 372, 1, '', '2022-04-07 15:18:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1160, 442, 2, '', '2022-04-07 15:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1161, 442, 3, '', '2022-04-07 15:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1162, 443, 2, '', '2022-04-07 15:28:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1163, 443, 3, 'X-Ray', '2022-04-07 15:28:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1164, 444, 2, '', '2022-04-07 15:36:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1165, 444, 3, 'USG', '2022-04-07 15:36:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1166, 373, 1, '', '2022-04-07 16:37:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1167, 445, 2, '', '2022-04-07 16:39:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1168, 445, 3, '', '2022-04-07 16:39:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1169, 374, 1, '', '2022-04-07 17:34:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1170, 446, 2, '', '2022-04-07 17:35:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1171, 446, 3, '', '2022-04-07 17:35:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1172, 375, 1, '', '2022-04-07 17:53:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1173, 447, 2, '', '2022-04-07 17:56:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1174, 447, 3, '', '2022-04-07 17:56:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1175, 376, 1, '', '2022-04-07 18:06:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1176, 377, 1, '', '2022-04-07 18:07:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1177, 448, 2, '', '2022-04-07 18:08:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1178, 448, 3, '', '2022-04-07 18:08:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1179, 378, 1, '', '2022-04-07 18:14:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1180, 449, 2, '', '2022-04-07 18:15:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1181, 449, 3, '', '2022-04-07 18:15:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1182, 0, 1, '', '2022-04-07 21:00:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1183, 450, 2, '', '2022-04-07 18:55:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1184, 450, 3, '', '2022-04-07 18:55:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1185, 380, 1, '', '2022-04-07 18:58:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1186, 451, 2, '', '2022-04-07 18:59:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1187, 451, 3, '', '2022-04-07 18:59:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1188, 381, 1, '', '2022-04-07 19:02:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1189, 452, 2, '', '2022-04-07 19:03:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1190, 452, 3, '', '2022-04-07 19:03:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1191, 453, 2, '', '2022-04-07 19:14:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1192, 453, 3, '', '2022-04-07 19:14:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1193, 382, 1, '', '2022-04-07 19:16:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1194, 383, 1, '', '2022-04-07 19:32:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1195, 454, 2, '', '2022-04-07 19:34: